--
-- PostgreSQL database dump
--

\restrict F5kYW5KDDYsfqHDahFWzOL5GA1Mvig9EZmMan7ddFxNzmgOKQFybODyNRWRlYI8

-- Dumped from database version 16.10 (Ubuntu 16.10-1.pgdg22.04+1)
-- Dumped by pg_dump version 16.10 (Ubuntu 16.10-1.pgdg22.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: coretlx; Type: SCHEMA; Schema: -; Owner: coretlx
--

CREATE SCHEMA coretlx;


ALTER SCHEMA coretlx OWNER TO coretlx;

--
-- Name: clientcat_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.clientcat_list AS (
	clientcat_list bigint[]
);


ALTER TYPE coretlx.clientcat_list OWNER TO coretlx;

--
-- Name: index_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.index_list AS (
	index_list bigint[]
);


ALTER TYPE coretlx.index_list OWNER TO coretlx;

--
-- Name: release_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.release_list AS (
	release_list timestamp(0) without time zone[]
);


ALTER TYPE coretlx.release_list OWNER TO coretlx;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: acc_advice_timeout; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_advice_timeout (
    advice_timeout_id bigint NOT NULL,
    advice_id bigint,
    notified timestamp(0) without time zone,
    changed timestamp(0) without time zone
);


ALTER TABLE coretlx.acc_advice_timeout OWNER TO coretlx;

--
-- Name: COLUMN acc_advice_timeout.advice_timeout_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.advice_timeout_id IS 'Id события';


--
-- Name: COLUMN acc_advice_timeout.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.advice_id IS 'ID уведомления';


--
-- Name: COLUMN acc_advice_timeout.notified; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.notified IS 'Когда было отправлено извещение';


--
-- Name: COLUMN acc_advice_timeout.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.changed IS 'Когда было изменение';


--
-- Name: acc_advice_timeout_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_advice_timeout_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.acc_advice_timeout_seq OWNER TO coretlx;

--
-- Name: acc_change; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_change (
    change_id integer NOT NULL,
    level_id integer NOT NULL,
    key_table character varying(100),
    key_value integer,
    ref_table character varying(100),
    ref_value integer,
    terminal integer,
    created timestamp(0) without time zone
);


ALTER TABLE coretlx.acc_change OWNER TO coretlx;

--
-- Name: acc_change_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_change_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.acc_change_seq OWNER TO coretlx;

--
-- Name: acc_changes; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_changes (
    change_id bigint NOT NULL,
    op_code character(1) NOT NULL,
    key_table character varying(400),
    ref_table character varying(400),
    key_name character varying(400),
    ref_name character varying(400),
    key_id bigint,
    ref_id bigint,
    changed timestamp(0) without time zone,
    terminal character varying(400),
    session_id character varying(96)
);


ALTER TABLE coretlx.acc_changes OWNER TO coretlx;

--
-- Name: acc_error; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_error (
    error_id integer NOT NULL,
    code_id integer NOT NULL,
    error_msg character varying(200),
    terminal character varying(800),
    created timestamp(0) without time zone,
    call_from character varying(1000)
);


ALTER TABLE coretlx.acc_error OWNER TO coretlx;

--
-- Name: acc_error_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_error_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.acc_error_seq OWNER TO coretlx;

--
-- Name: acc_errors; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_errors (
    error_id integer NOT NULL,
    code integer,
    msg character varying(200),
    terminal character varying(200),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL
);


ALTER TABLE coretlx.acc_errors OWNER TO coretlx;

--
-- Name: acc_errors_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_errors_seq
    START WITH 7374
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.acc_errors_seq OWNER TO coretlx;

--
-- Name: acc_level; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_level (
    level_id integer NOT NULL,
    level_name character varying(100),
    object_name character varying(100)
);


ALTER TABLE coretlx.acc_level OWNER TO coretlx;

--
-- Name: acc_module_login; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_module_login (
    module_login_id bigint NOT NULL,
    module_id bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    v_major bigint,
    v_minor bigint,
    v_release bigint,
    v_build bigint,
    terminal character varying(80),
    u_session_id character varying(24)
);


ALTER TABLE coretlx.acc_module_login OWNER TO coretlx;

--
-- Name: acc_module_login_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_module_login_seq
    START WITH 44709
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.acc_module_login_seq OWNER TO coretlx;

--
-- Name: acc_operator; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_operator (
    operator_id bigint NOT NULL,
    name character varying(200),
    created timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    external_id bigint,
    login character varying(50),
    password character varying(50),
    place_id bigint,
    place_num character varying(20),
    parent_id bigint,
    user_role smallint NOT NULL
);


ALTER TABLE coretlx.acc_operator OWNER TO coretlx;

--
-- Name: acc_operator_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_operator_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.acc_operator_seq OWNER TO coretlx;

--
-- Name: acc_operator_seq; Type: SEQUENCE OWNED BY; Schema: coretlx; Owner: coretlx
--

ALTER SEQUENCE coretlx.acc_operator_seq OWNED BY coretlx.acc_operator.operator_id;


--
-- Name: acc_user_login; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_user_login (
    user_login_id bigint NOT NULL,
    session_id bigint,
    operator_id bigint,
    module_id bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    terminal character varying(80),
    extension bigint,
    u_session_id character varying(24),
    module_login_id bigint,
    place_id bigint,
    place_num character varying(20),
    user_role smallint
);


ALTER TABLE coretlx.acc_user_login OWNER TO coretlx;

--
-- Name: acc_user_login_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_user_login_seq
    START WITH 43552
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.acc_user_login_seq OWNER TO coretlx;

--
-- Name: bill_abocharge_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_abocharge_seq
    START WITH 483332
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_abocharge_seq OWNER TO coretlx;

--
-- Name: bill_abocharges; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_abocharges (
    abocharge_id bigint NOT NULL,
    cost numeric(15,2) DEFAULT 0 NOT NULL,
    extracost numeric(15,2) DEFAULT 0 NOT NULL,
    ndscost numeric(15,2) DEFAULT 0 NOT NULL,
    note character varying(200),
    message_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    operator_id bigint,
    terminal character varying(80) NOT NULL,
    charge_state_id smallint NOT NULL,
    our_cost numeric(15,2) DEFAULT 0 NOT NULL,
    tarif_id bigint,
    account_no numeric(20,0),
    bill_contract numeric(20,0),
    our_nds numeric(15,2) DEFAULT 0 NOT NULL,
    call_id bigint,
    chgtype_id smallint
);


ALTER TABLE coretlx.bill_abocharges OWNER TO coretlx;

--
-- Name: COLUMN bill_abocharges.abocharge_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.abocharge_id IS 'Идентификатор начисления';


--
-- Name: COLUMN bill_abocharges.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.cost IS 'Сумма по тарифу';


--
-- Name: COLUMN bill_abocharges.extracost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.extracost IS 'Сумма сбора';


--
-- Name: COLUMN bill_abocharges.ndscost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.ndscost IS 'НДС';


--
-- Name: COLUMN bill_abocharges.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.note IS 'Примечание';


--
-- Name: COLUMN bill_abocharges.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN bill_abocharges.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_abocharges.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.operator_id IS 'Идентификатор оператора создавшего начисление';


--
-- Name: COLUMN bill_abocharges.terminal; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.terminal IS 'Терминал пользователя';


--
-- Name: COLUMN bill_abocharges.charge_state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.charge_state_id IS 'Идентификатор состояния начисления';


--
-- Name: COLUMN bill_abocharges.our_cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.our_cost IS 'Сумма в пользу оператора связи';


--
-- Name: COLUMN bill_abocharges.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_abocharges.account_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.account_no IS 'Идентификатор абонента';


--
-- Name: COLUMN bill_abocharges.bill_contract; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.bill_contract IS 'Идентификатор договора';


--
-- Name: COLUMN bill_abocharges.our_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.our_nds IS 'НДС на сумму в пользу оператора связи';


--
-- Name: COLUMN bill_abocharges.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN bill_abocharges.chgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.chgtype_id IS 'Тип начисления';


--
-- Name: bill_charge_detail; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_charge_detail (
    message_id bigint,
    abocharge_id bigint,
    f_substract smallint DEFAULT 0 NOT NULL,
    cost numeric(15,2),
    billing_code bigint,
    price_id bigint,
    operator_id bigint,
    f_canceled smallint DEFAULT 0
);


ALTER TABLE coretlx.bill_charge_detail OWNER TO coretlx;

--
-- Name: COLUMN bill_charge_detail.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN bill_charge_detail.abocharge_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.abocharge_id IS 'Идентификатор начисления';


--
-- Name: COLUMN bill_charge_detail.f_substract; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.f_substract IS 'Признак вычитания';


--
-- Name: COLUMN bill_charge_detail.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.cost IS 'Сумма по тарифу';


--
-- Name: COLUMN bill_charge_detail.billing_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.billing_code IS 'Идентификатор начисления по классификатору';


--
-- Name: COLUMN bill_charge_detail.price_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.price_id IS 'Идентификатор цены в системе';


--
-- Name: COLUMN bill_charge_detail.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.operator_id IS 'Идентификатор оператора, внесшего начисление';


--
-- Name: bill_discount; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_discount (
    discount_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    discount numeric(5,2) DEFAULT 0 NOT NULL,
    period_id bigint,
    tarif_id bigint,
    clientcategory_id smallint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    note character varying(200),
    operator_id bigint,
    oper_id bigint
);


ALTER TABLE coretlx.bill_discount OWNER TO coretlx;

--
-- Name: bill_discount_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_discount_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_discount_seq OWNER TO coretlx;

--
-- Name: bill_pay_phone; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_pay_phone (
    pay_phone_id bigint NOT NULL,
    aon_phone character varying(20) NOT NULL,
    abonent_phone character varying(20) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    note character varying(200),
    operator_id bigint
);


ALTER TABLE coretlx.bill_pay_phone OWNER TO coretlx;

--
-- Name: COLUMN bill_pay_phone.pay_phone_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.pay_phone_id IS 'Идентификатор соответствия телефонов';


--
-- Name: COLUMN bill_pay_phone.aon_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.aon_phone IS 'Телефон АОН';


--
-- Name: COLUMN bill_pay_phone.abonent_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.abonent_phone IS 'Телефон оплаты';


--
-- Name: COLUMN bill_pay_phone.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_pay_phone.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_pay_phone.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_pay_phone.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.note IS 'Примечание';


--
-- Name: COLUMN bill_pay_phone.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.operator_id IS 'Идентификатор оператора сделавшего последнюю модификацию';


--
-- Name: bill_pay_phone_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_pay_phone_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_pay_phone_seq OWNER TO coretlx;

--
-- Name: bill_price; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_price (
    price_id bigint NOT NULL,
    const numeric(10,2) DEFAULT 0 NOT NULL,
    mult numeric(10,2) DEFAULT 0 NOT NULL,
    extra smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    min_units integer DEFAULT 0 NOT NULL,
    max_units integer DEFAULT 999999 NOT NULL,
    svckind_id bigint,
    period_id bigint,
    clientcategory_id smallint,
    min_msg integer DEFAULT 1 NOT NULL,
    max_msg integer DEFAULT 1 NOT NULL,
    service_id bigint,
    tarif_id bigint,
    changed timestamp(0) without time zone,
    note character varying(100),
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    charge smallint DEFAULT 0 NOT NULL,
    by_release smallint DEFAULT 0 NOT NULL,
    operator_id bigint,
    region_id bigint,
    receive_id bigint,
    billing_code bigint,
    dest_location_id bigint,
    is_exclude_dest smallint DEFAULT 0,
    CONSTRAINT bill_price_chk1 CHECK ((min_units <= max_units))
);


ALTER TABLE coretlx.bill_price OWNER TO coretlx;

--
-- Name: COLUMN bill_price.price_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.price_id IS 'Идентификатор цены';


--
-- Name: COLUMN bill_price.const; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.const IS 'Константа';


--
-- Name: COLUMN bill_price.mult; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.mult IS 'Множитель';


--
-- Name: COLUMN bill_price.extra; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.extra IS 'Флаг сбора (=1)';


--
-- Name: COLUMN bill_price.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_price.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_price.min_units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.min_units IS 'Минимальное число тарификационных единиц';


--
-- Name: COLUMN bill_price.max_units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.max_units IS 'Максимальное число тарификационных единиц';


--
-- Name: COLUMN bill_price.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.svckind_id IS 'Идентификатор вида';


--
-- Name: COLUMN bill_price.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.period_id IS 'Идентификатор периода';


--
-- Name: COLUMN bill_price.clientcategory_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.clientcategory_id IS 'Идентификатор категории абонента';


--
-- Name: COLUMN bill_price.min_msg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.min_msg IS 'Минимальное число сообщений';


--
-- Name: COLUMN bill_price.max_msg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.max_msg IS 'Максимальное число сообщений';


--
-- Name: COLUMN bill_price.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN bill_price.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_price.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_price.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.note IS 'Примечание';


--
-- Name: COLUMN bill_price.opened; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.opened IS 'Дата/время начала действия';


--
-- Name: COLUMN bill_price.charge; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.charge IS 'Признак начисения без учета кол-ва сообщений';


--
-- Name: COLUMN bill_price.by_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.by_release IS 'Проводить расчет по дате выхода объявления (если = 0 расчет производится по дате подачи)';


--
-- Name: COLUMN bill_price.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.operator_id IS 'Идентификатор оператора в последний раз изменившего цену';


--
-- Name: COLUMN bill_price.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.region_id IS 'Идентификатор региона откуда поступил вызов';


--
-- Name: COLUMN bill_price.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.receive_id IS 'Идентификатор места приема (телефон/почта)';


--
-- Name: COLUMN bill_price.billing_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.billing_code IS 'Идентификатор начисления в тарификаторе';


--
-- Name: COLUMN bill_price.dest_location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.dest_location_id IS 'Идентификатор региона куда направлено сообщение';


--
-- Name: COLUMN bill_price.is_exclude_dest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.is_exclude_dest IS 'Если = 1, то применять тариф для сообщений, отправленных за пределы указанного региона';


--
-- Name: bill_price_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_price_seq
    START WITH 7468
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_price_seq OWNER TO coretlx;

--
-- Name: bill_service; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_service (
    service_id bigint NOT NULL,
    name character varying(100),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    tarif_id bigint NOT NULL,
    changed timestamp(0) without time zone,
    start_label character varying(100),
    end_label character varying(100),
    operator_id bigint
);


ALTER TABLE coretlx.bill_service OWNER TO coretlx;

--
-- Name: COLUMN bill_service.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN bill_service.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.name IS 'Наименование услуги';


--
-- Name: COLUMN bill_service.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_service.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_service.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_service.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_service.start_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.start_label IS 'Начальная отметка в сообщении';


--
-- Name: COLUMN bill_service.end_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.end_label IS 'Конечная отметка в сообщении';


--
-- Name: COLUMN bill_service.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.operator_id IS 'Идентификатор оператора в последний раз изменившего услугу';


--
-- Name: bill_service_kind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_service_kind (
    svckind_id bigint NOT NULL,
    service_id bigint NOT NULL
);


ALTER TABLE coretlx.bill_service_kind OWNER TO coretlx;

--
-- Name: COLUMN bill_service_kind.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service_kind.svckind_id IS 'Идентификатор вида услуги';


--
-- Name: COLUMN bill_service_kind.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service_kind.service_id IS 'Идентификатор услуги';


--
-- Name: bill_service_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_service_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_service_seq OWNER TO coretlx;

--
-- Name: bill_service_seq; Type: SEQUENCE OWNED BY; Schema: coretlx; Owner: coretlx
--

ALTER SEQUENCE coretlx.bill_service_seq OWNED BY coretlx.bill_service.service_id;


--
-- Name: bill_svckind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_svckind (
    svckind_id bigint NOT NULL,
    tarif_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    p1 character varying(1) DEFAULT ' '::character varying NOT NULL,
    p2 character varying(1) DEFAULT ' '::character varying NOT NULL,
    p3 character varying(1) DEFAULT ' '::character varying NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    start_label character varying(50),
    end_label character varying(50),
    f_serve smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    operator_id bigint,
    f_notification smallint DEFAULT 0 NOT NULL,
    f_printcopy smallint DEFAULT 0 NOT NULL,
    f_needrequest smallint DEFAULT 0 NOT NULL,
    f_needtg smallint DEFAULT 0 NOT NULL,
    tlgkind_id bigint
);


ALTER TABLE coretlx.bill_svckind OWNER TO coretlx;

--
-- Name: COLUMN bill_svckind.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.svckind_id IS 'Идентификатор вида услуги';


--
-- Name: COLUMN bill_svckind.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_svckind.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.name IS 'Наименование вида услуги';


--
-- Name: COLUMN bill_svckind.required; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.required IS 'Требуется наличие (категория)';


--
-- Name: COLUMN bill_svckind.p1; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p1 IS 'Первая буква категории приоритета';


--
-- Name: COLUMN bill_svckind.p2; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p2 IS 'Вторая буква категории приоритета';


--
-- Name: COLUMN bill_svckind.p3; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p3 IS 'Третья буква категории приоритета';


--
-- Name: COLUMN bill_svckind.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_svckind.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_svckind.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_svckind.start_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.start_label IS 'Начальная отметка в сообщении';


--
-- Name: COLUMN bill_svckind.end_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.end_label IS 'Конечная отметка в сообщении';


--
-- Name: COLUMN bill_svckind.f_serve; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_serve IS 'Признак необходимости указания времени доставки';


--
-- Name: COLUMN bill_svckind.f_second; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_second IS 'Признак использования во втором и следующем сообщении (для многословных телеграмм)';


--
-- Name: COLUMN bill_svckind.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.operator_id IS 'Идентификатор оператора в последний раз изменившего вид услуги';


--
-- Name: COLUMN bill_svckind.f_notification; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_notification IS 'Признак необходимости уведомления';


--
-- Name: COLUMN bill_svckind.f_printcopy; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_printcopy IS 'Признак необходимости печати копии';


--
-- Name: COLUMN bill_svckind.f_needrequest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_needrequest IS 'Признак необходимости дополнительного запроса (уведомления)';


--
-- Name: COLUMN bill_svckind.f_needtg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_needtg IS 'Требовать наличие телеграфного аппарата';


--
-- Name: bill_svckind_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_svckind_seq
    START WITH 6375
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_svckind_seq OWNER TO coretlx;

--
-- Name: bill_tarif; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_tarif (
    tarif_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    profit numeric(5,2) DEFAULT 0 NOT NULL,
    nds numeric(5,2) DEFAULT 0 NOT NULL,
    closed timestamp(0) without time zone,
    unit_id bigint NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    def_service_id bigint,
    msgtype_id smallint NOT NULL,
    operator_id bigint,
    external_id bigint,
    subtract_nds smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.bill_tarif OWNER TO coretlx;

--
-- Name: COLUMN bill_tarif.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_tarif.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.name IS 'Наименование тарифа';


--
-- Name: COLUMN bill_tarif.profit; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.profit IS '% в пользу оператора связи';


--
-- Name: COLUMN bill_tarif.nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.nds IS 'НДС';


--
-- Name: COLUMN bill_tarif.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_tarif.unit_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.unit_id IS 'Идентификатор единицы тарификации';


--
-- Name: COLUMN bill_tarif.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_tarif.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_tarif.opened; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.opened IS 'Дата/время начала действия';


--
-- Name: COLUMN bill_tarif.def_service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.def_service_id IS 'Идентификатор услуги по умолчанию';


--
-- Name: COLUMN bill_tarif.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN bill_tarif.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.operator_id IS 'Идентификатор оператора в последний раз изменившего тариф';


--
-- Name: COLUMN bill_tarif.external_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.external_id IS 'Внешний идентификатор';


--
-- Name: COLUMN bill_tarif.subtract_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.subtract_nds IS 'Признак вычитания НДС из суммы начисленной по тарифу (1 - вычитается, 0 - добавляется)';


--
-- Name: bill_tarif_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_tarif_seq
    START WITH 1021
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_tarif_seq OWNER TO coretlx;

--
-- Name: bill_tlgkind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_tlgkind (
    tlgkind_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    p1 character varying(1) NOT NULL,
    p2 character varying(1) NOT NULL,
    p3 character varying(1) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    operator_id bigint,
    start_label character varying(50),
    end_label character varying(50),
    f_serve smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    f_notification smallint DEFAULT 0 NOT NULL,
    f_printcopy smallint DEFAULT 0 NOT NULL,
    f_needrequest smallint DEFAULT 0 NOT NULL,
    f_needtg smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.bill_tlgkind OWNER TO coretlx;

--
-- Name: bill_tlgkind_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_tlgkind_seq
    START WITH 41
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.bill_tlgkind_seq OWNER TO coretlx;

--
-- Name: err_sys_message_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.err_sys_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.err_sys_message_seq OWNER TO coretlx;

--
-- Name: err_sys_messages; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.err_sys_messages (
    sys_message_id bigint NOT NULL,
    sys_message character varying(200),
    terminal character varying(200)
);


ALTER TABLE coretlx.err_sys_messages OWNER TO coretlx;

--
-- Name: flyway_schema_history; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.flyway_schema_history (
    installed_rank integer NOT NULL,
    version character varying(50),
    description character varying(200) NOT NULL,
    type character varying(20) NOT NULL,
    script character varying(1000) NOT NULL,
    checksum integer,
    installed_by character varying(100) NOT NULL,
    installed_on timestamp without time zone DEFAULT now() NOT NULL,
    execution_time integer NOT NULL,
    success boolean NOT NULL
);


ALTER TABLE coretlx.flyway_schema_history OWNER TO coretlx;

--
-- Name: imp_tlindex_russia; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.imp_tlindex_russia (
    province_name character varying(100),
    main_town character varying(60),
    time_diff character varying(10),
    town_name character varying(100),
    note character varying(100),
    region_name character varying(100),
    attr character varying(2),
    tlindex character varying(6),
    has_telex character varying(10),
    work_days character varying(100),
    holydays character varying(60),
    li_number character varying(100),
    chaned character varying(100),
    country_id bigint,
    province_id bigint,
    town_id bigint
);


ALTER TABLE coretlx.imp_tlindex_russia OWNER TO coretlx;

--
-- Name: message_temp; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.message_temp (
    created timestamp(0) without time zone,
    pay_phone character(11)
);


ALTER TABLE coretlx.message_temp OWNER TO coretlx;

--
-- Name: msg_address; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_address (
    address_id bigint NOT NULL,
    template_id bigint NOT NULL,
    email character varying(300) NOT NULL,
    name character varying(50) NOT NULL,
    max_count integer NOT NULL,
    body_text text,
    note character varying(300),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    encoding_id smallint DEFAULT 1 NOT NULL,
    max_char smallint DEFAULT 100 NOT NULL,
    attachment smallint DEFAULT 0 NOT NULL,
    cr_mode smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    ccemail character varying(300),
    subject character varying(100) DEFAULT '[Служба заказов]'::character varying,
    extension character varying(20) DEFAULT 'etl'::character varying,
    CONSTRAINT msg_address_chk1 CHECK ((max_count < 2000))
);


ALTER TABLE coretlx.msg_address OWNER TO coretlx;

--
-- Name: COLUMN msg_address.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.address_id IS 'Идентификатор адреса передачи сообщений';


--
-- Name: COLUMN msg_address.template_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.template_id IS 'Идентификатор шаблона форматирования';


--
-- Name: COLUMN msg_address.email; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.email IS 'Адрес электронной почты';


--
-- Name: COLUMN msg_address.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.name IS 'Наименование адреса доставки';


--
-- Name: COLUMN msg_address.max_count; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.max_count IS 'Максимальное число сообщений в пакете';


--
-- Name: COLUMN msg_address.body_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.body_text IS 'Информационный текст в сообщении';


--
-- Name: COLUMN msg_address.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.note IS 'Примечание';


--
-- Name: COLUMN msg_address.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_address.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_address.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_address.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.operator_id IS 'Идентификатор оператора в последний раз изменившего адрес';


--
-- Name: COLUMN msg_address.encoding_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.encoding_id IS 'Идентификатор кодировки письма';


--
-- Name: COLUMN msg_address.max_char; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.max_char IS 'Максимальное число символов в строке';


--
-- Name: COLUMN msg_address.attachment; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.attachment IS 'Передавать пакет как вложение (если 1) или в теле письма (если 0)';


--
-- Name: COLUMN msg_address.cr_mode; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.cr_mode IS 'Режим CR/LF';


--
-- Name: COLUMN msg_address.f_second; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.f_second IS 'Вторичный адрес';


--
-- Name: COLUMN msg_address.ccemail; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.ccemail IS 'Адрес электронной почты для отправки копии';


--
-- Name: msg_address_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_address_seq
    START WITH 965
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_address_seq OWNER TO coretlx;

--
-- Name: msg_advert; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_advert (
    message_id bigint NOT NULL,
    dest_rubric_id bigint NOT NULL,
    release coretlx.release_list
);


ALTER TABLE coretlx.msg_advert OWNER TO coretlx;

--
-- Name: COLUMN msg_advert.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_advert.dest_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.dest_rubric_id IS 'Идентификатор рубрики';


--
-- Name: COLUMN msg_advert.release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.release IS 'Даты выхода объявления';


--
-- Name: msg_advice; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_advice (
    advice_id bigint NOT NULL,
    message_id bigint,
    advice_state_id bigint NOT NULL,
    note character varying(200),
    f_printcopy smallint,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    is_notifice smallint DEFAULT 0 NOT NULL,
    is_inquire smallint DEFAULT 0 NOT NULL,
    copied timestamp(0) without time zone,
    notified timestamp(0) without time zone
);


ALTER TABLE coretlx.msg_advice OWNER TO coretlx;

--
-- Name: COLUMN msg_advice.is_notifice; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.is_notifice IS 'Уведомление';


--
-- Name: COLUMN msg_advice.is_inquire; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.is_inquire IS 'Запрос';


--
-- Name: COLUMN msg_advice.copied; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.copied IS 'Копия отправлена';


--
-- Name: COLUMN msg_advice.notified; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.notified IS 'Отправлено уведомление';


--
-- Name: msg_advice_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_advice_seq
    START WITH 384194
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_advice_seq OWNER TO coretlx;

--
-- Name: msg_call; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_call (
    call_id bigint NOT NULL,
    aon_phone character varying(20),
    call_phone character varying(20),
    reverse_call smallint,
    abonent_id character varying(20),
    contract_id bigint,
    contract_no character varying(20),
    fgplace_id bigint,
    fgabonent_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    clientcat coretlx.clientcat_list,
    inn character varying(20),
    kpp character varying(20),
    name character varying(300),
    address character varying(350),
    j_address character varying(350),
    pay_phone character varying(20),
    phone_town character varying(100),
    charge_nds smallint DEFAULT 0 NOT NULL,
    fgplace_num character varying(20),
    cdr_call_id bigint,
    key_word character varying(100),
    user_login_id bigint,
    operator_id bigint,
    limit_sum numeric(15,2),
    region_id bigint,
    receive_id bigint,
    f_auto_header smallint DEFAULT 1 NOT NULL,
    completed timestamp(0) without time zone,
    f_avance smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_call OWNER TO coretlx;

--
-- Name: COLUMN msg_call.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN msg_call.aon_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.aon_phone IS 'Телефон АОН';


--
-- Name: COLUMN msg_call.call_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.call_phone IS 'Телефон приема';


--
-- Name: COLUMN msg_call.reverse_call; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.reverse_call IS 'Признак обратного вызова';


--
-- Name: COLUMN msg_call.abonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.abonent_id IS 'Идентификатор абонента в биллинговой системе';


--
-- Name: COLUMN msg_call.contract_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.contract_id IS 'Идентификатор договора в биллинговой системе';


--
-- Name: COLUMN msg_call.contract_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.contract_no IS 'Номер договора';


--
-- Name: COLUMN msg_call.fgplace_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgplace_id IS 'Идентификатор места оплаты';


--
-- Name: COLUMN msg_call.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgabonent_id IS 'Идентификатор типа абонента ЦУС';


--
-- Name: COLUMN msg_call.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_call.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_call.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_call.clientcat; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.clientcat IS 'Список идентификаторов категорий абонента';


--
-- Name: COLUMN msg_call.inn; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.inn IS 'ИНН';


--
-- Name: COLUMN msg_call.kpp; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.kpp IS 'КПП';


--
-- Name: COLUMN msg_call.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.name IS 'Наименование абонента';


--
-- Name: COLUMN msg_call.address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.address IS 'Адрес';


--
-- Name: COLUMN msg_call.j_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.j_address IS 'Юридический адрес';


--
-- Name: COLUMN msg_call.pay_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.pay_phone IS 'Телефон оплаты';


--
-- Name: COLUMN msg_call.phone_town; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.phone_town IS 'Город установки телефона';


--
-- Name: COLUMN msg_call.charge_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.charge_nds IS 'Признак начисления НДС';


--
-- Name: COLUMN msg_call.fgplace_num; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgplace_num IS 'Номер места оплаты';


--
-- Name: COLUMN msg_call.cdr_call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.cdr_call_id IS 'Идентификатор вызова в CDR';


--
-- Name: COLUMN msg_call.key_word; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.key_word IS 'Ключевой слово';


--
-- Name: COLUMN msg_call.user_login_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.user_login_id IS 'Идентификатор сессии оператора, принявшего вызов';


--
-- Name: COLUMN msg_call.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.operator_id IS 'Идентификатор оператора в последний раз изменившего вызов';


--
-- Name: COLUMN msg_call.limit_sum; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.limit_sum IS 'Лимит суммы приема';


--
-- Name: COLUMN msg_call.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.region_id IS 'Регион из которого поступил вызов';


--
-- Name: COLUMN msg_call.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.receive_id IS 'Место приема телеграммы';


--
-- Name: msg_call_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_call_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_call_seq OWNER TO coretlx;

--
-- Name: msg_call_seq; Type: SEQUENCE OWNED BY; Schema: coretlx; Owner: coretlx
--

ALTER SEQUENCE coretlx.msg_call_seq OWNED BY coretlx.msg_call.call_id;


--
-- Name: msg_chanell_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_chanell_state (
    chanell_id integer NOT NULL,
    state_id smallint NOT NULL,
    changed timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    sector character varying(10)
);


ALTER TABLE coretlx.msg_chanell_state OWNER TO coretlx;

--
-- Name: COLUMN msg_chanell_state.chanell_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chanell_state.chanell_id IS 'Телеграфный канал';


--
-- Name: COLUMN msg_chanell_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chanell_state.state_id IS 'Идентификатор текущего состояния';


--
-- Name: msg_chunk; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_chunk (
    chunk_id bigint NOT NULL,
    message_id bigint,
    text character varying(4000),
    full_text character varying(4000),
    header character varying(400),
    serial_no bigint NOT NULL,
    units bigint,
    words bigint,
    chars bigint,
    sended timestamp(0) without time zone,
    tlg_chanell character varying(6),
    sector character varying(10),
    chanell_no bigint,
    full_serial character varying(50)
);


ALTER TABLE coretlx.msg_chunk OWNER TO coretlx;

--
-- Name: COLUMN msg_chunk.chunk_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chunk_id IS 'Идентификатор фрагмента сообщения';


--
-- Name: COLUMN msg_chunk.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_chunk.text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.text IS 'Текст фрагмента';


--
-- Name: COLUMN msg_chunk.full_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.full_text IS 'Полный форматированные текст фрагмента';


--
-- Name: COLUMN msg_chunk.header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.header IS 'Заголовок';


--
-- Name: COLUMN msg_chunk.serial_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.serial_no IS 'Кассовый номер';


--
-- Name: COLUMN msg_chunk.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.units IS 'Количество единиц тарификации';


--
-- Name: COLUMN msg_chunk.words; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.words IS 'Количество слов';


--
-- Name: COLUMN msg_chunk.chars; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chars IS 'Количество символов';


--
-- Name: COLUMN msg_chunk.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.sended IS 'Дата/время отправки фрагмента';


--
-- Name: COLUMN msg_chunk.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.tlg_chanell IS 'Телеграфный канал по которому передан фрагмент';


--
-- Name: COLUMN msg_chunk.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.sector IS 'Сектор телеграфного канала';


--
-- Name: COLUMN msg_chunk.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_chunk.full_serial; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.full_serial IS 'Полный кассовый номер сообщения (с каналом и сектором)';


--
-- Name: msg_chunk_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_chunk_seq
    START WITH 527174
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_chunk_seq OWNER TO coretlx;

--
-- Name: msg_dest; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_dest (
    dest_id bigint NOT NULL,
    name character varying(100) NOT NULL,
    info character varying(4000),
    nds numeric(10,2) DEFAULT 0 NOT NULL,
    bill_name character varying(100),
    j_address character varying(100),
    inn character varying(50),
    contr character varying(50),
    closed timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    short_name character varying(100),
    tarif_id bigint,
    release_count smallint DEFAULT 10 NOT NULL,
    operator_id bigint,
    region_id bigint
);


ALTER TABLE coretlx.msg_dest OWNER TO coretlx;

--
-- Name: COLUMN msg_dest.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_dest.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.name IS 'Наименование издания';


--
-- Name: COLUMN msg_dest.info; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.info IS 'Информация об издании (показывается оператору)';


--
-- Name: COLUMN msg_dest.nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.nds IS 'Размер НДС';


--
-- Name: COLUMN msg_dest.bill_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.bill_name IS 'Наименование в биллинговой системе';


--
-- Name: COLUMN msg_dest.j_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.j_address IS 'Юридический адрес';


--
-- Name: COLUMN msg_dest.inn; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.inn IS 'ИНН';


--
-- Name: COLUMN msg_dest.contr; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.contr IS 'Договор';


--
-- Name: COLUMN msg_dest.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_dest.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_dest.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_dest.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.short_name IS 'Краткое наименование издания';


--
-- Name: COLUMN msg_dest.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.tarif_id IS 'Идентификатор применяемого тарифа';


--
-- Name: COLUMN msg_dest.release_count; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.release_count IS 'Максимальное число выпусков';


--
-- Name: COLUMN msg_dest.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.operator_id IS 'Идентификатор оператора в последний раз изменившего скидку';


--
-- Name: COLUMN msg_dest.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.region_id IS 'Идентификатор региона';


--
-- Name: msg_dest_address; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_dest_address (
    dest_id bigint NOT NULL,
    address_id bigint NOT NULL
);


ALTER TABLE coretlx.msg_dest_address OWNER TO coretlx;

--
-- Name: COLUMN msg_dest_address.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest_address.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_dest_address.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest_address.address_id IS 'Идентификатор адреса';


--
-- Name: msg_dest_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_dest_seq
    START WITH 869
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_dest_seq OWNER TO coretlx;

--
-- Name: msg_intelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_intelex (
    intelex_id bigint NOT NULL,
    tlg_index character varying(40),
    tlg_sector character varying(40),
    ch_number bigint,
    full_text character varying(4000),
    created timestamp(0) without time zone DEFAULT statement_timestamp(),
    siregex_id bigint,
    msgservice_id bigint,
    dtlg_content character varying(4000),
    dtlg_sign character varying(4000),
    dtlg_num character varying(400),
    dtlg_date character varying(400),
    dtlg_word character varying(400)
);


ALTER TABLE coretlx.msg_intelex OWNER TO coretlx;

--
-- Name: msg_intelex_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_intelex_seq
    START WITH 40270
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.msg_intelex_seq OWNER TO coretlx;

--
-- Name: msg_last_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_last_log (
    tlg_index character varying(40),
    tlg_sector character varying(40),
    chanell_no bigint,
    message_id bigint,
    chunk_id bigint,
    outtelex_id bigint,
    intelex_id bigint,
    created timestamp(0) without time zone,
    full_text character varying(4000)
);


ALTER TABLE coretlx.msg_last_log OWNER TO coretlx;

--
-- Name: TABLE msg_last_log; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.msg_last_log IS 'Последние отправленные телеграммы';


--
-- Name: msg_message; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_message (
    message_id bigint NOT NULL,
    note character varying(150),
    created timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    units bigint DEFAULT 0 NOT NULL,
    terminal character varying(80),
    service_id bigint NOT NULL,
    cost numeric(15,2) DEFAULT 0 NOT NULL,
    extracost numeric(15,2) DEFAULT 0 NOT NULL,
    ndscost numeric(15,2) DEFAULT 0 NOT NULL,
    msgtype_id smallint DEFAULT 1 NOT NULL,
    our_cost numeric(15,2),
    our_nds numeric(15,2),
    discount numeric(15,2) DEFAULT 0 NOT NULL,
    discount_extra numeric(15,2) DEFAULT 0 NOT NULL,
    changed timestamp(0) without time zone,
    call_id bigint,
    notification character varying(200),
    f_request smallint DEFAULT 0 NOT NULL,
    copy_dest_id integer,
    f_send_request smallint DEFAULT 0 NOT NULL,
    parent_id bigint,
    f_message_copy smallint DEFAULT 0 NOT NULL,
    f_auto_header smallint DEFAULT 1 NOT NULL,
    f_forward smallint DEFAULT 0 NOT NULL,
    tlgplace_no bigint,
    fgnote character varying(150),
    tarif_cost numeric(15,2) DEFAULT 0 NOT NULL,
    extra_cost numeric(15,2) DEFAULT 0 NOT NULL,
    nds_cost numeric(15,2) DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_message OWNER TO coretlx;

--
-- Name: COLUMN msg_message.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_message.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.note IS 'Примечание';


--
-- Name: COLUMN msg_message.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_message.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_message.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.operator_id IS 'Идентификатор оператора в последний раз изменившего сообщение';


--
-- Name: COLUMN msg_message.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.units IS 'Количество тарификационных единиц';


--
-- Name: COLUMN msg_message.terminal; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.terminal IS 'Терминал, с которого принято сообщение';


--
-- Name: COLUMN msg_message.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN msg_message.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.cost IS 'Сумма начисления по тарифу';


--
-- Name: COLUMN msg_message.extracost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.extracost IS 'Сумма сбора по тарифу';


--
-- Name: COLUMN msg_message.ndscost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.ndscost IS 'Сумма НДС';


--
-- Name: COLUMN msg_message.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN msg_message.our_cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.our_cost IS 'Доход оператора связи';


--
-- Name: COLUMN msg_message.our_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.our_nds IS 'НДС на доход оператора связи';


--
-- Name: COLUMN msg_message.discount; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.discount IS 'Скидка на сумму начисления';


--
-- Name: COLUMN msg_message.discount_extra; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.discount_extra IS 'Скидка на сумму сбора';


--
-- Name: COLUMN msg_message.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_message.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN msg_message.notification; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.notification IS 'Адрес уведомления о доставке';


--
-- Name: COLUMN msg_message.f_request; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_request IS 'Признак запроса уведомления';


--
-- Name: COLUMN msg_message.copy_dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.copy_dest_id IS 'Идентификатор места доставки копии сообщения';


--
-- Name: COLUMN msg_message.f_send_request; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_send_request IS 'Признак необходимости запроса';


--
-- Name: COLUMN msg_message.parent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.parent_id IS 'Идентификатор родительского сообщения (для копии)';


--
-- Name: COLUMN msg_message.f_message_copy; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_message_copy IS 'Признак копии ссобщения';


--
-- Name: COLUMN msg_message.f_auto_header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_auto_header IS 'Признак автоматического формирования заголовка в сервере доставки';


--
-- Name: COLUMN msg_message.f_forward; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_forward IS 'Признак сообщения типа "досыл"';


--
-- Name: COLUMN msg_message.tlgplace_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.tlgplace_no IS 'Номер телеграфного места для почтового ОС';


--
-- Name: COLUMN msg_message.fgnote; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.fgnote IS 'Дополнительное примечание при отправке сообщения';


--
-- Name: msg_message_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_message_seq
    START WITH 525984
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_message_seq OWNER TO coretlx;

--
-- Name: msg_outtelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_outtelex (
    outtelex_id bigint NOT NULL,
    text character varying(4000),
    header character varying(1600),
    serial_no bigint,
    units bigint,
    words bigint,
    chars bigint,
    tlg_chanell character varying(24),
    sector character varying(40),
    chanell_no bigint,
    full_serial character varying(200),
    sended timestamp(0) without time zone,
    created timestamp(0) without time zone,
    prepared timestamp(0) without time zone,
    message_id bigint,
    msgtype_id bigint,
    tlgend character varying(24),
    town_id bigint,
    note character varying(1600),
    tlgkind_id integer,
    operator_id bigint,
    advice_id bigint,
    intelex_id bigint,
    address character varying(1600),
    is_service smallint DEFAULT 1 NOT NULL,
    is_pay smallint DEFAULT 0 NOT NULL,
    postend character varying(24),
    is_query smallint DEFAULT 1 NOT NULL,
    is_notify smallint DEFAULT 0 NOT NULL,
    is_auto_header smallint DEFAULT 1 NOT NULL,
    is_retry smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_outtelex OWNER TO coretlx;

--
-- Name: COLUMN msg_outtelex.outtelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.outtelex_id IS 'Идентификатор исходящего сообщения';


--
-- Name: COLUMN msg_outtelex.text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.text IS 'Текст сообщения';


--
-- Name: COLUMN msg_outtelex.header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.header IS 'Заголовок сообщения';


--
-- Name: COLUMN msg_outtelex.serial_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.serial_no IS 'Кассовый номер';


--
-- Name: COLUMN msg_outtelex.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.units IS 'Единиц тарификации';


--
-- Name: COLUMN msg_outtelex.words; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.words IS 'Слов';


--
-- Name: COLUMN msg_outtelex.chars; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.chars IS 'Символов';


--
-- Name: COLUMN msg_outtelex.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlg_chanell IS 'Индекс канала передачи';


--
-- Name: COLUMN msg_outtelex.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.sector IS 'Сектор';


--
-- Name: COLUMN msg_outtelex.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_outtelex.full_serial; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.full_serial IS 'Полный номер телеграммы';


--
-- Name: COLUMN msg_outtelex.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.sended IS 'Отправлена';


--
-- Name: COLUMN msg_outtelex.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.created IS 'Создана';


--
-- Name: COLUMN msg_outtelex.prepared; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.prepared IS 'Подготовлена к отправке';


--
-- Name: COLUMN msg_outtelex.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_outtelex.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.msgtype_id IS 'Тип сообщения';


--
-- Name: COLUMN msg_outtelex.tlgend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlgend IS 'Телеграфный индекс назначения';


--
-- Name: COLUMN msg_outtelex.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.town_id IS 'Населенный пункт';


--
-- Name: COLUMN msg_outtelex.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.note IS 'Примечание оператора';


--
-- Name: COLUMN msg_outtelex.tlgkind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlgkind_id IS 'Категория телеграммы';


--
-- Name: COLUMN msg_outtelex.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.operator_id IS 'Оператор';


--
-- Name: COLUMN msg_outtelex.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.advice_id IS 'В ответ на запрос уведомления';


--
-- Name: COLUMN msg_outtelex.intelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.intelex_id IS 'В ответ на входящую телеграмму';


--
-- Name: COLUMN msg_outtelex.address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.address IS 'Адрес пункта назначения';


--
-- Name: COLUMN msg_outtelex.is_service; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_service IS 'Признак служебной телеграммы';


--
-- Name: COLUMN msg_outtelex.is_pay; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_pay IS 'Признак платной телеграммы';


--
-- Name: COLUMN msg_outtelex.postend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.postend IS 'Почтовй индекс';


--
-- Name: COLUMN msg_outtelex.is_query; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_query IS 'Запрос';


--
-- Name: COLUMN msg_outtelex.is_notify; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_notify IS 'Извещение отправителя';


--
-- Name: COLUMN msg_outtelex.is_auto_header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_auto_header IS 'Автоматическре формирование заголовка';


--
-- Name: COLUMN msg_outtelex.is_retry; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_retry IS 'Повторно неполучением';


--
-- Name: msg_parse; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_parse (
    intelex_id bigint NOT NULL,
    tlg_from character varying(4000),
    tlg_dest character varying(4000),
    tlg_content character varying(4000),
    tlg_sign character varying(4000),
    tlg_num character varying(400),
    tlg_date character varying(400),
    tlg_word character varying(400)
);


ALTER TABLE coretlx.msg_parse OWNER TO coretlx;

--
-- Name: COLUMN msg_parse.intelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.intelex_id IS 'ID входящей телеграммы';


--
-- Name: COLUMN msg_parse.tlg_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_from IS 'Откуда отправлена телеграмма';


--
-- Name: COLUMN msg_parse.tlg_dest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_dest IS 'Куда направлена телеграмма';


--
-- Name: COLUMN msg_parse.tlg_content; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_content IS 'Содержимое телеграммы';


--
-- Name: COLUMN msg_parse.tlg_sign; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_sign IS 'Подпись';


--
-- Name: COLUMN msg_parse.tlg_num; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_num IS 'Номер исходной телеграммы (из содержимого)';


--
-- Name: COLUMN msg_parse.tlg_date; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_date IS 'Дата исходной телеграммы';


--
-- Name: COLUMN msg_parse.tlg_word; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_word IS 'Количество слов исходной телеграммы';


--
-- Name: msg_rawtelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_rawtelex (
    rawtelex_id integer NOT NULL,
    tlg_header character varying(4000),
    tlg_body character varying(4000),
    tlg_footer character varying(4000),
    chunk_id bigint,
    outtelex_id bigint,
    intelex_id bigint,
    created timestamp(0) without time zone NOT NULL,
    tlg_index character varying(40),
    tlg_sector character varying(40),
    tlg_number integer,
    sended timestamp(0) without time zone
);


ALTER TABLE coretlx.msg_rawtelex OWNER TO coretlx;

--
-- Name: TABLE msg_rawtelex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.msg_rawtelex IS 'Отправленная/принятая по каналу связи телеграмма';


--
-- Name: msg_rawtelex_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_rawtelex_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.msg_rawtelex_seq OWNER TO coretlx;

--
-- Name: msg_request; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_request (
    request_id bigint NOT NULL,
    advice_id bigint,
    message_id bigint,
    codeword_id bigint,
    tlg_number character varying(20),
    note character varying(200),
    full_text text,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_request OWNER TO coretlx;

--
-- Name: msg_request_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_request_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_request_seq OWNER TO coretlx;

--
-- Name: msg_response; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_response (
    response_id bigint NOT NULL,
    codeword_id bigint,
    advice_id bigint NOT NULL,
    message_id bigint,
    tlg_number character varying(20) NOT NULL,
    note character varying(200),
    full_text text,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_response OWNER TO coretlx;

--
-- Name: msg_response_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_response_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_response_seq OWNER TO coretlx;

--
-- Name: msg_responsible; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_responsible (
    responsible_id bigint NOT NULL,
    name character varying(300),
    phone1 character varying(20),
    phone2 character varying(20),
    e_mail character varying(300),
    dest_id bigint NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_responsible OWNER TO coretlx;

--
-- Name: COLUMN msg_responsible.responsible_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.responsible_id IS 'Идентификатор ответственного лица';


--
-- Name: COLUMN msg_responsible.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.name IS 'Имя';


--
-- Name: COLUMN msg_responsible.phone1; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.phone1 IS 'Контактный телефон 1';


--
-- Name: COLUMN msg_responsible.phone2; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.phone2 IS 'Контактный телефон 2';


--
-- Name: COLUMN msg_responsible.e_mail; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.e_mail IS 'Адрес электронной почты';


--
-- Name: COLUMN msg_responsible.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_responsible.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_responsible.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_responsible.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_responsible.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: msg_responsible_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_responsible_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_responsible_seq OWNER TO coretlx;

--
-- Name: msg_send_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_send_log (
    send_log_id bigint NOT NULL,
    error_id smallint,
    sended timestamp(0) without time zone DEFAULT statement_timestamp(),
    tlg_chanell character varying(6),
    chunk_id bigint,
    telex_number bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    error_string character varying(200),
    sector character varying(10),
    message_id bigint
);


ALTER TABLE coretlx.msg_send_log OWNER TO coretlx;

--
-- Name: COLUMN msg_send_log.send_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.send_log_id IS 'Идентификатор журнала отправки';


--
-- Name: COLUMN msg_send_log.error_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.error_id IS 'Идентификатор ошибки отправки';


--
-- Name: COLUMN msg_send_log.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.sended IS 'Отправлено';


--
-- Name: COLUMN msg_send_log.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.tlg_chanell IS 'Телеграфный канал';


--
-- Name: COLUMN msg_send_log.chunk_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.chunk_id IS 'Идентификатор фрагмента';


--
-- Name: COLUMN msg_send_log.telex_number; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.telex_number IS 'Номер телеграммы';


--
-- Name: COLUMN msg_send_log.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_send_log.error_string; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.error_string IS 'Строка ошибки';


--
-- Name: COLUMN msg_send_log.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.sector IS 'Телеграфный сектор';


--
-- Name: msg_send_log_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_send_log_seq
    START WITH 496887
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_send_log_seq OWNER TO coretlx;

--
-- Name: msg_serial; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_serial (
    operator_id bigint,
    serial_no bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL
);


ALTER TABLE coretlx.msg_serial OWNER TO coretlx;

--
-- Name: msg_service; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_service (
    msgservice_id bigint NOT NULL,
    full_text character varying(4000),
    operator_id bigint,
    sended timestamp(0) without time zone,
    received timestamp(0) without time zone,
    is_incoming smallint DEFAULT 0 NOT NULL,
    tlg_chanell character varying(24),
    sector character varying(40),
    chanell_no bigint,
    codeword_id bigint,
    advice_id bigint,
    is_inquire smallint DEFAULT 0,
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    name character varying(400),
    intelex_id bigint,
    outtelex_id bigint
);


ALTER TABLE coretlx.msg_service OWNER TO coretlx;

--
-- Name: COLUMN msg_service.msgservice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.msgservice_id IS 'Идентификатор служебной кодограммы';


--
-- Name: COLUMN msg_service.full_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.full_text IS 'Полный текст служебной кодограммы';


--
-- Name: COLUMN msg_service.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.operator_id IS 'Идентификатор оператора принявшего/отправившего телеграмму';


--
-- Name: COLUMN msg_service.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.sended IS 'Когда отправлена';


--
-- Name: COLUMN msg_service.received; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.received IS 'Когда принята';


--
-- Name: COLUMN msg_service.is_incoming; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.is_incoming IS 'Признак входящей кодограммы';


--
-- Name: COLUMN msg_service.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.tlg_chanell IS 'Телеграфный канал';


--
-- Name: COLUMN msg_service.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.sector IS 'Сектор';


--
-- Name: COLUMN msg_service.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_service.codeword_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.codeword_id IS 'Идентификатор кодового слова в телеграмме';


--
-- Name: COLUMN msg_service.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.advice_id IS 'Идентификатор запроса уведомления';


--
-- Name: COLUMN msg_service.is_inquire; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.is_inquire IS 'Запрос';


--
-- Name: COLUMN msg_service.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.name IS 'Наименование кодограммы';


--
-- Name: msg_service_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_service_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.msg_service_seq OWNER TO coretlx;

--
-- Name: msg_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_state (
    message_id bigint NOT NULL,
    state_id smallint NOT NULL,
    prepared timestamp(0) without time zone,
    sended timestamp(0) without time zone,
    dest_id bigint,
    operator_id bigint,
    locked timestamp(0) without time zone,
    tlg_chanell bigint,
    sector character varying(10),
    created timestamp(0) without time zone,
    msgtype_id smallint,
    parent_id bigint,
    tlgprio smallint,
    outtelex_id bigint
);


ALTER TABLE coretlx.msg_state OWNER TO coretlx;

--
-- Name: COLUMN msg_state.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.state_id IS 'Идентификатор текущего состояния';


--
-- Name: COLUMN msg_state.prepared; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.prepared IS 'Подготовлено к передаче';


--
-- Name: COLUMN msg_state.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.sended IS 'Отправлено';


--
-- Name: COLUMN msg_state.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_state.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.operator_id IS 'Идентификатор оператор, изменившего состояния';


--
-- Name: COLUMN msg_state.locked; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.locked IS 'Заблокировано на отправку';


--
-- Name: COLUMN msg_state.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.tlg_chanell IS 'Телеграфный канал передачи сообщения';


--
-- Name: COLUMN msg_state.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.created IS 'Время создания сообщения';


--
-- Name: COLUMN msg_state.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.msgtype_id IS 'Тип телеграммы';


--
-- Name: COLUMN msg_state.parent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.parent_id IS 'Идентификатор родительской телеграммы';


--
-- Name: COLUMN msg_state.tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.tlgprio IS 'Идентификатор приоритета';


--
-- Name: COLUMN msg_state.outtelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.outtelex_id IS 'Идентификатор исходящей телеграммы';


--
-- Name: msg_telex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_telex (
    message_id bigint NOT NULL,
    sign character varying(200),
    tlindex character varying(6) NOT NULL,
    tlgend character varying(200),
    street character varying(200),
    addressee character varying(150),
    country character varying(50),
    postend character varying(6),
    town_id bigint,
    first_address character varying(1000),
    second_address character varying(1000),
    serve_date character varying(100),
    first_tlgprio bigint,
    second_tlgprio bigint,
    cond_address character varying(200),
    tlgplace_no bigint
);


ALTER TABLE coretlx.msg_telex OWNER TO coretlx;

--
-- Name: COLUMN msg_telex.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_telex.sign; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.sign IS 'Подпись абонента';


--
-- Name: COLUMN msg_telex.tlindex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlindex IS 'Телеграфный индекс назначения';


--
-- Name: COLUMN msg_telex.tlgend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlgend IS 'Адрес';


--
-- Name: COLUMN msg_telex.street; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.street IS 'Адрес';


--
-- Name: COLUMN msg_telex.addressee; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.addressee IS 'Получатель';


--
-- Name: COLUMN msg_telex.country; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.country IS 'Страна назначения';


--
-- Name: COLUMN msg_telex.postend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.postend IS 'Почтовый индекс';


--
-- Name: COLUMN msg_telex.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.town_id IS 'Идентификатор города назначения';


--
-- Name: COLUMN msg_telex.first_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.first_address IS 'Адрес первого фрагмента';


--
-- Name: COLUMN msg_telex.second_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.second_address IS 'Адрес следующего фрагмента';


--
-- Name: COLUMN msg_telex.serve_date; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.serve_date IS 'Дата вручения';


--
-- Name: COLUMN msg_telex.first_tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.first_tlgprio IS 'Приоритет первой телеграммы';


--
-- Name: COLUMN msg_telex.second_tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.second_tlgprio IS 'Приоритет второй телеграммы';


--
-- Name: COLUMN msg_telex.cond_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.cond_address IS 'Условный адрес';


--
-- Name: COLUMN msg_telex.tlgplace_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlgplace_no IS 'Номер телеграфного места для почтового ОС';


--
-- Name: msg_template; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_template (
    template_id bigint NOT NULL,
    name character varying(100) NOT NULL,
    note character varying(300),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    xslt text,
    operator_id bigint
);


ALTER TABLE coretlx.msg_template OWNER TO coretlx;

--
-- Name: COLUMN msg_template.template_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.template_id IS 'Идентификатор шаблона форматирования';


--
-- Name: COLUMN msg_template.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.name IS 'Наименование шаблона форматирования';


--
-- Name: COLUMN msg_template.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.note IS 'Примечание';


--
-- Name: COLUMN msg_template.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_template.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_template.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_template.xslt; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.xslt IS 'Шаблон форматирования в формате XSLT';


--
-- Name: COLUMN msg_template.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.operator_id IS 'Идентификатор оператора в последний раз изменившего шаблон';


--
-- Name: msg_template_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_template_seq
    START WITH 209
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.msg_template_seq OWNER TO coretlx;

--
-- Name: msg_xfer_content; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_xfer_content (
    xfer_log_id bigint NOT NULL,
    message_id bigint NOT NULL
);


ALTER TABLE coretlx.msg_xfer_content OWNER TO coretlx;

--
-- Name: COLUMN msg_xfer_content.xfer_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_content.xfer_log_id IS 'Идентификатор запланированной передачи';


--
-- Name: COLUMN msg_xfer_content.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_content.message_id IS 'Идентификатор сообщения';


--
-- Name: msg_xfer_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_xfer_log (
    xfer_log_id bigint NOT NULL,
    address_id bigint NOT NULL,
    xfered timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    planned timestamp(0) without time zone,
    started timestamp(0) without time zone,
    xfer_id bigint
);


ALTER TABLE coretlx.msg_xfer_log OWNER TO coretlx;

--
-- Name: COLUMN msg_xfer_log.xfer_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfer_log_id IS 'Идентификатор запланированной передачи';


--
-- Name: COLUMN msg_xfer_log.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.address_id IS 'Идентификатор адреса передачи';


--
-- Name: COLUMN msg_xfer_log.xfered; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfered IS 'Дата завершения передачи';


--
-- Name: COLUMN msg_xfer_log.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.created IS 'Дата создания запланированной передачи';


--
-- Name: COLUMN msg_xfer_log.planned; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.planned IS 'Запланировано';


--
-- Name: COLUMN msg_xfer_log.started; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.started IS 'Начато';


--
-- Name: COLUMN msg_xfer_log.xfer_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfer_id IS 'Идентификатор времени передачи';


--
-- Name: msg_xfer_log_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_xfer_log_seq
    START WITH 46447
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.msg_xfer_log_seq OWNER TO coretlx;

--
-- Name: ref_clientcategory; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_clientcategory (
    clientcategory_id smallint NOT NULL,
    name character varying(50),
    charge_nds smallint DEFAULT 0 NOT NULL,
    short_name character varying(50),
    catgroup_id bigint
);


ALTER TABLE coretlx.ref_clientcategory OWNER TO coretlx;

--
-- Name: COLUMN ref_clientcategory.clientcategory_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.clientcategory_id IS 'Идентификатор категории абонента';


--
-- Name: COLUMN ref_clientcategory.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.name IS 'Наименование категории абонента';


--
-- Name: COLUMN ref_clientcategory.charge_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.charge_nds IS 'Признак начисления НДС';


--
-- Name: COLUMN ref_clientcategory.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.short_name IS 'Краткое наименование категории абонента';


--
-- Name: COLUMN ref_clientcategory.catgroup_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.catgroup_id IS 'Идентификатор группы категорий';


--
-- Name: ref_codeword; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_codeword (
    codeword_id bigint NOT NULL,
    codeword character varying(80) NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    description character varying(4000)
);


ALTER TABLE coretlx.ref_codeword OWNER TO coretlx;

--
-- Name: ref_codeword_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_codeword_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_codeword_seq OWNER TO coretlx;

--
-- Name: ref_copy_dest; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_copy_dest (
    copy_dest_id integer NOT NULL,
    dest_name character varying(100),
    start_label character varying(100),
    end_label character varying(100),
    telex_hi character(3),
    telex_lo character(3),
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id integer,
    region_id bigint
);


ALTER TABLE coretlx.ref_copy_dest OWNER TO coretlx;

--
-- Name: ref_copy_dest_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_copy_dest_seq
    START WITH 174
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_copy_dest_seq OWNER TO coretlx;

--
-- Name: ref_country; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_country (
    country_id bigint NOT NULL,
    name character varying(60) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_country OWNER TO coretlx;

--
-- Name: COLUMN ref_country.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.country_id IS 'Идентификатор страны СНГ для передачи телеграммы';


--
-- Name: COLUMN ref_country.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.name IS 'Наименование страны';


--
-- Name: COLUMN ref_country.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_country.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_country.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_country.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.operator_id IS 'Идентификатор оператора в последний раз изменившего страну';


--
-- Name: ref_country_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_country_seq
    START WITH 19
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_country_seq OWNER TO coretlx;

--
-- Name: ref_day_period_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_day_period_seq
    START WITH 84
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_day_period_seq OWNER TO coretlx;

--
-- Name: ref_day_periods; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_day_periods (
    day_period_id bigint NOT NULL,
    day_period_name character varying(50) NOT NULL,
    exclude smallint DEFAULT 0 NOT NULL,
    date_from timestamp(0) without time zone,
    date_to timestamp(0) without time zone,
    time_from character(8),
    time_to character(8),
    weekday_from smallint,
    weekday_to smallint,
    period_id bigint NOT NULL
);


ALTER TABLE coretlx.ref_day_periods OWNER TO coretlx;

--
-- Name: COLUMN ref_day_periods.day_period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.day_period_id IS 'Идентификатор временного интервала';


--
-- Name: COLUMN ref_day_periods.day_period_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.day_period_name IS 'Наименование';


--
-- Name: COLUMN ref_day_periods.exclude; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.exclude IS 'Признак исключения из периода';


--
-- Name: COLUMN ref_day_periods.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.date_from IS 'Дата начала действия';


--
-- Name: COLUMN ref_day_periods.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.date_to IS 'Дата окончания действия';


--
-- Name: COLUMN ref_day_periods.time_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.time_from IS 'Время начала действия';


--
-- Name: COLUMN ref_day_periods.time_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.time_to IS 'Время окончания действия';


--
-- Name: COLUMN ref_day_periods.weekday_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.weekday_from IS 'День недели начала';


--
-- Name: COLUMN ref_day_periods.weekday_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.weekday_to IS 'День недели окончания';


--
-- Name: COLUMN ref_day_periods.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.period_id IS 'Идентификатор периода';


--
-- Name: ref_delivery; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_delivery (
    delivery_id bigint NOT NULL,
    cat_name character varying(800),
    delivery_time character varying(400),
    reason character varying(800),
    entered timestamp(0) without time zone,
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    order_no bigint
);


ALTER TABLE coretlx.ref_delivery OWNER TO coretlx;

--
-- Name: COLUMN ref_delivery.delivery_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.delivery_id IS 'Уникальный идентификатор';


--
-- Name: COLUMN ref_delivery.cat_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.cat_name IS 'Наименование категории телеграммы';


--
-- Name: COLUMN ref_delivery.delivery_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.delivery_time IS 'Срок доставки телеграммы';


--
-- Name: COLUMN ref_delivery.reason; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.reason IS 'Основание ';


--
-- Name: COLUMN ref_delivery.entered; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.entered IS 'Введен';


--
-- Name: COLUMN ref_delivery.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.created IS 'Создано';


--
-- Name: COLUMN ref_delivery.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.changed IS 'Изменено';


--
-- Name: COLUMN ref_delivery.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.closed IS 'Удалено';


--
-- Name: COLUMN ref_delivery.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.order_no IS 'Порядок отображения';


--
-- Name: ref_delivery_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_delivery_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.ref_delivery_seq OWNER TO coretlx;

--
-- Name: ref_dest_rubric; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_dest_rubric (
    dest_rubric_id bigint NOT NULL,
    name character varying(100),
    label character varying(50),
    order_no bigint,
    dest_id bigint,
    my_rubric_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_dest_rubric OWNER TO coretlx;

--
-- Name: COLUMN ref_dest_rubric.dest_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.dest_rubric_id IS 'Идентификатор рубрики издания';


--
-- Name: COLUMN ref_dest_rubric.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.name IS 'Наименование рубрики';


--
-- Name: COLUMN ref_dest_rubric.label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.label IS 'Отметка в сообщении';


--
-- Name: COLUMN ref_dest_rubric.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.order_no IS 'Порядковый номер (используется для сортировки списка при выводе оператору)';


--
-- Name: COLUMN ref_dest_rubric.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN ref_dest_rubric.my_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.my_rubric_id IS 'Идентификатор внутренней рубрики';


--
-- Name: COLUMN ref_dest_rubric.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_dest_rubric.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_dest_rubric.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_dest_rubric.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.operator_id IS 'Идентификатор оператора в последний раз изменившего рубрику';


--
-- Name: ref_dest_rubric_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_dest_rubric_order_seq
    START WITH 1663
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_dest_rubric_order_seq OWNER TO coretlx;

--
-- Name: ref_dest_rubric_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_dest_rubric_seq
    START WITH 1663
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_dest_rubric_seq OWNER TO coretlx;

--
-- Name: ref_exclude_release; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_exclude_release (
    exclude_release_id bigint NOT NULL,
    date_from timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    date_to timestamp(0) without time zone,
    note character varying(100),
    dest_id bigint NOT NULL
);


ALTER TABLE coretlx.ref_exclude_release OWNER TO coretlx;

--
-- Name: COLUMN ref_exclude_release.exclude_release_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.exclude_release_id IS 'Идентификатор запрета приема';


--
-- Name: COLUMN ref_exclude_release.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.date_from IS 'Дата начала';


--
-- Name: COLUMN ref_exclude_release.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.date_to IS 'Дата окончания';


--
-- Name: COLUMN ref_exclude_release.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.note IS 'Примечание';


--
-- Name: COLUMN ref_exclude_release.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.dest_id IS 'Идентификатор издания';


--
-- Name: ref_exclude_release_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_exclude_release_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.ref_exclude_release_seq OWNER TO coretlx;

--
-- Name: ref_fgplace; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_fgplace (
    fgplace_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    telex_town character varying(200),
    telex_index character varying(10),
    receive_id bigint,
    region_id bigint
);


ALTER TABLE coretlx.ref_fgplace OWNER TO coretlx;

--
-- Name: ref_fgplace_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_fgplace_seq
    START WITH 661
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.ref_fgplace_seq OWNER TO coretlx;

--
-- Name: ref_location; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_location (
    location_id bigint NOT NULL,
    name character varying(60),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    tarif_id bigint,
    operator_id bigint,
    f_builtin smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.ref_location OWNER TO coretlx;

--
-- Name: COLUMN ref_location.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.location_id IS 'Идентификатор территории';


--
-- Name: COLUMN ref_location.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.name IS 'Наименование территории';


--
-- Name: COLUMN ref_location.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_location.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_location.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_location.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN ref_location.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: COLUMN ref_location.f_builtin; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.f_builtin IS 'Признак использование в системе, не может удаляться пользователем';


--
-- Name: ref_location_place; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_location_place (
    location_id bigint NOT NULL,
    country_id bigint,
    province_id bigint,
    town_id bigint,
    exclude smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_location_place OWNER TO coretlx;

--
-- Name: COLUMN ref_location_place.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.location_id IS 'Идентификатор территории';


--
-- Name: COLUMN ref_location_place.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.country_id IS 'Идентификатор страны';


--
-- Name: COLUMN ref_location_place.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.province_id IS 'Идентификатор области';


--
-- Name: COLUMN ref_location_place.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.town_id IS 'Идентификатор города';


--
-- Name: COLUMN ref_location_place.exclude; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.exclude IS 'Признак исключения из территории';


--
-- Name: COLUMN ref_location_place.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_location_place.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_location_place.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_location_place.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_location_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_location_seq
    START WITH 39
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_location_seq OWNER TO coretlx;

--
-- Name: ref_my_rubric; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_my_rubric (
    my_rubric_id bigint NOT NULL,
    name character varying(50),
    order_no bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_my_rubric OWNER TO coretlx;

--
-- Name: COLUMN ref_my_rubric.my_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.my_rubric_id IS 'Идентификатор внутренней рубрики';


--
-- Name: COLUMN ref_my_rubric.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.name IS 'Наименование внутренней рубрики';


--
-- Name: COLUMN ref_my_rubric.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.order_no IS 'Номер по порядку (для сортировки)';


--
-- Name: COLUMN ref_my_rubric.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_my_rubric.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_my_rubric.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_my_rubric.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.operator_id IS 'Идентификатор оператора в последний раз изменившего рубрику';


--
-- Name: ref_my_rubric_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_my_rubric_order_seq
    START WITH 11
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_my_rubric_order_seq OWNER TO coretlx;

--
-- Name: ref_my_rubric_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_my_rubric_seq
    START WITH 11
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_my_rubric_seq OWNER TO coretlx;

--
-- Name: ref_news; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_news (
    news_id bigint NOT NULL,
    country_id bigint,
    created timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    content character varying(4000)
);


ALTER TABLE coretlx.ref_news OWNER TO coretlx;

--
-- Name: COLUMN ref_news.news_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.news_id IS 'Идентификатор новости';


--
-- Name: COLUMN ref_news.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.country_id IS 'Идентификатор страны назначения';


--
-- Name: COLUMN ref_news.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.created IS 'Создано';


--
-- Name: COLUMN ref_news.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.closed IS 'Удалено';


--
-- Name: COLUMN ref_news.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.changed IS 'Изменено';


--
-- Name: COLUMN ref_news.content; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.content IS 'Содержимое новости';


--
-- Name: ref_news_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_news_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.ref_news_seq OWNER TO coretlx;

--
-- Name: ref_options; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_options (
    option_id bigint NOT NULL,
    module_id bigint NOT NULL,
    options bytea,
    operator_id bigint,
    prop_name character varying(100)
);


ALTER TABLE coretlx.ref_options OWNER TO coretlx;

--
-- Name: COLUMN ref_options.option_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.option_id IS 'Идентификатор настроек';


--
-- Name: COLUMN ref_options.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN ref_options.options; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.options IS 'Настройки';


--
-- Name: COLUMN ref_options.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.operator_id IS 'Идентификатор оператора, для которого сохранены настройки (null - глобальные настройки для всех операторов)';


--
-- Name: COLUMN ref_options.prop_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.prop_name IS 'Наименование настроек';


--
-- Name: ref_options_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_options_seq
    START WITH 42
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_options_seq OWNER TO coretlx;

--
-- Name: ref_order; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_order (
    order_id bigint NOT NULL,
    tarif_id bigint NOT NULL,
    name character varying(50),
    short_name character varying(50),
    label character varying(50),
    info character varying(4000),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone
);


ALTER TABLE coretlx.ref_order OWNER TO coretlx;

--
-- Name: COLUMN ref_order.order_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.order_id IS 'Идентификатор услуги заказа';


--
-- Name: COLUMN ref_order.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN ref_order.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.name IS 'Наименование услуги заказа';


--
-- Name: COLUMN ref_order.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.short_name IS 'Краткое наименование';


--
-- Name: COLUMN ref_order.label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.label IS 'Отметка';


--
-- Name: COLUMN ref_order.info; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.info IS 'Информация (для оператора)';


--
-- Name: COLUMN ref_order.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_order.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_order.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.closed IS 'Дата/время удаления';


--
-- Name: ref_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_order_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.ref_order_seq OWNER TO coretlx;

--
-- Name: ref_period; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_period (
    period_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    closed timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_period OWNER TO coretlx;

--
-- Name: COLUMN ref_period.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.period_id IS 'Идентификатор периода времени';


--
-- Name: COLUMN ref_period.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.name IS 'Наименование';


--
-- Name: COLUMN ref_period.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_period.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_period.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_period.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_period_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_period_seq
    START WITH 103
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_period_seq OWNER TO coretlx;

--
-- Name: ref_province; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_province (
    province_id bigint NOT NULL,
    country_id bigint NOT NULL,
    name character varying(60) NOT NULL,
    name_print character varying(60),
    time_diff smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    def_town_id bigint,
    operator_id bigint,
    imp_name character varying(100),
    CONSTRAINT ref_province_chk1 CHECK (((time_diff >= '-24'::integer) AND (time_diff <= 24)))
);


ALTER TABLE coretlx.ref_province OWNER TO coretlx;

--
-- Name: COLUMN ref_province.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.province_id IS 'Идентификатор области (края)';


--
-- Name: COLUMN ref_province.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.country_id IS 'Идентификатор страны, в которой расположена область';


--
-- Name: COLUMN ref_province.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.name IS 'Наименование';


--
-- Name: COLUMN ref_province.name_print; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.name_print IS 'Наименование в родительном падеже';


--
-- Name: COLUMN ref_province.time_diff; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.time_diff IS 'Разница во времени с МСК';


--
-- Name: COLUMN ref_province.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_province.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_province.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_province.def_town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.def_town_id IS 'Идентификатор города, автоматически выбираемого в АРМ оператора при выборе области';


--
-- Name: COLUMN ref_province.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.operator_id IS 'Идентификатор оператора в последний раз изменившего область';


--
-- Name: COLUMN ref_province.imp_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.imp_name IS 'Наименование в импортируемом справочнике телеграфных индексов';


--
-- Name: ref_province_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_province_seq
    START WITH 244
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_province_seq OWNER TO coretlx;

--
-- Name: ref_release; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_release (
    date_from timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    date_to timestamp(0) without time zone,
    lock_days smallint DEFAULT 0 NOT NULL,
    lock_time character varying(5) DEFAULT '00:00'::character varying NOT NULL,
    weekday_from smallint,
    weekday_to smallint,
    release_id bigint NOT NULL,
    note character varying(100),
    disable_time character varying(5) DEFAULT '00:00'::character varying NOT NULL,
    dest_id bigint NOT NULL,
    operator_id bigint
);


ALTER TABLE coretlx.ref_release OWNER TO coretlx;

--
-- Name: COLUMN ref_release.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.date_from IS 'Дата начала действия';


--
-- Name: COLUMN ref_release.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.date_to IS 'Дата окончания действия';


--
-- Name: COLUMN ref_release.lock_days; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.lock_days IS 'Запретить прием за дней (мягкая блокировка)';


--
-- Name: COLUMN ref_release.lock_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.lock_time IS 'Запретить прием в (время) (мягкая блокировка)';


--
-- Name: COLUMN ref_release.weekday_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.weekday_from IS 'День недели начала действия';


--
-- Name: COLUMN ref_release.weekday_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.weekday_to IS 'День недели окончания действия';


--
-- Name: COLUMN ref_release.release_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.release_id IS 'Идентификатор времени выпуска';


--
-- Name: COLUMN ref_release.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.note IS 'Примечание';


--
-- Name: COLUMN ref_release.disable_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.disable_time IS 'Запретить формировние за дней (жесткая блокировка)';


--
-- Name: COLUMN ref_release.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.dest_id IS 'Запретить формирование в (время) (жесткая блокировка)';


--
-- Name: COLUMN ref_release.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_release_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_release_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_release_seq OWNER TO coretlx;

--
-- Name: ref_reports; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_reports (
    report_id bigint NOT NULL,
    module_id bigint NOT NULL,
    r_data bytea,
    u_name character varying(100),
    grid_name character varying(100),
    slow_report smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.ref_reports OWNER TO coretlx;

--
-- Name: COLUMN ref_reports.report_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.report_id IS 'Идентификатор отчета';


--
-- Name: COLUMN ref_reports.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN ref_reports.r_data; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.r_data IS 'Шаблон для построения отчета';


--
-- Name: COLUMN ref_reports.u_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.u_name IS 'Наименование отчета';


--
-- Name: COLUMN ref_reports.grid_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.grid_name IS 'Наименование сетки (для интегрированных отчетов)';


--
-- Name: COLUMN ref_reports.slow_report; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.slow_report IS 'Признак медленного отчета';


--
-- Name: ref_reports_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_reports_seq
    START WITH 105381
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.ref_reports_seq OWNER TO coretlx;

--
-- Name: ref_town; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_town (
    town_id bigint NOT NULL,
    province_id bigint NOT NULL,
    name character varying(60),
    region character varying(60),
    attr character varying(1),
    note character varying(100),
    has_telex smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    telex_hi character varying(3) NOT NULL,
    telex_lo character varying(3),
    operator_id bigint,
    imp_name character varying(100),
    CONSTRAINT ref_town_chk1 CHECK (((attr)::text = ANY (ARRAY[(''::character varying)::text, ('о'::character varying)::text, ('ц'::character varying)::text, ('г'::character varying)::text, ('О'::character varying)::text, ('Ц'::character varying)::text, ('Г'::character varying)::text, (' '::character varying)::text])))
);


ALTER TABLE coretlx.ref_town OWNER TO coretlx;

--
-- Name: COLUMN ref_town.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.town_id IS 'Идентификатор города (населенного пункта)';


--
-- Name: COLUMN ref_town.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.province_id IS 'Идентификатор области (края) где расположен город';


--
-- Name: COLUMN ref_town.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.name IS 'Наименование';


--
-- Name: COLUMN ref_town.region; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.region IS 'Район (если есть) в родительном падеже';


--
-- Name: COLUMN ref_town.attr; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.attr IS 'Признак (О - областной центр, Ц - районный центр, Г - город без необходимости указания района в адресе)';


--
-- Name: COLUMN ref_town.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.note IS 'Примечание для операторов по приему телеграмм';


--
-- Name: COLUMN ref_town.has_telex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.has_telex IS 'Признак наличия телеграфной связи';


--
-- Name: COLUMN ref_town.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_town.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_town.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_town.telex_hi; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.telex_hi IS 'Верхний телеграфный индекс';


--
-- Name: COLUMN ref_town.telex_lo; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.telex_lo IS 'Низовой телеграфный индекс';


--
-- Name: COLUMN ref_town.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.operator_id IS 'Идентификатор оператора в последний раз изменившего город';


--
-- Name: COLUMN ref_town.imp_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.imp_name IS 'Наименование в импортируемом справочнике телеграфных индексов';


--
-- Name: ref_town_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_town_seq
    START WITH 33510
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_town_seq OWNER TO coretlx;

--
-- Name: ref_xfer; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_xfer (
    xfer_time character varying(5),
    weekday_id smallint NOT NULL,
    xfer_id bigint NOT NULL,
    note character varying(100),
    address_id bigint
);


ALTER TABLE coretlx.ref_xfer OWNER TO coretlx;

--
-- Name: COLUMN ref_xfer.xfer_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.xfer_time IS 'Время передачи';


--
-- Name: COLUMN ref_xfer.weekday_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.weekday_id IS 'День недели';


--
-- Name: COLUMN ref_xfer.xfer_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.xfer_id IS 'Идентификатор передачи';


--
-- Name: COLUMN ref_xfer.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.note IS 'Примечание';


--
-- Name: COLUMN ref_xfer.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.address_id IS 'Идентификатор адреса доставки сообщений';


--
-- Name: ref_xfer_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_xfer_seq
    START WITH 2545
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER SEQUENCE coretlx.ref_xfer_seq OWNER TO coretlx;

--
-- Name: role_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE coretlx.role_seq OWNER TO coretlx;

--
-- Name: roles; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.roles (
    id smallint NOT NULL,
    name character varying(255)
);


ALTER TABLE coretlx.roles OWNER TO coretlx;

--
-- Name: tmp_old_charge_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.tmp_old_charge_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER SEQUENCE coretlx.tmp_old_charge_seq OWNER TO coretlx;

--
-- Name: voc_advice_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_advice_state (
    advice_state_id bigint NOT NULL,
    state_name character varying(50),
    f_advice smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_advice_state OWNER TO coretlx;

--
-- Name: voc_app_errors; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_app_errors (
    module_id bigint,
    error_code bigint,
    package_name character varying(50),
    message character varying(200)
);


ALTER TABLE coretlx.voc_app_errors OWNER TO coretlx;

--
-- Name: voc_chanell_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_chanell_state (
    state_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_chanell_state OWNER TO coretlx;

--
-- Name: voc_charge_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_charge_state (
    charge_state_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_charge_state OWNER TO coretlx;

--
-- Name: COLUMN voc_charge_state.charge_state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_charge_state.charge_state_id IS 'Идентификатор состояния начисления';


--
-- Name: COLUMN voc_charge_state.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_charge_state.name IS 'Расшифровка';


--
-- Name: voc_charge_type; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_charge_type (
    chgtype_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_charge_type OWNER TO coretlx;

--
-- Name: voc_encoding; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_encoding (
    encoding_id smallint NOT NULL,
    name character varying(20)
);


ALTER TABLE coretlx.voc_encoding OWNER TO coretlx;

--
-- Name: COLUMN voc_encoding.encoding_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_encoding.encoding_id IS 'Идентификатор кодировки сообщения';


--
-- Name: COLUMN voc_encoding.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_encoding.name IS 'Наимеование кодировки';


--
-- Name: voc_fgabonent; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_fgabonent (
    fgabonent_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    clientcat coretlx.clientcat_list,
    receive_id bigint,
    f_auto_header smallint DEFAULT 1 NOT NULL
);


ALTER TABLE coretlx.voc_fgabonent OWNER TO coretlx;

--
-- Name: COLUMN voc_fgabonent.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgabonent.fgabonent_id IS 'Идентификатор абонента';


--
-- Name: COLUMN voc_fgabonent.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgabonent.receive_id IS 'место приема';


--
-- Name: voc_fgregion; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_fgregion (
    region_id bigint,
    fgabonent_id bigint,
    pay_phone character varying(20),
    abonent_id character varying(20)
);


ALTER TABLE coretlx.voc_fgregion OWNER TO coretlx;

--
-- Name: COLUMN voc_fgregion.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_fgregion.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.fgabonent_id IS 'Идентификатор типа обслуживания';


--
-- Name: COLUMN voc_fgregion.pay_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.pay_phone IS 'Телефон оплаты, экспортируемый в биллинговую систему';


--
-- Name: COLUMN voc_fgregion.abonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.abonent_id IS 'Идентификатор абонента, экспортируемый в биллинговую систему';


--
-- Name: voc_modules; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_modules (
    module_id bigint NOT NULL,
    module_name character varying(200),
    v_major bigint DEFAULT 0 NOT NULL,
    v_minor bigint DEFAULT 0 NOT NULL,
    v_release bigint DEFAULT 0 NOT NULL,
    v_build bigint DEFAULT 0 NOT NULL,
    option_list bytea,
    m_major bigint DEFAULT 0 NOT NULL,
    m_minor bigint DEFAULT 0 NOT NULL,
    m_release bigint DEFAULT 0 NOT NULL,
    m_build bigint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_modules OWNER TO coretlx;

--
-- Name: COLUMN voc_modules.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN voc_modules.module_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.module_name IS 'Наименование модуля';


--
-- Name: COLUMN voc_modules.v_major; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_major IS 'Старший номер версии модуля';


--
-- Name: COLUMN voc_modules.v_minor; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_minor IS 'Младший номер версии модуля';


--
-- Name: COLUMN voc_modules.v_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_release IS 'Номер выпуска версии модуля';


--
-- Name: COLUMN voc_modules.v_build; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_build IS 'Номер постройки версии модуля';


--
-- Name: COLUMN voc_modules.option_list; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.option_list IS 'Глобальные настройки модуля';


--
-- Name: COLUMN voc_modules.m_major; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_major IS 'Минимальный старший номер поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_minor; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_minor IS 'Минимальный младший номер поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_release IS 'Минимальный номер выпуска поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_build; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_build IS 'Минимальный номер постройки поддерживаемой версии модуля';


--
-- Name: voc_msg_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_msg_state (
    state_id smallint NOT NULL,
    name character varying(50),
    archive smallint NOT NULL
);


ALTER TABLE coretlx.voc_msg_state OWNER TO coretlx;

--
-- Name: COLUMN voc_msg_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.state_id IS 'Идентификатор текущего состояния сообщения';


--
-- Name: COLUMN voc_msg_state.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.name IS 'Наименование текущего состояния сообщения';


--
-- Name: COLUMN voc_msg_state.archive; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.archive IS 'Признак архива (сообщение отправлено по линии связи)';


--
-- Name: voc_msgtype; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_msgtype (
    msgtype_id smallint NOT NULL,
    name character varying(50),
    group_id smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_msgtype OWNER TO coretlx;

--
-- Name: COLUMN voc_msgtype.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN voc_msgtype.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.name IS 'Наименование типа сообщения';


--
-- Name: COLUMN voc_msgtype.group_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.group_id IS 'Идентификатор группы типов';


--
-- Name: voc_receive; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_receive (
    receive_id bigint NOT NULL,
    name character varying(100)
);


ALTER TABLE coretlx.voc_receive OWNER TO coretlx;

--
-- Name: COLUMN voc_receive.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_receive.receive_id IS 'Идентификатор пункта приема';


--
-- Name: COLUMN voc_receive.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_receive.name IS 'Наименование пункта приема (телефон/почта)';


--
-- Name: voc_region_code; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_region_code (
    region_id bigint NOT NULL,
    abc_code character varying(10),
    order_no bigint NOT NULL,
    billing_proc character varying(100),
    contract_proc character varying(100)
);


ALTER TABLE coretlx.voc_region_code OWNER TO coretlx;

--
-- Name: COLUMN voc_region_code.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_region_code.abc_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.abc_code IS 'ABC код региона';


--
-- Name: COLUMN voc_region_code.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.order_no IS 'Номер выборки при определении региона';


--
-- Name: COLUMN voc_region_code.billing_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.billing_proc IS 'Процедура запроса даных в биллинговой системе';


--
-- Name: COLUMN voc_region_code.contract_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.contract_proc IS 'Процедура запроса данных по договору';


--
-- Name: voc_regions; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_regions (
    region_id bigint NOT NULL,
    abc_code character varying(10),
    name character varying(100),
    billing_proc character varying(100),
    note character varying(200),
    location_id bigint,
    time_zone character varying(400)
);


ALTER TABLE coretlx.voc_regions OWNER TO coretlx;

--
-- Name: COLUMN voc_regions.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_regions.abc_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.abc_code IS 'ABC код региона';


--
-- Name: COLUMN voc_regions.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.name IS 'Наименование региона';


--
-- Name: COLUMN voc_regions.billing_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.billing_proc IS 'Процедура запроса даных в биллинговой системе';


--
-- Name: COLUMN voc_regions.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.note IS 'Примечания';


--
-- Name: COLUMN voc_regions.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.location_id IS 'Местоположение для региона';


--
-- Name: COLUMN voc_regions.time_zone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.time_zone IS 'Временная зона для региона';


--
-- Name: voc_send_error; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_send_error (
    error_id smallint NOT NULL,
    description character varying(100)
);


ALTER TABLE coretlx.voc_send_error OWNER TO coretlx;

--
-- Name: COLUMN voc_send_error.error_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_send_error.error_id IS 'Идентификатор ошибки отправки';


--
-- Name: COLUMN voc_send_error.description; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_send_error.description IS 'Описание ошибки';


--
-- Name: voc_siregex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_siregex (
    siregex_id bigint NOT NULL,
    name character varying(200),
    regex character varying(400)
);


ALTER TABLE coretlx.voc_siregex OWNER TO coretlx;

--
-- Name: TABLE voc_siregex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.voc_siregex IS 'Шаблоны для служебных кодограмм';


--
-- Name: COLUMN voc_siregex.siregex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.siregex_id IS 'идентификатор';


--
-- Name: COLUMN voc_siregex.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.name IS 'наименование кодограммы';


--
-- Name: COLUMN voc_siregex.regex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.regex IS 'регулярное выражение';


--
-- Name: voc_tlgprio; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_tlgprio (
    tlgprio_id integer NOT NULL,
    mark character varying(3) NOT NULL,
    note character varying(100),
    prio smallint DEFAULT 500 NOT NULL
);


ALTER TABLE coretlx.voc_tlgprio OWNER TO coretlx;

--
-- Name: COLUMN voc_tlgprio.tlgprio_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.tlgprio_id IS 'Идентификатор приоритета отправки телеграммы';


--
-- Name: COLUMN voc_tlgprio.mark; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.mark IS 'Отметка в служебном заголовке';


--
-- Name: COLUMN voc_tlgprio.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.note IS 'Примечание';


--
-- Name: COLUMN voc_tlgprio.prio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.prio IS 'Числовой приоритет отправки';


--
-- Name: voc_units; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_units (
    unit_id smallint NOT NULL,
    name character varying(50) NOT NULL
);


ALTER TABLE coretlx.voc_units OWNER TO coretlx;

--
-- Name: COLUMN voc_units.unit_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_units.unit_id IS 'Идентификатор тарификационной единицы';


--
-- Name: COLUMN voc_units.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_units.name IS 'Наименование тарификационной единицы';


--
-- Name: voc_weekdays; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_weekdays (
    weekday_id smallint NOT NULL,
    weekday_name character varying(20) NOT NULL,
    swdname character varying(10) NOT NULL
);


ALTER TABLE coretlx.voc_weekdays OWNER TO coretlx;

--
-- Name: COLUMN voc_weekdays.weekday_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.weekday_id IS 'Идентификатор дня недели';


--
-- Name: COLUMN voc_weekdays.weekday_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.weekday_name IS 'Полное наименование дня недели';


--
-- Name: COLUMN voc_weekdays.swdname; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.swdname IS 'Краткое наименование дня недели';


--
-- Data for Name: acc_advice_timeout; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_advice_timeout (advice_timeout_id, advice_id, notified, changed) FROM stdin;
\.


--
-- Data for Name: acc_change; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_change (change_id, level_id, key_table, key_value, ref_table, ref_value, terminal, created) FROM stdin;
\.


--
-- Data for Name: acc_changes; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_changes (change_id, op_code, key_table, ref_table, key_name, ref_name, key_id, ref_id, changed, terminal, session_id) FROM stdin;
\.


--
-- Data for Name: acc_error; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_error (error_id, code_id, error_msg, terminal, created, call_from) FROM stdin;
\.


--
-- Data for Name: acc_errors; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_errors (error_id, code, msg, terminal, created) FROM stdin;
\.


--
-- Data for Name: acc_level; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_level (level_id, level_name, object_name) FROM stdin;
\.


--
-- Data for Name: acc_module_login; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_module_login (module_login_id, module_id, created, v_major, v_minor, v_release, v_build, terminal, u_session_id) FROM stdin;
\.


--
-- Data for Name: acc_operator; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_operator (operator_id, name, created, closed, changed, external_id, login, password, place_id, place_num, parent_id, user_role) FROM stdin;
1	Тестовый оператор	2014-03-25 00:00:00	\N	\N	\N	1	3cdbcbe119058a77e1b3fe1318c42a68	2	\N	\N	2
\.


--
-- Data for Name: acc_user_login; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.acc_user_login (user_login_id, session_id, operator_id, module_id, created, closed, terminal, extension, u_session_id, module_login_id, place_id, place_num, user_role) FROM stdin;
\.


--
-- Data for Name: bill_abocharges; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_abocharges (abocharge_id, cost, extracost, ndscost, note, message_id, created, operator_id, terminal, charge_state_id, our_cost, tarif_id, account_no, bill_contract, our_nds, call_id, chgtype_id) FROM stdin;
\.


--
-- Data for Name: bill_charge_detail; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_charge_detail (message_id, abocharge_id, f_substract, cost, billing_code, price_id, operator_id, f_canceled) FROM stdin;
\.


--
-- Data for Name: bill_discount; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_discount (discount_id, name, discount, period_id, tarif_id, clientcategory_id, created, changed, closed, opened, note, operator_id, oper_id) FROM stdin;
\.


--
-- Data for Name: bill_pay_phone; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_pay_phone (pay_phone_id, aon_phone, abonent_phone, created, changed, closed, note, operator_id) FROM stdin;
\.


--
-- Data for Name: bill_price; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_price (price_id, const, mult, extra, created, closed, min_units, max_units, svckind_id, period_id, clientcategory_id, min_msg, max_msg, service_id, tarif_id, changed, note, opened, charge, by_release, operator_id, region_id, receive_id, billing_code, dest_location_id, is_exclude_dest) FROM stdin;
\.


--
-- Data for Name: bill_service; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_service (service_id, name, created, closed, tarif_id, changed, start_label, end_label, operator_id) FROM stdin;
3833	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3834	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3835	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3836	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3837	Срочная Делюкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3838	Обыкновенная А/Я Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3839	Обыкновенная Заверенная Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3840	Обыкновенная Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3841	Обыкновенная До востреб. Заверенная Копия Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3842	Срочная Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3843	Обыкновенная Люкс Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3844	Срочная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3845	Срочная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3846	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3847	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3848	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3849	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3850	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3851	Обыкновенная До востреб. Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3852	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3853	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3854	Обыкновенная А/Я Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3855	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3856	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3857	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3858	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3859	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3860	Срочная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3861	Срочная До востреб. Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3862	Обыкновенная Копия Люкс Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3863	Срочная Копия Люкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3864	Срочная Копия Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3865	Срочная Люкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3866	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3867	Срочная До востреб. Люкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3868	Срочная Делюкс До востреб.	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3869	Обыкновенная Копия Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3870	Срочная Делюкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3871	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3872	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3873	Обыкновенная До востреб. Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3874	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3875	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3876	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3877	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3878	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3879	Обыкновенная Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3880	Обыкновенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3881	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3882	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3883	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3884	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3830	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3768	Обыкновенная А/Я Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3769	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3770	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3771	Обыкновенная До востреб. Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3772	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3773	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3774	Обыкновенная Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3775	Срочная А/Я Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3776	Срочная А/Я Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3777	Срочная А/Я Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3778	Срочная До востреб. Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3779	Срочная До востреб. Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3780	Срочная До востреб. Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3781	Срочная Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3782	Срочная Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3783	Срочная А/Я Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3784	Срочная Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3785	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3786	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3787	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3788	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3789	Срочная До востреб.	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3790	Срочная До востреб. Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3791	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3792	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3793	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3794	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3795	Обыкновенная Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3796	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3797	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3798	Обыкновенная А/Я	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3799	Обыкновенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3800	Обыкновенная Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3801	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3802	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3803	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3804	Срочная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3805	Срочная Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3806	Срочная Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3807	Срочная До востреб.	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3808	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3809	Срочная А/Я	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3810	Срочная Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3811	Срочная Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3812	Срочная До востреб. Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3813	Обыкновенная Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3814	Срочная До востреб. Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3815	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3816	Обыкновенная А/Я Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3817	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3818	Обыкновенная А/Я Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3819	Обыкновенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3820	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3821	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3822	Обыкновенная А/Я Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3823	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3824	Обыкновенная До востреб. Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3825	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3826	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3827	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3828	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3829	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3742	Обыкновенная До востреб. Заверенная Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3743	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3744	Срочная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3745	Срочная Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3746	Срочная До востреб. Копия Люкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
1209	Простым шрифтом	2009-06-23 10:47:29	\N	60	2009-06-23 10:47:29	Простым шрифтом	\N	618
1210	Простым шрифтом в рамке	2009-06-24 09:28:13	\N	81	2009-06-24 09:28:13	Простым шрифтом в рамке	\N	618
1211	Коммерческое простым шрифтом (вторник, четверг)	2009-06-24 09:30:59	\N	48	2009-06-24 09:50:52	Коммерческое простым шрифтом (вторник, четверг)	\N	618
1212	Некоммерческое простым шрифтом (пятница)	2009-06-24 09:31:14	\N	48	2009-06-24 09:32:15	Некоммерческое простым шрифтом (пятница)	\N	618
5481	Обыкновенная До востреб. Копия Люкс	2010-01-27 16:28:28	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
1213	Некоммерческое простым шрифтом (вторник, четверг)	2009-06-24 09:32:35	\N	48	2009-06-24 09:50:40	Некоммерческое простым шрифтом (вторник, четверг)	\N	618
1214	Коммерческое простым шрифтом (пятница)	2009-06-24 09:32:53	\N	48	2009-06-24 09:32:53	Коммерческое простым шрифтом (пятница)	\N	618
1215	Простым шрифтом	2009-06-24 13:32:09	\N	117	2009-06-24 13:32:09	Простым шрифтом	\N	618
1227	Простым шрифтом	2009-06-24 13:48:50	\N	137	2009-06-24 13:48:50	Простым шрифтом	\N	618
1228	Простым шрифтом	2009-06-24 13:56:14	\N	138	2009-06-24 13:56:14	Простым шрифтом	\N	618
1216	Строка простая	2009-06-25 09:09:44	2009-09-09 08:43:01	118	2009-09-09 08:43:01	Строка простая	\N	36
1217	Строка на подложке (желтый фон)-предлагаю работу	2009-06-25 09:12:39	\N	118	2009-11-12 16:09:37	Строка на подложке (желтый фон)-предлагаю работу	\N	36
1218	Резюме соискателей-простым шрифтом	2009-06-25 09:19:59	2009-09-09 10:56:26	118	2009-09-09 10:56:26	Резюме соискателей-простым шрифтом	\N	36
1219	Резюме соискателей выделенное (желтый фон)	2009-06-25 09:20:30	\N	118	2009-06-25 09:20:30	Резюме соискателей выделенное (желтый фон)	\N	618
1220	Резюме соискателей в рамке	2009-06-25 09:20:47	\N	118	2009-06-25 09:20:47	Резюме соискателей в рамке	\N	618
1229	Мини-модуль	2009-06-25 10:56:46	\N	118	2009-06-25 10:56:46	Мини-модуль	\N	618
1230	Простым шрифтом	2009-06-25 11:47:11	\N	47	2009-06-25 11:47:11	Простым шрифтом	\N	618
1231	Простым шрифтом	2009-06-25 12:25:43	\N	56	2009-06-25 12:25:43	Простым шрифтом	\N	618
1232	Простым шрифтом не по тематике газеты	2009-06-25 12:26:41	\N	56	2009-06-25 12:26:41	Простым шрифтом не по тематике газеты	\N	618
1233	Простым шрифтом	2009-06-25 13:24:08	\N	140	2009-09-17 08:51:14	Простым шрифтом	\N	31
1234	Простым шрифтом	2009-06-25 13:24:51	\N	141	2009-06-25 13:24:51	Простым шрифтом	\N	618
1221	Модуль 12,1/12,2 (понедельник)	2009-06-25 16:15:32	\N	118	2009-06-25 16:15:32	Модуль 12,1/12,2 (понедельник)	\N	618
1222	Модуль 12,1/12,2 (четверг)	2009-06-25 16:15:45	\N	118	2009-06-25 16:15:45	Модуль 12,1/12,2 (четверг)	\N	618
1247	Простым шрифтом	2009-06-29 14:23:39	\N	157	2009-06-29 14:23:39	Простым шрифтом	\N	618
1248	Жирным шрифтом	2009-06-29 14:23:49	\N	157	2011-04-28 11:59:54	Жирным шрифтом	\N	36
1147	Простым шрифтом 	2009-06-16 13:08:18	\N	18	2009-06-24 09:29:25	Простым шрифтом 	\N	618
1148	Простым шрифтом	2009-06-16 16:54:57	\N	19	2009-11-06 12:45:13	Простым шрифтом	\N	36
1149	Заглавными буквами	2009-06-16 16:55:17	\N	19	2009-11-06 12:45:52	Заглавными буквами	\N	36
1167	Простым шрифтом	2009-06-19 15:04:30	\N	97	2009-06-19 15:04:30	Простым шрифтом	\N	\N
1168	Жирным шрифтом	2009-06-19 16:05:27	\N	97	2009-06-19 16:05:27	Жирным шрифтом	\N	\N
1187	Простым шрифтом	2009-06-22 08:48:43	\N	44	2009-06-22 08:48:43	Простым шрифтом	\N	618
1188	Резюме	2009-06-22 08:49:38	\N	44	2009-06-22 08:49:38	Резюме	\N	618
1189	Простым шрифтом - население	2009-06-22 10:48:03	\N	57	2009-06-22 10:48:03	Простым шрифтом - население	\N	618
1190	Простым шрифтом-организации	2009-06-22 10:48:21	\N	57	2009-06-22 10:48:53	Простым шрифтом-организации	\N	618
1191	Полужирным шрифтом - население	2009-06-22 11:07:38	\N	57	2009-06-22 11:07:38	Полужирным шрифтом - население	\N	618
1192	Полужирным шрифтом - организации	2009-06-22 11:07:59	\N	57	2009-06-22 11:07:59	Полужирным шрифтом - организации	\N	618
1193	В рамке - население	2009-06-22 11:08:32	\N	57	2009-06-22 11:08:32	В рамке - население	\N	618
1194	В рамке - организации	2009-06-22 11:09:18	\N	57	2009-06-22 11:09:18	В рамке - организации	\N	618
1195	Простым шрифтом 	2009-06-22 11:35:30	\N	37	2011-10-06 10:07:43	Простым шрифтом 	\N	36
1196	простым шрифтом для организаций	2009-06-22 11:36:03	2010-02-11 13:34:40	37	2010-02-11 13:34:40	простым шрифтом для организаций	\N	36
1197	Простым шрифтом	2009-06-22 12:08:03	\N	43	2009-06-22 12:10:21	Простым шрифтом	\N	618
1198	Транспорт	2009-06-22 12:08:13	2009-06-22 12:10:03	43	2009-06-22 12:10:03	Транспорт	\N	618
1199	Услуги	2009-06-22 12:09:06	2009-06-22 12:10:02	43	2009-06-22 12:10:02	Услуги	\N	618
1200	Животные	2009-06-22 12:09:16	2009-06-22 12:10:01	43	2009-06-22 12:10:01	Животные	\N	618
1201	Работа	2009-06-22 12:09:26	2009-06-22 12:09:59	43	2009-06-22 12:09:59	Работа	\N	618
1202	Разное	2009-06-22 12:09:37	2009-06-22 12:09:57	43	2009-06-22 12:09:57	Разное	\N	618
1203	Простым шрифтом	2009-06-22 12:59:13	\N	53	2009-06-22 12:59:13	Простым шрифтом	\N	618
1204	Простым шрифтом в рамочке	2009-06-22 14:33:40	\N	53	2009-06-22 14:33:40	Простым шрифтом в рамочке	\N	618
1207	Простым шрифтом некоммерческого содержания	2009-06-23 09:48:25	\N	58	2009-06-23 10:02:25	Простым шрифтом некоммерческого содержания	\N	618
1208	Простым шрифтом коммерческого содержания	2009-06-23 09:49:08	\N	58	2010-01-18 09:44:09	Простым шрифтом коммерческого содержания	\N	36
5477	Обыкновенная Заверенная Почтой заказное	2010-01-27 16:26:17	\N	190	2010-01-27 16:26:17	\N	\N	31
5478	Обыкновенная Заверенная Копия Почтой заказное	2010-01-27 16:26:20	\N	190	2010-01-27 16:26:20	\N	\N	31
5479	Обыкновенная Копия Люкс Почтой заказное	2010-01-27 16:27:59	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5480	Обыкновенная До востреб. Люкс	2010-01-27 16:28:25	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
3970	Срочная А/Я	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
5482	Обыкновенная А/Я Копия Люкс	2010-01-27 16:28:34	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5483	Обыкновенная А/Я Люкс	2010-01-27 16:28:37	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5484	Обыкновенная Почтой заказное	2010-01-27 16:31:22	\N	185	2010-01-27 16:31:22	\N	\N	31
5485	Обыкновенная Копия Почтой заказное	2010-01-27 16:31:27	\N	185	2010-01-27 16:31:27	\N	\N	31
5486	Обыкновенная Заверенная Почтой заказное	2010-01-27 16:32:18	\N	185	2010-01-27 16:32:18	\N	\N	31
5487	Обыкновенная Заверенная Копия Почтой заказное	2010-01-27 16:32:20	\N	185	2010-01-27 16:32:20	\N	\N	31
5488	Срочная	2010-01-27 16:32:58	\N	185	2010-01-27 16:32:58	\N	\N	31
5489	Срочная Копия	2010-01-27 16:33:05	\N	185	2010-01-27 16:33:05	\N	\N	31
5490	Срочная Заверенная	2010-01-27 16:33:14	\N	185	2010-01-27 16:33:14	\N	\N	31
5491	Срочная До востреб.	2010-01-27 16:33:21	\N	185	2010-01-27 16:33:21	\N	\N	31
5492	Срочная До востреб. Копия	2010-01-27 16:33:26	\N	185	2010-01-27 16:33:26	\N	\N	31
5493	Срочная Заверенная Копия	2010-01-27 16:33:31	\N	185	2010-01-27 16:33:31	\N	\N	31
5494	Обыкновенная Почтой заказное	2010-01-27 16:35:07	\N	186	2010-01-27 16:35:07	\N	\N	31
5495	Обыкновенная Копия Почтой заказное	2010-01-27 16:35:10	\N	186	2010-01-27 16:35:10	\N	\N	31
5496	Обыкновенная Заверенная Почтой заказное	2010-01-27 16:35:21	\N	186	2010-01-27 16:35:21	\N	\N	31
5497	Обыкновенная Заверенная Копия Почтой заказное	2010-01-27 16:35:23	\N	186	2010-01-27 16:35:23	\N	\N	31
5498	Обыкновенная Копия Люкс Почтой заказное	2010-01-27 16:35:27	\N	186	2010-01-27 16:35:27	\N	\N	31
5499	Обыкновенная Люкс Почтой заказное	2010-01-27 16:35:30	\N	186	2010-01-27 16:35:30	\N	\N	31
5500	Срочная Копия Люкс	2010-01-27 16:37:06	\N	187	2010-01-27 16:37:06	\N	\N	31
5501	Срочная Люкс	2010-01-27 16:37:15	\N	187	2010-01-27 16:37:15	\N	\N	31
5507	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 10:58:23	\N	191	2010-01-28 10:58:23	\N	\N	31
5508	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 10:58:32	\N	191	2010-01-28 10:58:32	\N	\N	31
5509	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 10:58:37	\N	191	2010-01-28 10:58:37	\N	\N	31
5510	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 10:58:40	\N	191	2010-01-28 10:58:40	\N	\N	31
5511	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 10:59:09	\N	190	2010-01-28 10:59:09	\N	\N	31
5512	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 10:59:13	\N	190	2010-01-28 10:59:13	\N	\N	31
5513	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 10:59:23	\N	190	2010-01-28 10:59:23	\N	\N	31
5514	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 10:59:25	\N	190	2010-01-28 10:59:25	\N	\N	31
5515	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 10:59:36	\N	193	2010-01-28 10:59:36	\N	\N	31
5516	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 10:59:39	\N	193	2010-01-28 10:59:39	\N	\N	31
5517	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 10:59:43	\N	193	2010-01-28 10:59:43	\N	\N	31
5518	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 10:59:46	\N	193	2010-01-28 10:59:46	\N	\N	31
5519	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 10:59:59	\N	177	2010-01-28 10:59:59	\N	\N	31
5520	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:00:01	\N	177	2010-01-28 11:00:01	\N	\N	31
5521	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:00:20	\N	177	2010-01-28 11:00:20	\N	\N	31
5522	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:00:23	\N	177	2010-01-28 11:00:23	\N	\N	31
5523	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:00:30	\N	177	2010-01-28 11:00:30	\N	\N	31
5524	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:00:32	\N	177	2010-01-28 11:00:32	\N	\N	31
3950	Обыкновенная Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3951	Обыкновенная	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3952	Обыкновенная А/Я	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3953	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3954	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3955	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3956	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3957	Обыкновенная А/Я Люкс	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3958	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3959	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3960	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3961	Обыкновенная До востреб. Копия	2009-06-30 15:59:11	\N	180	2009-06-30 15:59:11	\N	\N	\N
3962	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3963	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3964	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3965	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3966	Обыкновенная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3967	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3968	Обыкновенная Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3969	Срочная	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3971	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3972	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3973	Срочная А/Я Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3974	Срочная А/Я Копия Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3975	Срочная А/Я Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3976	Срочная До востреб.	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3977	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3978	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3979	Срочная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3980	Срочная До востреб. Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3981	Срочная До востреб. Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3982	Срочная Заверенная	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3983	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3984	Срочная Копия Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3985	Срочная Люкс	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3986	Срочная Копия	2009-06-30 15:59:12	\N	180	2009-06-30 15:59:12	\N	\N	\N
3987	Обыкновенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3988	Обыкновенная А/Я	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3989	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3990	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3991	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3992	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3993	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3994	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3995	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3996	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3997	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3998	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3999	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4000	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4001	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3948	Обыкновенная Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
4002	Обыкновенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4003	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4004	Обыкновенная Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4005	Срочная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4006	Срочная А/Я	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4007	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4008	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4009	Срочная А/Я Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4010	Срочная А/Я Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4011	Срочная А/Я Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4012	Срочная До востреб.	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4013	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
3885	Обыкновенная А/Я Делюкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3886	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3887	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3888	Обыкновенная А/Я Люкс Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3889	Обыкновенная А/Я Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3890	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3891	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3892	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3893	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3894	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3895	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3896	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3897	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3898	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3899	Обыкновенная А/Я Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3900	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3901	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3902	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3903	Срочная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3904	Срочная А/Я Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3905	Срочная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3906	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3907	Срочная До востреб. Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3908	Срочная А/Я Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3909	Срочная А/Я Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3910	Срочная А/Я	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3911	Срочная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3912	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3913	Обыкновенная Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3914	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3915	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3916	Срочная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3917	Срочная А/Я Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3918	Срочная А/Я Заверенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3919	Срочная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3920	Срочная А/Я Копия	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3921	Срочная А/Я Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3922	Срочная А/Я Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3923	Срочная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3924	Срочная До востреб. Люкс	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3925	Обыкновенная А/Я Заверенная Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3926	Обыкновенная А/Я Заверенная Копия Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3927	Обыкновенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3928	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3929	Обыкновенная А/Я	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3930	Обыкновенная До востреб. Копия Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3931	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3932	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3933	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3934	Обыкновенная А/Я	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3935	Обыкновенная А/Я	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3936	Обыкновенная А/Я	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3937	Обыкновенная	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3938	Обыкновенная	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3939	Обыкновенная	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3940	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3941	Обыкновенная Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3942	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3943	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3944	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3945	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	179	2009-06-30 15:59:11	\N	\N	\N
3946	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
3947	Обыкновенная Заверенная Копия	2009-06-30 15:59:11	\N	191	2009-06-30 15:59:11	\N	\N	\N
3831	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3832	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
4220	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
5525	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:00:35	\N	177	2010-01-28 11:00:35	\N	\N	31
5526	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:00:39	\N	177	2010-01-28 11:00:39	\N	\N	31
5527	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:00:59	\N	193	2010-01-28 11:00:59	\N	\N	31
5528	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:01:01	\N	193	2010-01-28 11:01:01	\N	\N	31
5170	Модуль 1/32 (полноцвет) СРЕДА	2009-11-20 14:47:29	\N	457	2009-11-20 14:47:29	Модуль 1/32 (полноцвет) СРЕДА	\N	36
5171	Благодарность	2009-11-20 15:14:20	\N	457	2009-11-20 15:14:20	Благодарность	\N	36
5187	Белым по черному - население	2009-11-30 10:42:40	\N	57	2009-11-30 10:43:09	Белым по черному - население	\N	36
5188	Белым по черному - организации	2009-11-30 10:43:01	\N	57	2009-11-30 10:43:01	Белым по черному - организации	\N	36
5207	Заглавными буквами	2009-11-30 15:36:30	\N	157	2009-11-30 15:36:30	Заглавными буквами	\N	36
5208	Простым шрифтом в рамочке	2009-11-30 15:36:48	\N	157	2009-11-30 15:36:48	Простым шрифтом в рамочке	\N	36
5227	Простым шрифтом	2009-12-07 13:57:13	\N	477	2009-12-07 13:57:13	Простым шрифтом	\N	36
5247	Простым шрифтом на 4 выпуска	2009-12-09 13:52:06	\N	497	2009-12-09 13:57:21	Простым шрифтом на 4 выпуска	\N	36
5267	Модуль 4,5 х 3 см	2009-12-11 08:51:31	\N	497	2009-12-11 10:53:25	Модуль 4,5 х 3 см	\N	36
5268	Модуль 9 х 2 см	2009-12-11 08:51:48	\N	497	2009-12-11 10:53:32	Модуль 9 х 2 см	\N	36
5269	Модуль 4,5 х 4,5 см	2009-12-11 08:52:14	\N	497	2009-12-11 10:53:41	Модуль 4,5 х 4,5 см	\N	36
5270	Модуль 4,5 х 6 см	2009-12-11 08:52:29	\N	497	2009-12-11 10:53:48	Модуль 4,5 х 6 см	\N	36
5287	Модуль 9 х 2 см	2009-12-11 09:54:31	\N	517	2009-12-11 10:52:43	Модуль 9 х 2 см	\N	36
5288	Модуль 4,5 х 3 см	2009-12-11 09:54:44	\N	517	2009-12-11 10:52:51	Модуль 4,5 х 3 см	\N	36
5289	Модуль 4,5 х 4,5 см	2009-12-11 09:54:57	\N	517	2009-12-11 10:53:00	Модуль 4,5 х 4,5 см	\N	36
5290	Модуль 4,5 х 6 см	2009-12-11 09:55:08	\N	517	2009-12-11 10:53:11	Модуль 4,5 х 6 см	\N	36
5307	Обыкновенная Копия Служ. запрос част	2009-12-15 11:05:25	\N	187	2009-12-15 11:05:25	\N	\N	31
5308	Обыкновенная Копия Служ. запрос пред	2009-12-15 11:05:31	\N	187	2009-12-15 11:05:31	\N	\N	31
5327	Простым шрифтом	2009-12-17 08:49:18	\N	537	2009-12-17 08:49:18	Простым шрифтом	\N	36
5328	Простым шрифтом	2009-12-17 12:01:03	\N	557	2009-12-17 12:01:03	Простым шрифтом	\N	36
5329	Знакомства	2009-12-17 12:11:08	\N	557	2009-12-17 12:11:08	Знакомства	\N	36
5347	Простым шрифтом	2009-12-17 16:41:15	\N	558	2009-12-17 16:41:15	Простым шрифтом	\N	36
5348	Знакомства	2009-12-17 16:41:23	\N	558	2009-12-17 16:41:23	Знакомства	\N	36
5367	Обыкновенная Почтой заказное	2010-01-04 17:04:17	\N	179	2010-01-04 17:04:17	\N	\N	31
5368	Обыкновенная Копия Почтой заказное	2010-01-04 17:04:22	\N	179	2010-01-04 17:04:22	\N	\N	31
5369	Обыкновенная Заверенная Копия Почтой заказное	2010-01-04 17:04:43	\N	179	2010-01-04 17:04:43	\N	\N	31
5370	Обыкновенная Заверенная Почтой заказное	2010-01-04 17:04:46	\N	179	2010-01-04 17:04:46	\N	\N	31
5371	Обыкновенная Почтой заказное	2010-01-04 17:10:07	\N	180	2010-01-04 17:10:07	\N	\N	31
5372	Обыкновенная Копия Почтой заказное	2010-01-04 17:10:13	\N	180	2010-01-04 17:10:13	\N	\N	31
5373	Обыкновенная Копия Люкс Почтой заказное	2010-01-04 17:10:20	\N	180	2010-01-04 17:10:20	\N	\N	31
5374	Обыкновенная Люкс Почтой заказное	2010-01-04 17:10:25	\N	180	2010-01-04 17:10:25	\N	\N	31
5375	Обыкновенная Почтой заказное	2010-01-04 18:02:29	\N	182	2010-01-04 18:02:29	\N	\N	31
5376	Обыкновенная Люкс Почтой заказное	2010-01-04 18:02:33	\N	182	2010-01-04 18:02:33	\N	\N	31
5377	Обыкновенная Копия Люкс Почтой заказное	2010-01-04 18:02:37	\N	182	2010-01-04 18:02:37	\N	\N	31
5387	Обыкновенная	2010-01-15 12:23:37	\N	578	2010-01-15 12:23:37	\N	\N	31
5388	Обыкновенная	2010-01-15 12:23:50	\N	577	2010-01-15 12:23:50	\N	\N	31
5448	Правительственная	2010-01-22 12:54:50	\N	578	2010-01-22 12:54:50	\N	\N	31
5449	Правительственная	2010-01-22 12:55:06	\N	577	2010-01-22 12:55:06	\N	\N	31
5467	Обыкновенная Заверенная Почтой заказное	2010-01-27 16:17:39	\N	189	2010-01-27 16:17:39	\N	\N	31
5468	Обыкновенная Заверенная Копия Почтой заказное	2010-01-27 16:17:42	\N	189	2010-01-27 16:17:42	\N	\N	31
5469	Обыкновенная Люкс Почтой заказное	2010-01-27 16:18:08	\N	189	2010-01-27 16:18:08	\N	\N	31
5470	Обыкновенная Копия Люкс Почтой заказное	2010-01-27 16:18:11	\N	189	2010-01-27 16:18:11	\N	\N	31
5471	Обыкновенная Почтой заказное	2010-01-27 16:18:27	\N	189	2010-01-27 16:18:27	\N	\N	31
5472	Обыкновенная Копия Почтой заказное	2010-01-27 16:18:34	\N	189	2010-01-27 16:18:34	\N	\N	31
5473	Обыкновенная Заверенная Почтой заказное	2010-01-27 16:24:23	\N	191	2010-01-27 16:24:23	\N	\N	31
5474	Обыкновенная Заверенная Копия Почтой заказное	2010-01-27 16:24:27	\N	191	2010-01-27 16:24:27	\N	\N	31
5475	Обыкновенная Почтой заказное	2010-01-27 16:25:58	\N	191	2010-01-27 16:25:58	\N	\N	31
5476	Обыкновенная Копия Почтой заказное	2010-01-27 16:26:02	\N	191	2010-01-27 16:26:02	\N	\N	31
5008	Простым шрифтом в рамке	2009-09-30 11:00:26	\N	317	2009-09-30 11:00:26	Простым шрифтом в рамке	\N	36
5009	Жирным шрифтом	2009-09-30 11:00:41	\N	317	2009-09-30 11:00:41	Жирным шрифтом	\N	36
5010	На цветном фоне	2009-09-30 11:01:13	\N	317	2009-09-30 11:01:13	На цветном фоне	\N	36
5027	Выделенным шрифтом	2009-10-12 14:07:47	\N	337	2009-10-12 14:07:47	Выделенным шрифтом	\N	36
5047	 Простым шрифтом	2009-10-16 14:54:19	\N	357	2012-03-29 08:44:51	Простым шрифтом	\N	36
5048	Подписка на 1 полугодие МАРТ-ИЮНЬ 2014 (с доставкой)	2009-10-16 14:57:03	\N	357	2014-01-21 10:53:01	Подписка на 1 полугодие МАРТ-ИЮНЬ 2014 (с доставкой)	\N	36
5049	Подписка на 1 полугодие (без доставки)	2009-10-16 14:57:20	\N	357	2012-10-12 11:30:56	Подписка на 1 полугодие (без доставки)	\N	36
5067	Простым шрифтом	2009-10-26 11:13:32	\N	377	2009-10-26 11:13:32	Простым шрифтом	\N	36
5087	Мониторы в здании автовокзала/месяц	2009-10-28 13:46:48	\N	397	2009-10-29 10:55:12	Мониторы в здании автовокзала/месяц	\N	36
5088	Рекламный пакет в 30 машинах/месяц	2009-10-28 13:47:04	\N	397	2009-10-29 10:55:29	Рекламный пакет в 30 машинах/месяц	\N	36
5089	Эфир с 09.00 до 13.00 - 1 выход	2009-10-28 16:15:28	\N	398	2009-10-28 16:15:28	Эфир с 09.00 до 13.00 - 1 выход	\N	36
5090	Эфир с 09.00 до 13.00 - 2 выхода	2009-10-28 16:16:24	\N	398	2009-10-28 16:16:24	Эфир с 09.00 до 13.00 - 2 выхода	\N	36
5091	Эфир с 09.00 до 13.00 - 3 выхода	2009-10-28 16:16:38	\N	398	2009-10-28 16:16:38	Эфир с 09.00 до 13.00 - 3 выхода	\N	36
5092	Эфир с 09.00 до 13.00 - 4 выхода	2009-10-28 16:16:49	\N	398	2009-10-28 16:16:49	Эфир с 09.00 до 13.00 - 4 выхода	\N	36
5093	Эфир с 09.00 до 13.00 - 5 выходов	2009-10-28 16:17:03	\N	398	2009-10-28 16:17:03	Эфир с 09.00 до 13.00 - 5 выходов	\N	36
5094	Эфир с 09.00 до 13.00 - 6 выходов	2009-10-28 16:17:11	\N	398	2009-10-28 16:17:11	Эфир с 09.00 до 13.00 - 6 выходов	\N	36
5095	Эфир с 09.00 до 13.00 - 7 выходов	2009-10-28 16:17:23	\N	398	2009-10-28 16:17:23	Эфир с 09.00 до 13.00 - 7 выходов	\N	36
5096	Эфир с 09.00 до 13.00 - 8 выходов	2009-10-28 16:17:32	\N	398	2009-10-28 16:17:32	Эфир с 09.00 до 13.00 - 8 выходов	\N	36
5097	Эфир с 09.00 до 13.00 - 9 выходов	2009-10-28 16:17:41	\N	398	2009-10-28 16:17:41	Эфир с 09.00 до 13.00 - 9 выходов	\N	36
4375	Обыкновенная Копия Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
5098	Эфир с 09.00 до 13.00 - 10 выходов	2009-10-28 16:17:48	\N	398	2009-10-28 16:17:58	Эфир с 09.00 до 13.00 - 10 выходов	\N	36
5099	Эфир с 20.00 до 21.00 - 1 выход	2009-10-28 16:18:28	\N	398	2009-10-28 16:18:28	Эфир с 20.00 до 21.00 - 1 выход	\N	36
5100	Эфир с 20.00 до 21.00 - 2 выхода	2009-10-28 16:18:36	\N	398	2009-10-28 16:18:59	Эфир с 20.00 до 21.00 - 2 выхода	\N	36
5101	Эфир с 20.00 до 21.00 - 3 выхода	2009-10-28 16:19:04	\N	398	2009-10-28 16:19:17	Эфир с 20.00 до 21.00 - 3 выхода	\N	36
5102	1 машина/месяц	2009-10-29 10:55:45	\N	397	2009-10-29 10:55:45	1 машина/месяц	\N	36
5107	Простым шрифтом от частных лиц	2009-11-16 08:52:43	\N	417	2009-11-16 08:52:43	Простым шрифтом от частных лиц	\N	36
5108	Простым шрифтом от огранизаций	2009-11-16 08:53:24	\N	417	2009-11-16 08:53:24	Простым шрифтом от огранизаций	\N	36
5127	Некролог для частных лиц 	2009-11-16 11:42:47	\N	417	2009-11-16 11:43:57	Некролог для частных лиц 	\N	36
5128	Некролог для организаций	2009-11-16 11:44:11	\N	417	2009-11-16 11:44:11	Некролог для организаций	\N	36
5147	Реклама, объявления (для физических лиц)	2009-11-17 10:08:06	\N	437	2009-11-17 10:09:51	Реклама, объявления (для физических лиц)	\N	36
5148	Реклама, объявления (для юридических лиц)	2009-11-17 10:08:42	\N	437	2009-11-17 10:10:16	Реклама, объявления (для юридических лиц)	\N	36
5149	Благодарность (для физических лиц)	2009-11-17 10:09:35	\N	437	2009-11-17 10:09:35	Благодарность (для физических лиц)	\N	36
5150	Благодарность (для юридических лиц)	2009-11-17 10:10:38	\N	437	2009-11-17 10:10:38	Благодарность (для юридических лиц)	\N	36
5151	Поздравление (для физических лиц)	2009-11-17 10:21:59	\N	437	2009-11-17 10:21:59	Поздравление (для физических лиц)	\N	36
5152	Поздравление (для юридических лиц)	2009-11-17 10:22:27	\N	437	2009-11-17 10:22:27	Поздравление (для юридических лиц)	\N	36
5167	Выделенным шрифтом (строчное) СРЕДА	2009-11-20 14:37:07	\N	457	2009-11-20 14:38:30	Выделенным шрифтом (строчное) СРЕДА	\N	36
5168	Модуль 1/32 (ч/б)  СРЕДА	2009-11-20 14:45:46	\N	457	2009-11-20 14:46:17	Модуль 1/32 (ч/б)  СРЕДА	\N	36
5169	Модуль 1/32 (ч/б)  ПЯТНИЦА	2009-11-20 14:46:07	\N	457	2009-11-20 14:46:23	Модуль 1/32 (ч/б)  ПЯТНИЦА	\N	36
4867	Обыкновенная Заверенная Служ. запрос пред	2009-08-04 11:24:07	\N	192	2009-08-04 11:24:07	\N	\N	31
4868	Обыкновенная Копия Служ. запрос пред	2009-08-07 12:29:18	\N	183	2009-08-07 12:29:18	\N	\N	31
4887	Срочная Служ. запрос пред	2009-08-18 15:10:33	\N	192	2009-08-18 15:10:33	\N	\N	34
4888	Срочная Служ. запрос част	2009-08-18 15:10:49	\N	192	2009-08-18 15:10:49	\N	\N	34
4907	Простым шрифтом	2009-08-26 13:56:32	\N	237	2009-08-26 13:56:47	Простым шрифтом	\N	36
4908	Заглавными буквами	2009-08-26 13:57:09	\N	237	2009-08-26 13:57:09	Заглавными буквами	\N	36
4927	Простым шрифтом	2009-09-01 13:27:47	\N	257	2009-09-01 13:27:47	Простым шрифтом	\N	36
4928	Заглавными буквами	2009-09-01 13:28:02	\N	257	2009-09-01 13:28:02	Заглавными буквами	\N	36
4947	Эфир с 08.30 до 19.00 - 1 выход	2009-09-21 08:56:25	\N	277	2009-09-22 09:35:41	Эфир с 08.30 до 19.00 - 1 выход	\N	36
4948	Эфир с 20.00 до 23.00 - 1 выход	2009-09-21 08:56:44	\N	277	2009-09-21 16:50:23	Эфир с 20.00 до 23.00 - 1 выход	\N	36
4949	Эфир с 08.30 до 19.00 - 2 выхода 	2009-09-21 16:50:05	\N	277	2009-09-21 16:50:05	Эфир с 08.30 до 19.00 - 2 выхода 	\N	36
4950	Эфир с 08.30 до 19.00 - 3 выхода	2009-09-22 10:09:31	\N	277	2009-09-22 11:53:25	Эфир с 08.30 до 19.00 - 3 выхода	\N	36
4951	Эфир с 08.30 до 19.00 - 4 выхода	2009-09-22 10:09:43	\N	277	2009-09-22 11:53:38	Эфир с 08.30 до 19.00 - 4 выхода	\N	36
4952	Эфир с 08.30 до 19.00 - 5 выходов	2009-09-22 10:09:53	\N	277	2009-09-22 11:53:48	Эфир с 08.30 до 19.00 - 5 выходов	\N	36
4953	Эфир с 08.30 до 19.00 - 6 выходов	2009-09-22 10:47:14	\N	277	2009-09-22 11:53:57	Эфир с 08.30 до 19.00 - 6 выходов	\N	36
4954	Эфир с 08.30 до 19.00 - 7 выходов	2009-09-22 10:47:21	\N	277	2009-09-23 11:02:22	Эфир с 08.30 до 19.00 - 7 выходов	\N	31
4955	Эфир с 20.00 до 23.00 - 6 выходов	2009-09-22 11:05:18	\N	277	2009-09-23 11:01:32	Эфир с 20.00 до 23.00 - 6 выходов	\N	31
4956	Эфир с 20.00 до 23.00 - 5 выходов	2009-09-22 11:05:35	\N	277	2009-09-22 11:05:35	Эфир с 20.00 до 23.00 - 5 выходов	\N	36
4957	Эфир с 20.00 до 23.00 - 4 выхода	2009-09-22 11:05:53	\N	277	2009-09-22 11:05:53	Эфир с 20.00 до 23.00 - 4 выхода	\N	36
4958	Эфир с 20.00 до 23.00 - 3 выхода	2009-09-22 11:06:09	\N	277	2009-09-22 11:06:09	Эфир с 20.00 до 23.00 - 3 выхода	\N	36
4959	Эфир с 20.00 до 23.00 - 2 выхода	2009-09-22 11:06:18	\N	277	2009-09-22 11:06:18	Эфир с 20.00 до 23.00 - 2 выхода	\N	36
4960	ПАКЕТНОЕ размещение (на 8 выходов)	2009-09-22 11:41:00	\N	277	2009-09-23 11:04:29	ПАКЕТНОЕ размещение (на 8 выходов)	\N	31
4961	Эфир с 20.00 до 23.00 - 7 выходов	2009-09-23 11:01:43	\N	277	2009-09-23 11:01:43	Эфир с 20.00 до 23.00 - 7 выходов	\N	31
4962	Эфир с 20.00 до 23.00 - 8 выходов	2009-09-23 11:02:16	\N	277	2009-09-23 11:03:18	Эфир с 20.00 до 23.00 - 8 выходов	\N	31
4963	Эфир с 08.30 до 19.00 - 8 выходов	2009-09-23 11:02:33	\N	277	2009-09-23 11:02:33	Эфир с 08.30 до 19.00 - 8 выходов	\N	31
4964	Эфир с 08.30 до 19.00 - 9 выходов	2009-09-23 11:02:59	\N	277	2009-09-23 11:02:59	Эфир с 08.30 до 19.00 - 9 выходов	\N	31
4965	Эфир с 08.30 до 19.00 - 10 выходов	2009-09-23 11:03:12	\N	277	2009-09-23 11:03:12	Эфир с 08.30 до 19.00 - 10 выходов	\N	31
4966	Эфир с 20.00 до 23.00 - 9 выходов	2009-09-23 11:03:30	\N	277	2009-09-23 11:03:30	Эфир с 20.00 до 23.00 - 9 выходов	\N	31
4967	Эфир с 20.00 до 23.00 - 10 выходов	2009-09-23 11:03:42	\N	277	2009-09-23 11:03:42	Эфир с 20.00 до 23.00 - 10 выходов	\N	31
4987	Простым шрифтом	2009-09-29 10:37:00	\N	297	2009-09-29 10:37:00	Простым шрифтом	\N	36
4988	Заглавными буквами	2009-09-29 10:37:14	\N	297	2009-09-29 10:38:33	Заглавными буквами	\N	36
4989	Простым шрифтом	2009-09-29 10:37:41	\N	299	2009-09-29 10:37:41	Простым шрифтом	\N	36
4990	Заглавными буквами	2009-09-29 10:38:22	\N	299	2009-09-29 10:38:22	Заглавными буквами	\N	36
4991	Цветной фон	2009-09-29 11:14:43	\N	297	2009-09-29 11:14:43	Цветной фон	\N	36
4992	Простым шрифтом	2009-09-29 11:15:02	\N	300	2009-09-29 11:15:02	Простым шрифтом	\N	36
4993	Заглавными буквами	2009-09-29 11:15:16	\N	300	2009-09-29 11:15:16	Заглавными буквами	\N	36
4994	Цветной фон	2009-09-29 11:15:28	\N	300	2009-09-29 11:15:28	Цветной фон	\N	36
4995	Цветной фон	2009-09-29 11:18:00	\N	299	2009-09-29 11:18:00	Цветной фон	\N	36
4996	Цветной фон	2009-09-29 11:18:12	\N	301	2009-09-29 11:18:12	Цветной фон	\N	36
4997	Простым шрифтом	2009-09-29 11:18:22	\N	301	2009-09-29 11:18:22	Простым шрифтом	\N	36
4998	Заглавными буквами	2009-09-29 11:18:34	\N	301	2009-09-29 11:18:34	Заглавными буквами	\N	36
5007	Простым шрифтом	2009-09-30 10:58:56	\N	317	2009-09-30 10:58:56	Простым шрифтом	\N	36
4767	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4768	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4769	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:15	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
4770	Обыкновенная Копия Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4771	Обыкновенная Копия Почтой заказное Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4772	Обыкновенная Копия Почтой заказное Служ. запрос пред	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4773	Обыкновенная Люкс Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4774	Обыкновенная Люкс Служ. запрос пред	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4775	Обыкновенная Копия Люкс Служ. запрос пред	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4776	Обыкновенная Люкс Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4777	Обыкновенная Копия Люкс Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4778	Обыкновенная Служ. запрос пред	2009-06-30 15:59:15	\N	185	2009-06-30 15:59:15	\N	\N	\N
4779	Обыкновенная Копия Служ. запрос пред	2009-06-30 15:59:15	\N	185	2009-06-30 15:59:15	\N	\N	\N
4780	Обыкновенная А/Я Служ. запрос пред	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4781	Обыкновенная А/Я Копия Служ. запрос пред	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4782	Обыкновенная А/Я Копия Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4783	Обыкновенная А/Я Служ. запрос част	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4784	Обыкновенная Копия Служ. запрос част	2009-06-30 15:59:15	\N	188	2009-06-30 15:59:15	\N	\N	\N
4785	Обыкновенная Копия Почтой заказное Служ. запрос част	2009-06-30 15:59:15	\N	188	2009-06-30 15:59:15	\N	\N	\N
4786	Обыкновенная Копия Служ. запрос пред	2009-06-30 15:59:15	\N	188	2009-06-30 15:59:15	\N	\N	\N
4787	Обыкновенная Копия Почтой заказное Служ. запрос пред	2009-06-30 15:59:15	\N	188	2009-06-30 15:59:15	\N	\N	\N
4788	Обыкновенная Копия Служ. запрос част	2009-07-01 13:01:41	\N	178	2009-07-01 13:01:41	\N	\N	34
4789	Обыкновенная Копия Служ. запрос пред	2009-07-01 13:02:01	\N	178	2009-07-01 13:02:01	\N	\N	34
4790	Обыкновенная Люкс/М Служ. запрос част	2009-07-01 13:04:09	\N	192	2009-07-01 13:04:09	\N	\N	34
4791	Обыкновенная Люкс/М Служ. запрос пред	2009-07-01 13:04:34	\N	192	2009-07-01 13:04:34	\N	\N	34
4792	Обыкновенная Вручить (дата) Копия	2009-07-01 13:32:52	\N	192	2009-07-01 13:32:52	\N	\N	221
4793	Обыкновенная Почтой заказное Служ. запрос пред	2009-07-01 13:34:35	\N	188	2009-07-01 13:34:35	\N	\N	221
4794	Обыкновенная Почтой заказное Служ. запрос част	2009-07-01 13:34:57	\N	188	2009-07-01 13:34:57	\N	\N	221
4807	Простым шрифтом	2009-07-06 15:21:48	\N	197	2009-07-06 15:21:48	Простым шрифтом	\N	618
4808	Простым шрифтом в рамке	2009-07-06 15:33:49	\N	197	2009-07-06 15:33:49	Простым шрифтом в рамке	\N	618
4809	Простым шрифтом	2009-07-07 11:21:10	\N	54	2009-07-07 11:22:03	Простым шрифтом	\N	618
4810	Жирным шрифтом	2009-07-07 11:21:23	\N	54	2009-07-07 11:22:19	Жирным шрифтом	\N	618
4811	Простым шрифтом в рамке	2009-07-07 11:21:37	\N	54	2009-07-07 11:21:37	Простым шрифтом в рамке	\N	618
4812	Жирным шрифтом в рамке	2009-07-07 11:21:50	2009-07-07 13:28:54	54	2009-07-07 13:28:54	Жирным шрифтом в рамке	\N	618
4813	Простым шрифтом в рамке+ цветная подложка (фон)	2009-07-07 11:22:51	\N	54	2009-07-07 11:22:51	Простым шрифтом в рамке+ цветная подложка (фон)	\N	618
4814	Жирным шрифтом в рамке+ цветная подложка (фон)	2009-07-07 11:23:02	2009-07-07 13:28:57	54	2009-07-07 13:28:57	Жирным шрифтом в рамке+ цветная подложка (фон)	\N	618
4815	Простым шрифтом	2009-07-07 13:22:01	\N	198	2009-07-07 13:22:01	Простым шрифтом	\N	618
4816	Простым шрифтом в рамке	2009-07-07 13:22:10	\N	198	2009-07-07 13:22:10	Простым шрифтом в рамке	\N	618
4817	Простым шрифтом в рамке + цветная подложка (фон)	2009-07-07 13:22:41	\N	198	2009-07-07 13:22:41	Простым шрифтом в рамке + цветная подложка (фон)	\N	618
4818	Жирным шрифтом в рамке + цветная подложка (фон)	2009-07-07 13:22:51	2009-07-07 13:28:23	198	2009-07-07 13:28:23	Жирным шрифтом в рамке + цветная подложка (фон)	\N	618
4819	Жирным шрифтом в рамке 	2009-07-07 13:23:04	2009-07-07 13:28:30	198	2009-07-07 13:28:30	Жирным шрифтом в рамке 	\N	618
4820	Жирным шрифтом 	2009-07-07 13:23:16	\N	198	2009-07-07 13:23:16	Жирным шрифтом 	\N	618
4821	Обыкновенная Копия Служ. запрос част	2009-07-09 17:45:06	\N	177	2009-07-09 17:45:06	\N	\N	31
4827	Простым шрифтом	2009-07-16 13:37:22	\N	217	2009-07-16 13:37:29	Простым шрифтом	\N	618
4847	Обыкновенная Копия Служ. запрос пред	2009-07-30 14:09:41	\N	180	2009-07-30 14:09:41	\N	\N	31
4848	Обыкновенная Копия Служ. запрос част	2009-07-30 14:11:33	\N	180	2009-07-30 14:11:33	\N	\N	31
3949	Обыкновенная Копия	2009-06-30 15:59:11	\N	190	2009-06-30 15:59:11	\N	\N	\N
4438	Обыкновенная Люкс/М Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4439	Обыкновенная Копия Люкс/М Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4440	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4441	Обыкновенная Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4442	Срочная Перевод	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4443	Срочная Перевод Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4444	Срочная Перевод Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4445	Правительственная Увед. простое Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4446	Правительственная Увед. срочное Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4447	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4448	Обыкновенная До востреб. ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4449	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4450	Обыкновенная Запрос-увед. част	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4451	Обыкновенная Запрос-увед. пред	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4452	Обыкновенная Копия част	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4453	Обыкновенная Копия пред	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4454	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	182	2009-06-30 15:59:13	\N	\N	\N
4455	Обыкновенная Копия Увед. простое ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4456	Обыкновенная Увед. простое ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4457	Обыкновенная До востреб. Копия ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4458	Обыкновенная Люкс/И Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4459	Обыкновенная Увед. срочное ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4460	Обыкновенная Копия Увед. срочное ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4461	Обыкновенная Вручить (дата) ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4462	Обыкновенная Копия Вручить (дата) ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4463	Обыкновенная Копия Люкс/И Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4464	Срочная ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4465	Срочная Копия ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4466	Срочная А/Я ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4467	Срочная А/Я Копия ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4468	Срочная До востреб. Копия ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4469	Срочная До востреб. ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4470	Срочная Увед. простое ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4471	Срочная Копия Увед. простое ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4472	Срочная Увед. срочное ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4473	Срочная Копия Увед. срочное ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4474	Срочная Копия Вручить (дата) ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4475	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	188	2009-06-30 15:59:13	\N	\N	\N
4476	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	188	2009-06-30 15:59:13	\N	\N	\N
4477	Обыкновенная Почтой заказное ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4478	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	182	2009-06-30 15:59:13	\N	\N	\N
4479	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	184	2009-06-30 15:59:13	\N	\N	\N
4480	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	184	2009-06-30 15:59:13	\N	\N	\N
4481	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	183	2009-06-30 15:59:13	\N	\N	\N
4482	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	183	2009-06-30 15:59:13	\N	\N	\N
4483	Обыкновенная Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4484	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4485	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4370	Срочная Копия Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4371	Срочная Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4372	Срочная Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4373	Обыкновенная А/Я Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4374	Обыкновенная До востреб. Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4376	Обыкновенная А/Я Копия Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4377	Обыкновенная До востреб. Копия Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4378	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4379	Обыкновенная Копия Переговор Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4380	Обыкновенная Копия Правительственная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4381	Обыкновенная Копия Люкс/М Правительственная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4382	Правительственная Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4383	Правительственная Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4384	Обыкновенная Перевод Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4385	Обыкновенная Перевод Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4386	Обыкновенная Перевод Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4387	Обыкновенная Копия Переводная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4388	Обыкновенная Копия Переводная Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4389	Обыкновенная Копия Переводная Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4390	Обыкновенная Копия Переводная Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4391	Обыкновенная До востреб. Переводная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4392	Обыкновенная До востреб. Копия Переводная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4393	Обыкновенная Переговор	2009-06-30 15:59:13	\N	177	2009-06-30 15:59:13	\N	\N	\N
4394	Обыкновенная Переговор	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4395	Обыкновенная Переговор	2009-06-30 15:59:13	\N	178	2009-06-30 15:59:13	\N	\N	\N
4396	Обыкновенная Переговор	2009-06-30 15:59:13	\N	179	2009-06-30 15:59:13	\N	\N	\N
4397	Обыкновенная Переговор	2009-06-30 15:59:13	\N	190	2009-06-30 15:59:13	\N	\N	\N
4398	Обыкновенная Переговор	2009-06-30 15:59:13	\N	191	2009-06-30 15:59:13	\N	\N	\N
4399	Обыкновенная Переговор	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4400	Обыкновенная Переговор	2009-06-30 15:59:13	\N	181	2009-06-30 15:59:13	\N	\N	\N
4401	Обыкновенная Переговор	2009-06-30 15:59:13	\N	182	2009-06-30 15:59:13	\N	\N	\N
4402	Срочная Копия Увед. простое Люкс/В	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4403	Обыкновенная Переговор	2009-06-30 15:59:13	\N	184	2009-06-30 15:59:13	\N	\N	\N
4404	Обыкновенная Переговор	2009-06-30 15:59:13	\N	185	2009-06-30 15:59:13	\N	\N	\N
4405	Обыкновенная Переговор	2009-06-30 15:59:13	\N	186	2009-06-30 15:59:13	\N	\N	\N
4406	Обыкновенная Переговор	2009-06-30 15:59:13	\N	187	2009-06-30 15:59:13	\N	\N	\N
4407	Обыкновенная Переговор	2009-06-30 15:59:13	\N	188	2009-06-30 15:59:13	\N	\N	\N
4408	Обыкновенная Переговор	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4409	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:13	\N	183	2009-06-30 15:59:13	\N	\N	\N
4410	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:13	\N	178	2009-06-30 15:59:13	\N	\N	\N
4411	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:13	\N	188	2009-06-30 15:59:13	\N	\N	\N
4412	Правительственная	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4413	Правительственная	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4414	Правительственная	2009-06-30 15:59:13	\N	179	2009-06-30 15:59:13	\N	\N	\N
4415	Правительственная	2009-06-30 15:59:13	\N	190	2009-06-30 15:59:13	\N	\N	\N
4416	Правительственная	2009-06-30 15:59:13	\N	191	2009-06-30 15:59:13	\N	\N	\N
4417	Правительственная	2009-06-30 15:59:13	\N	181	2009-06-30 15:59:13	\N	\N	\N
4418	Правительственная	2009-06-30 15:59:13	\N	182	2009-06-30 15:59:13	\N	\N	\N
4419	Правительственная	2009-06-30 15:59:13	\N	183	2009-06-30 15:59:13	\N	\N	\N
4420	Правительственная	2009-06-30 15:59:13	\N	184	2009-06-30 15:59:13	\N	\N	\N
4421	Правительственная	2009-06-30 15:59:13	\N	185	2009-06-30 15:59:13	\N	\N	\N
4422	Правительственная	2009-06-30 15:59:13	\N	186	2009-06-30 15:59:13	\N	\N	\N
4423	Правительственная	2009-06-30 15:59:13	\N	187	2009-06-30 15:59:13	\N	\N	\N
4424	Правительственная	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4425	Обыкновенная Делюкс	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4426	Обыкновенная Делюкс Копия	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4427	Обыкновенная А/Я Делюкс Копия	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4428	Обыкновенная А/Я Делюкс	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4429	Обыкновенная Копия Увед. срочное Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4317	Обыкновенная А/Я Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4318	Обыкновенная До востреб. Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4319	Обыкновенная До востреб. Копия Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4320	Обыкновенная До востреб. Копия Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4321	Обыкновенная До востреб. Копия Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4322	Обыкновенная До востреб. Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4323	Обыкновенная До востреб. Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4324	Обыкновенная До востреб. Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4325	Обыкновенная Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4326	Обыкновенная Копия Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4327	Обыкновенная Копия Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4328	Обыкновенная Копия Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4329	Обыкновенная Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4330	Обыкновенная Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4331	Обыкновенная Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4332	Срочная Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4333	Срочная А/Я Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4334	Срочная А/Я Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4335	Срочная До востреб. Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4336	Срочная До востреб. Копия Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4337	Срочная До востреб. Копия Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4338	Срочная До востреб. Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4339	Срочная До востреб. Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4340	Срочная До востреб. Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4341	Срочная Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4342	Срочная Копия Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4343	Срочная Копия Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4344	Срочная Люкс/И Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4345	Срочная Люкс/И Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4346	Обыкновенная А/Я Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4347	Обыкновенная Заверенная Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4348	Обыкновенная До востреб. Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4349	Обыкновенная До востреб. Копия Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4350	Обыкновенная До востреб. Копия Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4351	Обыкновенная До востреб. Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4352	Обыкновенная До востреб. Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4353	Обыкновенная До востреб. Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4354	Обыкновенная Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4355	Обыкновенная Копия Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4356	Обыкновенная Копия Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4357	Обыкновенная Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4358	Обыкновенная Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4359	Срочная Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4360	Срочная А/Я Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4361	Срочная А/Я Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4362	Срочная До востреб. Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4363	Срочная До востреб. Копия Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4364	Срочная До востреб. Копия Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4365	Срочная До востреб. Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4366	Срочная До востреб. Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4367	Срочная До востреб. Люкс/М Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4368	Срочная Копия Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4369	Срочная Копия Люкс/М Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4260	Срочная До востреб. Заверенная Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4261	Срочная До востреб. Заверенная Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4262	Срочная Заверенная Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4263	Срочная До востреб. Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4264	Срочная Делюкс Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4265	Срочная Делюкс Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4266	Срочная Делюкс До востреб. Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4267	Срочная Делюкс До востреб. Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4268	Срочная Делюкс Копия Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4269	Срочная Делюкс До востреб. Копия Увед. срочное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4270	Обыкновенная Запрос-увед. част	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4271	Обыкновенная Запрос-увед. пред	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4272	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4273	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	180	2009-06-30 15:59:13	\N	\N	\N
4274	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	177	2009-06-30 15:59:13	\N	\N	\N
4275	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	177	2009-06-30 15:59:13	\N	\N	\N
4276	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4277	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4278	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	179	2009-06-30 15:59:13	\N	\N	\N
4279	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	190	2009-06-30 15:59:13	\N	\N	\N
4280	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	191	2009-06-30 15:59:13	\N	\N	\N
4281	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	179	2009-06-30 15:59:13	\N	\N	\N
4282	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	190	2009-06-30 15:59:13	\N	\N	\N
4283	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	191	2009-06-30 15:59:13	\N	\N	\N
4284	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	178	2009-06-30 15:59:13	\N	\N	\N
4285	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	178	2009-06-30 15:59:13	\N	\N	\N
4286	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4287	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	189	2009-06-30 15:59:13	\N	\N	\N
4288	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	181	2009-06-30 15:59:13	\N	\N	\N
4289	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	181	2009-06-30 15:59:13	\N	\N	\N
4290	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	185	2009-06-30 15:59:13	\N	\N	\N
4291	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	185	2009-06-30 15:59:13	\N	\N	\N
4292	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	186	2009-06-30 15:59:13	\N	\N	\N
4293	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	186	2009-06-30 15:59:13	\N	\N	\N
4294	Обыкновенная Служ. запрос част	2009-06-30 15:59:13	\N	187	2009-06-30 15:59:13	\N	\N	\N
4295	Обыкновенная Служ. запрос пред	2009-06-30 15:59:13	\N	187	2009-06-30 15:59:13	\N	\N	\N
4296	Обыкновенная Люкс	2009-06-30 15:59:13	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
4297	Обыкновенная Люкс/М Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4298	Обыкновенная Копия Люкс/М Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4299	Обыкновенная Почтой заказное Люкс/В	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4300	Обыкновенная Копия Почтой заказное Люкс/В	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4301	Обыкновенная А/Я Копия	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4302	Обыкновенная А/Я Заверенная Копия Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4303	Обыкновенная А/Я Копия ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4304	Обыкновенная ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4305	Обыкновенная А/Я ЛК/М/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4306	Обыкновенная Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4307	Обыкновенная А/Я Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4308	Обыкновенная А/Я Копия Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4309	Обыкновенная А/Я Копия Почтой заказное Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4310	Обыкновенная До востреб. Люкс/И	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4311	Обыкновенная Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4312	Обыкновенная А/Я Люкс/М	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4313	Обыкновенная Переговор	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4314	Обыкновенная Перевод	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4315	Правительственная	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4316	Обыкновенная А/Я Копия Люкс/И Почтой заказное	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4203	Срочная А/Я Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4204	Срочная А/Я Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4205	Срочная До востреб.	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4206	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4207	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4208	Срочная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4209	Срочная До востреб. Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4210	Срочная До востреб. Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4211	Срочная Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4212	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4213	Срочная Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4214	Срочная Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4215	Срочная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4216	Обыкновенная	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4217	Обыкновенная А/Я	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4218	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4219	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4221	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4222	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4223	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4224	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4225	Обыкновенная Копия	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4226	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4227	Обыкновенная Люкс	2009-06-30 15:59:12	\N	189	2009-06-30 15:59:12	\N	\N	\N
4228	Обыкновенная А/Я	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4229	Обыкновенная Делюкс До востреб. Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4230	Обыкновенная Делюкс Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4231	Обыкновенная Делюкс До востреб. Копия Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4232	Срочная Делюкс	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4233	Срочная Делюкс Копия	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4234	Срочная Делюкс До востреб. Копия	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4235	Обыкновенная Делюкс До востреб. Почтой заказное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4236	Обыкновенная Делюкс До востреб. Копия	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4237	Обыкновенная А/Я Делюкс Копия	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4238	Обыкновенная Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4239	Обыкновенная Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4240	Срочная Делюкс До востреб. Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4241	Обыкновенная Делюкс До востреб. Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4242	Обыкновенная Делюкс До востреб. Копия Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4243	Обыкновенная До востреб. Копия Люкс Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4244	Обыкновенная До востреб. Люкс Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4245	Обыкновенная Люкс Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4246	Обыкновенная До востреб. Заверенная Копия Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4247	Обыкновенная Заверенная Копия Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4248	Обыкновенная Копия Люкс Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4249	Обыкновенная Делюкс Копия Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4250	Обыкновенная До востреб. Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4251	Обыкновенная До востреб. Заверенная Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4252	Срочная Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4253	Срочная Копия Люкс Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4254	Срочная Люкс Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4255	Срочная До востреб. Люкс Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4256	Срочная До востреб. Копия Люкс Увед. простое	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4257	Срочная Копия Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4258	Срочная До востреб. Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4259	Срочная Заверенная Увед. простое	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4202	Срочная А/Я Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4142	Обыкновенная А/Я	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4143	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4144	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4145	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4146	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4147	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4148	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4149	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4150	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4151	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4152	Обыкновенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4153	Срочная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4154	Срочная А/Я	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4155	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4156	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4157	Срочная А/Я Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4158	Срочная До востреб.	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4159	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4160	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4161	Срочная До востреб. Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4162	Срочная Заверенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4163	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4164	Срочная Копия	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4165	Обыкновенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4166	Обыкновенная А/Я	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4167	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4168	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4169	Обыкновенная А/Я Заверенная Копия Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4170	Обыкновенная А/Я Заверенная Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4171	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4172	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4173	Обыкновенная А/Я Копия Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4174	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4175	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4176	Обыкновенная А/Я Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4177	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4178	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4179	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4180	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4181	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4182	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4183	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4184	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4185	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4186	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4187	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4188	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4189	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4190	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4191	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4192	Обыкновенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4193	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4194	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4195	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4196	Обыкновенная Люкс	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4197	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4198	Срочная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4199	Срочная А/Я	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4200	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4201	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	188	2009-06-30 15:59:12	\N	\N	\N
4076	Срочная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4077	Срочная А/Я	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4078	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4079	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4080	Срочная А/Я Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4081	Срочная А/Я Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4082	Срочная А/Я Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4083	Срочная До востреб.	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4084	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4085	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4086	Срочная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4087	Срочная До востреб. Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4088	Срочная Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4089	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4090	Срочная Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4091	Срочная Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4092	Срочная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4093	Обыкновенная	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4094	Обыкновенная А/Я	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4095	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4096	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4097	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4098	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4099	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4100	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4101	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4102	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4103	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4104	Обыкновенная Копия	2009-06-30 15:59:12	\N	185	2009-06-30 15:59:12	\N	\N	\N
4105	Обыкновенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4106	Обыкновенная А/Я	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4107	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4108	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4109	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4110	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4111	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4112	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4113	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4114	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4115	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4116	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4117	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4118	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4119	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4120	Обыкновенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4121	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4122	Обыкновенная Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4123	Срочная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4124	Срочная А/Я	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4125	Срочная А/Я Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4126	Срочная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4127	Срочная А/Я Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4128	Срочная А/Я Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4129	Срочная А/Я Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4130	Срочная До востреб.	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4131	Срочная До востреб. Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4132	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4133	Срочная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4134	Срочная До востреб. Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4135	Срочная До востреб. Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4136	Срочная Заверенная	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4137	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4138	Срочная Копия Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4139	Срочная Люкс	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4140	Срочная Копия	2009-06-30 15:59:12	\N	186	2009-06-30 15:59:12	\N	\N	\N
4141	Обыкновенная	2009-06-30 15:59:12	\N	187	2009-06-30 15:59:12	\N	\N	\N
4014	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4015	Срочная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4016	Срочная До востреб. Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4017	Срочная До востреб. Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4018	Срочная Заверенная	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4019	Срочная Заверенная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4020	Срочная Копия Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4021	Срочная Люкс	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4022	Срочная Копия	2009-06-30 15:59:12	\N	181	2009-06-30 15:59:12	\N	\N	\N
4023	Обыкновенная	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4024	Обыкновенная А/Я	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4025	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4026	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4027	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4028	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4029	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4030	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4031	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4032	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4033	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4034	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4035	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4036	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4037	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4038	Обыкновенная Копия	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4039	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4040	Обыкновенная Люкс	2009-06-30 15:59:12	\N	182	2009-06-30 15:59:12	\N	\N	\N
4041	Обыкновенная	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4042	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4043	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4044	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4045	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4046	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4047	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4048	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4049	Обыкновенная Копия	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4050	Обыкновенная Увед. срочное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4051	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:12	\N	183	2009-06-30 15:59:12	\N	\N	\N
4052	Обыкновенная А/Я Делюкс	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4053	Срочная А/Я Делюкс	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4054	Срочная А/Я Делюкс Копия	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4055	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4056	Обыкновенная Делюкс До востреб. Копия Почтой заказное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4057	Обыкновенная А/Я Делюкс Копия Почтой заказное	2009-06-30 15:59:12	\N	192	2009-06-30 15:59:12	\N	\N	\N
4058	Обыкновенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4059	Обыкновенная А/Я	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4060	Обыкновенная А/Я Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4061	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4062	Обыкновенная А/Я Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4063	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4064	Обыкновенная А/Я Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4065	Обыкновенная До востреб.	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4066	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4067	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4068	Обыкновенная До востреб. Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4069	Обыкновенная До востреб. Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4070	Обыкновенная До востреб. Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4071	Обыкновенная Заверенная	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4072	Обыкновенная Заверенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4073	Обыкновенная Копия	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4074	Обыкновенная Копия Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
4075	Обыкновенная Люкс	2009-06-30 15:59:12	\N	184	2009-06-30 15:59:12	\N	\N	\N
5529	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:01:04	\N	193	2010-01-28 11:01:04	\N	\N	31
5530	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:01:24	\N	193	2010-01-28 11:01:24	\N	\N	31
5531	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:01:51	\N	178	2010-01-28 11:01:51	\N	\N	31
5532	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:01:54	\N	178	2010-01-28 11:01:54	\N	\N	31
5533	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:01:57	\N	178	2010-01-28 11:01:57	\N	\N	31
5534	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:01:59	\N	178	2010-01-28 11:01:59	\N	\N	31
5535	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:02:10	\N	179	2010-01-28 11:02:10	\N	\N	31
5536	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:02:12	\N	179	2010-01-28 11:02:12	\N	\N	31
5537	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:02:17	\N	179	2010-01-28 11:02:17	\N	\N	31
5538	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:02:20	\N	179	2010-01-28 11:02:20	\N	\N	31
5539	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:02:30	\N	180	2010-01-28 11:02:30	\N	\N	31
5540	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:02:33	\N	180	2010-01-28 11:02:33	\N	\N	31
5541	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:02:36	\N	180	2010-01-28 11:02:36	\N	\N	31
5542	Обыкновенная Копия Люкс/И Почтой заказное Служ. запрос пред	2010-01-28 11:02:42	2014-09-15 12:32:53	180	2014-09-15 12:32:53	\N	\N	13
5543	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:02:52	\N	180	2010-01-28 11:02:52	\N	\N	31
5544	Обыкновенная Люкс/И Почтой заказное Служ. запрос част	2010-01-28 11:02:54	\N	180	2010-01-28 11:02:54	\N	\N	31
5545	Обыкновенная Копия Люкс/И Почтой заказное Служ. запрос част	2010-01-28 11:02:57	\N	180	2010-01-28 11:02:57	\N	\N	31
5546	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:03:00	\N	180	2010-01-28 11:03:00	\N	\N	31
5547	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:03:04	\N	180	2010-01-28 11:03:04	\N	\N	31
5548	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:03:41	\N	181	2010-01-28 11:03:41	\N	\N	31
5549	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:03:44	\N	181	2010-01-28 11:03:44	\N	\N	31
5550	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:03:48	\N	181	2010-01-28 11:03:48	\N	\N	31
5551	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:03:50	\N	181	2010-01-28 11:03:50	\N	\N	31
5552	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:03:57	\N	181	2010-01-28 11:03:57	\N	\N	31
5553	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:03:59	\N	181	2010-01-28 11:03:59	\N	\N	31
5554	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:04:02	\N	181	2010-01-28 11:04:02	\N	\N	31
5555	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:04:05	\N	181	2010-01-28 11:04:05	\N	\N	31
5556	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:05:40	\N	182	2010-01-28 11:05:40	\N	\N	31
5557	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:05:44	\N	182	2010-01-28 11:05:44	\N	\N	31
5558	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:06:24	\N	182	2010-01-28 11:06:24	\N	\N	31
5559	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:06:27	\N	182	2010-01-28 11:06:27	\N	\N	31
5560	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:06:32	\N	182	2010-01-28 11:06:32	\N	\N	31
5561	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:06:36	\N	182	2010-01-28 11:06:36	\N	\N	31
5562	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:06:38	\N	182	2010-01-28 11:06:38	\N	\N	31
5563	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:06:41	\N	182	2010-01-28 11:06:41	\N	\N	31
5564	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:06:49	\N	183	2010-01-28 11:06:49	\N	\N	31
5565	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:06:51	\N	183	2010-01-28 11:06:51	\N	\N	31
5566	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:06:55	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5567	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:06:58	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5568	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:07:04	\N	183	2010-01-28 11:07:04	\N	\N	31
5569	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:07:06	\N	183	2010-01-28 11:07:06	\N	\N	31
5570	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:07:08	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5571	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:07:11	2013-02-28 16:06:50	183	2013-02-28 16:06:50	\N	\N	36
5572	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:07:20	\N	184	2010-01-28 11:07:20	\N	\N	31
5573	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:07:23	\N	184	2010-01-28 11:07:23	\N	\N	31
5574	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:07:30	\N	184	2010-01-28 11:07:30	\N	\N	31
5575	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:07:32	\N	184	2010-01-28 11:07:32	\N	\N	31
5576	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:07:36	\N	184	2010-01-28 11:07:36	\N	\N	31
5577	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:07:40	\N	184	2010-01-28 11:07:40	\N	\N	31
5578	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:07:42	\N	184	2010-01-28 11:07:42	\N	\N	31
5579	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:07:44	\N	184	2010-01-28 11:07:44	\N	\N	31
5580	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:08:09	\N	192	2010-01-28 11:08:09	\N	\N	31
5581	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:08:12	\N	192	2010-01-28 11:08:12	\N	\N	31
5582	Обыкновенная ЛК/М/И Почтой заказное Служ. запрос пред	2010-01-28 11:08:20	\N	192	2010-01-28 11:08:20	\N	\N	31
5583	Обыкновенная Копия ЛК/М/И Почтой заказное Служ. запрос пред	2010-01-28 11:08:23	\N	192	2010-01-28 11:08:23	\N	\N	31
5584	Обыкновенная Люкс/В Почтой заказное Служ. запрос пред	2010-01-28 11:08:27	\N	192	2010-01-28 11:08:27	\N	\N	31
5585	Обыкновенная Копия Люкс/В Почтой заказное Служ. запрос пред	2010-01-28 11:08:30	\N	192	2010-01-28 11:08:30	\N	\N	31
5586	Обыкновенная Люкс/И Почтой заказное Служ. запрос пред	2010-01-28 11:08:35	\N	192	2010-01-28 11:08:35	\N	\N	31
5587	Обыкновенная Копия Люкс/И Почтой заказное Служ. запрос пред	2010-01-28 11:08:37	\N	192	2010-01-28 11:08:37	\N	\N	31
5588	Обыкновенная Люкс/М Почтой заказное Служ. запрос пред	2010-01-28 11:08:41	\N	192	2010-01-28 11:08:41	\N	\N	31
5589	Обыкновенная Копия Люкс/М Почтой заказное Служ. запрос пред	2010-01-28 11:08:43	\N	192	2010-01-28 11:08:43	\N	\N	31
5590	Обыкновенная ЛК/М/И Почтой заказное Служ. запрос част	2010-01-28 11:10:27	\N	192	2010-01-28 11:10:27	\N	\N	31
5591	Обыкновенная Копия ЛК/М/И Почтой заказное Служ. запрос част	2010-01-28 11:10:29	\N	192	2010-01-28 11:10:29	\N	\N	31
5592	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:10:32	\N	192	2010-01-28 11:10:32	\N	\N	31
5593	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:10:35	\N	192	2010-01-28 11:10:35	\N	\N	31
5594	Обыкновенная Люкс/В Почтой заказное Служ. запрос част	2010-01-28 11:10:37	\N	192	2010-01-28 11:10:37	\N	\N	31
5595	Обыкновенная Копия Люкс/В Почтой заказное Служ. запрос част	2010-01-28 11:10:39	\N	192	2010-01-28 11:10:39	\N	\N	31
5596	Обыкновенная Копия Люкс/И Почтой заказное Служ. запрос част	2010-01-28 11:10:46	\N	192	2010-01-28 11:10:46	\N	\N	31
5597	Обыкновенная Люкс/И Почтой заказное Служ. запрос част	2010-01-28 11:10:49	\N	192	2010-01-28 11:10:49	\N	\N	31
5598	Обыкновенная Люкс/М Почтой заказное Служ. запрос част	2010-01-28 11:10:52	\N	192	2010-01-28 11:10:52	\N	\N	31
5599	Обыкновенная Копия Люкс/М Почтой заказное Служ. запрос част	2010-01-28 11:10:54	\N	192	2010-01-28 11:10:54	\N	\N	31
5600	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:11:05	\N	185	2010-01-28 11:11:05	\N	\N	31
5601	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:11:08	\N	185	2010-01-28 11:11:08	\N	\N	31
5602	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:11:12	\N	185	2010-01-28 11:11:12	\N	\N	31
5603	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:11:14	\N	185	2010-01-28 11:11:14	\N	\N	31
5604	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:11:23	\N	186	2010-01-28 11:11:23	\N	\N	31
5605	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:11:26	\N	186	2010-01-28 11:11:26	\N	\N	31
5606	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:11:28	\N	186	2010-01-28 11:11:28	\N	\N	31
5607	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:11:31	\N	186	2010-01-28 11:11:31	\N	\N	31
5608	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:11:35	\N	186	2010-01-28 11:11:35	\N	\N	31
5609	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:11:37	\N	186	2010-01-28 11:11:37	\N	\N	31
5610	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:11:39	\N	186	2010-01-28 11:11:39	\N	\N	31
5611	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:11:42	\N	186	2010-01-28 11:11:42	\N	\N	31
5612	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:11:49	\N	187	2010-01-28 11:11:49	\N	\N	31
5613	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:11:53	\N	187	2010-01-28 11:11:53	\N	\N	31
5614	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:11:55	\N	187	2010-01-28 11:11:55	\N	\N	31
5615	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:11:57	\N	187	2010-01-28 11:11:57	\N	\N	31
5616	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:12:01	\N	187	2010-01-28 11:12:01	\N	\N	31
5617	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:12:04	\N	187	2010-01-28 11:12:04	\N	\N	31
5618	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:07	\N	187	2010-01-28 11:12:07	\N	\N	31
5619	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:09	\N	187	2010-01-28 11:12:09	\N	\N	31
5620	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:12:20	\N	188	2010-01-28 11:12:20	\N	\N	31
5621	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:12:23	\N	188	2010-01-28 11:12:23	\N	\N	31
5622	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:30	\N	188	2010-01-28 11:12:30	\N	\N	31
3747	Обыкновенная Делюкс Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3748	Срочная Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3749	Срочная Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3750	Обыкновенная Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3751	Срочная А/Я Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3752	Обыкновенная Делюкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3753	Обыкновенная Делюкс До востреб.	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3754	Срочная До востреб. Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3755	Срочная А/Я Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3756	Срочная А/Я Копия Люкс	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3757	Срочная До востреб. Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3758	Срочная А/Я Делюкс Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3759	Обыкновенная До востреб. Копия Люкс Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3760	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3761	Срочная До востреб. Копия Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3762	Срочная До востреб.	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3706	Срочная До востреб. Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3707	Обыкновенная Делюкс Копия Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3708	Обыкновенная Делюкс Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3709	Обыкновенная До востреб. Люкс Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3710	Обыкновенная Заверенная Копия Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3711	Срочная А/Я	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3712	Обыкновенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3713	Срочная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3714	Срочная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3715	Срочная До востреб. Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3716	Срочная Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3717	Срочная Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3718	Обыкновенная Копия	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3719	Обыкновенная Люкс	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3720	Обыкновенная Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3721	Обыкновенная До востреб.	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3722	Обыкновенная А/Я	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3723	Обыкновенная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3724	Срочная	2009-06-30 15:59:11	\N	193	2009-06-30 15:59:11	\N	\N	\N
3725	Срочная А/Я Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3726	Срочная А/Я Заверенная Копия	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3727	Обыкновенная Копия Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3728	Срочная Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3729	Срочная До востреб.	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3730	Обыкновенная До востреб. Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3731	Срочная До востреб. Копия Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3732	Обыкновенная Увед. простое	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3733	Срочная До востреб. Заверенная Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3734	Срочная До востреб. Заверенная Копия Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3735	Срочная Заверенная Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3736	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3737	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3738	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3739	Обыкновенная А/Я Заверенная Почтой заказное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3740	Обыкновенная А/Я	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3741	Срочная Заверенная Копия Увед. срочное	2009-06-30 15:59:11	\N	192	2009-06-30 15:59:11	\N	\N	\N
3763	Срочная А/Я	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
3764	Срочная Заверенная	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3765	Срочная Люкс	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3766	Срочная Заверенная Копия	2009-06-30 15:59:11	\N	178	2009-06-30 15:59:11	\N	\N	\N
3767	Обыкновенная А/Я Заверенная	2009-06-30 15:59:11	\N	177	2009-06-30 15:59:11	\N	\N	\N
4714	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4715	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4716	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4717	Обыкновенная А/Я Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4718	Обыкновенная А/Я Копия Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4719	Обыкновенная Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4720	Обыкновенная Копия Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4721	Обыкновенная А/Я Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4722	Обыкновенная А/Я Копия Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4723	Обыкновенная А/Я До востреб. Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4724	Обыкновенная А/Я До востреб. Копия Люкс	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4725	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4726	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4727	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4728	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4729	Обыкновенная Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4730	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4731	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4732	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4733	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4734	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4735	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4736	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4737	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	187	2009-06-30 15:59:15	\N	\N	\N
4738	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	2010-01-27 16:35:01	186	2010-01-27 16:35:01	\N	\N	31
4739	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	2010-01-27 16:32:03	185	2010-01-27 16:32:03	\N	\N	31
4740	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4741	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	182	2009-06-30 15:59:15	\N	\N	\N
4742	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	181	2009-06-30 15:59:15	\N	\N	\N
4743	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	180	2009-06-30 15:59:15	\N	\N	\N
4744	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	179	2009-06-30 15:59:15	\N	\N	\N
4745	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	190	2009-06-30 15:59:15	\N	\N	\N
4746	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	191	2009-06-30 15:59:15	\N	\N	\N
4747	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	193	2009-06-30 15:59:15	\N	\N	\N
4748	Обыкновенная Переговор Почтой заказное	2009-06-30 15:59:15	\N	177	2009-06-30 15:59:15	\N	\N	\N
4749	Обыкновенная Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4750	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4751	Обыкновенная Заверенная Копия	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4752	Обыкновенная Заверенная	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4753	Обыкновенная А/Я Заверенная	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4754	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4755	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4756	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4757	Срочная Увед. срочное Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4758	Срочная Копия Увед. срочное Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4759	Обыкновенная Вручить (дата) Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4760	Обыкновенная Копия Вручить (дата) Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4761	Обыкновенная Увед. простое Вручить (дата) Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4762	Срочная Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4763	Срочная Копия Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4764	Срочная Увед. простое Люкс/В	2009-06-30 15:59:15	\N	192	2009-06-30 15:59:15	\N	\N	\N
4765	Обыкновенная До востреб. Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4766	Обыкновенная До востреб. Копия Вручить (дата)	2009-06-30 15:59:15	\N	189	2009-06-30 15:59:15	\N	\N	\N
4658	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4659	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4660	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4661	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4662	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4663	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4664	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4665	Обыкновенная А/Я Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4666	Обыкновенная А/Я Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4667	Срочная А/Я	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4668	Срочная А/Я Копия	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4669	Срочная До востреб.	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4670	Срочная До востреб. Копия	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4671	Срочная Заверенная	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4672	Срочная Заверенная Копия	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4673	Срочная Люкс	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4674	Срочная Копия Люкс	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4675	Срочная До востреб. Люкс	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4676	Срочная До востреб. Копия Люкс	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4677	Обыкновенная Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4678	Обыкновенная А/Я Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4679	Обыкновенная А/Я Копия Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4680	Обыкновенная Копия Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4681	Обыкновенная До востреб. Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4682	Обыкновенная До востреб. Копия Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4683	Обыкновенная Увед. простое Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4684	Обыкновенная Копия Увед. простое Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4685	Обыкновенная Копия Увед. срочное Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4686	Обыкновенная Увед. срочное Люкс/В	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4687	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4688	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4689	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4690	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	182	2009-06-30 15:59:14	\N	\N	\N
4691	Обыкновенная Копия Служ. запрос пред	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4692	Обыкновенная Служ. запрос пред	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4693	Обыкновенная Почтой заказное Служ. запрос пред	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4694	Обыкновенная Служ. запрос част	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4695	Обыкновенная	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4696	Обыкновенная Почтой заказное Служ. запрос част	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4697	Обыкновенная Заверенная	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4698	Обыкновенная Заверенная Копия	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4699	Обыкновенная А/Я Заверенная Копия	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4700	Обыкновенная А/Я Заверенная	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4701	Обыкновенная До востреб. Заверенная	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4702	Обыкновенная До востреб. Заверенная Копия	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4703	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4704	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:14	\N	183	2009-06-30 15:59:14	\N	\N	\N
4705	Обыкновенная Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
5748	Жирный шрифт	2010-04-29 13:28:09	\N	621	2010-04-29 13:28:09	Жирный шрифт	\N	36
4706	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4707	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4708	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4709	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4710	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4711	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4712	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4713	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:15	\N	184	2009-06-30 15:59:15	\N	\N	\N
4603	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4604	Обыкновенная Делюкс	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4605	Обыкновенная Делюкс Копия	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4606	Обыкновенная А/Я Делюкс	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4607	Обыкновенная А/Я Делюкс Копия	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4608	Обыкновенная Делюкс До востреб.	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4609	Обыкновенная Делюкс До востреб. Копия	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4610	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4611	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4612	Срочная Делюкс Копия	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4613	Срочная Делюкс До востреб.	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4614	Срочная Делюкс До востреб. Копия	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4615	Срочная Делюкс	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4616	Срочная Делюкс Копия	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4617	Срочная Делюкс До востреб. Копия	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4618	Срочная Делюкс До востреб.	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4619	Обыкновенная Делюкс	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4620	Обыкновенная Делюкс Копия	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4621	Обыкновенная А/Я Делюкс Копия	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4622	Обыкновенная А/Я Делюкс	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4623	Обыкновенная Делюкс До востреб.	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4624	Обыкновенная Делюкс До востреб. Копия	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4625	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4626	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4627	Обыкновенная Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4628	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4629	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4630	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4631	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4632	Обыкновенная До востреб. Копия Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4633	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4634	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4635	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4636	Обыкновенная Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4637	Обыкновенная До востреб. Люкс Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4638	Обыкновенная До востреб. Копия Люкс Почтой заказное	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4639	Обыкновенная Делюкс	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4640	Обыкновенная Делюкс Копия	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4641	Обыкновенная А/Я Делюкс	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4642	Обыкновенная А/Я Делюкс Копия	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4643	Обыкновенная Делюкс До востреб.	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4644	Обыкновенная Делюкс До востреб. Копия	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4645	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4646	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4647	Срочная Делюкс	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4648	Срочная Делюкс Копия	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4649	Срочная Делюкс До востреб.	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4650	Срочная Делюкс До востреб. Копия	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4651	Обыкновенная Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4652	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4653	Обыкновенная А/Я Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4654	Обыкновенная А/Я Копия Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4655	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4656	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4657	Обыкновенная До востреб. Почтой заказное	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4602	Обыкновенная Люкс Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4542	Срочная Заверенная	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4543	Срочная Заверенная	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4544	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4545	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4546	Срочная Делюкс	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4547	Срочная Делюкс Копия	2009-06-30 15:59:14	2009-07-01 12:56:05	188	2009-07-01 12:56:05	\N	\N	34
4548	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4549	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4550	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4551	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4552	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4553	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4554	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4555	Срочная Копия	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4556	Срочная Копия	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4557	Срочная Копия	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4558	Срочная Заверенная Копия	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4559	Срочная Заверенная Копия	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4560	Срочная Заверенная Копия	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4561	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4562	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4563	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4564	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4565	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4566	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4567	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4568	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	181	2009-06-30 15:59:14	\N	\N	\N
4569	Срочная До востреб.	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4570	Срочная До востреб.	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4571	Срочная До востреб.	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4572	Срочная До востреб. Копия	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4573	Срочная До востреб. Копия	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4574	Срочная До востреб. Копия	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4575	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4576	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4577	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4578	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4579	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4580	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4581	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4582	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	186	2009-06-30 15:59:14	\N	\N	\N
4583	Срочная До востреб. Заверенная	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4584	Срочная До востреб. Заверенная	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4585	Срочная До востреб. Заверенная	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4586	Обыкновенная Люкс Увед. простое Вручить (дата)	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4587	Обыкновенная Выборы	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4588	Обыкновенная Копия Выборы	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4589	Обыкновенная Увед. простое Выборы	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4590	Обыкновенная Увед. срочное Выборы	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4591	Правительственная	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4592	Обыкновенная Копия ЛК/М/И	2009-06-30 15:59:14	\N	192	2009-06-30 15:59:14	\N	\N	\N
4593	Правительственная	2009-06-30 15:59:14	\N	178	2009-06-30 15:59:14	\N	\N	\N
4594	Правительственная	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4595	Обыкновенная Делюкс	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4596	Обыкновенная Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4597	Обыкновенная Перевод	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4598	Обыкновенная Копия Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4599	Обыкновенная Делюкс Копия	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4600	Обыкновенная Заверенная Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4601	Обыкновенная Заверенная Копия Почтой заказное	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4486	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4487	Обыкновенная Делюкс Почтой заказное	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4488	Обыкновенная Делюкс Копия Почтой заказное	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4489	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4490	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4491	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:13	\N	193	2009-06-30 15:59:13	\N	\N	\N
4492	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4493	Обыкновенная А/Я Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4494	Обыкновенная А/Я Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	193	2009-06-30 15:59:14	\N	\N	\N
4495	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4496	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4497	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4498	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4499	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4500	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4501	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4502	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	177	2009-06-30 15:59:14	\N	\N	\N
4503	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4504	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4505	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4506	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4507	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4508	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4509	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4510	Обыкновенная Люкс/И Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4511	Обыкновенная Копия Люкс/И Вручить (дата)	2009-06-30 15:59:14	\N	180	2009-06-30 15:59:14	\N	\N	\N
4512	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4513	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4514	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4515	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4516	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4517	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4518	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4519	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	184	2009-06-30 15:59:14	\N	\N	\N
4520	Срочная Переговор	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4521	Срочная Переговор	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4522	Срочная Переговор	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4523	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4524	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4525	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4526	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4527	Обыкновенная Заверенная Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4528	Обыкновенная Заверенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4529	Обыкновенная Люкс Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4530	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:14	\N	187	2009-06-30 15:59:14	\N	\N	\N
4531	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4532	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4533	Срочная До востреб. Заверенная Копия	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4534	Обыкновенная Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4535	Обыкновенная Копия Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4536	Обыкновенная А/Я Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4537	Обыкновенная А/Я Копия Вручить (дата)	2009-06-30 15:59:14	\N	188	2009-06-30 15:59:14	\N	\N	\N
4538	Срочная	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4539	Срочная	2009-06-30 15:59:14	\N	190	2009-06-30 15:59:14	\N	\N	\N
4540	Срочная	2009-06-30 15:59:14	\N	191	2009-06-30 15:59:14	\N	\N	\N
4541	Срочная Заверенная	2009-06-30 15:59:14	\N	179	2009-06-30 15:59:14	\N	\N	\N
4430	Обыкновенная Копия Правительственная Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4431	Правительственная Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4432	Обыкновенная Увед. срочное Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4433	Обыкновенная Делюкс Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4434	Обыкновенная Делюкс Копия Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4435	Обыкновенная Увед. простое Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4436	Обыкновенная Копия Увед. простое Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
4437	Обыкновенная Копия Люкс Вручить (дата)	2009-06-30 15:59:13	\N	192	2009-06-30 15:59:13	\N	\N	\N
6396	Тестовая услуга	2014-07-22 12:57:15	\N	841	2014-07-31 11:24:40	ТЕСТ	\N	1
6651	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-09-12 17:52:40	\N	177	2014-09-12 17:52:40	\N	\N	13
6652	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 17:52:58	\N	177	2014-09-12 17:52:58	\N	\N	13
6653	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 17:53:08	\N	177	2014-09-12 17:53:08	\N	\N	13
6654	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 17:53:21	\N	177	2014-09-12 17:53:21	\N	\N	13
6655	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 17:53:32	\N	177	2014-09-12 17:53:32	\N	\N	13
6656	Срочная Заверенная Служ. запрос пред	2014-09-12 17:53:55	\N	177	2014-09-12 17:53:55	\N	\N	13
6657	Срочная Заверенная Служ. запрос част	2014-09-12 17:54:05	\N	177	2014-09-12 17:54:05	\N	\N	13
6658	Срочная Заверенная Копия Служ. запрос пред	2014-09-12 17:54:15	\N	177	2014-09-12 17:54:15	\N	\N	13
6659	Срочная Заверенная Копия Служ. запрос част	2014-09-12 17:54:24	\N	177	2014-09-12 17:54:24	\N	\N	13
6660	Срочная Делюкс Служ. запрос пред	2014-09-12 17:54:36	\N	177	2014-09-12 17:54:36	\N	\N	13
6661	Срочная Делюкс Служ. запрос част	2014-09-12 17:54:44	\N	177	2014-09-12 17:54:44	\N	\N	13
6662	Срочная До востреб. Служ. запрос пред	2014-09-12 17:54:58	\N	177	2014-09-12 17:54:58	\N	\N	13
6663	Срочная До востреб. Служ. запрос част	2014-09-12 17:55:09	\N	177	2014-09-12 17:55:09	\N	\N	13
6664	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 17:55:25	\N	177	2014-09-12 17:55:25	\N	\N	13
6665	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 17:55:36	\N	177	2014-09-12 17:55:36	\N	\N	13
6666	Срочная Люкс Служ. запрос пред	2014-09-12 17:55:53	\N	177	2014-09-12 17:55:53	\N	\N	13
6667	Срочная Люкс Служ. запрос част	2014-09-12 17:56:02	\N	177	2014-09-12 17:56:02	\N	\N	13
6668	Срочная До востреб. Люкс Служ. запрос част	2014-09-15 10:53:20	\N	177	2014-09-15 10:53:20	\N	\N	13
6669	Срочная А/Я Служ. запрос пред	2014-09-15 10:53:52	\N	177	2014-09-15 10:53:52	\N	\N	13
6670	Срочная А/Я Служ. запрос част	2014-09-15 10:54:04	\N	177	2014-09-15 10:54:04	\N	\N	13
6671	Срочная Вручить (дата) Люкс Служ. запрос пред	2014-09-15 10:54:23	\N	177	2014-09-15 10:54:23	\N	\N	13
6672	Срочная Вручить (дата) Люкс Служ. запрос част	2014-09-15 10:54:48	\N	177	2014-09-15 10:54:48	\N	\N	13
6673	Обыкновенная Вручить (дата) Люкс Служ. запрос част	2014-09-15 10:55:09	\N	177	2014-09-15 10:55:09	\N	\N	13
6674	Обыкновенная Вручить (дата) Люкс Служ. запрос пред	2014-09-15 10:55:29	\N	177	2014-09-15 10:55:29	\N	\N	13
6675	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос пред	2014-09-15 10:56:24	\N	177	2014-09-15 10:56:24	\N	\N	13
6676	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос част	2014-09-15 10:56:39	\N	177	2014-09-15 10:56:39	\N	\N	13
6677	Обыкновенная А/Я Копия Служ. запрос пред	2014-09-15 10:57:07	\N	177	2014-09-15 10:57:07	\N	\N	13
6678	Обыкновенная А/Я Копия Служ. запрос част	2014-09-15 10:57:16	\N	177	2014-09-15 10:57:16	\N	\N	13
6679	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-15 10:57:31	\N	177	2014-09-15 10:57:31	\N	\N	13
6680	Обыкновенная А/Я Копия Люкс Служ. запрос част	2014-09-15 10:57:41	\N	177	2014-09-15 10:57:41	\N	\N	13
6681	Обыкновенная А/Я Служ. запрос част	2014-09-15 10:58:14	\N	177	2014-09-15 10:58:14	\N	\N	13
6682	Обыкновенная А/Я Служ. запрос пред	2014-09-15 10:58:24	\N	177	2014-09-15 10:58:24	\N	\N	13
6683	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-15 10:59:07	\N	177	2014-09-15 10:59:07	\N	\N	13
6684	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-15 10:59:19	\N	177	2014-09-15 10:59:19	\N	\N	13
6685	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-15 10:59:31	\N	177	2014-09-15 10:59:31	\N	\N	13
6686	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-15 10:59:41	\N	177	2014-09-15 10:59:41	\N	\N	13
6687	Обыкновенная А/Я Люкс Служ. запрос пред	2014-09-15 11:00:25	\N	177	2014-09-15 11:00:25	\N	\N	13
6688	Обыкновенная А/Я Люкс Служ. запрос част	2014-09-15 11:00:35	\N	177	2014-09-15 11:00:35	\N	\N	13
6689	Обыкновенная А/Я Делюкс Служ. запрос пред	2014-09-15 11:01:15	\N	177	2014-09-15 11:01:15	\N	\N	13
6690	Обыкновенная А/Я Делюкс Служ. запрос част	2014-09-15 11:01:26	\N	177	2014-09-15 11:01:26	\N	\N	13
6691	Обыкновенная А/Я Делюкс Копия Служ. запрос пред	2014-09-15 11:01:45	\N	177	2014-09-15 11:01:45	\N	\N	13
6692	Обыкновенная А/Я Делюкс Копия Служ. запрос част	2014-09-15 11:01:54	\N	177	2014-09-15 11:01:54	\N	\N	13
6693	Срочная А/Я Заверенная Служ. запрос част	2014-09-15 11:02:58	\N	178	2014-09-15 11:02:58	\N	\N	13
6694	Срочная А/Я Люкс Служ. запрос пред	2014-09-15 11:03:19	\N	178	2014-09-15 11:03:19	\N	\N	13
6695	Срочная А/Я Люкс Служ. запрос част	2014-09-15 11:03:27	\N	178	2014-09-15 11:03:27	\N	\N	13
6696	Срочная А/Я Копия Люкс Служ. запрос пред	2014-09-15 11:03:40	\N	178	2014-09-15 11:03:40	\N	\N	13
6697	Срочная А/Я Копия Люкс Служ. запрос част	2014-09-15 11:03:52	\N	178	2014-09-15 11:03:52	\N	\N	13
6698	Срочная Делюкс Служ. запрос пред	2014-09-15 11:04:07	\N	178	2014-09-15 11:04:07	\N	\N	13
6699	Срочная А/Я Делюкс	2014-09-15 11:04:30	\N	178	2014-09-15 11:04:30	\N	\N	13
6700	Срочная А/Я Делюкс Служ. запрос пред	2014-09-15 11:04:39	\N	178	2014-09-15 11:04:39	\N	\N	13
6701	Срочная А/Я Делюкс Служ. запрос част	2014-09-15 11:04:49	\N	178	2014-09-15 11:04:49	\N	\N	13
6702	Срочная Вручить (дата) Служ. запрос пред	2014-09-15 11:05:15	\N	178	2014-09-15 11:05:15	\N	\N	13
6703	Срочная Вручить (дата) Служ. запрос част	2014-09-15 11:05:29	\N	178	2014-09-15 11:05:29	\N	\N	13
6704	Срочная До востреб. Служ. запрос пред	2014-09-15 11:05:43	\N	178	2014-09-15 11:05:43	\N	\N	13
6705	Срочная До востреб. Служ. запрос част	2014-09-15 11:05:52	\N	178	2014-09-15 11:05:52	\N	\N	13
6706	Срочная До востреб. Заверенная Служ. запрос пред	2014-09-15 11:06:05	\N	178	2014-09-15 11:06:05	\N	\N	13
6707	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-15 11:06:44	\N	178	2014-09-15 11:06:44	\N	\N	13
6708	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-15 11:06:57	\N	178	2014-09-15 11:06:57	\N	\N	13
6709	Обыкновенная Вручить (дата) Служ. запрос част	2014-09-15 11:07:49	\N	178	2014-09-15 11:07:49	\N	\N	13
6710	Обыкновенная Вручить (дата) Люкс Служ. запрос пред	2014-09-15 11:08:04	\N	178	2014-09-15 11:08:04	\N	\N	13
6711	Обыкновенная Вручить (дата) Люкс Служ. запрос част	2014-09-15 11:08:17	\N	178	2014-09-15 11:08:17	\N	\N	13
6712	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос част	2014-09-15 11:08:44	\N	178	2014-09-15 11:08:44	\N	\N	13
6713	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос пред	2014-09-15 11:08:53	\N	178	2014-09-15 11:08:53	\N	\N	13
6714	Обыкновенная А/Я Вручить (дата) Копия	2014-09-15 11:09:36	\N	178	2014-09-15 11:09:36	\N	\N	13
6715	Обыкновенная А/Я Вручить (дата) Копия Служ. запрос пред	2014-09-15 11:09:50	\N	178	2014-09-15 11:09:50	\N	\N	13
6716	Обыкновенная А/Я Вручить (дата) Люкс Служ. запрос част	2014-09-15 11:10:10	\N	178	2014-09-15 11:10:10	\N	\N	13
6717	Обыкновенная А/Я Вручить (дата) Копия Служ. запрос част	2014-09-15 11:10:34	\N	178	2014-09-15 11:10:34	\N	\N	13
6718	Обыкновенная А/Я Вручить (дата) Копия Люкс Служ. запрос пред	2014-09-15 11:10:49	\N	178	2014-09-15 11:10:49	\N	\N	13
6719	Обыкновенная А/Я Вручить (дата) Копия Люкс Служ. запрос част	2014-09-15 11:11:05	\N	178	2014-09-15 11:11:05	\N	\N	13
6720	Срочная А/Я Служ. запрос пред	2014-09-15 11:11:53	\N	179	2014-09-15 11:11:53	\N	\N	13
6721	Срочная А/Я Служ. запрос част	2014-09-15 11:12:14	\N	179	2014-09-15 11:12:14	\N	\N	13
6722	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-09-15 11:20:47	\N	179	2014-09-15 11:20:47	\N	\N	13
6723	Обыкновенная До востреб. Заверенная Служ. запрос част	2014-09-15 11:20:55	\N	179	2014-09-15 11:20:55	\N	\N	13
6724	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-15 11:22:44	\N	180	2014-09-15 11:22:44	\N	\N	13
6725	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-15 11:23:00	\N	180	2014-09-15 11:23:00	\N	\N	13
6726	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-15 11:23:12	\N	180	2014-09-15 11:23:12	\N	\N	13
6727	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-15 11:23:29	\N	180	2014-09-15 11:23:29	\N	\N	13
6728	Обыкновенная Вручить (дата) Служ. запрос пред	2014-09-15 11:23:49	\N	180	2014-09-15 11:23:49	\N	\N	13
6729	Обыкновенная Вручить (дата) Служ. запрос част	2014-09-15 11:23:56	\N	180	2014-09-15 11:23:56	\N	\N	13
6730	Обыкновенная Вручить (дата) Люкс Служ. запрос пред	2014-09-15 11:24:26	\N	180	2014-09-15 11:24:26	\N	\N	13
6731	Обыкновенная Вручить (дата) Копия Люкс/И Служ. запрос част	2014-09-15 11:24:36	\N	180	2014-09-15 11:24:36	\N	\N	13
6732	Обыкновенная А/Я Вручить (дата) Служ. запрос пред	2014-09-15 12:36:26	\N	180	2014-09-15 12:36:26	\N	\N	13
6733	Обыкновенная А/Я Вручить (дата) Служ. запрос част	2014-09-15 12:36:35	\N	180	2014-09-15 12:36:35	\N	\N	13
6734	Обыкновенная Заверенная Копия Почтой заказное	2014-09-15 12:37:06	\N	180	2014-09-15 12:37:06	\N	\N	13
6735	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-15 12:37:16	\N	180	2014-09-15 12:37:16	\N	\N	13
6736	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-15 12:39:01	\N	180	2014-09-15 12:39:01	\N	\N	13
6737	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-15 12:39:09	\N	180	2014-09-15 12:39:09	\N	\N	13
6738	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-15 12:39:19	\N	180	2014-09-15 12:39:19	\N	\N	13
5623	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:33	\N	188	2010-01-28 11:12:33	\N	\N	31
5624	Обыкновенная Почтой заказное Служ. запрос пред	2010-01-28 11:12:40	\N	189	2010-01-28 11:12:40	\N	\N	31
5625	Обыкновенная Копия Почтой заказное Служ. запрос пред	2010-01-28 11:12:43	\N	189	2010-01-28 11:12:43	\N	\N	31
5626	Обыкновенная Копия Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:12:45	\N	189	2010-01-28 11:12:45	\N	\N	31
5627	Обыкновенная Люкс Почтой заказное Служ. запрос пред	2010-01-28 11:12:47	\N	189	2010-01-28 11:12:47	\N	\N	31
5628	Обыкновенная Почтой заказное Служ. запрос част	2010-01-28 11:12:51	\N	189	2010-01-28 11:12:51	\N	\N	31
5629	Обыкновенная Копия Почтой заказное Служ. запрос част	2010-01-28 11:12:53	\N	189	2010-01-28 11:12:53	\N	\N	31
5630	Обыкновенная Копия Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:55	\N	189	2010-01-28 11:12:55	\N	\N	31
5631	Обыкновенная Люкс Почтой заказное Служ. запрос част	2010-01-28 11:12:57	\N	189	2010-01-28 11:12:57	\N	\N	31
5647	Рекламный пакет 2 монитора + 30 машин на месяц	2010-01-28 12:24:05	\N	397	2010-01-28 12:24:05	Рекламный пакет 2 монитора + 30 машин на месяц	\N	36
5667	Физ лицо 1/32 полосы - будни (вт.ср.пт.сб)	2010-01-29 15:46:42	\N	597	2010-11-02 16:01:21	Физ лицо 1/32 полосы - будни (вт.ср.пт.сб)	\N	36
5668	Физ лицо 1/32 полосы- с ТВ-программой (четверг)	2010-01-29 15:47:37	\N	597	2010-11-02 16:01:34	Физ лицо 1/32 полосы- с ТВ-программой (четверг)	\N	36
5669	Физ лицо 1/32 + 1/128 полосы - с ТВ-программой (четверг)	2010-01-29 15:48:19	\N	597	2010-11-02 16:01:48	Физ лицо 1/32 + 1/128 полосы - с ТВ-программой (четверг)	\N	36
5670	Физ лицо 1/32 + 1/128 полосы - будни (вт.ср.пт.сб)	2010-01-29 15:48:44	\N	597	2010-11-02 16:02:06	Физ лицо 1/32 + 1/128 полосы - будни (вт.ср.пт.сб)	\N	36
5671	Физ лицо 1/64 полосы - будни (вт.ср.пт.сб.)	2010-01-29 15:49:31	\N	597	2010-11-02 16:00:47	Физ лицо 1/64 полосы - будни (вт.ср.пт.сб.)	\N	36
5672	Физ лицо 1/64 + 1/128 полосы - будни (вт.ср.пт.сб.)	2010-01-29 15:49:49	\N	597	2010-11-02 16:02:23	Физ лицо 1/64 + 1/128 полосы - будни (вт.ср.пт.сб.)	\N	36
5673	Физ лицо 1/64 + 1/128 полосы с ТВ-программой (четверг)	2010-01-29 15:50:14	\N	597	2010-11-02 16:02:42	Физ лицо 1/64 + 1/128 полосы с ТВ-программой (четверг)	\N	36
5674	Физ лицо 1/64 полосы с ТВ-программой (четверг)	2010-01-29 15:50:38	\N	597	2010-11-02 16:02:53	Физ лицо 1/64 полосы с ТВ-программой (четверг)	\N	36
5675	Физ лицо 1/128 полосы -будни (вт.ср. пт.сб.)	2010-01-29 15:51:02	\N	597	2010-11-02 16:03:05	Физ лицо 1/128 полосы -будни (вт.ср. пт.сб.)	\N	36
5676	Физ лицо 1/128 полосы- с ТВ-программой (четверг)	2010-01-29 15:51:48	\N	597	2010-11-02 16:03:16	Физ лицо 1/128 полосы- с ТВ-программой (четверг)	\N	36
5688	Обыкновенная Почтой заказное Служ. запрос пред	2010-03-04 10:58:14	\N	178	2010-03-04 10:58:14	\N	\N	\N
5689	Обыкновенная Почтой заказное Служ. запрос част	2010-03-04 10:58:35	\N	178	2010-03-04 10:58:35	\N	\N	\N
5707	Коммерческое	2010-04-21 13:03:09	\N	617	2010-04-22 15:22:04	Простой шрифт 	\N	36
5708	Ярмарка вакансий	2010-04-21 15:26:44	\N	617	2010-04-22 15:21:56	Простой шрифт	\N	36
5709	Простой шрифт частное	2010-04-21 15:28:01	\N	617	2010-04-22 15:20:27	Простой шрифт 	\N	36
5710	Жирный шрифт (частные)	2010-04-22 12:04:53	\N	618	2010-04-22 14:26:13	Жирный шрифт	\N	36
5711	В рамке (частные)	2010-04-22 12:05:22	\N	618	2010-04-22 12:06:23	В рамке	\N	36
5712	Коммерческое	2010-04-22 12:06:44	\N	618	2010-04-22 12:06:44	Коммерческое	\N	36
5713	Простой шрифт 10 кв.см.	2010-04-22 12:18:59	\N	619	2010-04-23 12:48:18	Простой шрифт 10 кв.см.	\N	36
5714	Простой шрифт (частное)	2010-04-22 13:18:23	\N	618	2010-04-22 14:26:03	Простой шрифт 	\N	36
5715	Ярмарка вакансий	2010-04-22 14:26:38	\N	618	2010-04-22 14:26:38	Ярмарка вакансий	\N	36
5716	Поздравления	2010-04-22 14:28:47	\N	618	2010-04-22 14:28:47	Поздравления	\N	36
5717	Частное объявление	2010-04-23 07:51:53	\N	620	2010-04-23 12:36:01	Частное объявление	\N	36
5718	Частное (Двойная плотность)	2010-04-23 07:52:54	\N	620	2010-04-23 12:36:16	Частное (Двойная плотность)	\N	36
5719	Объявление о вакансиях	2010-04-23 07:53:40	\N	620	2010-04-23 12:37:12	Объявление о вакансиях	\N	36
5720	Объявление о вакансиях (Двойная плотность)	2010-04-23 07:53:59	\N	620	2010-04-23 12:37:26	Объявление о вакансиях (Двойная плотность)	\N	36
5721	Коммерческое	2010-04-23 07:54:23	\N	620	2010-04-23 12:36:38	Коммерческое	\N	36
5722	Коммерческое (Двойная плотность)	2010-04-23 07:54:38	\N	620	2010-04-23 12:36:59	Коммерческое (Двойная плотность)	\N	36
5723	Реклама	2010-04-23 08:14:37	\N	620	2010-04-23 08:14:37	Реклама	\N	36
5724	Простой шрифт 12 кв.см.	2010-04-23 12:48:30	\N	619	2010-04-23 12:48:30	Простой шрифт 12 кв.см.	\N	36
5725	Простой шрифт 14 кв.см.	2010-04-23 12:48:42	\N	619	2010-04-23 12:48:42	Простой шрифт 14 кв.см.	\N	36
5726	Простой шрифт 16 кв.см.	2010-04-23 12:48:51	\N	619	2010-04-23 12:48:51	Простой шрифт 16 кв.см.	\N	36
5727	Простой шрифт 18 кв.см.	2010-04-23 12:49:30	\N	619	2010-04-23 12:49:30	Простой шрифт 18 кв.см.	\N	36
5728	Простой шрифт 20 кв.см.	2010-04-23 12:49:41	\N	619	2010-04-23 12:49:41	Простой шрифт 20 кв.см.	\N	36
5729	Простой шрифт 24 кв.см.	2010-04-23 12:50:23	\N	619	2010-04-23 12:50:23	Простой шрифт 24 кв.см.	\N	36
5730	Простой шрифт 28 кв.см.	2010-04-23 12:53:48	\N	619	2010-04-23 12:54:12	Простой шрифт 28 кв.см.	\N	36
5731	Простой шрифт 30 кв.см.	2010-04-23 12:54:02	\N	619	2010-04-23 12:54:02	Простой шрифт 30 кв.см.	\N	36
5732	Простой шрифт 32 кв.см.	2010-04-23 12:54:25	\N	619	2010-04-23 12:54:37	Простой шрифт 32 кв.см.	\N	36
5733	Простой шрифт 36 кв.см.	2010-04-23 12:54:48	\N	619	2010-04-23 12:54:48	Простой шрифт 36 кв.см.	\N	36
5734	Простой шрифт 40 кв.см.	2010-04-23 12:55:04	\N	619	2010-04-23 12:55:04	Простой шрифт 40 кв.см.	\N	36
5735	Простой шрифт 48 кв.см.	2010-04-23 12:55:24	\N	619	2010-04-23 12:55:24	Простой шрифт 48 кв.см.	\N	36
5747	Простой шрифт	2010-04-29 13:27:56	\N	621	2010-04-29 13:27:56	Простой шрифт	\N	36
5749	Жирный шрифт в рамке	2010-04-29 13:29:00	\N	621	2010-04-29 13:29:00	Жирный шрифт в рамке	\N	36
5767	Срочная Копия Служ. запрос част	2010-05-31 11:21:02	\N	192	2010-05-31 11:21:02	\N	\N	31
5768	Срочная Копия Служ. запрос пред	2010-05-31 11:21:06	\N	192	2010-05-31 11:21:06	\N	\N	31
5787	Соболезнование	2010-06-15 12:38:38	\N	621	2010-06-15 12:38:38	Соболезнование	\N	36
5807	  Подписка на 5 мес.(с доставкой февраль-июнь)	2010-07-01 15:24:44	\N	357	2012-12-20 13:34:28	Подписка на 5 мес.(с доставкой февраль-июнь)	\N	36
5808	  Подписка на 5 мес.(без доставки февраль-июнь)	2010-07-01 15:25:02	\N	357	2012-12-20 13:34:53	Подписка на 5 мес.(без доставки февраль-июнь)	\N	36
5827	Простым шрифтом	2010-07-29 13:30:42	\N	637	2010-07-29 13:30:42	Простым шрифтом	\N	36
5828	В рамке	2010-07-29 13:51:16	\N	637	2010-07-29 13:51:16	В рамке	\N	36
5829	Выворотка (белым шрифтом на черном фоне)	2010-07-29 13:52:20	\N	637	2010-07-29 13:52:20	Выворотка (белым шрифтом на черном фоне)	\N	36
5830	На цветном фоне	2010-07-29 13:52:50	\N	637	2010-07-29 13:52:50	На цветном фоне	\N	36
5831	ВИКТОРИНА	2010-07-29 16:18:06	\N	637	2010-07-29 16:18:06	ВИКТОРИНА	\N	36
5847	Простым шрифтом	2010-10-28 14:53:02	\N	657	2010-10-28 14:53:02	Простым шрифтом	\N	36
5848	ЗАГЛАВНЫМИ БУКВАМИ	2010-10-28 14:53:24	\N	657	2010-10-28 14:53:24	ЗАГЛАВНЫМИ БУКВАМИ	\N	36
5849	Цветной фон	2010-10-28 14:53:36	\N	657	2010-10-28 14:54:38	Цветной фон	\N	36
5850	Юр. лицо 1/64 полосы - будни (вт.ср.пт.сб.)	2010-11-02 16:04:45	\N	597	2010-11-02 16:04:45	Юр. лицо 1/64 полосы - будни (вт.ср.пт.сб.)	\N	36
5851	Юр. лицо 1/64 полосы  -  с ТВ-программой (четверг)	2010-11-02 16:05:22	\N	597	2010-11-02 16:05:22	Юр. лицо 1/64 полосы  -  с ТВ-программой (четверг)	\N	36
5852	Подписка на год (без доставки)	2010-11-03 09:52:02	\N	357	2012-12-20 13:31:20	Подписка на год (без доставки)	\N	36
5853	Подписка на год МАРТ-ДЕКАБРЬ 2014 (с доставкой)	2010-11-03 09:52:19	\N	357	2014-01-21 10:53:27	Подписка на год МАРТ-ДЕКАБРЬ 2014 (с доставкой)	\N	36
5867	Простым шрифтом	2010-11-12 11:20:39	\N	677	2010-11-12 11:20:39	Простым шрифтом	\N	36
5868	Полужирным шрифтом	2010-11-12 11:21:14	\N	677	2010-11-12 11:21:14	Полужирным шрифтом	\N	36
5869	В рамке	2010-11-12 11:21:22	\N	677	2010-11-12 11:21:22	В рамке	\N	36
5887	Обыкновенная Люкс/В Служ. запрос част	2010-11-26 13:35:11	\N	192	2010-11-26 13:35:11	\N	\N	31
5888	Обыкновенная Люкс/В Служ. запрос пред	2010-11-26 13:35:21	\N	192	2010-11-26 13:35:21	\N	\N	31
5907	Срочная Служ. запрос пред	2011-01-26 12:47:36	\N	180	2011-01-26 12:47:36	\N	\N	31
5908	Срочная Служ. запрос част	2011-01-26 12:47:42	\N	180	2011-01-26 12:47:42	\N	\N	31
5927	Простым шрифтом	2011-04-14 16:03:39	\N	697	2011-04-14 16:03:39	Простым шрифтом	\N	36
5928	Простым шрифтом	2011-04-14 16:03:54	\N	698	2011-04-14 16:03:54	Простым шрифтом	\N	36
5947	Жирный шрифт	2011-04-20 12:57:27	\N	697	2011-04-20 12:57:27	Жирный шрифт	\N	36
5967	В рамке	2011-04-28 11:59:25	\N	697	2011-04-28 11:59:25	В рамке	\N	36
5968	Жирным шрифтом	2011-04-28 12:06:27	\N	698	2011-04-28 12:06:27	Жирным шрифтом	\N	36
5969	В рамке	2011-04-28 12:06:36	\N	698	2011-04-28 12:06:36	В рамке	\N	36
5987	Простым шрифтом	2011-06-15 10:02:14	\N	717	2011-06-15 10:02:14	Простым шрифтом	\N	36
5988	Жирным шрифтом	2011-06-15 10:02:27	\N	717	2011-06-15 10:02:27	Жирным шрифтом	\N	36
6007	Простым шрифтом	2011-06-15 14:28:39	\N	718	2011-06-15 14:28:39	Простым шрифтом	\N	36
6008	Жирным шрифтом	2011-06-15 14:28:52	\N	718	2011-06-15 14:28:52	Жирным шрифтом	\N	36
6027	Простым шрифтом	2011-06-28 10:58:19	\N	737	2011-06-28 10:58:19	Простым шрифтом	\N	36
6028	Заглавными буквами	2011-06-28 10:58:45	\N	737	2011-06-28 10:58:45	Заглавными буквами	\N	36
6029	В рамке	2011-06-28 10:58:57	\N	737	2011-06-28 10:58:57	В рамке	\N	36
6030	Рубрика "Услуги"	2011-06-28 13:20:00	\N	738	2011-06-28 13:20:00	Рубрика "Услуги"	\N	36
6031	Риэлторские услуги	2011-06-28 13:20:36	\N	738	2011-06-29 10:36:07	Риэлторские услуги	\N	36
6032	Простым шрифтом, кроме риэлотрских и рубрики "Услуги"	2011-06-28 13:21:01	\N	738	2011-06-28 13:22:17	Простым шрифтом	\N	36
6047	Простым шрифтом	2011-08-15 10:02:30	\N	757	2011-08-15 10:02:30	Простым шрифтом	\N	36
6048	В рамке (с выделенным фоном)	2011-08-15 10:03:16	\N	757	2011-08-15 10:03:16	В рамке (с выделенным фоном)	\N	36
6067	Простым шрифтом	2011-09-13 09:47:08	\N	777	2011-09-13 09:47:08	Простым шрифтом	\N	36
6068	Жирным шрифтом	2011-09-13 09:47:29	\N	777	2011-09-13 09:47:29	Жирным шрифтом	\N	36
6069	Цветной фон	2011-09-13 09:48:03	\N	777	2011-09-13 09:48:36	Цветной фон	\N	36
6070	В рамке	2011-09-13 09:48:16	\N	777	2011-09-13 09:48:16	В рамке	\N	36
6087	Простым шрифтом	2011-10-21 09:23:26	\N	797	2011-10-21 09:23:26	Простым шрифтом	\N	36
6088	Полужирным шрифтом	2011-10-21 09:23:43	\N	797	2011-10-21 09:23:43	Полужирным шрифтом	\N	36
6107	Акция (простым шрифтом)	2011-10-27 11:37:33	\N	777	2011-10-27 11:37:33	Акция (простым шрифтом)	\N	36
6127	Акция (жирным шрифтом)	2011-10-27 11:57:26	\N	777	2011-10-27 11:57:26	Акция (жирным шрифтом)	\N	36
6128	Акция (цветной фон)	2011-10-27 11:57:53	\N	777	2011-10-27 11:57:53	Акция (цветной фон)	\N	36
6129	Акция (в рамке)	2011-10-27 11:58:04	\N	777	2011-10-27 11:58:04	Акция (в рамке)	\N	36
6147	Простым шрифтом	2011-11-26 14:28:12	\N	817	2011-11-26 14:28:12	Простым шрифтом	\N	36
6148	Жирным шрифтом	2011-11-26 14:28:23	\N	817	2011-11-26 14:28:23	Жирным шрифтом	\N	36
6149	Заглавными буквами	2011-11-26 14:28:35	\N	817	2011-11-26 14:28:35	Заглавными буквами	\N	36
6167	Акция (жирным шрифтом)	2011-12-08 09:50:27	2013-10-31 12:56:53	797	2013-10-31 12:56:53	Акция (жирным шрифтом)	\N	36
6187	В рамке	2011-12-09 14:56:35	\N	837	2011-12-12 15:46:12	В рамке	\N	36
6207	Поздравительный модуль 10 х 3 см	2011-12-14 10:16:00	\N	357	2012-12-20 13:31:29	Поздравительный модуль 10 х 3 см	\N	36
6208	Поздравительная визитка с цветочками 10 х 5 см	2011-12-14 10:16:38	\N	357	2012-12-20 13:31:33	Поздравительная визитка с цветочками 10 х 5 см	\N	36
6227	Подписка на 11 месяцев (февраль-декабрь 2014)	2012-01-13 12:29:17	\N	357	2013-12-23 11:57:07	Подписка на 11 месяцев (февраль-декабрь 2014)	\N	36
6247	Срочная Служ. запрос част	2012-02-20 09:39:23	\N	185	2012-02-20 09:39:23	\N	\N	31
6248	Срочная Служ. запрос пред	2012-02-20 09:39:30	\N	185	2012-02-20 09:39:30	\N	\N	31
6249	Срочная Служ. запрос пред	2012-02-20 09:40:13	\N	191	2012-02-20 09:40:13	\N	\N	31
6250	Срочная Служ. запрос част	2012-02-20 09:40:18	\N	191	2012-02-20 09:40:18	\N	\N	31
6251	Срочная Служ. запрос пред	2012-02-20 09:40:32	\N	190	2012-02-20 09:40:32	\N	\N	31
6252	Срочная Служ. запрос част	2012-02-20 09:40:35	\N	190	2012-02-20 09:40:35	\N	\N	31
6253	Срочная Служ. запрос пред	2012-02-20 09:40:56	\N	193	2012-02-20 09:40:56	\N	\N	31
6254	Срочная Служ. запрос част	2012-02-20 09:41:06	\N	193	2012-02-20 09:41:06	\N	\N	31
6255	Срочная Служ. запрос пред	2012-02-20 09:44:42	\N	177	2012-02-20 09:44:42	\N	\N	31
6256	Срочная Служ. запрос част	2012-02-20 09:44:46	\N	177	2012-02-20 09:44:46	\N	\N	31
6257	Срочная Служ. запрос пред	2012-02-20 09:44:56	\N	178	2012-02-20 09:44:56	\N	\N	31
6258	Срочная Служ. запрос част	2012-02-20 09:45:00	\N	178	2012-02-20 09:45:00	\N	\N	31
6259	Срочная Служ. запрос пред	2012-02-20 09:45:11	\N	179	2012-02-20 09:45:11	\N	\N	31
6260	Срочная Служ. запрос част	2012-02-20 09:45:14	\N	179	2012-02-20 09:45:14	\N	\N	31
6261	Срочная Служ. запрос пред	2012-02-20 09:45:35	\N	181	2012-02-20 09:45:35	\N	\N	31
6262	Срочная Служ. запрос част	2012-02-20 09:45:38	\N	181	2012-02-20 09:45:38	\N	\N	31
6263	Срочная Служ. запрос пред	2012-02-20 09:46:34	\N	184	2012-02-20 09:46:34	\N	\N	31
6264	Срочная Служ. запрос част	2012-02-20 09:46:38	\N	184	2012-02-20 09:46:38	\N	\N	31
6265	Срочная Служ. запрос пред	2012-02-20 09:47:00	\N	186	2012-02-20 09:47:00	\N	\N	31
6266	Срочная Служ. запрос част	2012-02-20 09:47:03	\N	186	2012-02-20 09:47:03	\N	\N	31
6267	Срочная Служ. запрос пред	2012-02-20 09:47:13	\N	187	2012-02-20 09:47:13	\N	\N	31
6268	Срочная Служ. запрос част	2012-02-20 09:47:17	\N	187	2012-02-20 09:47:17	\N	\N	31
6269	Срочная Служ. запрос пред	2012-02-20 09:47:28	\N	188	2012-02-20 09:47:28	\N	\N	31
6270	Срочная Служ. запрос част	2012-02-20 09:47:34	\N	188	2012-02-20 09:47:34	\N	\N	31
6307	Обыкновенная Вручить (дата) Люкс/М Увед. простое	2012-02-21 16:41:33	\N	192	2012-02-21 16:41:33	\N	\N	31
6327	В рубрика "Ищу работу"	2012-03-01 16:33:50	\N	81	2012-03-01 16:38:09	В рубрика "Ищу работу"	\N	36
6347	Некролог модуль 10 х 3 см	2012-03-29 08:37:01	\N	357	2012-03-29 08:37:01	Некролог модуль 10 х 3 см	\N	36
6368	Обыкновенная Вручить (дата)	2012-05-14 09:00:38	\N	191	2012-05-14 09:00:38	\N	\N	31
6369	Обыкновенная Вручить (дата) Копия	2012-05-14 09:00:45	\N	191	2012-05-14 09:00:45	\N	\N	31
6370	Срочная Вручить (дата)	2012-05-14 09:01:20	\N	191	2012-05-14 09:01:20	\N	\N	31
6371	Срочная Вручить (дата) Копия	2012-05-14 09:01:23	\N	191	2012-05-14 09:01:23	\N	\N	31
6374	Обыкновенная Увед. простое	2012-05-14 09:54:08	\N	191	2012-05-14 09:54:08	\N	\N	31
6375	Обыкновенная Копия Увед. простое	2012-05-14 09:54:15	\N	191	2012-05-14 09:54:15	\N	\N	31
6376	Обыкновенная Увед. срочное	2012-05-14 09:54:33	\N	191	2012-05-14 09:54:33	\N	\N	31
6377	Обыкновенная Копия Увед. срочное	2012-05-14 09:54:36	\N	191	2012-05-14 09:54:36	\N	\N	31
6378	Срочная Увед. простое	2012-05-14 09:54:58	\N	191	2012-05-14 09:54:58	\N	\N	31
6379	Срочная Копия Увед. простое	2012-05-14 09:55:01	\N	191	2012-05-14 09:55:01	\N	\N	31
6380	Срочная Увед. срочное	2012-05-14 09:55:06	\N	191	2012-05-14 09:55:06	\N	\N	31
6381	Срочная Копия Увед. срочное	2012-05-14 09:55:09	\N	191	2012-05-14 09:55:09	\N	\N	31
6387	В рамочке	2013-02-25 14:18:12	\N	797	2013-02-25 14:18:12	В рамочке	\N	36
6388	В рамочке полужирным	2013-02-25 14:18:38	\N	797	2013-02-25 14:18:38	В рамочке полужирным	\N	36
6392	Обыкновенная Заверенная Служ. запрос пред	2014-07-18 10:47:49	\N	177	2014-07-18 10:47:49	\N	\N	1
6393	Обыкновенная До востреб. Служ. запрос част	2014-07-18 10:51:20	\N	177	2014-07-18 10:51:20	\N	\N	1
6739	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-15 12:39:31	\N	180	2014-09-15 12:39:31	\N	\N	13
6740	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-09-15 12:40:02	\N	180	2014-09-15 12:40:02	\N	\N	13
6741	Обыкновенная До востреб. Заверенная Служ. запрос част	2014-09-15 12:40:12	\N	180	2014-09-15 12:40:12	\N	\N	13
6742	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-15 12:40:21	\N	180	2014-09-15 12:40:21	\N	\N	13
6743	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-15 12:40:34	\N	180	2014-09-15 12:40:34	\N	\N	13
6744	Обыкновенная А/Я Вручить (дата) Люкс Служ. запрос пред	2014-09-15 12:41:30	\N	180	2014-09-15 12:41:30	\N	\N	13
6745	Обыкновенная А/Я Вручить (дата) Люкс Служ. запрос част	2014-09-15 12:41:38	\N	180	2014-09-15 12:41:38	\N	\N	13
6746	Обыкновенная До востреб. Люкс Служ. запрос пред	2014-09-15 12:42:12	\N	180	2014-09-15 12:42:12	\N	\N	13
6747	Обыкновенная До востреб. Люкс Служ. запрос част	2014-09-15 12:42:24	\N	180	2014-09-15 12:42:24	\N	\N	13
6748	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-15 12:42:34	\N	180	2014-09-15 12:42:34	\N	\N	13
6749	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-15 12:42:46	\N	180	2014-09-15 12:42:46	\N	\N	13
6391	123	2014-05-13 15:39:41	2014-05-13 15:41:30	840	2014-05-13 15:41:30	123	\N	1
6394	Обыкновенная А/Я Делюкс Служ. запрос пред	2014-07-18 11:02:49	\N	192	2014-07-18 11:02:49	\N	\N	13
6395	Обыкновенная А/Я Делюкс Служ. запрос част	2014-07-18 11:03:29	\N	192	2014-07-18 11:03:29	\N	\N	13
6750	Срочная Заверенная Служ. запрос пред	2014-09-15 14:41:00	\N	180	2014-09-15 14:41:00	\N	\N	13
6751	Срочная Заверенная Служ. запрос част	2014-09-15 14:41:10	\N	180	2014-09-15 14:41:10	\N	\N	13
6752	Срочная Заверенная Копия Служ. запрос пред	2014-09-15 14:41:23	\N	180	2014-09-15 14:41:23	\N	\N	13
6753	Срочная Заверенная Копия Служ. запрос част	2014-09-15 14:41:32	\N	180	2014-09-15 14:41:32	\N	\N	13
6754	Срочная А/Я Заверенная Служ. запрос пред	2014-09-15 14:41:43	\N	180	2014-09-15 14:41:43	\N	\N	13
6755	Срочная А/Я Заверенная Служ. запрос част	2014-09-15 14:41:54	\N	180	2014-09-15 14:41:54	\N	\N	13
6756	Срочная А/Я Заверенная Копия Служ. запрос пред	2014-09-15 14:42:09	\N	180	2014-09-15 14:42:09	\N	\N	13
6757	Срочная А/Я Заверенная Копия Служ. запрос част	2014-09-15 14:42:24	\N	180	2014-09-15 14:42:24	\N	\N	13
6758	Срочная До востреб. Служ. запрос пред	2014-09-15 14:42:39	\N	180	2014-09-15 14:42:39	\N	\N	13
6759	Срочная До востреб. Служ. запрос част	2014-09-15 14:42:51	\N	180	2014-09-15 14:42:51	\N	\N	13
6760	Срочная До востреб. Заверенная Служ. запрос пред	2014-09-15 14:43:04	\N	180	2014-09-15 14:43:04	\N	\N	13
6761	Срочная До востреб. Заверенная Служ. запрос част	2014-09-15 14:43:17	\N	180	2014-09-15 14:43:17	\N	\N	13
6762	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-15 14:43:27	\N	180	2014-09-15 14:43:27	\N	\N	13
6763	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-15 14:43:38	\N	180	2014-09-15 14:43:38	\N	\N	13
6764	Обыкновенная Вручить (дата) Копия Служ. запрос пред	2014-09-15 14:44:21	\N	180	2014-09-15 14:44:21	\N	\N	13
6765	Обыкновенная Вручить (дата) Копия Служ. запрос част	2014-09-15 14:44:44	\N	180	2014-09-15 14:44:44	\N	\N	13
6766	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос пред	2014-09-15 14:45:02	\N	180	2014-09-15 14:45:02	\N	\N	13
6767	Обыкновенная Вручить (дата) Копия Люкс Служ. запрос част	2014-09-15 14:45:23	\N	180	2014-09-15 14:45:23	\N	\N	13
6768	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-15 14:47:00	\N	181	2014-09-15 14:47:00	\N	\N	13
6769	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-15 14:47:11	\N	181	2014-09-15 14:47:11	\N	\N	13
6770	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-15 14:47:23	\N	181	2014-09-15 14:47:23	\N	\N	13
6771	Обыкновенная А/Я Копия Служ. запрос част	2014-09-15 14:47:44	\N	181	2014-09-15 14:47:44	\N	\N	13
6772	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-15 14:48:49	\N	181	2014-09-15 14:48:49	\N	\N	13
6773	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-15 14:49:10	\N	181	2014-09-15 14:49:10	\N	\N	13
6468	Обыкновенная До востреб. Копия Служ. запрос пред	2014-09-03 12:41:52	\N	188	2014-09-03 12:41:52	\N	\N	13
6469	Обыкновенная До востреб. Копия Служ. запрос част	2014-09-03 12:42:00	\N	188	2014-09-03 12:42:00	\N	\N	13
6470	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-03 12:42:28	\N	188	2014-09-03 12:42:28	\N	\N	13
6471	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-03 12:42:40	\N	188	2014-09-03 12:42:40	\N	\N	13
6472	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-03 12:43:09	\N	188	2014-09-03 12:43:09	\N	\N	13
6473	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-03 12:43:19	\N	188	2014-09-03 12:43:19	\N	\N	13
6474	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-03 12:43:30	\N	188	2014-09-03 12:43:30	\N	\N	13
6475	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-03 12:43:38	\N	188	2014-09-03 12:43:38	\N	\N	13
6476	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-03 12:44:15	\N	188	2014-09-03 12:44:15	\N	\N	13
6477	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-03 12:44:29	\N	188	2014-09-03 12:44:29	\N	\N	13
6478	Обыкновенная Люкс Служ. запрос част	2014-09-03 12:46:12	\N	188	2014-09-03 12:46:12	\N	\N	13
6479	Обыкновенная Люкс Служ. запрос пред	2014-09-03 12:46:26	\N	188	2014-09-03 12:46:26	\N	\N	13
6480	Обыкновенная А/Я Копия Люкс Служ. запрос част	2014-09-03 13:45:32	\N	188	2014-09-03 13:45:32	\N	\N	13
6481	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-04 09:51:32	\N	178	2014-09-04 09:51:32	\N	\N	13
6482	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-04 09:51:59	\N	178	2014-09-04 09:51:59	\N	\N	13
6483	Обыкновенная Копия Почтой заказное Служ. запрос пред	2014-09-04 09:53:16	\N	178	2014-09-04 09:53:16	\N	\N	13
7203	Правительственная	2017-11-29 16:34:49	\N	879	2017-11-29 16:34:49	\N	\N	\N
6484	Обыкновенная Копия Почтой заказное Служ. запрос част	2014-09-04 09:53:30	\N	178	2014-09-04 09:53:30	\N	\N	13
6485	Обыкновенная А/Я Копия Служ. запрос част	2014-09-04 09:54:03	\N	178	2014-09-04 09:54:03	\N	\N	13
6486	Обыкновенная А/Я Люкс Служ. запрос пред	2014-09-04 09:54:40	\N	178	2014-09-04 09:54:40	\N	\N	13
6487	Обыкновенная А/Я Люкс Служ. запрос част	2014-09-04 09:54:54	\N	178	2014-09-04 09:54:54	\N	\N	13
6488	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-04 10:05:50	\N	178	2014-09-04 10:05:50	\N	\N	13
6489	Обыкновенная А/Я Копия Люкс Служ. запрос част	2014-09-04 10:06:17	\N	178	2014-09-04 10:06:17	\N	\N	13
6490	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-04 10:07:12	\N	178	2014-09-04 10:07:12	\N	\N	13
6491	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-04 10:07:28	\N	178	2014-09-04 10:07:28	\N	\N	13
6492	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-04 10:08:37	\N	178	2014-09-04 10:08:37	\N	\N	13
6493	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-04 10:08:52	\N	178	2014-09-04 10:08:52	\N	\N	13
6494	Срочная Заверенная Копия Служ. запрос пред	2014-09-04 10:10:00	\N	178	2014-09-04 10:10:00	\N	\N	13
6495	Срочная Заверенная Копия Служ. запрос част	2014-09-04 10:10:15	\N	178	2014-09-04 10:10:15	\N	\N	13
6496	Срочная Люкс Служ. запрос пред	2014-09-04 10:11:15	\N	178	2014-09-04 10:11:15	\N	\N	13
6497	Срочная Люкс Служ. запрос част	2014-09-04 10:11:36	\N	178	2014-09-04 10:11:36	\N	\N	13
6498	Срочная А/Я Заверенная Служ. запрос пред	2014-09-04 10:12:01	\N	178	2014-09-04 10:12:01	\N	\N	13
6499	Обыкновенная А/Я Люкс Служ. запрос част	2014-09-04 19:53:13	\N	192	2014-09-04 19:53:13	\N	\N	13
6500	Обыкновенная А/Я Люкс Служ. запрос пред	2014-09-04 19:53:37	\N	192	2014-09-04 19:53:37	\N	\N	13
6501	Обыкновенная А/Я Копия Люкс/В Служ. запрос част	2014-09-04 19:53:55	\N	192	2014-09-04 19:53:55	\N	\N	13
6502	Обыкновенная А/Я Копия Люкс/В Служ. запрос пред	2014-09-04 19:54:08	\N	192	2014-09-04 19:54:08	\N	\N	13
6503	Обыкновенная А/Я Люкс/И Служ. запрос част	2014-09-04 19:54:28	\N	192	2014-09-04 19:54:28	\N	\N	13
6504	Обыкновенная А/Я Люкс/И Служ. запрос пред	2014-09-04 19:54:44	\N	192	2014-09-04 19:54:44	\N	\N	13
6505	Обыкновенная А/Я Люкс/М Служ. запрос част	2014-09-04 19:54:55	\N	192	2014-09-04 19:54:55	\N	\N	13
6506	Обыкновенная А/Я Люкс/М Служ. запрос пред	2014-09-04 19:55:10	\N	192	2014-09-04 19:55:10	\N	\N	13
6507	Срочная А/Я Копия Люкс Служ. запрос част	2014-09-04 19:55:38	\N	192	2014-09-04 19:55:38	\N	\N	13
6508	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-04 19:55:55	\N	192	2014-09-04 19:55:55	\N	\N	13
6509	Обыкновенная А/Я Копия Люкс/И Служ. запрос пред	2014-09-04 19:56:25	\N	192	2014-09-04 19:56:25	\N	\N	13
6510	Обыкновенная А/Я Копия Люкс/М Служ. запрос пред	2014-09-04 19:56:40	\N	192	2014-09-04 19:56:40	\N	\N	13
6511	Срочная А/Я Копия Служ. запрос пред	2014-09-04 20:01:23	\N	192	2014-09-04 20:01:23	\N	\N	13
6512	Срочная А/Я Копия Служ. запрос част	2014-09-04 20:01:41	\N	192	2014-09-04 20:01:41	\N	\N	13
6513	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-12 12:09:17	\N	185	2014-09-12 12:09:17	\N	\N	13
6514	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 12:09:28	\N	185	2014-09-12 12:09:28	\N	\N	13
6515	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 12:09:47	\N	185	2014-09-12 12:09:47	\N	\N	13
6516	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 12:09:58	\N	185	2014-09-12 12:09:58	\N	\N	13
6517	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 12:10:16	\N	185	2014-09-12 12:10:16	\N	\N	13
6518	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 12:10:27	\N	185	2014-09-12 12:10:27	\N	\N	13
6519	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 12:11:27	\N	185	2014-09-12 12:11:27	\N	\N	13
6520	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 12:11:41	\N	185	2014-09-12 12:11:41	\N	\N	13
6521	Срочная Заверенная Копия Служ. запрос пред	2014-09-12 12:12:28	\N	185	2014-09-12 12:12:28	\N	\N	13
6522	Срочная Заверенная Копия Служ. запрос част	2014-09-12 12:12:45	\N	185	2014-09-12 12:12:45	\N	\N	13
6523	Срочная До востреб. Копия Служ. запрос пред	2014-09-12 12:13:19	\N	185	2014-09-12 12:13:19	\N	\N	13
6524	Срочная До востреб. Копия Служ. запрос част	2014-09-12 12:13:32	\N	185	2014-09-12 12:13:32	\N	\N	13
6525	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 12:13:58	\N	185	2014-09-12 12:13:58	\N	\N	13
6526	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 12:14:16	\N	185	2014-09-12 12:14:16	\N	\N	13
6527	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-12 12:14:51	\N	186	2014-09-12 12:14:51	\N	\N	13
6528	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 12:15:03	\N	186	2014-09-12 12:15:03	\N	\N	13
6529	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 12:15:19	\N	186	2014-09-12 12:15:19	\N	\N	13
6530	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 12:16:29	\N	186	2014-09-12 12:16:29	\N	\N	13
6531	Срочная Заверенная Копия Служ. запрос пред	2014-09-12 12:17:01	\N	186	2014-09-12 12:17:01	\N	\N	13
6532	Срочная Заверенная Копия Служ. запрос част	2014-09-12 12:17:12	\N	186	2014-09-12 12:17:12	\N	\N	13
6533	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 12:17:36	\N	186	2014-09-12 12:17:36	\N	\N	13
6534	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 12:17:46	\N	186	2014-09-12 12:17:46	\N	\N	13
6535	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-12 12:18:02	\N	186	2014-09-12 12:18:02	\N	\N	13
6536	Обыкновенная До востреб. Люкс Служ. запрос част	2014-09-12 12:18:20	\N	186	2014-09-12 12:18:20	\N	\N	13
6537	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-12 12:18:39	\N	186	2014-09-12 12:18:39	\N	\N	13
6538	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 12:19:04	\N	186	2014-09-12 12:19:04	\N	\N	13
6539	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 12:19:20	\N	186	2014-09-12 12:19:20	\N	\N	13
6540	Срочная А/Я Копия Люкс Служ. запрос пред	2014-09-12 12:19:42	\N	186	2014-09-12 12:19:42	\N	\N	13
6541	Обыкновенная А/Я Копия Служ. запрос част	2014-09-12 12:20:13	\N	186	2014-09-12 12:20:13	\N	\N	13
6542	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-12 12:20:41	\N	186	2014-09-12 12:20:41	\N	\N	13
6543	Обыкновенная А/Я Копия Люкс Служ. запрос част	2014-09-12 12:20:54	\N	186	2014-09-12 12:20:54	\N	\N	13
6544	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 12:21:12	\N	186	2014-09-12 12:21:12	\N	\N	13
6545	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 12:22:00	\N	186	2014-09-12 12:22:00	\N	\N	13
6546	Обыкновенная До востреб. Копия Служ. запрос част	2014-09-12 12:58:40	\N	186	2014-09-12 12:58:40	\N	\N	13
6547	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 13:00:09	\N	187	2014-09-12 13:00:09	\N	\N	13
6548	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 13:00:41	\N	187	2014-09-12 13:00:41	\N	\N	13
6549	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 13:00:53	\N	187	2014-09-12 13:00:53	\N	\N	13
6550	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 13:01:06	\N	187	2014-09-12 13:01:06	\N	\N	13
6551	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 13:01:22	\N	187	2014-09-12 13:01:22	\N	\N	13
6552	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-09-12 13:01:36	\N	187	2014-09-12 13:01:36	\N	\N	13
6553	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-12 13:02:54	\N	187	2014-09-12 13:02:54	\N	\N	13
6414	Обыкновенная А/Я Запрос-увед. пред Копия	2014-08-28 18:55:02	\N	192	2014-08-28 18:55:02	\N	\N	13
6415	Обыкновенная А/Я Запрос-увед. част Копия	2014-08-28 18:55:57	\N	192	2014-08-28 18:55:57	\N	\N	13
6416	Обыкновенная А/Я Запрос-увед. пред Люкс	2014-08-28 18:58:29	\N	192	2014-08-28 18:58:29	\N	\N	13
6417	Обыкновенная До востреб. Копия Люкс/В Увед. простое	2014-08-28 19:00:26	\N	192	2014-08-28 19:00:26	\N	\N	13
6418	Обыкновенная До востреб. Копия ЛК/М/И Увед. срочное	2014-08-28 19:01:27	\N	192	2014-08-28 19:01:27	\N	\N	13
6419	Обыкновенная Вручить (дата) До востреб. Копия Увед. простое	2014-08-28 19:03:12	\N	192	2014-08-28 19:03:12	\N	\N	13
6420	Обыкновенная Вручить (дата) До востреб. Копия Увед. срочное	2014-08-28 19:03:41	\N	192	2014-08-28 19:03:41	\N	\N	13
6421	Обыкновенная Вручить (дата) До востреб. ЛК/М/И	2014-08-28 19:04:26	\N	192	2014-08-28 19:04:26	\N	\N	13
6422	Обыкновенная Вручить (дата) До востреб. Люкс	2014-08-28 19:04:45	\N	192	2014-08-28 19:04:45	\N	\N	13
6423	Обыкновенная Вручить (дата) До востреб. Люкс/В	2014-08-28 19:05:17	\N	192	2014-08-28 19:05:17	\N	\N	13
6424	Обыкновенная Вручить (дата) До востреб. Люкс/И	2014-08-28 19:05:51	\N	192	2014-08-28 19:05:51	\N	\N	13
6425	Обыкновенная Вручить (дата) До востреб. Люкс/М	2014-08-28 19:06:00	\N	192	2014-08-28 19:06:00	\N	\N	13
6426	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-08-28 19:09:52	\N	192	2014-08-28 19:09:52	\N	\N	13
6427	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-08-28 19:10:01	\N	192	2014-08-28 19:10:01	\N	\N	13
6428	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-08-28 19:10:27	\N	192	2014-08-28 19:10:27	\N	\N	13
6429	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-08-28 19:10:36	\N	192	2014-08-28 19:10:36	\N	\N	13
6430	Обыкновенная Вручить (дата) До востреб. Копия ЛК/М/И Увед. простое	2014-08-28 19:18:34	\N	192	2014-08-28 19:18:34	\N	\N	13
6431	Обыкновенная Вручить (дата) До востреб. Копия ЛК/М/И Увед. срочное	2014-08-28 19:18:43	\N	192	2014-08-28 19:18:43	\N	\N	13
6432	Обыкновенная Вручить (дата) До востреб. Копия Люкс Увед. простое	2014-08-28 19:18:59	\N	192	2014-08-28 19:18:59	\N	\N	13
6433	Обыкновенная Вручить (дата) До востреб. Копия Люкс Увед. срочное	2014-08-28 19:19:06	\N	192	2014-08-28 19:19:06	\N	\N	13
6434	Обыкновенная Вручить (дата) До востреб. Копия Люкс/В Увед. срочное	2014-08-28 19:19:15	\N	192	2014-08-28 19:19:15	\N	\N	13
6435	Обыкновенная Вручить (дата) До востреб. Копия Люкс/В Увед. простое	2014-08-28 19:19:20	\N	192	2014-08-28 19:19:20	\N	\N	13
6436	Обыкновенная Вручить (дата) До востреб. Копия Люкс/И Увед. простое	2014-08-28 19:19:29	\N	192	2014-08-28 19:19:29	\N	\N	13
6437	Обыкновенная Вручить (дата) До востреб. Копия Люкс/И Увед. срочное	2014-08-28 19:19:37	\N	192	2014-08-28 19:19:37	\N	\N	13
7204	Обыкновенная	2017-11-29 16:34:49	\N	880	2017-11-29 16:34:49	\N	\N	\N
6438	Обыкновенная Вручить (дата) До востреб. Копия Люкс/М Увед. простое	2014-08-28 19:20:04	\N	192	2014-08-28 19:20:04	\N	\N	13
6439	Обыкновенная Вручить (дата) До востреб. Копия Люкс/М Увед. срочное	2014-08-28 19:20:12	\N	192	2014-08-28 19:20:12	\N	\N	13
6440	Обыкновенная Вручить (дата) До востреб. ЛК/М/И Увед. простое	2014-08-28 19:35:33	\N	192	2014-08-28 19:35:33	\N	\N	13
6441	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-08-28 19:42:10	\N	192	2014-08-28 19:42:10	\N	\N	13
6442	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-08-28 19:42:32	\N	192	2014-08-28 19:42:32	\N	\N	13
6443	Обыкновенная А/Я Копия ЛК/М/И Служ. запрос пред	2014-08-28 19:43:41	\N	192	2014-08-28 19:43:41	\N	\N	13
6444	Обыкновенная А/Я Копия ЛК/М/И Служ. запрос част	2014-08-28 19:44:12	\N	192	2014-08-28 19:44:12	\N	\N	13
6445	Обыкновенная Вручить (дата) До востреб.	2014-08-28 19:53:38	\N	192	2014-08-28 19:53:38	\N	\N	13
6446	Обыкновенная Вручить (дата) До востреб. Копия	2014-08-28 19:54:49	\N	192	2014-08-28 19:54:49	\N	\N	13
6447	Обыкновенная Вручить (дата) До востреб. Копия ЛК/М/И	2014-08-28 19:55:41	\N	192	2014-08-28 19:55:41	\N	\N	13
6448	Обыкновенная Вручить (дата) До востреб. Копия Люкс	2014-08-28 19:56:10	\N	192	2014-08-28 19:56:10	\N	\N	13
6449	Обыкновенная Вручить (дата) До востреб. Копия Люкс/В	2014-08-28 19:56:25	\N	192	2014-08-28 19:56:25	\N	\N	13
6450	Обыкновенная Вручить (дата) До востреб. Люкс/М Увед. срочное	2014-08-28 19:57:11	\N	192	2014-08-28 19:57:11	\N	\N	13
6451	Обыкновенная Вручить (дата) До востреб. Копия Люкс/И	2014-08-28 19:57:37	\N	192	2014-08-28 19:57:37	\N	\N	13
6554	Обыкновенная А/Я Люкс Служ. запрос пред	2014-09-12 13:04:55	\N	187	2014-09-12 13:04:55	\N	\N	13
6555	Обыкновенная А/Я Люкс Служ. запрос част	2014-09-12 13:05:35	\N	187	2014-09-12 13:05:35	\N	\N	13
6556	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-09-12 13:06:00	\N	187	2014-09-12 13:06:00	\N	\N	13
6557	Срочная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 13:11:09	\N	188	2014-09-12 13:11:09	\N	\N	13
6558	Срочная А/Я Заверенная Копия Служ. запрос част	2014-09-12 13:11:24	\N	188	2014-09-12 13:11:24	\N	\N	13
6559	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 13:11:38	\N	188	2014-09-12 13:11:38	\N	\N	13
6560	Срочная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 13:11:51	\N	188	2014-09-12 13:11:51	\N	\N	13
6561	Срочная До востреб. Люкс Служ. запрос част	2014-09-12 13:12:05	\N	188	2014-09-12 13:12:05	\N	\N	13
6562	Срочная До востреб. Люкс Служ. запрос пред	2014-09-12 13:12:21	\N	188	2014-09-12 13:12:21	\N	\N	13
6563	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-12 13:15:34	\N	189	2014-09-12 13:15:34	\N	\N	13
6564	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 13:15:44	\N	189	2014-09-12 13:15:44	\N	\N	13
6565	Обыкновенная До востреб. Копия Служ. запрос пред	2014-09-12 13:16:07	\N	189	2014-09-12 13:16:07	\N	\N	13
6566	Обыкновенная До востреб. Копия Служ. запрос част	2014-09-12 13:16:22	\N	189	2014-09-12 13:16:22	\N	\N	13
6567	Обыкновенная А/Я Копия Служ. запрос пред	2014-09-12 13:16:39	\N	189	2014-09-12 13:16:39	\N	\N	13
6568	Обыкновенная А/Я Копия Служ. запрос част	2014-09-12 13:16:49	\N	189	2014-09-12 13:16:49	\N	\N	13
6569	Обыкновенная До востреб. Люкс Служ. запрос пред	2014-09-12 13:19:18	\N	189	2014-09-12 13:19:18	\N	\N	13
6570	Обыкновенная До востреб. Люкс Служ. запрос част	2014-09-12 13:19:39	\N	189	2014-09-12 13:19:39	\N	\N	13
6571	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-12 13:20:12	\N	189	2014-09-12 13:20:12	\N	\N	13
6572	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-12 13:20:48	\N	189	2014-09-12 13:20:48	\N	\N	13
6573	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 13:21:07	\N	189	2014-09-12 13:21:07	\N	\N	13
6574	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 13:21:18	\N	189	2014-09-12 13:21:18	\N	\N	13
6575	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-12 13:21:48	\N	189	2014-09-12 13:21:48	\N	\N	13
6576	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-12 13:22:08	\N	189	2014-09-12 13:22:08	\N	\N	13
6577	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-12 13:23:10	\N	189	2014-09-12 13:23:10	\N	\N	13
6578	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-12 13:23:30	\N	189	2014-09-12 13:23:30	\N	\N	13
6579	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 13:23:48	\N	189	2014-09-12 13:23:48	\N	\N	13
6580	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 13:24:01	\N	189	2014-09-12 13:24:01	\N	\N	13
6581	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-12 13:26:39	\N	179	2014-09-12 13:26:39	\N	\N	13
6582	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 13:26:49	\N	179	2014-09-12 13:26:49	\N	\N	13
6583	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 13:27:07	\N	179	2014-09-12 13:27:07	\N	\N	13
6584	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 13:27:22	\N	179	2014-09-12 13:27:22	\N	\N	13
6585	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-12 13:27:35	\N	179	2014-09-12 13:27:35	\N	\N	13
6586	Обыкновенная А/Я Копия Служ. запрос част	2014-09-12 13:27:52	\N	179	2014-09-12 13:27:52	\N	\N	13
6587	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 13:28:09	\N	179	2014-09-12 13:28:09	\N	\N	13
6588	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 13:28:23	\N	179	2014-09-12 13:28:23	\N	\N	13
6589	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 13:28:50	\N	179	2014-09-12 13:28:50	\N	\N	13
6590	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 13:29:03	\N	179	2014-09-12 13:29:03	\N	\N	13
6591	Срочная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 13:29:33	\N	179	2014-09-12 13:29:33	\N	\N	13
6592	Срочная А/Я Заверенная	2014-09-12 13:30:13	\N	179	2014-09-12 13:30:13	\N	\N	13
6593	Срочная А/Я Заверенная Копия	2014-09-12 13:30:28	\N	179	2014-09-12 13:30:28	\N	\N	13
6594	Срочная А/Я Заверенная Служ. запрос пред	2014-09-12 14:04:45	\N	179	2014-09-12 14:04:45	\N	\N	13
6595	Срочная А/Я Копия	2014-09-12 14:05:04	\N	179	2014-09-12 14:05:04	\N	\N	13
6596	Срочная А/Я Копия Служ. запрос пред	2014-09-12 14:05:14	\N	179	2014-09-12 14:05:14	\N	\N	13
6597	Срочная А/Я Копия Служ. запрос част	2014-09-12 14:05:29	\N	179	2014-09-12 14:05:29	\N	\N	13
6598	Срочная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 14:05:49	\N	179	2014-09-12 14:05:49	\N	\N	13
6599	Срочная А/Я Заверенная Копия Служ. запрос част	2014-09-12 14:06:00	\N	179	2014-09-12 14:06:00	\N	\N	13
6389	Обыкновенная А/Я Вручить (дата)	2014-04-25 15:04:33	2014-04-25 15:04:46	192	2014-04-25 15:04:46	\N	\N	1
6390	Обыкновенная Вручить (дата) Копия Люкс Увед. простое	2014-04-25 15:10:23	\N	192	2014-04-25 15:10:23	\N	\N	1
6397	Обыкновенная А/Я Служ. запрос пред	2014-07-23 17:44:35	\N	188	2014-07-23 17:44:35	\N	\N	13
6398	Обыкновенная А/Я Служ. запрос част	2014-07-23 17:45:23	\N	188	2014-07-23 17:45:23	\N	\N	13
6399	Обыкновенная А/Я Копия Служ. запрос пред	2014-07-23 17:47:27	\N	188	2014-07-23 17:47:27	\N	\N	13
6400	Обыкновенная А/Я Копия Люкс Служ. запрос пред	2014-07-24 14:07:53	\N	188	2014-07-24 14:07:53	\N	\N	13
6401	Обыкновенная А/Я Копия Служ. запрос част	2014-07-24 14:08:17	\N	188	2014-07-24 14:08:17	\N	\N	13
6402	Обыкновенная Заверенная Копия Служ. запрос пред	2014-07-24 14:11:39	\N	188	2014-07-24 14:11:39	\N	\N	13
6403	Обыкновенная Заверенная Копия Служ. запрос част	2014-07-24 14:11:57	\N	188	2014-07-24 14:11:57	\N	\N	13
6404	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-07-24 14:14:10	\N	188	2014-07-24 14:14:10	\N	\N	13
6405	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-07-24 14:14:28	\N	188	2014-07-24 14:14:28	\N	\N	13
6406	Обыкновенная Копия Люкс Служ. запрос част	2014-07-24 14:17:00	\N	188	2014-07-24 14:17:00	\N	\N	13
6407	Обыкновенная Копия Люкс Служ. запрос пред	2014-07-24 14:20:56	\N	188	2014-07-24 14:20:56	\N	\N	13
6408	Обыкновенная Заверенная Служ. запрос част	2014-07-24 16:35:24	\N	188	2014-07-24 16:35:24	\N	\N	13
6409	Обыкновенная Заверенная Служ. запрос пред	2014-07-24 16:35:35	\N	188	2014-07-24 16:35:35	\N	\N	13
6410	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-07-24 16:39:50	\N	188	2014-07-24 16:39:50	\N	\N	13
6411	Обыкновенная До востреб. Заверенная Служ. запрос част	2014-07-24 16:40:02	\N	188	2014-07-24 16:40:02	\N	\N	13
6412	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-07-24 16:40:46	\N	188	2014-07-24 16:40:46	\N	\N	13
6413	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-07-24 16:42:46	\N	188	2014-07-24 16:42:46	\N	\N	13
6452	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-08-29 09:49:36	\N	191	2014-08-29 09:49:36	\N	\N	13
6453	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-08-29 09:50:07	\N	191	2014-08-29 09:50:07	\N	\N	13
6454	Обыкновенная Заверенная Копия Служ. запрос пред	2014-08-29 10:18:43	\N	193	2014-08-29 10:18:43	\N	\N	13
6455	Обыкновенная Заверенная Копия Служ. запрос част	2014-08-29 10:19:03	\N	193	2014-08-29 10:19:03	\N	\N	13
6456	Обыкновенная До востреб. Заверенная Служ. запрос пред	2014-08-29 10:21:41	\N	193	2014-08-29 10:21:41	\N	\N	13
6457	Обыкновенная Заверенная Копия Служ. запрос пред	2014-08-29 18:07:36	\N	178	2014-08-29 18:07:36	\N	\N	13
6458	Обыкновенная Заверенная Копия Служ. запрос част	2014-08-29 18:08:10	\N	178	2014-08-29 18:08:10	\N	\N	13
6459	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-08-29 18:08:40	\N	178	2014-08-29 18:08:40	\N	\N	13
6460	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-08-29 18:08:51	\N	178	2014-08-29 18:08:51	\N	\N	13
6461	Обыкновенная До востреб. Служ. запрос пред	2014-08-29 18:10:24	\N	178	2014-08-29 18:10:24	\N	\N	13
6462	Обыкновенная До востреб. Служ. запрос част	2014-08-29 18:10:48	\N	178	2014-08-29 18:10:48	\N	\N	13
6463	Обыкновенная До востреб. Копия Служ. запрос пред	2014-08-29 18:11:08	\N	178	2014-08-29 18:11:08	\N	\N	13
6464	Обыкновенная До востреб. Копия Служ. запрос част	2014-08-29 18:11:23	\N	178	2014-08-29 18:11:23	\N	\N	13
6465	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-08-29 18:12:20	\N	178	2014-08-29 18:12:20	\N	\N	13
6466	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-08-29 18:12:42	\N	178	2014-08-29 18:12:42	\N	\N	13
6467	Обыкновенная А/Я Вручить (дата) Служ. запрос пред	2014-08-29 18:13:18	\N	178	2014-08-29 18:13:18	\N	\N	13
7205	Правительственная	2017-11-29 16:34:49	\N	880	2017-11-29 16:34:49	\N	\N	\N
6600	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-12 14:07:49	\N	191	2014-09-12 14:07:49	\N	\N	13
6601	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-12 14:08:20	\N	191	2014-09-12 14:08:20	\N	\N	13
6602	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 14:09:06	\N	191	2014-09-12 14:09:06	\N	\N	13
6603	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 14:09:40	\N	191	2014-09-12 14:09:40	\N	\N	13
6604	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-12 16:53:55	\N	190	2014-09-12 16:53:55	\N	\N	13
6605	Обыкновенная Заверенная Служ. запрос част	2014-09-12 16:54:28	\N	190	2014-09-12 16:54:28	\N	\N	13
6606	Обыкновенная Заверенная Служ. запрос пред	2014-09-12 16:55:08	\N	190	2014-09-12 16:55:08	\N	\N	13
6607	Обыкновенная Заверенная Копия Служ. запрос пред	2014-09-12 16:55:20	\N	190	2014-09-12 16:55:20	\N	\N	13
6608	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-12 17:08:05	\N	190	2014-09-12 17:08:05	\N	\N	13
6609	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 17:22:03	\N	190	2014-09-12 17:22:03	\N	\N	13
6610	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 17:22:16	\N	190	2014-09-12 17:22:16	\N	\N	13
6611	Срочная Заверенная Копия Служ. запрос пред	2014-09-12 17:22:36	\N	190	2014-09-12 17:22:36	\N	\N	13
6612	Срочная Заверенная Копия Служ. запрос част	2014-09-12 17:22:44	\N	190	2014-09-12 17:22:44	\N	\N	13
6613	Обыкновенная До востреб. Служ. запрос пред	2014-09-12 17:23:06	\N	190	2014-09-12 17:23:06	\N	\N	13
6614	Обыкновенная До востреб. Служ. запрос част	2014-09-12 17:25:02	\N	190	2014-09-12 17:25:02	\N	\N	13
6615	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 17:27:36	\N	190	2014-09-12 17:27:36	\N	\N	13
6616	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 17:27:48	\N	190	2014-09-12 17:27:48	\N	\N	13
6617	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 17:29:07	\N	190	2014-09-12 17:29:07	\N	\N	13
6618	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 17:29:55	\N	190	2014-09-12 17:29:55	\N	\N	13
6619	Срочная До востреб. Служ. запрос част	2014-09-12 17:34:38	\N	190	2014-09-12 17:34:38	\N	\N	13
6620	Срочная До востреб. Служ. запрос пред	2014-09-12 17:34:55	\N	190	2014-09-12 17:34:55	\N	\N	13
6621	Срочная До востреб. Копия Служ. запрос пред	2014-09-12 17:35:05	\N	190	2014-09-12 17:35:05	\N	\N	13
6622	Срочная До востреб. Копия Служ. запрос част	2014-09-12 17:35:14	\N	190	2014-09-12 17:35:14	\N	\N	13
6623	Обыкновенная А/Я Заверенная Служ. запрос пред	2014-09-12 17:35:42	\N	190	2014-09-12 17:35:42	\N	\N	13
6624	Обыкновенная А/Я Заверенная Служ. запрос част	2014-09-12 17:35:53	\N	190	2014-09-12 17:35:53	\N	\N	13
6625	Срочная А/Я Копия	2014-09-12 17:36:52	\N	190	2014-09-12 17:36:52	\N	\N	13
6626	Срочная А/Я Копия Служ. запрос пред	2014-09-12 17:38:04	\N	190	2014-09-12 17:38:04	\N	\N	13
6627	Срочная А/Я Копия Служ. запрос част	2014-09-12 17:38:15	\N	190	2014-09-12 17:38:15	\N	\N	13
6628	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос част	2014-09-12 17:38:43	\N	193	2014-09-12 17:38:43	\N	\N	13
6629	Обыкновенная Заверенная Копия Почтой заказное Служ. запрос пред	2014-09-12 17:38:55	\N	193	2014-09-12 17:38:55	\N	\N	13
6630	Обыкновенная А/Я Заверенная Копия Служ. запрос пред	2014-09-12 17:39:11	\N	193	2014-09-12 17:39:11	\N	\N	13
6631	Обыкновенная А/Я Заверенная Копия Служ. запрос част	2014-09-12 17:39:22	\N	193	2014-09-12 17:39:22	\N	\N	13
6632	Обыкновенная До востреб. Заверенная Служ. запрос част	2014-09-12 17:39:52	\N	193	2014-09-12 17:39:52	\N	\N	13
6633	Обыкновенная До востреб. Заверенная Копия Служ. запрос част	2014-09-12 17:40:12	\N	193	2014-09-12 17:40:12	\N	\N	13
6634	Обыкновенная До востреб. Заверенная Копия Служ. запрос пред	2014-09-12 17:40:27	\N	193	2014-09-12 17:40:27	\N	\N	13
6635	Обыкновенная До востреб. Копия Люкс Служ. запрос пред	2014-09-12 17:41:41	\N	193	2014-09-12 17:41:41	\N	\N	13
6636	Обыкновенная До востреб. Копия Люкс Служ. запрос част	2014-09-12 17:41:52	\N	193	2014-09-12 17:41:52	\N	\N	13
6637	Обыкновенная Вручить (дата) Копия Служ. запрос пред	2014-09-12 17:42:15	\N	193	2014-09-12 17:42:15	\N	\N	13
6638	Обыкновенная Вручить (дата) Копия Служ. запрос част	2014-09-12 17:42:30	\N	193	2014-09-12 17:42:30	\N	\N	13
6639	Срочная Заверенная Служ. запрос пред	2014-09-12 17:43:15	\N	193	2014-09-12 17:43:15	\N	\N	13
6640	Срочная Заверенная Служ. запрос част	2014-09-12 17:43:27	\N	193	2014-09-12 17:43:27	\N	\N	13
6641	Срочная До востреб. Служ. запрос пред	2014-09-12 17:43:42	\N	193	2014-09-12 17:43:42	\N	\N	13
6642	Срочная До востреб. Служ. запрос част	2014-09-12 17:43:53	\N	193	2014-09-12 17:43:53	\N	\N	13
6643	Срочная Заверенная Копия Служ. запрос част	2014-09-12 17:44:18	\N	193	2014-09-12 17:44:18	\N	\N	13
6644	Срочная Заверенная Копия Служ. запрос пред	2014-09-12 17:44:28	\N	193	2014-09-12 17:44:28	\N	\N	13
6645	Срочная Делюкс Копия Служ. запрос пред	2014-09-12 17:45:00	\N	193	2014-09-12 17:45:00	\N	\N	13
6646	Срочная Делюкс Копия Служ. запрос част	2014-09-12 17:45:11	\N	193	2014-09-12 17:45:11	\N	\N	13
6647	Обыкновенная Заверенная Служ. запрос част	2014-09-12 17:46:50	\N	177	2014-09-12 17:46:50	\N	\N	13
7206	Обыкновенная	2017-11-29 16:34:49	\N	881	2017-11-29 16:34:49	\N	\N	\N
6648	Обыкновенная Заверенная Почтой заказное Служ. запрос пред	2014-09-12 17:49:27	\N	177	2014-09-12 17:49:27	\N	\N	13
6649	Обыкновенная Заверенная Копия Служ. запрос част	2014-09-12 17:49:48	\N	177	2014-09-12 17:49:48	\N	\N	13
6650	Обыкновенная Заверенная Почтой заказное Служ. запрос част	2014-09-12 17:50:07	\N	177	2014-09-12 17:50:07	\N	\N	13
7130	Обыкновенная	2017-11-29 16:34:49	\N	842	2017-11-29 16:34:49	\N	\N	\N
7131	Правительственная	2017-11-29 16:34:49	\N	842	2017-11-29 16:34:49	\N	\N	\N
7132	Обыкновенная	2017-11-29 16:34:49	\N	843	2017-11-29 16:34:49	\N	\N	\N
7133	Правительственная	2017-11-29 16:34:49	\N	843	2017-11-29 16:34:49	\N	\N	\N
7134	Обыкновенная	2017-11-29 16:34:49	\N	844	2017-11-29 16:34:49	\N	\N	\N
7135	Правительственная	2017-11-29 16:34:49	\N	844	2017-11-29 16:34:49	\N	\N	\N
7136	Обыкновенная	2017-11-29 16:34:49	\N	845	2017-11-29 16:34:49	\N	\N	\N
7137	Правительственная	2017-11-29 16:34:49	\N	845	2017-11-29 16:34:49	\N	\N	\N
7138	Обыкновенная	2017-11-29 16:34:49	\N	846	2017-11-29 16:34:49	\N	\N	\N
7139	Правительственная	2017-11-29 16:34:49	\N	846	2017-11-29 16:34:49	\N	\N	\N
7140	Обыкновенная	2017-11-29 16:34:49	\N	847	2017-11-29 16:34:49	\N	\N	\N
7141	Правительственная	2017-11-29 16:34:49	\N	847	2017-11-29 16:34:49	\N	\N	\N
7142	Обыкновенная	2017-11-29 16:34:49	\N	848	2017-11-29 16:34:49	\N	\N	\N
7143	Правительственная	2017-11-29 16:34:49	\N	848	2017-11-29 16:34:49	\N	\N	\N
7144	Обыкновенная	2017-11-29 16:34:49	\N	849	2017-11-29 16:34:49	\N	\N	\N
7145	Правительственная	2017-11-29 16:34:49	\N	849	2017-11-29 16:34:49	\N	\N	\N
7146	Обыкновенная	2017-11-29 16:34:49	\N	850	2017-11-29 16:34:49	\N	\N	\N
7147	Правительственная	2017-11-29 16:34:49	\N	850	2017-11-29 16:34:49	\N	\N	\N
7148	Обыкновенная	2017-11-29 16:34:49	\N	851	2017-11-29 16:34:49	\N	\N	\N
7149	Правительственная	2017-11-29 16:34:49	\N	851	2017-11-29 16:34:49	\N	\N	\N
7150	Обыкновенная	2017-11-29 16:34:49	\N	852	2017-11-29 16:34:49	\N	\N	\N
7151	Правительственная	2017-11-29 16:34:49	\N	852	2017-11-29 16:34:49	\N	\N	\N
7152	Обыкновенная	2017-11-29 16:34:49	\N	853	2017-11-29 16:34:49	\N	\N	\N
7153	Правительственная	2017-11-29 16:34:49	\N	853	2017-11-29 16:34:49	\N	\N	\N
7154	Обыкновенная	2017-11-29 16:34:49	\N	854	2017-11-29 16:34:49	\N	\N	\N
7155	Правительственная	2017-11-29 16:34:49	\N	854	2017-11-29 16:34:49	\N	\N	\N
7156	Обыкновенная	2017-11-29 16:34:49	\N	855	2017-11-29 16:34:49	\N	\N	\N
7157	Правительственная	2017-11-29 16:34:49	\N	855	2017-11-29 16:34:49	\N	\N	\N
7158	Обыкновенная	2017-11-29 16:34:49	\N	856	2017-11-29 16:34:49	\N	\N	\N
7159	Правительственная	2017-11-29 16:34:49	\N	856	2017-11-29 16:34:49	\N	\N	\N
7160	Обыкновенная	2017-11-29 16:34:49	\N	857	2017-11-29 16:34:49	\N	\N	\N
7161	Правительственная	2017-11-29 16:34:49	\N	857	2017-11-29 16:34:49	\N	\N	\N
7162	Обыкновенная	2017-11-29 16:34:49	\N	858	2017-11-29 16:34:49	\N	\N	\N
7163	Правительственная	2017-11-29 16:34:49	\N	858	2017-11-29 16:34:49	\N	\N	\N
7164	Обыкновенная	2017-11-29 16:34:49	\N	859	2017-11-29 16:34:49	\N	\N	\N
7165	Правительственная	2017-11-29 16:34:49	\N	859	2017-11-29 16:34:49	\N	\N	\N
7166	Обыкновенная	2017-11-29 16:34:49	\N	861	2017-11-29 16:34:49	\N	\N	\N
7167	Правительственная	2017-11-29 16:34:49	\N	861	2017-11-29 16:34:49	\N	\N	\N
7168	Обыкновенная	2017-11-29 16:34:49	\N	862	2017-11-29 16:34:49	\N	\N	\N
7169	Правительственная	2017-11-29 16:34:49	\N	862	2017-11-29 16:34:49	\N	\N	\N
7170	Обыкновенная	2017-11-29 16:34:49	\N	863	2017-11-29 16:34:49	\N	\N	\N
7171	Правительственная	2017-11-29 16:34:49	\N	863	2017-11-29 16:34:49	\N	\N	\N
7172	Обыкновенная	2017-11-29 16:34:49	\N	864	2017-11-29 16:34:49	\N	\N	\N
7173	Правительственная	2017-11-29 16:34:49	\N	864	2017-11-29 16:34:49	\N	\N	\N
7174	Обыкновенная	2017-11-29 16:34:49	\N	865	2017-11-29 16:34:49	\N	\N	\N
7175	Правительственная	2017-11-29 16:34:49	\N	865	2017-11-29 16:34:49	\N	\N	\N
7176	Обыкновенная	2017-11-29 16:34:49	\N	866	2017-11-29 16:34:49	\N	\N	\N
7177	Правительственная	2017-11-29 16:34:49	\N	866	2017-11-29 16:34:49	\N	\N	\N
7178	Обыкновенная	2017-11-29 16:34:49	\N	867	2017-11-29 16:34:49	\N	\N	\N
7179	Правительственная	2017-11-29 16:34:49	\N	867	2017-11-29 16:34:49	\N	\N	\N
7180	Обыкновенная	2017-11-29 16:34:49	\N	868	2017-11-29 16:34:49	\N	\N	\N
7181	Правительственная	2017-11-29 16:34:49	\N	868	2017-11-29 16:34:49	\N	\N	\N
7182	Обыкновенная	2017-11-29 16:34:49	\N	869	2017-11-29 16:34:49	\N	\N	\N
7183	Правительственная	2017-11-29 16:34:49	\N	869	2017-11-29 16:34:49	\N	\N	\N
7184	Обыкновенная	2017-11-29 16:34:49	\N	870	2017-11-29 16:34:49	\N	\N	\N
7185	Правительственная	2017-11-29 16:34:49	\N	870	2017-11-29 16:34:49	\N	\N	\N
7186	Обыкновенная	2017-11-29 16:34:49	\N	871	2017-11-29 16:34:49	\N	\N	\N
7187	Правительственная	2017-11-29 16:34:49	\N	871	2017-11-29 16:34:49	\N	\N	\N
7188	Обыкновенная	2017-11-29 16:34:49	\N	872	2017-11-29 16:34:49	\N	\N	\N
7189	Правительственная	2017-11-29 16:34:49	\N	872	2017-11-29 16:34:49	\N	\N	\N
7190	Обыкновенная	2017-11-29 16:34:49	\N	873	2017-11-29 16:34:49	\N	\N	\N
7191	Правительственная	2017-11-29 16:34:49	\N	873	2017-11-29 16:34:49	\N	\N	\N
7192	Обыкновенная	2017-11-29 16:34:49	\N	874	2017-11-29 16:34:49	\N	\N	\N
7193	Правительственная	2017-11-29 16:34:49	\N	874	2017-11-29 16:34:49	\N	\N	\N
7194	Обыкновенная	2017-11-29 16:34:49	\N	875	2017-11-29 16:34:49	\N	\N	\N
7195	Правительственная	2017-11-29 16:34:49	\N	875	2017-11-29 16:34:49	\N	\N	\N
7196	Обыкновенная	2017-11-29 16:34:49	\N	876	2017-11-29 16:34:49	\N	\N	\N
7197	Правительственная	2017-11-29 16:34:49	\N	876	2017-11-29 16:34:49	\N	\N	\N
7198	Обыкновенная	2017-11-29 16:34:49	\N	877	2017-11-29 16:34:49	\N	\N	\N
7199	Правительственная	2017-11-29 16:34:49	\N	877	2017-11-29 16:34:49	\N	\N	\N
7200	Обыкновенная	2017-11-29 16:34:49	\N	878	2017-11-29 16:34:49	\N	\N	\N
7201	Правительственная	2017-11-29 16:34:49	\N	878	2017-11-29 16:34:49	\N	\N	\N
7202	Обыкновенная	2017-11-29 16:34:49	\N	879	2017-11-29 16:34:49	\N	\N	\N
7207	Правительственная	2017-11-29 16:34:49	\N	881	2017-11-29 16:34:49	\N	\N	\N
7208	Обыкновенная	2017-11-29 16:34:49	\N	882	2017-11-29 16:34:49	\N	\N	\N
7209	Правительственная	2017-11-29 16:34:49	\N	882	2017-11-29 16:34:49	\N	\N	\N
7210	Обыкновенная	2017-11-29 16:34:49	\N	883	2017-11-29 16:34:49	\N	\N	\N
7211	Правительственная	2017-11-29 16:34:49	\N	883	2017-11-29 16:34:49	\N	\N	\N
7212	Обыкновенная	2017-11-29 16:34:49	\N	884	2017-11-29 16:34:49	\N	\N	\N
7213	Правительственная	2017-11-29 16:34:49	\N	884	2017-11-29 16:34:49	\N	\N	\N
7214	Обыкновенная	2017-11-29 16:34:49	\N	885	2017-11-29 16:34:49	\N	\N	\N
7215	Правительственная	2017-11-29 16:34:49	\N	885	2017-11-29 16:34:49	\N	\N	\N
7216	Обыкновенная	2017-11-29 16:34:49	\N	886	2017-11-29 16:34:49	\N	\N	\N
7217	Правительственная	2017-11-29 16:34:49	\N	886	2017-11-29 16:34:49	\N	\N	\N
7218	Обыкновенная	2017-11-29 16:34:49	\N	887	2017-11-29 16:34:49	\N	\N	\N
7219	Правительственная	2017-11-29 16:34:49	\N	887	2017-11-29 16:34:49	\N	\N	\N
7220	Обыкновенная	2017-11-29 16:34:49	\N	888	2017-11-29 16:34:49	\N	\N	\N
7221	Правительственная	2017-11-29 16:34:49	\N	888	2017-11-29 16:34:49	\N	\N	\N
7222	Обыкновенная	2017-11-29 16:34:49	\N	889	2017-11-29 16:34:49	\N	\N	\N
7223	Правительственная	2017-11-29 16:34:49	\N	889	2017-11-29 16:34:49	\N	\N	\N
7224	Обыкновенная	2017-11-29 16:34:49	\N	890	2017-11-29 16:34:49	\N	\N	\N
7225	Правительственная	2017-11-29 16:34:49	\N	890	2017-11-29 16:34:49	\N	\N	\N
7226	Обыкновенная	2017-11-29 16:34:49	\N	891	2017-11-29 16:34:49	\N	\N	\N
7227	Правительственная	2017-11-29 16:34:49	\N	891	2017-11-29 16:34:49	\N	\N	\N
7228	Обыкновенная	2017-11-29 16:34:49	\N	892	2017-11-29 16:34:49	\N	\N	\N
7229	Правительственная	2017-11-29 16:34:49	\N	892	2017-11-29 16:34:49	\N	\N	\N
7230	Обыкновенная	2017-11-29 16:34:49	\N	893	2017-11-29 16:34:49	\N	\N	\N
7231	Правительственная	2017-11-29 16:34:49	\N	893	2017-11-29 16:34:49	\N	\N	\N
7232	Обыкновенная	2017-11-29 16:34:49	\N	894	2017-11-29 16:34:49	\N	\N	\N
7233	Правительственная	2017-11-29 16:34:49	\N	894	2017-11-29 16:34:49	\N	\N	\N
7234	Обыкновенная	2017-11-29 16:34:49	\N	895	2017-11-29 16:34:49	\N	\N	\N
7235	Правительственная	2017-11-29 16:34:49	\N	895	2017-11-29 16:34:49	\N	\N	\N
7236	Обыкновенная	2017-11-29 16:34:49	\N	896	2017-11-29 16:34:49	\N	\N	\N
7237	Правительственная	2017-11-29 16:34:49	\N	896	2017-11-29 16:34:49	\N	\N	\N
7238	Обыкновенная	2017-11-29 16:34:49	\N	897	2017-11-29 16:34:49	\N	\N	\N
7239	Правительственная	2017-11-29 16:34:49	\N	897	2017-11-29 16:34:49	\N	\N	\N
7240	Обыкновенная	2017-11-29 16:34:49	\N	898	2017-11-29 16:34:49	\N	\N	\N
7241	Правительственная	2017-11-29 16:34:49	\N	898	2017-11-29 16:34:49	\N	\N	\N
7242	Обыкновенная	2017-11-29 16:34:49	\N	899	2017-11-29 16:34:49	\N	\N	\N
7243	Правительственная	2017-11-29 16:34:49	\N	899	2017-11-29 16:34:49	\N	\N	\N
7244	Обыкновенная	2017-11-29 16:34:49	\N	900	2017-11-29 16:34:49	\N	\N	\N
7245	Правительственная	2017-11-29 16:34:49	\N	900	2017-11-29 16:34:49	\N	\N	\N
7246	Обыкновенная	2017-11-29 16:34:49	\N	901	2017-11-29 16:34:49	\N	\N	\N
7247	Правительственная	2017-11-29 16:34:49	\N	901	2017-11-29 16:34:49	\N	\N	\N
7248	Обыкновенная	2017-11-29 16:34:49	\N	902	2017-11-29 16:34:49	\N	\N	\N
7249	Правительственная	2017-11-29 16:34:49	\N	902	2017-11-29 16:34:49	\N	\N	\N
7250	Обыкновенная	2017-11-29 16:34:49	\N	903	2017-11-29 16:34:49	\N	\N	\N
7251	Правительственная	2017-11-29 16:34:49	\N	903	2017-11-29 16:34:49	\N	\N	\N
7252	Обыкновенная	2017-11-29 16:34:49	\N	904	2017-11-29 16:34:49	\N	\N	\N
7253	Правительственная	2017-11-29 16:34:49	\N	904	2017-11-29 16:34:49	\N	\N	\N
7254	Обыкновенная	2017-11-29 16:34:49	\N	905	2017-11-29 16:34:49	\N	\N	\N
7255	Правительственная	2017-11-29 16:34:49	\N	905	2017-11-29 16:34:49	\N	\N	\N
7256	Обыкновенная	2017-11-29 16:34:49	\N	906	2017-11-29 16:34:49	\N	\N	\N
7257	Правительственная	2017-11-29 16:34:49	\N	906	2017-11-29 16:34:49	\N	\N	\N
7258	Обыкновенная	2017-11-29 16:34:49	\N	907	2017-11-29 16:34:49	\N	\N	\N
7259	Правительственная	2017-11-29 16:34:49	\N	907	2017-11-29 16:34:49	\N	\N	\N
7260	Обыкновенная	2017-11-29 16:34:49	\N	908	2017-11-29 16:34:49	\N	\N	\N
7261	Правительственная	2017-11-29 16:34:49	\N	908	2017-11-29 16:34:49	\N	\N	\N
7262	Обыкновенная	2017-11-29 16:34:49	\N	909	2017-11-29 16:34:49	\N	\N	\N
7263	Правительственная	2017-11-29 16:34:49	\N	909	2017-11-29 16:34:49	\N	\N	\N
7264	Обыкновенная	2017-11-29 16:34:49	\N	910	2017-11-29 16:34:49	\N	\N	\N
7265	Правительственная	2017-11-29 16:34:49	\N	910	2017-11-29 16:34:49	\N	\N	\N
7266	Обыкновенная	2017-11-29 16:34:49	\N	911	2017-11-29 16:34:49	\N	\N	\N
7267	Правительственная	2017-11-29 16:34:49	\N	911	2017-11-29 16:34:49	\N	\N	\N
7268	Обыкновенная	2017-11-29 16:34:49	\N	912	2017-11-29 16:34:49	\N	\N	\N
7269	Правительственная	2017-11-29 16:34:49	\N	912	2017-11-29 16:34:49	\N	\N	\N
7270	Обыкновенная	2017-11-29 16:34:49	\N	913	2017-11-29 16:34:49	\N	\N	\N
7271	Правительственная	2017-11-29 16:34:49	\N	913	2017-11-29 16:34:49	\N	\N	\N
7272	Обыкновенная	2017-11-29 16:34:49	\N	914	2017-11-29 16:34:49	\N	\N	\N
7273	Правительственная	2017-11-29 16:34:49	\N	914	2017-11-29 16:34:49	\N	\N	\N
7274	Обыкновенная	2017-11-29 16:34:49	\N	915	2017-11-29 16:34:49	\N	\N	\N
7275	Правительственная	2017-11-29 16:34:49	\N	915	2017-11-29 16:34:49	\N	\N	\N
7276	Обыкновенная	2017-11-29 16:34:49	\N	916	2017-11-29 16:34:49	\N	\N	\N
7277	Правительственная	2017-11-29 16:34:49	\N	916	2017-11-29 16:34:49	\N	\N	\N
7278	Обыкновенная	2017-11-29 16:34:49	\N	917	2017-11-29 16:34:49	\N	\N	\N
7279	Правительственная	2017-11-29 16:34:49	\N	917	2017-11-29 16:34:49	\N	\N	\N
7280	Обыкновенная	2017-11-29 16:34:49	\N	918	2017-11-29 16:34:49	\N	\N	\N
7281	Правительственная	2017-11-29 16:34:49	\N	918	2017-11-29 16:34:49	\N	\N	\N
7282	Обыкновенная	2017-11-29 16:34:49	\N	919	2017-11-29 16:34:49	\N	\N	\N
7283	Правительственная	2017-11-29 16:34:49	\N	919	2017-11-29 16:34:49	\N	\N	\N
7284	Обыкновенная	2017-11-29 16:34:49	\N	920	2017-11-29 16:34:49	\N	\N	\N
7285	Правительственная	2017-11-29 16:34:49	\N	920	2017-11-29 16:34:49	\N	\N	\N
7286	Обыкновенная	2017-11-29 16:34:49	\N	921	2017-11-29 16:34:49	\N	\N	\N
7287	Правительственная	2017-11-29 16:34:49	\N	921	2017-11-29 16:34:49	\N	\N	\N
7288	Обыкновенная	2017-11-29 16:34:49	\N	922	2017-11-29 16:34:49	\N	\N	\N
7289	Правительственная	2017-11-29 16:34:49	\N	922	2017-11-29 16:34:49	\N	\N	\N
7290	Обыкновенная	2017-11-29 16:34:49	\N	923	2017-11-29 16:34:49	\N	\N	\N
7291	Правительственная	2017-11-29 16:34:49	\N	923	2017-11-29 16:34:49	\N	\N	\N
7292	Обыкновенная	2017-11-29 16:34:49	\N	924	2017-11-29 16:34:49	\N	\N	\N
7293	Правительственная	2017-11-29 16:34:49	\N	924	2017-11-29 16:34:49	\N	\N	\N
7294	Обыкновенная	2017-11-29 16:34:49	\N	925	2017-11-29 16:34:49	\N	\N	\N
7295	Правительственная	2017-11-29 16:34:49	\N	925	2017-11-29 16:34:49	\N	\N	\N
7296	Обыкновенная	2017-11-29 16:34:49	\N	926	2017-11-29 16:34:49	\N	\N	\N
7297	Правительственная	2017-11-29 16:34:49	\N	926	2017-11-29 16:34:49	\N	\N	\N
7298	Обыкновенная	2017-11-29 16:34:49	\N	927	2017-11-29 16:34:49	\N	\N	\N
7299	Правительственная	2017-11-29 16:34:49	\N	927	2017-11-29 16:34:49	\N	\N	\N
7300	Обыкновенная	2017-11-29 16:34:49	\N	928	2017-11-29 16:34:49	\N	\N	\N
7301	Правительственная	2017-11-29 16:34:49	\N	928	2017-11-29 16:34:49	\N	\N	\N
7302	Обыкновенная	2017-11-29 16:34:49	\N	929	2017-11-29 16:34:49	\N	\N	\N
7303	Правительственная	2017-11-29 16:34:49	\N	929	2017-11-29 16:34:49	\N	\N	\N
7304	Обыкновенная	2017-11-29 16:34:49	\N	930	2017-11-29 16:34:49	\N	\N	\N
7305	Правительственная	2017-11-29 16:34:49	\N	930	2017-11-29 16:34:49	\N	\N	\N
7306	Обыкновенная	2017-11-29 16:34:49	\N	931	2017-11-29 16:34:49	\N	\N	\N
7307	Правительственная	2017-11-29 16:34:49	\N	931	2017-11-29 16:34:49	\N	\N	\N
7308	Обыкновенная	2017-11-29 16:34:49	\N	932	2017-11-29 16:34:49	\N	\N	\N
7309	Правительственная	2017-11-29 16:34:49	\N	932	2017-11-29 16:34:49	\N	\N	\N
7310	Обыкновенная	2017-11-29 16:34:49	\N	933	2017-11-29 16:34:49	\N	\N	\N
7311	Правительственная	2017-11-29 16:34:49	\N	933	2017-11-29 16:34:49	\N	\N	\N
7312	Обыкновенная	2017-11-29 16:34:49	\N	934	2017-11-29 16:34:49	\N	\N	\N
7313	Правительственная	2017-11-29 16:34:49	\N	934	2017-11-29 16:34:49	\N	\N	\N
7314	Обыкновенная	2017-11-29 16:34:49	\N	935	2017-11-29 16:34:49	\N	\N	\N
7315	Правительственная	2017-11-29 16:34:49	\N	935	2017-11-29 16:34:49	\N	\N	\N
7316	Обыкновенная	2017-11-29 16:34:49	\N	936	2017-11-29 16:34:49	\N	\N	\N
7317	Правительственная	2017-11-29 16:34:49	\N	936	2017-11-29 16:34:49	\N	\N	\N
7318	Обыкновенная	2017-11-29 16:34:49	\N	937	2017-11-29 16:34:49	\N	\N	\N
7319	Правительственная	2017-11-29 16:34:49	\N	937	2017-11-29 16:34:49	\N	\N	\N
7320	Обыкновенная	2017-11-29 16:34:49	\N	938	2017-11-29 16:34:49	\N	\N	\N
7321	Правительственная	2017-11-29 16:34:49	\N	938	2017-11-29 16:34:49	\N	\N	\N
7322	Обыкновенная	2017-11-29 16:34:49	\N	939	2017-11-29 16:34:49	\N	\N	\N
7323	Правительственная	2017-11-29 16:34:49	\N	939	2017-11-29 16:34:49	\N	\N	\N
7324	Обыкновенная	2017-11-29 16:34:49	\N	940	2017-11-29 16:34:49	\N	\N	\N
7325	Правительственная	2017-11-29 16:34:49	\N	940	2017-11-29 16:34:49	\N	\N	\N
7326	Обыкновенная	2017-11-29 16:34:49	\N	941	2017-11-29 16:34:49	\N	\N	\N
7327	Правительственная	2017-11-29 16:34:49	\N	941	2017-11-29 16:34:49	\N	\N	\N
7328	Обыкновенная	2017-11-29 16:34:49	\N	942	2017-11-29 16:34:49	\N	\N	\N
7329	Правительственная	2017-11-29 16:34:49	\N	942	2017-11-29 16:34:49	\N	\N	\N
7330	Обыкновенная	2017-11-29 16:34:49	\N	943	2017-11-29 16:34:49	\N	\N	\N
7331	Правительственная	2017-11-29 16:34:49	\N	943	2017-11-29 16:34:49	\N	\N	\N
7332	Обыкновенная	2017-11-29 16:34:49	\N	944	2017-11-29 16:34:49	\N	\N	\N
7333	Правительственная	2017-11-29 16:34:49	\N	944	2017-11-29 16:34:49	\N	\N	\N
7334	Обыкновенная	2017-11-29 16:34:49	\N	945	2017-11-29 16:34:49	\N	\N	\N
7335	Правительственная	2017-11-29 16:34:49	\N	945	2017-11-29 16:34:49	\N	\N	\N
7336	Обыкновенная	2017-11-29 16:34:49	\N	946	2017-11-29 16:34:49	\N	\N	\N
7337	Правительственная	2017-11-29 16:34:49	\N	946	2017-11-29 16:34:49	\N	\N	\N
7338	Обыкновенная	2017-11-29 16:34:49	\N	947	2017-11-29 16:34:49	\N	\N	\N
7339	Правительственная	2017-11-29 16:34:49	\N	947	2017-11-29 16:34:49	\N	\N	\N
7340	Обыкновенная	2017-11-29 16:34:49	\N	948	2017-11-29 16:34:49	\N	\N	\N
7341	Правительственная	2017-11-29 16:34:49	\N	948	2017-11-29 16:34:49	\N	\N	\N
7342	Обыкновенная	2017-11-29 16:34:49	\N	949	2017-11-29 16:34:49	\N	\N	\N
7343	Правительственная	2017-11-29 16:34:49	\N	949	2017-11-29 16:34:49	\N	\N	\N
7344	Обыкновенная	2017-11-29 16:34:49	\N	950	2017-11-29 16:34:49	\N	\N	\N
7345	Правительственная	2017-11-29 16:34:49	\N	950	2017-11-29 16:34:49	\N	\N	\N
7346	Обыкновенная	2017-11-29 16:34:49	\N	951	2017-11-29 16:34:49	\N	\N	\N
7347	Правительственная	2017-11-29 16:34:49	\N	951	2017-11-29 16:34:49	\N	\N	\N
7348	Обыкновенная	2017-11-29 16:34:49	\N	952	2017-11-29 16:34:49	\N	\N	\N
7349	Правительственная	2017-11-29 16:34:49	\N	952	2017-11-29 16:34:49	\N	\N	\N
7350	Обыкновенная	2017-11-29 16:34:49	\N	953	2017-11-29 16:34:49	\N	\N	\N
7351	Правительственная	2017-11-29 16:34:49	\N	953	2017-11-29 16:34:49	\N	\N	\N
7352	Обыкновенная	2017-11-29 16:34:49	\N	954	2017-11-29 16:34:49	\N	\N	\N
7353	Правительственная	2017-11-29 16:34:49	\N	954	2017-11-29 16:34:49	\N	\N	\N
7354	Обыкновенная	2017-11-29 16:34:49	\N	955	2017-11-29 16:34:49	\N	\N	\N
7355	Правительственная	2017-11-29 16:34:49	\N	955	2017-11-29 16:34:49	\N	\N	\N
7356	Обыкновенная	2017-11-29 16:34:49	\N	956	2017-11-29 16:34:49	\N	\N	\N
7357	Правительственная	2017-11-29 16:34:49	\N	956	2017-11-29 16:34:49	\N	\N	\N
7358	Обыкновенная	2017-11-29 16:34:49	\N	957	2017-11-29 16:34:49	\N	\N	\N
7359	Правительственная	2017-11-29 16:34:49	\N	957	2017-11-29 16:34:49	\N	\N	\N
7360	Обыкновенная	2017-11-29 16:34:49	\N	958	2017-11-29 16:34:49	\N	\N	\N
7361	Правительственная	2017-11-29 16:34:49	\N	958	2017-11-29 16:34:49	\N	\N	\N
7362	Обыкновенная	2017-11-29 16:34:49	\N	959	2017-11-29 16:34:49	\N	\N	\N
7363	Правительственная	2017-11-29 16:34:49	\N	959	2017-11-29 16:34:49	\N	\N	\N
7364	Обыкновенная	2017-11-29 16:34:49	\N	960	2017-11-29 16:34:49	\N	\N	\N
7365	Правительственная	2017-11-29 16:34:49	\N	960	2017-11-29 16:34:49	\N	\N	\N
7366	Обыкновенная	2017-11-29 16:34:49	\N	961	2017-11-29 16:34:49	\N	\N	\N
7367	Правительственная	2017-11-29 16:34:49	\N	961	2017-11-29 16:34:49	\N	\N	\N
7368	Обыкновенная	2017-11-29 16:34:49	\N	962	2017-11-29 16:34:49	\N	\N	\N
7369	Правительственная	2017-11-29 16:34:49	\N	962	2017-11-29 16:34:49	\N	\N	\N
7370	Обыкновенная	2017-11-29 16:34:49	\N	963	2017-11-29 16:34:49	\N	\N	\N
7371	Правительственная	2017-11-29 16:34:49	\N	963	2017-11-29 16:34:49	\N	\N	\N
7372	Обыкновенная	2017-11-29 16:34:49	\N	964	2017-11-29 16:34:49	\N	\N	\N
7373	Правительственная	2017-11-29 16:34:49	\N	964	2017-11-29 16:34:49	\N	\N	\N
7374	Обыкновенная	2017-11-29 16:34:49	\N	965	2017-11-29 16:34:49	\N	\N	\N
7375	Правительственная	2017-11-29 16:34:49	\N	965	2017-11-29 16:34:49	\N	\N	\N
7376	Обыкновенная	2017-11-29 16:34:49	\N	966	2017-11-29 16:34:49	\N	\N	\N
7377	Правительственная	2017-11-29 16:34:49	\N	966	2017-11-29 16:34:49	\N	\N	\N
7378	Обыкновенная	2017-11-29 16:34:49	\N	967	2017-11-29 16:34:49	\N	\N	\N
7379	Правительственная	2017-11-29 16:34:49	\N	967	2017-11-29 16:34:49	\N	\N	\N
7380	Обыкновенная	2017-11-29 16:34:49	\N	968	2017-11-29 16:34:49	\N	\N	\N
7381	Правительственная	2017-11-29 16:34:49	\N	968	2017-11-29 16:34:49	\N	\N	\N
7382	Обыкновенная	2017-11-29 16:34:49	\N	969	2017-11-29 16:34:49	\N	\N	\N
7383	Правительственная	2017-11-29 16:34:49	\N	969	2017-11-29 16:34:49	\N	\N	\N
7384	Обыкновенная	2017-11-29 16:34:49	\N	970	2017-11-29 16:34:49	\N	\N	\N
7385	Правительственная	2017-11-29 16:34:49	\N	970	2017-11-29 16:34:49	\N	\N	\N
7386	Обыкновенная	2017-11-29 16:34:49	\N	971	2017-11-29 16:34:49	\N	\N	\N
7387	Правительственная	2017-11-29 16:34:49	\N	971	2017-11-29 16:34:49	\N	\N	\N
7388	Обыкновенная	2017-11-29 16:34:49	\N	972	2017-11-29 16:34:49	\N	\N	\N
7389	Правительственная	2017-11-29 16:34:49	\N	972	2017-11-29 16:34:49	\N	\N	\N
7390	Обыкновенная	2017-11-29 16:34:49	\N	973	2017-11-29 16:34:49	\N	\N	\N
7391	Правительственная	2017-11-29 16:34:49	\N	973	2017-11-29 16:34:49	\N	\N	\N
7392	Обыкновенная	2017-11-29 16:34:49	\N	974	2017-11-29 16:34:49	\N	\N	\N
7393	Правительственная	2017-11-29 16:34:49	\N	974	2017-11-29 16:34:49	\N	\N	\N
7394	Обыкновенная	2017-11-29 16:34:49	\N	975	2017-11-29 16:34:49	\N	\N	\N
7395	Правительственная	2017-11-29 16:34:49	\N	975	2017-11-29 16:34:49	\N	\N	\N
7396	Обыкновенная	2017-11-29 16:34:49	\N	976	2017-11-29 16:34:49	\N	\N	\N
7397	Правительственная	2017-11-29 16:34:49	\N	976	2017-11-29 16:34:49	\N	\N	\N
7398	Обыкновенная	2017-11-29 16:34:49	\N	977	2017-11-29 16:34:49	\N	\N	\N
7399	Правительственная	2017-11-29 16:34:49	\N	977	2017-11-29 16:34:49	\N	\N	\N
7400	Обыкновенная	2017-11-29 16:34:49	\N	978	2017-11-29 16:34:49	\N	\N	\N
7401	Правительственная	2017-11-29 16:34:49	\N	978	2017-11-29 16:34:49	\N	\N	\N
7402	Обыкновенная	2017-11-29 16:34:49	\N	979	2017-11-29 16:34:49	\N	\N	\N
7403	Правительственная	2017-11-29 16:34:49	\N	979	2017-11-29 16:34:49	\N	\N	\N
7404	Обыкновенная	2017-11-29 16:34:49	\N	980	2017-11-29 16:34:49	\N	\N	\N
7405	Правительственная	2017-11-29 16:34:49	\N	980	2017-11-29 16:34:49	\N	\N	\N
7406	Обыкновенная	2017-11-29 16:34:49	\N	981	2017-11-29 16:34:49	\N	\N	\N
7407	Правительственная	2017-11-29 16:34:49	\N	981	2017-11-29 16:34:49	\N	\N	\N
7408	Обыкновенная	2017-11-29 16:34:49	\N	982	2017-11-29 16:34:49	\N	\N	\N
7409	Правительственная	2017-11-29 16:34:49	\N	982	2017-11-29 16:34:49	\N	\N	\N
7410	Обыкновенная	2017-11-29 16:34:49	\N	983	2017-11-29 16:34:49	\N	\N	\N
7411	Правительственная	2017-11-29 16:34:49	\N	983	2017-11-29 16:34:49	\N	\N	\N
7412	Обыкновенная	2017-11-29 16:34:49	\N	984	2017-11-29 16:34:49	\N	\N	\N
7413	Правительственная	2017-11-29 16:34:49	\N	984	2017-11-29 16:34:49	\N	\N	\N
7414	Обыкновенная	2017-11-29 16:34:49	\N	985	2017-11-29 16:34:49	\N	\N	\N
7415	Правительственная	2017-11-29 16:34:49	\N	985	2017-11-29 16:34:49	\N	\N	\N
7416	Обыкновенная	2017-11-29 16:34:49	\N	986	2017-11-29 16:34:49	\N	\N	\N
7417	Правительственная	2017-11-29 16:34:49	\N	986	2017-11-29 16:34:49	\N	\N	\N
7418	Обыкновенная	2017-11-29 16:34:49	\N	987	2017-11-29 16:34:49	\N	\N	\N
7419	Правительственная	2017-11-29 16:34:49	\N	987	2017-11-29 16:34:49	\N	\N	\N
7420	Обыкновенная	2017-11-29 16:34:49	\N	988	2017-11-29 16:34:49	\N	\N	\N
7421	Правительственная	2017-11-29 16:34:49	\N	988	2017-11-29 16:34:49	\N	\N	\N
7422	Обыкновенная	2017-11-29 16:34:49	\N	989	2017-11-29 16:34:49	\N	\N	\N
7423	Правительственная	2017-11-29 16:34:49	\N	989	2017-11-29 16:34:49	\N	\N	\N
7424	Обыкновенная	2017-11-29 16:34:49	\N	990	2017-11-29 16:34:49	\N	\N	\N
7425	Правительственная	2017-11-29 16:34:49	\N	990	2017-11-29 16:34:49	\N	\N	\N
7426	Обыкновенная	2017-11-29 16:34:49	\N	991	2017-11-29 16:34:49	\N	\N	\N
7427	Правительственная	2017-11-29 16:34:49	\N	991	2017-11-29 16:34:49	\N	\N	\N
7428	Обыкновенная	2017-11-29 16:34:49	\N	992	2017-11-29 16:34:49	\N	\N	\N
7429	Правительственная	2017-11-29 16:34:49	\N	992	2017-11-29 16:34:49	\N	\N	\N
7430	Обыкновенная	2017-11-29 16:34:49	\N	993	2017-11-29 16:34:49	\N	\N	\N
7431	Правительственная	2017-11-29 16:34:49	\N	993	2017-11-29 16:34:49	\N	\N	\N
7432	Обыкновенная	2017-11-29 16:34:49	\N	994	2017-11-29 16:34:49	\N	\N	\N
7433	Правительственная	2017-11-29 16:34:49	\N	994	2017-11-29 16:34:49	\N	\N	\N
7434	Обыкновенная	2017-11-29 16:34:49	\N	995	2017-11-29 16:34:49	\N	\N	\N
7435	Правительственная	2017-11-29 16:34:49	\N	995	2017-11-29 16:34:49	\N	\N	\N
7436	Обыкновенная	2017-11-29 16:34:49	\N	996	2017-11-29 16:34:49	\N	\N	\N
7437	Правительственная	2017-11-29 16:34:49	\N	996	2017-11-29 16:34:49	\N	\N	\N
7438	Обыкновенная	2017-11-29 16:34:49	\N	997	2017-11-29 16:34:49	\N	\N	\N
7439	Правительственная	2017-11-29 16:34:49	\N	997	2017-11-29 16:34:49	\N	\N	\N
7440	Обыкновенная	2017-11-29 16:34:49	\N	998	2017-11-29 16:34:49	\N	\N	\N
7441	Правительственная	2017-11-29 16:34:49	\N	998	2017-11-29 16:34:49	\N	\N	\N
7442	Обыкновенная	2017-11-29 16:34:49	\N	999	2017-11-29 16:34:49	\N	\N	\N
7443	Правительственная	2017-11-29 16:34:49	\N	999	2017-11-29 16:34:49	\N	\N	\N
7444	Обыкновенная	2017-11-29 16:34:49	\N	1000	2017-11-29 16:34:49	\N	\N	\N
7445	Правительственная	2017-11-29 16:34:49	\N	1000	2017-11-29 16:34:49	\N	\N	\N
7446	Обыкновенная	2017-11-29 16:34:49	\N	1001	2017-11-29 16:34:49	\N	\N	\N
7447	Правительственная	2017-11-29 16:34:49	\N	1001	2017-11-29 16:34:49	\N	\N	\N
7448	Обыкновенная	2017-11-29 16:34:49	\N	1002	2017-11-29 16:34:49	\N	\N	\N
7449	Правительственная	2017-11-29 16:34:49	\N	1002	2017-11-29 16:34:49	\N	\N	\N
7450	Обыкновенная	2017-11-29 16:34:49	\N	1003	2017-11-29 16:34:49	\N	\N	\N
7451	Правительственная	2017-11-29 16:34:49	\N	1003	2017-11-29 16:34:49	\N	\N	\N
7452	Обыкновенная	2017-11-29 16:34:49	\N	1004	2017-11-29 16:34:49	\N	\N	\N
7453	Правительственная	2017-11-29 16:34:49	\N	1004	2017-11-29 16:34:49	\N	\N	\N
7454	Обыкновенная	2017-11-29 16:34:49	\N	1005	2017-11-29 16:34:49	\N	\N	\N
7455	Правительственная	2017-11-29 16:34:49	\N	1005	2017-11-29 16:34:49	\N	\N	\N
7456	Обыкновенная	2017-11-29 16:34:49	\N	1006	2017-11-29 16:34:49	\N	\N	\N
7457	Правительственная	2017-11-29 16:34:49	\N	1006	2017-11-29 16:34:49	\N	\N	\N
7458	Обыкновенная	2017-11-29 16:34:49	\N	1007	2017-11-29 16:34:49	\N	\N	\N
7459	Правительственная	2017-11-29 16:34:49	\N	1007	2017-11-29 16:34:49	\N	\N	\N
7460	Обыкновенная	2017-11-29 16:34:49	\N	1008	2017-11-29 16:34:49	\N	\N	\N
7461	Правительственная	2017-11-29 16:34:49	\N	1008	2017-11-29 16:34:49	\N	\N	\N
7462	Обыкновенная	2017-11-29 16:34:49	\N	1009	2017-11-29 16:34:49	\N	\N	\N
7463	Правительственная	2017-11-29 16:34:49	\N	1009	2017-11-29 16:34:49	\N	\N	\N
7464	Обыкновенная	2017-11-29 16:34:49	\N	1010	2017-11-29 16:34:49	\N	\N	\N
7465	Правительственная	2017-11-29 16:34:49	\N	1010	2017-11-29 16:34:49	\N	\N	\N
7466	Обыкновенная	2017-11-29 16:34:49	\N	1011	2017-11-29 16:34:49	\N	\N	\N
7467	Правительственная	2017-11-29 16:34:49	\N	1011	2017-11-29 16:34:49	\N	\N	\N
7468	Обыкновенная	2017-11-29 16:34:49	\N	1012	2017-11-29 16:34:49	\N	\N	\N
7469	Правительственная	2017-11-29 16:34:49	\N	1012	2017-11-29 16:34:49	\N	\N	\N
7470	Обыкновенная	2017-11-29 16:34:49	\N	1013	2017-11-29 16:34:49	\N	\N	\N
7471	Правительственная	2017-11-29 16:34:49	\N	1013	2017-11-29 16:34:49	\N	\N	\N
7472	Обыкновенная	2017-11-29 16:34:49	\N	1014	2017-11-29 16:34:49	\N	\N	\N
7473	Правительственная	2017-11-29 16:34:49	\N	1014	2017-11-29 16:34:49	\N	\N	\N
7474	Обыкновенная	2017-11-29 16:34:49	\N	1015	2017-11-29 16:34:49	\N	\N	\N
7475	Правительственная	2017-11-29 16:34:49	\N	1015	2017-11-29 16:34:49	\N	\N	\N
7476	Обыкновенная	2017-11-29 16:34:49	\N	1016	2017-11-29 16:34:49	\N	\N	\N
7477	Правительственная	2017-11-29 16:34:49	\N	1016	2017-11-29 16:34:49	\N	\N	\N
7478	Обыкновенная	2017-11-29 16:34:49	\N	1017	2017-11-29 16:34:49	\N	\N	\N
7479	Правительственная	2017-11-29 16:34:49	\N	1017	2017-11-29 16:34:49	\N	\N	\N
7480	Обыкновенная	2017-11-29 16:34:49	\N	1018	2017-11-29 16:34:49	\N	\N	\N
7481	Правительственная	2017-11-29 16:34:49	\N	1018	2017-11-29 16:34:49	\N	\N	\N
7482	Обыкновенная	2017-11-29 16:34:49	\N	1019	2017-11-29 16:34:49	\N	\N	\N
7483	Правительственная	2017-11-29 16:34:49	\N	1019	2017-11-29 16:34:49	\N	\N	\N
7484	Обыкновенная	2017-11-29 16:34:49	\N	1020	2017-11-29 16:34:49	\N	\N	\N
7485	Правительственная	2017-11-29 16:34:49	\N	1020	2017-11-29 16:34:49	\N	\N	\N
7486	Правительственная Почтой заказное	2021-08-16 15:02:38	\N	192	2021-08-16 15:02:38	\N	\N	1
7487	Обыкновенная А/Я Копия пред	2023-04-13 14:40:32	\N	192	2023-04-13 14:40:32	\N	\N	161
7488	Обыкновенная Вручить (дата) Копия пред	2023-04-13 14:41:12	\N	192	2023-04-13 14:41:12	\N	\N	161
7489	Обыкновенная Делюкс Копия пред	2023-04-13 14:58:39	\N	192	2023-04-13 14:58:39	\N	\N	161
7490	Обыкновенная Заверенная Копия пред	2023-04-13 14:59:11	\N	192	2023-04-13 14:59:11	\N	\N	161
7491	Обыкновенная Копия пред Люкс	2023-04-13 14:59:59	\N	192	2023-04-13 14:59:59	\N	\N	161
7492	Обыкновенная Копия пред Почтой заказное	2023-04-13 15:00:13	\N	192	2023-04-13 15:00:13	\N	\N	161
7493	Обыкновенная Копия пред Служ. запрос пред	2023-04-13 15:00:29	\N	192	2023-04-13 15:00:29	\N	\N	161
7494	Обыкновенная Копия пред Служ. запрос част	2023-04-13 15:00:40	\N	192	2023-04-13 15:00:40	\N	\N	161
7495	Обыкновенная Копия пред Увед. простое	2023-04-13 15:00:51	\N	192	2023-04-13 15:00:51	\N	\N	161
7496	Обыкновенная Копия пред Увед. срочное	2023-04-13 15:00:59	\N	192	2023-04-13 15:00:59	\N	\N	161
7497	Обыкновенная Копия пред Люкс Почтой заказное Служ. запрос пред	2023-04-13 15:14:17	2023-04-13 15:14:43	192	2023-04-13 15:14:43	\N	\N	161
\.


--
-- Data for Name: bill_service_kind; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_service_kind (svckind_id, service_id) FROM stdin;
201	4009
203	4009
206	4010
201	4010
203	4010
204	4010
206	4011
201	4011
204	4011
206	4012
205	4012
206	4013
205	4013
202	4013
206	4014
205	4014
202	4014
203	4014
206	4015
205	4015
203	4015
204	4015
206	4016
205	4016
204	4016
206	4017
205	4017
203	4017
206	4018
202	4018
206	4019
202	4019
203	4019
206	4020
203	4020
204	4020
206	4021
204	4021
206	4022
203	4022
207	4023
207	4024
208	4024
207	4025
208	4025
209	4025
207	4026
208	4026
209	4026
210	4026
207	4027
208	4027
210	4027
207	4028
208	4028
210	4028
211	4028
207	4029
208	4029
211	4029
207	4030
212	4030
207	4031
212	4031
209	4031
207	4032
212	4032
209	4032
210	4032
207	4033
212	4033
210	4033
207	4034
212	4034
210	4034
211	4034
207	4035
212	4035
211	4035
207	4036
209	4036
207	4037
209	4037
210	4037
207	4038
210	4038
207	4039
210	4039
211	4039
207	4040
211	4040
213	4041
213	4042
214	4042
215	4042
213	4043
214	4043
215	4043
216	4043
213	4044
214	4044
216	4044
213	4045
217	4045
213	4046
217	4046
215	4046
213	4047
217	4047
215	4047
216	4047
213	4048
217	4048
216	4048
213	4049
215	4049
147	4050
146	4050
213	4051
215	4051
216	4051
147	4052
153	4052
148	4052
144	4053
153	4053
148	4053
144	4054
153	4054
148	4054
149	4054
147	4055
148	4055
166	4055
147	4056
148	4056
145	4056
149	4056
166	4056
147	4057
153	4057
148	4057
149	4057
166	4057
218	4058
218	4059
219	4059
218	4060
219	4060
220	4060
218	4061
219	4061
220	4061
221	4061
218	4062
219	4062
221	4062
218	4063
219	4063
221	4063
222	4063
218	4064
219	4064
222	4064
218	4065
223	4065
218	4066
223	4066
220	4066
218	4067
223	4067
220	4067
221	4067
218	4068
223	4068
221	4068
218	4069
223	4069
221	4069
222	4069
218	4070
223	4070
222	4070
218	4071
220	4071
218	4072
220	4072
221	4072
218	4073
221	4073
218	4074
221	4074
222	4074
218	4075
222	4075
224	4076
224	4077
153	3885
148	3885
166	3885
147	3886
145	3886
147	3887
153	3887
166	3887
147	3888
153	3888
151	3888
166	3888
147	3889
153	3889
151	3889
147	3890
153	3890
152	3890
149	3890
170	3891
171	3891
187	3891
173	3892
174	3892
188	3892
176	3893
177	3893
189	3893
170	3894
171	3894
173	3895
174	3895
176	3896
177	3896
170	3897
190	3897
172	3897
173	3898
191	3898
175	3898
176	3899
192	3899
178	3899
170	3900
190	3900
187	3900
173	3901
191	3901
188	3901
176	3902
192	3902
189	3902
155	3903
163	3903
161	3903
156	3903
155	3904
163	3904
156	3904
160	3904
155	3905
162	3905
156	3905
160	3905
157	3906
158	3906
168	3906
167	3906
157	3907
158	3907
167	3907
157	3908
169	3908
159	3908
157	3909
169	3909
167	3909
159	3909
157	3910
169	3910
157	3911
184	3912
159	3912
185	3912
184	3913
159	3913
164	3914
181	3914
180	3914
164	3915
181	3915
180	3915
183	3915
157	3916
169	3916
168	3916
167	3916
157	3917
169	3917
168	3917
165	3918
182	3918
180	3918
165	3919
182	3919
180	3919
183	3919
165	3920
182	3920
183	3920
165	3921
182	3921
183	3921
179	3921
165	3922
182	3922
179	3922
165	3923
181	3923
183	3923
179	3923
165	3924
181	3924
179	3924
184	3925
169	3925
168	3925
185	3925
184	3926
169	3926
168	3926
167	3926
185	3926
184	3927
184	3928
169	3928
168	3928
184	3929
169	3929
147	3930
145	3930
149	3930
150	3930
170	3931
190	3931
187	3931
172	3931
173	3932
191	3932
188	3932
175	3932
176	3933
192	3933
189	3933
178	3933
170	3934
190	3934
173	3935
191	3935
176	3936
192	3936
170	3937
173	3938
176	3939
184	3940
167	3940
185	3940
184	3941
167	3941
159	3941
170	3942
187	3942
173	3943
188	3943
176	3944
189	3944
170	3945
187	3945
172	3945
173	3946
188	3946
175	3946
176	3947
189	3947
178	3947
170	3948
172	3948
173	3949
175	3949
176	3950
178	3950
193	3951
193	3952
194	3952
193	3953
194	3953
195	3953
193	3954
194	3954
195	3954
196	3954
193	3955
194	3955
196	3955
193	3956
194	3956
196	3956
197	3956
193	3957
194	3957
197	3957
193	3958
198	3958
193	3959
198	3959
195	3959
193	3960
198	3960
195	3960
196	3960
193	3961
198	3961
196	3961
193	3962
198	3962
196	3962
197	3962
193	3963
198	3963
197	3963
193	3964
195	3964
193	3965
195	3965
196	3965
193	3966
196	3966
193	3967
196	3967
197	3967
193	3968
197	3968
199	3969
199	3970
194	3970
199	3971
194	3971
195	3971
199	3972
194	3972
195	3972
196	3972
199	3973
194	3973
196	3973
199	3974
194	3974
196	3974
197	3974
199	3975
194	3975
197	3975
199	3976
198	3976
199	3977
198	3977
195	3977
199	3978
198	3978
195	3978
196	3978
199	3979
198	3979
196	3979
197	3979
182	3801
183	3801
164	3802
180	3802
183	3802
164	3803
181	3803
183	3803
165	3804
183	3804
165	3805
179	3805
165	3806
180	3806
165	3807
181	3807
184	3808
169	3808
168	3808
167	3808
165	3809
182	3809
165	3810
183	3810
179	3810
165	3811
180	3811
183	3811
165	3812
181	3812
183	3812
184	3813
185	3813
165	3814
181	3814
180	3814
184	3815
169	3815
167	3815
185	3815
184	3816
169	3816
159	3816
165	3817
181	3817
180	3817
183	3817
184	3818
169	3818
159	3818
185	3818
184	3819
167	3819
164	3820
182	3820
180	3820
164	3821
182	3821
180	3821
183	3821
164	3822
182	3822
179	3822
164	3823
182	3823
183	3823
179	3823
164	3824
181	3824
179	3824
164	3825
181	3825
183	3825
179	3825
184	3826
168	3826
167	3826
184	3827
168	3827
167	3827
185	3827
184	3828
158	3828
184	3829
158	3829
167	3829
184	3830
158	3830
168	3830
167	3830
184	3831
158	3831
168	3831
184	3832
158	3832
167	3832
159	3832
185	3832
184	3833
158	3833
185	3833
184	3834
168	3834
184	3835
158	3835
167	3835
159	3835
184	3836
158	3836
159	3836
185	3836
165	3837
186	3837
147	3838
153	3838
149	3838
151	3838
166	3838
147	3839
152	3839
150	3839
147	3840
166	3840
147	3841
145	3841
152	3841
149	3841
150	3841
144	3842
151	3842
147	3843
151	3843
150	3843
144	3844
157	3845
167	3845
184	3846
169	3846
185	3846
170	3847
171	3847
187	3847
172	3847
173	3848
174	3848
188	3848
175	3848
176	3849
177	3849
189	3849
178	3849
184	3850
168	3850
185	3850
184	3851
158	3851
159	3851
184	3852
169	3852
167	3852
159	3852
184	3853
169	3853
167	3853
184	3854
169	3854
167	3854
159	3854
185	3854
184	3855
158	3855
167	3855
185	3855
184	3856
167	3856
159	3856
185	3856
147	3857
152	3857
149	3857
147	3858
152	3858
149	3858
166	3858
147	3859
152	3859
144	3860
145	3860
149	3860
151	3860
144	3861
145	3861
149	3861
147	3862
149	3862
151	3862
150	3862
144	3863
149	3863
151	3863
146	3863
144	3864
149	3864
146	3864
144	3865
151	3865
146	3865
147	3866
153	3866
149	3866
151	3866
144	3867
145	3867
151	3867
146	3867
144	3868
148	3868
145	3868
147	3869
149	3869
146	3869
144	3870
148	3870
146	3870
147	3871
153	3871
149	3871
166	3871
147	3872
145	3872
149	3872
166	3872
147	3873
145	3873
151	3873
147	3874
145	3874
149	3874
151	3874
147	3875
145	3875
149	3875
151	3875
166	3875
147	3876
145	3876
152	3876
149	3876
147	3877
145	3877
149	3877
147	3878
145	3878
151	3878
166	3878
147	3879
149	3879
151	3879
147	3880
149	3880
147	3881
149	3881
151	3881
166	3881
147	3882
152	3882
166	3882
147	3883
151	3883
166	3883
144	3884
145	3884
152	3884
149	3884
147	3885
160	3716
155	3717
161	3717
154	3718
156	3718
154	3719
160	3719
154	3720
161	3720
154	3721
162	3721
154	3722
163	3722
164	3723
165	3724
144	3725
153	3725
152	3725
144	3726
153	3726
152	3726
149	3726
147	3727
149	3727
150	3727
144	3728
146	3728
144	3729
145	3729
147	3730
145	3730
150	3730
144	3731
145	3731
149	3731
146	3731
147	3732
150	3732
144	3733
145	3733
152	3733
146	3733
144	3734
145	3734
152	3734
149	3734
146	3734
144	3735
152	3735
146	3735
147	3736
145	3736
152	3736
147	3737
145	3737
166	3737
147	3738
153	3738
152	3738
147	3739
153	3739
152	3739
166	3739
147	3740
153	3740
144	3741
152	3741
149	3741
146	3741
147	3742
145	3742
152	3742
150	3742
147	3743
149	3743
166	3743
144	3744
149	3744
144	3745
149	3745
151	3745
144	3746
145	3746
149	3746
151	3746
146	3746
147	3747
148	3747
149	3747
144	3748
152	3748
144	3749
152	3749
149	3749
147	3750
151	3750
144	3751
153	3751
151	3751
147	3752
148	3752
147	3753
148	3753
145	3753
144	3754
145	3754
151	3754
144	3755
153	3755
149	3755
144	3756
153	3756
149	3756
151	3756
144	3757
145	3757
152	3757
144	3758
153	3758
148	3758
146	3758
147	3759
145	3759
149	3759
151	3759
150	3759
147	3760
148	3760
149	3760
166	3760
157	3761
158	3761
167	3761
159	3761
155	3762
162	3762
155	3763
163	3763
157	3764
168	3764
157	3765
159	3765
157	3766
168	3766
167	3766
154	3767
163	3767
161	3767
154	3768
163	3768
160	3768
154	3769
163	3769
156	3769
154	3770
162	3770
161	3770
154	3771
162	3771
160	3771
154	3772
162	3772
156	3772
154	3773
161	3773
156	3773
154	3774
156	3774
160	3774
155	3775
163	3775
161	3775
155	3776
163	3776
160	3776
155	3777
163	3777
156	3777
155	3778
162	3778
161	3778
155	3779
162	3779
160	3779
155	3780
162	3780
156	3780
155	3781
161	3781
156	3781
155	3782
156	3782
160	3782
157	3783
169	3783
167	3783
157	3784
167	3784
159	3784
154	3785
163	3785
161	3785
156	3785
154	3786
163	3786
156	3786
160	3786
154	3787
162	3787
161	3787
156	3787
154	3788
162	3788
156	3788
160	3788
157	3789
158	3789
157	3790
158	3790
168	3790
170	3791
171	3791
172	3791
173	3792
174	3792
175	3792
176	3793
177	3793
178	3793
155	3794
162	3794
161	3794
156	3794
164	3795
179	3795
164	3796
180	3796
164	3797
181	3797
164	3798
182	3798
164	3799
183	3799
164	3800
183	3800
179	3800
164	3801
144	3706
145	3706
146	3706
147	3707
148	3707
149	3707
150	3707
147	3708
148	3708
150	3708
147	3709
145	3709
151	3709
150	3709
147	3710
152	3710
149	3710
150	3710
144	3711
153	3711
154	3712
155	3713
155	3714
156	3714
157	3715
158	3715
159	3715
155	3716
163	4630
156	4630
357	4630
154	4631
162	4631
357	4631
154	4632
162	4632
156	4632
357	4632
154	4633
161	4633
357	4633
154	4634
161	4634
156	4634
357	4634
154	4635
160	4635
357	4635
154	4636
156	4636
160	4636
357	4636
154	4637
162	4637
160	4637
357	4637
154	4638
162	4638
156	4638
160	4638
357	4638
184	4639
358	4639
184	4640
358	4640
167	4640
184	4641
169	4641
358	4641
184	4642
169	4642
358	4642
167	4642
184	4643
358	4643
158	4643
184	4644
358	4644
158	4644
167	4644
184	4645
358	4645
185	4645
184	4646
358	4646
167	4646
185	4646
157	4647
358	4647
157	4648
358	4648
167	4648
157	4649
358	4649
158	4649
157	4650
358	4650
158	4650
167	4650
200	4651
359	4651
200	4652
203	4652
359	4652
200	4653
201	4653
359	4653
200	4654
201	4654
203	4654
359	4654
200	4655
360	4655
359	4655
200	4656
360	4656
203	4656
359	4656
200	4657
205	4657
359	4657
200	4658
205	4658
203	4658
359	4658
200	4659
202	4659
359	4659
200	4660
202	4660
203	4660
359	4660
200	4661
204	4661
359	4661
200	4662
203	4662
204	4662
359	4662
200	4663
205	4663
204	4663
359	4663
200	4664
205	4664
203	4664
204	4664
359	4664
200	4665
201	4665
204	4665
359	4665
200	4666
201	4666
203	4666
204	4666
359	4666
361	4667
208	4667
361	4668
208	4668
210	4668
361	4669
212	4669
361	4670
212	4670
210	4670
361	4671
209	4671
361	4672
209	4672
210	4672
361	4673
211	4673
361	4674
210	4674
211	4674
361	4675
212	4675
211	4675
361	4676
212	4676
210	4676
211	4676
147	4677
284	4677
147	4678
153	4678
284	4678
147	4679
153	4679
149	4679
284	4679
147	4680
149	4680
284	4680
147	4681
145	4681
284	4681
147	4682
145	4682
149	4682
284	4682
147	4683
150	4683
284	4683
147	4684
149	4684
150	4684
284	4684
147	4685
149	4685
146	4685
284	4685
147	4686
146	4686
284	4686
207	4687
362	4687
207	4688
210	4688
362	4688
207	4689
210	4689
211	4689
362	4689
207	4690
211	4690
362	4690
147	4691
149	4691
322	4691
147	4692
322	4692
147	4693
166	4693
322	4693
147	4694
321	4694
147	4695
147	4696
166	4696
321	4696
213	4697
363	4697
213	4698
363	4698
215	4698
213	4699
214	4699
363	4699
215	4699
213	4700
214	4700
363	4700
213	4701
217	4701
363	4701
213	4702
217	4702
363	4702
215	4702
213	4703
363	4703
216	4703
213	4704
363	4704
215	4704
216	4704
218	4705
364	4705
218	4706
221	4706
364	4706
218	4707
219	4707
364	4707
218	4708
219	4708
221	4708
364	4708
218	4709
223	4709
364	4709
218	4710
223	4710
221	4710
364	4710
218	4711
220	4711
364	4711
218	4712
220	4712
221	4712
364	4712
218	4713
222	4713
364	4713
218	4714
221	4714
222	4714
364	4714
218	4715
223	4715
343	4533
177	4533
189	4533
178	4533
243	4534
346	4534
243	4535
246	4535
346	4535
243	4536
244	4536
346	4536
243	4537
244	4537
246	4537
346	4537
341	4538
342	4539
343	4540
341	4541
187	4541
342	4542
188	4542
343	4543
189	4543
243	4544
248	4544
346	4544
243	4545
246	4545
248	4545
346	4545
250	4546
347	4546
250	4547
347	4547
246	4547
184	4548
348	4548
184	4549
167	4549
348	4549
184	4550
169	4550
348	4550
184	4551
168	4551
348	4551
184	4552
168	4552
167	4552
348	4552
184	4553
159	4553
348	4553
184	4554
167	4554
159	4554
348	4554
341	4555
172	4555
342	4556
175	4556
343	4557
178	4557
341	4558
187	4558
172	4558
342	4559
188	4559
175	4559
343	4560
189	4560
178	4560
200	4561
349	4561
200	4562
203	4562
349	4562
200	4563
201	4563
349	4563
200	4564
201	4564
203	4564
349	4564
200	4565
202	4565
349	4565
200	4566
202	4566
203	4566
349	4566
200	4567
204	4567
349	4567
200	4568
203	4568
204	4568
349	4568
341	4569
171	4569
342	4570
174	4570
343	4571
177	4571
341	4572
171	4572
172	4572
342	4573
174	4573
175	4573
343	4574
177	4574
178	4574
230	4575
350	4575
230	4576
233	4576
350	4576
230	4577
231	4577
350	4577
230	4578
231	4578
233	4578
350	4578
230	4579
232	4579
233	4579
350	4579
230	4580
232	4580
350	4580
230	4581
234	4581
350	4581
230	4582
233	4582
234	4582
350	4582
341	4583
171	4583
187	4583
342	4584
174	4584
188	4584
343	4585
177	4585
189	4585
147	4586
151	4586
150	4586
320	4586
351	4587
149	4588
351	4588
150	4589
351	4589
146	4590
351	4590
352	4591
147	4592
149	4592
285	4592
353	4593
354	4594
164	4595
186	4595
164	4596
336	4596
164	4597
355	4597
164	4598
183	4598
336	4598
164	4599
186	4599
183	4599
164	4600
180	4600
336	4600
164	4601
180	4601
183	4601
336	4601
164	4602
179	4602
336	4602
164	4603
183	4603
179	4603
336	4603
243	4604
347	4604
243	4605
347	4605
246	4605
243	4606
244	4606
347	4606
243	4607
244	4607
347	4607
246	4607
243	4608
347	4608
249	4608
243	4609
347	4609
249	4609
246	4609
243	4610
347	4610
247	4610
243	4611
347	4611
246	4611
247	4611
165	4612
186	4612
183	4612
165	4613
186	4613
181	4613
165	4614
186	4614
181	4614
183	4614
155	4615
356	4615
155	4616
356	4616
156	4616
155	4617
356	4617
162	4617
156	4617
155	4618
356	4618
162	4618
154	4619
356	4619
154	4620
356	4620
156	4620
154	4621
163	4621
356	4621
156	4621
154	4622
163	4622
356	4622
154	4623
356	4623
162	4623
154	4624
356	4624
162	4624
156	4624
154	4625
356	4625
357	4625
154	4626
356	4626
156	4626
357	4626
154	4627
357	4627
154	4628
156	4628
357	4628
154	4629
163	4629
357	4629
154	4630
146	4444
288	4444
150	4445
289	4445
320	4445
146	4446
289	4446
320	4446
147	4447
321	4447
147	4448
145	4448
285	4448
147	4449
322	4449
147	4450
323	4450
147	4451
324	4451
147	4452
325	4452
147	4453
326	4453
207	4454
327	4454
147	4455
149	4455
150	4455
285	4455
147	4456
150	4456
285	4456
147	4457
145	4457
149	4457
285	4457
147	4458
286	4458
320	4458
147	4459
146	4459
285	4459
147	4460
149	4460
146	4460
285	4460
147	4461
320	4461
285	4461
147	4462
149	4462
320	4462
285	4462
147	4463
149	4463
286	4463
320	4463
144	4464
285	4464
144	4465
149	4465
285	4465
144	4466
153	4466
285	4466
144	4467
153	4467
149	4467
285	4467
144	4468
145	4468
149	4468
285	4468
144	4469
145	4469
285	4469
144	4470
150	4470
285	4470
144	4471
149	4471
150	4471
285	4471
144	4472
146	4472
285	4472
144	4473
149	4473
146	4473
285	4473
144	4474
149	4474
320	4474
285	4474
243	4475
328	4475
243	4476
329	4476
147	4477
166	4477
285	4477
207	4478
330	4478
366	5605
279	5605
230	5606
233	5606
234	5606
366	5606
279	5606
230	5607
234	5607
366	5607
279	5607
230	5608
366	5608
278	5608
230	5609
233	5609
366	5609
278	5609
230	5610
233	5610
234	5610
366	5610
278	5610
230	5611
234	5611
366	5611
278	5611
237	5612
365	5612
281	5612
237	5613
240	5613
365	5613
281	5613
237	5614
240	5614
345	5614
365	5614
281	5614
237	5615
345	5615
365	5615
281	5615
237	5616
365	5616
280	5616
237	5617
240	5617
365	5617
280	5617
237	5618
240	5618
345	5618
365	5618
280	5618
237	5619
345	5619
365	5619
280	5619
243	5620
248	5620
247	5620
329	5620
243	5621
246	5621
248	5621
247	5621
329	5621
243	5622
246	5622
248	5622
247	5622
328	5622
243	5623
248	5623
247	5623
328	5623
251	5624
5447	5624
273	5624
251	5625
253	5625
5447	5625
273	5625
251	5626
253	5626
254	5626
5447	5626
273	5626
251	5627
254	5627
5447	5627
273	5627
251	5628
5447	5628
272	5628
251	5629
253	5629
5447	5629
272	5629
251	5630
253	5630
254	5630
5447	5630
272	5630
251	5631
254	5631
5447	5631
272	5631
184	5688
185	5688
271	5688
184	5689
185	5689
270	5689
144	5767
149	5767
321	5767
144	5768
149	5768
322	5768
147	5887
284	5887
321	5887
147	5888
284	5888
322	5888
199	5907
259	5907
199	5908
258	5908
5431	6247
276	6247
5431	6248
277	6248
343	6249
269	6249
343	6250
266	6250
342	6251
268	6251
342	6252
265	6252
165	6253
263	6253
165	6254
262	6254
155	6255
261	6255
155	6256
260	6256
157	6257
271	6257
157	6258
270	6258
341	6259
267	6259
341	6260
264	6260
206	6261
275	6261
206	6262
274	6262
224	6263
332	6263
224	6264
331	6264
236	6265
279	6265
236	6266
278	6266
242	6267
281	6267
242	6268
280	6268
250	6269
329	6269
250	6270
328	6270
147	6307
320	6307
283	6307
150	6307
176	6368
6367	6368
176	6369
6367	6369
178	6369
343	6370
6367	6370
343	6371
6367	6371
178	6371
176	6374
6372	6374
176	6375
178	6375
6372	6375
176	6376
6373	6376
176	6377
178	6377
6373	6377
343	6378
6372	6378
343	6379
178	6379
6372	6379
343	6380
6373	6380
343	6381
178	6381
6373	6381
264	5538
193	5539
369	5539
259	5539
193	5540
196	5540
369	5540
259	5540
193	5541
196	5541
197	5541
369	5541
259	5541
193	5542
196	5542
339	5542
369	5542
259	5542
193	5543
369	5543
258	5543
193	5544
339	5544
369	5544
258	5544
193	5545
196	5545
339	5545
369	5545
258	5545
193	5546
196	5546
197	5546
369	5546
258	5546
193	5547
197	5547
369	5547
258	5547
200	5548
359	5548
275	5548
200	5549
203	5549
359	5549
275	5549
200	5550
203	5550
204	5550
359	5550
275	5550
200	5551
204	5551
359	5551
275	5551
200	5552
359	5552
274	5552
200	5553
203	5553
359	5553
274	5553
200	5554
203	5554
204	5554
359	5554
274	5554
200	5555
204	5555
359	5555
274	5555
207	5556
368	5556
327	5556
207	5557
210	5557
368	5557
327	5557
207	5558
210	5558
211	5558
368	5558
327	5558
207	5559
211	5559
368	5559
327	5559
207	5560
368	5560
330	5560
207	5561
210	5561
368	5561
330	5561
207	5562
210	5562
211	5562
368	5562
330	5562
207	5563
211	5563
368	5563
330	5563
213	5564
216	5564
334	5564
213	5565
215	5565
216	5565
334	5565
213	5566
215	5566
282	5566
216	5566
334	5566
213	5567
282	5567
216	5567
334	5567
213	5568
216	5568
333	5568
213	5569
215	5569
216	5569
333	5569
213	5570
215	5570
282	5570
216	5570
333	5570
213	5571
282	5571
216	5571
333	5571
218	5572
364	5572
332	5572
218	5573
221	5573
364	5573
332	5573
218	5574
221	5574
222	5574
364	5574
332	5574
218	5575
222	5575
364	5575
332	5575
218	5576
364	5576
331	5576
218	5577
221	5577
364	5577
331	5577
218	5578
221	5578
222	5578
364	5578
331	5578
218	5579
222	5579
364	5579
331	5579
147	5580
151	5580
166	5580
322	5580
147	5581
149	5581
151	5581
166	5581
322	5581
147	5582
285	5582
166	5582
322	5582
147	5583
149	5583
285	5583
166	5583
322	5583
147	5584
284	5584
166	5584
322	5584
147	5585
149	5585
284	5585
166	5585
322	5585
147	5586
286	5586
166	5586
322	5586
147	5587
149	5587
286	5587
166	5587
322	5587
147	5588
283	5588
166	5588
322	5588
147	5589
149	5589
283	5589
166	5589
322	5589
147	5590
285	5590
166	5590
321	5590
147	5591
149	5591
285	5591
166	5591
321	5591
147	5592
149	5592
151	5592
166	5592
321	5592
147	5593
151	5593
166	5593
321	5593
147	5594
284	5594
166	5594
321	5594
147	5595
149	5595
284	5595
166	5595
321	5595
147	5596
149	5596
286	5596
166	5596
321	5596
147	5597
286	5597
166	5597
321	5597
147	5598
283	5598
166	5598
321	5598
147	5599
149	5599
283	5599
166	5599
321	5599
225	5600
367	5600
277	5600
225	5601
228	5601
367	5601
277	5601
225	5602
228	5602
367	5602
276	5602
225	5603
367	5603
276	5603
230	5604
366	5604
279	5604
230	5605
233	5605
322	4867
213	4868
215	4868
334	4868
144	4887
322	4887
144	4888
321	4888
237	5307
240	5307
280	5307
237	5308
240	5308
281	5308
170	5367
370	5367
170	5368
172	5368
370	5368
170	5369
187	5369
172	5369
370	5369
170	5370
187	5370
370	5370
193	5371
369	5371
193	5372
196	5372
369	5372
193	5373
196	5373
197	5373
369	5373
193	5374
197	5374
369	5374
207	5375
368	5375
207	5376
211	5376
368	5376
207	5377
210	5377
211	5377
368	5377
251	5467
374	5467
5447	5467
251	5468
374	5468
253	5468
5447	5468
251	5469
254	5469
5447	5469
251	5470
253	5470
254	5470
5447	5470
251	5471
5447	5471
251	5472
253	5472
5447	5472
176	5473
189	5473
372	5473
176	5474
189	5474
178	5474
372	5474
176	5475
372	5475
176	5476
178	5476
372	5476
173	5477
188	5477
371	5477
173	5478
188	5478
175	5478
371	5478
213	5479
215	5479
282	5479
216	5479
213	5480
217	5480
282	5480
213	5481
217	5481
215	5481
282	5481
213	5482
214	5482
215	5482
282	5482
213	5483
214	5483
282	5483
225	5484
367	5484
225	5485
228	5485
367	5485
225	5486
227	5486
367	5486
225	5487
227	5487
228	5487
367	5487
5431	5488
5431	5489
228	5489
5431	5490
227	5490
5431	5491
229	5491
5431	5492
229	5492
228	5492
5431	5493
227	5493
228	5493
230	5494
366	5494
230	5495
233	5495
366	5495
230	5496
232	5496
366	5496
230	5497
232	5497
233	5497
366	5497
230	5498
233	5498
234	5498
366	5498
230	5499
234	5499
366	5499
242	5500
240	5500
345	5500
242	5501
345	5501
176	5507
372	5507
269	5507
176	5508
372	5508
266	5508
176	5509
178	5509
372	5509
266	5509
176	5510
178	5510
372	5510
269	5510
173	5511
371	5511
268	5511
173	5512
175	5512
371	5512
268	5512
173	5513
371	5513
265	5513
173	5514
175	5514
371	5514
265	5514
164	5515
336	5515
263	5515
164	5516
183	5516
336	5516
263	5516
164	5517
183	5517
336	5517
262	5517
164	5518
336	5518
262	5518
154	5519
357	5519
261	5519
154	5520
156	5520
357	5520
261	5520
154	5521
156	5521
357	5521
260	5521
154	5522
357	5522
260	5522
154	5523
160	5523
357	5523
260	5523
154	5524
156	5524
160	5524
357	5524
260	5524
154	5525
156	5525
160	5525
357	5525
261	5525
154	5526
160	5526
357	5526
261	5526
164	5527
179	5527
336	5527
263	5527
164	5528
183	5528
179	5528
336	5528
263	5528
164	5529
183	5529
179	5529
336	5529
262	5529
164	5530
179	5530
336	5530
262	5530
184	5531
167	5531
159	5531
185	5531
271	5531
184	5532
159	5532
185	5532
271	5532
184	5533
159	5533
185	5533
270	5533
184	5534
167	5534
159	5534
185	5534
270	5534
170	5535
370	5535
267	5535
170	5536
172	5536
370	5536
267	5536
170	5537
172	5537
370	5537
264	5537
170	5538
370	5538
222	4715
364	4715
218	4716
223	4716
221	4716
222	4716
364	4716
218	4717
219	4717
222	4717
364	4717
218	4718
219	4718
221	4718
222	4718
364	4718
237	4719
345	4719
237	4720
240	4720
345	4720
237	4721
238	4721
345	4721
237	4722
238	4722
240	4722
345	4722
237	4723
238	4723
241	4723
345	4723
237	4724
238	4724
241	4724
240	4724
345	4724
237	4725
345	4725
365	4725
237	4726
240	4726
345	4726
365	4726
237	4727
241	4727
240	4727
345	4727
365	4727
237	4728
241	4728
345	4728
365	4728
237	4729
365	4729
237	4730
240	4730
365	4730
237	4731
238	4731
365	4731
237	4732
238	4732
240	4732
365	4732
237	4733
241	4733
365	4733
237	4734
241	4734
240	4734
365	4734
237	4735
239	4735
365	4735
237	4736
239	4736
240	4736
365	4736
237	4737
365	4737
302	4737
230	4738
366	4738
301	4738
225	4739
367	4739
300	4739
218	4740
364	4740
299	4740
207	4741
368	4741
298	4741
200	4742
359	4742
297	4742
193	4743
369	4743
296	4743
170	4744
370	4744
293	4744
173	4745
371	4745
294	4745
176	4746
372	4746
295	4746
164	4747
336	4747
291	4747
154	4748
357	4748
290	4748
251	4749
373	4749
251	4750
253	4750
373	4750
251	4751
374	4751
253	4751
251	4752
374	4752
251	4753
252	4753
374	4753
251	4754
252	4754
374	4754
253	4754
251	4755
255	4755
374	4755
251	4756
255	4756
374	4756
253	4756
144	4757
146	4757
284	4757
144	4758
149	4758
146	4758
284	4758
147	4759
320	4759
284	4759
147	4760
149	4760
320	4760
284	4760
147	4761
150	4761
320	4761
284	4761
144	4762
284	4762
144	4763
149	4763
284	4763
144	4764
150	4764
284	4764
251	4765
255	4765
373	4765
251	4766
255	4766
253	4766
373	4766
251	4767
254	4767
373	4767
251	4768
253	4768
254	4768
373	4768
213	4769
282	4769
216	4769
147	4770
149	4770
321	4770
147	4771
149	4771
166	4771
321	4771
147	4772
149	4772
166	4772
322	4772
147	4773
151	4773
321	4773
147	4774
151	4774
322	4774
147	4775
149	4775
151	4775
322	4775
147	4776
151	4776
321	4776
147	4777
149	4777
151	4777
321	4777
225	4778
277	4778
225	4779
228	4779
277	4779
147	4780
153	4780
322	4780
147	4781
153	4781
149	4781
322	4781
147	4782
153	4782
149	4782
321	4782
147	4783
153	4783
321	4783
243	4784
246	4784
328	4784
243	4785
246	4785
247	4785
328	4785
243	4786
246	4786
329	4786
243	4787
246	4787
247	4787
329	4787
184	4788
167	4788
270	4788
184	4789
167	4789
271	4789
147	4790
283	4790
321	4790
147	4791
283	4791
322	4791
147	4792
320	4792
149	4792
243	4793
247	4793
329	4793
243	4794
247	4794
328	4794
154	4821
156	4821
260	4821
193	4847
196	4847
259	4847
193	4848
196	4848
258	4848
147	4867
152	4867
199	3980
198	3980
196	3980
199	3981
198	3981
197	3981
199	3982
195	3982
199	3983
195	3983
196	3983
199	3984
196	3984
197	3984
199	3985
197	3985
199	3986
196	3986
200	3987
200	3988
201	3988
200	3989
201	3989
202	3989
200	3990
201	3990
202	3990
203	3990
200	3991
201	3991
203	3991
200	3992
201	3992
203	3992
204	3992
200	3993
201	3993
204	3993
200	3994
205	3994
200	3995
205	3995
202	3995
200	3996
205	3996
202	3996
203	3996
200	3997
205	3997
203	3997
200	3998
205	3998
203	3998
204	3998
200	3999
205	3999
204	3999
200	4000
202	4000
200	4001
202	4001
203	4001
200	4002
203	4002
200	4003
203	4003
204	4003
200	4004
204	4004
206	4005
206	4006
201	4006
206	4007
201	4007
202	4007
206	4008
201	4008
202	4008
203	4008
206	4009
153	4301
149	4301
147	4302
153	4302
152	4302
149	4302
166	4302
147	4303
153	4303
149	4303
285	4303
147	4304
285	4304
147	4305
153	4305
285	4305
147	4306
286	4306
147	4307
153	4307
286	4307
147	4308
153	4308
149	4308
286	4308
147	4309
153	4309
149	4309
166	4309
286	4309
147	4310
145	4310
286	4310
147	4311
283	4311
147	4312
153	4312
283	4312
147	4313
287	4313
147	4314
288	4314
289	4315
147	4316
153	4316
149	4316
166	4316
286	4316
147	4317
153	4317
166	4317
286	4317
147	4318
145	4318
149	4318
286	4318
147	4319
145	4319
149	4319
166	4319
286	4319
147	4320
145	4320
149	4320
150	4320
286	4320
147	4321
145	4321
149	4321
146	4321
286	4321
147	4322
145	4322
166	4322
286	4322
147	4323
145	4323
150	4323
286	4323
147	4324
145	4324
146	4324
286	4324
147	4325
149	4325
286	4325
147	4326
149	4326
166	4326
286	4326
147	4327
149	4327
150	4327
286	4327
147	4328
149	4328
146	4328
286	4328
147	4329
166	4329
286	4329
147	4330
150	4330
286	4330
147	4331
146	4331
286	4331
144	4332
286	4332
144	4333
153	4333
149	4333
286	4333
144	4334
153	4334
286	4334
144	4335
145	4335
149	4335
286	4335
144	4336
145	4336
149	4336
150	4336
286	4336
144	4337
145	4337
149	4337
146	4337
286	4337
144	4338
145	4338
286	4338
144	4339
145	4339
150	4339
286	4339
144	4340
145	4340
146	4340
286	4340
144	4341
149	4341
286	4341
144	4342
149	4342
150	4342
286	4342
144	4343
149	4343
146	4343
286	4343
144	4344
150	4344
286	4344
144	4345
146	4345
286	4345
147	4346
153	4346
149	4346
283	4346
147	4347
243	4174
244	4174
246	4174
247	4174
243	4175
244	4175
248	4175
243	4176
244	4176
248	4176
247	4176
243	4177
244	4177
247	4177
243	4178
249	4178
243	4179
249	4179
245	4179
243	4180
249	4180
245	4180
246	4180
243	4181
249	4181
246	4181
243	4182
249	4182
246	4182
248	4182
243	4183
249	4183
246	4183
248	4183
247	4183
243	4184
249	4184
246	4184
247	4184
243	4185
249	4185
248	4185
243	4186
249	4186
248	4186
247	4186
243	4187
249	4187
247	4187
243	4188
245	4188
243	4189
245	4189
246	4189
243	4190
245	4190
246	4190
247	4190
243	4191
245	4191
247	4191
243	4192
246	4192
243	4193
246	4193
248	4193
243	4194
246	4194
248	4194
247	4194
243	4195
246	4195
247	4195
243	4196
248	4196
243	4197
248	4197
247	4197
250	4198
250	4199
244	4199
250	4200
244	4200
245	4200
250	4201
244	4201
245	4201
246	4201
250	4202
244	4202
246	4202
250	4203
244	4203
246	4203
248	4203
250	4204
244	4204
248	4204
250	4205
249	4205
250	4206
249	4206
245	4206
250	4207
249	4207
245	4207
246	4207
250	4208
249	4208
246	4208
248	4208
250	4209
249	4209
246	4209
250	4210
249	4210
248	4210
250	4211
245	4211
250	4212
245	4212
246	4212
250	4213
246	4213
248	4213
250	4214
248	4214
250	4215
246	4215
251	4216
251	4217
252	4217
251	4218
252	4218
253	4218
251	4219
252	4219
253	4219
254	4219
251	4220
252	4220
254	4220
251	4221
255	4221
251	4222
255	4222
253	4222
251	4223
255	4223
253	4223
254	4223
251	4224
255	4224
254	4224
251	4225
253	4225
251	4226
253	4226
254	4226
251	4227
254	4227
213	4228
214	4228
147	4229
148	4229
145	4229
150	4229
147	4230
148	4230
146	4230
147	4231
148	4231
145	4231
149	4231
150	4231
144	4232
148	4232
144	4233
148	4233
149	4233
144	4234
148	4234
145	4234
149	4234
147	4235
148	4235
145	4235
166	4235
147	4236
148	4236
145	4236
149	4236
147	4237
153	4237
148	4237
149	4237
243	4238
247	4238
213	4239
216	4239
144	4240
148	4240
145	4240
146	4240
147	4241
148	4241
145	4241
146	4241
147	4242
148	4242
145	4242
149	4242
146	4242
147	4243
145	4243
149	4243
151	4243
146	4243
147	4244
145	4244
151	4244
146	4244
147	4245
151	4245
146	4245
147	4246
145	4246
152	4246
149	4246
146	4246
147	4247
152	4247
149	4247
146	4247
147	4248
149	4248
151	4248
146	4248
147	4249
148	4249
149	4249
146	4249
147	4250
145	4250
146	4250
147	4251
145	4251
152	4251
146	4251
144	4252
150	4252
144	4253
149	4253
151	4253
150	4253
144	4254
151	4254
150	4254
144	4255
145	4255
151	4255
150	4255
144	4256
145	4256
149	4256
151	4256
150	4256
144	4257
149	4257
150	4257
144	4258
145	4258
150	4258
144	4259
152	4259
219	4077
224	4078
219	4078
220	4078
224	4079
219	4079
220	4079
221	4079
224	4080
219	4080
221	4080
224	4081
219	4081
221	4081
222	4081
224	4082
219	4082
222	4082
224	4083
223	4083
224	4084
223	4084
220	4084
224	4085
223	4085
220	4085
221	4085
224	4086
223	4086
221	4086
222	4086
224	4087
223	4087
222	4087
224	4088
220	4088
224	4089
220	4089
221	4089
224	4090
221	4090
222	4090
224	4091
222	4091
224	4092
221	4092
225	4093
225	4094
226	4094
225	4095
226	4095
227	4095
225	4096
226	4096
227	4096
228	4096
225	4097
226	4097
228	4097
225	4098
229	4098
225	4099
229	4099
227	4099
225	4100
229	4100
227	4100
228	4100
225	4101
229	4101
228	4101
225	4102
227	4102
225	4103
227	4103
228	4103
225	4104
228	4104
230	4105
230	4106
231	4106
230	4107
231	4107
232	4107
230	4108
231	4108
232	4108
233	4108
230	4109
231	4109
233	4109
230	4110
231	4110
233	4110
234	4110
230	4111
231	4111
234	4111
230	4112
235	4112
230	4113
235	4113
232	4113
230	4114
235	4114
232	4114
233	4114
230	4115
235	4115
233	4115
230	4116
235	4116
233	4116
234	4116
230	4117
235	4117
234	4117
230	4118
232	4118
230	4119
232	4119
233	4119
230	4120
233	4120
230	4121
233	4121
234	4121
230	4122
234	4122
236	4123
236	4124
231	4124
236	4125
231	4125
232	4125
236	4126
231	4126
232	4126
233	4126
236	4127
231	4127
233	4127
236	4128
231	4128
233	4128
234	4128
236	4129
231	4129
234	4129
236	4130
235	4130
236	4131
235	4131
232	4131
236	4132
235	4132
232	4132
233	4132
236	4133
235	4133
233	4133
234	4133
236	4134
235	4134
233	4134
236	4135
235	4135
234	4135
236	4136
232	4136
236	4137
232	4137
233	4137
236	4138
233	4138
234	4138
236	4139
234	4139
236	4140
233	4140
237	4141
237	4142
238	4142
237	4143
238	4143
239	4143
237	4144
238	4144
239	4144
240	4144
237	4145
238	4145
240	4145
237	4146
241	4146
237	4147
241	4147
239	4147
237	4148
241	4148
239	4148
240	4148
237	4149
241	4149
240	4149
237	4150
239	4150
237	4151
239	4151
240	4151
237	4152
240	4152
242	4153
242	4154
238	4154
242	4155
238	4155
239	4155
242	4156
238	4156
239	4156
240	4156
242	4157
238	4157
240	4157
242	4158
241	4158
242	4159
241	4159
239	4159
242	4160
241	4160
239	4160
240	4160
242	4161
241	4161
240	4161
242	4162
239	4162
242	4163
239	4163
240	4163
242	4164
240	4164
243	4165
243	4166
244	4166
243	4167
244	4167
245	4167
243	4168
244	4168
245	4168
246	4168
243	4169
244	4169
245	4169
246	4169
247	4169
243	4170
244	4170
245	4170
247	4170
243	4171
244	4171
246	4171
243	4172
244	4172
246	4172
248	4172
243	4173
244	4173
246	4173
248	4173
247	4173
147	6389
153	6389
320	6389
147	6390
320	6390
149	6390
151	6390
150	6390
243	6397
244	6397
329	6397
243	6398
244	6398
328	6398
243	6399
244	6399
246	6399
329	6399
243	6400
244	6400
246	6400
248	6400
329	6400
243	6401
244	6401
246	6401
328	6401
243	6402
245	6402
246	6402
329	6402
243	6403
245	6403
246	6403
328	6403
243	6404
245	6404
246	6404
247	6404
329	6404
243	6405
245	6405
246	6405
247	6405
328	6405
243	6406
246	6406
248	6406
328	6406
243	6407
246	6407
248	6407
329	6407
243	6408
245	6408
328	6408
243	6409
245	6409
329	6409
243	6410
249	6410
245	6410
329	6410
243	6411
249	6411
245	6411
328	6411
243	6412
249	6412
245	6412
246	6412
329	6412
243	6413
249	6413
245	6413
246	6413
328	6413
176	6452
189	6452
178	6452
372	6452
269	6452
176	6453
189	6453
178	6453
372	6453
266	6453
164	6454
180	6454
183	6454
263	6454
164	6455
180	6455
183	6455
262	6455
164	6456
181	6456
180	6456
263	6456
184	6457
168	6457
167	6457
271	6457
184	6458
168	6458
167	6458
270	6458
184	6459
168	6459
167	6459
185	6459
271	6459
184	6460
168	6460
167	6460
185	6460
270	6460
184	6461
158	6461
271	6461
184	6462
158	6462
270	6462
184	6463
158	6463
167	6463
271	6463
184	6464
158	6464
167	6464
270	6464
184	6465
169	6465
168	6465
167	6465
271	6465
184	6466
169	6466
168	6466
167	6466
270	6466
184	6467
169	6467
348	6467
271	6467
154	6686
163	6686
161	6686
156	6686
260	6686
154	6687
163	6687
160	6687
261	6687
154	6688
163	6688
160	6688
260	6688
154	6689
163	6689
356	6689
261	6689
154	6690
163	6690
356	6690
260	6690
154	6691
163	6691
356	6691
156	6691
261	6691
154	6692
163	6692
356	6692
156	6692
260	6692
157	6693
169	6693
168	6693
270	6693
157	6694
169	6694
159	6694
271	6694
157	6695
169	6695
159	6695
270	6695
157	6696
169	6696
167	6696
159	6696
271	6696
157	6697
169	6697
167	6697
159	6697
270	6697
157	6698
358	6698
271	6698
157	6699
169	6699
358	6699
157	6700
169	6700
358	6700
271	6700
157	6701
169	6701
358	6701
270	6701
157	6702
348	6702
271	6702
157	6703
348	6703
270	6703
157	6704
158	6704
271	6704
157	6705
158	6705
270	6705
157	6706
158	6706
168	6706
271	6706
157	6707
158	6707
168	6707
167	6707
271	6707
157	6708
158	6708
168	6708
167	6708
270	6708
184	6709
348	6709
270	6709
184	6710
348	6710
159	6710
271	6710
184	6711
348	6711
159	6711
270	6711
184	6712
348	6712
167	6712
159	6712
270	6712
184	6713
348	6713
167	6713
159	6713
271	6713
184	6714
169	6714
348	6714
167	6714
184	6715
169	6715
348	6715
167	6715
271	6715
184	6716
169	6716
348	6716
159	6716
270	6716
184	6717
169	6717
348	6717
167	6717
270	6717
184	6718
169	6718
348	6718
167	6718
159	6718
271	6718
184	6719
169	6719
348	6719
167	6719
159	6719
270	6719
341	6720
190	6720
267	6720
341	6721
190	6721
264	6721
170	6722
171	6722
187	6722
267	6722
170	6723
171	6723
187	6723
264	6723
193	6724
194	6724
195	6724
259	6724
193	6725
194	6725
195	6725
258	6725
193	6726
194	6726
195	6726
196	6726
259	6726
193	6727
194	6727
195	6727
196	6727
258	6727
193	6728
338	6728
259	6728
193	6729
338	6729
258	6729
193	6730
338	6730
197	6730
259	6730
193	6731
338	6731
196	6731
339	6731
258	6731
193	6732
194	6732
338	6732
259	6732
193	6733
194	6733
338	6733
258	6733
193	6734
195	6734
196	6734
369	6734
193	6735
195	6735
196	6735
259	6735
193	6736
195	6736
196	6736
369	6736
259	6736
193	6737
195	6737
196	6737
369	6737
258	6737
193	6738
195	6738
369	6738
259	6738
193	6739
195	6739
196	6739
258	6739
193	6740
198	6740
195	6740
259	6740
193	6741
198	6741
195	6741
258	6741
193	6742
198	6742
195	6742
196	6742
259	6742
193	6743
198	6743
195	6743
196	6743
258	6743
193	6744
194	6744
338	6744
197	6744
259	6744
193	6745
194	6745
338	6745
197	6745
258	6745
193	6746
198	6746
197	6746
259	6746
193	6747
198	6747
154	6392
161	6392
261	6392
154	6393
162	6393
260	6393
197	6747
258	6747
193	6748
198	6748
196	6748
197	6748
259	6748
193	6749
198	6749
196	6749
197	6749
258	6749
199	6750
195	6750
259	6750
199	6751
195	6751
258	6751
199	6752
195	6752
196	6752
259	6752
199	6753
195	6753
196	6753
258	6753
199	6754
194	6754
195	6754
259	6754
199	6755
194	6755
195	6755
258	6755
199	6756
194	6756
195	6756
196	6756
259	6756
199	6757
194	6757
195	6757
196	6757
258	6757
199	6758
198	6758
259	6758
199	6759
198	6759
258	6759
199	6760
198	6760
195	6760
259	6760
199	6761
198	6761
195	6761
258	6761
199	6762
198	6762
195	6762
196	6762
259	6762
199	6763
198	6763
195	6763
196	6763
258	6763
193	6764
338	6764
196	6764
259	6764
193	6765
338	6765
196	6765
258	6765
193	6766
338	6766
196	6766
197	6766
259	6766
193	6767
338	6767
196	6767
197	6767
258	6767
200	6768
201	6768
202	6768
275	6768
200	6769
201	6769
202	6769
274	6769
200	6770
201	6770
202	6770
203	6770
275	6770
200	6771
201	6771
203	6771
274	6771
200	6772
201	6772
202	6772
203	6772
274	6772
200	6773
201	6773
203	6773
204	6773
275	6773
147	6394
153	6394
148	6394
322	6394
147	6395
153	6395
148	6395
321	6395
243	6468
249	6468
246	6468
329	6468
243	6469
249	6469
246	6469
328	6469
243	6470
249	6470
246	6470
248	6470
329	6470
243	6471
249	6471
246	6471
248	6471
328	6471
243	6472
244	6472
245	6472
329	6472
243	6473
244	6473
245	6473
328	6473
243	6474
244	6474
245	6474
246	6474
328	6474
243	6475
244	6475
245	6475
246	6475
329	6475
243	6476
245	6476
247	6476
329	6476
243	6477
245	6477
247	6477
328	6477
243	6478
248	6478
328	6478
243	6479
248	6479
329	6479
243	6480
244	6480
246	6480
248	6480
328	6480
184	6481
168	6481
185	6481
271	6481
184	6482
168	6482
185	6482
270	6482
184	6483
167	6483
185	6483
271	6483
184	6484
167	6484
185	6484
270	6484
184	6485
169	6485
167	6485
270	6485
184	6486
169	6486
159	6486
271	6486
184	6487
169	6487
159	6487
270	6487
184	6488
169	6488
167	6488
159	6488
271	6488
184	6489
169	6489
167	6489
159	6489
270	6489
184	6490
158	6490
167	6490
159	6490
270	6490
184	6491
158	6491
167	6491
159	6491
271	6491
184	6492
158	6492
168	6492
167	6492
270	6492
184	6493
158	6493
168	6493
167	6493
271	6493
157	6494
168	6494
167	6494
271	6494
157	6495
168	6495
167	6495
270	6495
157	6496
159	6496
271	6496
157	6497
159	6497
270	6497
157	6498
169	6498
168	6498
271	6498
147	6499
153	6499
151	6499
321	6499
147	6500
153	6500
151	6500
322	6500
147	6501
153	6501
149	6501
284	6501
321	6501
147	6502
153	6502
149	6502
284	6502
322	6502
147	6503
153	6503
286	6503
321	6503
147	6504
153	6504
286	6504
322	6504
147	6505
153	6505
283	6505
321	6505
147	6506
153	6506
283	6506
322	6506
144	6507
153	6507
149	6507
151	6507
321	6507
147	6508
153	6508
149	6508
151	6508
322	6508
147	6509
153	6509
149	6509
286	6509
322	6509
147	6510
153	6510
149	6510
283	6510
322	6510
144	6511
153	6511
149	6511
322	6511
144	6512
153	6512
149	6512
321	6512
225	6513
227	6513
228	6513
277	6513
225	6514
227	6514
228	6514
276	6514
225	6515
229	6515
227	6515
228	6515
277	6515
225	6516
229	6516
227	6516
228	6516
276	6516
225	6517
226	6517
227	6517
228	6517
277	6517
225	6518
226	6518
227	6518
228	6518
276	6518
225	6519
227	6519
228	6519
367	6519
277	6519
225	6520
227	6520
228	6520
367	6520
276	6520
5431	6521
227	6521
228	6521
277	6521
5431	6522
227	6522
228	6522
276	6522
5431	6523
229	6523
228	6523
277	6523
5431	6524
229	6524
228	6524
276	6524
5431	6525
229	6525
227	6525
228	6525
277	6525
5431	6526
229	6526
227	6526
228	6526
276	6526
230	6527
232	6527
233	6527
279	6527
230	6528
232	6528
233	6528
278	6528
230	6529
232	6529
233	6529
366	6529
279	6529
230	6530
232	6530
233	6530
366	6530
278	6530
236	6531
232	6531
233	6531
279	6531
236	6532
232	6532
233	6532
278	6532
230	6533
235	6533
232	6533
233	6533
279	6533
230	6534
235	6534
232	6534
233	6534
278	6534
230	6535
235	6535
233	6535
234	6535
279	6535
230	6536
235	6536
234	6536
278	6536
230	6537
235	6537
233	6537
234	6537
278	6537
230	6538
231	6538
232	6538
233	6538
279	6538
230	6539
231	6539
232	6539
233	6539
278	6539
236	6540
231	6540
233	6540
234	6540
279	6540
230	6541
231	6541
233	6541
278	6541
230	6542
231	6542
233	6542
234	6542
279	6542
230	6543
231	6543
233	6543
234	6543
278	6543
236	6544
235	6544
232	6544
233	6544
279	6544
236	6545
235	6545
232	6545
233	6545
278	6545
230	6546
235	6546
233	6546
278	6546
237	6547
239	6547
240	6547
365	6547
281	6547
237	6548
239	6548
240	6548
280	6548
237	6549
239	6549
240	6549
365	6549
280	6549
237	6550
238	6550
239	6550
240	6550
281	6550
237	6551
238	6551
239	6551
240	6551
280	6551
237	6552
241	6552
239	6552
281	6552
237	6553
238	6553
239	6553
281	6553
237	6554
238	6554
345	6554
281	6554
237	6555
238	6555
345	6555
280	6555
237	6556
238	6556
240	6556
345	6556
281	6556
250	6557
244	6557
245	6557
246	6557
329	6557
250	6558
244	6558
245	6558
246	6558
328	6558
250	6559
249	6559
245	6559
246	6559
329	6559
250	6560
249	6560
245	6560
246	6560
328	6560
250	6561
249	6561
248	6561
328	6561
250	6562
249	6562
248	6562
329	6562
251	6563
374	6563
253	6563
273	6563
251	6564
374	6564
253	6564
272	6564
251	6565
255	6565
253	6565
273	6565
251	6566
255	6566
253	6566
272	6566
251	6567
252	6567
253	6567
273	6567
251	6568
252	6568
253	6568
272	6568
251	6569
255	6569
254	6569
273	6569
251	6570
255	6570
254	6570
272	6570
251	6571
374	6571
5447	6571
273	6571
251	6572
374	6572
5447	6572
272	6572
251	6573
374	6573
253	6573
5447	6573
273	6573
251	6574
374	6574
253	6574
5447	6574
272	6574
251	6575
255	6575
253	6575
254	6575
273	6575
251	6576
255	6576
253	6576
254	6576
272	6576
251	6577
252	6577
374	6577
273	6577
251	6578
252	6578
374	6578
272	6578
251	6579
252	6579
374	6579
253	6579
273	6579
251	6580
252	6580
374	6580
253	6580
272	6580
170	6581
187	6581
172	6581
267	6581
170	6582
187	6582
172	6582
264	6582
170	6583
187	6583
172	6583
370	6583
267	6583
170	6584
187	6584
172	6584
370	6584
264	6584
170	6585
190	6585
187	6585
267	6585
170	6586
190	6586
172	6586
264	6586
170	6587
171	6587
187	6587
172	6587
267	6587
170	6588
171	6588
187	6588
172	6588
264	6588
170	6589
190	6589
187	6589
172	6589
267	6589
170	6590
190	6590
187	6590
172	6590
264	6590
341	6591
171	6591
187	6591
172	6591
267	6591
341	6592
190	6592
187	6592
341	6593
190	6593
187	6593
172	6593
147	6414
153	6414
324	6414
149	6414
147	6415
153	6415
323	6415
149	6415
147	6416
153	6416
324	6416
151	6416
147	6417
145	6417
149	6417
284	6417
150	6417
147	6418
145	6418
149	6418
285	6418
146	6418
147	6419
320	6419
145	6419
149	6419
150	6419
147	6420
320	6420
145	6420
149	6420
146	6420
147	6421
320	6421
145	6421
285	6421
147	6422
320	6422
145	6422
151	6422
147	6423
320	6423
145	6423
284	6423
147	6424
320	6424
145	6424
286	6424
147	6425
320	6425
145	6425
283	6425
147	6426
152	6426
166	6426
322	6426
147	6427
152	6427
166	6427
321	6427
147	6428
152	6428
149	6428
166	6428
321	6428
147	6429
152	6429
149	6429
166	6429
322	6429
147	6430
320	6430
145	6430
149	6430
285	6430
150	6430
147	6431
320	6431
145	6431
149	6431
285	6431
146	6431
147	6432
320	6432
145	6432
149	6432
151	6432
150	6432
147	6433
320	6433
145	6433
149	6433
151	6433
146	6433
147	6434
320	6434
145	6434
149	6434
284	6434
146	6434
147	6435
320	6435
145	6435
149	6435
284	6435
150	6435
147	6436
320	6436
145	6436
149	6436
286	6436
150	6436
147	6437
320	6437
145	6437
149	6437
286	6437
146	6437
147	6438
320	6438
145	6438
149	6438
283	6438
150	6438
147	6439
320	6439
145	6439
149	6439
283	6439
146	6439
147	6440
320	6440
145	6440
285	6440
150	6440
147	6441
153	6441
152	6441
149	6441
322	6441
147	6442
153	6442
152	6442
149	6442
321	6442
147	6443
153	6443
149	6443
285	6443
322	6443
147	6444
153	6444
149	6444
285	6444
321	6444
147	6445
320	6445
145	6445
147	6446
320	6446
145	6446
149	6446
147	6447
320	6447
145	6447
149	6447
285	6447
147	6448
320	6448
145	6448
149	6448
151	6448
147	6449
320	6449
145	6449
149	6449
284	6449
147	6450
320	6450
145	6450
283	6450
146	6450
147	6451
320	6451
145	6451
149	6451
286	6451
341	6594
190	6594
187	6594
267	6594
341	6595
190	6595
172	6595
341	6596
190	6596
172	6596
267	6596
341	6597
190	6597
172	6597
264	6597
341	6598
190	6598
187	6598
172	6598
267	6598
341	6599
190	6599
187	6599
172	6599
264	6599
176	6600
189	6600
372	6600
266	6600
176	6601
189	6601
372	6601
269	6601
176	6602
192	6602
189	6602
178	6602
269	6602
176	6603
192	6603
189	6603
178	6603
266	6603
173	6604
188	6604
371	6604
265	6604
173	6605
188	6605
265	6605
173	6606
188	6606
268	6606
173	6607
188	6607
175	6607
268	6607
173	6608
188	6608
371	6608
268	6608
173	6609
188	6609
175	6609
371	6609
268	6609
173	6610
188	6610
175	6610
371	6610
265	6610
342	6611
188	6611
175	6611
268	6611
342	6612
188	6612
175	6612
265	6612
173	6613
174	6613
268	6613
173	6614
174	6614
265	6614
173	6615
174	6615
188	6615
175	6615
268	6615
173	6616
174	6616
188	6616
175	6616
265	6616
173	6617
191	6617
188	6617
175	6617
268	6617
173	6618
191	6618
188	6618
175	6618
265	6618
342	6619
174	6619
265	6619
342	6620
174	6620
268	6620
342	6621
174	6621
175	6621
268	6621
342	6622
174	6622
175	6622
265	6622
173	6623
191	6623
188	6623
268	6623
173	6624
191	6624
188	6624
265	6624
342	6625
191	6625
175	6625
342	6626
191	6626
175	6626
268	6626
342	6627
191	6627
175	6627
265	6627
164	6628
180	6628
183	6628
336	6628
262	6628
164	6629
180	6629
183	6629
336	6629
263	6629
164	6630
182	6630
180	6630
183	6630
263	6630
164	6631
182	6631
180	6631
183	6631
262	6631
164	6632
181	6632
180	6632
262	6632
164	6633
181	6633
180	6633
183	6633
262	6633
164	6634
181	6634
180	6634
183	6634
263	6634
164	6635
181	6635
183	6635
179	6635
263	6635
164	6636
181	6636
183	6636
179	6636
262	6636
164	6637
335	6637
183	6637
263	6637
164	6638
335	6638
183	6638
262	6638
165	6639
180	6639
263	6639
165	6640
180	6640
262	6640
165	6641
181	6641
263	6641
165	6642
181	6642
262	6642
165	6643
180	6643
183	6643
262	6643
165	6644
180	6644
183	6644
263	6644
165	6645
186	6645
183	6645
263	6645
165	6646
186	6646
183	6646
262	6646
154	6647
161	6647
260	6647
154	6648
161	6648
357	6648
261	6648
154	6649
161	6649
156	6649
260	6649
154	6650
161	6650
357	6650
260	6650
154	6651
162	6651
161	6651
261	6651
154	6652
162	6652
161	6652
156	6652
261	6652
154	6653
162	6653
161	6653
156	6653
260	6653
154	6654
161	6654
156	6654
357	6654
261	6654
154	6655
161	6655
156	6655
357	6655
260	6655
155	6656
161	6656
261	6656
155	6657
161	6657
260	6657
155	6658
161	6658
156	6658
261	6658
155	6659
161	6659
156	6659
260	6659
155	6660
356	6660
261	6660
155	6661
356	6661
260	6661
155	6662
162	6662
261	6662
155	6663
162	6663
260	6663
155	6664
162	6664
161	6664
156	6664
261	6664
155	6665
162	6665
161	6665
156	6665
260	6665
155	6666
160	6666
261	6666
155	6667
160	6667
260	6667
155	6668
162	6668
160	6668
260	6668
155	6669
163	6669
261	6669
155	6670
163	6670
260	6670
155	6671
337	6671
160	6671
261	6671
155	6672
337	6672
160	6672
260	6672
154	6673
337	6673
160	6673
260	6673
154	6674
337	6674
160	6674
261	6674
154	6675
337	6675
156	6675
160	6675
261	6675
154	6676
337	6676
156	6676
160	6676
260	6676
154	6677
163	6677
156	6677
261	6677
154	6678
163	6678
156	6678
260	6678
154	6679
163	6679
156	6679
160	6679
261	6679
154	6680
163	6680
156	6680
160	6680
260	6680
154	6681
163	6681
260	6681
154	6682
163	6682
261	6682
154	6683
163	6683
161	6683
261	6683
154	6684
163	6684
161	6684
260	6684
154	6685
163	6685
161	6685
156	6685
261	6685
218	4479
331	4479
218	4480
332	4480
213	4481
333	4481
213	4482
334	4482
164	4483
335	4483
164	4484
183	4484
335	4484
164	4485
179	4485
335	4485
164	4486
183	4486
179	4486
335	4486
164	4487
186	4487
336	4487
164	4488
186	4488
183	4488
336	4488
164	4489
182	4489
335	4489
164	4490
182	4490
183	4490
335	4490
164	4491
180	4491
335	4491
164	4492
180	4492
183	4492
335	4492
164	4493
182	4493
180	4493
335	4493
164	4494
182	4494
180	4494
183	4494
335	4494
154	4495
337	4495
154	4496
156	4496
337	4496
154	4497
163	4497
337	4497
154	4498
163	4498
156	4498
337	4498
154	4499
161	4499
337	4499
154	4500
161	4500
156	4500
337	4500
154	4501
160	4501
337	4501
154	4502
156	4502
160	4502
337	4502
193	4503
338	4503
193	4504
197	4504
338	4504
193	4505
196	4505
197	4505
338	4505
193	4506
194	4506
338	4506
193	4507
194	4507
196	4507
338	4507
193	4508
195	4508
338	4508
193	4509
195	4509
196	4509
338	4509
193	4510
339	4510
338	4510
193	4511
196	4511
339	4511
338	4511
218	4512
340	4512
218	4513
221	4513
340	4513
218	4514
219	4514
340	4514
218	4515
219	4515
221	4515
340	4515
218	4516
220	4516
340	4516
218	4517
220	4517
221	4517
340	4517
218	4518
222	4518
340	4518
218	4519
221	4519
222	4519
340	4519
341	4520
293	4520
342	4521
294	4521
343	4522
295	4522
237	4523
344	4523
237	4524
240	4524
344	4524
237	4525
238	4525
344	4525
237	4526
238	4526
240	4526
344	4526
237	4527
239	4527
344	4527
237	4528
239	4528
240	4528
344	4528
237	4529
345	4529
344	4529
237	4530
240	4530
345	4530
344	4530
341	4531
171	4531
187	4531
172	4531
342	4532
174	4532
188	4532
175	4532
152	4347
146	4347
147	4348
145	4348
149	4348
283	4348
147	4349
145	4349
149	4349
150	4349
283	4349
147	4350
145	4350
149	4350
146	4350
283	4350
147	4351
145	4351
283	4351
147	4352
145	4352
150	4352
283	4352
147	4353
145	4353
146	4353
283	4353
147	4354
149	4354
283	4354
147	4355
149	4355
150	4355
283	4355
147	4356
149	4356
146	4356
283	4356
147	4357
150	4357
283	4357
147	4358
146	4358
283	4358
144	4359
283	4359
144	4360
153	4360
149	4360
283	4360
144	4361
153	4361
283	4361
144	4362
145	4362
149	4362
283	4362
144	4363
145	4363
149	4363
150	4363
283	4363
144	4364
145	4364
149	4364
146	4364
283	4364
144	4365
145	4365
283	4365
144	4366
145	4366
150	4366
283	4366
144	4367
145	4367
146	4367
283	4367
144	4368
149	4368
283	4368
144	4369
149	4369
150	4369
283	4369
144	4370
149	4370
146	4370
283	4370
144	4371
150	4371
283	4371
144	4372
146	4372
283	4372
147	4373
153	4373
287	4373
147	4374
145	4374
287	4374
147	4375
149	4375
287	4375
147	4376
153	4376
149	4376
287	4376
147	4377
145	4377
149	4377
287	4377
147	4378
166	4378
287	4378
147	4379
149	4379
166	4379
287	4379
149	4380
289	4380
149	4381
283	4381
289	4381
150	4382
289	4382
146	4383
289	4383
147	4384
146	4384
288	4384
147	4385
150	4385
288	4385
147	4386
166	4386
288	4386
147	4387
149	4387
288	4387
147	4388
149	4388
166	4388
288	4388
147	4389
149	4389
150	4389
288	4389
147	4390
149	4390
146	4390
288	4390
147	4391
145	4391
288	4391
147	4392
145	4392
149	4392
288	4392
154	4393
290	4393
164	4394
291	4394
184	4395
292	4395
170	4396
293	4396
173	4397
294	4397
176	4398
295	4398
193	4399
296	4399
200	4400
297	4400
207	4401
298	4401
144	4402
149	4402
150	4402
284	4402
218	4403
299	4403
225	4404
300	4404
230	4405
301	4405
237	4406
302	4406
243	4407
303	4407
251	4408
304	4408
213	4409
216	4409
305	4409
184	4410
185	4410
292	4410
243	4411
247	4411
303	4411
306	4412
307	4413
308	4414
309	4415
310	4416
311	4417
312	4418
313	4419
314	4420
315	4421
316	4422
317	4423
318	4424
251	4425
319	4425
251	4426
319	4426
253	4426
251	4427
252	4427
319	4427
253	4427
251	4428
252	4428
319	4428
147	4429
149	4429
146	4429
320	4429
149	4430
289	4430
320	4430
289	4431
320	4431
147	4432
146	4432
320	4432
147	4433
148	4433
320	4433
147	4434
148	4434
149	4434
320	4434
147	4435
150	4435
320	4435
147	4436
149	4436
150	4436
320	4436
147	4437
149	4437
151	4437
320	4437
147	4438
283	4438
320	4438
147	4439
149	4439
283	4439
320	4439
147	4440
151	4440
320	4440
147	4441
320	4441
144	4442
288	4442
144	4443
150	4443
288	4443
144	4444
150	4259
144	4260
145	4260
152	4260
149	4260
150	4260
144	4261
145	4261
152	4261
150	4261
144	4262
152	4262
149	4262
150	4262
144	4263
145	4263
149	4263
150	4263
144	4264
148	4264
150	4264
144	4265
148	4265
149	4265
150	4265
144	4266
148	4266
145	4266
149	4266
150	4266
144	4267
148	4267
145	4267
150	4267
144	4268
148	4268
149	4268
146	4268
144	4269
148	4269
145	4269
149	4269
146	4269
193	4270
256	4270
193	4271
257	4271
193	4272
258	4272
193	4273
259	4273
154	4274
260	4274
154	4275
261	4275
164	4276
262	4276
164	4277
263	4277
170	4278
264	4278
173	4279
265	4279
176	4280
266	4280
170	4281
267	4281
173	4282
268	4282
176	4283
269	4283
184	4284
270	4284
184	4285
271	4285
251	4286
272	4286
251	4287
273	4287
200	4288
274	4288
200	4289
275	4289
225	4290
276	4290
225	4291
277	4291
230	4292
278	4292
230	4293
279	4293
237	4294
280	4294
237	4295
281	4295
213	4296
282	4296
147	4297
166	4297
283	4297
147	4298
149	4298
166	4298
283	4298
147	4299
166	4299
284	4299
147	4300
149	4300
166	4300
284	4300
147	4301
289	7486
166	7486
147	7487
153	7487
326	7487
147	7488
320	7488
326	7488
147	7489
148	7489
326	7489
147	7490
152	7490
326	7490
147	7491
326	7491
151	7491
147	7492
326	7492
166	7492
147	7493
326	7493
322	7493
147	7494
326	7494
321	7494
147	7495
326	7495
150	7495
147	7496
326	7496
146	7496
147	7497
326	7497
151	7497
166	7497
322	7497
\.


--
-- Data for Name: bill_svckind; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_svckind (svckind_id, tarif_id, name, required, p1, p2, p3, created, changed, closed, start_label, end_label, f_serve, f_second, operator_id, f_notification, f_printcopy, f_needrequest, f_needtg, tlgkind_id) FROM stdin;
326	192	Копия пред	0	 	 	 	2009-06-30 15:59:13	2009-07-03 16:49:41	\N	\N	\N	0	0	221	1	1	0	0	26
327	182	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:25	\N	\N	\N	0	0	221	1	0	1	0	27
328	188	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:50	\N	\N	\N	0	0	221	1	0	1	0	3
329	188	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:46	\N	\N	\N	0	0	221	1	0	1	0	27
330	182	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:30	\N	\N	\N	0	0	221	1	0	1	0	3
331	184	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:52	\N	\N	\N	0	0	221	1	0	1	0	3
332	184	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:49	\N	\N	\N	0	0	221	1	0	1	0	27
333	183	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:41	\N	\N	\N	0	0	221	1	0	1	0	3
334	183	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:38	\N	\N	\N	0	0	221	1	0	1	0	27
335	193	Вручить (дата)	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:16:56	\N	\N	\N	1	0	221	0	0	0	0	19
337	177	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 10:59:03	\N	\N	\N	1	0	221	0	0	0	0	19
338	180	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:22:46	\N	\N	\N	1	0	221	0	0	0	0	19
339	180	Люкс/И	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:23:54	\N	ЛЮКС/И	\N	0	0	221	0	0	0	0	6
340	184	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:30:00	\N	\N	\N	1	0	221	0	0	0	0	19
341	179	Срочная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:22:35	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
342	190	Срочная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:16:42	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
343	191	Срочная	1	С	 	 	2009-06-30 15:59:14	2019-11-26 18:44:39	\N	СРОЧНАЯ	\N	0	1	134	0	0	0	0	9
344	187	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:34:27	\N	\N	\N	1	0	221	0	0	0	0	19
345	187	Люкс	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:35:03	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
346	188	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:36:09	\N	\N	\N	1	0	221	0	0	0	0	19
347	188	Делюкс	0	 	 	 	2009-06-30 15:59:14	2009-07-01 12:56:05	2009-07-01 12:56:05	ДЕЛЮКС	\N	0	0	34	0	0	0	0	10
348	178	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:19:23	\N	\N	\N	1	0	221	0	0	0	0	19
349	181	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:24:58	\N	\N	\N	1	0	221	0	0	0	0	19
350	186	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:32:46	\N	\N	\N	1	0	221	0	0	0	0	19
351	192	Выборы	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:06:55	\N	ВЫБОРЫ	\N	0	1	221	0	0	0	0	20
352	188	Правительственная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:37:18	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
353	178	Правительственная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:20:46	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
354	177	Правительственная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 10:59:27	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
355	193	Перевод	0	 	П	 	2009-06-30 15:59:14	2009-06-30 15:59:14	\N	\N	\N	0	0	\N	0	0	0	0	21
357	177	Почтой заказное	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:02:57	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
358	178	Делюкс	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:19:34	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
359	181	Почтой заказное	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:26:21	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
360	181	Делюкс	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:25:12	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
361	182	Срочная	1	С	 	 	2009-06-30 15:59:14	2009-07-01 11:28:26	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
362	182	Вручить (дата)	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:27:05	\N	\N	\N	1	0	221	0	0	0	0	19
363	183	Заверенная	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:28:58	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
364	184	Почтой заказное	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:30:53	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
366	186	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:33:49	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
367	185	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:32:14	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
368	182	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:27:59	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
369	180	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2020-12-10 12:49:02	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	136	0	0	0	0	13
370	179	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:22:05	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
371	190	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:16:08	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
373	189	Вручить (дата)	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:37:43	\N	\N	\N	1	0	221	0	0	0	0	19
374	189	Заверенная	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:38:19	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
171	179	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:21:27	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
195	180	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:23:08	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
202	181	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:25:33	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
180	193	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:17:38	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
181	193	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:17:32	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
182	193	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
145	192	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:07:53	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
147	192	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:10:07	\N	\N	\N	0	1	221	0	0	0	0	23
148	192	Делюкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:07:28	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
149	192	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:49:25	\N	\N	\N	0	0	221	1	1	0	0	4
150	192	Увед. простое	0	 	 	У	2009-06-30 15:59:11	2009-10-01 13:37:58	\N	УВЕДОМЛЕНИЕ ТЕЛЕГРАФОМ	\N	0	0	221	1	0	0	0	11
151	192	Люкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:09:12	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
152	192	Заверенная	0	 	 	 	2009-06-30 15:59:11	2018-01-30 18:10:39	\N	ЗАВЕРЕННАЯ	\N	0	1	134	0	0	1	0	14
153	192	А/Я	0	 	 	 	2009-06-30 15:59:11	2018-01-30 18:11:40	\N	а/я	заверенная	0	0	134	0	0	1	0	7
154	177	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:02:23	\N	\N	\N	0	1	221	0	0	0	0	23
155	177	Срочная	1	С	 	 	2009-06-30 15:59:11	2009-07-01 11:03:27	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
157	178	Срочная	1	С	 	 	2009-06-30 15:59:11	2009-07-01 11:21:07	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
158	178	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:19:49	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
159	178	Люкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:20:17	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
160	177	Люкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:02:05	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
161	177	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:01:23	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
162	177	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:01:04	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
163	177	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
164	193	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:18:11	\N	\N	\N	0	1	221	0	0	0	0	23
165	193	Срочная	1	С	 	 	2009-06-30 15:59:11	2009-07-01 11:19:04	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
166	192	Почтой заказное	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:10:54	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
167	178	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:48:02	\N	\N	\N	0	0	221	1	1	0	0	4
168	178	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:20:03	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
169	178	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
183	193	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:47:41	\N	\N	\N	0	0	221	1	1	0	0	4
184	178	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:20:24	\N	\N	\N	0	1	221	0	0	0	0	23
185	178	Почтой заказное	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:20:36	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
186	193	Делюкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:17:11	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
189	191	Заверенная	0	 	 	 	2009-06-30 15:59:11	2019-11-26 18:44:28	\N	ЗАВЕРЕННАЯ	\N	0	1	134	0	0	0	0	14
190	179	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
191	190	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
192	191	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
194	180	А/Я	0	 	 	 	2009-06-30 15:59:11	2009-06-30 15:59:11	\N	\N	\N	0	0	\N	0	0	0	0	7
196	180	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-29 12:50:29	\N	\N	\N	0	0	31	1	1	0	0	4
197	180	Люкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:23:41	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
198	180	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:22:58	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
199	180	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:24:46	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
200	181	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:26:01	\N	\N	\N	0	1	221	0	0	0	0	23
201	181	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
203	181	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:48:34	\N	\N	\N	0	0	221	1	1	0	0	4
204	181	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:25:53	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
205	181	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:25:22	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
170	179	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:21:48	\N	\N	\N	0	1	221	0	0	0	0	23
172	179	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:48:12	\N	\N	\N	0	0	221	1	1	0	0	4
173	190	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:15:31	\N	\N	\N	0	1	221	0	0	0	0	23
174	190	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:15:01	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
175	190	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:47:31	\N	\N	\N	0	0	221	1	1	0	0	4
176	191	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:13:36	\N	\N	\N	0	1	221	0	0	0	0	23
177	191	До востреб.	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:13:00	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
179	193	Люкс	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:18:07	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
206	181	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:26:55	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
255	189	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:38:09	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
273	189	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:21:00	\N	\N	\N	0	0	221	1	0	1	0	27
156	177	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:47:50	\N	\N	\N	0	0	221	1	1	0	0	4
193	180	Обыкновенная	1	П	 	 	2009-06-30 15:59:11	2009-07-01 11:23:59	\N	\N	\N	0	1	221	0	0	0	0	23
231	186	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
252	189	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
294	190	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
318	189	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:38:55	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
365	187	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2009-07-01 11:35:26	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
144	192	Срочная	1	С	 	 	2009-06-30 15:59:11	2009-07-01 11:11:50	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
188	190	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:15:17	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
209	182	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:27:29	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
243	188	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:36:57	\N	\N	\N	0	1	221	0	0	0	0	23
300	185	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
269	191	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:16:49	\N	\N	\N	0	0	221	1	0	1	0	27
336	193	Почтой заказное	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:18:29	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
356	177	Делюкс	0	 	 	 	2009-06-30 15:59:14	2009-07-01 11:00:39	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
372	191	Почтой заказное	0	 	 	 	2009-06-30 15:59:15	2019-11-26 18:44:52	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	134	0	0	0	0	13
146	192	Увед. срочное	0	 	 	У	2009-06-30 15:59:11	2009-10-01 13:38:07	\N	УВЕДОМЛЕНИЕ ТЕЛЕГРАФОМ СРОЧНОЕ 	\N	0	0	221	1	0	0	0	28
187	179	Заверенная	0	 	 	 	2009-06-30 15:59:11	2009-07-01 11:21:36	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
178	191	Копия	0	 	 	 	2009-06-30 15:59:11	2009-07-03 16:47:23	\N	\N	\N	0	0	221	1	1	0	0	4
207	182	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:27:45	\N	\N	\N	0	1	221	0	0	0	0	23
228	185	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:49:51	\N	\N	\N	0	0	221	1	1	0	0	4
245	188	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:36:42	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
265	190	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:17:13	\N	\N	\N	0	0	221	1	0	1	0	3
282	183	Люкс	0	 	 	 	2009-06-30 15:59:13	2013-02-28 16:06:50	2013-02-28 16:06:50	ЛЮКС	\N	0	0	36	0	0	0	0	16
313	183	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:29:42	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
5431	185	Срочная	1	С	 	 	2010-01-19 12:27:42	2012-03-27 15:52:00	\N	СРОЧНАЯ	\N	0	1	31	0	0	0	0	9
5447	189	Почтой заказное	0	 	 	 	2010-01-22 12:20:00	2010-01-22 12:20:00	\N	\N	\N	0	0	31	0	0	0	0	13
6367	191	Вручить (дата)	0	 	 	 	2012-05-14 08:59:36	2012-05-14 08:59:36	\N	\N	\N	1	0	31	0	0	0	0	19
6372	191	Увед. простое	0	 	 	У	2012-05-14 09:51:12	2019-11-26 18:45:13	\N	\N	\N	0	0	134	1	0	0	0	11
6373	191	Увед. срочное	0	 	 	У	2012-05-14 09:51:52	2012-05-14 09:53:41	\N	\N	\N	0	0	31	1	0	0	0	28
208	182	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
210	182	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:48:43	\N	\N	\N	0	0	221	1	1	0	0	4
211	182	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:27:40	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
212	182	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:27:14	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
213	183	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:29:19	\N	\N	\N	0	1	221	0	0	0	0	23
214	183	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
215	183	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:48:52	\N	\N	\N	0	0	221	1	1	0	0	4
216	183	Почтой заказное	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:29:33	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
217	183	До востреб.	0	 	 	 	2009-06-30 15:59:12	2013-02-27 09:12:25	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	36	0	0	0	0	22
218	184	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:30:37	\N	\N	\N	0	1	221	0	0	0	0	23
219	184	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
220	184	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:30:19	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
221	184	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:49:00	\N	\N	\N	0	0	221	1	1	0	0	4
222	184	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:30:33	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
223	184	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:30:10	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
224	184	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:31:25	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
225	185	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:32:01	\N	\N	\N	0	1	221	0	0	0	0	23
226	185	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
227	185	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:31:53	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
229	185	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:31:40	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
230	186	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:33:36	\N	\N	\N	0	1	221	0	0	0	0	23
232	186	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:33:16	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
233	186	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:50:00	\N	\N	\N	0	0	221	1	1	0	0	4
234	186	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:33:28	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
235	186	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:33:01	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
236	186	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:34:19	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
237	187	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:35:10	\N	\N	\N	0	1	221	0	0	0	0	23
238	187	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
239	187	Заверенная	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:34:48	\N	ЗАВЕРЕННАЯ	\N	0	1	221	0	0	0	0	14
240	187	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:50:09	\N	\N	\N	0	0	221	1	1	0	0	4
241	187	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:34:38	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
242	187	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:35:59	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
244	188	А/Я	0	 	 	 	2009-06-30 15:59:12	2009-06-30 15:59:12	\N	\N	\N	0	0	\N	0	0	0	0	7
246	188	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:50:18	\N	\N	\N	0	0	221	1	1	0	0	4
247	188	Почтой заказное	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:37:06	\N	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	221	0	0	0	0	13
248	188	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:36:53	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
249	188	До востреб.	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:36:34	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	221	0	0	0	0	22
250	188	Срочная	1	С	 	 	2009-06-30 15:59:12	2009-07-01 11:37:34	\N	СРОЧНАЯ	\N	0	1	221	0	0	0	0	9
251	189	Обыкновенная	1	П	 	 	2009-06-30 15:59:12	2009-07-01 11:38:41	\N	\N	\N	0	1	221	0	0	0	0	23
253	189	Копия	0	 	 	 	2009-06-30 15:59:12	2009-07-03 16:50:26	\N	\N	\N	0	0	221	1	1	0	0	4
254	189	Люкс	0	 	 	 	2009-06-30 15:59:12	2009-07-01 11:38:35	\N	ЛЮКС	\N	0	0	221	0	0	0	0	16
256	180	Запрос-увед. част	0	 	 	У	2009-06-30 15:59:13	2009-07-01 11:23:27	\N	\N	\N	0	0	221	1	0	0	0	15
257	180	Запрос-увед. пред	0	 	 	У	2009-06-30 15:59:13	2009-07-01 11:23:23	\N	\N	\N	0	0	221	1	0	0	0	5
258	180	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-29 12:56:12	\N	\N	\N	0	0	31	1	0	1	0	3
259	180	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2017-11-08 08:47:59	\N	\N	\N	0	0	134	1	0	1	0	27
260	177	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:18	\N	\N	\N	0	0	221	1	0	1	0	3
261	177	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:22	\N	\N	\N	0	0	221	1	0	1	0	27
262	193	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:07	\N	\N	\N	0	0	221	1	0	1	0	3
263	193	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:11	\N	\N	\N	0	0	221	1	0	1	0	27
264	179	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:44	\N	\N	\N	0	0	221	1	0	1	0	3
266	191	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:16:43	\N	\N	\N	0	0	221	1	0	1	0	3
267	179	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:47	\N	\N	\N	0	0	221	1	0	1	0	27
268	190	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:17:16	\N	\N	\N	0	0	221	1	0	1	0	27
270	178	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:31	\N	\N	\N	0	0	221	1	0	1	0	3
271	178	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:18:35	\N	\N	\N	0	0	221	1	0	1	0	27
272	189	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:56	\N	\N	\N	0	0	221	1	0	1	0	3
274	181	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:08	\N	\N	\N	0	0	221	1	0	1	0	3
275	181	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:19:11	\N	\N	\N	0	0	221	1	0	1	0	27
276	185	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:15	\N	\N	\N	0	0	221	1	0	1	0	3
277	185	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:12	\N	\N	\N	0	0	221	1	0	1	0	27
278	186	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:27	\N	\N	\N	0	0	221	1	0	1	0	3
279	186	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:25	\N	\N	\N	0	0	221	1	0	1	0	27
280	187	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:39	\N	\N	\N	0	0	221	1	0	1	0	3
281	187	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:35	\N	\N	\N	0	0	221	1	0	1	0	27
283	192	Люкс/М	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:09:42	\N	ЛЮКС/М	\N	0	0	221	0	0	0	0	12
284	192	Люкс/В	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:09:22	\N	ЛЮКС/В	\N	0	0	221	0	0	0	0	24
285	192	ЛК/М/И	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:08:59	\N	ЛЮКС/М/И	\N	0	0	221	0	0	0	0	25
286	192	Люкс/И	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:09:32	\N	ЛЮКС/И	\N	0	0	221	0	0	0	0	6
287	192	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
288	192	Перевод	0	 	П	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	21
289	192	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:11:32	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
290	177	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:02:35	\N	\N	\N	0	1	221	0	0	0	0	18
291	193	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
292	178	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
293	179	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
295	191	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
296	180	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
297	181	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
298	182	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
299	184	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
301	186	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
302	187	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
303	188	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
304	189	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
305	183	Переговор	0	 	 	 	2009-06-30 15:59:13	2009-06-30 15:59:13	\N	\N	\N	0	0	\N	0	0	0	0	18
306	193	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:18:42	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
307	180	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:24:22	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
308	179	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:22:16	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
309	190	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:16:22	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
310	191	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:14:09	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
311	181	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:26:34	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
312	182	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:28:08	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	0	221	0	0	0	0	17
314	184	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:31:06	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
315	185	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:32:28	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
316	186	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:33:59	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
317	187	Правительственная	1	С	 	 	2009-06-30 15:59:13	2009-07-01 11:35:35	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	221	0	0	0	0	17
319	189	Делюкс	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:37:58	\N	ДЕЛЮКС	\N	0	0	221	0	0	0	0	10
320	192	Вручить (дата)	0	 	 	 	2009-06-30 15:59:13	2009-07-01 11:03:59	\N	\N	\N	1	0	221	0	0	0	0	19
321	192	Служ. запрос част	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:03	\N	\N	\N	0	0	221	1	0	1	0	3
322	192	Служ. запрос пред	0	 	 	 	2009-06-30 15:59:13	2009-07-07 18:20:00	\N	\N	\N	0	0	221	1	0	1	0	27
323	192	Запрос-увед. част	0	 	 	У	2009-06-30 15:59:13	2009-10-01 13:37:42	\N	\N	\N	0	0	221	1	0	0	0	15
324	192	Запрос-увед. пред	0	 	 	У	2009-06-30 15:59:13	2009-10-01 13:37:47	\N	\N	\N	0	0	221	1	0	0	0	5
325	192	Копия част	0	 	 	 	2009-06-30 15:59:13	2009-07-03 16:49:33	\N	\N	\N	0	0	221	1	1	0	0	8
6374	180	Делюкс	0	 	 	 	2020-12-10 12:53:15	2020-12-10 12:53:15	\N	ДЕЛЮКС	\N	0	0	136	0	0	0	0	10
\.


--
-- Data for Name: bill_tarif; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_tarif (tarif_id, name, profit, nds, closed, unit_id, created, changed, opened, def_service_id, msgtype_id, operator_id, external_id, subtract_nds) FROM stdin;
18	Вакансии сегодня	30.00	18.00	\N	2	2009-06-16 13:05:30	2009-12-07 13:32:40	2009-06-16 00:00:00	\N	2	36	10	0
19	Я.Жизнь	30.00	18.00	\N	2	2009-06-16 14:35:49	2011-06-28 10:49:50	2009-06-16 00:00:00	\N	2	36	11	0
37	Новости города. Пермь	30.00	18.00	\N	2	2009-06-17 10:51:00	2009-12-07 13:35:22	2009-06-17 10:51:00	\N	2	36	12	0
38	ТВ3-Пермь	100.00	18.00	\N	2	2009-06-17 11:09:09	2009-06-17 11:28:14	2009-06-17 11:09:09	\N	2	\N	13	0
39	Мегаполис	100.00	18.00	2009-06-17 11:28:37	2	2009-06-17 11:28:07	2009-06-17 11:28:37	2009-06-17 00:00:00	\N	2	\N	14	0
40	Мегаполис	100.00	18.00	\N	2	2009-06-17 11:28:52	2009-06-17 11:28:52	2009-06-17 11:28:52	\N	2	\N	14	0
41	Московский комсомолец-МК в Перми	100.00	18.00	\N	1	2009-06-17 11:35:53	2009-06-17 11:35:53	2009-06-17 11:35:53	\N	2	\N	15	0
43	Почто-Ринг	100.00	18.00	\N	1	2009-06-17 11:46:47	2009-06-17 11:46:47	2009-06-17 00:00:00	\N	2	\N	16	0
44	Ваш Спецiалистъ по Работе, Вакансиям, Обучению	100.00	18.00	\N	2	2009-06-17 11:52:29	2009-06-17 11:52:29	2009-06-17 11:52:29	\N	2	\N	17	0
45	Интернет-дайджест Пятница	100.00	18.00	2009-09-30 10:57:25	1	2009-06-17 12:30:13	2009-09-30 10:57:25	2009-06-17 12:30:13	\N	2	36	18	0
46	Интернет-сайт /www.metrovich.ru/	100.00	18.00	\N	3	2009-06-17 12:38:55	2009-06-18 10:46:42	2009-06-17 12:38:55	\N	2	\N	19	0
47	Сибирский тракт-Пермь	100.00	18.00	\N	2	2009-06-17 12:47:00	2009-06-17 12:47:00	2009-06-17 12:47:00	\N	2	\N	20	0
48	Звезда	100.00	18.00	\N	1	2009-06-17 12:52:32	2009-06-17 12:52:32	2009-06-17 12:52:32	\N	2	\N	21	0
49	Бесплатная речевая газета Всё про всё:вакансии гор	100.00	18.00	\N	2	2009-06-17 12:59:18	2009-06-17 12:59:18	2009-06-17 12:59:18	\N	2	\N	22	0
50	Хронометр. Пермь	100.00	18.00	\N	2	2009-06-17 13:03:57	2009-06-17 13:03:57	2009-06-17 13:03:57	\N	2	\N	23	0
51	Пермская областная газета "Эфир"	100.00	18.00	\N	1	2009-06-17 13:09:44	2009-06-17 13:09:44	2009-06-17 13:09:44	\N	2	\N	24	0
52	Инфокурьер	100.00	18.00	\N	1	2009-06-17 13:14:14	2009-06-17 13:14:14	2009-06-17 13:14:14	\N	2	\N	25	0
53	Мой дом	30.00	18.00	\N	1	2009-06-17 13:17:38	2009-12-07 13:33:11	2009-06-17 13:17:38	\N	2	36	26	0
54	Я.Комсомольская правда в Перми 	30.00	18.00	\N	2	2009-06-17 13:23:43	2011-04-14 16:01:59	2009-06-17 13:23:43	\N	2	36	27	0
55	Мой район.Микрорайон Крохалева,микрорайон Краснова	100.00	18.00	\N	1	2009-06-17 14:08:01	2009-06-17 14:08:01	2009-06-17 14:08:01	\N	2	\N	28	0
56	Работа всем в Перми	30.00	18.00	\N	2	2009-06-17 14:16:49	2009-12-07 13:33:23	2009-06-17 14:16:49	\N	2	36	29	0
57	Время-Деньги	30.00	18.00	\N	2	2009-06-17 15:59:51	2009-12-07 13:33:28	2009-06-17 15:59:51	\N	2	36	30	0
58	Досье 02	30.00	18.00	\N	2	2009-06-17 16:15:58	2009-12-07 13:35:11	2009-06-17 16:15:58	\N	2	36	31	0
59	Пермские квартиры, дома & офисы	100.00	18.00	\N	2	2009-06-17 16:48:29	2009-06-17 16:48:29	2009-06-17 16:48:29	\N	2	\N	32	0
60	Пермский автокурьер	30.00	18.00	\N	2	2009-06-17 16:59:00	2009-12-07 13:33:38	2009-06-17 16:59:00	\N	2	36	33	0
77	Специалист. Пермский край	100.00	18.00	\N	2	2009-06-18 10:23:24	2009-06-18 10:23:24	2009-06-18 10:23:24	\N	2	\N	34	0
78	Прикамье один плюс один	100.00	18.00	\N	2	2009-06-18 10:31:31	2009-06-18 10:31:31	2009-06-18 10:31:31	\N	2	\N	35	0
79	Прикамье один плюс один Балатово	100.00	18.00	\N	2	2009-06-18 10:34:41	2009-06-18 10:34:41	2009-06-18 10:34:41	\N	2	\N	36	0
80	Интернет-сайт /www.vsem.info/	100.00	18.00	\N	1	2009-06-18 10:47:58	2009-06-18 10:47:58	2009-06-18 10:47:58	\N	2	\N	37	0
81	Работа и услуги в Пермском крае	30.00	18.00	\N	2	2009-06-18 10:59:49	2009-12-07 13:33:50	2009-06-18 10:59:49	\N	2	36	38	0
97	Теленеделя для всей семьи	30.00	18.00	\N	1	2009-06-19 15:03:32	2009-12-07 13:35:31	2009-06-19 15:03:32	\N	2	36	39	0
117	Гайва плюс	30.00	18.00	\N	2	2009-06-24 13:31:51	2009-12-07 13:34:05	2009-06-24 13:31:51	\N	2	36	40	0
137	Закамск плюс	30.00	18.00	\N	2	2009-06-24 13:47:56	2009-12-07 13:34:17	2009-06-24 13:47:56	\N	2	36	41	0
138	Мотовилиха плюс	30.00	18.00	\N	2	2009-06-24 13:55:26	2009-12-07 13:34:22	2009-06-24 13:55:26	\N	2	36	42	0
118	Работа для Вас	30.00	18.00	\N	2	2009-06-25 09:09:00	2009-12-07 13:34:53	2009-06-25 09:09:00	\N	2	36	43	0
139	Работа в Прикамье	100.00	18.00	2009-06-25 12:25:22	2	2009-06-25 12:24:59	2009-06-25 12:25:22	2009-06-25 12:24:59	\N	2	618	44	0
140	Работа в Прикамье	30.00	18.00	\N	2	2009-06-25 13:17:46	2009-12-07 13:34:58	2009-06-25 13:17:46	\N	2	36	44	0
141	Работа всей Перми	30.00	18.00	\N	2	2009-06-25 13:18:10	2009-12-07 13:35:02	2009-06-25 13:18:10	\N	2	36	45	0
157	Информ-курьер	30.00	18.00	\N	2	2009-06-29 14:23:20	2009-12-07 13:35:06	2009-06-29 14:23:20	\N	2	36	46	0
177	Телеграмма Армения	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:19	2009-06-30 14:29:55	3712	1	221	114	0
178	Телеграмма Беларусь	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:40:36	2009-06-30 14:29:55	3927	1	221	115	0
179	Телеграмма Грузия	100.00	18.00	\N	2	2009-06-30 14:29:55	2015-02-07 16:17:51	2009-06-30 14:29:55	3937	1	134	116	0
180	Телеграмма Казахстан	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:33	2009-06-30 14:29:55	3951	1	221	117	0
181	Телеграмма Кыргызстан	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:37	2009-06-30 14:29:55	3987	1	221	118	0
182	Телеграмма Латвия	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:41	2009-06-30 14:29:55	4023	1	221	119	0
183	Телеграмма Литва	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:45	2009-06-30 14:29:55	4041	1	221	120	0
184	Телеграмма Молдова	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:48	2009-06-30 14:29:55	4058	1	221	121	0
185	Телеграмма Таджикистан	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:54	2009-06-30 14:29:55	4093	1	221	122	0
186	Телеграмма Туркмения	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:59	2009-06-30 14:29:55	4105	1	221	123	0
187	Телеграмма Узбекистан	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:40:03	2009-06-30 14:29:55	4141	1	221	124	0
188	Телеграмма Украина	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:40:10	2009-06-30 14:29:55	4165	1	221	125	0
189	Телеграмма Эстония	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:40:15	2009-06-30 14:29:55	4216	1	221	126	0
190	Телеграмма Аджария	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:40:19	2009-06-30 14:29:55	3938	1	221	127	0
191	Телеграмма Абхазия	100.00	18.00	\N	2	2009-06-30 14:29:55	2019-11-26 18:36:21	2009-06-30 14:29:55	3939	1	134	128	0
192	Телеграмма Россия	100.00	18.00	\N	2	2009-06-30 14:29:55	2022-09-30 14:26:32	2022-10-01 14:29:55	4695	1	134	129	0
193	Телеграмма Азербайджан	100.00	18.00	\N	2	2009-06-30 14:29:55	2009-07-01 11:39:24	2009-06-30 14:29:55	3723	1	221	130	0
197	Пермские новости	30.00	18.00	\N	2	2009-07-06 15:16:07	2009-12-07 13:35:49	2009-07-06 15:16:07	\N	2	36	47	0
198	Я.Комсомольская правда в Перми-толстушка	30.00	18.00	\N	2	2009-07-07 13:17:24	2011-04-14 16:02:05	2009-07-07 13:17:24	\N	2	36	48	0
217	Телегазета Мегаполис	30.00	18.00	\N	2	2009-07-16 13:06:21	2009-12-07 13:35:59	2009-07-16 13:06:21	\N	2	36	49	0
237	Телекон	25.00	18.00	\N	2	2009-08-26 13:51:51	2009-12-07 13:36:04	2009-08-26 13:51:51	\N	2	36	132	0
257	Телекон Плюс	100.00	18.00	\N	2	2009-09-01 13:27:12	2009-12-07 13:36:14	2009-09-01 13:27:12	\N	2	36	\N	0
277	Рифей-Пермь	30.00	18.00	\N	2	2009-09-21 08:55:19	2009-12-07 13:36:18	2009-09-21 08:55:19	\N	2	36	133	0
297	РАЙОНЫ ПЕРМИ. Проспект Парковый	30.00	18.00	\N	2	2009-09-29 10:31:15	2009-12-07 13:36:23	2009-09-29 10:31:15	\N	2	36	134	0
299	РАЙОНЫ ПЕРМИ. Мотовилиха	30.00	18.00	\N	2	2009-09-29 10:31:44	2009-12-07 13:36:27	2009-09-29 10:31:44	\N	2	36	135	0
300	РАЙОНЫ ПЕРМИ. Балатово	30.00	18.00	\N	2	2009-09-29 10:44:38	2009-12-07 13:36:31	2009-09-29 10:44:38	\N	2	36	136	0
301	РАЙОНЫ ПЕРМИ. Центр	30.00	18.00	\N	2	2009-09-29 10:45:23	2009-12-07 13:36:35	2009-09-29 10:45:23	\N	2	36	137	0
317	Интернет-Дайджест "Пятница"	30.00	18.00	\N	1	2009-09-30 10:53:16	2009-12-07 13:36:39	2009-09-30 10:53:16	\N	2	36	138	0
337	Районы. Кварталы. Квартиры	30.00	18.00	\N	3	2009-10-12 13:45:42	2009-12-07 13:36:46	2009-10-12 13:45:42	\N	2	36	\N	0
357	Березовский рабочий	40.00	18.00	\N	1	2009-10-16 14:16:07	2010-04-22 12:18:15	2009-10-16 14:16:07	\N	2	36	142	0
377	Интернет-сайт /www.properm.ru, teron.ru/	30.00	18.00	\N	2	2009-10-26 09:22:16	2009-12-07 13:36:56	2009-10-26 09:22:16	\N	2	36	144	0
397	Маршрут ТВ Урал	30.00	18.00	\N	2	2009-10-28 13:45:43	2009-12-07 13:37:00	2009-10-28 13:45:43	\N	2	36	141	0
398	ВЕТТА	30.00	18.00	\N	2	2009-10-28 16:08:54	2009-12-07 13:37:04	2009-10-28 16:08:54	\N	2	36	143	0
417	Заря Урала	30.00	18.00	\N	2	2009-11-10 15:30:19	2009-12-07 13:37:08	2009-11-10 15:30:19	\N	2	36	152	0
437	Красноуральский рабочий	30.00	18.00	\N	1	2009-11-17 08:58:41	2009-12-07 13:37:12	2009-11-17 08:58:41	\N	2	36	153	0
457	Нейва	30.00	18.00	\N	2	2009-11-20 10:55:38	2009-12-07 13:37:16	2009-11-20 10:55:38	\N	2	36	154	0
477	Первоуральск ТВ	30.00	18.00	\N	2	2009-12-07 13:22:55	2009-12-07 13:37:19	2009-12-07 13:22:55	\N	2	36	149	0
497	Толкучка	30.00	18.00	\N	3	2009-12-09 13:44:58	2009-12-09 14:01:17	2009-12-09 13:44:58	\N	2	36	148	0
517	Новая еженедельная газета	30.00	18.00	\N	3	2009-12-09 14:00:59	2009-12-09 14:00:59	2009-12-09 14:00:59	\N	2	36	150	0
537	Всё будет!	30.00	18.00	\N	1	2009-12-15 10:32:46	2009-12-15 10:32:46	2009-12-15 10:32:46	\N	2	36	145	0
557	Три города	30.00	18.00	\N	1	2009-12-17 11:20:11	2009-12-17 11:20:11	2009-12-17 11:20:11	\N	2	36	146	0
558	Пульс города	30.00	18.00	\N	1	2009-12-17 13:17:42	2010-04-22 12:17:53	2009-12-17 13:17:42	\N	2	36	147	0
577	Европа	100.00	18.00	\N	4	2010-01-15 11:55:55	2014-09-04 16:00:17	2010-01-15 00:00:00	5388	3	1	\N	0
578	Австралия	100.00	18.00	\N	4	2010-01-15 11:56:10	2010-01-15 12:28:57	2010-01-15 00:00:00	\N	3	31	\N	0
597	Тагильский рабочий	30.00	18.00	\N	3	2010-01-29 14:08:17	2010-04-22 12:17:47	2010-01-29 14:08:17	\N	2	36	157	0
617	Новый компас	20.00	18.00	\N	2	2010-04-19 12:06:55	2010-04-22 12:17:36	2010-04-19 12:06:55	\N	2	36	\N	0
618	Нет проблем!	20.00	18.00	\N	2	2010-04-22 11:53:42	2010-04-22 12:17:28	2010-04-22 11:53:42	\N	2	36	\N	0
619	ТВоя программа	20.00	18.00	\N	2	2010-04-22 11:54:10	2010-04-22 12:17:21	2010-04-22 11:54:10	\N	2	36	\N	0
620	Компас-ТВ	100.00	18.00	\N	2	2010-04-22 15:30:33	2010-04-22 15:30:33	2010-04-22 15:30:33	\N	2	36	\N	0
621	Районные будни	40.00	18.00	\N	2	2010-04-27 11:04:54	2010-04-27 11:04:54	2010-04-27 11:04:54	\N	2	36	\N	0
637	Купеческий дворЪ	100.00	18.00	\N	1	2010-07-29 12:47:07	2010-07-29 12:47:07	2010-07-29 12:47:07	\N	2	36	\N	0
657	Районы Перми	100.00	18.00	\N	2	2010-10-28 14:05:24	2010-10-28 14:05:24	2010-10-28 14:05:24	\N	2	36	\N	0
677	Perm Animals	100.00	18.00	\N	1	2010-11-12 10:16:58	2010-11-12 10:16:58	2010-11-12 10:16:58	\N	2	36	\N	0
697	Комсомольская правда	100.00	18.00	\N	2	2011-04-14 16:02:34	2011-04-14 16:02:34	2011-04-14 16:02:34	\N	2	36	\N	0
698	Комсомольская правда-толстушка	100.00	18.00	\N	2	2011-04-14 16:02:56	2011-04-14 16:02:56	2011-04-14 16:02:56	\N	2	36	\N	0
717	Золотая горка	100.00	18.00	\N	5	2011-06-14 16:47:26	2011-06-15 14:03:49	2011-06-01 00:00:00	\N	2	36	\N	0
718	Еженедельный карман	100.00	18.00	\N	5	2011-06-15 14:27:09	2011-06-15 14:27:09	2011-06-15 14:27:09	\N	2	36	\N	0
737	Жизнь	100.00	18.00	\N	2	2011-06-28 10:50:08	2011-06-28 10:50:08	2011-06-28 10:50:08	\N	2	36	\N	0
738	Купи Продай плюс ТВ	100.00	18.00	\N	3	2011-06-28 13:18:55	2011-06-28 13:18:55	2011-06-28 13:18:55	\N	2	36	\N	0
757	Пятница-Вакансии	100.00	18.00	\N	5	2011-08-15 10:01:46	2013-07-25 11:01:39	2011-08-15 10:01:46	\N	2	4761	\N	0
777	В Курсе Пермь	100.00	18.00	\N	5	2011-09-13 09:44:36	2011-09-13 09:44:36	2011-09-13 09:44:36	\N	2	36	\N	0
797	Другая газета	100.00	18.00	\N	5	2011-10-20 16:27:35	2011-10-20 16:27:35	2011-10-20 16:27:35	\N	2	36	\N	0
817	Березаinfo	100.00	18.00	\N	5	2011-11-26 14:27:30	2011-11-26 14:27:30	2011-11-26 14:27:30	\N	2	36	31724	0
837	Пятница	100.00	18.00	\N	2	2011-12-09 14:56:01	2011-12-09 14:56:01	2011-12-09 14:56:01	\N	2	36	\N	0
841	Тестовое СМИ	0.00	18.00	\N	1	2014-07-22 12:56:57	2014-07-31 11:24:40	2014-07-22 12:56:57	\N	2	1	\N	0
842	Австрия	100.00	18.00	\N	4	2017-11-29 09:58:24	2017-11-29 09:58:24	2017-12-01 00:00:00	\N	3	1	\N	0
843	Албания	100.00	18.00	\N	4	2017-11-29 09:58:43	2017-11-29 09:58:43	2017-12-01 00:00:00	\N	3	1	\N	0
844	Алжир	100.00	18.00	\N	4	2017-11-29 09:59:42	2017-11-29 09:59:42	2017-12-01 00:00:00	\N	3	1	\N	0
845	Ангола	100.00	18.00	\N	4	2017-11-29 10:00:15	2017-11-29 10:00:15	2017-12-01 00:00:00	\N	3	1	\N	0
846	Андорра	100.00	18.00	\N	4	2017-11-29 10:00:32	2017-11-29 10:00:32	2017-12-01 00:00:00	\N	3	1	\N	0
847	Антильские нидерландские о-ва	100.00	18.00	\N	4	2017-11-29 10:01:10	2017-11-29 10:01:10	2017-12-01 00:00:00	\N	3	1	\N	0
848	Аргентина	100.00	18.00	\N	4	2017-11-29 10:01:30	2017-11-29 10:01:30	2017-12-01 00:00:00	\N	3	1	\N	0
849	Аруба	100.00	18.00	\N	4	2017-11-29 10:01:44	2017-11-29 10:01:44	2017-11-01 00:00:00	\N	3	1	\N	0
850	Багамские о-ва	100.00	18.00	\N	4	2017-11-29 10:02:10	2017-11-29 10:02:10	2017-12-01 00:00:00	\N	3	1	\N	0
851	Бангладеш	100.00	18.00	\N	4	2017-11-29 10:02:48	2017-11-29 10:02:48	2017-12-01 00:00:00	\N	3	1	\N	0
852	Барбадос	100.00	18.00	\N	4	2017-11-29 10:03:07	2017-11-29 10:03:07	2017-12-01 00:00:00	\N	3	1	\N	0
853	Бахрейн	100.00	18.00	\N	4	2017-11-29 10:03:24	2017-11-29 10:03:24	2017-12-01 00:00:00	\N	3	1	\N	0
854	Белиз	100.00	18.00	\N	4	2017-11-29 10:03:39	2017-11-29 10:03:39	2017-12-01 00:00:00	\N	3	1	\N	0
855	Бельгия	100.00	18.00	\N	4	2017-11-29 10:03:51	2017-11-29 10:03:51	2017-12-01 00:00:00	\N	3	1	\N	0
856	Бенин	100.00	18.00	\N	4	2017-11-29 10:04:06	2017-11-29 10:04:06	2017-12-01 00:00:00	\N	3	1	\N	0
857	Бермудские о-ва	100.00	18.00	\N	4	2017-11-29 10:04:26	2017-11-29 10:04:26	2017-12-01 00:00:00	\N	3	1	\N	0
858	Болгария	100.00	18.00	\N	4	2017-11-29 10:04:55	2017-11-29 10:04:55	2017-12-01 00:00:00	\N	3	1	\N	0
859	Боливия	100.00	18.00	\N	4	2017-11-29 10:05:08	2017-11-29 10:05:08	2017-12-01 00:00:00	\N	3	1	\N	0
861	Босния и Герцеговина	100.00	18.00	\N	4	2017-11-29 10:05:33	2017-11-29 10:05:33	2017-12-01 00:00:00	\N	3	1	\N	0
862	Ботсвана	100.00	18.00	\N	4	2017-11-29 10:05:51	2017-11-29 10:05:51	2017-12-01 00:00:00	\N	3	1	\N	0
863	Бразилия	100.00	18.00	\N	4	2017-11-29 10:06:04	2017-11-29 10:06:04	2017-12-01 00:00:00	\N	3	1	\N	0
864	Бруней	100.00	18.00	\N	4	2017-11-29 10:06:24	2017-11-29 10:06:24	2017-12-01 00:00:00	\N	3	1	\N	0
865	Буркина-Фасо	100.00	18.00	\N	4	2017-11-29 10:06:48	2017-11-29 10:06:48	2017-12-01 00:00:00	\N	3	1	\N	0
866	Бурунди	100.00	18.00	\N	4	2017-11-29 10:07:07	2017-11-29 10:07:07	2017-12-01 00:00:00	\N	3	1	\N	0
867	Бутан	100.00	18.00	\N	4	2017-11-29 10:07:25	2017-11-29 10:07:25	2017-12-01 00:00:00	\N	3	1	\N	0
868	Вануату	100.00	18.00	\N	4	2017-11-29 10:27:22	2017-11-29 10:27:22	2017-12-01 00:00:00	\N	3	1	\N	0
869	Ватикан	100.00	18.00	\N	4	2017-11-29 10:27:35	2017-11-29 10:27:35	2017-12-01 00:00:00	\N	3	1	\N	0
870	Великобритания	100.00	18.00	\N	4	2017-11-29 10:27:52	2017-11-29 10:27:52	2017-12-01 00:00:00	\N	3	1	\N	0
871	Венгрия	100.00	18.00	\N	4	2017-11-29 10:28:09	2017-11-29 10:28:09	2017-12-01 00:00:00	\N	3	1	\N	0
872	Венесуэла	100.00	18.00	\N	4	2017-11-29 10:28:25	2017-11-29 10:28:25	2017-12-01 00:00:00	\N	3	1	\N	0
873	Виргинские британские о-ва	100.00	18.00	\N	4	2017-11-29 10:29:04	2017-11-29 10:29:04	2017-12-01 00:00:00	\N	3	1	\N	0
874	Вознесения о-в	100.00	18.00	2017-11-29 10:30:32	4	2017-11-29 10:29:27	2017-11-29 10:30:32	2017-12-01 00:00:00	\N	3	1	\N	0
875	Вьетнам	100.00	18.00	\N	4	2017-11-29 10:29:51	2017-11-29 10:29:51	2017-12-01 00:00:00	\N	3	1	\N	0
876	Габон	100.00	18.00	\N	4	2017-11-29 10:30:04	2017-11-29 10:30:04	2017-12-01 00:00:00	\N	3	1	\N	0
877	Гаити	100.00	18.00	\N	4	2017-11-29 10:30:13	2017-11-29 10:30:13	2017-12-01 00:00:00	\N	3	1	\N	0
878	Гайана	100.00	18.00	\N	4	2017-11-29 10:31:01	2017-11-29 10:31:01	2017-12-01 00:00:00	\N	3	1	\N	0
879	Гамбия	100.00	18.00	\N	4	2017-11-29 10:31:16	2017-11-29 10:31:16	2017-12-01 00:00:00	\N	3	1	\N	0
880	Гана	100.00	18.00	\N	4	2017-11-29 10:31:26	2017-11-29 10:31:26	2017-12-01 00:00:00	\N	3	1	\N	0
881	Гваделупа	100.00	18.00	\N	4	2017-11-29 10:31:41	2017-11-29 10:31:41	2017-12-01 00:00:00	\N	3	1	\N	0
882	Гватемала	100.00	18.00	\N	4	2017-11-29 10:31:54	2017-11-29 10:31:54	2017-12-01 00:00:00	\N	3	1	\N	0
883	Гвиана (французская)	100.00	18.00	\N	4	2017-11-29 10:32:23	2017-11-29 10:32:23	2017-12-01 00:00:00	\N	3	1	\N	0
884	Гвинея	100.00	18.00	\N	4	2017-11-29 10:32:43	2017-11-29 10:32:43	2017-12-01 00:00:00	\N	3	1	\N	0
885	Гвинея-Бисау	100.00	18.00	\N	4	2017-11-29 10:32:57	2017-11-29 10:32:57	2017-12-01 00:00:00	\N	3	1	\N	0
886	Германия	100.00	18.00	\N	4	2017-11-29 10:33:19	2017-11-29 10:33:19	2017-12-01 00:00:00	\N	3	1	\N	0
887	Гибралтар	100.00	18.00	\N	4	2017-11-29 10:33:36	2017-11-29 10:33:36	2017-12-01 00:00:00	\N	3	1	\N	0
888	Гонддурас	100.00	18.00	\N	4	2017-11-29 10:33:53	2017-11-29 10:33:53	2017-12-01 00:00:00	\N	3	1	\N	0
889	Гонконг	100.00	18.00	\N	4	2017-11-29 10:34:13	2017-11-29 10:34:13	2017-12-01 00:00:00	\N	3	1	\N	0
890	Гренада	100.00	18.00	\N	4	2017-11-29 10:34:26	2017-11-29 10:34:26	2017-12-01 00:00:00	\N	3	1	\N	0
891	Греция	100.00	18.00	\N	4	2017-11-29 10:34:48	2017-11-29 10:34:48	2017-12-01 00:00:00	\N	3	1	\N	0
892	Гуам	100.00	18.00	\N	4	2017-11-29 10:35:00	2017-11-29 10:35:00	2017-12-01 00:00:00	\N	3	1	\N	0
893	Дания	100.00	18.00	\N	4	2017-11-29 10:35:26	2017-11-29 10:35:26	2017-12-01 00:00:00	\N	3	1	\N	0
894	Демократическая республика Конго	100.00	18.00	\N	4	2017-11-29 10:35:53	2017-11-29 10:35:53	2017-12-01 00:00:00	\N	3	1	\N	0
895	Джибути	100.00	18.00	\N	4	2017-11-29 10:36:12	2017-11-29 10:36:12	2017-12-01 00:00:00	\N	3	1	\N	0
896	Доминиканская р-ка	100.00	18.00	\N	4	2017-11-29 10:36:33	2017-11-29 10:36:33	2017-12-01 00:00:00	\N	3	1	\N	0
897	Египет	100.00	18.00	\N	4	2017-11-29 10:36:51	2017-11-29 10:36:51	2017-12-01 00:00:00	\N	3	1	\N	0
898	Замбия	100.00	18.00	\N	4	2017-11-29 10:37:03	2017-11-29 10:37:03	2017-12-01 00:00:00	\N	3	1	\N	0
899	Западное Самоа	100.00	18.00	\N	4	2017-11-29 10:37:23	2017-11-29 10:37:23	2017-12-01 00:00:00	\N	3	1	\N	0
900	Зимбабве	100.00	18.00	\N	4	2017-11-29 10:37:42	2017-11-29 10:37:42	2017-12-01 00:00:00	\N	3	1	\N	0
901	Израиль	100.00	18.00	\N	4	2017-11-29 10:37:57	2017-11-29 10:37:57	2017-12-01 00:00:00	\N	3	1	\N	0
902	Индия	100.00	18.00	\N	4	2017-11-29 10:38:19	2017-11-29 10:38:19	2017-12-01 00:00:00	\N	3	1	\N	0
903	Индонезия	100.00	18.00	\N	4	2017-11-29 10:38:30	2017-11-29 10:38:30	2017-12-01 00:00:00	\N	3	1	\N	0
904	Иордания	100.00	18.00	\N	4	2017-11-29 10:38:41	2017-11-29 10:38:41	2017-12-01 00:00:00	\N	3	1	\N	0
905	Иран	100.00	18.00	\N	4	2017-11-29 10:38:57	2017-11-29 10:38:57	2017-12-01 00:00:00	\N	3	1	\N	0
906	Ирландия	100.00	18.00	\N	4	2017-11-29 10:39:13	2017-11-29 10:39:13	2017-12-01 00:00:00	\N	3	1	\N	0
907	Исландия	100.00	18.00	\N	4	2017-11-29 10:39:26	2017-11-29 10:39:26	2017-12-01 00:00:00	\N	3	1	\N	0
908	Испания	100.00	18.00	\N	4	2017-11-29 10:39:42	2017-11-29 10:39:42	2017-12-01 00:00:00	\N	3	1	\N	0
909	Италия	100.00	18.00	\N	4	2017-11-29 10:39:54	2017-11-29 10:39:54	2017-12-01 00:00:00	\N	3	1	\N	0
910	Йемен	100.00	18.00	\N	4	2017-11-29 10:40:10	2017-11-29 10:40:10	2017-12-01 00:00:00	\N	3	1	\N	0
911	Кабо-Верде	100.00	18.00	\N	4	2017-11-29 10:40:36	2017-11-29 10:40:36	2017-12-01 00:00:00	\N	3	1	\N	0
912	Каймановы о-ва	100.00	18.00	\N	4	2017-11-29 10:40:56	2017-11-29 10:40:56	2017-12-01 00:00:00	\N	3	1	\N	0
913	Камбоджа	100.00	18.00	\N	4	2017-11-29 10:41:13	2017-11-29 10:41:13	2017-12-01 00:00:00	\N	3	1	\N	0
914	Канада	100.00	18.00	\N	4	2017-11-29 10:41:29	2017-11-29 10:41:29	2017-12-01 00:00:00	\N	3	1	\N	0
915	Катар	100.00	18.00	\N	4	2017-11-29 10:41:41	2017-11-29 10:41:41	2017-12-01 00:00:00	\N	3	1	\N	0
916	Кения	100.00	18.00	\N	4	2017-11-29 10:42:06	2017-11-29 10:42:06	2017-12-01 00:00:00	\N	3	1	\N	0
917	Кипр	100.00	18.00	\N	4	2017-11-29 10:42:16	2017-11-29 10:42:16	2017-12-01 00:00:00	\N	3	1	\N	0
918	Кирибати	100.00	18.00	\N	4	2017-11-29 10:42:33	2017-11-29 10:42:33	2017-12-01 00:00:00	\N	3	1	\N	0
919	Китай	100.00	18.00	\N	4	2017-11-29 10:42:50	2017-11-29 10:42:50	2017-12-01 00:00:00	\N	3	1	\N	0
920	Колумбия	100.00	18.00	\N	4	2017-11-29 10:43:07	2017-11-29 10:43:07	2017-12-01 00:00:00	\N	3	1	\N	0
921	Коморские о-ва	100.00	18.00	\N	4	2017-11-29 10:43:30	2017-11-29 10:43:30	2017-12-01 00:00:00	\N	3	1	\N	0
922	Конго	100.00	18.00	\N	4	2017-11-29 10:43:47	2017-11-29 10:43:47	2017-12-01 00:00:00	\N	3	1	\N	0
923	Корейская народно-демократическая республика	100.00	18.00	\N	4	2017-11-29 10:44:13	2017-11-29 10:44:13	2017-12-01 00:00:00	\N	3	1	\N	0
924	Корея республика	100.00	18.00	\N	4	2017-11-29 10:44:32	2017-11-29 10:44:32	2017-12-01 00:00:00	\N	3	1	\N	0
925	Коста-Рика	100.00	18.00	\N	4	2017-11-29 10:44:56	2017-11-29 10:44:56	2017-12-01 00:00:00	\N	3	1	\N	0
926	Кот-Дивуар	100.00	18.00	\N	4	2017-11-29 10:45:17	2017-11-29 10:45:17	2017-12-01 00:00:00	\N	3	1	\N	0
927	Куба	100.00	18.00	\N	4	2017-11-29 10:45:34	2017-11-29 10:45:34	2017-12-01 00:00:00	\N	3	1	\N	0
928	Кувейт	100.00	18.00	\N	4	2017-11-29 10:45:44	2017-11-29 10:45:44	2017-12-01 00:00:00	\N	3	1	\N	0
929	Кука о-ва	100.00	18.00	\N	4	2017-11-29 10:46:01	2017-11-29 10:46:01	2017-12-01 00:00:00	\N	3	1	\N	0
930	Лесото	100.00	18.00	\N	4	2017-11-29 10:46:21	2017-11-29 10:46:21	2017-12-01 00:00:00	\N	3	1	\N	0
931	Ливан	100.00	18.00	\N	4	2017-11-29 10:46:33	2017-11-29 10:46:33	2017-12-01 00:00:00	\N	3	1	\N	0
932	Ливия	100.00	18.00	\N	4	2017-11-29 10:46:42	2017-11-29 10:46:42	2017-12-01 00:00:00	\N	3	1	\N	0
933	Лихтенштейн	100.00	18.00	\N	4	2017-11-29 10:46:56	2017-11-29 10:46:56	2017-12-01 00:00:00	\N	3	1	\N	0
934	Люксембург	100.00	18.00	\N	4	2017-11-29 10:47:09	2017-11-29 10:47:09	2017-12-01 00:00:00	\N	3	1	\N	0
935	Маврикий	100.00	18.00	\N	4	2017-11-29 10:47:30	2017-11-29 10:47:30	2017-12-01 00:00:00	\N	3	1	\N	0
936	Мавритания	100.00	18.00	2017-11-29 10:48:07	4	2017-11-29 10:47:42	2017-11-29 10:48:07	2017-12-01 00:00:00	\N	3	1	\N	0
937	Мадагаскар	100.00	18.00	\N	4	2017-11-29 10:48:00	2017-11-29 10:48:00	2017-12-01 00:00:00	\N	3	1	\N	0
938	Макао	100.00	18.00	\N	4	2017-11-29 10:48:40	2017-11-29 10:48:40	2017-12-01 00:00:00	\N	3	1	\N	0
939	Македония	100.00	18.00	\N	4	2017-11-29 10:48:56	2017-11-29 10:48:56	2017-12-01 00:00:00	\N	3	1	\N	0
940	Малави	100.00	18.00	\N	4	2017-11-29 10:49:08	2017-11-29 10:49:08	2017-12-01 00:00:00	\N	3	1	\N	0
839	Крым	100.00	18.00	2014-04-25 15:00:41	2	2014-04-25 15:00:28	2014-04-25 15:00:41	2014-04-25 15:00:28	\N	1	1	\N	0
840	123	30.00	18.00	2014-05-13 15:41:30	1	2014-05-13 15:39:21	2014-05-13 15:41:30	2014-05-13 15:39:21	\N	2	1	\N	0
941	Малайзия	100.00	18.00	\N	4	2017-11-29 10:49:24	2017-11-29 10:49:24	2017-12-01 00:00:00	\N	3	1	\N	0
942	Мали	100.00	18.00	\N	4	2017-11-29 10:49:32	2017-11-29 10:49:32	2017-12-01 00:00:00	\N	3	1	\N	0
943	Мальдивы	100.00	18.00	\N	4	2017-11-29 10:49:49	2017-11-29 10:49:49	2017-11-01 00:00:00	\N	3	1	\N	0
944	Мальта	100.00	18.00	\N	4	2017-11-29 10:49:59	2017-11-29 10:49:59	2017-12-01 00:00:00	\N	3	1	\N	0
945	марианские о-ва	100.00	18.00	\N	4	2017-11-29 10:50:21	2017-11-29 10:50:21	2017-12-01 00:00:00	\N	3	1	\N	0
946	Марокко	100.00	18.00	\N	4	2017-11-29 10:50:35	2017-11-29 10:50:35	2017-12-01 00:00:00	\N	3	1	\N	0
947	Мартининка	100.00	18.00	\N	4	2017-11-29 10:50:56	2017-11-29 10:50:56	2017-12-01 00:00:00	\N	3	1	\N	0
948	Мексика	100.00	18.00	\N	4	2017-11-29 10:51:20	2017-11-29 10:51:20	2017-12-01 00:00:00	\N	3	1	\N	0
949	Микронейзия	100.00	18.00	\N	4	2017-11-29 10:51:39	2017-11-29 10:51:39	2017-12-01 00:00:00	\N	3	1	\N	0
950	Мозамбик	100.00	18.00	\N	4	2017-11-29 10:51:54	2017-11-29 10:51:54	2017-12-01 00:00:00	\N	3	1	\N	0
951	Монако	100.00	18.00	\N	4	2017-11-29 10:52:04	2017-11-29 10:52:04	2017-12-01 00:00:00	\N	3	1	\N	0
952	Монтсеррат	100.00	18.00	\N	4	2017-11-29 10:52:29	2017-11-29 10:52:29	2017-12-01 00:00:00	\N	3	1	\N	0
953	Мьянма	100.00	18.00	\N	4	2017-11-29 10:52:46	2017-11-29 10:52:46	2017-12-01 00:00:00	\N	3	1	\N	0
954	Намибия	100.00	18.00	\N	4	2017-11-29 10:53:00	2017-11-29 10:53:00	2017-12-01 00:00:00	\N	3	1	\N	0
955	Науру	100.00	18.00	\N	4	2017-11-29 10:53:10	2017-11-29 10:53:10	2017-12-01 00:00:00	\N	3	1	\N	0
956	Непал	100.00	18.00	\N	4	2017-11-29 10:53:29	2017-11-29 10:53:29	2017-12-01 00:00:00	\N	3	1	\N	0
957	Нигер	100.00	18.00	\N	4	2017-11-29 10:53:41	2017-11-29 10:53:41	2017-12-01 00:00:00	\N	3	1	\N	0
958	Нидерланды	100.00	18.00	\N	4	2017-11-29 10:54:04	2017-11-29 10:54:04	2017-12-01 00:00:00	\N	3	1	\N	0
959	Никарагуа	100.00	18.00	\N	4	2017-11-29 10:54:16	2017-11-29 10:54:16	2017-12-01 00:00:00	\N	3	1	\N	0
960	Новая Зеландия	100.00	18.00	\N	4	2017-11-29 10:54:34	2017-11-29 10:54:34	2017-12-01 00:00:00	\N	3	1	\N	0
961	Норвегия	100.00	18.00	\N	4	2017-11-29 10:54:45	2017-11-29 10:54:45	2017-12-01 00:00:00	\N	3	1	\N	0
962	Объединенные Арабские Эмираты	100.00	18.00	\N	4	2017-11-29 10:55:25	2017-11-29 10:55:25	2017-12-01 00:00:00	\N	3	1	\N	0
963	Оман	100.00	18.00	\N	4	2017-11-29 10:55:37	2017-11-29 10:55:37	2017-12-01 00:00:00	\N	3	1	\N	0
964	Пакистан	100.00	18.00	\N	4	2017-11-29 10:55:53	2017-11-29 10:55:53	2017-12-01 00:00:00	\N	3	1	\N	0
965	Панама	100.00	18.00	\N	4	2017-11-29 10:56:08	2017-11-29 10:56:08	2017-12-01 00:00:00	\N	3	1	\N	0
966	Папуа-Новая Гвинея	100.00	18.00	\N	4	2017-11-29 10:56:40	2017-11-29 10:56:40	2017-12-01 00:00:00	\N	3	1	\N	0
967	Парагвай	100.00	18.00	\N	4	2017-11-29 10:56:53	2017-11-29 10:56:53	2017-12-01 00:00:00	\N	3	1	\N	0
968	Перу	100.00	18.00	\N	4	2017-11-29 10:57:02	2017-11-29 10:57:02	2017-12-01 00:00:00	\N	3	1	\N	0
969	Полинезия французская	100.00	18.00	\N	4	2017-11-29 10:57:27	2017-11-29 10:57:27	2017-12-01 00:00:00	\N	3	1	\N	0
970	Польша	100.00	18.00	\N	4	2017-11-29 10:57:47	2017-11-29 10:57:47	2017-12-01 00:00:00	\N	3	1	\N	0
971	Португалия	100.00	18.00	\N	4	2017-11-29 10:58:00	2017-11-29 10:58:00	2017-12-01 00:00:00	\N	3	1	\N	0
972	Пуэрто-Рико	100.00	18.00	\N	4	2017-11-29 10:58:26	2017-11-29 10:58:26	2017-12-01 00:00:00	\N	3	1	\N	0
973	Реюньон	100.00	18.00	\N	4	2017-11-29 10:58:46	2017-11-29 10:58:46	2017-12-01 00:00:00	\N	3	1	\N	0
974	Руанда	100.00	18.00	\N	4	2017-11-29 10:59:03	2017-11-29 10:59:03	2017-12-01 00:00:00	\N	3	1	\N	0
975	Румыния	100.00	18.00	\N	4	2017-11-29 10:59:15	2017-11-29 10:59:15	2017-12-01 00:00:00	\N	3	1	\N	0
976	Сан-Томе и Принсипи	100.00	18.00	\N	4	2017-11-29 10:59:45	2017-11-29 10:59:45	2017-12-01 00:00:00	\N	3	1	\N	0
977	Саудовская Аравия	100.00	18.00	\N	4	2017-11-29 11:00:05	2017-11-29 11:00:05	2017-12-01 00:00:00	\N	3	1	\N	0
978	Свазиленд	100.00	18.00	\N	4	2017-11-29 11:00:22	2017-11-29 11:00:22	2017-12-01 00:00:00	\N	3	1	\N	0
979	Святой Елены о-в	100.00	18.00	\N	4	2017-11-29 11:00:43	2017-11-29 11:00:43	2017-12-01 00:00:00	\N	3	1	\N	0
980	Сейшельские о-ва	100.00	18.00	\N	4	2017-11-29 11:01:05	2017-11-29 11:01:05	2017-12-01 00:00:00	\N	3	1	\N	0
981	Сенегал	100.00	18.00	\N	4	2017-11-29 11:01:23	2017-11-29 11:01:23	2017-12-01 00:00:00	\N	3	1	\N	0
982	Сент-Винсент и Гренадины	100.00	18.00	\N	4	2017-11-29 11:01:50	2017-11-29 11:01:50	2017-12-01 00:00:00	\N	3	1	\N	0
983	Сент-Люсия	100.00	18.00	\N	4	2017-11-29 11:02:14	2017-11-29 11:02:14	2017-12-01 00:00:00	\N	3	1	\N	0
984	Сингапур	100.00	18.00	\N	4	2017-11-29 11:02:32	2017-11-29 11:02:32	2017-12-01 00:00:00	\N	3	1	\N	0
985	Сирия	100.00	18.00	\N	4	2017-11-29 11:02:42	2017-11-29 11:02:42	2017-12-01 00:00:00	\N	3	1	\N	0
986	Словения	100.00	18.00	\N	4	2017-11-29 11:02:59	2017-11-29 11:02:59	2017-12-01 00:00:00	\N	3	1	\N	0
987	Сомали	100.00	18.00	\N	4	2017-11-29 11:03:08	2017-11-29 11:03:08	2017-12-01 00:00:00	\N	3	1	\N	0
988	Судан	100.00	18.00	\N	4	2017-11-29 11:03:18	2017-11-29 11:03:18	2017-12-01 00:00:00	\N	3	1	\N	0
989	Суринам	100.00	18.00	\N	4	2017-11-29 11:03:37	2017-11-29 11:03:37	2017-12-01 00:00:00	\N	3	1	\N	0
990	Соединенные Штаты Америки	100.00	18.00	\N	4	2017-11-29 11:04:00	2017-11-29 11:04:00	2017-12-01 00:00:00	\N	3	1	\N	0
991	Соломоновы о-ва	100.00	18.00	\N	4	2017-11-29 11:04:23	2017-11-29 11:04:23	2017-12-01 00:00:00	\N	3	1	\N	0
992	Сьерра-Леона	100.00	18.00	\N	4	2017-11-29 11:04:46	2017-11-29 11:04:46	2017-12-01 00:00:00	\N	3	1	\N	0
993	Таиланд	100.00	18.00	\N	4	2017-11-29 11:05:03	2017-11-29 11:05:03	2017-12-01 00:00:00	\N	3	1	\N	0
994	Танзания	100.00	18.00	\N	4	2017-11-29 11:05:26	2017-11-29 11:05:26	2017-12-01 00:00:00	\N	3	1	\N	0
995	Теркс и Кайкос о-ва	100.00	18.00	\N	4	2017-11-29 11:05:50	2017-11-29 11:05:50	2017-12-01 00:00:00	\N	3	1	\N	0
996	Тимор	100.00	18.00	\N	4	2017-11-29 11:06:06	2017-11-29 11:06:06	2017-12-01 00:00:00	\N	3	1	\N	0
997	Того	100.00	18.00	\N	4	2017-11-29 11:06:16	2017-11-29 11:06:16	2017-12-01 00:00:00	\N	3	1	\N	0
998	Тринилат и Тобаго	100.00	18.00	\N	4	2017-11-29 11:06:38	2017-11-29 11:06:38	2017-12-01 00:00:00	\N	3	1	\N	0
999	Тувалу	100.00	18.00	\N	4	2017-11-29 11:06:55	2017-11-29 11:06:55	2017-12-01 00:00:00	\N	3	1	\N	0
1000	Тунис	100.00	18.00	\N	4	2017-11-29 11:07:06	2017-11-29 11:07:06	2017-12-01 00:00:00	\N	3	1	\N	0
1001	Турция	100.00	18.00	\N	4	2017-11-29 11:07:15	2017-11-29 11:07:15	2017-12-01 00:00:00	\N	3	1	\N	0
1002	Уругвай	100.00	18.00	\N	4	2017-11-29 11:07:32	2017-11-29 11:07:32	2017-12-01 00:00:00	\N	3	1	\N	0
1003	Филиппины	100.00	18.00	\N	4	2017-11-29 11:08:23	2017-11-29 11:08:23	2017-12-01 00:00:00	\N	3	1	\N	0
1004	Финляндия	100.00	18.00	\N	4	2017-11-29 11:08:46	2017-11-29 11:08:46	2017-12-01 00:00:00	\N	3	1	\N	0
1005	Фолклендские (мальвинские) о-ва	100.00	18.00	\N	4	2017-11-29 11:09:14	2017-11-29 11:09:14	2017-12-01 00:00:00	\N	3	1	\N	0
1006	Франция	100.00	18.00	\N	4	2017-11-29 11:09:31	2017-11-29 11:09:31	2017-12-01 00:00:00	\N	3	1	\N	0
1007	Хорватия	100.00	18.00	\N	4	2017-11-29 11:09:47	2017-11-29 11:09:47	2017-12-01 00:00:00	\N	3	1	\N	0
1008	Чад	100.00	18.00	\N	4	2017-11-29 11:09:57	2017-11-29 11:09:57	2017-12-01 00:00:00	\N	3	1	\N	0
1009	Черногория	100.00	18.00	\N	4	2017-11-29 11:10:08	2017-11-29 11:10:08	2017-12-01 00:00:00	\N	3	1	\N	0
1010	Чехия	100.00	18.00	\N	4	2017-11-29 11:10:27	2017-11-29 11:10:27	2017-12-01 00:00:00	\N	3	1	\N	0
1011	Швейцария	100.00	18.00	\N	4	2017-11-29 11:10:49	2017-11-29 11:10:49	2017-12-01 00:00:00	\N	3	1	\N	0
1012	Швеция	100.00	18.00	\N	4	2017-11-29 11:11:00	2017-11-29 11:11:00	2017-12-01 00:00:00	\N	3	1	\N	0
1013	Шри Ланка	100.00	18.00	\N	4	2017-11-29 11:11:16	2017-11-29 11:11:16	2017-12-01 00:00:00	\N	3	1	\N	0
1014	Эквадор	100.00	18.00	\N	4	2017-11-29 11:11:36	2017-11-29 11:11:36	2017-12-01 00:00:00	\N	3	1	\N	0
1015	Экваториальная Гвинея	100.00	18.00	\N	4	2017-11-29 11:11:53	2017-11-29 11:11:53	2017-12-01 00:00:00	\N	3	1	\N	0
1016	Эритрея	100.00	18.00	\N	4	2017-11-29 11:12:09	2017-11-29 11:12:09	2017-12-01 00:00:00	\N	3	1	\N	0
1017	Южно-Африканская Республика	100.00	18.00	\N	4	2017-11-29 11:12:35	2017-11-29 11:12:35	2017-12-01 00:00:00	\N	3	1	\N	0
1018	Югославия	100.00	18.00	\N	4	2017-11-29 11:12:50	2017-11-29 11:12:50	2017-12-01 00:00:00	\N	3	1	\N	0
1019	Ямайка	100.00	18.00	\N	4	2017-11-29 11:13:00	2017-11-29 11:13:00	2017-12-01 00:00:00	\N	3	1	\N	0
1020	Япония	100.00	18.00	\N	4	2017-11-29 11:13:11	2017-11-29 11:13:11	2017-12-01 00:00:00	\N	3	1	\N	0
\.


--
-- Data for Name: bill_tlgkind; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.bill_tlgkind (tlgkind_id, name, required, p1, p2, p3, created, changed, closed, operator_id, start_label, end_label, f_serve, f_second, f_notification, f_printcopy, f_needrequest, f_needtg) FROM stdin;
3	Служ. запрос част	0	 	 	 	2014-03-27 18:34:20	2015-02-07 16:16:36	\N	134	\N	\N	0	0	1	0	1	0
4	Копия	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	1	0	0
5	Запрос-увед. пред	0	 	 	У	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	0	0	0
6	Люкс/И	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ЛЮКС/И	\N	0	0	0	0	0	0
7	А/Я	0	 	 	 	2014-03-27 18:34:20	2018-09-21 10:12:18	\N	134	\N	\N	0	1	0	0	0	0
8	Копия част	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	1	0	0
9	Срочная	1	С	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	СРОЧНАЯ	\N	0	1	0	0	0	0
10	Делюкс	0	 	 	 	2014-03-27 18:34:20	2020-12-10 12:51:42	\N	136	ДЕЛЮКС	\N	0	0	0	0	0	0
11	Увед. простое	0	 	 	У	2014-03-27 18:34:20	2019-11-26 18:46:01	\N	134	УВЕДОМЛЕНИЕ ТЕЛЕГРАФОМ	\N	0	1	0	0	0	0
12	Люкс/М	0	 	 	 	2014-03-27 18:34:20	2019-11-26 18:46:13	\N	134	ЛЮКС/М	\N	0	1	0	0	0	0
13	Почтой заказное	0	 	 	 	2014-03-27 18:34:20	2017-11-08 08:49:33	\N	134	ПОЧТОЙ ЗАКАЗНОЕ	\N	0	0	0	0	0	0
14	Заверенная	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ЗАВЕРЕННАЯ	\N	0	1	0	0	0	0
15	Запрос-увед. част	0	 	 	У	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	0	0	0
16	Люкс	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ЛЮКС	\N	0	0	0	0	0	0
17	Правительственная	1	С	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ПРАВИТЕЛЬСТВЕННАЯ	\N	0	1	0	0	0	0
18	Переговор	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	0	0	0	0
19	Вручить (дата)	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	1	0	0	0	0	0
20	Выборы	1	С	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ВЫБОРЫ	\N	0	1	0	0	0	0
21	Перевод	0	 	П	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	0	0	0	0
22	До востреб.	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	ДО ВОСТРЕБОВАНИЯ	0	1	0	0	0	0
23	Обыкновенная	1	П	 	 	2014-03-27 18:34:20	2023-04-07 10:41:59	\N	135	ПРИЕМ ЗАКРЫТ	ПРИЕМ ЗАКРЫТ	0	1	0	0	0	0
24	Люкс/В	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ЛЮКС/В	\N	0	0	0	0	0	0
25	ЛК/М/И	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	ЛЮКС/М/И	\N	0	0	0	0	0	0
26	Копия пред	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	1	0	0
27	Служ. запрос пред	0	 	 	 	2014-03-27 18:34:20	2014-03-27 18:34:20	\N	\N	\N	\N	0	0	1	0	1	0
28	Увед. срочное	0	 	 	У	2014-03-27 18:34:20	2019-11-26 18:37:21	2019-11-26 18:37:21	134	УВЕДОМЛЕНИЕ ТЕЛЕГРАФОМ СРОЧНОЕ 	\N	0	0	1	0	0	0
\.


--
-- Data for Name: err_sys_messages; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.err_sys_messages (sys_message_id, sys_message, terminal) FROM stdin;
\.


--
-- Data for Name: flyway_schema_history; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.flyway_schema_history (installed_rank, version, description, type, script, checksum, installed_by, installed_on, execution_time, success) FROM stdin;
1	1	<< Flyway Baseline >>	BASELINE	<< Flyway Baseline >>	\N	null	2024-10-28 17:00:01.96752	0	t
2	2	msg call sequence	SQL	V2__msg_call_sequence.sql	1004286835	coretlx	2024-10-28 17:00:02.046507	25	t
3	3	bill service sequence	SQL	V3__bill_service_sequence.sql	1895410005	coretlx	2024-10-28 17:00:02.100429	19	t
4	4	acc operator sequence	SQL	V4__acc_operator_sequence.sql	-1715539751	coretlx	2024-10-28 17:00:02.147312	28	t
5	5	add tele message constr	SQL	V5__add_tele_message_constr.sql	-85250473	coretlx	2024-10-29 15:40:24.044714	1416	t
6	6	delete unrelated states	SQL	V6__delete_unrelated_states.sql	-711054529	coretlx	2024-10-29 15:44:16.091716	3162	t
7	7	add state message constraint	SQL	V7__add_state_message_constraint.sql	332749541	coretlx	2024-10-29 15:44:21.22541	1257	t
8	8	add state voc constraint	SQL	V8__add_state_voc_constraint.sql	-2130023763	coretlx	2024-10-29 15:44:24.416607	1174	t
9	9	acc operator fk	SQL	V9__acc_operator_fk.sql	-1018086034	coretlx	2024-10-29 16:05:34.099149	884	t
10	10	role id smallint	SQL	V10__role_id_smallint.sql	-61013791	coretlx	2025-04-26 19:55:00.101411	230	t
\.


--
-- Data for Name: imp_tlindex_russia; Type: TABLE DATA; Schema: coretlx; Owner: coretlx
--

COPY coretlx.imp_tlindex_russia (province_name, main_town, time_diff, town_name, note, region_name, attr, tlindex, has_telex, work_days, holydays, li_number, chaned, country_id, province_id, town_id) FROM stdin;
Архангельская область	Архангельск	0	Большая	\N	Красноборского	\N	242508	\N	09-12	Пн, Ср, Пт, Вс	\N	\N	\N	6	5493
Архангельская область	Архангельск	0	Большая Слудка	\N	Красноборского	\N	242508	\N	09-13	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5495
Архангельская область	Архангельск	0	Верхнее Шилово	\N	Красноборского	\N	242508	\N	09-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5515
Архангельская область	Архангельск	0	Верхняя Сергеевская	\N	Красноборского	\N	242508	\N	09-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5519
Архангельская область	Архангельск	0	Верхняя Уфтюга	\N	Красноборского	\N	242508	\N	09-13	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5520
Архангельская область	Архангельск	0	Дябрино	\N	Красноборского	\N	242508	\N	07-11	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5556
Архангельская область	Архангельск	0	Комарово	\N	Красноборского	\N	242508	\N	07-11	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5603
Архангельская область	Архангельск	0	Комсомольский	\N	Красноборского	\N	242508	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5604
Архангельская область	Архангельск	0	Красноборск	\N	Красноборского	\N	242508	ТГ	08.30-17 Пт 08.30-16.30	Сб, Вс	\N	\N	\N	6	137
Архангельская область	Архангельск	0	Куликово	\N	Красноборского	\N	242508	\N	07-12	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5620
Архангельская область	Архангельск	0	Ляховская	\N	Красноборского	\N	242508	\N	09-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5652
Архангельская область	Архангельск	0	Монастырская Пашня	\N	Красноборского	\N	242508	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5664
Архангельская область	Архангельск	0	Савинская	\N	Красноборского	\N	242508	\N	09-13	Пн, Ср, Чт, Пт, Вс	\N	\N	\N	6	5751
Архангельская область	Архангельск	0	Санаторий Евда	\N	Красноборского	\N	242508	\N	07-11	Вт, Чт, Сб, Вс	\N	\N	\N	6	5758
Архангельская область	Архангельск	0	Черевково	\N	Красноборского	\N	242508	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5872
Архангельская область	Архангельск	0	Запань Яреньга	\N	Ленского	\N	242588	\N	09-11	Вт, Чт, Сб, Вс	\N	\N	\N	6	5565
Архангельская область	Архангельск	0	Ирта	\N	Ленского	\N	242588	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5578
Архангельская область	Архангельск	0	Козьмино	\N	Ленского	\N	242588	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5598
Архангельская область	Архангельск	0	Литвино	\N	Ленского	\N	242588	\N	07-12	Вт, Чт, Сб, Вс	\N	\N	\N	6	5641
Архангельская область	Архангельск	0	Лысимо	\N	Ленского	\N	242588	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5650
Архангельская область	Архангельск	0	Ошлапье	\N	Ленского	\N	242588	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5691
Архангельская область	Архангельск	0	Сойга	\N	Ленского	\N	242588	\N	07-14	Вт, Чт, Сб, Вс	\N	\N	\N	6	5778
Архангельская область	Архангельск	0	Урдома	\N	Ленского	\N	242588	\N	10-18	Вс	\N	\N	\N	6	171
Архангельская область	Архангельск	0	Усть-Очея	\N	Ленского	\N	242588	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5851
Архангельская область	Архангельск	0	Яренск	\N	Ленского	\N	242588	ТГ	09-16 Пт 09-14	Сб, Вс	\N	\N	\N	6	182
Архангельская область	Архангельск	0	Белощелье	\N	Лешуконского	\N	242505	\N	09-14	Пт, Сб, Вс	\N	\N	\N	6	5485
Архангельская область	Архангельск	0	Березник	\N	Лешуконского	\N	242505	\N	09-12	Сб, Вс, Пн	\N	\N	\N	6	5487
Архангельская область	Архангельск	0	Большая Нисогора	\N	Лешуконского	\N	242505	\N	09-14	Вт, Ср, Пт, Сб, Вс	\N	\N	\N	6	5461
Архангельская область	Архангельск	0	Вожгора	\N	Лешуконского	\N	242505	\N	09-17	Сб, Вс	\N	\N	\N	6	5525
Архангельская область	Архангельск	0	Засульё	\N	Лешуконского	\N	242505	\N	09-14	Сб, Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Зубово	\N	Лешуконского	\N	242505	\N	10-15	Сб, Вс	\N	\N	\N	6	5572
Архангельская область	Архангельск	0	Кеба	\N	Лешуконского	\N	242505	\N	10-15	Сб, Вс	\N	\N	\N	6	5589
Архангельская область	Архангельск	0	Койнас	\N	Лешуконского	\N	242505	\N	09-17	Сб, Вс	\N	\N	\N	6	5601
Архангельская область	Архангельск	0	Лешуконское	\N	Лешуконского	\N	242505	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	139
Архангельская область	Архангельск	0	Олема	\N	Лешуконского	\N	242505	\N	10-15	Сб, Вс	\N	\N	\N	6	5684
Архангельская область	Архангельск	0	Палащелье	\N	Лешуконского	\N	242505	\N	10-14	Вт, Ср, Пт, Сб, Вс	\N	\N	\N	6	5695
Архангельская область	Архангельск	0	Палуга	\N	Лешуконского	\N	242505	\N	10-14	Сб, Вс, Пн	\N	\N	\N	6	5698
Архангельская область	Архангельск	0	Пылема	\N	Лешуконского	\N	242505	\N	08-11	Пт, Сб, Вс	\N	\N	\N	6	5737
Архангельская область	Архангельск	0	Родома	\N	Лешуконского	\N	242505	\N	11-14	Сб, Вс, Пн	\N	\N	\N	6	5745
Архангельская область	Архангельск	0	Селище	\N	Лешуконского	\N	242505	\N	09-12	Пт, Сб, Вс	\N	\N	\N	6	5765
Архангельская область	Архангельск	0	Усть-Кыма	\N	Лешуконского	\N	242505	\N	09-14	Сб, Вс	\N	\N	\N	6	5850
Архангельская область	Архангельск	0	Усть-Чуласа	\N	Лешуконского	\N	242505	\N	09-14	Сб, Вс	\N	\N	\N	6	16276
Архангельская область	Архангельск	0	Ценогора	\N	Лешуконского	\N	242505	\N	09-17	Сб, Вс	\N	\N	\N	6	16280
Архангельская область	Архангельск	0	Чуласа	\N	Лешуконского	\N	242505	\N	09-13	Сб, Вс	\N	\N	\N	6	5875
Архангельская область	Архангельск	0	Юрома	\N	Лешуконского	\N	242505	\N	Вт, Ср 09-17 Пн 09-14	Сб, Вс	\N	\N	\N	6	5894
Архангельская область	Архангельск	0	Азаполье	\N	Мезенского	\N	242591	\N	10-13	Ср, Сб, Вс	\N	\N	\N	6	5468
Архангельская область	Архангельск	0	Бычье	\N	Мезенского	\N	242591	\N	10-14	Сб, Вс	\N	\N	\N	6	5504
Архангельская область	Архангельск	0	Долгощелье	\N	Мезенского	\N	242591	\N	09-16	Сб, Вс	\N	\N	\N	6	5551
Архангельская область	Архангельск	0	Дорогорское	\N	Мезенского	\N	242591	\N	09-16	Сб, Вс	\N	\N	\N	6	5553
Архангельская область	Архангельск	0	Жердь	\N	Мезенского	\N	242591	\N	09-13	Ср, Сб, Вс	\N	\N	\N	6	5563
Архангельская область	Архангельск	0	Заакакурье	\N	Мезенского	\N	242591	\N	09-13	Ср, Сб, Вс	\N	\N	\N	6	5564
Архангельская область	Архангельск	0	Каменка	\N	Мезенского	\N	242591	\N	10-17	Вс	\N	\N	\N	6	125
Архангельская область	Архангельск	0	Козьмогородское	\N	Мезенского	\N	242591	\N	09-13	Сб, Вс	\N	\N	\N	6	5599
Архангельская область	Архангельск	0	Койда	\N	Мезенского	\N	242591	\N	09-17	Сб, Вс	\N	\N	\N	6	5600
Архангельская область	Архангельск	0	Лампожня	\N	Мезенского	\N	242591	\N	09-12	Ср, Сб, Вс	\N	\N	\N	6	5630
Архангельская область	Архангельск	0	Мезень	\N	Мезенского	\N	242591	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	143
Архангельская область	Архангельск	0	Мезень-1	\N	Мезенского	\N	242591	\N	09-15	Сб, Вс	\N	\N	\N	6	5408
Архангельская область	Архангельск	0	Мосеево	\N	Мезенского	\N	242591	\N	10-14	Пт, Сб, Вс	\N	\N	\N	6	5667
Архангельская область	Архангельск	0	Ручьи	\N	Мезенского	\N	242591	\N	09-14	Сб, Вс	\N	\N	\N	6	5748
Архангельская область	Архангельск	0	Сафоново	\N	Мезенского	\N	242591	\N	10-14	Пт, Сб, Вс	\N	\N	\N	6	5762
Архангельская область	Архангельск	0	Совполье	\N	Мезенского	\N	242591	\N	09-12	Чт, Сб, Вс	\N	\N	\N	6	5776
Архангельская область	Архангельск	0	Сояна	\N	Мезенского	\N	242591	\N	09-15	Сб, Вс	\N	\N	\N	6	5790
Архангельская область	Архангельск	0	Целегора	\N	Мезенского	\N	242591	\N	10-14	Сб, Вс	\N	\N	\N	6	5867
Архангельская область	Архангельск	0	Мирный	\N	\N	\N	242551	ТГ	09-17 Пт 08-16	Сб, Вс	\N	\N	\N	6	144
Архангельская область	Архангельск	0	Новодвинск	\N	\N	г	242562	\N	08-20 Сб 09-18	Вс	ЛИ-7037-17	12.07.2017	\N	6	147
Архангельская область	Архангельск	0	Андреевская	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5476
Архангельская область	Архангельск	0	Большой Двор	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5497
Архангельская область	Архангельск	0	Ивакша	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5573
Архангельская область	Архангельск	0	Каргополь-2	\N	Няндомского	\N	242581	\N	09-20	Вс	ЛИ-8592-17	21.08.2017	\N	6	\N
Архангельская область	Архангельск	0	Курниково	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5623
Архангельская область	Архангельск	0	Лельма	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5634
Архангельская область	Архангельск	0	Лепша	\N	Няндомского	\N	242581	\N	07-14 16-20	Вс, Пн	\N	\N	\N	6	5636
Архангельская область	Архангельск	0	Макаровская	\N	Няндомского	\N	242581	\N	09-17	Вс	\N	\N	\N	6	141
Архангельская область	Архангельск	0	Няндома	\N	Няндомского	\N	242581	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	148
Архангельская область	Архангельск	0	Няндома-3	\N	Няндомского	\N	242581	\N	09-20	Вс	\N	\N	\N	6	5398
Архангельская область	Архангельск	0	Пустарево	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5733
Архангельская область	Архангельск	0	Ступинская	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	16269
Архангельская область	Архангельск	0	Федосеевская	\N	Няндомского	\N	242581	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5858
Архангельская область	Архангельск	0	Шалакуша	\N	Няндомского	\N	242581	\N	10-17	Вс	\N	\N	\N	6	178
Архангельская область	Архангельск	0	Абрамовское	\N	Онежского	\N	242501	\N	13-16	Вс	\N	\N	\N	6	1889
Архангельская область	Архангельск	0	Анциферовский Бор	\N	Онежского	\N	242501	\N	09-16	Вс	\N	\N	\N	6	5478
Архангельская область	Архангельск	0	Большой Бор	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5496
Алтайский край	Барнаул	+4	Бурла	\N	Бурлинского	ц	233527	ТГ	09-17	Сб, Вс	\N	\N	\N	4	885
Архангельская область	Архангельск	0	Верхнеозерск	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5516
Архангельская область	Архангельск	0	Глазаниха	\N	Онежского	\N	242501	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5539
Архангельская область	Архангельск	0	Золотуха	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5571
Архангельская область	Архангельск	0	Каска	\N	Онежского	\N	242501	\N	09-13 14-16	Вс	\N	\N	\N	6	5586
Архангельская область	Архангельск	0	Клещево	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5592
Архангельская область	Архангельск	0	Ковкула	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5595
Архангельская область	Архангельск	0	Кодино	\N	Онежского	\N	242501	\N	10-17	Вс	\N	\N	\N	6	130
Архангельская область	Архангельск	0	Кодино-1	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5420
Архангельская область	Архангельск	0	Куша	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5624
Архангельская область	Архангельск	0	Кянда	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5625
Архангельская область	Архангельск	0	Лямца	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5651
Архангельская область	Архангельск	0	Маложма	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5655
Архангельская область	Архангельск	0	Малошуйка	\N	Онежского	\N	242501	\N	10-18	Вс	\N	\N	\N	6	142
Архангельская область	Архангельск	0	Мудьюга	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5668
Архангельская область	Архангельск	0	Нименьга	\N	Онежского	\N	242501	\N	10-13.30	Сб, Вс	\N	\N	\N	6	146
Архангельская область	Архангельск	0	Онега	\N	Онежского	\N	242501	ТГ	10-18	Сб, Вс	\N	\N	\N	6	152
Архангельская область	Архангельск	0	Онега-3	\N	Онежского	\N	242501	\N	09-20	Пн, Вс	\N	\N	\N	6	16257
Архангельская область	Архангельск	0	Онега-4	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	16258
Архангельская область	Архангельск	0	Покровское	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5719
Архангельская область	Архангельск	0	Порог	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5723
Архангельская область	Архангельск	0	Посад	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5725
Архангельская область	Архангельск	0	Прилуки	\N	Онежского	\N	242501	\N	11-14	Вс	\N	\N	\N	6	5729
Архангельская область	Архангельск	0	Прошково	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5730
Архангельская область	Архангельск	0	Пурнема	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5732
Архангельская область	Архангельск	0	Тамица	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5800
Архангельская область	Архангельск	0	Унежма	\N	Онежского	\N	242501	\N	09-15	Вс, Пн	\N	\N	\N	6	16274
Архангельская область	Архангельск	0	Усть-Кожа	\N	Онежского	\N	242501	\N	10-17	Вс	\N	\N	\N	6	5849
Архангельская область	Архангельск	0	Хачела	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	16278
Архангельская область	Архангельск	0	Шаста	\N	Онежского	\N	242501	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5877
Архангельская область	Архангельск	0	Шомокша	\N	Онежского	\N	242501	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5891
Архангельская область	Архангельск	0	Ваймуша	\N	Пинежского	\N	242578	\N	10-15	Вс, Пн	\N	\N	\N	6	5494
Архангельская область	Архангельск	0	Веегора	\N	Пинежского	\N	242578	\N	13-15	Сб, Вс	\N	\N	\N	6	5508
Архангельская область	Архангельск	0	Веркола	\N	Пинежского	\N	242578	\N	10-15	Вс, Пн	\N	\N	\N	6	5436
Архангельская область	Архангельск	0	Вонга	\N	Пинежского	\N	242578	\N	09-12	Сб, Вс	\N	\N	\N	6	5434
Архангельская область	Архангельск	0	Городецк	\N	Пинежского	\N	242578	\N	13-17	Сб, Вс	\N	\N	\N	6	5431
Архангельская область	Архангельск	0	Еркино	\N	Пинежского	\N	242578	\N	10-15	Вс, Пн	\N	\N	\N	6	5428
Архангельская область	Архангельск	0	Карпогоры	\N	Пинежского	\N	242578	ТГ	09-17 Пт 09-15	Сб, Вс	\N	\N	\N	6	127
Архангельская область	Архангельск	0	Кеврола	\N	Пинежского	\N	242578	\N	10-14	Вс, Пн	\N	\N	\N	6	5422
Архангельская область	Архангельск	0	Кобелево	\N	Пинежского	\N	242578	\N	10-14	Вс, Пн	\N	\N	\N	6	5594
Архангельская область	Архангельск	0	Кривые Озера	\N	Пинежского	\N	242578	\N	14-17	Сб, Вс	ЛИ-8852-17	22.08.2017	\N	6	\N
Архангельская область	Архангельск	0	Кулосега	\N	Пинежского	\N	242578	\N	13-17	Сб, Вс	\N	\N	\N	6	5622
Архангельская область	Архангельск	0	Кушкопола	\N	Пинежского	\N	242578	\N	09-15	Вс, Пн	\N	\N	\N	6	5411
Архангельская область	Архангельск	0	Лавела	\N	Пинежского	\N	242578	\N	12-15	Сб, Вс	\N	\N	\N	6	5409
Архангельская область	Архангельск	0	Матвера	\N	Пинежского	\N	242578	\N	10-13	Сб, Вс	\N	\N	\N	6	5649
Архангельская область	Архангельск	0	Междуреченский	\N	Пинежского	\N	242578	\N	10-18	Сб, Вс	\N	\N	\N	6	5658
Архангельская область	Архангельск	0	Ново-Лавела	\N	Пинежского	\N	242578	\N	10-18	Сб, Вс	\N	\N	\N	6	5403
Архангельская область	Архангельск	0	Нюхча	\N	Пинежского	\N	242578	\N	09-13	Сб, Вс	\N	\N	\N	6	5399
Архангельская область	Архангельск	0	Пачиха	\N	Пинежского	\N	242578	\N	13-16	Сб, Вс	\N	\N	\N	6	5705
Архангельская область	Архангельск	0	Петрово	\N	Пинежского	\N	242578	\N	10-13	Вс, Пн	\N	\N	\N	6	16260
Архангельская область	Архангельск	0	Пинега	\N	Пинежского	\N	242578	\N	09-17 Сб 10-16	Вс	\N	\N	\N	6	154
Архангельская область	Архангельск	0	Пиринемь	\N	Пинежского	\N	242578	\N	11.30-16	Сб, Вс	\N	\N	\N	6	5713
Архангельская область	Архангельск	0	Русковера	\N	Пинежского	\N	242578	\N	11-18	Вс, Пн	\N	\N	\N	6	16266
Архангельская область	Архангельск	0	Сия	\N	Пинежского	\N	242578	\N	09-17	Вс, Пн	\N	\N	\N	6	5771
Архангельская область	Архангельск	0	Сосновка	\N	Пинежского	\N	242578	\N	09-17	Сб, Вс	\N	\N	\N	6	5787
Архангельская область	Архангельск	0	Сояла	\N	Пинежского	\N	242578	\N	10-13	Вс, Пн	\N	\N	\N	6	16268
Архангельская область	Архангельск	0	Сульца	\N	Пинежского	\N	242578	\N	Вт, Пт 13-16 Пн, Чт 13-18	Ср, Сб, Вс	\N	\N	\N	6	5797
Архангельская область	Архангельск	0	Сура	\N	Пинежского	\N	242578	\N	10-16	Сб, Вс	\N	\N	\N	6	168
Архангельская область	Архангельск	0	Сылога	\N	Пинежского	\N	242578	\N	11-16	Вс, Пн	\N	\N	\N	6	5798
Архангельская область	Архангельск	0	Тайга	\N	Пинежского	\N	242578	\N	12-15	Сб, Вс	\N	\N	\N	6	16270
Архангельская область	Архангельск	0	Труфанова	\N	Пинежского	\N	242578	\N	12-14	Сб, Вс	\N	\N	\N	6	16272
Архангельская область	Архангельск	0	Чакола	\N	Пинежского	\N	242578	\N	13-16	Сб, Вс	\N	\N	\N	6	5870
Архангельская область	Архангельск	0	Шардонемь	\N	Пинежского	\N	242578	\N	10-14	Вс, Пн	\N	\N	\N	6	16281
Архангельская область	Архангельск	0	Широкое	\N	Пинежского	\N	242578	\N	14-18	Сб, Вс	\N	\N	\N	6	16284
Архангельская область	Архангельск	0	Шотова	\N	Пинежского	\N	242578	\N	11-15	Вс, Пн	\N	\N	\N	6	16286
Архангельская область	Архангельск	0	Шотогорка	\N	Пинежского	\N	242578	\N	11-15	Сб, Вс	\N	\N	\N	6	16287
Архангельская область	Архангельск	0	Шуйга	\N	Пинежского	\N	242578	\N	12-17	Сб, Вс	\N	\N	\N	6	16289
Архангельская область	Архангельск	0	Ясный	\N	Пинежского	\N	242578	\N	10-18	Вс, Пн	\N	\N	\N	6	16291
Архангельская область	Архангельск	0	Булатово	\N	Плесецкого	\N	242525	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5501
Архангельская область	Архангельск	0	Верховский	\N	Плесецкого	\N	242525	\N	09-17	Пн, Вс	\N	\N	\N	6	5521
Архангельская область	Архангельск	0	Вершинино	\N	Плесецкого	\N	242525	\N	10-17	Пн, Вс	\N	\N	\N	6	5523
Архангельская область	Архангельск	0	Вознесенская	\N	Плесецкого	\N	242525	\N	07-11 16-20	Пн, Чт, Сб, Вс	\N	\N	\N	6	5526
Архангельская область	Архангельск	0	Емца	\N	Плесецкого	\N	242525	\N	09-19	Вс	\N	\N	\N	6	5559
Архангельская область	Архангельск	0	Коковка	\N	Плесецкого	\N	242525	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5602
Архангельская область	Архангельск	0	Конево	\N	Плесецкого	\N	242525	\N	10-13	Вс	\N	\N	\N	6	133
Архангельская область	Архангельск	0	Корякино	\N	Плесецкого	\N	242525	\N	10-17	Пн, Чт, Сб, Вс	\N	\N	\N	6	5611
Архангельская область	Архангельск	0	Летнеозерский	\N	Плесецкого	\N	242525	\N	07-11 16-20	Вс	\N	\N	\N	6	5638
Архангельская область	Архангельск	0	Липаково	\N	Плесецкого	\N	242525	\N	09-16	Вс	\N	\N	\N	6	5640
Архангельская область	Архангельск	0	Ломовое	\N	Плесецкого	\N	242525	\N	07-19	Пн, Вс	\N	\N	\N	6	5644
Архангельская область	Архангельск	0	Лужма	\N	Плесецкого	\N	242525	\N	10-17	Вт, Сб, Вс	\N	\N	\N	6	5647
Архангельская область	Архангельск	0	Нижнее Устье	\N	Плесецкого	\N	242525	\N	07-19	Пн, Вс	\N	\N	\N	6	5674
Архангельская область	Архангельск	0	Обозерский	\N	Плесецкого	\N	242525	\N	10-16 Сб 10-14	Вс	\N	\N	\N	6	149
Алтайский край	Барнаул	+4	Алейск	\N	Алейского	ц	233521	ТГ	08-19 Сб, Вс 08-15	\N	\N	\N	\N	4	5309
Алтайский край	Барнаул	+4	Алтайское	\N	Алтайского	ц	233531	ТГ	08-18 Сб 09-13	Вс	ЛИ-301-16	30.12.1899	\N	4	5308
Алтайский край	Барнаул	+4	Баево	\N	Баевского	ц	233556	ТГ	09-17	Сб, Вс	\N	\N	\N	4	5262
Алтайский край	Барнаул	+4	Барнаул	\N	\N	\N	233ххх	ТГ	08-20	\N	\N	\N	\N	4	16085
Алтайский край	Барнаул	+4	Белокуриха	\N	\N	г	233536	ТГ	08-20	\N	\N	\N	\N	4	5261
Алтайский край	Барнаул	+4	Бийск	\N	Бийского	ц	233559	ТГ	08-20	\N	ЛИ-43-16	30.12.1899	\N	4	5256
Алтайский край	Барнаул	+4	Благовещенка	\N	Благовещенского	ц	233514	ТГ	08-18 Сб 09-14	Вс	\N	\N	\N	4	5253
Алтайский край	Барнаул	+4	Быстрый Исток	\N	Быстроистокского	ц	233509	ТГ	09-16	Сб, Вс	\N	\N	\N	4	15995
Алтайский край	Барнаул	+4	Волчиха	\N	Волчихинского	ц	233529	ТГ	08-18 Сб, Вс 09-17	\N	\N	\N	\N	4	73
Алтайский край	Барнаул	+4	Новоегорьевское	\N	Егорьевского	ц	233512	ТГ	09-17	Сб, Вс	ЛИ-2578-17	30.12.1899	\N	4	871
Алтайский край	Барнаул	+4	Ельцовка	\N	Ельцовского	ц	233510	ТГ	09-16	Сб, Вс	\N	\N	\N	4	4731
Алтайский край	Барнаул	+4	Завьялово	\N	Завьяловского	ц	233518	ТГ	09-17 Пт 09-16	Сб, Вс	\N	\N	\N	4	354
Алтайский край	Барнаул	+4	Залесово	\N	Залесовского	ц	233530	ТГ	09-16	Сб, Вс	ЛИ-4035-17	30.12.1899	\N	4	351
Алтайский край	Барнаул	+4	Заринск	\N	Заринского	ц	233525	ТГ	08-17 Пт 08-16	Сб, Вс	ЛИ-4003-17	30.12.1899	\N	4	7264
Алтайский край	Барнаул	+4	Змеиногорск	\N	Змеиногорского	ц	233523	ТГ	08-17	Сб, Вс	ЛИ-40-16	30.12.1899	\N	4	4169
Алтайский край	Барнаул	+4	Зональное	\N	Зонального	ц	233569	ТГ	09-17	Сб, Вс	\N	\N	\N	4	1225
Алтайский край	Барнаул	+4	Калманка	\N	Калманского	ц	233528	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1237
Алтайский край	Барнаул	+4	Камень-На-Оби	\N	Каменского	ц	233513	ТГ	08-20 Сб, Вс 08-18	\N	\N	\N	\N	4	282
Алтайский край	Барнаул	+4	Ключи	\N	Ключевского	ц	233537	ТГ	09-17 Сб 09-13	Вс	ЛИ-2577-17	30.12.1899	\N	4	280
Алтайский край	Барнаул	+4	Косиха	\N	Косихинского	ц	233517	ТГ	09-17	Сб, Вс	\N	\N	\N	4	278
Алтайский край	Барнаул	+4	Красногорское	\N	Красногорского	ц	233560	ТГ	09-16	Сб, Вс	\N	\N	\N	4	5139
Алтайский край	Барнаул	+4	Краснощеково	\N	Краснощёковского	ц	233538	ТГ	09-17	Сб, Вс	\N	\N	\N	4	\N
Алтайский край	Барнаул	+4	Крутиха	\N	Крутихинского	ц	233565	ТГ	09-16	Сб, Вс	ЛИ-4140-17	30.12.1899	\N	4	4927
Алтайский край	Барнаул	+4	Кулунда	\N	Кулундинского	ц	233532	ТГ	09-17 Сб 09-13	Вс	\N	\N	\N	4	4903
Алтайский край	Барнаул	+4	Курья	\N	Курьинского	ц	233539	ТГ	09-17	Сб, Вс	\N	\N	\N	4	4900
Алтайский край	Барнаул	+4	Кытманово	\N	Кытмановского	ц	233540	ТГ	09-17	Сб, Вс	\N	\N	\N	4	4875
Алтайский край	Барнаул	+4	Горняк	\N	Локтевского	ц	233541	ТГ	09-19 Сб 10-14	Вс	\N	\N	\N	4	70
Алтайский край	Барнаул	+4	Мамонтово	\N	Мамонтовского	ц	233545	ТГ	08-17 Сб 10-14	Вс	\N	\N	\N	4	899
Алтайский край	Барнаул	+4	Михайловское	\N	Михайловского	ц	233546	ТГ	08-18 Вс 10-13 Сб 09-13	\N	\N	\N	\N	4	882
Алтайский край	Барнаул	+4	Новичиха	\N	Новичихинского	ц	233520	ТГ	08-16	Сб, Вс	\N	\N	\N	4	881
Алтайский край	Барнаул	+4	Павловск	\N	Павловского	ц	233524	ТГ	08-18 Сб 09-15	Вс	\N	\N	\N	4	872
Алтайский край	Барнаул	+4	Панкрушиха	\N	Панкрушихинского	ц	233547	ТГ	09-17	Сб, Вс	\N	\N	\N	4	855
Алтайский край	Барнаул	+4	Зато Сибирский	\N	Первомайского	\N	233570	ТГ	08.30-18	Сб, Вс	ЛИ-4004-17	30.12.1899	\N	4	\N
Алтайский край	Барнаул	+4	Новоалтайск	\N	Первомайского	ц	233511	ТГ	08-17	Сб, Вс	ЛИ-4032-17	30.12.1899	\N	4	878
Алтайский край	Барнаул	+4	Петропавловское	\N	Петропавловского	ц	233561	ТГ	09-16	Сб, Вс	\N	\N	\N	4	106
Алтайский край	Барнаул	+4	Поспелиха	\N	Поспелихинского	ц	233557	ТГ	08-18 Сб 09-15	Вс	\N	\N	\N	4	1587
Алтайский край	Барнаул	+4	Ребриха	\N	Ребрихинского	ц	233542	ТГ	09-16.45	Сб, Вс	\N	\N	\N	4	2792
Алтайский край	Барнаул	+4	Родино	\N	Родинского	ц	233548	ТГ	09-18	Сб, Вс	\N	\N	\N	4	4092
Алтайский край	Барнаул	+4	Романово	\N	Романовского	ц	233549	ТГ	09-16.45	Сб, Вс	\N	\N	\N	4	13206
Алтайский край	Барнаул	+4	Рубцовск	\N	Рубцовского	ц	233533	ТГ	08-20	\N	\N	\N	\N	4	1502
Алтайский край	Барнаул	+4	Славгород	\N	Славгородского	ц	233522	ТГ	08-19 Сб, Вс 09-16	\N	\N	\N	\N	4	1558
Алтайский край	Барнаул	+4	Яровое	\N	Славгородского	\N	233567	ТГ	08-20 Сб, Вс 09-16	\N	\N	\N	\N	4	16000
Алтайский край	Барнаул	+4	Смоленское	\N	Смоленского	ц	233516	ТГ	08-18	Сб, Вс	\N	\N	\N	4	1434
Алтайский край	Барнаул	+4	Советское	\N	Советского	ц	233562	ТГ	09-17	Сб, Вс	\N	\N	\N	4	1451
Алтайский край	Барнаул	+4	Солонешное	\N	Солонешенского	ц	233563	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1416
Алтайский край	Барнаул	+4	Солтон	\N	Солтонского	ц	233564	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1314
Алтайский край	Барнаул	+4	Верх-Суетка	\N	Суетского	ц	233573	ТГ	09-16	Сб, Вс	\N	\N	\N	4	4794
Алтайский край	Барнаул	+4	Табуны	\N	Табунского	ц	233550	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1186
Алтайский край	Барнаул	+4	Тальменка	\N	Тальменского	ц	233534	ТГ	08-17 Сб 09-14	Вс	\N	\N	\N	4	1187
Алтайский край	Барнаул	+4	Тогул	\N	Тогульского	ц	233566	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1184
Алтайский край	Барнаул	+4	Топчиха	\N	Топчихинского	ц	233543	ТГ	08-17 Пт 08-16	Сб, Вс	\N	\N	\N	4	16221
Алтайский край	Барнаул	+4	Староалейское	\N	Третьяковского	ц	233551	ТГ	09-16	Сб, Вс	\N	\N	\N	4	1288
Алтайский край	Барнаул	+4	Троицкое	\N	Троицкого	ц	233558	ТГ	09-17	Сб, Вс	ЛИ-4005-17	30.12.1899	\N	4	1143
Алтайский край	Барнаул	+4	Тюменцево	\N	Тюменцевского	ц	233552	ТГ	08-16	Сб, Вс	ЛИ-4006-17	30.12.1899	\N	4	1079
Алтайский край	Барнаул	+4	Угловское	\N	Угловского	ц	233553	ТГ	09-17	Сб, Вс	\N	\N	\N	4	570
Алтайский край	Барнаул	+4	Усть-Калманка	\N	Усть-Калманского	ц	233519	ТГ	09-17	Сб, Вс	\N	\N	\N	4	353
Алтайский край	Барнаул	+4	Усть-Чарышская Пристань	\N	Усть-Пристанского	ц	233554	ТГ	09-17	Сб, Вс	\N	\N	\N	4	324
Алтайский край	Барнаул	+4	Хабары	\N	Хабарского	ц	233526	ТГ	09-17	Сб, Вс	\N	\N	\N	4	13218
Алтайский край	Барнаул	+4	Целинное	\N	Целинного	ц	233535	ТГ	09-16	Сб, Вс	\N	\N	\N	4	15996
Алтайский край	Барнаул	+4	Чарышское	\N	Чарышского	ц	233555	ТГ	09-17	Сб, Вс	\N	\N	\N	4	15997
Алтайский край	Барнаул	+4	Шелаболиха	\N	Шелаболихинского	ц	233568	ТГ	09-17	Сб, Вс	\N	\N	\N	4	15998
Алтайский край	Барнаул	+4	Шипуново	\N	Шипуновского	ц	233544	ТГ	09-18 Сб 10-13	Вс	\N	\N	\N	4	16136
Амурская область	Благовещенск	+6	Архара	в зоне обслуживания Благовещенского МЦТЭТ	Архаринского	ц	154543	ТГ	08-17	Сб, Вс, Пн	ЛИ-3583-17	28.11.2017	\N	5	5325
Амурская область	Благовещенск	+6	Белогорск	\N	Белогорского	ц	154511	ТГ	08-17	Сб, Вс	\N	\N	\N	5	76
Амурская область	Благовещенск	+6	Благовещенск	\N	\N	\N	154ххх	ТГ	08-20	\N	\N	\N	\N	5	74
Амурская область	Благовещенск	+6	Новобурейский	в зоне обслуживания Благовещенского МЦТЭТ	Бурейского	ц	154521	ТГ	08-17	Сб, Вс, Пн	\N	\N	\N	5	90
Амурская область	Благовещенск	+6	Завитинск	Кроме Завитинск-5,  в зоне обслуживания Белогорского МЦТЭТ	Завитинского	ц	154542	ТГ	09-18	Сб, Вс, Пн	ЛИ-3584-17	28.11.2017	\N	5	83
Амурская область	Благовещенск	+6	Зея	\N	Зейского	ц	154531	ТГ	08-17	Сб, Вс	\N	\N	\N	5	84
Амурская область	Благовещенск	+6	Ивановка	в зоне обслуживания Благовещенского МЦТЭТ	Ивановского	ц	154516	ТГ	09-16	Сб, Вс, Пн	ЛИ-2572-17	09.11.2017	\N	5	85
Амурская область	Благовещенск	+6	Константиновка	в зоне обслуживания Благовещенского МЦТЭТ	Константиновского	ц	154526	ТГ	08-17	Сб, Вс,Вт	ЛИ-2574-17	28.11.2017	\N	5	86
Амурская область	Благовещенск	+6	Магдагачи	в зоне обслуживания Зейского МЦТЭТ	Магдагачинского	ц	154525	ТГ	09-17	Пн, Сб, Вс	ЛИ-466-17	28.11.2017	\N	5	89
Амурская область	Благовещенск	+6	Новокиевский Увал	в зоне обслуживания Свободненского МЦТЭТ	Мазановского	ц	154534	ТГ	08-17	Сб, Вс	ЛИ-2576-17	28.11.2017	\N	5	91
Амурская область	Благовещенск	+6	Поярково	в зоне обслуживания Благовещенского МЦТЭТ	Михайловского	ц	154541	ТГ	08-16	Сб, Вс	ЛИ-2573-17	28.11.2017	\N	5	94
Амурская область	Благовещенск	+6	Екатеринославка	в зоне обслуживания Белогорского МЦТЭТ	Октябрьского	ц	154515	ТГ	10-16	Сб, Вс, Пн	ЛИ-132-17	30.12.1899	\N	5	81
Амурская область	Благовещенск	+6	Райчихинск	в зоне обслуживания Благовещенского МЦТЭТ	\N	ц	154522	ТГ	09-17	Пн, Сб, Вс	ЛИ-2575-17	28.11.2017	\N	5	\N
Амурская область	Благовещенск	+6	Ромны	в зоне обслуживания Белогорского МЦТЭТ	Ромненского	ц	154517	ТГ	08-15.30	Сб, Вс	\N	\N	\N	5	97
Амурская область	Благовещенск	+6	Свободный	Кроме Свободный-20,21	Свободненского	ц	154512	ТГ	08-20	\N	\N	\N	\N	5	98
Амурская область	Благовещенск	+6	Экимчан	в зоне обслуживания Свободненского МЦТЭТ	Селемджинского	ц	154533	ТГ	09-16	Сб, Вс	ЛИ-1513-17	28.11.2017	\N	5	109
Амурская область	Благовещенск	+6	Серышево	Кроме Серышево 1,2, в зоне обслуживания Белогорского МЦТЭТ	Серышевского	ц	154513	ТГ	08-17	Сб, Вс	ЛИ-3585-17	28.11.2017	\N	5	99
Амурская область	Благовещенск	+6	Сковородино	в зоне обслуживания Тындинского МЦТЭТ	Сковородинского	ц	154523	ТГ	09-17	Сб, Вс, Пн	\N	\N	\N	5	100
Амурская область	Благовещенск	+6	Тамбовка	в зоне обслуживания Благовещенского МЦТЭТ	Тамбовского	ц	154532	ТГ	08-16	Вт, Сб, Вс	ЛИ-539-17	28.11.2017	\N	5	103
Амурская область	Благовещенск	+6	Тында	\N	Тындинского	ц	154524	ТГ	08-19	\N	\N	\N	\N	5	104
Амурская область	Благовещенск	+6	Шимановск	в зоне обслуживания Свободненского МЦТЭТ	Шимановского	ц	154514	ТГ	08-20	Сб, Вс	\N	\N	\N	5	108
Архангельская область	Архангельск	0	Архангельск	\N	\N	г	242ххх	ТГ	08-20 Сб 09-18	Вс	ЛИ-7034-17	12.07.2017	\N	6	111
Архангельская область	Архангельск	0	Аргуновский	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5479
Архангельская область	Архангельск	0	Благовещенское	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Вт	\N	\N	\N	6	5490
Архангельская область	Архангельск	0	Боровое	\N	Вельского	\N	242556	\N	09-13	Вс, Вт	\N	\N	\N	6	5499
Архангельская область	Архангельск	0	Вельск	\N	Вельского	ц	242556	ТГ	07-19	Сб, Вс	ЛИ-7035-17	12.07.2017	\N	6	117
Архангельская область	Архангельск	0	Вельск-1	\N	Вельского	\N	242556	\N	10-13	Ср, Вс	\N	\N	\N	6	5441
Архангельская область	Архангельск	0	Верхопуйский	\N	Вельского	\N	242556	\N	09-14	Вс, Пн	\N	\N	\N	6	5522
Архангельская область	Архангельск	0	Георгиевское	\N	Вельского	\N	242556	\N	09-14	Вс, Пн	\N	\N	\N	6	5538
Архангельская область	Архангельск	0	Горка-Муравьевская	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5433
Архангельская область	Архангельск	0	Долматово	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5552
Архангельская область	Архангельск	0	Еменьга	\N	Вельского	\N	242556	\N	10-15	Вс, Вт	\N	\N	\N	6	5558
Архангельская область	Архангельск	0	Ефремковская	\N	Вельского	\N	242556	\N	09-15	Вс, Вт	\N	\N	\N	6	5562
Архангельская область	Архангельск	0	Игнатовка	\N	Вельского	\N	242556	\N	08-14	Вс, Пн	\N	\N	\N	6	5575
Архангельская область	Архангельск	0	Исполиновка	\N	Вельского	\N	242556	\N	08-15	Сб, Вс	\N	\N	\N	6	124
Архангельская область	Архангельск	0	Козловская	\N	Вельского	\N	242556	\N	09-16	Вс, Вт	\N	\N	\N	6	5597
Архангельская область	Архангельск	0	Комсомольский	\N	Вельского	\N	242556	\N	09-16	Сб, Вс	\N	\N	\N	6	132
Архангельская область	Архангельск	0	Кулой	\N	Вельского	\N	242556	\N	08-18 Сб 09-15	Вс	\N	\N	\N	6	138
Архангельская область	Архангельск	0	Лиходиевский	\N	Вельского	\N	242556	\N	09-14	Вс, Пн	\N	\N	\N	6	5642
Архангельская область	Архангельск	0	Лодейное	\N	Вельского	\N	242556	\N	09-13	Вс, Вт	\N	\N	\N	6	5643
Архангельская область	Архангельск	0	Малая Липовка	\N	Вельского	\N	242556	\N	09-16	Вс, Пн	\N	\N	\N	6	5654
Архангельская область	Архангельск	0	Мелединская	\N	Вельского	\N	242556	\N	09-13	Вс, Пн	\N	\N	\N	6	5659
Архангельская область	Архангельск	0	Никифорово	\N	Вельского	\N	242556	\N	09-13	Вс, Пн	\N	\N	\N	6	5676
Архангельская область	Архангельск	0	Новинки	\N	Вельского	\N	242556	\N	09-13	Вс, Вт	\N	\N	\N	6	5678
Архангельская область	Архангельск	0	Павловское	\N	Вельского	\N	242556	\N	09-13	Вс, Пн	\N	\N	\N	6	5694
Архангельская область	Архангельск	0	Пасьва	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5700
Архангельская область	Архангельск	0	Пежма	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5706
Архангельская область	Архангельск	0	Саргино	\N	Вельского	\N	242556	\N	09-13	Вс, Пн	\N	\N	\N	6	5761
Архангельская область	Архангельск	0	Синега	\N	Вельского	\N	242556	\N	08-14	Вс, Вт	\N	\N	\N	6	5769
Архангельская область	Архангельск	0	Смольянская	\N	Вельского	\N	242556	\N	09-13	Вс, Вт	\N	\N	\N	6	5775
Архангельская область	Архангельск	0	Солгинский	\N	Вельского	\N	242556	\N	09-17	Сб, Вс	\N	\N	\N	6	164
Архангельская область	Архангельск	0	Судромский	\N	Вельского	\N	242556	\N	08-15	Сб, Вс	\N	\N	\N	6	167
Архангельская область	Архангельск	0	Тегроозеро	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5804
Архангельская область	Архангельск	0	Теребино	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	16271
Архангельская область	Архангельск	0	Тимонино	\N	Вельского	\N	242556	\N	09-14	Вс, Пн	\N	\N	\N	6	5832
Архангельская область	Архангельск	0	Усть-Шоноша	\N	Вельского	\N	242556	\N	09-16	Сб, Вс	\N	\N	\N	6	173
Архангельская область	Архангельск	0	Шокша	\N	Вельского	\N	242556	\N	09-14	Вс, Вт	\N	\N	\N	6	5890
Архангельская область	Архангельск	0	Шунема	\N	Вельского	\N	242556	\N	07-11 16-20	Вс, Вт	\N	\N	\N	6	5892
Архангельская область	Архангельск	0	Авнюгский	\N	Верхнетоемского	\N	242585	\N	07-11	Пн,Ср, Пт, Вс	\N	\N	\N	6	5467
Архангельская область	Архангельск	0	Бурцевская	\N	Верхнетоемского	\N	242585	\N	09-12	Вс	\N	\N	\N	6	5503
Архангельская область	Архангельск	0	Верхняя Тойма	\N	Верхнетоемского	\N	242585	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	118
Архангельская область	Архангельск	0	Вознесенское	\N	Верхнетоемского	\N	242585	\N	09-12	Вс	\N	\N	\N	6	5527
Архангельская область	Архангельск	0	Двинской	\N	Верхнетоемского	\N	242585	\N	09-12	Вс	\N	\N	\N	6	5549
Архангельская область	Архангельск	0	Евдокимовская	\N	Верхнетоемского	\N	242585	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5557
Архангельская область	Архангельск	0	Зеленник	\N	Верхнетоемского	\N	242585	\N	07-11	Вс, Пн	\N	\N	\N	6	5569
Брянская область	Брянск	0	Лукин	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	7368
Архангельская область	Архангельск	0	Игумновская	\N	Верхнетоемского	\N	242585	\N	09-12	Пн, Ср, Пт, Вс	\N	\N	\N	6	5577
Архангельская область	Архангельск	0	Кодима	\N	Верхнетоемского	\N	242585	\N	10-14	Вт, Чт, Сб, Вс	\N	\N	\N	6	5596
Архангельская область	Архангельск	0	Кондратовская	\N	Верхнетоемского	\N	242585	\N	08-12 Сб 09-12	Вт, Чт, Сб, Вс	\N	\N	\N	6	5605
Архангельская область	Архангельск	0	Красная	\N	Верхнетоемского	\N	242585	\N	07-11	Пн, Ср, Чт, Пт, Вс	\N	\N	\N	6	5612
Архангельская область	Архангельск	0	Ламбас	\N	Верхнетоемского	\N	242585	\N	09-12	Вт, Чт, Сб, Вс	\N	\N	\N	6	5629
Архангельская область	Архангельск	0	Окуловская	\N	Верхнетоемского	\N	242585	\N	09-12	Вт, Пт, Вс	\N	\N	\N	6	5683
Архангельская область	Архангельск	0	Осяткино	\N	Верхнетоемского	\N	242585	\N	09-13	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5689
Архангельская область	Архангельск	0	Палова	\N	Верхнетоемского	\N	242585	\N	Пн, Ср, Пт 09-14.20	Вт, Чт, Сб, Вс	ЛИ-16-16	13.12.2016	\N	6	\N
Архангельская область	Архангельск	0	Поперечка	\N	Верхнетоемского	\N	242585	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	6	5722
Архангельская область	Архангельск	0	Семеновская-Первая	\N	Верхнетоемского	\N	242585	\N	10-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5767
Архангельская область	Архангельск	0	Согра	\N	Верхнетоемского	\N	242585	\N	07-11	Вс, Пн	\N	\N	\N	6	5777
Архангельская область	Архангельск	0	Сосновый	\N	Верхнетоемского	\N	242585	\N	08-12 Сб 09-11	Вт, Чт, Сб, Вс	\N	\N	\N	6	5789
Архангельская область	Архангельск	0	Усть-Ерга	\N	Верхнетоемского	\N	242585	\N	10-13	Вс	\N	\N	\N	6	5848
Архангельская область	Архангельск	0	Вилегодск	\N	Вилегодского	\N	242598	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5524
Архангельская область	Архангельск	0	Ильинско-Подомское	\N	Вилегодского	\N	242598	ТГ	08-17 Пт 08-15.30	Сб, Вс	\N	\N	\N	6	123
Архангельская область	Архангельск	0	Никольск	\N	Вилегодского	\N	242598	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5677
Архангельская область	Архангельск	0	Павловск	\N	Вилегодского	\N	242598	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5692
Архангельская область	Архангельск	0	Сорово	\N	Вилегодского	\N	242598	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5785
Архангельская область	Архангельск	0	Широкий Прилук	\N	Вилегодского	\N	242598	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5887
Архангельская область	Архангельск	0	Артюшинская	\N	Виноградовского	\N	242568	\N	09-16	Вс, Пн	\N	\N	\N	6	5481
Архангельская область	Архангельск	0	Березник	\N	Виноградовского	\N	242568	ТГ	07-18 Пт 09-13	Сб, Вс	\N	\N	\N	6	112
Архангельская область	Архангельск	0	Березник-1	\N	Виноградовского	\N	242568	\N	09-16	Вс	\N	\N	\N	6	5482
Архангельская область	Архангельск	0	Важский	\N	Виноградовского	\N	242568	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5505
Архангельская область	Архангельск	0	Верхняя-Кица	\N	Виноградовского	\N	242568	\N	09-15	Вс, Пн, Ср, Пт	\N	\N	\N	6	5518
Архангельская область	Архангельск	0	Воронцы	\N	Виноградовского	\N	242568	\N	09-16	Вс, Сб	\N	\N	\N	6	5533
Архангельская область	Архангельск	0	Игнатьевская	\N	Виноградовского	\N	242568	\N	09-17	Вс, Пн	\N	\N	\N	6	5576
Архангельская область	Архангельск	0	Моржегоры	\N	Виноградовского	\N	242568	\N	09-17	Вс, Пн	\N	\N	\N	6	5665
Архангельская область	Архангельск	0	Осиново	\N	Виноградовского	\N	242568	\N	08-15	Вс	\N	\N	\N	6	5687
Архангельская область	Архангельск	0	Пянда	\N	Виноградовского	\N	242568	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5738
Архангельская область	Архангельск	0	Ростовское	\N	Виноградовского	\N	242568	\N	09-14	Вс, Пн	\N	\N	\N	6	5746
Архангельская область	Архангельск	0	Рочегда	\N	Виноградовского	\N	242568	\N	09-16	Сб, Вс	\N	\N	\N	6	159
Архангельская область	Архангельск	0	Рочегда-1	\N	Виноградовского	\N	242568	\N	10-17	Вс, Пн	\N	\N	\N	6	16265
Архангельская область	Архангельск	0	Рязаново	\N	Виноградовского	\N	242568	\N	09-17	Вс, Пн	\N	\N	\N	6	5750
Архангельская область	Архангельск	0	Сельменьга	\N	Виноградовского	\N	242568	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5766
Архангельская область	Архангельск	0	Топса	\N	Виноградовского	\N	242568	\N	10-17 Сб 10-16	Вс	\N	\N	\N	6	5836
Архангельская область	Архангельск	0	Уйта	\N	Виноградовского	\N	242568	\N	09-13	Вс, Пн	\N	\N	\N	6	5841
Архангельская область	Архангельск	0	Усть-Вага	\N	Виноградовского	\N	242568	\N	09-13	Вс, Пн	\N	\N	\N	6	5847
Архангельская область	Архангельск	0	Усть-Ваеньга	\N	Виноградовского	\N	242568	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5846
Архангельская область	Архангельск	0	Шидрово	\N	Виноградовского	\N	242568	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5883
Архангельская область	Архангельск	0	Шошельцы	\N	Виноградовского	\N	242568	\N	10-13	Пт, Вс, Пн	\N	\N	\N	6	16288
Архангельская область	Архангельск	0	Яковлевское	\N	Виноградовского	\N	242568	\N	09-14 Сб 09-16	Вс, Пн	\N	\N	\N	6	5898
Архангельская область	Архангельск	0	Абакумово	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Бронево	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Ватамановская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Гавриловская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс,Пн	\N	\N	\N	6	5536
Архангельская область	Архангельск	0	Казаково	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Каргополь	\N	Каргопольского	\N	242595	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	126
Архангельская область	Архангельск	0	Каргополь-1	\N	Каргопольского	\N	242595	\N	09-17	Вс	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Кононово	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Кречетово	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Морщихинская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Осташевская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5688
Архангельская область	Архангельск	0	Песок	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5708
Архангельская область	Архангельск	0	Петровская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5709
Архангельская область	Архангельск	0	Тимошинская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5833
Архангельская область	Архангельск	0	Шелоховская	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5881
Архангельская область	Архангельск	0	Ширяиха	\N	Каргопольского	\N	242595	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5888
Архангельская область	Архангельск	0	Вельцы	\N	Коношского	\N	242548	\N	09-13	Вс, Пн	\N	\N	\N	6	5514
Архангельская область	Архангельск	0	Волошка	\N	Коношского	\N	242548	\N	07-20	Вс, Пн	\N	\N	\N	6	5531
Архангельская область	Архангельск	0	Ерцево	\N	Коношского	\N	242548	\N	09-20	Вс	\N	\N	\N	6	5561
Архангельская область	Архангельск	0	Ерцево-1	\N	Коношского	\N	242548	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5427
Архангельская область	Архангельск	0	Заречный	\N	Коношского	\N	242548	\N	09-16	Вс, Пн	\N	\N	\N	6	5566
Архангельская область	Архангельск	0	Климовская	\N	Коношского	\N	242548	\N	09-17	Вс, Пн	\N	\N	\N	6	5593
Архангельская область	Архангельск	0	Коноша	\N	Коношского	\N	242548	ТГ	08-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	134
Архангельская область	Архангельск	0	Коноша-1	\N	Коношского	\N	242548	\N	08-21	Вс	\N	\N	\N	6	5414
Архангельская область	Архангельск	0	Коноша-2	\N	Коношского	\N	242548	\N	09-16	Вс, Пн	\N	\N	\N	6	5413
Архангельская область	Архангельск	0	Кремлево	\N	Коношского	\N	242548	\N	09-16	Вс, Пн	\N	\N	\N	6	5616
Архангельская область	Архангельск	0	Мелентьевский	\N	Коношского	\N	242548	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5660
Архангельская область	Архангельск	0	Мирный	\N	Коношского	\N	242548	\N	09-16	Вс, Пн	\N	\N	\N	6	5661
Архангельская область	Архангельск	0	Можуга	\N	Коношского	\N	242548	\N	09-17	Вс, Пн	\N	\N	\N	6	5663
Архангельская область	Архангельск	0	Нечаевская	\N	Коношского	\N	242548	\N	08-16	Вс, Пн	\N	\N	\N	6	5671
Архангельская область	Архангельск	0	Норменьга	\N	Коношского	\N	242548	\N	09-16	Вс, Пн	\N	\N	\N	6	5679
Архангельская область	Архангельск	0	Папинская	\N	Коношского	\N	242548	\N	09-17	Вс, Пн	\N	\N	\N	6	5699
Архангельская область	Архангельск	0	Першинская	\N	Коношского	\N	242548	\N	08-15	Вс, Пн	\N	\N	\N	6	16259
Архангельская область	Архангельск	0	Подюга	\N	Коношского	\N	242548	\N	09-20 Сб, Вс 10-18	\N	\N	\N	\N	6	156
Архангельская область	Архангельск	0	Понамаревская	\N	Коношского	\N	242548	\N	07-20	Вс, Пн	\N	\N	\N	6	5721
Архангельская область	Архангельск	0	Сосновка	\N	Коношского	\N	242548	\N	08-16	Вс, Пн	\N	\N	\N	6	16267
Архангельская область	Архангельск	0	Топоровская	\N	Коношского	\N	242548	\N	09-13	Вс, Пн	\N	\N	\N	6	5835
Архангельская область	Архангельск	0	Фоминская	\N	Коношского	\N	242548	\N	09-17	Вс, Пн	\N	\N	\N	6	5861
Архангельская область	Архангельск	0	Коряжма	\N	\N	г	242531	\N	07-21	\N	ЛИ-7036-17	12.07.2017	\N	6	135
Архангельская область	Архангельск	0	Борки	\N	Котласского	\N	242531	\N	08-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5498
Архангельская область	Архангельск	0	Вотлажма	\N	Котласского	\N	242531	\N	09-12	Пн, Ср, Пт, Вс	\N	\N	\N	6	5534
Архангельская область	Архангельск	0	Выставка	\N	Котласского	\N	242531	\N	09-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5535
Архангельская область	Архангельск	0	Вычегодский	\N	Котласского	\N	242531	\N	09-20	Вс	\N	\N	\N	6	116
Архангельская область	Архангельск	0	Городише	\N	Котласского	\N	242531	\N	10-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Григорово	\N	Котласского	\N	242531	\N	07-11	Пн, Ср, Пт,	\N	\N	\N	6	5544
Архангельская область	Архангельск	0	Ерга	\N	Котласского	\N	242531	\N	09-13	Пн, Ср, Сб, Вс	\N	\N	\N	6	5560
Архангельская область	Архангельск	0	Котлас	\N	Котласского	\N	242531	ТГ	08-15 Сб 09-14	Вс	\N	\N	\N	6	136
Архангельская область	Архангельск	0	Котлас-9	\N	Котласского	\N	242531	\N	09-16 Сб 09-14	Вс	\N	\N	\N	6	914
Архангельская область	Архангельск	0	Нечаиха	\N	Котласского	\N	242531	\N	09-12	Пн, Ср, Пт, Вс	\N	\N	\N	6	5672
Архангельская область	Архангельск	0	Прела	\N	Котласского	\N	242531	\N	10-14	Пн, Ср, Сб, Вс	\N	\N	\N	6	5728
Архангельская область	Архангельск	0	Приводино	\N	Котласского	\N	242535	\N	10-12	Чт, Сб, Вс	\N	\N	\N	6	157
Архангельская область	Архангельск	0	Реваж	\N	Котласского	\N	242531	\N	08-12	Пн, Ср, Пт, Вс	\N	\N	\N	6	5740
Архангельская область	Архангельск	0	Сольвычегодск	\N	Котласского	\N	242531	\N	09-13	Пн, Ср, Вс	\N	\N	\N	6	165
Архангельская область	Архангельск	0	Удимский	\N	Котласского	\N	242531	\N	09-13	Сб, Вс	\N	\N	\N	6	5840
Архангельская область	Архангельск	0	Федотовская	\N	Котласского	\N	242531	\N	07-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5859
Архангельская область	Архангельск	0	Хаминово	\N	Котласского	\N	242531	\N	08-11	Пн, Ср, Пт, Вс	\N	\N	\N	6	5863
Архангельская область	Архангельск	0	Харитоново	\N	Котласского	\N	242531	\N	07-11	Пн, Ср, Вс	\N	\N	\N	6	16277
Архангельская область	Архангельск	0	Черемушский	\N	Котласского	\N	242531	\N	08-13	Пн, Ср, Вс	\N	\N	\N	6	5873
Архангельская область	Архангельск	0	Шипицино	\N	Котласского	\N	242531	\N	09-13	Сб, Вс	\N	\N	\N	6	16283
Архангельская область	Архангельск	0	Ядриха	\N	Котласского	\N	242531	\N	09-13	Пн, Ср, Пт, Вс	\N	\N	\N	6	5897
Архангельская область	Архангельск	0	Березонаволок	\N	Красноборского	\N	242508	\N	09-13	Пн, Вт, Чт, Пт, Вс	\N	\N	\N	6	5488
Белгородская область	Белгород	0	Беломестное	\N	Новооскольского	\N	156501	\N	08-16	Вс, Пн	\N	\N	\N	10	6072
Белгородская область	Белгород	0	Богдановка	\N	Новооскольского	\N	156501	\N	10-16	Вс, Пн	\N	\N	\N	10	6089
Белгородская область	Белгород	0	Богородское	\N	Новооскольского	\N	156501	\N	08-16	Вс, Пн	\N	\N	\N	10	6090
Белгородская область	Белгород	0	Боровки	\N	Новооскольского	\N	156501	\N	09-14	Вс, Пн	\N	\N	\N	10	6102
Белгородская область	Белгород	0	Боровое	\N	Новооскольского	\N	156501	\N	11-16	Вс, Пн	\N	\N	\N	10	6103
Белгородская область	Белгород	0	Васильдол	\N	Новооскольского	\N	156501	\N	08-15	Вс, Пн	\N	\N	\N	10	6113
Белгородская область	Белгород	0	Великомихайловка	\N	Новооскольского	\N	156501	ТГ	08-16	\N	\N	\N	\N	10	4780
Белгородская область	Белгород	0	Глинное	\N	Новооскольского	\N	156501	\N	10-15	Вс, Пн	\N	\N	\N	10	6142
Белгородская область	Белгород	0	Голубино	\N	Новооскольского	\N	156501	\N	09-15	Вс, Пн	\N	\N	\N	10	6149
Белгородская область	Белгород	0	Киселевка	\N	Новооскольского	\N	156501	\N	09-12	Вс, Пн	\N	\N	\N	10	6278
Белгородская область	Белгород	0	Крюк	\N	Новооскольского	\N	156501	\N	10-15	Вс, Пн	\N	\N	\N	10	6383
Белгородская область	Белгород	0	Макешкино	\N	Новооскольского	\N	156501	\N	10-14	Вс, Пн	\N	\N	\N	10	6433
Белгородская область	Белгород	0	Немцево	\N	Новооскольского	\N	156501	\N	10-15	Вс, Пн	\N	\N	\N	10	6500
Белгородская область	Белгород	0	Николаевка	\N	Новооскольского	\N	156501	\N	09-15	Вс, Пн	\N	\N	\N	10	6517
Белгородская область	Белгород	0	Ниновка	\N	Новооскольского	\N	156501	\N	09-16	Вс, Пн	\N	\N	\N	10	6529
Белгородская область	Белгород	0	Новая Безгинка	\N	Новооскольского	\N	156501	\N	08-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Новый Оскол	\N	Новооскольского	ц	156501	ТГ	07-21	\N	ЛИ-7340-17	13.07.2017	\N	10	279
Белгородская область	Белгород	0	Ольховатка	\N	Новооскольского	\N	156501	\N	08-16	Вс, Пн	\N	\N	\N	10	6566
Белгородская область	Белгород	0	Оскольское	\N	Новооскольского	\N	156501	\N	09-17	Вс, Пн	\N	\N	\N	10	6572
Белгородская область	Белгород	0	Прибрежный	\N	Новооскольского	\N	156501	\N	09-15	Вс, Пн	\N	\N	\N	10	6622
Белгородская область	Белгород	0	Севальное	\N	Новооскольского	\N	156501	\N	09-17	Вс, Пн	\N	\N	\N	10	6669
Белгородская область	Белгород	0	Серебрянка	\N	Новооскольского	\N	156501	\N	09-15	Вс, Пн	\N	\N	\N	10	6680
Белгородская область	Белгород	0	Скрыниково	\N	Новооскольского	\N	156501	\N	11-15	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Слоновка	\N	Новооскольского	\N	156501	\N	10-15	Вс, Пн	\N	\N	\N	10	6688
Белгородская область	Белгород	0	Солонец-Поляна	\N	Новооскольского	\N	156501	\N	09-12	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Старая Безгинка	\N	Новооскольского	\N	156501	\N	09-16	Вс, Пн	\N	\N	\N	10	6734
Белгородская область	Белгород	0	Тростянец	\N	Новооскольского	\N	156501	\N	09-14	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Шараповка	\N	Новооскольского	\N	156501	\N	08-16	Вс, Пн	\N	\N	\N	10	6847
Белгородская область	Белгород	0	Яковлевка	\N	Новооскольского	\N	156501	\N	09-16	Вс, Пн	\N	\N	\N	10	6875
Белгородская область	Белгород	0	Ярское	\N	Новооскольского	\N	156501	\N	09-15	Вс, Пн	\N	\N	\N	10	6879
Белгородская область	Белгород	0	Беленихино	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6069
Белгородская область	Белгород	0	Береговое-1	\N	Прохоровского	\N	156536	\N	09-16	Вс, Пн	\N	\N	\N	10	6077
Белгородская область	Белгород	0	Береговое-2	\N	Прохоровского	\N	156536	\N	09-16	Вс, Пн	\N	\N	\N	10	6078
Белгородская область	Белгород	0	Большое	\N	Прохоровского	\N	156536	\N	10-16	Вс, Пн	\N	\N	\N	10	6097
Белгородская область	Белгород	0	Веселое	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6126
Белгородская область	Белгород	0	Вязовое	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6139
Белгородская область	Белгород	0	Гнездиловка	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6145
Белгородская область	Белгород	0	Грязное	\N	Прохоровского	\N	156536	\N	08-15	Вс, Пн	\N	\N	\N	10	6159
Белгородская область	Белгород	0	Донец	\N	Прохоровского	\N	156536	\N	09-15	Вс, Пн	\N	\N	\N	10	6172
Белгородская область	Белгород	0	Журавка	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6183
Белгородская область	Белгород	0	Карташовка	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6276
Белгородская область	Белгород	0	Красное	\N	Прохоровского	\N	156536	\N	10-15	Вс, Пн	\N	\N	\N	10	6355
Белгородская область	Белгород	0	Кривошеевка	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6373
Белгородская область	Белгород	0	Кривые Балки	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6377
Белгородская область	Белгород	0	Лучки	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6427
Белгородская область	Белгород	0	Петровка	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	6585
Белгородская область	Белгород	0	Плота	\N	Прохоровского	\N	156636	\N	09-17	Вс, Пн	\N	\N	\N	10	6595
Белгородская область	Белгород	0	Подольхи	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6603
Белгородская область	Белгород	0	Прелестное	\N	Прохоровского	\N	156536	\N	08-16	Вс, Пн	\N	\N	\N	10	6618
Белгородская область	Белгород	0	Призначное	\N	Прохоровского	\N	156536	\N	08-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Прохоровка	\N	Прохоровского	ц	156536	ТГ	07-21	\N	ЛИ-7341-17	13.07.2017	\N	10	281
Белгородская область	Белгород	0	Радьковка	\N	Прохоровского	\N	156536	\N	09-17	Вс, Пн	\N	\N	\N	10	6629
Белгородская область	Белгород	0	Раисовка	\N	Прохоровского	\N	156536	\N	10-16	Вс, Пн	\N	\N	\N	10	6634
Белгородская область	Белгород	0	Ржавец	\N	Прохоровского	\N	156536	\N	09-16	Вс, Пн	\N	\N	\N	10	6646
Белгородская область	Белгород	0	Сагайдачное	\N	Прохоровского	\N	156536	\N	10-16	Вс, Пн	\N	\N	\N	10	6661
Белгородская область	Белгород	0	Сеймица	\N	Прохоровского	\N	156536	\N	10-17	Вс, Пн	\N	\N	\N	10	6671
Белгородская область	Белгород	0	Тетеревино	\N	Прохоровского	\N	156536	\N	11-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Холодное	\N	Прохоровского	\N	156536	\N	10-16	Вс, Пн	\N	\N	\N	10	6812
Белгородская область	Белгород	0	Шахово	\N	Прохоровского	\N	156536	\N	10-16	Вс, Пн	\N	\N	\N	10	6851
Белгородская область	Белгород	0	Бобрава	\N	Ракитянского	\N	156545	\N	09-18	Вс, Пн	\N	\N	\N	10	6086
Белгородская область	Белгород	0	Борисполье	\N	Ракитянского	\N	156545	\N	09-14	Вс, Пн, Пт	\N	\N	\N	10	6101
Белгородская область	Белгород	0	Васильевка	\N	Ракитянского	\N	156545	\N	09-15	Вс, Пн, Пт	\N	\N	\N	10	6114
Белгородская область	Белгород	0	Введенская Готня	\N	Ракитянского	\N	156545	\N	09-16	Вс, Пн	\N	\N	\N	10	6115
Белгородская область	Белгород	0	Венгеровка	\N	Ракитянского	\N	156545	\N	09-15	Вс, Пн	\N	\N	\N	10	6116
Белгородская область	Белгород	0	Вышные Пены	\N	Ракитянского	\N	156545	\N	09-15	Вс, Пн, Пт	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Дмитриевка	\N	Ракитянского	\N	156545	\N	09-16	Вс, Пн	\N	\N	\N	10	6165
Белгородская область	Белгород	0	Зинаидино	\N	Ракитянского	\N	156545	\N	09-17	Вс, Пн, Пт	\N	\N	\N	10	6213
Белгородская область	Белгород	0	Илек-Кошары	\N	Ракитянского	\N	156545	\N	08-15	Вс, Пн	\N	\N	\N	10	6226
Белгородская область	Белгород	0	Меловое	\N	Ракитянского	\N	156545	\N	09-16	Вс, Пн, Пт	\N	\N	\N	10	6478
Белгородская область	Белгород	0	Нижние Пены	\N	Ракитянского	\N	156545	\N	09-16	Вс, Пн	\N	\N	\N	10	6508
Белгородская область	Белгород	0	Пролетарский	\N	Ракитянского	\N	156545	ТГ	07-21	\N	\N	\N	\N	10	4787
Белгородская область	Белгород	0	Ракитное	\N	Ракитянского	ц	156545	ТГ	07-21	\N	ЛИ-7342-17	13.07.2017	\N	10	283
Белгородская область	Белгород	0	Ракитное-1	\N	Ракитянского	\N	156545	ТГ	09-17	Вс	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Русская Березовка	\N	Ракитянского	\N	156545	\N	10-15	Вс, Пн, Пт	\N	\N	\N	10	6659
Белгородская область	Белгород	0	Святославка	\N	Ракитянского	\N	156545	\N	09-15	Вс, Пн, Пт	\N	\N	\N	10	6668
Белгородская область	Белгород	0	Солдатское	\N	Ракитянского	\N	156545	\N	09-17	Вс, Пн, Пт	\N	\N	\N	10	6694
Белгородская область	Белгород	0	Трефиловка	\N	Ракитянского	\N	156545	\N	09-16	Вс, Пн	\N	\N	\N	10	6762
Белгородская область	Белгород	0	Айдар	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн	\N	\N	\N	10	6050
Белгородская область	Белгород	0	Барсучье	\N	Ровеньского	\N	156543	\N	11-14	Вс, Пн, Чт	\N	\N	\N	10	6067
Белгородская область	Белгород	0	Верхняя Серебрянка	\N	Ровеньского	\N	156543	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6123
Белгородская область	Белгород	0	Всесвятка	\N	Ровеньского	\N	156543	\N	10-14	Вс, Пн, Чт	\N	\N	\N	10	6136
Белгородская область	Белгород	0	Еремовка	\N	Ровеньского	\N	156543	\N	11-14	Вс, Пн, Чт	\N	\N	\N	10	6179
Белгородская область	Белгород	0	Жабское	\N	Ровеньского	\N	156543	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6180
Белгородская область	Белгород	0	Ивановка	\N	Ровеньского	\N	156543	\N	12-14	Вс, Пн, Чт	\N	\N	\N	10	6221
Белгородская область	Белгород	0	Клименково	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6298
Белгородская область	Белгород	0	Копанки	\N	Ровеньского	\N	156543	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6329
Белгородская область	Белгород	0	Ладомировка	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6398
Белгородская область	Белгород	0	Лихолюбово	\N	Ровеньского	\N	156543	\N	11-13	Вс, Пн, Чт	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Лозная	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6413
Белгородская область	Белгород	0	Лозовое	\N	Ровеньского	\N	156543	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6416
Белгородская область	Белгород	0	Масловка	\N	Ровеньского	\N	156543	\N	13-16	Вс, Пн, Пт	\N	\N	\N	10	6468
Белгородская область	Белгород	0	Нагольное	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн	\N	\N	\N	10	6493
Белгородская область	Белгород	0	Нагорье	\N	Ровеньского	\N	156543	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6495
Белгородская область	Белгород	0	Нижняя Серебрянка	\N	Ровеньского	\N	156543	\N	10-13	Вс, Пн, Чт	\N	\N	\N	10	6511
Белгородская область	Белгород	0	Новоалександровка	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6543
Белгородская область	Белгород	0	Пристень	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6626
Белгородская область	Белгород	0	Ржевка	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6650
Белгородская область	Белгород	0	Ровеньки	\N	Ровеньского	ц	156543	ТГ	07-21	\N	ЛИ-7343-17	13.07.2017	\N	10	284
Белгородская область	Белгород	0	Свистовка	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6667
Белгородская область	Белгород	0	Харьковское	\N	Ровеньского	\N	156543	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6800
Белгородская область	Белгород	0	Архангельское	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6061
Белгородская область	Белгород	0	Верхнечуфичево	\N	Старооскольского	\N	156651	\N	09-13	Вс, Пн	\N	\N	\N	10	6119
Белгородская область	Белгород	0	Владимировка	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6129
Белгородская область	Белгород	0	Городище	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6152
Белгородская область	Белгород	0	Дмитриевка	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6166
Белгородская область	Белгород	0	Долгая Поляна	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6169
Белгородская область	Белгород	0	Знаменка	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6215
Белгородская область	Белгород	0	Ивановка	\N	Старооскольского	\N	156651	\N	10-16	Вс, Пн	\N	\N	\N	10	6220
Белгородская область	Белгород	0	Казачок	\N	Старооскольского	\N	156651	\N	08-16	Вс, Пн	\N	\N	\N	10	6241
Белгородская область	Белгород	0	Каплино	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6272
Белгородская область	Белгород	0	Котово	\N	Старооскольского	\N	156651	\N	08-16	Вс, Пн	\N	\N	\N	10	6336
Белгородская область	Белгород	0	Круглое	\N	Старооскольского	\N	156651	\N	09-16	Вс, Пн	\N	\N	\N	10	6376
Белгородская область	Белгород	0	Лапыгино	\N	Старооскольского	\N	156651	\N	08-16	Вс, Пн	\N	\N	\N	10	6402
Белгородская область	Белгород	0	Незнамово	\N	Старооскольского	\N	156651	\N	08-16	Вс, Пн	\N	\N	\N	10	6498
Белгородская область	Белгород	0	Нижнечуфичево	\N	Старооскольского	\N	156651	\N	09-13	Вс, Пн	\N	\N	\N	10	6505
Белгородская область	Белгород	0	Обуховка	\N	Старооскольского	\N	156651	\N	08-12	Вс, Пн	\N	\N	\N	10	6556
Белгородская область	Белгород	0	Озерки	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6559
Белгородская область	Белгород	0	Песчанка	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6579
Белгородская область	Белгород	0	Петровский	\N	Старооскольского	\N	156651	\N	11-15	Вс, Пн	\N	\N	\N	10	6586
Белгородская область	Белгород	0	Потудань	\N	Старооскольского	\N	156651	\N	10-15	Вс, Пн	\N	\N	\N	10	6614
Белгородская область	Белгород	0	Преображенка	\N	Старооскольского	\N	156651	\N	10-14	Вс, Пн	\N	\N	\N	10	6621
Белгородская область	Белгород	0	Роговатое	\N	Старооскольского	\N	156651	\N	09-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Солдатское	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6695
Белгородская область	Белгород	0	Сорокино	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6728
Белгородская область	Белгород	0	Старый Оскол	\N	Старооскольского	ц	156651	ТГ	07-21	\N	ЛИ-7350-17	13.07.2017	\N	10	265
Белгородская область	Белгород	0	Терехово	\N	Старооскольского	\N	156651	\N	08-12	Вс, Пн	\N	\N	\N	10	6747
Белгородская область	Белгород	0	Федосеевка	\N	Старооскольского	\N	156651	\N	08-16	Вс, Пн	\N	\N	\N	10	6788
Белгородская область	Белгород	0	Шаталовка	\N	Старооскольского	\N	156651	\N	09-17	Вс, Пн	\N	\N	\N	10	6849
Белгородская область	Белгород	0	Александровка	\N	Чернянского	\N	156517	\N	09-16	Пн, Чт, Вс	\N	\N	\N	10	6053
Белгородская область	Белгород	0	Андреевка	\N	Чернянского	\N	156517	\N	09-17	Пн, Чт, Вс	\N	\N	\N	10	6057
Белгородская область	Белгород	0	Большое	\N	Чернянского	\N	156517	\N	09-15	Пн, Чт, Вс	\N	\N	\N	10	6098
Белгородская область	Белгород	0	Бородин	\N	Чернянского	\N	156517	\N	09-14	Пн, Чт, Вс	\N	\N	\N	10	6104
Белгородская область	Белгород	0	Верхне Кузькино	\N	Чернянского	\N	156517	\N	09-17	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Волково	\N	Чернянского	\N	156517	\N	09-16	Пн, Чт, Вс	\N	\N	\N	10	6132
Белгородская область	Белгород	0	Волоконовка	\N	Чернянского	\N	156517	\N	08-15	Пн, Чт, Вс	\N	\N	\N	10	6133
Белгородская область	Белгород	0	Волотово	\N	Чернянского	\N	156517	\N	08-17	Вс, Пн	\N	\N	\N	10	6134
Белгородская область	Белгород	0	Ездочное	\N	Чернянского	\N	156517	\N	08-17	Вс, Пн	\N	\N	\N	10	6178
Белгородская область	Белгород	0	Ковылено	\N	Чернянского	\N	156517	\N	08-15	Вс, Пн	\N	\N	\N	10	6305
Белгородская область	Белгород	0	Кочегуры	\N	Чернянского	\N	156517	\N	09-17	Вс, Пн	\N	\N	\N	10	6338
Белгородская область	Белгород	0	Ларисовка	\N	Чернянского	\N	156517	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6405
Белгородская область	Белгород	0	Лозное	\N	Чернянского	\N	156517	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6415
Белгородская область	Белгород	0	Лубяное	\N	Чернянского	\N	156517	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6423
Белгородская область	Белгород	0	Малотроицкое	\N	Чернянского	\N	156517	\N	08-17	Вс, Пн	\N	\N	\N	10	6440
Белгородская область	Белгород	0	Новая Масловка	\N	Чернянского	\N	156517	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Новоречье	\N	Чернянского	\N	156517	\N	09-17	Вс, Пн	\N	\N	\N	10	6547
Белгородская область	Белгород	0	Огибное	\N	Чернянского	\N	156517	\N	09-17	Вс, Пн	\N	\N	\N	10	6557
Белгородская область	Белгород	0	Окуни	\N	Чернянского	\N	156517	\N	08-17	Вс, Пн, Чт	\N	\N	\N	10	6561
Белгородская область	Белгород	0	Ольшанка	\N	Чернянского	\N	156517	\N	09-17	Вс, Пн	\N	\N	\N	10	6567
Белгородская область	Белгород	0	Орлик	\N	Чернянского	\N	156517	\N	08-16	Вс, Пн	\N	\N	\N	10	6568
Белгородская область	Белгород	0	Русская Халань	\N	Чернянского	\N	156517	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6660
Белгородская область	Белгород	0	Холки	\N	Чернянского	\N	156517	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6810
Белгородская область	Белгород	0	Чернянка	\N	Чернянского	ц	156517	ТГ	07-21	\N	ЛИ-7344-17	13.07.2017	\N	10	6785
Белгородская область	Белгород	0	Чернянка-1	\N	Чернянского	\N	156517	\N	08-20	\N	\N	\N	\N	10	6837
Белгородская область	Белгород	0	Чернянка-2	\N	Чернянского	\N	156517	\N	08-20	\N	\N	\N	\N	10	6839
Белгородская область	Белгород	0	Александровка	\N	Шебекинского	\N	156514	\N	09-15	Вс, Пн	\N	\N	\N	10	6054
Белгородская область	Белгород	0	Архангельское	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6062
Белгородская область	Белгород	0	Белый Колодец	\N	Шебекинского	\N	156514	\N	08-14	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Белянка	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6076
Белгородская область	Белгород	0	Бершаково	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6081
Белгородская область	Белгород	0	Большетроицкое	\N	Шебекинского	\N	156514	ТГ	08-16	Вс, Пн	\N	\N	\N	10	4779
Белгородская область	Белгород	0	Большое Городище	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6099
Белгородская область	Белгород	0	Булановка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6107
Белгородская область	Белгород	0	Верхнее Березово	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6117
Белгородская область	Белгород	0	Вознесеновка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6131
Белгородская область	Белгород	0	Графовка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6156
Белгородская область	Белгород	0	Дмитриевка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6167
Белгородская область	Белгород	0	Зиборовка	\N	Шебекинского	\N	156514	\N	08-14	Вс, Пн	\N	\N	\N	10	6200
Белгородская область	Белгород	0	Зимовное	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6208
Белгородская область	Белгород	0	Караичное	\N	Шебекинского	\N	156514	\N	09-15	Вс, Пн	\N	\N	\N	10	6273
Белгородская область	Белгород	0	Козьмодемьяновка	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6308
Белгородская область	Белгород	0	Кошлаково	\N	Шебекинского	\N	156514	\N	09-16	Вс, Пн	\N	\N	\N	10	6342
Белгородская область	Белгород	0	Крапивное	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6346
Белгородская область	Белгород	0	Красная Поляна	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6349
Белгородская область	Белгород	0	Красное	\N	Шебекинского	\N	156514	\N	09-16	Вс, Пн	\N	\N	\N	10	6363
Белгородская область	Белгород	0	Купино	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6393
Белгородская область	Белгород	0	Максимовка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6435
Белгородская область	Белгород	0	Маломихайловка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6441
Белгородская область	Белгород	0	Маслова Пристань	\N	Шебекинского	\N	156514	ТГ	08-16	Вс, Пн	\N	\N	\N	10	4785
Белгородская область	Белгород	0	Мешковое	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6481
Белгородская область	Белгород	0	Муром	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6488
Белгородская область	Белгород	0	Никольское	\N	Шебекинского	\N	156514	\N	08-15	Вс, Пн	\N	\N	\N	10	6526
Белгородская область	Белгород	0	Новая Товалжанка	\N	Шебекинского	\N	156514	ТГ	08-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Первое Цепляево	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6577
Белгородская область	Белгород	0	Ржевка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6648
Белгородская область	Белгород	0	Середа	\N	Шебекинского	\N	156514	\N	09-15	Вс, Пн	\N	\N	\N	10	6682
Белгородская область	Белгород	0	Стариково	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6735
Белгородская область	Белгород	0	Стрелица Вторая	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6739
Белгородская область	Белгород	0	Червона Дибровка	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	ЛИ-9787-17	13.09.2017	\N	10	\N
Белгородская область	Белгород	0	Чураево	\N	Шебекинского	\N	156514	\N	08-16	Вс, Пн	\N	\N	\N	10	6845
Белгородская область	Белгород	0	Шебекино	\N	Шебекинского	ц	156514	ТГ	07-21	\N	ЛИ-7345-17	13.07.2017	\N	10	286
Белгородская область	Белгород	0	Алексеевка	\N	Яковлевского	\N	156555	\N	08-16	Вс, Пн	\N	\N	\N	10	6056
Белгородская область	Белгород	0	Бутово	\N	Яковлевского	\N	156555	\N	09-17	Вс, Пн	\N	\N	\N	10	6106
Белгородская область	Белгород	0	Быково	\N	Яковлевского	\N	156555	\N	09-10	Вс, Пн	\N	\N	\N	10	6105
Белгородская область	Белгород	0	Верхний Ольшанец	\N	Яковлевского	\N	156555	\N	10-14	Вс, Пн, Чт	\N	\N	\N	10	6121
Белгородская область	Белгород	0	Гостищево	\N	Яковлевского	\N	156555	\N	09-13	Вс, Ср, Чт	\N	\N	\N	10	6153
Белгородская область	Белгород	0	Дмитриевка	\N	Яковлевского	\N	156555	\N	09-15	Вс, Пн	\N	\N	\N	10	6168
Белгородская область	Белгород	0	Драгунка	\N	Яковлевского	\N	156555	\N	08-12	Вс, Пн	\N	\N	\N	10	6175
Белгородская область	Белгород	0	Завидовка	\N	Яковлевского	\N	156555	\N	09-16	Вс, Пн	\N	\N	\N	10	6187
Белгородская область	Белгород	0	Казацкое	\N	Яковлевского	\N	156555	\N	09-12	Вс, Пн	\N	\N	\N	10	6240
Белгородская область	Белгород	0	Калинино	\N	Яковлевского	\N	156555	\N	09-12	Вс, Пн	\N	\N	\N	10	6247
Белгородская область	Белгород	0	Кривцово	\N	Яковлевского	\N	156555	\N	09-16	Вс, Пн	\N	\N	\N	10	6374
Белгородская область	Белгород	0	Локня	\N	Яковлевского	\N	156555	\N	10-12	Вс, Пн	\N	\N	\N	10	6418
Белгородская область	Белгород	0	Мощеное	\N	Яковлевского	\N	156555	\N	09-13	Вс, Пн	\N	\N	\N	10	6486
Белгородская область	Белгород	0	Новая Глинка	\N	Яковлевского	\N	156555	\N	10-14	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Сажное	\N	Яковлевского	\N	156555	\N	11-14	Вс, Пн	\N	\N	\N	10	6662
Белгородская область	Белгород	0	Серетино	\N	Яковлевского	\N	156555	\N	09-16	Вс, Пн	\N	\N	\N	10	6683
Белгородская область	Белгород	0	Смородино	\N	Яковлевского	\N	156555	\N	10-13	Вс, Пн	\N	\N	\N	10	6690
Белгородская область	Белгород	0	Ст.Сажное	\N	Яковлевского	\N	156555	\N	09-15	Вс, Пн	\N	\N	\N	10	6733
Белгородская область	Белгород	0	Стрелецкое	\N	Яковлевского	\N	156555	\N	08-16	Вс, Пн	\N	\N	\N	10	6738
Белгородская область	Белгород	0	Строитель	\N	Яковлевского	\N	156555	ТГ	07-21	\N	\N	\N	\N	10	285
Белгородская область	Белгород	0	Терновка	\N	Яковлевского	\N	156555	\N	08-16	\N	\N	\N	\N	10	6749
Белгородская область	Белгород	0	Томаровка	\N	Яковлевского	\N	156555	\N	07-19	Вс	\N	\N	\N	10	6760
Белгородская область	Белгород	0	Черкассы	\N	Яковлевского	\N	156555	\N	11-13	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Яковлево	\N	Яковлевского	ц	156555	\N	08-20	\N	ЛИ-7346-17	13.07.2017	\N	10	6877
Брянская область	Брянск	0	Брасово	\N	Брасовского	\N	182533	\N	09-17	Вс, Пн	ЛИ-5880-17	30.06.2017	\N	11	6971
Брянская область	Брянск	0	Веребское	\N	Брасовского	\N	182533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-5881-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Глоднево	\N	Брасовского	\N	182533	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5961-17	30.06.2017	\N	11	7061
Брянская область	Брянск	0	Городище 2-е	\N	Брасовского	\N	182533	\N	09-16 Сб 10-15	Вс, Пн	ЛИ-5962-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Добрик	\N	Брасовского	\N	182533	\N	09-17	Пн, Ср, Вс	ЛИ-5963-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Дубровка	\N	Брасовского	\N	182533	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5964-17	30.06.2017	\N	11	7164
Брянская область	Брянск	0	Красное	\N	Брасовского	\N	182533	\N	09-16 Сб 10-15	Вс, Пн	ЛИ-5965-17	30.06.2017	\N	11	7290
Брянская область	Брянск	0	Красный Колодец	\N	Брасовского	\N	182533	\N	09-17	Вс, Пн	ЛИ-5966-17	30.06.2017	\N	11	7299
Брянская область	Брянск	0	Крупец	\N	Брасовского	\N	182533	\N	09-16	Пн, Ср, Вс	ЛИ-5967-17	30.06.2017	\N	11	7306
Брянская область	Брянск	0	Локоть	\N	Брасовского	ц	182533	ТГ	Вс 09.00-14.00 Пн, Вт, Ср, Чт, Пт 08.00-20.00 Сб 09.00-18.00	\N	ЛИ-747-16	30.12.1899	\N	11	302
Брянская область	Брянск	0	Осотское	\N	Брасовского	\N	182533	\N	12.30-15	Пн, Ср, Пт, Вс	ЛИ-5968-17	30.06.2017	\N	11	7491
Брянская область	Брянск	0	Погребы	\N	Брасовского	\N	182533	\N	08-16 Сб 09-16	Вс, Пн	ЛИ-5970-17	30.06.2017	\N	11	7512
Брянская область	Брянск	0	Сныткино	\N	Брасовского	\N	182533	\N	09-17	Пн, Ср, Вс	ЛИ-5971-17	30.06.2017	\N	11	7583
Брянская область	Брянск	0	Столбово	\N	Брасовского	\N	182533	\N	10-16.20	Пн, Ср, Пт, Вс	ЛИ-5972-17	30.06.2017	\N	11	7609
Брянская область	Брянск	0	Холмечь	\N	Брасовского	\N	182533	\N	12.35-13.05	Пн, Ср, Пт, Вс	ЛИ-5973-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Хотеева	\N	Брасовского	\N	182533	\N	10-16.20	Пн, Ср, Пт, Вс	ЛИ-5974-17	30.06.2017	\N	11	7648
Брянская область	Брянск	0	Чаянка	\N	Брасовского	\N	182533	\N	10-16.20	Пн, Ср, Пт, Вс	ЛИ-5975-17	30.06.2017	\N	11	7655
Брянская область	Брянск	0	Брянск, кроме Брянск-18	\N	\N	\N	182ххх	ТГ	08-20	\N	ЛИ-1209-18	21.06.2018	\N	11	\N
Брянская область	Брянск	0	Бетово	\N	Брянского	\N	182035	\N	08-18.30	Пн, Ср, Пт, Вс	ЛИ-5943-17	30.06.2017	\N	11	6584
Брянская область	Брянск	0	Большое Полпино	\N	Брянского	\N	182022	\N	08-17	Вс, Пн	ЛИ-13080-17	18.01.2018	\N	11	6532
Брянская область	Брянск	0	Ботогово	\N	Брянского	\N	182050	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5944-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Глинищево	\N	Брянского	\N	182035	\N	08-17	Пн, Вс	ЛИ-5899-17	30.06.2017	\N	11	11574
Брянская область	Брянск	0	Добрунь	\N	Брянского	\N	182050	\N	09-17	Вс, Пн	ЛИ-5901-17	30.06.2017	\N	11	11500
Брянская область	Брянск	0	Домашово	\N	Брянского	\N	182553	\N	08-18.30	Пн, Ср, Пт, Вс	ЛИ-5945-17	30.06.2017	\N	11	7155
Брянская область	Брянск	0	Журиничи	\N	Брянского	\N	182050	\N	08-18.30	Пн, Ср, Пт, Вс	ЛИ-5946-17	30.06.2017	\N	11	7192
Брянская область	Брянск	0	Малое Полпино	\N	Брянского	\N	182050	\N	10-19	Пн, Ср, Пт, Вс	ЛИ-5947-17	30.06.2017	\N	11	7379
Брянская область	Брянск	0	Мирный	\N	Брянского	\N	182050	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-5949-17	30.06.2017	\N	11	7396
Брянская область	Брянск	0	Мичуринский	\N	Брянского	\N	182035	\N	09-17 Пн 09-16	Вт, Вс	ЛИ-5950-17	30.06.2017	\N	11	11386
Брянская область	Брянск	0	Нетьинка	\N	Брянского	\N	182035	\N	09-17 Пн 09-16	Вт, Вс	ЛИ-5951-17	30.06.2017	\N	11	7454
Брянская область	Брянск	0	Новоселки	\N	Брянского	\N	182050	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5948-17	30.06.2017	\N	11	7467
Брянская область	Брянск	0	Новые Дарковичи	\N	Брянского	\N	182035	\N	09-17	Вт, Вс	ЛИ-5952-17	30.06.2017	\N	11	11377
Архангельская область	Архангельск	0	Обозерский-1	\N	Плесецкого	\N	242525	\N	10-17 Сб 10-12	Вс	\N	\N	\N	6	5397
Архангельская область	Архангельск	0	Оксовский	\N	Плесецкого	\N	242525	\N	10-17 Сб 10-15	Вс	\N	\N	\N	6	5396
Архангельская область	Архангельск	0	Плесецк	\N	Плесецкого	\N	242525	ТГ	10-18	Сб, Вс	\N	\N	\N	6	155
Архангельская область	Архангельск	0	Подволочье	\N	Плесецкого	\N	242525	\N	10-16	Пн, Вс	\N	\N	\N	6	5718
Архангельская область	Архангельск	0	Поча	\N	Плесецкого	\N	242525	\N	08-19	Пн, Вс	\N	\N	\N	6	5726
Архангельская область	Архангельск	0	Пукса	\N	Плесецкого	\N	242525	\N	08-19	Пн, Вс	\N	\N	\N	6	5731
Архангельская область	Архангельск	0	Пуксоозеро	\N	Плесецкого	\N	242525	\N	10-19	Вс	\N	\N	\N	6	16261
Архангельская область	Архангельск	0	Савинский	\N	Плесецкого	\N	242525	\N	10-16 Сб 10-14	Вс	\N	\N	\N	6	161
Архангельская область	Архангельск	0	Самково	\N	Плесецкого	\N	242525	\N	08-19	Пн, Вс	\N	\N	\N	6	5752
Архангельская область	Архангельск	0	Самодед	\N	Плесецкого	\N	242525	\N	10-19	Вс	\N	\N	\N	6	5757
Архангельская область	Архангельск	0	Североонежск	\N	Плесецкого	\N	242525	\N	10-16 Сб 10-14	Вс	\N	\N	\N	6	162
Архангельская область	Архангельск	0	Улитино	\N	Плесецкого	\N	242525	\N	08-19	Пн, Вс	\N	\N	\N	6	5843
Архангельская область	Архангельск	0	Усть-Поча	\N	Плесецкого	\N	242525	\N	10-16	Пн, Вс	\N	\N	\N	6	16275
Архангельская область	Архангельск	0	Федово	\N	Плесецкого	\N	242525	\N	08-19 Сб 10-14	Пн, Вс	\N	\N	\N	6	5857
Архангельская область	Архангельск	0	Швакино	\N	Плесецкого	\N	242525	\N	10-13	Вт, Вс	\N	\N	\N	6	5878
Архангельская область	Архангельск	0	Беломорье	\N	Приморского	\N	242562	\N	09-17 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	6	5484
Архангельская область	Архангельск	0	Боброво	\N	Приморского	\N	242911	\N	09-17 Сб 09-13	Вс, Пн	\N	\N	\N	6	5491
Архангельская область	Архангельск	0	Верхняя Золотица	\N	Приморского	\N	242911	\N	10-16	Сб, Вс	\N	\N	\N	6	5517
Архангельская область	Архангельск	0	Вознесенье	\N	Приморского	\N	242911	\N	08-16 Сб 09-13	Вс, Пн	\N	\N	\N	6	5528
Архангельская область	Архангельск	0	Катунино	\N	Приморского	\N	242911	\N	08-16 Сб 08-13	Вс, Пн	\N	\N	\N	6	5585
Архангельская область	Архангельск	0	Лайский Док	\N	Приморского	\N	242911	\N	09-16 Сб 09-14	Вс, Пн	\N	\N	\N	6	5628
Архангельская область	Архангельск	0	Ластола	\N	Приморского	\N	242911	\N	09-14 Сб 09-13	Пт, Вс, Пн	\N	\N	\N	6	5631
Архангельская область	Архангельск	0	Летняя Золотица	\N	Приморского	\N	242911	\N	07-11 16-20	Ср, Вс	\N	\N	\N	6	5639
Архангельская область	Архангельск	0	Лопшеньга	\N	Приморского	\N	242911	\N	07-11 16-20	Ср, Вс	\N	\N	\N	6	5646
Архангельская область	Архангельск	0	Нижняя Золотица	\N	Приморского	\N	242911	\N	09-13	Вт, Сб, Вс	\N	\N	\N	6	5675
Архангельская область	Архангельск	0	Пертоминск	\N	Приморского	\N	242911	\N	08.30-17	Сб, Вс	\N	\N	\N	6	153
Архангельская область	Архангельск	0	Пустошь	\N	Приморского	\N	242911	\N	09-16	Вс, Пн	\N	\N	\N	6	5734
Архангельская область	Архангельск	0	Рикасиха	\N	Приморского	\N	242911	\N	10-17 Сб 10-14	Вс, Пн	\N	\N	\N	6	5741
Архангельская область	Архангельск	0	Рикасово	\N	Приморского	\N	242911	\N	08-16 Сб 08-14	Вс, Пн	\N	\N	\N	6	5743
Архангельская область	Архангельск	0	Соловецкий	\N	Приморского	\N	242911	\N	10-17 Сб 10-15	Вс	\N	\N	\N	6	\N
Архангельская область	Архангельск	0	Талаги	\N	Приморского	\N	242911	\N	10-17 Сб 10-13	Вс, Пн	\N	\N	\N	6	5799
Архангельская область	Архангельск	0	Уемский	\N	Приморского	\N	242911	\N	09-17 Сб 09-14	Вс, Пн	\N	\N	\N	6	16273
Архангельская область	Архангельск	0	Уна	\N	Приморского	\N	242911	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5845
Архангельская область	Архангельск	0	Хорьково	\N	Приморского	\N	242911	\N	08-16 Сб 08-13	Вс, Пн	\N	\N	\N	6	5865
Архангельская область	Архангельск	0	Часовенская	\N	Приморского	\N	242911	\N	10-15	Пн, Вт, Ср, Сб, Вс	\N	\N	\N	6	5871
Архангельская область	Архангельск	0	Чуб Наволок	\N	Приморского	\N	242911	\N	12-14	Пн, Вт, Ср, Пт, Вс	\N	\N	\N	6	5874
Архангельская область	Архангельск	0	Яреньга	\N	Приморского	\N	242911	\N	07-11 16-20	Ср, Вс	\N	\N	\N	6	5899
Архангельская область	Архангельск	0	Северодвинск	\N	\N	г	242511	ТГ	08-21 Сб 10-17	Вс	ЛИ-7038-17	12.07.2017	\N	6	114
Архангельская область	Архангельск	0	Волость	\N	Северодвинского	\N	242511	\N	09-16	Пн, Ср, Чт, Сб, Вс	\N	\N	\N	6	5529
Архангельская область	Архангельск	0	Ненокса	\N	Северодвинского	\N	242511	\N	09-17	Сб, Вс	\N	\N	\N	6	145
Архангельская область	Архангельск	0	Солза	\N	Северодвинского	\N	276911	\N	Чт 09-17	Пн, Вт, Ср, Пт, Сб, Вс	\N	\N	\N	6	5780
Архангельская область	Архангельск	0	Алферовская	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5472
Архангельская область	Архангельск	0	Березник	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5486
Архангельская область	Архангельск	0	Бестужево	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5489
Архангельская область	Архангельск	0	Богдановский	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5492
Архангельская область	Архангельск	0	Вежа	\N	Устьянского	\N	242576	\N	07-11 16-20 Сб 07-11	Вс, Пн	\N	\N	\N	6	5445
Архангельская область	Архангельск	0	Выселок Горская	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	ЛИ-8853-17	22.08.2017	\N	6	\N
Архангельская область	Архангельск	0	Глубокий	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5540
Архангельская область	Архангельск	0	Грунцовская	\N	Устьянского	\N	242576	\N	07-11 16-20 Сб 07-11	Вс, Пн	\N	\N	\N	6	5547
Архангельская область	Архангельск	0	Дубровская	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5554
Архангельская область	Архангельск	0	Илеза	\N	Устьянского	\N	242576	\N	09-17	\N	\N	\N	\N	6	115
Архангельская область	Архангельск	0	Кадыевская	\N	Устьянского	\N	242576	\N	07-15	Ср, Сб, Вс	\N	\N	\N	6	5580
Архангельская область	Архангельск	0	Казово	\N	Устьянского	\N	242576	\N	07-13	Пн, Вс	\N	\N	\N	6	5424
Архангельская область	Архангельск	0	Квазеньга	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5587
Архангельская область	Архангельск	0	Кидюга	\N	Устьянского	\N	242576	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5591
Архангельская область	Архангельск	0	Кизема	\N	Устьянского	\N	242576	\N	09-17	Вс	\N	\N	\N	6	129
Архангельская область	Архангельск	0	Кондратовская	\N	Устьянского	\N	242576	\N	07-11 16-20 Сб 07-11	Пн, Вс	\N	\N	\N	6	5606
Архангельская область	Архангельск	0	Костылево	\N	Устьянского	\N	242576	\N	10-17	Вс, Пн, Ср	\N	\N	\N	6	131
Архангельская область	Архангельск	0	Красный Бор	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Пт, Вс	\N	\N	\N	6	5615
Архангельская область	Архангельск	0	Лево-Плосская	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5633
Архангельская область	Архангельск	0	Лойга	\N	Устьянского	\N	242576	\N	09-16	Вс, Ср	\N	\N	\N	6	140
Архангельская область	Архангельск	0	Михалево	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5662
Архангельская область	Архангельск	0	Нагорская	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5669
Архангельская область	Архангельск	0	Октябрьский	\N	Устьянского	\N	242576	ТГ	09-17 Пт 09-15.30	Сб, Вс	\N	\N	\N	6	151
Архангельская область	Архангельск	0	Первомайский	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Пт, Вс	\N	\N	\N	6	5707
Архангельская область	Архангельск	0	Спасская	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5792
Архангельская область	Архангельск	0	Строевское	\N	Устьянского	\N	242576	\N	08-17	Сб, Вс	\N	\N	\N	6	166
Архангельская область	Архангельск	0	Студенец	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5795
Архангельская область	Архангельск	0	Ульюха	\N	Устьянского	\N	242576	\N	07-12 16-20	Пн, Ср, Вс	\N	\N	\N	6	5844
Архангельская область	Архангельск	0	Филинская	\N	Устьянского	\N	242576	\N	07-11 17-19	Пн, Вс	\N	\N	\N	6	5860
Архангельская область	Архангельск	0	Чадрома	\N	Устьянского	\N	242576	\N	08-11 13-17 Ср, Пт 07-14	Пн, Вс	\N	\N	\N	6	5869
Архангельская область	Архангельск	0	Шангалы	\N	Устьянского	\N	242576	\N	09-17	Вс, Пн	\N	\N	\N	6	179
Архангельская область	Архангельск	0	Шурай	\N	Устьянского	\N	242576	\N	07-11 16-20 Сб 07-11	Вт, Вс	\N	\N	\N	6	16290
Архангельская область	Архангельск	0	Юрятинская	\N	Устьянского	\N	242576	\N	07-11 16-20	Пн, Вс	\N	\N	\N	6	5895
Архангельская область	Архангельск	0	Eмецк	\N	Холмогорского	\N	242571	\N	09-17	Сб, Вс	ЛИ-8222-17	15.08.2017	\N	6	\N
Архангельская область	Архангельск	0	Анашкино	\N	Холмогорского	\N	242571	\N	09-16	Вс, Пн	\N	\N	\N	6	5474
Архангельская область	Архангельск	0	Андриановская	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-15	Вс, Пн	\N	\N	\N	6	5477
Архангельская область	Архангельск	0	Белогорский	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-14	Вс, Пн	\N	\N	\N	6	5483
Архангельская область	Архангельск	0	Волочек	\N	Холмогорского	\N	242571	\N	09-16 Сб 09-15	Вс, Пн	\N	\N	\N	6	5530
Архангельская область	Архангельск	0	Горка	\N	Холмогорского	\N	242571	\N	09-12	Ср, Вс, Пн	\N	\N	\N	6	5541
Архангельская область	Архангельск	0	Григоровская	\N	Холмогорского	\N	242571	\N	09-16 Сб 09-13	Вс	\N	\N	\N	6	5545
Архангельская область	Архангельск	0	Данилово	\N	Холмогорского	\N	242571	\N	09-16 Сб 09-14	Вс, Пн	\N	\N	\N	6	5430
Архангельская область	Архангельск	0	Двинской	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-13	Вс, Пн	\N	\N	\N	6	5550
Архангельская область	Архангельск	0	Зачачье	\N	Холмогорского	\N	242571	\N	09-16 Сб 09-13	Вс, Пн	\N	\N	\N	6	5568
Архангельская область	Архангельск	0	Казенщина	\N	Холмогорского	\N	242571	\N	10-14	Вт, Вс, Пн	\N	\N	\N	6	5582
Архангельская область	Архангельск	0	Копачево	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-15	Вс, Пн	\N	\N	\N	6	5609
Архангельская область	Архангельск	0	Кузомень	\N	Холмогорского	\N	242571	\N	09-14 Сб 09-12	Пт, Вс, Пн	\N	\N	\N	6	5618
Архангельская область	Архангельск	0	Ломоносово	\N	Холмогорского	\N	242571	\N	09-16	Вс, Пн	\N	\N	\N	6	5645
Архангельская область	Архангельск	0	Луковецкий	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-15	Вс, Пн	\N	\N	\N	6	5648
Архангельская область	Архангельск	0	Одиночка	\N	Холмогорского	\N	242571	\N	09-14	Вс, Пн	\N	\N	\N	6	5680
Архангельская область	Архангельск	0	Орлецы	\N	Холмогорского	\N	242571	\N	10-14	Сб, Вс, Пн	\N	\N	\N	6	5685
Архангельская область	Архангельск	0	Осередок	\N	Холмогорского	\N	242571	\N	09-12	Вс, Пн	\N	\N	\N	6	5686
Архангельская область	Архангельск	0	Палово	\N	Холмогорского	\N	242571	\N	09-14	Вс, Пн, Вт, Пт	\N	\N	\N	6	5696
Архангельская область	Архангельск	0	Пиньгиша	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-13	Вс, Пн	\N	\N	\N	6	5711
Архангельская область	Архангельск	0	Погост	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-13	Вс, Пн	\N	\N	\N	6	5717
Архангельская область	Архангельск	0	Почтовое	\N	Холмогорского	\N	242571	\N	09-14	Вс, Пн	\N	\N	\N	6	5727
Архангельская область	Архангельск	0	Ракула	\N	Холмогорского	\N	242571	\N	09-13	Вс, Пн	\N	\N	\N	6	5739
Архангельская область	Архангельск	0	Рембуево	\N	Холмогорского	\N	242571	\N	09-14 Сб 09-13	Вс, Пн	\N	\N	\N	6	16263
Архангельская область	Архангельск	0	Светлый	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	6	5763
Архангельская область	Архангельск	0	Товра	\N	Холмогорского	\N	242571	\N	09-12 Сб 09-13	Вс, Пн	\N	\N	\N	6	5834
Архангельская область	Архангельск	0	Усть-Пинега	\N	Холмогорского	\N	242571	\N	09-16 Сб 09-15	Вс, Пн	\N	\N	\N	6	5853
Архангельская область	Архангельск	0	Хаврогоры	\N	Холмогорского	\N	242571	\N	09-17 Сб 09-14	Вс, Пн	\N	\N	\N	6	5862
Архангельская область	Архангельск	0	Холмогоры	\N	Холмогорского	\N	242571	ТГ	08.30-17 Пт 08.30-15.30	Сб, Вс	\N	\N	\N	6	176
Архангельская область	Архангельск	0	Алешковская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5471
Архангельская область	Архангельск	0	Артемьевская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5480
Архангельская область	Архангельск	0	Дывлевская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5555
Архангельская область	Архангельск	0	Ивановская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5574
Архангельская область	Архангельск	0	Керзеньга	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5590
Архангельская область	Архангельск	0	Клемушино	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5421
Архангельская область	Архангельск	0	Красная Горка	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5613
Архангельская область	Архангельск	0	Куликовское	\N	Шенкурского	\N	242565	\N	11-15	Вс, Пн	\N	\N	\N	6	5621
Архангельская область	Архангельск	0	Никифоровская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5405
Архангельская область	Архангельск	0	Одинцовская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5681
Архангельская область	Архангельск	0	Плесо	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5714
Архангельская область	Архангельск	0	Раковская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	16262
Архангельская область	Архангельск	0	Ровдино	\N	Шенкурского	\N	242565	\N	09-16	Вс	\N	\N	\N	6	5744
Архангельская область	Архангельск	0	Россохи	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	16264
Архангельская область	Архангельск	0	Рыбогорская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5749
Архангельская область	Архангельск	0	Тронинская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5837
Архангельская область	Архангельск	0	Уколок	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5842
Архангельская область	Архангельск	0	Усть-Паденьга	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5852
Архангельская область	Архангельск	0	Ушаковская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5856
Архангельская область	Архангельск	0	Чушевская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5876
Архангельская область	Архангельск	0	Шахановка	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	16282
Архангельская область	Архангельск	0	Шеговары	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5879
Архангельская область	Архангельск	0	Шелаша	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5880
Архангельская область	Архангельск	0	Шенкурск	\N	Шенкурского	\N	242565	ТГ	08.30-17 Пт 08.30-13	Сб, Вс	\N	\N	\N	6	180
Архангельская область	Архангельск	0	Шипуновская	\N	Шенкурского	\N	242565	\N	07-11 16-20	Вс, Пн	\N	\N	\N	6	5885
Астраханская область	Астрахань	+1	Астрахань	\N	\N	г	254000	ТГ	Пн, Вт, Ср, Чт, Пт, Сб, Вс 08-20	\N	ЛИ-1553-17	30.12.1899	\N	7	183
Астраханская область	Астрахань	+1	Астрахань	\N	\N	г	254ххх	ТГ	\N	\N	ЛИ-7354-17	13.07.2017	\N	7	183
Астраханская область	Астрахань	+1	Ахтубинск	\N	Ахтубинского	ц	254511	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1562-17	30.12.1899	\N	7	185
Астраханская область	Астрахань	+1	Знаменск	\N	Ахтубинского	ц	254531	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1564-17	30.12.1899	\N	7	\N
Астраханская область	Астрахань	+1	Володарский	\N	Володарского	ц	254515	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1565-17	30.12.1899	\N	7	186
Астраханская область	Астрахань	+1	Енотаевка	\N	Енотаевского	ц	254512	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1566-17	30.12.1899	\N	7	187
Астраханская область	Астрахань	+1	Икряное	\N	Икрянинского	ц	254521	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1568-17	30.12.1899	\N	7	189
Астраханская область	Астрахань	+1	Камызяк	\N	Камызякского	ц	254513	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1569-17	30.12.1899	\N	7	190
Астраханская область	Астрахань	+1	Красный Яр	\N	Красноярского	ц	254522	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1570-17	30.12.1899	\N	7	191
Астраханская область	Астрахань	+1	Лиман	\N	Лиманского	ц	254532	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1571-17	30.12.1899	\N	7	192
Астраханская область	Астрахань	+1	Нариманов	\N	Наримановского	ц	254542	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1572-17	30.12.1899	\N	7	193
Астраханская область	Астрахань	+1	Началово	\N	Приволжского	ц	254524	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1573-17	30.12.1899	\N	7	194
Астраханская область	Астрахань	+1	Харабали	\N	Харабалинского	ц	254514	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1574-17	30.12.1899	\N	7	195
Астраханская область	Астрахань	+1	Черный Яр	\N	Черноярского	ц	254523	ТГ	Пн, Вт, Ср, Чт, Пт 08-16	Сб, Вс	ЛИ-1552-17	30.12.1899	\N	7	196
Белгородская область	Белгород	0	Алейниково	\N	Алексеевского	\N	156518	\N	09-15 Ср 09-12	Вс, Пн	\N	\N	\N	10	6052
Белгородская область	Белгород	0	Алексеевка	\N	Алексеевского	ц	156518	ТГ	08-17	Сб, Вс	ЛИ-717-16	30.12.1899	\N	10	266
Белгородская область	Белгород	0	Афанасьевка	\N	Алексеевского	\N	156518	\N	08-15 Ср 08-13	Вс, Пн	\N	\N	\N	10	6064
Белгородская область	Белгород	0	Божково	\N	Алексеевского	\N	156518	\N	09-15 Ср 09-12	Вс, Пн	\N	\N	\N	10	6092
Белгородская область	Белгород	0	Варваровка	\N	Алексеевского	\N	156518	\N	10-15 Ср 10-12	Вс, Пн	\N	\N	\N	10	6112
Белгородская область	Белгород	0	Гарбузово	\N	Алексеевского	\N	156518	\N	10-15 Ср 10-14	Вс, Пн	\N	\N	\N	10	6140
Белгородская область	Белгород	0	Глуховка	\N	Алексеевского	\N	156518	\N	09-16 Ср 09-12	Вс, Пн	\N	\N	\N	10	6144
Белгородская область	Белгород	0	Жуково	\N	Алексеевского	\N	156518	\N	08-14 Ср 08-12	Вс, Пн	\N	\N	\N	10	6182
Белгородская область	Белгород	0	Запольное	\N	Алексеевского	\N	156518	\N	10-14 Ср 10-12	Вс, Пн	\N	\N	\N	10	6195
Белгородская область	Белгород	0	Иващенково	\N	Алексеевского	\N	156518	\N	09-14 Ср 09-12	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Иловка	\N	Алексеевского	\N	156518	\N	09-17	Вс, Пн	\N	\N	\N	10	6236
Белгородская область	Белгород	0	Ильинка	\N	Алексеевского	\N	156518	\N	08-16 Ср 08-14	Вс, Пн	\N	\N	\N	10	6237
Белгородская область	Белгород	0	Калитва	\N	Алексеевского	\N	156518	\N	09-16 Ср 09-14	Вс, Пн	\N	\N	\N	10	6249
Белгородская область	Белгород	0	Камышеватое	\N	Алексеевского	\N	156518	\N	10-15 Ср 10-14	Вс, Пн	\N	\N	\N	10	6252
Белгородская область	Белгород	0	Ковалево	\N	Алексеевского	\N	156518	\N	10-14 Ср 10-13	Вс, Пн	\N	\N	\N	10	6302
Белгородская область	Белгород	0	Колтуновка	\N	Алексеевского	\N	156518	\N	10-14 Ср 10-12	Вс, Пн	\N	\N	\N	10	6319
Белгородская область	Белгород	0	Красное	\N	Алексеевского	\N	156518	\N	08-16 Ср 08-14	Вс, Пн	\N	\N	\N	10	6352
Белгородская область	Белгород	0	Луценково	\N	Алексеевского	\N	156518	\N	10-15 Ср 09-12	Вс, Пн	\N	\N	\N	10	6425
Белгородская область	Белгород	0	Матрено-Гезово	\N	Алексеевского	\N	156518	\N	08-16 Ср 08-14	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Меняйлово	\N	Алексеевского	\N	156518	\N	09-14 Ср 09-12	Вс, Пн	\N	\N	\N	10	6480
Белгородская область	Белгород	0	Мухо-Удеровка	\N	Алексеевского	\N	156518	\N	08-16 Ср 08-14	Вс, Пн	\N	\N	\N	10	6489
Белгородская область	Белгород	0	Пирогово	\N	Алексеевского	\N	156518	\N	11-14	Вс, Пн	\N	\N	\N	10	6590
Белгородская область	Белгород	0	Подсереднее	\N	Алексеевского	\N	156518	\N	08-15 Ср 08-11	Вс, Пн	\N	\N	\N	10	6605
Белгородская область	Белгород	0	Репенка	\N	Алексеевского	\N	156518	\N	09-15 Ср 09-12	Вс, Пн	\N	\N	\N	10	6639
Белгородская область	Белгород	0	Советское	\N	Алексеевского	\N	156518	\N	08-16 Ср 08-15	Вс, Пн	\N	\N	\N	10	6691
Белгородская область	Белгород	0	Тютюниково	\N	Алексеевского	\N	156518	\N	09-14 Ср 09-11	Вс, Пн	\N	\N	\N	10	6768
Белгородская область	Белгород	0	Хлевище	\N	Алексеевского	\N	156518	\N	09-16 Ср 09-12	Вс, Пн	\N	\N	\N	10	6802
Белгородская область	Белгород	0	Хрещатое	\N	Алексеевского	\N	156518	\N	10-14 Ср 10-12	Вс, Пн	\N	\N	\N	10	6825
Белгородская область	Белгород	0	Белгород	\N	\N	г	156ххх	ТГ	07-21	\N	ЛИ-7348-17	13.07.2017	\N	10	264
Белгородская область	Белгород	0	Белгород РУС	\N	Белгородского	ц	156560	ТГ	00-24	\N	ЛИ-7366-17	13.07.2017	\N	10	\N
Белгородская область	Белгород	0	Акулиновка	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6051
Белгородская область	Белгород	0	Байцуры	\N	Борисовского	\N	156532	\N	10-15	Вс, Пн, Ср	\N	\N	\N	10	6065
Белгородская область	Белгород	0	Беленькое	\N	Борисовского	\N	156532	\N	09-17	Вс, Пн	\N	\N	\N	10	6070
Белгородская область	Белгород	0	Березовка	\N	Борисовского	\N	156532	\N	09-17	Вс, Пн	\N	\N	\N	10	6079
Белгородская область	Белгород	0	Борисовка	\N	Борисовского	ц	156532	ТГ	08-21	\N	ЛИ-7330-17	13.07.2017	\N	10	267
Белгородская область	Белгород	0	Борисовка-1	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн	\N	\N	\N	10	6085
Белгородская область	Белгород	0	Борисовка-2	\N	Борисовского	\N	156532	\N	10-13	Вс, Пн	\N	\N	\N	10	6075
Белгородская область	Белгород	0	Грузское	\N	Борисовского	\N	156532	\N	09-17	Вс, Пн	\N	\N	\N	10	6157
Белгородская область	Белгород	0	Зыбино	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6216
Белгородская область	Белгород	0	Красный Куток	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6366
Белгородская область	Белгород	0	Крюково	\N	Борисовского	\N	156532	\N	09-13	Вс, Пн, Ср	\N	\N	\N	10	6387
Белгородская область	Белгород	0	Никитское	\N	Борисовского	\N	156532	\N	11-14	Вс, Пн, Ср	\N	\N	\N	10	6516
Белгородская область	Белгород	0	Новоалександровка	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6541
Белгородская область	Белгород	0	Октябрьская Готня	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6560
Белгородская область	Белгород	0	Стригуны	\N	Борисовского	\N	156532	\N	09-17	Вс, Пн	\N	\N	\N	10	6740
Белгородская область	Белгород	0	Хотмыжск	\N	Борисовского	\N	156532	\N	09-17	Вс, Пн, Ср	\N	\N	\N	10	6815
Белгородская область	Белгород	0	Чуланово	\N	Борисовского	\N	156532	\N	10-14	Вс, Пн, Ср	\N	\N	\N	10	6843
Белгородская область	Белгород	0	Бирюч	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6084
Белгородская область	Белгород	0	Борки	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6071
Белгородская область	Белгород	0	Бутырки	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6109
Белгородская область	Белгород	0	Валуйки	\N	Валуйского	ц	156511	ТГ	07-21	\N	ЛИ-7331-17	13.07.2017	\N	10	268
Белгородская область	Белгород	0	Герасимовка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6141
Белгородская область	Белгород	0	Дальнее	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6161
Белгородская область	Белгород	0	Двулучное	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6162
Белгородская область	Белгород	0	Казинка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6245
Белгородская область	Белгород	0	Казначеевка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6246
Белгородская область	Белгород	0	Конопляновка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6324
Белгородская область	Белгород	0	Кукуевка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6391
Белгородская область	Белгород	0	Лавы	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6395
Белгородская область	Белгород	0	Логачевка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6410
Белгородская область	Белгород	0	Мандрово	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6444
Белгородская область	Белгород	0	Насоново	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6496
Белгородская область	Белгород	0	Новопетровка	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6545
Белгородская область	Белгород	0	Подгорное	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6602
Белгородская область	Белгород	0	Принцевка	\N	Валуйского	\N	156511	\N	08-17	Вс, Пн	\N	\N	\N	10	6625
Белгородская область	Белгород	0	Рождествено	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6656
Белгородская область	Белгород	0	Селиваново	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6673
Белгородская область	Белгород	0	Солоти	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6698
Белгородская область	Белгород	0	Тимоново	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6754
Белгородская область	Белгород	0	Ураево	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6772
Белгородская область	Белгород	0	Уразово	\N	Валуйского	\N	156511	ТГ	07-21	\N	\N	\N	\N	10	4790
Белгородская область	Белгород	0	Уразово 1	\N	Валуйского	\N	156511	\N	10-18	Вс, Пн	ЛИ-715-16	30.12.1899	\N	10	\N
Белгородская область	Белгород	0	Уразово 4	\N	Валуйского	\N	156511	ТГ	08-21	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Хмелевец	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6804
Белгородская область	Белгород	0	Храпово	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6822
Белгородская область	Белгород	0	Шелаево	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6855
Белгородская область	Белгород	0	Яблоново	\N	Валуйского	\N	156511	\N	08-16	Вс, Пн	\N	\N	\N	10	6872
Белгородская область	Белгород	0	Белый Колодезь	\N	Вейделевского	\N	156541	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6074
Белгородская область	Белгород	0	Большие Липяги	\N	Вейделевского	\N	156541	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6095
Белгородская область	Белгород	0	Большой Плес	\N	Вейделевского	\N	156541	\N	10-14	Вс, Пн, Чт	\N	\N	\N	10	6094
Белгородская область	Белгород	0	Вейделевка	\N	Вейделевского	ц	156541	ТГ	08-16	\N	ЛИ-7332-17	13.07.2017	\N	10	269
Белгородская область	Белгород	0	Викторополь	\N	Вейделевского	\N	156541	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6127
Белгородская область	Белгород	0	Дегтярное	\N	Вейделевского	\N	156541	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6163
Белгородская область	Белгород	0	Долгое	\N	Вейделевского	\N	156541	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6171
Белгородская область	Белгород	0	Закутское	\N	Вейделевского	\N	156541	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6190
Белгородская область	Белгород	0	Зенино	\N	Вейделевского	\N	156541	\N	08-16	Вс, Пн, Чт	\N	\N	\N	10	6206
Белгородская область	Белгород	0	Клименки	\N	Вейделевского	\N	156541	\N	09-15	Вс, Пн, Чт	\N	\N	\N	10	6296
Белгородская область	Белгород	0	Колесники	\N	Вейделевского	\N	156541	\N	10-14	Вс, Пн, Чт	\N	\N	\N	10	6309
Белгородская область	Белгород	0	Кубраки	\N	Вейделевского	\N	156541	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6389
Белгородская область	Белгород	0	Малакеево	\N	Вейделевского	\N	156541	\N	08-15	Вс, Пн, Чт	\N	\N	\N	10	6438
Белгородская область	Белгород	0	Николаевка	\N	Вейделевского	\N	156541	\N	09-16	Вс, Пн, Чт	\N	\N	\N	10	6521
Белгородская область	Белгород	0	Олейники	\N	Вейделевского	\N	156541	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6564
Белгородская область	Белгород	0	Ровны	\N	Вейделевского	\N	156541	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6653
Белгородская область	Белгород	0	Ромахово	\N	Вейделевского	\N	156541	\N	09-14	Вс, Пн	\N	\N	\N	10	6658
Белгородская область	Белгород	0	Солонцы	\N	Вейделевского	\N	156541	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6697
Белгородская область	Белгород	0	Борисовка	\N	Волоконовского	\N	156534	\N	09-17	Вс	\N	\N	\N	10	6100
Белгородская область	Белгород	0	Верхние Лубянки	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	6120
Белгородская область	Белгород	0	Волоконовка	\N	Волоконовского	ц	156534	ТГ	07-21	\N	ЛИ-7333-17	13.07.2017	\N	10	270
Белгородская область	Белгород	0	Волчье Александровка	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Голофеевка	\N	Волоконовского	\N	156534	\N	09-17	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Грушевка	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	6158
Белгородская область	Белгород	0	Коновалово	\N	Волоконовского	\N	156534	\N	09-14	Вс, Пн	\N	\N	\N	10	6322
Белгородская область	Белгород	0	Погромец	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	6601
Белгородская область	Белгород	0	Покровка	\N	Волоконовского	\N	156534	\N	09-17	Вс, Пн	\N	\N	\N	10	6607
Белгородская область	Белгород	0	Пятницкое	\N	Волоконовского	\N	156534	\N	08-15	Сб, Вс	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Репьевка	\N	Волоконовского	\N	156534	\N	09-17	Вс	\N	\N	\N	10	6641
Белгородская область	Белгород	0	Староивановка	\N	Волоконовского	\N	156534	\N	09-17	Вс	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Тишанка	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	6755
Белгородская область	Белгород	0	Успенка	\N	Волоконовского	\N	156534	\N	09-16	Вс, Пн	\N	\N	\N	10	6778
Белгородская область	Белгород	0	Фощеватое	\N	Волоконовского	\N	156534	\N	09-17	Вс, Пн	\N	\N	\N	10	6794
Белгородская область	Белгород	0	Шидловка	\N	Волоконовского	\N	156534	\N	09-17	Вс, Пн	\N	\N	\N	10	6857
Белгородская область	Белгород	0	Ютановка	\N	Волоконовского	\N	156534	\N	08-16	Вс	\N	\N	\N	10	6868
Белгородская область	Белгород	0	Безымено	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6068
Белгородская область	Белгород	0	Глотово	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6143
Белгородская область	Белгород	0	Головчино	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6146
Белгородская область	Белгород	0	Головчино 1	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Гора Подол	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6150
Белгородская область	Белгород	0	Грайворон	\N	Грайворонского	ц	156550	ТГ	08-20	\N	ЛИ-7334-17	13.07.2017	\N	10	271
Белгородская область	Белгород	0	Дорогощь	\N	Грайворонского	\N	156550	\N	10-16	Вс, Пн, Чт	\N	\N	\N	10	6173
Белгородская область	Белгород	0	Дроновка	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6176
Белгородская область	Белгород	0	Дунайка	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6177
Белгородская область	Белгород	0	Ивановская Лисица	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6222
Белгородская область	Белгород	0	Казачья Лисица	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6244
Белгородская область	Белгород	0	Ломное	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6420
Белгородская область	Белгород	0	Мокрая Орловка	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6483
Белгородская область	Белгород	0	Новостроевка	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6552
Белгородская область	Белгород	0	Пороз	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6613
Белгородская область	Белгород	0	Почаево	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6616
Белгородская область	Белгород	0	Смородино	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6689
Белгородская область	Белгород	0	Хотмыжск	\N	Грайворонского	\N	156550	\N	10-15	Вс, Пн, Чт	\N	\N	\N	10	6818
Белгородская область	Белгород	0	Архангельское	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6060
Белгородская область	Белгород	0	Бобровы Дворы	\N	Губкинского	\N	156523	\N	08-16	Вс, Пн	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Богословка	\N	Губкинского	\N	156523	\N	08-12	Вс, Пн	\N	\N	\N	10	6091
Белгородская область	Белгород	0	Вислая Дубрава	\N	Губкинского	\N	156523	\N	08-12	Вс, Пн	\N	\N	\N	10	6128
Белгородская область	Белгород	0	Губкин	\N	Губкинского	ц	156523	ТГ	07-21	\N	ЛИ-7349-17	13.07.2017	\N	10	272
Белгородская область	Белгород	0	Гущино	\N	Губкинского	\N	156523	\N	08-12	Вс, Пн	\N	\N	\N	10	6160
Белгородская область	Белгород	0	Долгое	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6170
Белгородская область	Белгород	0	Заповедный	\N	Губкинского	\N	156523	\N	09-11	Вс, Пн	\N	\N	\N	10	6193
Белгородская область	Белгород	0	Ивановка	\N	Губкинского	\N	156523	\N	08-12	Вс, Пн	\N	\N	\N	10	6219
Белгородская область	Белгород	0	Истобное	\N	Губкинского	\N	156523	\N	08-15	Вс, Пн	\N	\N	\N	10	6238
Белгородская область	Белгород	0	Кладовое	\N	Губкинского	\N	156523	\N	08-11	Вс, Пн	\N	\N	\N	10	6280
Белгородская область	Белгород	0	Коньшино	\N	Губкинского	\N	156523	\N	08-14	Вс, Пн	\N	\N	\N	10	6326
Белгородская область	Белгород	0	Корочка	\N	Губкинского	\N	156523	\N	09-12	Вс, Пн	\N	\N	\N	10	6333
Белгородская область	Белгород	0	Меловое	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6473
Белгородская область	Белгород	0	Никаноровка	\N	Губкинского	\N	156523	\N	08-16	Вс, Пн	\N	\N	\N	10	6513
Белгородская область	Белгород	0	Осколец	\N	Губкинского	\N	156523	\N	08-14	Вс, Пн	\N	\N	\N	10	6571
Белгородская область	Белгород	0	Сапрыкино	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6665
Белгородская область	Белгород	0	Сергиевка	\N	Губкинского	\N	156523	\N	08-12	Вс, Пн	\N	\N	\N	10	6675
Белгородская область	Белгород	0	Скородное	\N	Губкинского	\N	156523	ТГ	09-17	Сб, Вс	\N	\N	\N	10	4788
Белгородская область	Белгород	0	Толстое	\N	Губкинского	\N	156523	\N	08-14	Вс, Пн	\N	\N	\N	10	6757
Белгородская область	Белгород	0	Троицкий	\N	Губкинского	\N	156523	ТГ	10-17	\N	\N	\N	\N	10	4789
Белгородская область	Белгород	0	Уколово	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6770
Белгородская область	Белгород	0	Чапкино	\N	Губкинского	\N	156523	\N	08-10	Вс, Пн	\N	\N	\N	10	6831
Белгородская область	Белгород	0	Чуево	\N	Губкинского	\N	156523	\N	08-15	Вс, Пн	\N	\N	\N	10	6842
Белгородская область	Белгород	0	Юрьевка	\N	Губкинского	\N	156523	\N	08-13	Вс, Пн	\N	\N	\N	10	6866
Белгородская область	Белгород	0	Березовка	\N	Ивнянского	\N	156526	\N	08-15	Вс, Пн	\N	\N	\N	10	6080
Белгородская область	Белгород	0	Богатое	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пн	\N	\N	\N	10	6088
Белгородская область	Белгород	0	Верхопенье	\N	Ивнянского	\N	156526	\N	08-17	Вс, Пн	\N	\N	\N	10	6124
Белгородская область	Белгород	0	Вознесеновка	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пн	\N	\N	\N	10	6130
Белгородская область	Белгород	0	Драгунка	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пн	\N	\N	\N	10	6174
Белгородская область	Белгород	0	Ивня	\N	Ивнянского	ц	156526	ТГ	07-21	\N	ЛИ-7335-17	13.07.2017	\N	10	273
Белгородская область	Белгород	0	Кочетовка	\N	Ивнянского	\N	156526	\N	08-16	Вс, Пн	\N	\N	\N	10	6340
Белгородская область	Белгород	0	Курасовка	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пн	\N	\N	\N	10	6394
Белгородская область	Белгород	0	Новенькое	\N	Ивнянского	\N	156526	\N	08-16	Вс, Пт	\N	\N	\N	10	6539
Белгородская область	Белгород	0	Песчаное	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пт	\N	\N	\N	10	6582
Белгородская область	Белгород	0	Покровка	\N	Ивнянского	\N	156526	\N	09-16	Вс, Пн	\N	\N	\N	10	6609
Белгородская область	Белгород	0	Сафоновка	\N	Ивнянского	\N	156526	\N	08-16	Вс, Пн	\N	\N	\N	10	6666
Белгородская область	Белгород	0	Сухосолотино	\N	Ивнянского	\N	156526	\N	09-17	Вс, Пн	\N	\N	\N	10	6741
Белгородская область	Белгород	0	Сырцево	\N	Ивнянского	\N	156526	\N	08-16	Вс, Пн	\N	\N	\N	10	6742
Белгородская область	Белгород	0	Федчевка	\N	Ивнянского	\N	156526	\N	09-12	Вс, Пн	\N	\N	\N	10	6790
Белгородская область	Белгород	0	Алексеевка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6055
Белгородская область	Белгород	0	Анновка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6058
Белгородская область	Белгород	0	Афанасовка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6063
Белгородская область	Белгород	0	Бехтеевка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6082
Белгородская область	Белгород	0	Большая Халань	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6093
Белгородская область	Белгород	0	Бубново	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6108
Белгородская область	Белгород	0	Жигайловка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6181
Белгородская область	Белгород	0	Заячье	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6198
Белгородская область	Белгород	0	Казанка	\N	Корочанского	\N	156521	\N	08-13	Вс, Пн, Чт	\N	\N	\N	10	6239
Белгородская область	Белгород	0	Клиновец	\N	Корочанского	\N	156521	\N	10-16 Сб 09-14	Вс, Пн, Чт	\N	\N	\N	10	6301
Белгородская область	Белгород	0	Короткое	\N	Корочанского	\N	156521	\N	09-15 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6332
Белгородская область	Белгород	0	Короча	\N	Корочанского	ц	156521	ТГ	07-21	\N	ЛИ-7336-17	13.07.2017	\N	10	274
Белгородская область	Белгород	0	Кощеево	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6344
Белгородская область	Белгород	0	Ломово	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6421
Белгородская область	Белгород	0	Мазикино	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6430
Брянская область	Брянск	0	Погар	\N	Погарского	ц	182541	ТГ	09-19	\N	\N	\N	\N	11	306
Белгородская область	Белгород	0	Мальцевка	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6442
Белгородская область	Белгород	0	Мелихово	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6474
Белгородская область	Белгород	0	Нечаево	\N	Корочанского	\N	156521	\N	08-13	Вс, Пн, Чт	\N	\N	\N	10	6503
Белгородская область	Белгород	0	Новая Слободка	\N	Корочанского	\N	156521	\N	08-16 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	\N
Белгородская область	Белгород	0	Пестуново	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6578
Белгородская область	Белгород	0	Песчаное	\N	Корочанского	\N	156521	\N	09-13	Вс, Пн, Чт	\N	\N	\N	10	6581
Белгородская область	Белгород	0	Плоское	\N	Корочанского	\N	156521	\N	09-13	Вс, Пн, Чт	\N	\N	\N	10	6593
Белгородская область	Белгород	0	Плотовец	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6597
Белгородская область	Белгород	0	Погореловка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6599
Белгородская область	Белгород	0	Поповка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6611
Белгородская область	Белгород	0	Проходное	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6627
Белгородская область	Белгород	0	Самойловка	\N	Корочанского	\N	156521	\N	09-14 Сб 09-13	Вс, Пн, Чт	\N	\N	\N	10	6664
Белгородская область	Белгород	0	Сидоровка	\N	Корочанского	\N	156521	\N	09-13 Сб 08-13	Вс, Пн, Чт	\N	\N	\N	10	6686
Белгородская область	Белгород	0	Соколовка	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6693
Белгородская область	Белгород	0	Ушаковка	\N	Корочанского	\N	156521	\N	09-13	Вс, Пн, Чт	\N	\N	\N	10	6787
Белгородская область	Белгород	0	Фощеватое	\N	Корочанского	\N	156521	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6797
Белгородская область	Белгород	0	Хмелевое	\N	Корочанского	\N	156621	\N	09-14	Вс, Пн, Чт	\N	\N	\N	10	6806
Белгородская область	Белгород	0	Шеино	\N	Корочанского	\N	156521	\N	08-14	Вс, Пн, Чт	\N	\N	\N	10	6853
Белгородская область	Белгород	0	Шляхово	\N	Корочанского	\N	156521	\N	10-14	Вс, Пн, Чт	\N	\N	\N	10	6859
Белгородская область	Белгород	0	Яблоново	\N	Корочанского	\N	156521	\N	08-17 Сб 08-14	Вс, Пн, Чт	\N	\N	\N	10	6870
Белгородская область	Белгород	0	Большое	\N	Красненского	\N	156516	\N	08-16 Ср, Пт 08-12	Вс, Пн	\N	\N	\N	10	6096
Белгородская область	Белгород	0	Горки	\N	Красненского	\N	156516	\N	08-17 Ср, Пт 08-15	Вс, Пн	\N	\N	\N	10	6151
Белгородская область	Белгород	0	Готовье	\N	Красненского	\N	156516	\N	08-16 Ср, Пт 08-13	Вс, Пн	\N	\N	\N	10	6154
Белгородская область	Белгород	0	Камызино	\N	Красненского	\N	156516	\N	08-16 Ср, Пт 08-12	Вс, Пн	\N	\N	\N	10	6250
Белгородская область	Белгород	0	Красное	\N	Красненского	ц	156516	ТГ	07-21	\N	ЛИ-7337-17	13.07.2017	\N	10	277
Белгородская область	Белгород	0	Круглое	\N	Красненского	\N	156516	\N	08-17 Ср, Пт 08-15	Вс, Пн	\N	\N	\N	10	6378
Белгородская область	Белгород	0	Лесное Уколово	\N	Красненского	\N	156516	\N	08-17 Ср, Пт 08-15	Вс, Пн	\N	\N	\N	10	6407
Белгородская область	Белгород	0	Новоуколово	\N	Красненского	\N	156516	\N	08-17 Ср 08-15	Вс, Пн	\N	\N	\N	10	6554
Белгородская область	Белгород	0	Расховец	\N	Красненского	\N	156516	\N	08-16 Ср, Пт 08-13	Вс, Пт	\N	\N	\N	10	6636
Белгородская область	Белгород	0	Сетище	\N	Красненского	\N	156516	\N	08-15 Ср, Пт 08-11	Вс, Пн	\N	\N	\N	10	6684
Белгородская область	Белгород	0	Ураково	\N	Красненского	\N	156516	\N	09-14 Ср, Пт 09-11	Вс, Пт	\N	\N	\N	10	6776
Белгородская область	Белгород	0	Флюговка	\N	Красненского	\N	156516	\N	11-14 Ср, Пт 11-13	Вс, Пн	\N	\N	\N	10	6792
Белгородская область	Белгород	0	Хмелевое	\N	Красненского	\N	156516	\N	10-14 Ср, Пт 10-13	Вс, Пн	\N	\N	\N	10	6808
Белгородская область	Белгород	0	Арнаутово	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6059
Белгородская область	Белгород	0	Бирюч	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6083
Белгородская область	Белгород	0	Быково	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6110
Белгородская область	Белгород	0	Валуйчик	\N	Красногвардейского	\N	156504	\N	08-16	Вс, Пн	\N	\N	\N	10	6111
Белгородская область	Белгород	0	Верхняя Покровка	\N	Красногвардейского	\N	156504	ТГ	08-16	Вс	\N	\N	\N	10	6122
Белгородская область	Белгород	0	Верхососна	\N	Красногвардейского	\N	156504	\N	08-16	Вс, Пн	\N	\N	\N	10	6125
Белгородская область	Белгород	0	Веселое	\N	Красногвардейского	\N	156504	ТГ	08-16	Вс	\N	\N	\N	10	4781
Белгородская область	Белгород	0	Засосна	\N	Красногвардейского	\N	156504	ТГ	08-16	Вс	\N	\N	\N	10	4783
Белгородская область	Белгород	0	Калиново	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6248
Белгородская область	Белгород	0	Коломыцево	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6312
Белгородская область	Белгород	0	Красногвардейское	\N	Красногвардейского	ц	156504	ТГ	08-18	\N	ЛИ-7338-17	13.07.2017	\N	10	276
Белгородская область	Белгород	0	Красногвардейское-1	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6306
Белгородская область	Белгород	0	Красное	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6359
Белгородская область	Белгород	0	Лазареново	\N	Красногвардейского	\N	156504	\N	08-12	Вс, Пн	\N	\N	\N	10	6400
Белгородская область	Белгород	0	Ливенка	\N	Красногвардейского	\N	156504	ТГ	08-16	Вс	\N	\N	\N	10	4784
Белгородская область	Белгород	0	Марьевка	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6446
Белгородская область	Белгород	0	Никитовка	\N	Красногвардейского	\N	156504	ТГ	08-16	Вс	\N	\N	\N	10	4786
Белгородская область	Белгород	0	Новохуторное	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6549
Белгородская область	Белгород	0	Палатово	\N	Красногвардейского	\N	156504	\N	08-16	Вс, Пн	\N	\N	\N	10	6575
Белгородская область	Белгород	0	Раздорное	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6632
Белгородская область	Белгород	0	Самарино	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6663
Белгородская область	Белгород	0	Сорокино	\N	Красногвардейского	\N	156504	\N	08-14	Вс, Пн	\N	\N	\N	10	6726
Белгородская область	Белгород	0	Стрелецкое	\N	Красногвардейского	\N	156504	\N	08-16	Вс, Пн	\N	\N	\N	10	6737
Белгородская область	Белгород	0	Уточка	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6782
Белгородская область	Белгород	0	Хуторцы	\N	Красногвардейского	\N	156504	\N	08-15	Вс, Пн	\N	\N	\N	10	6829
Белгородская область	Белгород	0	Вязовое	\N	Краснояружского	\N	156546	\N	09-17	Вс, Пн	\N	\N	\N	10	6138
Белгородская область	Белгород	0	Графовка	\N	Краснояружского	\N	156546	\N	09-16	Вс, Пн	\N	\N	\N	10	6155
Белгородская область	Белгород	0	Демидовка	\N	Краснояружского	\N	156546	\N	09-16	Вс, Пн	\N	\N	\N	10	6164
Белгородская область	Белгород	0	Илек-Пеньковка	\N	Краснояружского	\N	156546	\N	08-16	Вс, Пн	\N	\N	\N	10	6233
Белгородская область	Белгород	0	Колотиловка	\N	Краснояружского	\N	156546	\N	09-16	Вс, Пн	\N	\N	\N	10	6318
Белгородская область	Белгород	0	Красная Яруга	\N	Краснояружского	ц	156546	ТГ	07-21	\N	ЛИ-7339-17	13.07.2017	\N	10	275
Белгородская область	Белгород	0	Красная Яруга-1	\N	Краснояружского	\N	156546	\N	09-17	Вс, Пн	\N	\N	\N	10	6335
Белгородская область	Белгород	0	Репяховка	\N	Краснояружского	\N	156546	\N	09-16	Вс, Пн	\N	\N	\N	10	6644
Белгородская область	Белгород	0	Сергиевка	\N	Краснояружского	\N	156646	\N	09-14	Вс, Пн	\N	\N	\N	10	6678
Белгородская область	Белгород	0	Теребрено	\N	Краснояружского	\N	156546	\N	08-16	Вс, Пн	\N	\N	\N	10	6746
Белгородская область	Белгород	0	Хуторское	\N	Краснояружского	\N	156546	\N	10-15	Вс, Пн	\N	\N	\N	10	6827
Белгородская область	Белгород	0	Барсук	\N	Новооскольского	\N	156501	\N	11-13	Вс, Пн	\N	\N	\N	10	6066
Брянская область	Брянск	0	Новая Романовка	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	7460
Брянская область	Брянск	0	Новые Чешуйки	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	11374
Брянская область	Брянск	0	Осколково	\N	Мглинского	\N	182561	\N	15-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7489
Брянская область	Брянск	0	Семки	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	7566
Брянская область	Брянск	0	Симонтовка	\N	Мглинского	\N	182561	\N	15-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7572
Брянская область	Брянск	0	Соколовка	\N	Мглинского	\N	182561	\N	16-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7585
Брянская область	Брянск	0	Старая Романовка	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	7594
Брянская область	Брянск	0	Черновица	\N	Мглинского	\N	182561	\N	15-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Шумарово	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	7671
Брянская область	Брянск	0	Алешинка	\N	Навлинского	\N	182524	\N	11-19	Вс, Пн, Чт	\N	\N	\N	11	6896
Брянская область	Брянск	0	Алтухово	\N	Навлинского	\N	182524	\N	10-19	Вс, Пн	\N	\N	\N	11	6899
Брянская область	Брянск	0	Борщово	\N	Навлинского	\N	182524	\N	10-17	Вс, Пн, Вт, Чт	\N	\N	\N	11	\N
Брянская область	Брянск	0	Бутре	\N	Навлинского	\N	182524	\N	11-16.20	Пн, Ср, Пт, Вс	ЛИ-6215-17	29.05.2018	\N	11	6982
Брянская область	Брянск	0	Бяково	\N	Навлинского	\N	182524	\N	13-20	Пн, Вт, Чт, Вс	\N	\N	\N	11	6985
Брянская область	Брянск	0	Вздружное	\N	Навлинского	\N	182524	\N	14-20	Пн, Вт, Чт, Вс	\N	\N	\N	11	7021
Брянская область	Брянск	0	Гремячее	\N	Навлинского	\N	182524	\N	12-17	Пн, Вт, Чт, Вс	\N	\N	\N	11	7078
Брянская область	Брянск	0	Клюковники	\N	Навлинского	\N	182524	\N	10-17	Вс, Пн	\N	\N	\N	11	7250
Брянская область	Брянск	0	Лески	\N	Навлинского	\N	182524	\N	15-21	Пн, Вт, Чт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Навля	\N	Навлинского	ц	182524	ТГ	09-19	\N	\N	\N	\N	11	304
Брянская область	Брянск	0	Партизанское	\N	Навлинского	\N	182524	\N	11-17	Пн, Вт, Чт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Пролысово	\N	Навлинского	\N	182524	\N	12-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7523
Брянская область	Брянск	0	Ревны	\N	Навлинского	\N	182524	\N	10-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7532
Брянская область	Брянск	0	Салтановка	\N	Навлинского	\N	182524	\N	12-20	Пн, Вт, Чт, Вс	\N	\N	\N	11	7552
Брянская область	Брянск	0	Синезерский	\N	Навлинского	\N	182524	\N	11-18	Вс, Пн	\N	\N	\N	11	7573
Брянская область	Брянск	0	Соколово	\N	Навлинского	\N	182524	\N	11-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7586
Брянская область	Брянск	0	Чичково	\N	Навлинского	\N	182524	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6229-17	29.05.2018	\N	11	7661
Брянская область	Брянск	0	Щегловка	\N	Навлинского	\N	182524	\N	14-20	Пн, Вт, Чт, Вс	\N	\N	\N	11	7675
Брянская область	Брянск	0	Верещаки	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7007
Брянская область	Брянск	0	Внуковичи	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7033
Брянская область	Брянск	0	Деменка	\N	Новозыбковского	\N	182521	\N	14-19	Вс, Пн	\N	\N	\N	11	7107
Брянская область	Брянск	0	Дубровка	\N	Новозыбковского	\N	182521	\N	15-18	Вс, Пн	\N	\N	\N	11	7166
Брянская область	Брянск	0	Замишево	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7201
Брянская область	Брянск	0	Каташин	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7236
Брянская область	Брянск	0	Катичи	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7239
Брянская область	Брянск	0	Манюки	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7382
Брянская область	Брянск	0	Новое Место	\N	Новозыбковского	\N	182521	\N	15-18	Вс, Пн	\N	\N	\N	11	7464
Брянская область	Брянск	0	Новозыбков	\N	Новозыбковского	ц	182521	ТГ	Вс 09.00-14.00 Пн, Вт, Ср, Чт, Пт 08.00-20.00 Сб 09.00-18.00	\N	ЛИ-748-16	30.12.1899	\N	11	305
Брянская область	Брянск	0	Новые Бобовичи	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7471
Брянская область	Брянск	0	Синий Колодец	\N	Новозыбковского	\N	182521	\N	14-18	Вс, Пн	\N	\N	\N	11	7574
Брянская область	Брянск	0	Сновское	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7581
Брянская область	Брянск	0	Старые Бобовичи	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7597
Брянская область	Брянск	0	Старый Вышков	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7603
Брянская область	Брянск	0	Старый Кривец	\N	Новозыбковского	\N	182521	\N	16-19	Вс, Пн	\N	\N	\N	11	7604
Брянская область	Брянск	0	Холевичи	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7645
Брянская область	Брянск	0	Шеломы	\N	Новозыбковского	\N	182521	\N	15-19	Вс, Пн	\N	\N	\N	11	7668
Брянская область	Брянск	0	Андрейковичи	\N	Погарского	\N	182541	\N	17-20	Пн, Пт, Вс	\N	\N	\N	11	6904
Брянская область	Брянск	0	Березовка	\N	Погарского	\N	182541	\N	15-21	Пн, Пт, Вс	\N	\N	\N	11	6930
Брянская область	Брянск	0	Бобрик	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	6936
Брянская область	Брянск	0	Борщово	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Вадьковка	\N	Погарского	\N	182541	\N	14-20	Пн, Пт, Вс	\N	\N	\N	11	6986
Брянская область	Брянск	0	Василевка	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	6989
Брянская область	Брянск	0	Витемля	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	11646
Брянская область	Брянск	0	Гетуновка	\N	Погарского	\N	182541	\N	14-19	Пн, Пт, Вс	\N	\N	\N	11	7058
Брянская область	Брянск	0	Городище	\N	Погарского	\N	182541	\N	14-19	Пн, Пт, Вс	\N	\N	\N	11	7072
Брянская область	Брянск	0	Гринево	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	7080
Брянская область	Брянск	0	Гудовка	\N	Погарского	\N	182541	\N	16-18	Пн, Пт, Вс	\N	\N	\N	11	7087
Брянская область	Брянск	0	Дареевск	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	7101
Брянская область	Брянск	0	Долботово	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	7152
Брянская область	Брянск	0	Жигалки	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	7185
Брянская область	Брянск	0	Кистер	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	7247
Брянская область	Брянск	0	Курово	\N	Погарского	\N	182541	\N	14-19	Пн, Пт, Вс	\N	\N	\N	11	7322
Брянская область	Брянск	0	Посудичи	\N	Погарского	\N	182541	\N	17-21	Пн, Пт, Вс	\N	\N	\N	11	7520
Брянская область	Брянск	0	Прирубки	\N	Погарского	\N	182541	\N	16-21	Пн, Пт, Вс	\N	\N	\N	11	7521
Брянская область	Брянск	0	Савостьяны	\N	Погарского	\N	182541	\N	15-20	Пн, Пт, Вс	\N	\N	\N	11	7547
Брянская область	Брянск	0	Случовск	\N	Погарского	\N	182541	\N	16-20	Пн, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Стечна	\N	Погарского	\N	182541	\N	14-20	Пн, Пт, Вс	\N	\N	\N	11	7608
Брянская область	Брянск	0	Чайкино	\N	Погарского	\N	182541	\N	14-18	Пн, Пт, Вс	\N	\N	\N	11	7654
Брянская область	Брянск	0	Чаусы	\N	Погарского	\N	182541	\N	15-19	Пн, Пт, Вс	\N	\N	\N	11	6039
Брянская область	Брянск	0	Чеховка	\N	Погарского	\N	182541	\N	15-20	Пн, Пт, Вс	\N	\N	\N	11	7660
Брянская область	Брянск	0	Юдиново	\N	Погарского	\N	182541	\N	15-20	Пн, Пт, Вс	\N	\N	\N	11	7676
Брянская область	Брянск	0	Баклань	\N	Почепского	\N	182523	\N	14-17	Вс, Вт, Чт, Сб	\N	\N	\N	11	6912
Брянская область	Брянск	0	Балыки	\N	Почепского	\N	182523	\N	14-17	Вс, Пн, Ср, Пт	\N	\N	\N	11	6914
Брянская область	Брянск	0	Бельково	\N	Почепского	\N	182523	\N	13-17	Вс, Пн, Ср, Пт	\N	\N	\N	11	6926
Брянская область	Брянск	0	Валуец	\N	Почепского	\N	182523	\N	14-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	6987
Брянская область	Брянск	0	Верхняя Злобинка	\N	Почепского	\N	182523	\N	12-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7013
Брянская область	Брянск	0	Витовка	\N	Почепского	\N	182523	\N	14-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7027
Брянская область	Брянск	0	Громыки	\N	Почепского	\N	182523	\N	12-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7085
Брянская область	Брянск	0	Дмитрово	\N	Почепского	\N	182523	\N	13-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7121
Брянская область	Брянск	0	Доманичи	\N	Почепского	\N	182523	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7153
Брянская область	Брянск	0	Житня	\N	Почепского	\N	182523	\N	12-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7187
Брянская область	Брянск	0	Красный Рог	\N	Почепского	\N	182523	\N	15-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Милечь	\N	Почепского	\N	182523	\N	16-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7392
Брянская область	Брянск	0	Московский	\N	Почепского	\N	182523	\N	15-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7411
Брянская область	Брянск	0	Первомайское	\N	Почепского	\N	182523	\N	15-17	Вс, Вт, Чт, Сб	\N	\N	\N	11	7502
Брянская область	Брянск	0	Подбелово	\N	Почепского	\N	182523	\N	16-19	Вт, Чт, Сб, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Польники	\N	Почепского	\N	182523	\N	13-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Почеп	\N	Почепского	ц	182523	ТГ	08-20	\N	\N	\N	\N	11	307
Брянская область	Брянск	0	Рамасуха	\N	Почепского	\N	182523	\N	15-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7530
Владимирская область	Владимир	0	Большевысоково	\N	Вязниковского	\N	218512	\N	07-17	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Буторлино	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8339
Владимирская область	Владимир	0	Вязники	\N	Вязниковского	ц	218512	ТГ	08-18.30 Сб 09-13.30	Вс	ЛИ-820-16	30.12.1899	\N	13	363
Владимирская область	Владимир	0	Галкино	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8360
Владимирская область	Владимир	0	Козлово	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8414
Владимирская область	Владимир	0	Кудрявцево	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8438
Владимирская область	Владимир	0	Лукново	\N	Вязниковского	\N	218512	\N	09-17	Вс	\N	\N	\N	13	8448
Владимирская область	Владимир	0	Малые Удолы	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8454
Владимирская область	Владимир	0	Мстера	\N	Вязниковского	\N	218512	\N	09-17 Сб 09-14	Вс, Пн	\N	\N	\N	13	378
Владимирская область	Владимир	0	Мстера Станция	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	5972
Владимирская область	Владимир	0	Никологоры	\N	Вязниковского	\N	218512	\N	09-17 Сб 09-14	Вс, Пн	\N	\N	\N	13	380
Владимирская область	Владимир	0	Нововязники	\N	Вязниковского	\N	218512	\N	09-17 Сб 09-14	Вс, Пн	ЛИ-8594-17	21.08.2017	\N	13	381
Владимирская область	Владимир	0	Октябрьская	\N	Вязниковского	\N	218512	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8484
Владимирская область	Владимир	0	Октябрьский	\N	Вязниковского	\N	218512	\N	09-17	Вс	\N	\N	\N	13	8485
Владимирская область	Владимир	0	Осинки	\N	Вязниковского	\N	218512	\N	07-17	Сб, Вс	\N	\N	\N	13	8487
Владимирская область	Владимир	0	Паустово	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8497
Владимирская область	Владимир	0	Пески	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8503
Владимирская область	Владимир	0	Пировы Городищи	\N	Вязниковского	\N	218512	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Пролетарий	\N	Вязниковского	\N	218512	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8512
Владимирская область	Владимир	0	Сарыево	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8525
Владимирская область	Владимир	0	Сергиевы Горки	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8530
Владимирская область	Владимир	0	Серково	\N	Вязниковского	\N	218512	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8531
Владимирская область	Владимир	0	Станки	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8542
Владимирская область	Владимир	0	Степанцево	\N	Вязниковского	\N	218512	\N	09-18	Сб, Вс	\N	\N	\N	13	8545
Владимирская область	Владимир	0	Чудиново	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8572
Владимирская область	Владимир	0	Шатнево	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8574
Владимирская область	Владимир	0	Эдон	\N	Вязниковского	\N	218512	\N	09-17	Сб, Вс	\N	\N	\N	13	8578
Владимирская область	Владимир	0	Арефино	\N	Гороховецкого	\N	218542	\N	09-17	Сб, Вс	\N	\N	\N	13	8316
Владимирская область	Владимир	0	Быкасово	\N	Гороховецкого	\N	218542	\N	09-17	Сб, Вс	\N	\N	\N	13	8341
Владимирская область	Владимир	0	Великово	\N	Гороховецкого	\N	218542	\N	09-17	Сб, Вс	\N	\N	\N	13	8344
Владимирская область	Владимир	0	Гороховец	\N	Гороховецкого	ц	218542	ТГ	08-17	Сб, Вс	ЛИ-821-16	30.12.1899	\N	13	365
Владимирская область	Владимир	0	Гришино	\N	Гороховецкого	\N	218542	\N	09-17	Сб, Вс	\N	\N	\N	13	8371
Владимирская область	Владимир	0	Крутово	\N	Гороховецкого	\N	218542	\N	09-17	Сб, Вс	\N	\N	\N	13	8436
Владимирская область	Владимир	0	Пролетарский	\N	Гороховецкого	\N	218542	\N	07-20	Вс, Пн	\N	\N	\N	13	8513
Владимирская область	Владимир	0	Рождественно	\N	Гороховецкого	\N	218542	\N	10-13	Сб, Вс	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Фоминки	\N	Гороховецкого	\N	218542	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8563
Владимирская область	Владимир	0	Чулково	\N	Гороховецкого	\N	218542	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8573
Владимирская область	Владимир	0	Аббакумово	\N	Гусь-Хрустального	\N	218513	\N	11-16	Вс, Пн	\N	\N	\N	13	8308
Владимирская область	Владимир	0	Аксеново	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8310
Владимирская область	Владимир	0	Анопино	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8315
Владимирская область	Владимир	0	Вашутино	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8342
Владимирская область	Владимир	0	Вековка	\N	Гусь-Хрустального	\N	218513	\N	10-15	Вс, Пн	\N	\N	\N	13	8343
Владимирская область	Владимир	0	Великодворье	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8345
Владимирская область	Владимир	0	Григорьево	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8370
Владимирская область	Владимир	0	Гусевский	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8373
Владимирская область	Владимир	0	Гусь-Хрустальный	\N	Гусь-Хрустального	ц	218513	ТГ	08-17 Сб 09-15	Вс	ЛИ-822-16	30.12.1899	\N	13	366
Владимирская область	Владимир	0	Демидово	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8376
Владимирская область	Владимир	0	Добрятино	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8382
Владимирская область	Владимир	0	Долбино	\N	Гусь-Хрустального	\N	218513	\N	09-16	Вс, Пн	\N	\N	\N	13	8383
Владимирская область	Владимир	0	Золотково	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8394
Владимирская область	Владимир	0	Иванищи	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8395
Владимирская область	Владимир	0	Ильино	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8398
Владимирская область	Владимир	0	Колпь	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8416
Владимирская область	Владимир	0	Красное Эхо	\N	Гусь-Хрустального	\N	218513	\N	08-20	Вс	\N	\N	\N	13	8426
Владимирская область	Владимир	0	Красный Октябрь	\N	Гусь-Хрустального	\N	218513	\N	10-15	Вс, Пн	\N	\N	\N	13	374
Владимирская область	Владимир	0	Купреево	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8439
Владимирская область	Владимир	0	Курлово	\N	Гусь-Хрустального	\N	218513	\N	08-20 Сб 09-18	Вс	\N	\N	\N	13	375
Владимирская область	Владимир	0	Лесниково	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8441
Владимирская область	Владимир	0	Мезиновский	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8459
Владимирская область	Владимир	0	Мокрое	\N	Гусь-Хрустального	\N	218513	\N	10-17	Вс, Пн	\N	\N	\N	13	8463
Владимирская область	Владимир	0	Неклюдово	\N	Гусь-Хрустального	\N	218513	\N	09-14	Вс, Пн	\N	\N	\N	13	8471
Владимирская область	Владимир	0	Нечаевская	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8474
Владимирская область	Владимир	0	Никулино	\N	Гусь-Хрустального	\N	218513	\N	08-13	Вс, Пн	\N	\N	\N	13	8475
Владимирская область	Владимир	0	Панфиловский	\N	Гусь-Хрустального	\N	218513	\N	09-13	Вс, Пн	\N	\N	\N	13	5965
Владимирская область	Владимир	0	Парахино	\N	Гусь-Хрустального	\N	218513	\N	08-16	Вс, Пн	\N	\N	\N	13	8495
Владимирская область	Владимир	0	Семеновка	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8527
Владимирская область	Владимир	0	Тасин Бор	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8549
Владимирская область	Владимир	0	Тихоново	\N	Гусь-Хрустального	\N	218513	\N	11-15	Вс, Пн	\N	\N	\N	13	8552
Владимирская область	Владимир	0	Уршельский	\N	Гусь-Хрустального	\N	218513	\N	10-18	Вс, Пн	\N	\N	\N	13	8558
Владимирская область	Владимир	0	Черсево	\N	Гусь-Хрустального	\N	218513	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8570
Владимирская область	Владимир	0	Волковойно	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8348
Владимирская область	Владимир	0	Второво	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8356
Владимирская область	Владимир	0	Гатиха	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8361
Владимирская область	Владимир	0	Давыдово	\N	Камешковского	\N	218533	\N	08-16	Вс, Пн	\N	\N	\N	13	8374
Владимирская область	Владимир	0	Им. Артема	\N	Камешковского	\N	218533	\N	08-16	Вс, Пн	\N	\N	\N	13	8399
Владимирская область	Владимир	0	Им. К. Маркса	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8401
Владимирская область	Владимир	0	Им. Кирова	\N	Камешковского	\N	218533	\N	08-15	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Им. Красина	\N	Камешковского	\N	218533	\N	08-15	Вс, Пн	\N	\N	\N	13	8403
Владимирская область	Владимир	0	Им. М. Горького	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8404
Брянская область	Брянск	0	Речица	\N	Почепского	\N	182523	\N	12-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7534
Брянская область	Брянск	0	Рогово	\N	Почепского	\N	182523	\N	13-17	Вс, Вт, Чт, Сб	\N	\N	\N	11	\N
Брянская область	Брянск	0	Семцы	\N	Почепского	\N	182523	\N	13-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7567
Брянская область	Брянск	0	Сетолово	\N	Почепского	\N	182523	\N	13-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7571
Брянская область	Брянск	0	Старокрасная Слобода	\N	Почепского	\N	182523	\N	13-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Супрягино	\N	Почепского	\N	182523	\N	13-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7617
Брянская область	Брянск	0	Титовка	\N	Почепского	\N	182523	\N	13-17	Вт, Чт, Сб, Вс	\N	\N	\N	11	7624
Брянская область	Брянск	0	Третьяки	\N	Почепского	\N	182523	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7625
Брянская область	Брянск	0	Чопово	\N	Почепского	\N	182523	\N	12-17	Пн, Ср, Сб, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Шуморово	\N	Почепского	\N	182523	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Вороново	\N	Рогнединского	\N	182536	\N	13-20	Вт, Чт, Сб, Вс	\N	\N	\N	11	7044
Брянская область	Брянск	0	Гобики	\N	Рогнединского	\N	182536	\N	13-20	Вт, Чт, Сб, Вс	\N	\N	\N	11	7067
Брянская область	Брянск	0	Лутовиновка	\N	Рогнединского	\N	182536	\N	13-18	Вт, Чт, Сб, Вс	\N	\N	\N	11	7372
Брянская область	Брянск	0	Осовик	\N	Рогнединского	\N	182536	\N	13-18	Вт, Чт, Сб, Вс	\N	\N	\N	11	7490
Брянская область	Брянск	0	Пацынь	\N	Рогнединского	\N	182536	\N	13-18	Вт, Чт, Сб, Вс	\N	\N	\N	11	7499
Брянская область	Брянск	0	Рогнедино	\N	Рогнединского	ц	182536	ТГ	09-18	Вс	ЛИ-1738-18	29.10.2018	\N	11	308
Брянская область	Брянск	0	Снопоть	\N	Рогнединского	\N	182536	\N	13-21	Пн, Ср, Пт, Вс	\N	\N	\N	11	7582
Брянская область	Брянск	0	Тюнино	\N	Рогнединского	\N	182536	\N	14-19	Вт, Чт, Сб, Вс	\N	\N	\N	11	6044
Брянская область	Брянск	0	Шаровичи	\N	Рогнединского	\N	182536	\N	14-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	7665
Брянская область	Брянск	0	Бересток	\N	Севского	\N	182515	\N	13-18	Вс, Пн, Ср, Пт	\N	\N	\N	11	6931
Брянская область	Брянск	0	Гапонова	\N	Севского	\N	182515	\N	15-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7053
Брянская область	Брянск	0	Голышина	\N	Севского	\N	182515	\N	12-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7069
Брянская область	Брянск	0	Доброводье	\N	Севского	\N	182515	\N	15-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	7149
Брянская область	Брянск	0	Заулье	\N	Севского	\N	182515	\N	13-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7207
Брянская область	Брянск	0	Княгинино	\N	Севского	\N	182515	\N	12-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7252
Брянская область	Брянск	0	Косицы	\N	Севского	\N	182515	\N	13-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7275
Брянская область	Брянск	0	Лемешовка	\N	Севского	\N	182515	\N	15-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7342
Брянская область	Брянск	0	Марицкий Хутор	\N	Севского	\N	182515	\N	12-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7384
Брянская область	Брянск	0	Новоямское	\N	Севского	\N	182515	\N	13-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7470
Брянская область	Брянск	0	Первомайское	\N	Севского	\N	182515	\N	13-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7503
Брянская область	Брянск	0	Подлесные Новоселки	\N	Севского	\N	182515	\N	14-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7514
Брянская область	Брянск	0	Подывотье	\N	Севского	\N	182515	\N	14-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7515
Брянская область	Брянск	0	Пушкино	\N	Севского	\N	182515	\N	13-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7525
Брянская область	Брянск	0	Рабочий	\N	Севского	\N	182515	\N	14-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7886
Брянская область	Брянск	0	Севск	\N	Севского	ц	182515	ТГ	09-19	\N	\N	\N	\N	11	309
Брянская область	Брянск	0	Чемлыж	\N	Севского	\N	182515	\N	12-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7656
Брянская область	Брянск	0	Шведчики	\N	Севского	\N	182515	\N	14-16	Пн, Ср, Пт, Вс	\N	\N	\N	11	7667
Брянская область	Брянск	0	Сельцо	\N	\N	\N	182553	ТГ	08-20	\N	\N	\N	\N	11	310
Брянская область	Брянск	0	Азаровка	\N	Стародубского	\N	182531	\N	10-17	Пн, Чт, Вс	\N	\N	\N	11	5509
Брянская область	Брянск	0	Алейниково	\N	Стародубского	\N	182531	\N	11-17	Пн, Чт, Вс	\N	\N	\N	11	6886
Брянская область	Брянск	0	Воронок	\N	Стародубского	\N	182531	\N	11-17	Пн, Чт, Вс	\N	\N	\N	11	11597
Брянская область	Брянск	0	Галенск	\N	Стародубского	\N	182531	\N	10-15	Пн, Чт, Вс	\N	\N	\N	11	7051
Брянская область	Брянск	0	Гарцево	\N	Стародубского	\N	182531	\N	11-16	Пн, Чт, Вс	\N	\N	\N	11	7055
Брянская область	Брянск	0	Демьянки	\N	Стародубского	\N	182531	\N	09-16	Пн, Чт, Вс	\N	\N	\N	11	7109
Брянская область	Брянск	0	Десятуха	\N	Стародубского	\N	182531	\N	09-16	Пн, Чт, Вс	\N	\N	\N	11	7116
Брянская область	Брянск	0	Дохновичи	\N	Стародубского	\N	182531	\N	09-17	Пн, Чт, Вс	\N	\N	\N	11	7157
Брянская область	Брянск	0	Елионка	\N	Стародубского	\N	182531	\N	09-14	Пн, Чт, Вс	\N	\N	\N	11	7181
Брянская область	Брянск	0	Запольские Халеевичи	\N	Стародубского	\N	182531	\N	10-17	Пн, Чт, Вс	\N	\N	\N	11	7204
Брянская область	Брянск	0	Камень	\N	Стародубского	\N	182531	\N	09-14	Пн, Чт, Вс	\N	\N	\N	11	7220
Брянская область	Брянск	0	Картушин	\N	Стародубского	\N	182531	\N	09-13	Пн, Чт, Вс	\N	\N	\N	11	7227
Брянская область	Брянск	0	Ковалево	\N	Стародубского	\N	182531	\N	12-16	Пн, Чт, Вс	\N	\N	\N	11	7253
Брянская область	Брянск	0	Курковичи	\N	Стародубского	\N	182531	\N	11-16	Пн, Чт, Вс	\N	\N	\N	11	7320
Брянская область	Брянск	0	Левенка	\N	Стародубского	\N	182531	\N	09-17	Пн, Чт, Вс	\N	\N	\N	11	7333
Брянская область	Брянск	0	Логоватое	\N	Стародубского	\N	182531	\N	11-18	Пн, Чт, Вс	\N	\N	\N	11	7356
Брянская область	Брянск	0	Лужки	\N	Стародубского	\N	182531	\N	12-15	Пн, Чт, Вс	\N	\N	\N	11	7367
Брянская область	Брянск	0	Меленск	\N	Стародубского	\N	182531	\N	10-16	Пн, Чт, Вс	\N	\N	\N	11	7390
Брянская область	Брянск	0	Мишковка	\N	Стародубского	\N	182531	\N	10-16	Пн, Чт, Вс	\N	\N	\N	11	7403
Брянская область	Брянск	0	Мохоновка	\N	Стародубского	\N	182531	\N	12-19	Пн, Чт, Вс	\N	\N	\N	11	7412
Брянская область	Брянск	0	Нижнее	\N	Стародубского	\N	182531	\N	10-15	Пн, Чт, Вс	\N	\N	\N	11	7456
Брянская область	Брянск	0	Новое Село	\N	Стародубского	\N	182531	\N	11-14	Пн, Чт, Вс	\N	\N	\N	11	7465
Брянская область	Брянск	0	Новомлынка	\N	Стародубского	\N	182531	\N	10-16	Пн, Чт, Вс	\N	\N	\N	11	7466
Брянская область	Брянск	0	Пестриково	\N	Стародубского	\N	182531	\N	11-14	Пн, Чт, Вс	\N	\N	\N	11	7506
Брянская область	Брянск	0	Понуровка	\N	Стародубского	\N	182531	\N	10-14	Пн, Чт, Вс	\N	\N	\N	11	7519
Брянская область	Брянск	0	Пролетарск	\N	Стародубского	\N	182531	\N	10-13	Пн, Чт, Вс	\N	\N	\N	11	7522
Брянская область	Брянск	0	Пятовск	\N	Стародубского	\N	182531	\N	12-17	Пн, Чт, Вс	\N	\N	\N	11	7526
Брянская область	Брянск	0	Селище	\N	Стародубского	\N	182531	\N	12-17	Пн, Чт, Вс	\N	\N	\N	11	7562
Брянская область	Брянск	0	Стародуб	\N	Стародубского	ц	182531	ТГ	08-20	\N	\N	\N	\N	11	312
Брянская область	Брянск	0	Чубковичи	\N	Стародубского	\N	182531	\N	10-15	Пн, Чт, Вс	\N	\N	\N	11	7663
Брянская область	Брянск	0	Шкрябино	\N	Стародубского	\N	182531	\N	09-14	Пн, Чт, Вс	\N	\N	\N	11	7670
Брянская область	Брянск	0	KOKOPEBKA	\N	Суземского	\N	182552	\N	16-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Алешковичи	\N	Суземского	\N	182552	\N	15-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	6862
Брянская область	Брянск	0	Березовка	\N	Суземского	\N	182552	\N	15-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	6928
Брянская область	Брянск	0	Зерново	\N	Суземского	\N	182552	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7208
Брянская область	Брянск	0	Красная Слобода	\N	Суземского	\N	182552	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Невдольск	\N	Суземского	\N	182552	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7446
Брянская область	Брянск	0	Негино	\N	Суземского	\N	182552	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7448
Брянская область	Брянск	0	Новая Погощь	\N	Суземского	\N	182552	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7459
Брянская область	Брянск	0	Новенькое	\N	Суземского	\N	182552	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7463
Брянская область	Брянск	0	Полевые Новоселки	\N	Суземского	\N	182552	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Селечня	\N	Суземского	\N	182552	\N	17-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7560
Брянская область	Брянск	0	Семеновск	\N	Суземского	\N	182552	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7564
Брянская область	Брянск	0	Страчово	\N	Суземского	\N	182552	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7610
Брянская область	Брянск	0	Суземка	\N	Суземского	ц	182552	ТГ	09-19	\N	\N	\N	\N	11	313
Брянская область	Брянск	0	Холмечи	\N	Суземского	\N	182552	\N	16-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	7644
Брянская область	Брянск	0	Андреевка	\N	Суражского	\N	182525	\N	14-18	Пн, Чт, Сб, Вс	\N	\N	\N	11	6903
Брянская область	Брянск	0	Влазовичи	\N	Суражского	\N	182525	\N	14-18	Пн, Чт, Сб, Вс	\N	\N	\N	11	7032
Брянская область	Брянск	0	Гудовка	\N	Суражского	\N	182525	\N	13-20	Пн, Ср, Чт, Вс	\N	\N	\N	11	7089
Брянская область	Брянск	0	Далисичи	\N	Суражского	\N	182525	\N	12-19	Пн, Ср ,Пт, Вс	\N	\N	\N	11	7100
Брянская область	Брянск	0	Дегтяревка	\N	Суражского	\N	182525	\N	13-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	7104
Брянская область	Брянск	0	Дубровка	\N	Суражского	\N	182525	\N	13-19	Пн, Ср, Пт	\N	\N	\N	11	7163
Брянская область	Брянск	0	Душатин	\N	Суражского	\N	182525	\N	12-20	Пн, Чт, Сб, Вс	\N	\N	\N	11	7175
Брянская область	Брянск	0	Каменск	\N	Суражского	\N	182525	\N	12-19	Пн, Чт ,Сб, Вс	\N	\N	\N	11	7216
Брянская область	Брянск	0	Костеничи	\N	Суражского	\N	182525	\N	13-19	Пн, Чт, Сб, Вс	\N	\N	\N	11	11411
Брянская область	Брянск	0	Кулаги	\N	Суражского	\N	182525	\N	13-19	Пн, Чт, Сб, Вс	\N	\N	\N	11	7312
Брянская область	Брянск	0	Лесное	\N	Суражского	\N	182525	\N	12-18	Пн, Чт, Сб, Вс	\N	\N	\N	11	7348
Брянская область	Брянск	0	Лопазна	\N	Суражского	\N	182525	\N	13-18	Пн, Чт, Сб, Вс	\N	\N	\N	11	7359
Брянская область	Брянск	0	Ляличи	\N	Суражского	\N	182525	\N	13-19	Пн, Чт, Сб, Вс	\N	\N	\N	11	7377
Брянская область	Брянск	0	Нивное	\N	Суражского	\N	182525	\N	13-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7455
Брянская область	Брянск	0	Новый Дроков	\N	Суражского	\N	182525	\N	12-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7473
Брянская область	Брянск	0	Овчинец	\N	Суражского	\N	182525	\N	12-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7481
Брянская область	Брянск	0	Слище	\N	Суражского	\N	182525	\N	14-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	7575
Брянская область	Брянск	0	Струженка	\N	Суражского	\N	182525	\N	13-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Сураж	\N	Суражского	ц	182525	ТГ	09-19	\N	\N	\N	\N	11	314
Брянская область	Брянск	0	Аладьино	\N	Трубчевского	\N	182532	\N	14-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	6885
Брянская область	Брянск	0	Алешенка	\N	Трубчевского	\N	182532	\N	16-20	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Белая Березка	\N	Трубчевского	\N	182532	\N	08-20	\N	\N	\N	\N	11	6923
Брянская область	Брянск	0	Бобовня	\N	Трубчевского	\N	182532	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	6933
Брянская область	Брянск	0	Глыбочка	\N	Трубчевского	\N	182532	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7063
Брянская область	Брянск	0	Гнилево	\N	Трубчевского	\N	182532	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7065
Брянская область	Брянск	0	Городцы	\N	Трубчевского	\N	182532	\N	15-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7074
Брянская область	Брянск	0	Красное	\N	Трубчевского	\N	182532	\N	15-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Любожичи	\N	Трубчевского	\N	182532	\N	15-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	9787
Брянская область	Брянск	0	Молчаново	\N	Трубчевского	\N	182532	\N	14-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7408
Брянская область	Брянск	0	Плюсково	\N	Трубчевского	\N	182532	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7511
Брянская область	Брянск	0	Радутино	\N	Трубчевского	\N	182532	\N	14-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7528
Брянская область	Брянск	0	Радчино	\N	Трубчевского	\N	182532	\N	17-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7529
Брянская область	Брянск	0	Рябчовск	\N	Трубчевского	\N	182532	\N	14-17	Пн, Ср, Пт, Вс	\N	\N	\N	11	7544
Брянская область	Брянск	0	Сагутьево	\N	Трубчевского	\N	182532	\N	17-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7549
Брянская область	Брянск	0	Селец	\N	Трубчевского	\N	182532	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7559
Брянская область	Брянск	0	Семячки	\N	Трубчевского	\N	182532	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7568
Брянская область	Брянск	0	Трубчевск	\N	Трубчевского	ц	182532	ТГ	08-20	\N	\N	\N	\N	11	315
Брянская область	Брянск	0	Ужа	\N	Трубчевского	\N	182532	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7633
Брянская область	Брянск	0	Усох	\N	Трубчевского	\N	182532	\N	14-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7637
Брянская область	Брянск	0	Филипповичи	\N	Трубчевского	\N	182532	\N	16-19	Пн, Ср, Пт, Вс	\N	\N	\N	11	7639
Брянская область	Брянск	0	Хотьяновка	\N	Трубчевского	\N	182532	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7650
Брянская область	Брянск	0	Юрово	\N	Трубчевского	\N	182532	\N	16-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	7679
Брянская область	Брянск	0	Березина	\N	Унечского	\N	182514	\N	14-19	Пн, Ср, Вс	\N	\N	\N	11	11464
Брянская область	Брянск	0	Брянкустичи	\N	Унечского	\N	182514	\N	15-19	Пн, Ср, Вс	\N	\N	\N	11	6976
Брянская область	Брянск	0	Высокое	\N	Унечского	\N	182514	\N	14-19	Пн, Ср, Вс	\N	\N	\N	11	11596
Брянская область	Брянск	0	Добрик	\N	Унечского	\N	182514	\N	11-15	Пн, Ср, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Красновичи	\N	Унечского	\N	182514	\N	11-15	Пн, Ср, Вс	\N	\N	\N	11	7288
Брянская область	Брянск	0	Лизогубовка	\N	Унечского	\N	182514	\N	16-19	Пн, Ср, Вс	\N	\N	\N	11	7353
Брянская область	Брянск	0	Лыщичи	\N	Унечского	\N	182514	\N	15-17	Пн, Ср, Вс	\N	\N	\N	11	7374
Брянская область	Брянск	0	Найтоповичи	\N	Унечского	\N	182514	\N	14-18	Пн, Ср, Вс	\N	\N	\N	11	7443
Брянская область	Брянск	0	Новые Ивайтенки	\N	Унечского	\N	182514	\N	15-20	Пн, Ср, Вс	\N	\N	\N	11	11375
Брянская область	Брянск	0	Павловка	\N	Унечского	\N	182514	\N	15-19	Пн, Ср, Вс	\N	\N	\N	11	7495
Брянская область	Брянск	0	Писаревка	\N	Унечского	\N	182514	\N	14-19	Пн, Ср, Вс	\N	\N	\N	11	7509
Брянская область	Брянск	0	Рассуха	\N	Унечского	\N	182514	\N	15-19	Пн, Ср, Вс	\N	\N	\N	11	7531
Брянская область	Брянск	0	Рассуха-Поселок	\N	Унечского	\N	182514	\N	15-20	Пн, Ср, Вс	\N	\N	\N	11	11323
Брянская область	Брянск	0	Рюхов	\N	Унечского	\N	182514	\N	14-19	Пн, Ср, Вс	\N	\N	\N	11	7543
Брянская область	Брянск	0	Старая Гута	\N	Унечского	\N	182514	\N	13-18	Пн, Ср, Вс	\N	\N	\N	11	7592
Брянская область	Брянск	0	Староселье	\N	Унечского	\N	182514	\N	15-20	Пн, Ср, Вс	\N	\N	\N	11	7474
Брянская область	Брянск	0	Унеча	\N	Унечского	ц	182514	ТГ	08-20	\N	\N	\N	\N	11	316
Брянская область	Брянск	0	Белые Берега	\N	Фокинского	\N	182050	\N	08-20 Сб 09-18	Вс	ЛИ-1213-18	21.06.2018	\N	11	288
Владимирская область	Владимир	0	Александров	\N	Александровского	ц	218522	ТГ	08-18 Сб 08-15	Вс	ЛИ-834-16	30.12.1899	\N	13	357
Владимирская область	Владимир	0	Андреевское	\N	Александровского	\N	218522	\N	08-13 14-16	Вс, Пн	ЛИ-677-16	30.12.1899	\N	13	8312
Владимирская область	Владимир	0	Бакино	\N	Александровского	\N	218522	\N	09-14	Вс, Пн	\N	\N	\N	13	8321
Владимирская область	Владимир	0	Бакшеево	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8322
Владимирская область	Владимир	0	Балакирево	\N	Александровского	\N	218522	\N	08-20 Сб, Вс 08-18	\N	\N	\N	\N	13	359
Владимирская область	Владимир	0	Большое Каринское	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8334
Владимирская область	Владимир	0	Годуново	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8364
Владимирская область	Владимир	0	Долгополье	\N	Александровского	\N	218522	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	13	8384
Владимирская область	Владимир	0	Искра	\N	Александровского	\N	218522	\N	08-16 Сб 08-15	Вс, Пн	\N	\N	\N	13	8406
Владимирская область	Владимир	0	Карабаново	\N	Александровского	\N	218522	\N	08-20 Сб, Вс 08-18	\N	\N	\N	\N	13	368
Владимирская область	Владимир	0	Красное Пламя	\N	Александровского	\N	218522	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	13	8425
Владимирская область	Владимир	0	Лизуново	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8444
Владимирская область	Владимир	0	Лобково	\N	Александровского	\N	218522	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	13	8447
Владимирская область	Владимир	0	Майский	\N	Александровского	\N	218522	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	13	8451
Владимирская область	Владимир	0	Махра	\N	Александровского	\N	218522	\N	09-16 Сб 09-15	Вс, Пн	\N	\N	\N	13	8457
Владимирская область	Владимир	0	Мячково	\N	Александровского	\N	218522	\N	11-14	Вс, Пн	ЛИ-3708-17	11.05.2017	\N	13	8468
Владимирская область	Владимир	0	Обашево	\N	Александровского	\N	218522	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	13	8483
Владимирская область	Владимир	0	Плеханы	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8506
Владимирская область	Владимир	0	Покров	\N	Александровского	\N	218522	\N	08-13	Вс, Пн	\N	\N	\N	13	8508
Владимирская область	Владимир	0	Поречье	\N	Александровского	\N	218522	\N	08-15	Вс, Пн	\N	\N	\N	13	8511
Владимирская область	Владимир	0	Следнево	\N	Александровского	\N	218522	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8533
Владимирская область	Владимир	0	Струнино	\N	Александровского	\N	218522	\N	08-20 Сб, Вс 08-18	\N	\N	\N	\N	13	388
Владимирская область	Владимир	0	Тириброво	\N	Александровского	\N	218522	\N	09-15	Вс, Пн	\N	\N	\N	13	8551
Владимирская область	Владимир	0	Владимир	\N	\N	ц	218ххх	ТГ	09-18	Вс	ЛИ-819-16	30.12.1899	\N	13	392
Владимирская область	Владимир	0	Лесной	\N	Владимирского	\N	218911	\N	08-20	Пн, Ср, Пт, Вс	ЛИ-8223-17	15.08.2017	\N	13	8443
Владимирская область	Владимир	0	Оргтруд	\N	Владимирского	\N	218911	\N	08-20 Сб 09-18	Вс	ЛИ-8593-17	21.08.2017	\N	13	382
Владимирская область	Владимир	0	Радужный	\N	Владимирского	\N	218911	\N	07-21	\N	\N	\N	\N	13	385
Владимирская область	Владимир	0	Энергетик	\N	Владимирского	\N	218911	\N	08-20 Сб 09-18	Вс	\N	\N	\N	13	8579
Владимирская область	Владимир	0	Юрьевец	\N	Владимирского	\N	218911	\N	08-20	Вс	\N	\N	\N	13	356
Брянская область	Брянск	0	Октябрьское	\N	Брянского	\N	182035	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5953-17	30.06.2017	\N	11	7484
Брянская область	Брянск	0	Отрадное	\N	Брянского	\N	182035	\N	09-17	Вс, Пн	ЛИ-5954-17	30.06.2017	\N	11	7492
Брянская область	Брянск	0	Пальцо	\N	Брянского	\N	182050	\N	09-17 Вт 09-16	Вс, Пн	ЛИ-13082-17	18.01.2018	\N	11	7497
Брянская область	Брянск	0	Путевка	\N	Брянского	\N	182050	\N	08-17	Вс, Пн	ЛИ-13081-17	18.01.2018	\N	11	7524
Брянская область	Брянск	0	Свень	\N	Брянского	\N	182050	\N	09-17 Пн 09-16	Вт, Вс	ЛИ-5958-17	30.06.2017	\N	11	7556
Брянская область	Брянск	0	Стеклянная Радица	\N	Брянского	\N	182035	\N	Вт 09-16 Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-5915-17	30.06.2017	\N	11	7607
Брянская область	Брянск	0	Супонево	\N	Брянского	\N	182050	\N	09-17	Пн, Вс	ЛИ-5959-17	30.06.2017	\N	11	7616
Брянская область	Брянск	0	Теменичи	\N	Брянского	\N	182035	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5960-17	30.06.2017	\N	11	7622
Брянская область	Брянск	0	Хотылево	\N	Брянского	\N	182035	\N	09-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Выгоничи	\N	Выгоничского	ц	182517	ТГ	Вт, Ср, Чт, Пт, Сб 08.00-17.00	Вс, Пн	ЛИ-749-16	30.12.1899	\N	11	289
Брянская область	Брянск	0	Городец	\N	Выгоничского	\N	182517	\N	09-16.15	Вт, Чт, Сб, Вс	ЛИ-5941-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Карповка	\N	Выгоничского	\N	182517	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-5940-17	30.06.2017	\N	11	7224
Брянская область	Брянск	0	Кокино	\N	Выгоничского	\N	182517	\N	08-17	Вс, Пн	ЛИ-5939-17	30.06.2017	\N	11	4793
Брянская область	Брянск	0	Лопушь	\N	Выгоничского	\N	182517	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5938-17	30.06.2017	\N	11	7362
Брянская область	Брянск	0	Малфа	\N	Выгоничского	\N	182517	\N	09-15.15	Пн, Ср, Пт, Вс	ЛИ-5937-17	30.06.2017	\N	11	7380
Брянская область	Брянск	0	Орменка	\N	Выгоничского	\N	182517	\N	09-16.15	Пн, Ср, Пт, Вс	ЛИ-5936-17	30.06.2017	\N	11	7488
Брянская область	Брянск	0	Пильшино	\N	Выгоничского	\N	182517	\N	08-16	Вт, Вс	ЛИ-5935-17	30.06.2017	\N	11	7508
Брянская область	Брянск	0	Сосновка	\N	Выгоничского	\N	182517	\N	08-15.30	Пн, Ср, Пт, Вс	ЛИ-5934-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Сосновое Болото	\N	Выгоничского	\N	182517	\N	09-14.20	Вт, Чт, Сб, Вс	ЛИ-5933-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Хмелево	\N	Выгоничского	\N	182517	\N	09-16.30	Вт, Чт, Сб, Вс	ЛИ-5932-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Глинное	\N	Гордеевского	\N	182535	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-5976-17	30.06.2017	\N	11	11571
Брянская область	Брянск	0	Гордеевка	\N	Гордеевского	ц	182535	ТГ	09-18	\N	\N	\N	\N	11	290
Брянская область	Брянск	0	Кожаны	\N	Гордеевского	\N	182535	\N	09-14.50	Пн, Ср, Пт, Вс	ЛИ-5977-17	30.06.2017	\N	11	7255
Брянская область	Брянск	0	Мирный	\N	Гордеевского	\N	182535	\N	09-18	Вс, Пн	ЛИ-5978-17	30.06.2017	\N	11	7395
Брянская область	Брянск	0	Перетин	\N	Гордеевского	\N	182535	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-5979-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Смяльч	\N	Гордеевского	\N	182535	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-5980-17	30.06.2017	\N	11	7580
Брянская область	Брянск	0	Творишино	\N	Гордеевского	\N	182535	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5981-17	30.06.2017	\N	11	7621
Брянская область	Брянск	0	Уношево	\N	Гордеевского	\N	182535	\N	09-18	Вт, Вс	ЛИ-5982-17	30.06.2017	\N	11	7634
Брянская область	Брянск	0	Алешинка	\N	Дубровского	\N	182513	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-5983-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Алешня	\N	Дубровского	\N	182513	\N	09-15	Вс, Пн	ЛИ-424-18	29.05.2018	\N	11	6898
Брянская область	Брянск	0	Афонино	\N	Дубровского	\N	182513	\N	10-15.20	Пн,Ср, Пт, Вс	ЛИ-5984-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Давыдчичи	\N	Дубровского	\N	182513	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5985-17	30.06.2017	\N	11	7097
Брянская область	Брянск	0	Дубровка	\N	Дубровского	ц	182513	ТГ	09-19	\N	\N	\N	\N	11	291
Брянская область	Брянск	0	Мареевка	\N	Дубровского	\N	182513	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-5987-17	30.06.2017	\N	11	7383
Брянская область	Брянск	0	Новая Салынь	\N	Дубровского	\N	182513	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-5988-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Пеклино	\N	Дубровского	\N	182513	\N	09-15.30	Вс, Пн	ЛИ-5989-17	30.06.2017	\N	11	7500
Брянская область	Брянск	0	Рековичи	\N	Дубровского	\N	182513	\N	09-15.30	Вс, Пн	ЛИ-5990-17	30.06.2017	\N	11	7533
Брянская область	Брянск	0	Рябчи	\N	Дубровского	\N	182513	\N	09-15.30	Вс, Пн	ЛИ-5991-17	30.06.2017	\N	11	7545
Брянская область	Брянск	0	Сеща	\N	Дубровского	\N	182562	\N	09-18	Вс, Пн	ЛИ-5993-17	30.06.2017	\N	11	311
Брянская область	Брянск	0	Березино	\N	Дятьковского	\N	182512	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5994-17	30.06.2017	\N	11	6927
Брянская область	Брянск	0	Будочки	\N	Дятьковского	\N	182512	\N	09-14.50	Пн, Ср, Пт, Вс	ЛИ-5995-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Бытошь	\N	Дятьковского	\N	182512	\N	08-17	Вс, Пн	ЛИ-5996-17	30.06.2017	\N	11	6186
Брянская область	Брянск	0	Дружба	\N	Дятьковского	\N	182512	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-5997-17	30.06.2017	\N	11	7160
Брянская область	Брянск	0	Дятьково	\N	Дятьковского	ц	182512	ТГ	08-20	\N	\N	\N	\N	11	292
Брянская область	Брянск	0	Ивот	\N	Дятьковского	\N	182512	\N	09-18	Вс, Пн	ЛИ-5998-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Любохна	\N	Дятьковского	\N	182512	\N	08-20 Сб 09-18	Вс	ЛИ-6000-17	30.06.2017	\N	11	4166
Брянская область	Брянск	0	Немеричи	\N	Дятьковского	\N	182512	\N	09-17	Пн, Ср, Вс	ЛИ-6001-17	30.06.2017	\N	11	7453
Брянская область	Брянск	0	Сельцо	\N	Дятьковского	\N	182512	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6003-17	30.06.2017	\N	11	7563
Брянская область	Брянск	0	Слободище	\N	Дятьковского	\N	182512	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6004-17	30.06.2017	\N	11	7576
Брянская область	Брянск	0	Старь	\N	Дятьковского	\N	182512	\N	09-18	Вс, Пн	ЛИ-6005-17	30.06.2017	\N	11	7599
Брянская область	Брянск	0	Фокино	\N	Дятьковского	\N	182512	\N	08-20 Сб 09-18	Вс	ЛИ-1210-18	21.06.2018	\N	11	317
Брянская область	Брянск	0	Фокино 1	\N	Дятьковского	\N	182512	\N	09-18	Вс, Пн	ЛИ-6007-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Воробейня	\N	Жирятинского	\N	182537	\N	09-15.30	Вт, Сб, Вс	ЛИ-6008-17	30.06.2017	\N	11	7035
Брянская область	Брянск	0	Высокое	\N	Жирятинского	\N	182537	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6009-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Жирятино	\N	Жирятинского	ц	182537	ТГ	09-17	\N	\N	\N	\N	11	293
Брянская область	Брянск	0	Княвичи	\N	Жирятинского	\N	182537	\N	09-15.15	Пн, Ср, Пт, Вс	ЛИ-6010-17	30.06.2017	\N	11	7251
Брянская область	Брянск	0	Морачово	\N	Жирятинского	\N	182537	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6013-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Норино	\N	Жирятинского	\N	182537	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-6014-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Савлуково	\N	Жирятинского	\N	182537	\N	09-14.20	Вт, Чт, Сб, Вс	ЛИ-6016-17	30.06.2017	\N	11	7546
Брянская область	Брянск	0	Быковичи	\N	Жуковского	\N	182543	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6019-17	30.06.2017	\N	11	6983
Брянская область	Брянск	0	Гостиловка	\N	Жуковского	\N	182543	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6020-17	30.06.2017	\N	11	7076
Брянская область	Брянск	0	Гришина Слобода	\N	Жуковского	\N	182543	\N	09-15.30 Пн 09-15	Вт, Вс	ЛИ-6021-17	30.06.2017	\N	11	7082
Брянская область	Брянск	0	Жуковка	\N	Жуковского	ц	182543	ТГ	08-20	\N	\N	\N	\N	11	294
Брянская область	Брянск	0	Задубравье	\N	Жуковского	\N	182543	\N	09-15	Вс, Пн	ЛИ-6022-17	30.06.2017	\N	11	7197
Брянская область	Брянск	0	Косилово	\N	Жуковского	\N	182543	\N	08.40-14.00	Вт, Чт, Сб, Вс	ЛИ-6023-17	30.06.2017	\N	11	9923
Брянская область	Брянск	0	Леденево	\N	Жуковского	\N	182543	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6024-17	30.06.2017	\N	11	7339
Брянская область	Брянск	0	Летошники	\N	Жуковского	\N	182543	\N	09-15	Вс, Пн	ЛИ-6025-17	30.06.2017	\N	11	7351
Брянская область	Брянск	0	Никольская Слобода	\N	Жуковского	\N	182543	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6026-17	30.06.2017	\N	11	7458
Брянская область	Брянск	0	Овстуг	\N	Жуковского	\N	182543	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6027-17	30.06.2017	\N	11	7478
Брянская область	Брянск	0	Олсуфьево	\N	Жуковского	\N	182543	\N	09-16	Вт, Чт, Сб, Вс	ЛИ-6028-17	30.06.2017	\N	11	7486
Брянская область	Брянск	0	Петуховка	\N	Жуковского	\N	182543	\N	09-15.30	Вт, Вс	ЛИ-6029-17	30.06.2017	\N	11	8224
Брянская область	Брянск	0	Ржаница	\N	Жуковского	\N	182543	\N	09-18	Вт, Вс	ЛИ-6030-17	30.06.2017	\N	11	7535
Брянская область	Брянск	0	Тросна	\N	Жуковского	\N	182543	\N	09-17 Сб 09-16	Вт, Вс	ЛИ-6032-17	30.06.2017	\N	11	7627
Брянская область	Брянск	0	Большие Щербиничи	\N	Злынковского	\N	182527	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-6034-17	30.06.2017	\N	11	6942
Брянская область	Брянск	0	Вышков	\N	Злынковского	\N	182527	\N	08-20 Сб 09-18	Вс	ЛИ-6035-17	30.06.2017	\N	11	11595
Брянская область	Брянск	0	Денисковичи	\N	Злынковского	\N	182527	\N	10-14.15	Вс, Пн	ЛИ-6036-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Добродеевка	\N	Злынковского	\N	182527	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6037-17	30.06.2017	\N	11	7151
Брянская область	Брянск	0	Злынка	\N	Злынковского	ц	182527	ТГ	09-19	\N	\N	\N	\N	11	295
Брянская область	Брянск	0	Карпиловка	\N	Злынковского	\N	182527	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6038-17	30.06.2017	\N	11	7221
Брянская область	Брянск	0	Кожановка	\N	Злынковского	\N	182527	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6039-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Лысые	\N	Злынковского	\N	182527	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6040-17	30.06.2017	\N	11	7373
Брянская область	Брянск	0	Малые Щербиничи	\N	Злынковского	\N	182527	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6041-17	30.06.2017	\N	11	7381
Брянская область	Брянск	0	Петрятинка	\N	Злынковского	\N	182527	\N	11-14	Пн, Ср, Пт, Вс	ЛИ-6042-17	30.06.2017	\N	11	7507
Брянская область	Брянск	0	Рогов	\N	Злынковского	\N	182527	\N	10-15.30	Вс, Пн	ЛИ-6043-17	30.06.2017	\N	11	7536
Брянская область	Брянск	0	Софиевка	\N	Злынковского	\N	182527	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6044-17	30.06.2017	\N	11	7590
Брянская область	Брянск	0	Спиридонова Буда	\N	Злынковского	\N	182527	\N	10-15.30	Вс, Пн	ЛИ-6045-17	30.06.2017	\N	11	7591
Брянская область	Брянск	0	Алексеева	\N	Карачевского	\N	182542	\N	09.30-16 Пт 09.30-15.30	Вт, Чт, Сб, Вс	ЛИ-6046-17	30.06.2017	\N	11	6890
Брянская область	Брянск	0	Березовка	\N	Карачевского	\N	182542	\N	09-17 Пн 09-16	Вт, Вс	ЛИ-6048-17	30.06.2017	\N	11	6929
Брянская область	Брянск	0	Бошино	\N	Карачевского	\N	182542	\N	08-18.30	Вт, Чт, Сб, Вс	ЛИ-6049-17	30.06.2017	\N	11	6970
Брянская область	Брянск	0	Вельяминова	\N	Карачевского	\N	182542	\N	09-17 Вт 09-16	Вс, Пн	ЛИ-6050-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Верхополье	\N	Карачевского	\N	182542	\N	09.30-16 Пт 09.30-15.30	Вт, Чт, Сб, Вс	ЛИ-6051-17	30.06.2017	\N	11	7015
Брянская область	Брянск	0	Дунаевский	\N	Карачевского	\N	182542	\N	08-18.30	Вт, Чт, Сб, Вс	ЛИ-6053-17	30.06.2017	\N	11	7172
Брянская область	Брянск	0	Карачев	\N	Карачевского	ц	182542	ТГ	08-20	\N	\N	\N	\N	11	296
Брянская область	Брянск	0	Куприна	\N	Карачевского	\N	182542	\N	09.30-16 Сб 09.30-15.30	Пн, Ср, Пт, Вс	ЛИ-6054-17	30.06.2017	\N	11	7314
Брянская область	Брянск	0	Лужецкая	\N	Карачевского	\N	182542	\N	09.30-16 Сб 09.30-15.30	Пн,Ср, Пт, Вс	ЛИ-6055-17	30.06.2017	\N	11	7366
Брянская область	Брянск	0	Масловка	\N	Карачевского	\N	182542	\N	09-17 Вт 09-16	Вс, Пн	ЛИ-6056-17	30.06.2017	\N	11	7386
Брянская область	Брянск	0	Новгородский	\N	Карачевского	\N	182542	\N	09.30-16 Пт 09.30-15.30	Вт, Чт, Сб, Вс	ЛИ-6057-17	30.06.2017	\N	11	7462
Брянская область	Брянск	0	Одрина	\N	Карачевского	\N	182542	\N	09.30-16 Пт 09.30-15.30	Вт, Чт, Сб, Вс	ЛИ-6058-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Ружное	\N	Карачевского	\N	182542	\N	10-18	Пн, Ср, Пт, Вс	ЛИ-6059-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Согласие	\N	Карачевского	\N	182542	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6060-17	30.06.2017	\N	11	7584
Брянская область	Брянск	0	Теплое	\N	Карачевского	\N	182542	\N	08-19.30	Вт, Чт, Сб, Вс	ЛИ-6061-17	30.06.2017	\N	11	7623
Брянская область	Брянск	0	Трыковка	\N	Карачевского	\N	182542	\N	09-17 Сб 09-16	Вт, Вс	ЛИ-6062-17	30.06.2017	\N	11	7628
Брянская область	Брянск	0	Юрасово	\N	Карачевского	\N	182542	\N	09.30-16 Пт 09.30-15.30	Вт, Чт, Сб, Вс	ЛИ-6063-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Акуличи	\N	Клетнянского	\N	182534	\N	09-15.30	Вс, Пн	ЛИ-6064-17	30.06.2017	\N	11	6883
Брянская область	Брянск	0	Алексеевка	\N	Клетнянского	\N	182534	\N	10-15.20 Ср 10-15	Вт, Чт, Сб, Вс	ЛИ-6065-17	30.06.2017	\N	11	6889
Брянская область	Брянск	0	Болотня	\N	Клетнянского	\N	182534	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6066-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Добрая Корна	\N	Клетнянского	\N	182534	\N	13-18	Пн, Ср, Пт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Клетня	\N	Клетнянского	ц	182534	ТГ	09-19	\N	\N	\N	\N	11	297
Брянская область	Брянск	0	Коршево	\N	Клетнянского	\N	182534	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6067-17	30.06.2017	\N	11	7272
Брянская область	Брянск	0	Лутна	\N	Клетнянского	\N	182534	\N	09-15 Пн 09-15.30	Вт, Вс	ЛИ-6068-17	30.06.2017	\N	11	7370
Брянская область	Брянск	0	Мирный	\N	Клетнянского	\N	182534	\N	09-16.30 Сб 09-16	Вс, Пн	ЛИ-6069-17	30.06.2017	\N	11	7398
Брянская область	Брянск	0	Мужиново	\N	Клетнянского	\N	182534	\N	09-15	Вс, Пн	ЛИ-6070-17	30.06.2017	\N	11	7415
Брянская область	Брянск	0	Неделька	\N	Клетнянского	\N	182534	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6071-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Новотроицкое	\N	Клетнянского	\N	182534	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6072-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Павлинки	\N	Клетнянского	\N	182534	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-6073-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Синицкое	\N	Клетнянского	\N	182534	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-6075-17	30.06.2017	\N	11	33414
Брянская область	Брянск	0	Старая Мармазовка	\N	Клетнянского	\N	182534	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-6077-17	30.06.2017	\N	11	7593
Брянская область	Брянск	0	Харитоновка	\N	Клетнянского	\N	182534	\N	12.57-16.27	Пн, Ср, Пт, Вс	ЛИ-6078-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Ширковка	\N	Клетнянского	\N	182534	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-6079-17	30.06.2017	\N	11	\N
Брянская область	Брянск	0	Брахлов	\N	Климовского	\N	182522	\N	09-15.30	Вс, Пн	ЛИ-6081-17	03.07.2017	\N	11	6972
Брянская область	Брянск	0	Вишневый	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6083-17	03.07.2017	\N	11	7029
Брянская область	Брянск	0	Воробьевка	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6084-17	03.07.2017	\N	11	7037
Брянская область	Брянск	0	Гетманская Буда	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6085-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Истопки	\N	Климовского	\N	182522	\N	09-17	Вс, Пн	ЛИ-6086-17	03.07.2017	\N	11	7212
Брянская область	Брянск	0	Каменский Хутор	\N	Климовского	\N	182522	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6088-17	03.07.2017	\N	11	7218
Брянская область	Брянск	0	Кирилловка	\N	Климовского	\N	182522	\N	09-15.30	Вс, Пн	ЛИ-6089-17	03.07.2017	\N	11	7245
Брянская область	Брянск	0	Климово	\N	Климовского	ц	182522	ТГ	09-19	\N	\N	\N	\N	11	298
Брянская область	Брянск	0	Крапивна	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6090-17	03.07.2017	\N	11	7281
Брянская область	Брянск	0	Куршановичи	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6091-17	03.07.2017	\N	11	7324
Брянская область	Брянск	0	Лакомая Буда	\N	Климовского	\N	182522	\N	09-16.30	Пн, Пт, Вс	ЛИ-6092-17	03.07.2017	\N	11	7327
Брянская область	Брянск	0	Лобановка	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6093-17	03.07.2017	\N	11	7355
Брянская область	Брянск	0	Любечане	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6094-17	03.07.2017	\N	11	7375
Брянская область	Брянск	0	Митьковка	\N	Климовского	\N	182522	\N	09-14.45	Пн, Пт, Вс	ЛИ-6095-17	03.07.2017	\N	11	7400
Брянская область	Брянск	0	Могилевцы	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6096-17	03.07.2017	\N	11	7405
Брянская область	Брянск	0	Новые Юрковичи	\N	Климовского	\N	182522	\N	09-16.30	Пн, Пт, Вс	ЛИ-6097-17	03.07.2017	\N	11	7472
Брянская область	Брянск	0	Новый Ропск	\N	Климовского	\N	182522	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6098-17	03.07.2017	\N	11	7475
Брянская область	Брянск	0	Плавна	\N	Климовского	\N	182522	\N	09-16.30 Сб 09-16	Вс, Пн	ЛИ-6099-17	03.07.2017	\N	11	7510
Брянская область	Брянск	0	Рубежное	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6100-17	03.07.2017	\N	11	7539
Брянская область	Брянск	0	Сачковичи	\N	Климовского	\N	182522	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6102-17	03.07.2017	\N	11	7555
Брянская область	Брянск	0	Соловьевка	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6103-17	03.07.2017	\N	11	7587
Брянская область	Брянск	0	Старые Юрковичи	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6104-17	03.07.2017	\N	11	7601
Брянская область	Брянск	0	Сушаны	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6106-17	03.07.2017	\N	11	7618
Брянская область	Брянск	0	Сытая Буда	\N	Климовского	\N	182522	\N	09-16.30 Сб 09-16	Вс, Пн	ЛИ-6107-17	03.07.2017	\N	11	7619
Брянская область	Брянск	0	Фоевичи	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6108-17	03.07.2017	\N	11	7640
Брянская область	Брянск	0	Хоромное	\N	Климовского	\N	182522	\N	09-17.45	Пн, Ср, Пт, Вс	ЛИ-6109-17	03.07.2017	\N	11	7647
Брянская область	Брянск	0	Хохловка	\N	Климовского	\N	182522	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6110-17	03.07.2017	\N	11	7651
Брянская область	Брянск	0	Чернооково	\N	Климовского	\N	182522	\N	09-14.20	Пн, Ср, Пт, Вс	ЛИ-6111-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Чолхов	\N	Климовского	\N	182522	\N	09-16.40	Пн, Ср, Пт, Вс	ЛИ-6112-17	03.07.2017	\N	11	6037
Брянская область	Брянск	0	Чуровичи	\N	Климовского	\N	182522	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6113-17	03.07.2017	\N	11	7664
Брянская область	Брянск	0	Ардонь	\N	Клинцовского	\N	182511	\N	09-18	Вс, Пн	ЛИ-6115-17	03.07.2017	\N	11	6905
Брянская область	Брянск	0	Великая Топаль	\N	Клинцовского	\N	182511	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6116-17	03.07.2017	\N	11	6994
Брянская область	Брянск	0	Гулевка	\N	Клинцовского	\N	182511	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-6117-17	03.07.2017	\N	11	7091
Брянская область	Брянск	0	Гута-Корецкая	\N	Клинцовского	\N	182511	\N	09-14.50	Пн, Ср, Пт, Вс	ЛИ-6118-17	03.07.2017	\N	11	7093
Брянская область	Брянск	0	Займище	\N	Клинцовского	\N	182511	\N	09-18	Вс, Пн	ЛИ-6119-17	03.07.2017	\N	11	7199
Брянская область	Брянск	0	Клинцы	\N	Клинцовского	ц	182511	ТГ	08-20	\N	\N	\N	\N	11	299
Брянская область	Брянск	0	Коржовка-Голубовка	\N	Клинцовского	\N	182511	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6120-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Лопатни	\N	Клинцовского	\N	182511	\N	09-17	Пн, Ср, Вс	ЛИ-6121-17	03.07.2017	\N	11	7361
Брянская область	Брянск	0	Мартьяновка	\N	Клинцовского	\N	182511	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-6122-17	03.07.2017	\N	11	7385
Брянская область	Брянск	0	Медведово	\N	Клинцовского	\N	182511	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-6123-17	03.07.2017	\N	11	7388
Брянская область	Брянск	0	Ольховка	\N	Клинцовского	\N	182511	\N	09-17	Вс, Пн	ЛИ-6124-17	03.07.2017	\N	11	7487
Брянская область	Брянск	0	Павличи	\N	Клинцовского	\N	182511	\N	09-17	Пн, Ср, Вс	ЛИ-6125-17	03.07.2017	\N	11	7494
Брянская область	Брянск	0	Первое Мая	\N	Клинцовского	\N	182511	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6126-17	03.07.2017	\N	11	7501
Брянская область	Брянск	0	Рожны	\N	Клинцовского	\N	182511	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-6127-17	03.07.2017	\N	11	7538
Брянская область	Брянск	0	Смолевичи	\N	Клинцовского	\N	182511	\N	09-17 Сб 09-16	Вс, Пн	ЛИ-6128-17	03.07.2017	\N	11	7578
Брянская область	Брянск	0	Смотрова Буда	\N	Клинцовского	\N	182511	\N	09-17	Вс, Пн	ЛИ-6129-17	03.07.2017	\N	11	7579
Брянская область	Брянск	0	Ущерпье	\N	Клинцовского	\N	182511	\N	09-16.15	Вс, Пн	ЛИ-6130-17	03.07.2017	\N	11	7638
Брянская область	Брянск	0	Аркино	\N	Комаричского	\N	182551	\N	10-16.20	Вт, Чт, Сб, Вс	ЛИ-6131-17	03.07.2017	\N	11	6906
Брянская область	Брянск	0	Асовица	\N	Комаричского	\N	182551	\N	09-14.20	Вт, Чт, Сб, Вс	ЛИ-6132-17	03.07.2017	\N	11	6909
Брянская область	Брянск	0	Бобрик	\N	Комаричского	\N	182551	\N	09-15.20	Вт, Чт, Сб, Вс	ЛИ-6133-17	03.07.2017	\N	11	6935
Брянская область	Брянск	0	Быхово	\N	Комаричского	\N	182551	\N	09-16	Чт, Сб, Вс	ЛИ-6134-17	03.07.2017	\N	11	6984
Брянская область	Брянск	0	Владимировка	\N	Комаричского	\N	182551	\N	09-16	Чт, Сб, Вс	ЛИ-6135-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Дерюгина	\N	Комаричского	\N	182551	\N	09-16.20	Вт, Чт, Сб, Вс	ЛИ-6136-17	03.07.2017	\N	11	11525
Брянская область	Брянск	0	Евдокимовка	\N	Комаричского	\N	182551	\N	09-15.20	Вт, Чт, Сб, Вс	ЛИ-6137-17	03.07.2017	\N	11	7178
Брянская область	Брянск	0	Игрицкое	\N	Комаричского	\N	182551	\N	09-16	Чт, Сб, Вс	ЛИ-6138-17	03.07.2017	\N	11	11457
Брянская область	Брянск	0	Кокино	\N	Комаричского	\N	182551	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-6139-17	03.07.2017	\N	11	7257
Брянская область	Брянск	0	Комаричи	\N	Комаричского	ц	182551	ТГ	09-19	\N	\N	\N	\N	11	300
Брянская область	Брянск	0	Литиж	\N	Комаричского	\N	182551	\N	09-15.20	Вт, Чт, Сб, Вс	ЛИ-6140-17	03.07.2017	\N	11	7354
Брянская область	Брянск	0	Лопандино	\N	Комаричского	\N	182551	\N	09-17 Сб 09-16	Чт, Вс	ЛИ-6141-17	03.07.2017	\N	11	7360
Брянская область	Брянск	0	Лубошево	\N	Комаричского	\N	182551	\N	09-16	Чт, Сб, Вс	ЛИ-6142-17	03.07.2017	\N	11	7364
Брянская область	Брянск	0	Марьинка	\N	Комаричского	\N	182551	\N	09-17	Чт, Вс	ЛИ-6143-17	03.07.2017	\N	11	9761
Брянская область	Брянск	0	Радогощь	\N	Комаричского	\N	182551	\N	11-17.20	Вт, Чт, Сб, Вс	ЛИ-6144-17	03.07.2017	\N	11	7527
Брянская область	Брянск	0	Тростенчик	\N	Комаричского	\N	182551	\N	10-16.20	Вт, Чт, Сб, Вс	ЛИ-6145-17	03.07.2017	\N	11	6045
Брянская область	Брянск	0	Угревище	\N	Комаричского	\N	182551	\N	09-15.20	Вт, Чт, Сб, Вс	ЛИ-6146-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Усожа	\N	Комаричского	\N	182551	\N	09-16	Ср, Сб, Вс	ЛИ-6147-17	03.07.2017	\N	11	7636
Брянская область	Брянск	0	Чернево	\N	Комаричского	\N	182551	\N	11-17.20	Вт, Чт, Сб, Вс	ЛИ-6150-17	03.07.2017	\N	11	7657
Брянская область	Брянск	0	Шарово	\N	Комаричского	\N	182551	\N	10-15.20	Вт, Чт, Сб, Вс	ЛИ-6149-17	03.07.2017	\N	11	7666
Брянская область	Брянск	0	Батуровка	\N	Красногорского	\N	182516	\N	09-14.20	Вт, Чт, Сб, Вс	ЛИ-6151-17	03.07.2017	\N	11	\N
Брянская область	Брянск	0	Верхличи	\N	Красногорского	\N	182516	\N	09-14.50	Вт, Чт, Сб, Вс	ЛИ-6152-17	03.07.2017	\N	11	7010
Брянская область	Брянск	0	Кибирщина	\N	Красногорского	\N	182516	\N	09-14.20	Вт, Чт, Сб, Вс	ЛИ-6154-17	03.07.2017	\N	11	7242
Брянская область	Брянск	0	Колюды	\N	Красногорского	\N	182516	\N	09-14.50	Пн, Ср, Пт, Вс	ЛИ-6155-17	03.07.2017	\N	11	7268
Брянская область	Брянск	0	Красная Гора	\N	Красногорского	ц	182516	ТГ	09-18	\N	\N	\N	\N	11	301
Брянская область	Брянск	0	Кургановка	\N	Красногорского	\N	182516	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-6156-17	03.07.2017	\N	11	7315
Брянская область	Брянск	0	Ларневск	\N	Красногорского	\N	182516	\N	12-17	Вс, Вт	\N	\N	\N	11	7330
Брянская область	Брянск	0	Летяхи	\N	Красногорского	\N	182516	\N	10-15	Вс, Вт	\N	\N	\N	11	7352
Брянская область	Брянск	0	Лотаки	\N	Красногорского	\N	182516	\N	12-17	Вс, Вт	\N	\N	\N	11	7363
Брянская область	Брянск	0	Любовшо	\N	Красногорского	\N	182516	\N	10-14	Вс, Вт	\N	\N	\N	11	11396
Брянская область	Брянск	0	Макаричи	\N	Красногорского	\N	182516	\N	10-15	Вс, Вт	\N	\N	\N	11	7378
Брянская область	Брянск	0	Медведи	\N	Красногорского	\N	182516	\N	10-15	Вс, Вт	\N	\N	\N	11	9757
Брянская область	Брянск	0	Палужская Рудня	\N	Красногорского	\N	182516	\N	15-17	Вс, Вт	\N	\N	\N	11	7496
Брянская область	Брянск	0	Перелазы	\N	Красногорского	\N	182516	\N	10-14	Вс, Вт	\N	\N	\N	11	7504
Брянская область	Брянск	0	Фошное	\N	Красногорского	\N	182516	\N	11-14	Вт, Вс	\N	\N	\N	11	7641
Брянская область	Брянск	0	Яловка	\N	Красногорского	\N	182516	\N	12-17	Вт, Вс	\N	\N	\N	11	7680
Брянская область	Брянск	0	Беловодка	\N	Мглинского	\N	182561	\N	15-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	6925
Брянская область	Брянск	0	Великая Дуброва	\N	Мглинского	\N	182561	\N	16-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	6991
Брянская область	Брянск	0	Вельжичи	\N	Мглинского	\N	182561	\N	16-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	6997
Брянская область	Брянск	0	Ветлевка	\N	Мглинского	\N	182561	\N	15-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Высокое	\N	Мглинского	\N	182561	\N	15-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7046
Брянская область	Брянск	0	Деремна	\N	Мглинского	\N	182561	\N	16-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	\N
Брянская область	Брянск	0	Дивовка	\N	Мглинского	\N	182561	\N	16-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7118
Брянская область	Брянск	0	Красные Косары	\N	Мглинского	\N	182561	\N	14-18	Пн, Вт, Чт, Вс	\N	\N	\N	11	7296
Брянская область	Брянск	0	Луговец	\N	Мглинского	\N	182561	\N	14-19	Пн, Вт, Чт, Вс	\N	\N	\N	11	7365
Брянская область	Брянск	0	Мглин	\N	Мглинского	ц	182561	ТГ	09-19	\N	\N	\N	\N	11	303
Волгоградская область	Волгоград	+1	Трехостровская	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	9121
Волгоградская область	Волгоград	+1	Ширяевский	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	9161
Волгоградская область	Волгоград	+1	Бузиновка	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12115-17	05.03.2018	\N	14	8641
Волгоградская область	Волгоград	+1	Вербовский	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8300-17	16.08.2017	\N	14	8651
Волгоградская область	Волгоград	+1	Дом Отдыха	\N	Калачевского	\N	117531	\N	09-15.30	Вс, Пн, Ср, Пт	ЛИ-8301-17	16.08.2017	\N	14	8712
Волгоградская область	Волгоград	+1	Донской	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-12118-17	05.03.2018	\N	14	8713
Волгоградская область	Волгоград	+1	Заря	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2618-18	24.12.2018	\N	14	8741
Волгоградская область	Волгоград	+1	Ильевка	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн	\N	\N	\N	14	8758
Волгоградская область	Волгоград	+1	Калач-На-Дону	\N	Калачевского	ц	117531	ТГ	08-20	Вс	ЛИ-3265-17	01.12.2017	\N	14	404
Волгоградская область	Волгоград	+1	Камыши	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-12119-17	05.03.2018	\N	14	8774
Волгоградская область	Волгоград	+1	Колпачки	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8305-17	16.08.2017	\N	14	8794
Волгоградская область	Волгоград	+1	Комсомольский	\N	Калачевского	\N	117531	\N	09-18	Вс, Пн	ЛИ-12121-17	05.03.2018	\N	14	8798
Волгоградская область	Волгоград	+1	Крепинский	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн	\N	\N	\N	14	8832
Волгоградская область	Волгоград	+1	Ляпичев	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн	\N	\N	\N	14	8872
Волгоградская область	Волгоград	+1	Мариновка	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн	\N	\N	\N	14	8882
Волгоградская область	Волгоград	+1	Новоляпичев	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-12122-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Октябрьский	\N	Калачевского	\N	117531	\N	09-18	Вс, Пн	\N	\N	\N	14	2720
Волгоградская область	Волгоград	+1	Пархоменко	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12123-17	05.03.2018	\N	14	8962
Волгоградская область	Волгоград	+1	Приморский	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12124-17	05.03.2018	\N	14	9002
Волгоградская область	Волгоград	+1	Прудбой	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12125-17	05.03.2018	\N	14	9006
Волгоградская область	Волгоград	+1	Пятиизбянский	\N	Калачевского	\N	117531	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12126-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Пятиморск	\N	Калачевского	\N	117531	\N	09-18	Вс, Пн	ЛИ-12127-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Рюмино-Красноярский	\N	Калачевского	\N	117531	\N	09-15.30	Вс, Пн, Ср, Пт	ЛИ-8307-17	16.08.2017	\N	14	9036
Волгоградская область	Волгоград	+1	Светлый Лог	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8309-17	16.08.2017	\N	14	9051
Волгоградская область	Волгоград	+1	Степаневка	\N	Калачевского	\N	117531	\N	09-15.30	Вс, Пн, Ср, Пт	ЛИ-8310-17	16.08.2017	\N	14	9087
Волгоградская область	Волгоград	+1	Степной	\N	Калачевского	\N	117531	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8312-17	16.08.2017	\N	14	9090
Волгоградская область	Волгоград	+1	Тихоновка	\N	Калачевского	\N	117531	\N	09-15.30	Вс, Пн, Ср, Пт	ЛИ-8313-17	16.08.2017	\N	14	9113
Волгоградская область	Волгоград	+1	Антиповка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8601
Волгоградская область	Волгоград	+1	Барановка	\N	Камышинского	\N	117521	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-12172-17	05.03.2018	\N	14	8610
Волгоградская область	Волгоград	+1	Верхняя Грязнуха	\N	Камышинского	\N	117521	\N	09-17	Вс, Пн, Пт	\N	\N	\N	14	8664
Волгоградская область	Волгоград	+1	Верхняя Добринка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8666
Волгоградская область	Волгоград	+1	Верхняя Липовка	\N	Камышинского	\N	117521	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-12173-17	05.03.2018	\N	14	5935
Волгоградская область	Волгоград	+1	Вихлянцево	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8670
Волгоградская область	Волгоград	+1	Водно-Буерачное	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8675
Волгоградская область	Волгоград	+1	Галка	\N	Камышинского	\N	117521	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-8317-17	16.08.2017	\N	14	8680
Волгоградская область	Волгоград	+1	Геселка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8583
Волгоградская область	Волгоград	+1	Госселекстанция	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8693
Волгоградская область	Волгоград	+1	Дворянское	\N	Камышинского	\N	117521	\N	09-17	Вс, Пн	\N	\N	\N	14	8705
Волгоградская область	Волгоград	+1	Камышин	\N	Камышинского	ц	117521	ТГ	08-20	Вс	ЛИ-3516-17	10.01.2019	\N	14	4690
Волгоградская область	Волгоград	+1	Костарево	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8803
Волгоградская область	Волгоград	+1	Лебяжье	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8850
Волгоградская область	Волгоград	+1	Нижняя Добринка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8919
Волгоградская область	Волгоград	+1	Петров Вал	\N	Камышинского	\N	117453	\N	08-17	Вс, Пн	\N	\N	\N	14	423
Волгоградская область	Волгоград	+1	Петрунино	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	8974
Волгоградская область	Волгоград	+1	Саломатино	\N	Камышинского	\N	117521	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-2619-18	24.12.2018	\N	14	9043
Волгоградская область	Волгоград	+1	Семеновка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9057
Волгоградская область	Волгоград	+1	Таловка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9102
Волгоградская область	Волгоград	+1	Терновка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9107
Волгоградская область	Волгоград	+1	Умет	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9128
Волгоградская область	Волгоград	+1	Усть-Грязнуха	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9132
Волгоградская область	Волгоград	+1	Чухонастовка	\N	Камышинского	\N	117521	\N	08-17	Вс, Пн	\N	\N	\N	14	9156
Волгоградская область	Волгоград	+1	Александровка	\N	Киквидзенского	\N	117554	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12175-17	01.03.2018	\N	14	8593
Волгоградская область	Волгоград	+1	Алонцево	\N	Киквидзенского	\N	117554	\N	11-16	Вс, Пн, Ср, Пт	ЛИ-8319-17	16.08.2017	\N	14	8597
Волгоградская область	Волгоград	+1	Гришин	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8696
Волгоградская область	Волгоград	+1	Дубровский	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8719
Волгоградская область	Волгоград	+1	Ежовка	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	16313
Волгоградская область	Волгоград	+1	Завязка	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	16314
Волгоградская область	Волгоград	+1	Казарино	\N	Киквидзенского	\N	117554	\N	09.30-14.00	Вс, Пн, Ср, Пт	ЛИ-8320-17	16.08.2017	\N	14	8767
Волгоградская область	Волгоград	+1	Калачевский	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8769
Волгоградская область	Волгоград	+1	Калиновский	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8771
Волгоградская область	Волгоград	+1	Мачеха	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8885
Волгоградская область	Волгоград	+1	Михайловка	\N	Киквидзенского	\N	117554	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12178-17	05.03.2018	\N	14	8896
Волгоградская область	Волгоград	+1	Мордвинцево	\N	Киквидзенского	\N	117554	\N	09.30-14.00	Вс, Пн, Ср, Пт	ЛИ-8322-17	16.08.2017	\N	14	8901
Волгоградская область	Волгоград	+1	Озерки	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	8942
Волгоградская область	Волгоград	+1	Преображенская	\N	Киквидзенского	ц	117554	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2620-18	24.12.2018	\N	14	405
Волгоградская область	Волгоград	+1	Расстригин	\N	Киквидзенского	\N	117554	\N	10-15	Вс, Пн, Ср, Пт	ЛИ-12180-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Семеновка	\N	Киквидзенского	\N	117554	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-12181-17	05.03.2018	\N	14	9058
Волгоградская область	Волгоград	+1	Страхов	\N	Киквидзенского	\N	117554	\N	10-15	Вс, Пн, Ср, Пт	ЛИ-8325-17	16.08.2017	\N	14	9092
Волгоградская область	Волгоград	+1	Чернолагутинский	\N	Киквидзенского	\N	117554	\N	08-17	Вс, Пн	\N	\N	\N	14	9153
Волгоградская область	Волгоград	+1	Верхнечеренский	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8658
Волгоградская область	Волгоград	+1	Верхняя Бузиновка	\N	Клетского	\N	117527	\N	08-17	Вс, Пн	\N	\N	\N	14	8662
Волгоградская область	Волгоград	+1	Жирковский	\N	Клетского	\N	117527	\N	10-17	Вт, Чт, Сб, Вс	ЛИ-12183-17	05.03.2018	\N	14	8731
Волгоградская область	Волгоград	+1	Захаров	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8744
Волгоградская область	Волгоград	+1	Иванушенский	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8756
Волгоградская область	Волгоград	+1	Калмыковский	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8772
Волгоградская область	Волгоград	+1	Клетская	\N	Клетского	ц	117527	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2621-18	24.12.2018	\N	14	406
Волгоградская область	Волгоград	+1	Кременская	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8831
Волгоградская область	Волгоград	+1	Логовский	\N	Клетского	\N	117527	\N	09-16	Вт, Чт, Сб, Вс	ЛИ-12184-17	05.03.2018	\N	14	8866
Волгоградская область	Волгоград	+1	Манойлин	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8881
Волгоградская область	Волгоград	+1	Мелоклетский	\N	Клетского	\N	117527	\N	09-17	Вс, Вт, Чт, Сб	ЛИ-8336-17	16.08.2017	\N	14	8890
Волгоградская область	Волгоград	+1	Новоцарицынский	\N	Клетского	\N	117527	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2622-18	24.12.2018	\N	14	8936
Волгоградская область	Волгоград	+1	Перекопка	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8965
Волгоградская область	Волгоград	+1	Перекопская	\N	Клетского	\N	117527	\N	09-16	Вс, Вт, Чт, Сб	ЛИ-12187-17	05.03.2018	\N	14	8966
Волгоградская область	Волгоград	+1	Перелазовская	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	8967
Волгоградская область	Волгоград	+1	Распопинская	\N	Клетского	\N	117527	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Селиванов	\N	Клетского	\N	117527	\N	08-17	Вс, Вт	\N	\N	\N	14	9055
Волгоградская область	Волгоград	+1	Верхнеяблочный	\N	Котельниковского	\N	117542	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8339-17	16.08.2017	\N	14	8659
Волгоградская область	Волгоград	+1	Веселый	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8667
Волгоградская область	Волгоград	+1	Выпасной	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8679
Волгоградская область	Волгоград	+1	Генералово	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8683
Волгоградская область	Волгоград	+1	Дарганов	\N	Котельниковского	\N	117542	\N	10-16.30 Сб 10-16	Пн, Ср, Пт, Вс	ЛИ-12189-17	01.03.2018	\N	14	8703
Волгоградская область	Волгоград	+1	Дорофеевский	\N	Котельниковского	\N	117542	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12190-17	01.03.2018	\N	14	8715
Волгоградская область	Волгоград	+1	Захаров	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	16315
Волгоградская область	Волгоград	+1	Котельниково	\N	Котельниковского	ц	117542	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2623-18	24.12.2018	\N	14	407
Волгоградская область	Волгоград	+1	Красноярский	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8818
Волгоградская область	Волгоград	+1	Ленино	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8854
Волгоградская область	Волгоград	+1	Майоровский	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8875
Волгоградская область	Волгоград	+1	Нагольный	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8909
Волгоградская область	Волгоград	+1	Небыков	\N	Котельниковского	\N	117542	\N	10-16.30 Сб 10-16	Вс, Пн, Ср, Пт	ЛИ-8342-17	16.08.2017	\N	14	8911
Волгоградская область	Волгоград	+1	Карагичев	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	8779
Волгоградская область	Волгоград	+1	Нижнеяблочный	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8915
Волгоградская область	Волгоград	+1	Нижние Черни	\N	Котельниковского	\N	117542	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8344-17	16.08.2017	\N	14	8916
Волгоградская область	Волгоград	+1	Пимено-Черни	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8975
Волгоградская область	Волгоград	+1	Поперечный	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	8991
Волгоградская область	Волгоград	+1	Похлебин	\N	Котельниковского	\N	117542	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8345-17	16.08.2017	\N	14	8996
Волгоградская область	Волгоград	+1	Пугачевская	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	9009
Волгоградская область	Волгоград	+1	Равнинный	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	9015
Волгоградская область	Волгоград	+1	Семичный	\N	Котельниковского	\N	117542	\N	08-17	Вс, Пн	\N	\N	\N	14	9059
Волгоградская область	Волгоград	+1	Чиганаки	\N	Котельниковского	\N	117542	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8347-17	16.08.2017	\N	14	9154
Волгоградская область	Волгоград	+1	Бурлук	\N	Котовского	\N	117552	\N	09-17	Вс, Пн	\N	\N	\N	14	8645
Волгоградская область	Волгоград	+1	Ефимовка	\N	Котовского	\N	117552	\N	08-14	Вт, Чт, Сб, Вс	ЛИ-12195-17	05.03.2018	\N	14	8730
Волгоградская область	Волгоград	+1	Коростино	\N	Котовского	\N	117552	\N	09-18	Вс, Пн	\N	\N	\N	14	8802
Волгоградская область	Волгоград	+1	Котово	\N	Котовского	ц	117552	ТГ	08.00-19.00	Вс	ЛИ-3519-17	01.12.2017	\N	14	408
Волгоградская область	Волгоград	+1	Крячки	\N	Котовского	\N	117552	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-12196-17	05.03.2018	\N	14	8836
Волгоградская область	Волгоград	+1	Купцово	\N	Котовского	\N	117552	\N	09-17	Вс, Пн	\N	\N	\N	14	8845
Волгоградская область	Волгоград	+1	Лапшинская	\N	Котовского	\N	117552	\N	08-17	Вс, Пн	\N	\N	\N	14	8848
Волгоградская область	Волгоград	+1	Мирошники	\N	Котовского	\N	117552	\N	09-17	Вс, Пн	\N	\N	\N	14	8893
Волгоградская область	Волгоград	+1	Моисеево	\N	Котовского	\N	117552	\N	09-17	Вс, Пн	\N	\N	\N	14	8899
Волгоградская область	Волгоград	+1	Мокрая Ольховка	\N	Котовского	\N	117552	\N	08-17	Вс, Пн	\N	\N	\N	14	8900
Волгоградская область	Волгоград	+1	Нижние Коробки	\N	Котовского	\N	117552	\N	08-12.50	Вт, Чт, Сб, Вс	ЛИ-12197-17	05.03.2018	\N	14	8917
Волгоградская область	Волгоград	+1	Новониколаевка	\N	Котовского	\N	117552	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-12198-17	01.03.2018	\N	14	8928
Волгоградская область	Волгоград	+1	Перещепное	\N	Котовского	\N	117552	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-12199-17	05.03.2018	\N	14	8968
Волгоградская область	Волгоград	+1	Племхоз	\N	Котовского	\N	117552	\N	08-14	Вт, Чт, Сб, Вс	ЛИ-12200-17	05.03.2018	\N	14	8979
Волгоградская область	Волгоград	+1	Попки	\N	Котовского	\N	117552	\N	09-17	Вс, Пн	\N	\N	\N	14	8992
Волгоградская область	Волгоград	+1	Романов	\N	Котовского	\N	117552	\N	09-16	Вт, Чт, Сб, Вс	ЛИ-12201-17	01.03.2018	\N	14	9031
Волгоградская область	Волгоград	+1	Слюсарево	\N	Котовского	\N	117552	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-12202-17	05.03.2018	\N	14	9069
Волгоградская область	Волгоград	+1	Смородино	\N	Котовского	\N	117552	\N	08-15	Вт, Чт, Сб, Вс	ЛИ-12203-17	05.03.2018	\N	14	9070
Волгоградская область	Волгоград	+1	Сосновка	\N	Котовского	\N	117552	\N	09-15	Вт, Чт, Сб, Вс	ЛИ-12204-17	05.03.2018	\N	14	9078
Волгоградская область	Волгоград	+1	Тарасово	\N	Котовского	\N	117552	\N	10-17	Вт, Чт, Сб, Вс	ЛИ-12205-17	05.03.2018	\N	14	9104
Волгоградская область	Волгоград	+1	Букановская	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	8642
Волгоградская область	Волгоград	+1	Галкин	\N	Кумылженского	\N	117561	\N	09-15	Вс, Пн, Ср, Пт	ЛИ-8359-17	16.08.2017	\N	14	8681
Волгоградская область	Волгоград	+1	Глазуновская	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	8684
Волгоградская область	Волгоград	+1	Еланский	\N	Кумылженского	\N	117561	\N	10-16	Вс, Пн, Ср, Пт	ЛИ-8360-17	16.08.2017	\N	14	8725
Волгоградская область	Волгоград	+1	Красноармейский	\N	Кумылженского	\N	117561	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8361-17	16.08.2017	\N	14	8809
Волгоградская область	Волгоград	+1	Краснополов	\N	Кумылженского	\N	117561	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-8362-17	16.08.2017	\N	14	8813
Волгоградская область	Волгоград	+1	Краснянский	\N	Кумылженского	\N	117561	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8363-17	16.08.2017	\N	14	8829
Волгоградская область	Волгоград	+1	Кузнечинский	\N	Кумылженского	\N	117561	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8364-17	16.08.2017	\N	14	8837
Волгоградская область	Волгоград	+1	Кумылженская	\N	Кумылженского	ц	117561	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2625-18	24.12.2018	\N	14	411
Вологодская область	Вологда	0	Шелота	\N	Верховажского	\N	146580	\N	09-18	Вт, Вс	\N	\N	\N	15	\N
Волгоградская область	Волгоград	+1	Митькин	\N	Кумылженского	\N	117561	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8365-17	16.08.2017	\N	14	8894
Волгоградская область	Волгоград	+1	Никитинский	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-8366-17	16.08.2017	\N	14	8920
Волгоградская область	Волгоград	+1	Остроухов	\N	Кумылженского	\N	117561	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12214-17	05.03.2018	\N	14	8955
Волгоградская область	Волгоград	+1	Покручинский	\N	Кумылженского	\N	117561	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-12215-17	05.03.2018	\N	14	8988
Волгоградская область	Волгоград	+1	Попов	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	8994
Волгоградская область	Волгоград	+1	Родионовский	\N	Кумылженского	\N	117561	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-12216-17	05.03.2018	\N	14	9028
Волгоградская область	Волгоград	+1	Сарычевский	\N	Кумылженского	\N	117561	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-12217-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Седов	\N	Кумылженского	\N	117561	\N	08-13 14-20 Сб 09-18	Вс	\N	\N	\N	14	9053
Волгоградская область	Волгоград	+1	Скуришенская	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	9067
Волгоградская область	Волгоград	+1	Слащевская	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	9068
Волгоградская область	Волгоград	+1	Суляевский	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	9097
Волгоградская область	Волгоград	+1	Филин	\N	Кумылженского	\N	117561	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8376-17	16.08.2017	\N	14	9137
Волгоградская область	Волгоград	+1	Чиганаки 2	\N	Кумылженского	\N	117561	\N	09-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Шакин	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн	\N	\N	\N	14	9157
Волгоградская область	Волгоград	+1	Ярской 1	\N	Кумылженского	\N	117561	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-8377-17	16.08.2017	\N	14	\N
Волгоградская область	Волгоград	+1	Бахтияровка	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8612
Волгоградская область	Волгоград	+1	Заплавное	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8739
Волгоградская область	Волгоград	+1	Заря	\N	Ленинского	\N	117545	\N	09-12.30	Вс, Пн, Ср, Пт	ЛИ-8378-17	16.08.2017	\N	14	8742
Волгоградская область	Волгоград	+1	Имени Степана Разина	\N	Ленинского	\N	117545	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8380-17	16.08.2017	\N	14	8763
Волгоградская область	Волгоград	+1	Каршевитое	\N	Ленинского	\N	117545	\N	08-14.30	Пн, Ср, Пт, Вс	ЛИ-2626-18	24.12.2018	\N	14	8782
Волгоградская область	Волгоград	+1	Колобовка	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8793
Волгоградская область	Волгоград	+1	Коммунар	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8796
Волгоградская область	Волгоград	+1	Ленинск	\N	Ленинского	ц	117545	ТГ	08.00-20.00	Вс	ЛИ-3512-17	01.12.2017	\N	14	410
Волгоградская область	Волгоград	+1	Лещев	\N	Ленинского	\N	117545	\N	08-14.30	Вс, Пн, Ср, Пт	ЛИ-8381-17	16.08.2017	\N	14	8857
Волгоградская область	Волгоград	+1	Маляевка	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8880
Волгоградская область	Волгоград	+1	Маяк Октября	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	8886
Волгоградская область	Волгоград	+1	Покровка	\N	Ленинского	\N	117545	\N	08-13 13-17	Вс, Пн	\N	\N	\N	14	8987
Волгоградская область	Волгоград	+1	Путь Ильича	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	9010
Волгоградская область	Волгоград	+1	Рассвет	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Солодовка	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-8382-17	16.08.2017	\N	14	9073
Волгоградская область	Волгоград	+1	Степное	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	9089
Волгоградская область	Волгоград	+1	Тракторострой	\N	Ленинского	\N	117545	\N	08-14.30	Вс, Пн, Ср, Пт	ЛИ-8383-17	16.08.2017	\N	14	9119
Волгоградская область	Волгоград	+1	Царев	\N	Ленинского	\N	117545	\N	08-17	Вс, Пн	\N	\N	\N	14	9148
Волгоградская область	Волгоград	+1	Абрамов	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	8586
Волгоградская область	Волгоград	+1	Арчединка	\N	Михайловского	\N	117512	\N	09-17	Вс	\N	\N	\N	14	8604
Волгоградская область	Волгоград	+1	Безымянка	\N	Михайловского	\N	117512	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	14	8613
Волгоградская область	Волгоград	+1	Большой	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	8633
Волгоградская область	Волгоград	+1	Етеревская	\N	Михайловского	\N	117512	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2628-18	24.12.2018	\N	14	1127
Волгоградская область	Волгоград	+1	Ильменский 1	\N	Михайловского	\N	117512	\N	09-13 14-15	Пн, Ср, Пт	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Ильменский 2	\N	Михайловского	\N	117512	\N	09-13 14-15	Пн, Ср, Пт	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Катасонов	\N	Михайловского	\N	117512	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2629-18	24.12.2018	\N	14	8783
Волгоградская область	Волгоград	+1	Михайловка	\N	Михайловского	ц	117512	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2627-18	24.12.2018	\N	14	415
Волгоградская область	Волгоград	+1	Моховский	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8384-17	16.08.2017	\N	14	8904
Волгоградская область	Волгоград	+1	Орлы	\N	Михайловского	\N	117512	\N	09-13 14-15	Пн, Ср, Пт	\N	\N	\N	14	8952
Волгоградская область	Волгоград	+1	Отрадное	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	8956
Волгоградская область	Волгоград	+1	Отруба	\N	Михайловского	\N	117512	\N	10-13 14-15.50	Пн, Ср, Пт	\N	\N	\N	14	8958
Волгоградская область	Волгоград	+1	Плотников 2	\N	Михайловского	\N	117512	\N	09-13 14-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Раздоры	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9017
Волгоградская область	Волгоград	+1	Реконструкция	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9024
Волгоградская область	Волгоград	+1	Рогожин	\N	Михайловского	\N	117512	\N	09-13 14-17	Пн, Ср, Пт	\N	\N	\N	14	9026
Волгоградская область	Волгоград	+1	Секачи	\N	Михайловского	\N	117512	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2630-18	24.12.2018	\N	14	9054
Волгоградская область	Волгоград	+1	Сенной	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9061
Волгоградская область	Волгоград	+1	Сидоры	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9064
Волгоградская область	Волгоград	+1	Староселье	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9085
Волгоградская область	Волгоград	+1	Субботин	\N	Михайловского	\N	117512	\N	10-13 14-15.50	Пн, Ср, Пт	\N	\N	\N	14	9095
Волгоградская область	Волгоград	+1	Сухов 2	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Троицкий	\N	Михайловского	\N	117512	\N	09-17	Вс, Пн	\N	\N	\N	14	9122
Волгоградская область	Волгоград	+1	Верхнереченский	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8656
Волгоградская область	Волгоград	+1	Денисовский	\N	Нехаевского	\N	117536	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-8385-17	16.08.2017	\N	14	8708
Волгоградская область	Волгоград	+1	Динамо	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8709
Волгоградская область	Волгоград	+1	Захоперский	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8747
Волгоградская область	Волгоград	+1	Красновский	\N	Нехаевского	\N	117536	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8387-17	16.08.2017	\N	14	8810
Волгоградская область	Волгоград	+1	Краснополье	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8814
Волгоградская область	Волгоград	+1	Кругловка	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8834
Волгоградская область	Волгоград	+1	Кулички	\N	Нехаевского	\N	117536	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8388-17	16.08.2017	\N	14	8842
Волгоградская область	Волгоград	+1	Лобачевский	\N	Нехаевского	\N	117536	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8389-17	16.08.2017	\N	14	8862
Волгоградская область	Волгоград	+1	Луковская	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8871
Волгоградская область	Волгоград	+1	Нехаевская	\N	Нехаевского	ц	117536	ТГ	08.00-17.00	Сб, Вс	ЛИ-2963-17	01.12.2017	\N	14	416
Волгоградская область	Волгоград	+1	Нижнедолговский	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	8914
Волгоградская область	Волгоград	+1	Роднички	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	9029
Волгоградская область	Волгоград	+1	Соколовский	\N	Нехаевского	\N	117536	\N	09-15	Вс, Пн, Ср, Пт	ЛИ-8392-17	16.08.2017	\N	14	9072
Волгоградская область	Волгоград	+1	Солонка	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	9075
Волгоградская область	Волгоград	+1	Тишанская	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	9114
Волгоградская область	Волгоград	+1	Тушкановский	\N	Нехаевского	\N	117536	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8393-17	16.08.2017	\N	14	9127
Волгоградская область	Волгоград	+1	Упорниковская	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	9129
Владимирская область	Владимир	0	Камешково	\N	Камешковского	ц	218533	ТГ	08-18 Сб 08-14	Вс	ЛИ-823-16	30.12.1899	\N	13	367
Владимирская область	Владимир	0	Круглово	\N	Камешковского	\N	218533	\N	09-15	Вс, Пн	\N	\N	\N	13	8435
Владимирская область	Владимир	0	Мирный	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8462
Владимирская область	Владимир	0	Новки	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8476
Владимирская область	Владимир	0	Патакино	\N	Камешковского	\N	218533	\N	08-14	Вс, Пн	\N	\N	\N	13	8496
Вологодская область	Вологда	0	Аниково	\N	Бабушкинского	\N	146598	\N	09-17	\N	\N	\N	\N	15	9181
Владимирская область	Владимир	0	Пенкино	\N	Камешковского	\N	218533	\N	08-15	Вс, Пн	\N	\N	\N	13	8498
Владимирская область	Владимир	0	Сергеиха	\N	Камешковского	\N	218533	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8529
Владимирская область	Владимир	0	Барсово	\N	Киржачского	\N	218532	\N	09-18	Сб, Вс	\N	\N	\N	13	8324
Владимирская область	Владимир	0	Горка	\N	Киржачского	\N	218532	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8368
Владимирская область	Владимир	0	Ельцы	\N	Киржачского	\N	218532	\N	09-17	Вс, Пн	\N	\N	\N	13	8113
Владимирская область	Владимир	0	Заречье	\N	Киржачского	\N	218532	\N	09-17	Вс, Пн	\N	\N	\N	13	8391
Владимирская область	Владимир	0	Кашино	\N	Киржачского	\N	218532	\N	09-17	Вс, Пн	\N	\N	\N	13	6021
Владимирская область	Владимир	0	Кипрево	\N	Киржачского	\N	218532	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8409
Владимирская область	Владимир	0	Киржач	\N	Киржачского	ц	218532	ТГ	08-17 Сб 08-15	Вс	ЛИ-824-16	30.12.1899	\N	13	369
Владимирская область	Владимир	0	Красный Октябрь	\N	Киржачского	\N	218532	\N	09-18 Сб 09-16	Вс, Пн	ЛИ-8595-17	21.08.2017	\N	13	8431
Владимирская область	Владимир	0	Першино	\N	Киржачского	\N	218532	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8502
Владимирская область	Владимир	0	Савино	\N	Киржачского	\N	218532	\N	09-15	Вс, Пн, Чт	\N	\N	\N	13	8519
Владимирская область	Владимир	0	Филипповское	\N	Киржачского	\N	218532	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8560
Владимирская область	Владимир	0	Хмелево	\N	Киржачского	\N	218532	\N	09-14	Вс, Пн, Чт	\N	\N	\N	13	8564
Владимирская область	Владимир	0	Восход	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8353
Владимирская область	Владимир	0	Гигант	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8362
Владимирская область	Владимир	0	Дмитриево	\N	Ковровского	\N	218521	\N	09-20	Вс, Пн	\N	\N	\N	13	8378
Владимирская область	Владимир	0	Достижение	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8385
Владимирская область	Владимир	0	Заря	\N	Ковровского	\N	218521	\N	08-20	Вс	\N	\N	\N	13	8392
Владимирская область	Владимир	0	Ильино	\N	Ковровского	\N	218521	\N	09-20	Вс, Пн	\N	\N	\N	13	8396
Владимирская область	Владимир	0	Им. Чкалова	\N	Ковровского	\N	218521	\N	08-20	Вс	\N	\N	\N	13	8405
Владимирская область	Владимир	0	Клязменский Городок	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Ковров	\N	Ковровского	ц	218521	ТГ	08-18.30 Сб 08-13 Сб 14-18.30	Вс	ЛИ-825-16	30.12.1899	\N	13	370
Владимирская область	Владимир	0	Красный Маяк	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8430
Владимирская область	Владимир	0	Красный Октябрь	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8432
Владимирская область	Владимир	0	Крестниково	\N	Ковровского	\N	218521	\N	09-20	Вс, Пн, Чт	\N	\N	\N	13	8433
Владимирская область	Владимир	0	Малыгино	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Мелехово	\N	Ковровского	\N	218521	\N	08-20	Вс, Пн	\N	\N	\N	13	8460
Владимирская область	Владимир	0	Нерехта	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8472
Владимирская область	Владимир	0	Новый	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8480
Владимирская область	Владимир	0	Павловское	\N	Ковровского	\N	218521	\N	11-20	Вс, Пн	\N	\N	\N	13	8488
Владимирская область	Владимир	0	Пакино	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8490
Владимирская область	Владимир	0	Пантелеево	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8491
Владимирская область	Владимир	0	Первомайский	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8499
Владимирская область	Владимир	0	Ручей	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8518
Владимирская область	Владимир	0	Сан. Им. Абельмана	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Санниково	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8524
Владимирская область	Владимир	0	Смолино	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8534
Владимирская область	Владимир	0	Шевинское	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8575
Владимирская область	Владимир	0	Эсино	\N	Ковровского	\N	218521	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8581
Владимирская область	Владимир	0	Бавлены	\N	Кольчугинского	\N	218531	\N	09-17	Сб, Вс	\N	\N	\N	13	358
Владимирская область	Владимир	0	Белая Речка	\N	Кольчугинского	\N	218531	\N	08-20	Вс	\N	\N	\N	13	8325
Владимирская область	Владимир	0	Большое Кузьминское	\N	Кольчугинского	\N	218531	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8330
Иркутская область	Иркутск	+5	Хужир	\N	Ольхонского	\N	231531	\N	13-14	Вс	\N	\N	\N	21	12198
Владимирская область	Владимир	0	Ваулово	\N	Кольчугинского	\N	218531	\N	09-14	Вс, Пн	\N	\N	\N	13	8125
Владимирская область	Владимир	0	Вишневый	\N	Кольчугинского	\N	218531	\N	08-16	Вс, Пн	\N	\N	\N	13	8347
Владимирская область	Владимир	0	Ельцино	\N	Кольчугинского	\N	218531	\N	09-12	Вс, Пн	\N	\N	\N	13	8387
Владимирская область	Владимир	0	Есиплево	\N	Кольчугинского	\N	218531	\N	08-15	Вс, Пн	\N	\N	\N	13	8108
Владимирская область	Владимир	0	Золотуха	\N	Кольчугинского	\N	218531	\N	09-16	Вс, Пн	\N	\N	\N	13	8107
Владимирская область	Владимир	0	Ильинское	\N	Кольчугинского	\N	218531	\N	10-15	Вс, Пн	\N	\N	\N	13	6022
Владимирская область	Владимир	0	Кольчугино	\N	Кольчугинского	ц	218531	ТГ	08-18 Сб 09-16	Вс	ЛИ-826-16	30.12.1899	\N	13	371
Владимирская область	Владимир	0	Коробовщинский	\N	Кольчугинского	\N	218531	\N	09-12	Вс, Пн, Чт	\N	\N	\N	13	5999
Владимирская область	Владимир	0	Литвиново	\N	Кольчугинского	\N	218531	\N	09-14	Вс, Пн	\N	\N	\N	13	5978
Владимирская область	Владимир	0	Лычево	\N	Кольчугинского	\N	218531	\N	09-14	Вс, Пн	\N	\N	\N	13	5975
Владимирская область	Владимир	0	Металлист	\N	Кольчугинского	\N	218531	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8461
Владимирская область	Владимир	0	Новобусино	\N	Кольчугинского	\N	218531	\N	09-14	Вс, Пн	\N	\N	\N	13	5968
Владимирская область	Владимир	0	Павловка	\N	Кольчугинского	\N	218531	\N	09-17	Вс, Пн	\N	\N	\N	13	5966
Владимирская область	Владимир	0	Раздолье	\N	Кольчугинского	\N	218531	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8515
Владимирская область	Владимир	0	Флорищи	\N	Кольчугинского	\N	218531	\N	09-14	Вс, Пн	\N	\N	\N	13	8556
Владимирская область	Владимир	0	Архангел	\N	Меленковского	\N	218515	\N	08-16	Вс, Пн	\N	\N	\N	13	8317
Владимирская область	Владимир	0	Большой Приклон	\N	Меленковского	\N	218515	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8335
Владимирская область	Владимир	0	Бутылицы	\N	Меленковского	\N	218515	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8340
Владимирская область	Владимир	0	Воютино	\N	Меленковского	\N	218515	\N	09-17	Вс, Пн	\N	\N	\N	13	8355
Владимирская область	Владимир	0	Данилово	\N	Меленковского	\N	218515	\N	08-16	Вс, Пн	\N	\N	\N	13	8375
Владимирская область	Владимир	0	Денятино	\N	Меленковского	\N	218515	\N	09-17	Вс, Пн	\N	\N	\N	13	8377
Владимирская область	Владимир	0	Дмитриевы Горы	\N	Меленковского	\N	218515	\N	07-11 16-20	Вс, Пн	ЛИ-9786-17	13.09.2017	\N	13	8380
Владимирская область	Владимир	0	Илькино	\N	Меленковского	\N	218515	\N	08-16	Вс, Пн	\N	\N	\N	13	8397
Владимирская область	Владимир	0	Каменка	\N	Меленковского	\N	218515	\N	10-12.30	Вс, Пн	\N	\N	\N	13	8407
Владимирская область	Владимир	0	Ляхи	\N	Меленковского	\N	218515	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8450
Владимирская область	Владимир	0	Меленки	\N	Меленковского	ц	218515	ТГ	08-13 14-18 Сб 09-14	Вс	ЛИ-827-16	30.12.1899	\N	13	377
Владимирская область	Владимир	0	Папулино	\N	Меленковского	\N	218515	\N	08-16	Вс, Пн	\N	\N	\N	13	8494
Владимирская область	Владимир	0	Тургенево	\N	Меленковского	\N	218515	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8555
Владимирская область	Владимир	0	Усад	\N	Меленковского	\N	218515	\N	09-17	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Благовещенское	\N	Муромского	\N	218511	\N	09-13	Вс, Пн	\N	\N	\N	13	8329
Владимирская область	Владимир	0	Борисоглеб	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8337
Владимирская область	Владимир	0	Булатниково	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8338
Владимирская область	Владимир	0	Вербовский	\N	Муромского	\N	218511	ТГ	08-20 Сб 10-18	Вс	\N	\N	\N	13	361
Владимирская область	Владимир	0	Дмитриевская Слобода	\N	Муромского	\N	218511	\N	08-20	Вс, Пн	\N	\N	\N	13	8379
Владимирская область	Владимир	0	Зименки	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8393
Владимирская область	Владимир	0	Ковардицы	\N	Муромского	\N	218511	\N	07-20	Вс, Пн	\N	\N	\N	13	8413
Владимирская область	Владимир	0	Кондраково	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8417
Владимирская область	Владимир	0	Красный Бор	\N	Муромского	\N	218511	\N	09-16	Вс, Пн	\N	\N	\N	13	8428
Владимирская область	Владимир	0	Кривицы	\N	Муромского	\N	218511	\N	09-16	Вс, Пн	\N	\N	\N	13	8434
Владимирская область	Владимир	0	Межищи	\N	Муромского	\N	218511	\N	09-16	Вс, Пн	\N	\N	\N	13	8458
Владимирская область	Владимир	0	Молотицы	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8464
Владимирская область	Владимир	0	Муром	\N	Муромского	ц	218511	ТГ	08-18 Сб 08-17	Вс	ЛИ-828-16	30.12.1899	\N	13	379
Владимирская область	Владимир	0	Муромский	\N	Муромского	\N	218511	\N	07-20 08-20	Вс, Пн	\N	\N	\N	13	5970
Владимирская область	Владимир	0	Панфилово	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8492
Владимирская область	Владимир	0	Пестенькино	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8504
Владимирская область	Владимир	0	Польцо	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8509
Владимирская область	Владимир	0	Прудищи	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8514
Владимирская область	Владимир	0	Савково	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8520
Владимирская область	Владимир	0	Стригино	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8546
Владимирская область	Владимир	0	Талызино	\N	Муромского	\N	218511	\N	09-15 Сб 09-13	Вс, Пн	\N	\N	\N	13	8548
Владимирская область	Владимир	0	Татарово	\N	Муромского	\N	218511	\N	09-16	Вс, Пн	\N	\N	\N	13	8550
Владимирская область	Владимир	0	Чаадаево	\N	Муромского	\N	218511	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8566
Владимирская область	Владимир	0	Якиманская Слобода	\N	Муромского	\N	218511	\N	08-20	Вс, Пн	\N	\N	\N	13	8582
Владимирская область	Владимир	0	Андреевское	\N	Петушинского	\N	218525	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8313
Владимирская область	Владимир	0	Анкудиново	\N	Петушинского	\N	218525	\N	09-16	Вс, Пн	\N	\N	\N	13	8314
Владимирская область	Владимир	0	Березка	\N	Петушинского	\N	218525	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8327
Владимирская область	Владимир	0	Болдино	\N	Петушинского	\N	218525	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8331
Владимирская область	Владимир	0	Большая Пекша	\N	Петушинского	\N	218525	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8332
Владимирская область	Владимир	0	Вольгинский	\N	Петушинского	\N	218525	\N	09-17	Вс, Пн	\N	\N	\N	13	362
Владимирская область	Владимир	0	Воспушка	\N	Петушинского	\N	218525	\N	10-15	Вс, Пн	\N	\N	\N	13	8352
Владимирская область	Владимир	0	Головино	\N	Петушинского	\N	218525	\N	Вт, Чт 09-16 Пт 09-11	Пн, Ср, Сб, Вс	ЛИ-1233-18	21.06.2018	\N	13	8365
Владимирская область	Владимир	0	Городищи	\N	Петушинского	\N	218525	\N	09-17	Вс, Пн	\N	\N	\N	13	364
Владимирская область	Владимир	0	Караваево	\N	Петушинского	\N	218525	\N	09-14	Вс, Пн	\N	\N	\N	13	8408
Владимирская область	Владимир	0	Костерево	\N	Петушинского	\N	218525	\N	09-17	Вс, Пн	\N	\N	\N	13	8421
Владимирская область	Владимир	0	Костерево-1	\N	Петушинского	\N	218525	\N	09-20	Вс	\N	\N	\N	13	372
Владимирская область	Владимир	0	Костино	\N	Петушинского	\N	218525	\N	08-16	Вс, Пн	\N	\N	\N	13	8422
Владимирская область	Владимир	0	Крутово	\N	Петушинского	\N	218525	\N	09-16	Вс, Пн	\N	\N	\N	13	8437
Владимирская область	Владимир	0	Липна	\N	Петушинского	\N	218525	\N	09-11 16-20	Вс, Пн	\N	\N	\N	13	8446
Владимирская область	Владимир	0	Марково	\N	Петушинского	\N	218525	\N	Вт, Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-1234-18	21.06.2018	\N	13	8455
Владимирская область	Владимир	0	Новое Аннино	\N	Петушинского	\N	218525	\N	08-12	Вс, Пн	\N	\N	\N	13	8479
Владимирская область	Владимир	0	Панфилово	\N	Петушинского	\N	218525	\N	Пн, Ср, Пт 10-16	Вт, Чт, Сб, Вс	ЛИ-1235-18	21.06.2018	\N	13	8493
Владимирская область	Владимир	0	Петушки	\N	Петушинского	ц	218525	ТГ	08-18 Сб 09-14	Вс	ЛИ-829-16	30.12.1899	\N	13	383
Владимирская область	Владимир	0	Покров-1	\N	Петушинского	\N	218525	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1231-18	21.06.2018	\N	13	11686
Владимирская область	Владимир	0	Покров-2	\N	Петушинского	\N	218525	\N	08-20 Сб 09-18	Вс	ЛИ-1230-18	21.06.2018	\N	13	\N
Владимирская область	Владимир	0	Покров-3	\N	Петушинского	\N	218525	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1232-18	21.06.2018	\N	13	5961
Владимирская область	Владимир	0	Санино	\N	Петушинского	\N	218525	\N	07-11 16-20	Вс, Пн	ЛИ-9785-17	13.09.2017	\N	13	8523
Владимирская область	Владимир	0	Сосновый Бор	\N	Петушинского	\N	218525	\N	Вт, Чт, Сб 10-14	Пн, Ср, Пт, Вс	ЛИ-1236-18	21.06.2018	\N	13	8539
Владимирская область	Владимир	0	Старые Омутищи	\N	Петушинского	\N	218525	\N	11-16	Вс, Пн	\N	\N	\N	13	8543
Владимирская область	Владимир	0	Сушнево-1	\N	Петушинского	\N	218525	\N	09-16	Вс, Пн	\N	\N	\N	13	8547
Владимирская область	Владимир	0	Вощиха	\N	Селивановского	\N	218535	\N	08-13	Вс, Пн, Пт	\N	\N	\N	13	8354
Владимирская область	Владимир	0	Губино	\N	Селивановского	\N	218535	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8372
Владимирская область	Владимир	0	Драчево	\N	Селивановского	\N	218535	\N	07-13 16-20	Вс, Пн	\N	\N	\N	13	8386
Владимирская область	Владимир	0	Копнино	\N	Селивановского	\N	218535	\N	07-12 16-20	Вс, Пн	\N	\N	\N	13	8418
Владимирская область	Владимир	0	Костенец	\N	Селивановского	\N	218535	\N	09-13 14-16	Вс, Пн	\N	\N	\N	13	6000
Владимирская область	Владимир	0	Красная Горбатка	\N	Селивановского	\N	218535	ТГ	07-21	\N	\N	\N	\N	13	373
Владимирская область	Владимир	0	Красная Горбатка-1	\N	Селивановского	\N	218535	\N	08-20	Вс	\N	\N	\N	13	5998
Владимирская область	Владимир	0	Красная Ушна	\N	Селивановского	\N	218535	\N	07-12 16-20	Вс, Пн	\N	\N	\N	13	8423
Владимирская область	Владимир	0	Малышево	\N	Селивановского	\N	218535	\N	07-20	Вс, Пн	\N	\N	\N	13	8453
Владимирская область	Владимир	0	Надеждино	\N	Селивановского	\N	218535	\N	09-13 14-16	Вс, Пн	\N	\N	\N	13	8469
Владимирская область	Владимир	0	Новлянка	\N	Селивановского	\N	218535	\N	07-20	Вс, Пн	\N	\N	\N	13	8477
Владимирская область	Владимир	0	Новый Быт	\N	Селивановского	\N	218535	\N	07-20	Вс, Пн	\N	\N	\N	13	8482
Владимирская область	Владимир	0	Первомайский	\N	Селивановского	\N	218535	\N	07-20	Вс, Пн	\N	\N	\N	13	8500
Владимирская область	Владимир	0	Переложниково	\N	Селивановского	\N	218535	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8501
Владимирская область	Владимир	0	Чертково	\N	Селивановского	\N	218535	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8571
Владимирская область	Владимир	0	Асерхово	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8318
Владимирская область	Владимир	0	Бабаево	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8320
Владимирская область	Владимир	0	Березники	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8328
Владимирская область	Владимир	0	Волосово	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8349
Владимирская область	Владимир	0	Ворша	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8351
Владимирская область	Владимир	0	Вышманово	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8357
Владимирская область	Владимир	0	Глухово	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8363
Владимирская область	Владимир	0	Ельтесуново	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8388
Владимирская область	Владимир	0	Жерехово	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8389
Владимирская область	Владимир	0	Заречное	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8390
Владимирская область	Владимир	0	Кишлеево	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8410
Владимирская область	Владимир	0	Колокша	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8415
Владимирская область	Владимир	0	Копнино	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8419
Владимирская область	Владимир	0	Курилово	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8440
Владимирская область	Владимир	0	Лакинск	\N	Собинского	\N	218514	\N	08-20	\N	\N	\N	\N	13	376
Владимирская область	Владимир	0	Рождествено	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8517
Владимирская область	Владимир	0	Рукав	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	5955
Владимирская область	Владимир	0	Собинка	\N	Собинского	ц	218514	ТГ	08-18	Вс	ЛИ-830-16	30.12.1899	\N	13	386
Владимирская область	Владимир	0	Ставрово	\N	Собинского	\N	218514	\N	09-18	Сб, Вс	\N	\N	\N	13	387
Владимирская область	Владимир	0	Толпухово	\N	Собинского	\N	218514	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8553
Владимирская область	Владимир	0	Фетинино	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8562
Владимирская область	Владимир	0	Черкутино	\N	Собинского	\N	218514	\N	08-15	Вс	\N	\N	\N	13	8569
Владимирская область	Владимир	0	Андреево	\N	Судогодского	\N	218524	\N	09-17 Сб 08-12	Вс	\N	\N	\N	13	8311
Владимирская область	Владимир	0	Бараки	\N	Судогодского	\N	218524	\N	07-20 Сб 07-11	Вс	\N	\N	\N	13	8323
Владимирская область	Владимир	0	Вольная Артемовка	\N	Судогодского	\N	218524	\N	09-12	Вс, Пн	\N	\N	\N	13	8350
Владимирская область	Владимир	0	Вяткино	\N	Судогодского	\N	218524	\N	08-14	Вс, Пн	\N	\N	\N	13	8358
Владимирская область	Владимир	0	Головино	\N	Судогодского	\N	218524	\N	08-20	Вс	\N	\N	\N	13	8366
Владимирская область	Владимир	0	Гонобилово	\N	Судогодского	\N	218524	\N	11-13	Вс, Пн	\N	\N	\N	13	8367
Владимирская область	Владимир	0	Ильино	\N	Судогодского	\N	218524	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	6024
Владимирская область	Владимир	0	Им. Воровского	\N	Судогодского	\N	218524	\N	08-20	Вс	\N	\N	\N	13	8400
Владимирская область	Владимир	0	Красный Богатырь	\N	Судогодского	\N	218524	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8427
Владимирская область	Владимир	0	Красный Куст	\N	Судогодского	\N	218524	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8429
Владимирская область	Владимир	0	Ликино	\N	Судогодского	\N	218524	\N	08-15	Вс, Пн	\N	\N	\N	13	8445
Владимирская область	Владимир	0	Мошок	\N	Судогодского	\N	218524	\N	09-15	Вс, Пн	\N	\N	\N	13	8466
Владимирская область	Владимир	0	Муромцево	\N	Судогодского	\N	218524	\N	08-20	Вс	\N	\N	\N	13	8467
Владимирская область	Владимир	0	Сойма	\N	Судогодского	\N	218524	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8536
Владимирская область	Владимир	0	Судогда	\N	Судогодского	ц	218524	ТГ	08-17 Сб 09-12	Вс	ЛИ-831-16	30.12.1899	\N	13	389
Владимирская область	Владимир	0	Улыбышево	\N	Судогодского	\N	218524	\N	09-14	Вс, Пн	\N	\N	\N	13	8557
Владимирская область	Владимир	0	Чамерево	\N	Судогодского	\N	218524	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8567
Владимирская область	Владимир	0	Боголюбово	\N	Суздальского	\N	218911	\N	08-20	\N	\N	\N	\N	13	360
Владимирская область	Владимир	0	Борисовское	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8336
Владимирская область	Владимир	0	Весь	\N	Суздальского	\N	218534	\N	08-14	Вс	\N	\N	\N	13	8346
Владимирская область	Владимир	0	Гавриловское	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8359
Владимирская область	Владимир	0	Добрынское	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8381
Владимирская область	Владимир	0	Клементьево	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8411
Владимирская область	Владимир	0	Красногвардейский	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8424
Владимирская область	Владимир	0	Мордыш	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8465
Владимирская область	Владимир	0	Ново-Александрово	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8473
Владимирская область	Владимир	0	Новое	\N	Суздальского	\N	218534	\N	08-14	Вс	\N	\N	\N	13	8478
Владимирская область	Владимир	0	Новый	\N	Суздальского	\N	218534	\N	08-15	Вс	\N	\N	\N	13	8481
Владимирская область	Владимир	0	Павловское	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8489
Владимирская область	Владимир	0	Порецкое	\N	Суздальского	\N	218534	\N	08-13	Вс	\N	\N	\N	13	8510
Владимирская область	Владимир	0	Садовый	\N	Суздальского	\N	218534	\N	08-20	Вс	\N	\N	\N	13	8521
Владимирская область	Владимир	0	Сновицы	\N	Суздальского	\N	218911	\N	08-16	Вс	\N	\N	\N	13	8535
Владимирская область	Владимир	0	Сокол	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8537
Владимирская область	Владимир	0	Спасское	\N	Суздальского	\N	218911	\N	08-16	Сб, Вс	\N	\N	\N	13	8538
Владимирская область	Владимир	0	Спасское Городище	\N	Суздальского	\N	218534	\N	08-13	Вс	\N	\N	\N	13	8541
Владимирская область	Владимир	0	Старый Двор	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8544
Владимирская область	Владимир	0	Суздаль	\N	Суздальского	ц	218534	ТГ	08-19	\N	ЛИ-832-16	30.12.1899	\N	13	390
Владимирская область	Владимир	0	Торчино	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8554
Владимирская область	Владимир	0	Цибеево	\N	Суздальского	\N	218534	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8565
Владимирская область	Владимир	0	Авдотьино	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8309
Владимирская область	Владимир	0	Беляницино	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8326
Владимирская область	Владимир	0	Горки	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8369
Владимирская область	Владимир	0	Косинское	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8420
Владимирская область	Владимир	0	Красное Заречье	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	5995
Владимирская область	Владимир	0	Матвейщево	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8456
Владимирская область	Владимир	0	Местечко Лучки	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	\N
Владимирская область	Владимир	0	Небылое	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8470
Владимирская область	Владимир	0	Ополье	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8486
Владимирская область	Владимир	0	Подолец	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8507
Владимирская область	Владимир	0	Семьинское	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8528
Владимирская область	Владимир	0	Сима	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8532
Владимирская область	Владимир	0	Сосновый Бор	\N	Юрьев-Польского	\N	216523	\N	09-17	Вс, Пн	\N	\N	\N	13	8540
Владимирская область	Владимир	0	Федоровское	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8561
Владимирская область	Владимир	0	Чеково	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8568
Владимирская область	Владимир	0	Шипилово	\N	Юрьев-Польского	\N	218523	\N	09-17	Вс, Пн	\N	\N	\N	13	8576
Владимирская область	Владимир	0	Шихобалово	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8577
Владимирская область	Владимир	0	Энтузиаст	\N	Юрьев-Польского	\N	218523	\N	07-11 16-20	Вс, Пн	\N	\N	\N	13	8580
Владимирская область	Владимир	0	Юрьев-Польский	\N	Юрьев-Польского	ц	218523	ТГ	08-18 Сб 08-13	Вс	ЛИ-833-16	30.12.1899	\N	13	391
Волгоградская область	Волгоград	+1	Алексеевская	\N	Алексеевского	\N	117526	ТГ	пн,вт,ср,чт,пт 08-17	Сб, Вс	ЛИ-720-16	30.12.1899	\N	14	393
Волгоградская область	Волгоград	+1	Аржановская	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11587-17	01.03.2018	\N	14	8603
Волгоградская область	Волгоград	+1	Ежовка	\N	Алексеевского	\N	117526	\N	09-12.30	Вс, Пн, Ср, Пт	ЛИ-8261-17	16.08.2017	\N	14	8724
Волгоградская область	Волгоград	+1	Исакиевский	\N	Алексеевского	\N	117526	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8262-17	16.08.2017	\N	14	8765
Волгоградская область	Волгоград	+1	Красный Октябрь	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11590-17	05.03.2018	\N	14	16317
Волгоградская область	Волгоград	+1	Ларинский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11591-17	05.03.2018	\N	14	8849
Волгоградская область	Волгоград	+1	Павловский	\N	Алексеевского	\N	117526	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-11592-17	01.03.2018	\N	14	8960
Волгоградская область	Волгоград	+1	Поклоновский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11593-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Реченский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11594-17	01.03.2018	\N	14	9025
Волгоградская область	Волгоград	+1	Рябовский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11595-17	01.03.2018	\N	14	9037
Волгоградская область	Волгоград	+1	Самолшинский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11596-17	01.03.2018	\N	14	9046
Волгоградская область	Волгоград	+1	Солонцовский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11597-17	01.03.2018	\N	14	9076
Волгоградская область	Волгоград	+1	Стеженский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11598-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Титовский	\N	Алексеевского	\N	117526	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-11599-17	01.03.2018	\N	14	9112
Волгоградская область	Волгоград	+1	Трехложинский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11600-17	05.03.2018	\N	14	9120
Волгоградская область	Волгоград	+1	Усть-Бузулукская	\N	Алексеевского	\N	117526	\N	08-17	Вс, Пн	\N	\N	\N	14	1883
Волгоградская область	Волгоград	+1	Шарашенский	\N	Алексеевского	\N	117526	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11601-17	01.03.2018	\N	14	9158
Волгоградская область	Волгоград	+1	Яминский	\N	Алексеевского	\N	117526	\N	08-17	Вс, Пн	\N	\N	\N	14	9167
Волгоградская область	Волгоград	+1	Александровка	\N	Быковского	\N	117535	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11611-17	05.03.2018	\N	14	8590
Волгоградская область	Волгоград	+1	Быково	\N	Быковского	ц	117535	ТГ	08.00-20.00	Вс	ЛИ-3411-17	01.12.2017	\N	14	396
Волгоградская область	Волгоград	+1	Верхний Балыклей	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	5940
Волгоградская область	Волгоград	+1	Демидов	\N	Быковского	\N	117535	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11612-17	01.03.2018	\N	14	8706
Волгоградская область	Волгоград	+1	Зеленый	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8748
Волгоградская область	Волгоград	+1	Катричев	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8784
Волгоградская область	Волгоград	+1	Кислово	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8788
Волгоградская область	Волгоград	+1	Красноселец	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8815
Волгоградская область	Волгоград	+1	Луговая Пролейка	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8847
Волгоградская область	Волгоград	+1	Новоникольское	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	2732
Волгоградская область	Волгоград	+1	Победа	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	8982
Волгоградская область	Волгоград	+1	Приморск	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	9001
Волгоградская область	Волгоград	+1	Садовое	\N	Быковского	\N	117535	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11614-17	05.03.2018	\N	14	9040
Волгоградская область	Волгоград	+1	Солдатско-Степное	\N	Быковского	\N	117535	\N	08-17	Вс, Пн	\N	\N	\N	14	9060
Волгоградская область	Волгоград	+1	Волгоград	\N	\N	г	117ххх	ТГ	08-20	\N	\N	\N	\N	14	3808
Волгоградская область	Волгоград	+1	Волжский	\N	\N	г	1176хх	ТГ	Пн, Вт, Ср, Чт, Пт, Сб, Вс 08.00-20.00	\N	ЛИ-3539-17	30.12.1899	\N	14	397
Волгоградская область	Волгоград	+1	Вертячий	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	8652
Волгоградская область	Волгоград	+1	Городище	\N	Городищенского	ц	117555	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2606-18	24.12.2018	\N	14	398
Волгоградская область	Волгоград	+1	Грачи	\N	Городищенского	\N	117555	\N	08-17	Вс, Пн	ЛИ-2600-18	24.12.2018	\N	14	8695
Волгоградская область	Волгоград	+1	Ерзовка	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	ЛИ-11629-17	05.03.2018	\N	14	8728
Волгоградская область	Волгоград	+1	Каменный	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	766
Волгоградская область	Волгоград	+1	Карповка	\N	Городищенского	\N	117555	\N	Пн, Вт, Ср, Пт 08-17 Сб 08-18	Чт, Вс	ЛИ-2601-18	24.12.2018	\N	14	8781
Волгоградская область	Волгоград	+1	Котлубань	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	8804
Волгоградская область	Волгоград	+1	Красный Пахарь	\N	Городищенского	\N	117555	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2602-18	24.12.2018	\N	14	8826
Волгоградская область	Волгоград	+1	Кузьмичи	\N	Городищенского	\N	117555	\N	08-17	Вс, Пн	ЛИ-2603-18	24.12.2018	\N	14	8839
Волгоградская область	Волгоград	+1	Новая Надежда	\N	Городищенского	\N	117555	\N	08-17	Чт, Вс	ЛИ-2604-18	24.12.2018	\N	14	8924
Волгоградская область	Волгоград	+1	Новый Рогачик	\N	Городищенского	\N	117555	\N	08-20 Сб 09-18	Вс	\N	\N	\N	14	8939
Волгоградская область	Волгоград	+1	Областная  сельскохозяйственная опытная станция	\N	Городищенского	\N	117555	\N	08-17	Вс, Пн	ЛИ-2605-18	24.12.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Орловка	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	8950
Волгоградская область	Волгоград	+1	Паньшино	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	8961
Волгоградская область	Волгоград	+1	Песковатка	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	8969
Волгоградская область	Волгоград	+1	Сады Придонья	\N	Городищенского	\N	117555	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-11631-17	05.03.2018	\N	14	9041
Волгоградская область	Волгоград	+1	Самофаловка 1	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	\N	\N	\N	14	9047
Волгоградская область	Волгоград	+1	Самофаловка 2	\N	Городищенского	\N	117555	\N	10-17	Пн, Ср, Пт, Вс	ЛИ-11632-17	05.03.2018	\N	14	9048
Волгоградская область	Волгоград	+1	Степной	\N	Городищенского	\N	117555	\N	09-18	Вс, Пн	ЛИ-11633-17	01.03.2018	\N	14	33265
Волгоградская область	Волгоград	+1	Гумрак 	Гумрак в черте г. Волгограда	\N	г	117066	ТГ	08-20	\N	ЛИ-3542-17	10.01.2019	\N	14	\N
Волгоградская область	Волгоград	+1	Атамановка	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8607
Волгоградская область	Волгоград	+1	Белые Пруды	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8616
Волгоградская область	Волгоград	+1	Березовская	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8621
Волгоградская область	Волгоград	+1	Гончары	\N	Даниловского	\N	117544	\N	13.15-16.40	Пн, Ср, Пт, Вс	ЛИ-11637-17	05.03.2018	\N	14	8686
Волгоградская область	Волгоград	+1	Горин	\N	Даниловского	\N	117544	\N	11-14.30	Пн, Ср, Пт, Вс	ЛИ-11639-17	05.03.2018	\N	14	8688
Волгоградская область	Волгоград	+1	Даниловка	\N	Даниловского	ц	117544	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2609-18	24.12.2018	\N	14	399
Волгоградская область	Волгоград	+1	Заплавка	\N	Даниловского	\N	117544	\N	10-14.30	Пн, Ср, Пт, Вс	ЛИ-11656-17	05.03.2018	\N	14	8738
Волгоградская область	Волгоград	+1	Заполянский	\N	Даниловского	\N	117544	\N	10-14.30	Пн, Ср, Пт, Вс	ЛИ-11658-17	05.03.2018	\N	14	8740
Волгоградская область	Волгоград	+1	Красный	\N	Даниловского	\N	117544	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11660-17	24.12.2018	\N	14	8821
Волгоградская область	Волгоград	+1	Лобойково	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8863
Волгоградская область	Волгоград	+1	Ловягин	\N	Даниловского	\N	117544	\N	09-14.45	Пн, Ср, Пт, Вс	ЛИ-11662-17	05.03.2018	\N	14	8864
Волгоградская область	Волгоград	+1	Миусово	\N	Даниловского	\N	117544	\N	12.30-17.00	Пн, Ср, Пт, Вс	ЛИ-11663-17	05.03.2018	\N	14	8895
Волгоградская область	Волгоград	+1	Орехово	\N	Даниловского	\N	117544	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2607-18	24.12.2018	\N	14	8949
Волгоградская область	Волгоград	+1	Островская	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8954
Волгоградская область	Волгоград	+1	Плотников	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	8980
Волгоградская область	Волгоград	+1	Профсоюзник	\N	Даниловского	\N	117544	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2608-18	24.12.2018	\N	14	9005
Волгоградская область	Волгоград	+1	Сергиевская	\N	Даниловского	\N	117544	\N	09-17	Вс, Пн	\N	\N	\N	14	9062
Волгоградская область	Волгоград	+1	Горная Пролейка	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	\N	\N	\N	14	8689
Волгоградская область	Волгоград	+1	Горноводяное	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	\N	\N	\N	14	8690
Волгоградская область	Волгоград	+1	Горный Балыклей	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	ЛИ-11667-17	05.03.2018	\N	14	8699
Волгоградская область	Волгоград	+1	Давыдовка	\N	Дубовского	\N	117532	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2610-18	24.12.2018	\N	14	8702
Волгоградская область	Волгоград	+1	Дубовка	\N	Дубовского	ц	117532	ТГ	08.00-20.00	Вс	ЛИ-3399-17	01.12.2017	\N	14	400
Волгоградская область	Волгоград	+1	Караваинка	\N	Дубовского	\N	117532	\N	10-13.30	Пн, Ср, Пт, Вс	ЛИ-11670-17	05.03.2018	\N	14	8778
Волгоградская область	Волгоград	+1	Лозное	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	\N	\N	\N	14	8867
Волгоградская область	Волгоград	+1	Малая Ивановка	\N	Дубовского	\N	117532	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2611-18	24.12.2018	\N	14	8878
Волгоградская область	Волгоград	+1	Оленье	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	\N	\N	\N	14	8945
Волгоградская область	Волгоград	+1	Песковатка	\N	Дубовского	\N	117532	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2612-18	24.12.2018	\N	14	8948
Волгоградская область	Волгоград	+1	Пичуга	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	ЛИ-11672-17	05.03.2018	\N	14	8978
Волгоградская область	Волгоград	+1	Прямая Балка	\N	Дубовского	\N	117532	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-2613-18	24.12.2018	\N	14	9008
Волгоградская область	Волгоград	+1	Садки	\N	Дубовского	\N	117532	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-11673-17	05.03.2018	\N	14	9039
Волгоградская область	Волгоград	+1	Семеновка	\N	Дубовского	\N	117532	\N	09-14	Пн, Ср, Пт, Вс	ЛИ-11675-17	05.03.2018	\N	14	9056
Волгоградская область	Волгоград	+1	Стрельноширокое	\N	Дубовского	\N	117532	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2614-18	24.12.2018	\N	14	9094
Волгоградская область	Волгоград	+1	Суводская	\N	Дубовского	\N	117532	\N	08-17	Вс, Пн	\N	\N	\N	14	9096
Волгоградская область	Волгоград	+1	Усть-Погожье	\N	Дубовского	\N	117532	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2615-18	24.12.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Алявы	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-11681-17	05.03.2018	\N	14	8598
Волгоградская область	Волгоград	+1	Бабинкино	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8271-17	16.08.2017	\N	14	8608
Волгоградская область	Волгоград	+1	Березовка	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	ЛИ-11684-17	05.03.2018	\N	14	8619
Волгоградская область	Волгоград	+1	Березовка 1	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11686-17	05.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Большевик	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	\N	\N	\N	14	8630
Волгоградская область	Волгоград	+1	Большой Морец	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	\N	\N	\N	14	5944
Волгоградская область	Волгоград	+1	Булгурино	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8273-17	16.08.2017	\N	14	8643
Волгоградская область	Волгоград	+1	Водопьяново	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8274-17	16.08.2017	\N	14	8676
Волгоградская область	Волгоград	+1	Волково	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8275-17	16.08.2017	\N	14	8677
Волгоградская область	Волгоград	+1	Вязовка	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	ЛИ-11690-17	01.03.2018	\N	14	33243
Волгоградская область	Волгоград	+1	Дубовое	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11691-17	05.03.2018	\N	14	8716
Волгоградская область	Волгоград	+1	Елань	\N	Еланского	ц	117541	ТГ	08.00-20.00	Вс	ЛИ-3525-17	01.12.2017	\N	14	401
Волгоградская область	Волгоград	+1	Журавка	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11692-17	05.03.2018	\N	14	8732
Волгоградская область	Волгоград	+1	Зеленый	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8276-17	16.08.2017	\N	14	8749
Волгоградская область	Волгоград	+1	Ивановка	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8277-17	16.08.2017	\N	14	8753
Волгоградская область	Волгоград	+1	Краишево	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	\N	\N	\N	14	8807
Волгоградская область	Волгоград	+1	Красноталовский	\N	Еланского	\N	117541	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-11695-17	05.03.2018	\N	14	8816
Волгоградская область	Волгоград	+1	Набат	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8279-17	16.08.2017	\N	14	8907
Волгоградская область	Волгоград	+1	Николаевка	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8280-17	16.08.2017	\N	14	8921
Волгоградская область	Волгоград	+1	Родинское	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8281-17	16.08.2017	\N	14	9027
Волгоградская область	Волгоград	+1	Таловка	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11699-17	05.03.2018	\N	14	9101
Волгоградская область	Волгоград	+1	Терновое	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11772-17	05.03.2018	\N	14	9109
Волгоградская область	Волгоград	+1	Терса	\N	Еланского	\N	117541	\N	08-17	Вс, Пн	\N	\N	\N	14	5361
Волгоградская область	Волгоград	+1	Торяное	\N	Еланского	\N	117541	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8282-17	16.08.2017	\N	14	9118
Вологодская область	Вологда	0	Чушевицы	\N	Верховажского	\N	146580	\N	09-18	Вт, Вс	\N	\N	\N	15	9660
Волгоградская область	Волгоград	+1	Тростянка	\N	Еланского	\N	117541	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-11774-17	05.03.2018	\N	14	9123
Волгоградская область	Волгоград	+1	Хвощинка	\N	Еланского	\N	117541	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-11775-17	05.03.2018	\N	14	9143
Волгоградская область	Волгоград	+1	Александровка	\N	Жирновского	\N	117523	\N	08-16	Вс, Пн	ЛИ-11776-17	05.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Алешники	\N	Жирновского	\N	117523	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-11777-17	05.03.2018	\N	14	8596
Волгоградская область	Волгоград	+1	Андреевка	\N	Жирновского	\N	117523	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-11778-17	05.03.2018	\N	14	8600
Волгоградская область	Волгоград	+1	Большая Князевка	\N	Жирновского	\N	117523	\N	08-13	Вс, Пн, Ср, Пт	ЛИ-8286-17	16.08.2017	\N	14	8628
Волгоградская область	Волгоград	+1	Бородачи	\N	Жирновского	\N	117523	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-11780-17	05.03.2018	\N	14	8636
Волгоградская область	Волгоград	+1	Бутырка	\N	Жирновского	\N	117523	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8287-17	16.08.2017	\N	14	\N
Волгоградская область	Волгоград	+1	Верхняя Добринка	\N	Жирновского	\N	117523	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-12092-17	05.03.2018	\N	14	8665
Волгоградская область	Волгоград	+1	Вишневое	\N	Жирновского	\N	117523	\N	09-15	Вс, Пн, Ср, Пт	ЛИ-12093-17	05.03.2018	\N	14	8673
Волгоградская область	Волгоград	+1	Ершовка	\N	Жирновского	\N	117523	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8289-17	16.08.2017	\N	14	8729
Волгоградская область	Волгоград	+1	Жирновск	\N	Жирновского	ц	117523	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2616-18	24.12.2018	\N	14	402
Волгоградская область	Волгоград	+1	Кленовка	\N	Жирновского	\N	117523	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12095-17	05.03.2018	\N	14	8789
Волгоградская область	Волгоград	+1	Красный Яр	\N	Жирновского	\N	117523	\N	08-18	Вс, Пн	ЛИ-12096-17	05.03.2018	\N	14	412
Волгоградская область	Волгоград	+1	Линево	\N	Жирновского	\N	117523	\N	08-18	Вс, Пн	ЛИ-12097-17	05.03.2018	\N	14	413
Волгоградская область	Волгоград	+1	Медведица	\N	Жирновского	\N	117523	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Медведицкий	\N	Жирновского	\N	117523	\N	08-17	Вс,Пн	\N	\N	\N	14	8888
Волгоградская область	Волгоград	+1	Меловатка	\N	Жирновского	\N	117523	\N	08-14	Вс, Пн, Ср, Пт	ЛИ-12098-17	05.03.2018	\N	14	8889
Волгоградская область	Волгоград	+1	Мирный	\N	Жирновского	\N	117523	\N	09-11.42	Вс, Пн, Ср, Пт	ЛИ-8292-17	16.08.2017	\N	14	8891
Волгоградская область	Волгоград	+1	Морозово	\N	Жирновского	\N	117523	\N	09-11.42	Вс, Пн, Ср, Пт	ЛИ-8293-17	16.08.2017	\N	14	8902
Волгоградская область	Волгоград	+1	Недоступов	\N	Жирновского	\N	117523	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-12101-17	01.03.2018	\N	14	8912
Волгоградская область	Волгоград	+1	Нижняя Добринка	\N	Жирновского	\N	117523	\N	08-17	Вс, Пн	ЛИ-12102-17	05.03.2018	\N	14	8918
Волгоградская область	Волгоград	+1	Новинка	\N	Жирновского	\N	117523	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-12103-17	05.03.2018	\N	14	8926
Волгоградская область	Волгоград	+1	Песковка	\N	Жирновского	\N	117523	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-8295-17	16.08.2017	\N	14	8971
Волгоградская область	Волгоград	+1	Подчинный	\N	Жирновского	\N	117523	\N	09-14	Вс, Пн, Ср, Пт	ЛИ-474-18	01.03.2018	\N	14	8985
Волгоградская область	Волгоград	+1	Тарапатино	\N	Жирновского	\N	117523	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-8297-17	16.08.2017	\N	14	9103
Волгоградская область	Волгоград	+1	Тетеревятка	\N	Жирновского	\N	117523	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-12107-17	05.03.2018	\N	14	9111
Волгоградская область	Волгоград	+1	Авилов	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	ЛИ-12108-17	01.03.2018	\N	14	8587
Волгоградская область	Волгоград	+1	Александровка	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8592
Волгоградская область	Волгоград	+1	Большая Ивановка	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8627
Волгоградская область	Волгоград	+1	Вилтов	\N	Иловлинского	\N	117525	\N	09-13	Вс, Пн, Ср, Пт	ЛИ-12109-17	01.03.2018	\N	14	8669
Волгоградская область	Волгоград	+1	Иловля	\N	Иловлинского	ц	117525	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2617-18	24.12.2018	\N	14	403
Волгоградская область	Волгоград	+1	Качалино	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8785
Волгоградская область	Волгоград	+1	Кондраши	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8801
Волгоградская область	Волгоград	+1	Кузнецов	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8838
Волгоградская область	Волгоград	+1	Лог	\N	Иловлинского	\N	117525	\N	08-17	Сб, Вс	ЛИ-12110-17	05.03.2018	\N	14	8865
Волгоградская область	Волгоград	+1	Медведев	\N	Иловлинского	\N	117525	\N	08-17	Вс, Пн	\N	\N	\N	14	8887
Волгоградская область	Волгоград	+1	Дьяконовский	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	ЛИ-13171-17	05.03.2018	\N	14	8723
Волгоградская область	Волгоград	+1	Новогригорьевская	\N	Иловлинского	\N	117525	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-12111-17	05.03.2018	\N	14	8931
Волгоградская область	Волгоград	+1	Озерки	\N	Иловлинского	\N	117525	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-12112-17	05.03.2018	\N	14	8941
Волгоградская область	Волгоград	+1	Санаторий Качалинский	\N	Иловлинского	\N	117525	\N	08-13.20	Пн, Ср, Пт, Вс	ЛИ-12113-17	05.03.2018	\N	14	9049
Волгоградская область	Волгоград	+1	Сиротинская	\N	Иловлинского	\N	117525	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-12114-17	05.03.2018	\N	14	9066
Волгоградская область	Волгоград	+1	Верхнеаксеновский	\N	Суровикинского	\N	117533	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-13148-17	01.03.2018	\N	14	33240
Волгоградская область	Волгоград	+1	Верхнесолоновский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13149-17	01.03.2018	\N	14	33241
Волгоградская область	Волгоград	+1	Верхнечирский	\N	Суровикинского	\N	117533	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-13150-17	01.03.2018	\N	14	33242
Волгоградская область	Волгоград	+1	Добринка	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13151-17	01.03.2018	\N	14	33244
Волгоградская область	Волгоград	+1	Качалин	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13152-17	01.03.2018	\N	14	33245
Волгоградская область	Волгоград	+1	Лобакин	\N	Суровикинского	\N	117533	\N	08-17	Вс, Пн	ЛИ-13153-17	01.03.2018	\N	14	33248
Волгоградская область	Волгоград	+1	Лысов	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13154-17	01.03.2018	\N	14	33249
Волгоградская область	Волгоград	+1	Майоровский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2671-18	24.12.2018	\N	14	33251
Волгоградская область	Волгоград	+1	Нижнеосиновский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13156-17	01.03.2018	\N	14	33255
Волгоградская область	Волгоград	+1	Нижний Чир	\N	Суровикинского	\N	117533	\N	08-17	Вс, Пн	ЛИ-13157-17	01.03.2018	\N	14	33256
Волгоградская область	Волгоград	+1	Новодербеновский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2672-18	24.12.2018	\N	14	33257
Волгоградская область	Волгоград	+1	Новомаксимовский	\N	Суровикинского	\N	117533	\N	08-17	Вс, Пн	ЛИ-13159-17	01.03.2018	\N	14	33258
Волгоградская область	Волгоград	+1	Савинский	\N	Суровикинского	\N	117533	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-2673-18	24.12.2018	\N	14	33263
Волгоградская область	Волгоград	+1	Синяпкинский	\N	Суровикинского	\N	117533	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-13161-17	01.03.2018	\N	14	33264
Волгоградская область	Волгоград	+1	Суворовская	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2674-18	24.12.2018	\N	14	33266
Волгоградская область	Волгоград	+1	Суровикино	\N	Суровикинского	ц	117533	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2675-18	24.12.2018	\N	14	429
Волгоградская область	Волгоград	+1	Сысоевский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13163-17	01.03.2018	\N	14	33267
Волгоградская область	Волгоград	+1	Акчернский	\N	Урюпинского	\N	117522	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13164-17	05.03.2018	\N	14	8589
Волгоградская область	Волгоград	+1	Беспаловский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2676-18	24.12.2018	\N	14	8623
Волгоградская область	Волгоград	+1	Бесплемяновский	\N	Урюпинского	\N	117522	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-2677-18	24.12.2018	\N	14	8624
Волгоградская область	Волгоград	+1	Бубновский	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	\N	\N	\N	14	8638
Волгоградская область	Волгоград	+1	Бугровский	\N	Урюпинского	\N	117522	\N	10-15	Пн, Ср, Пт, Вс	ЛИ-13184-17	01.03.2018	\N	14	8639
Волгоградская область	Волгоград	+1	Булековский	\N	Урюпинского	\N	117522	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-13185-17	01.03.2018	\N	14	8644
Волгоградская область	Волгоград	+1	Верхнебезымянский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13166-17	05.03.2018	\N	14	8654
Волгоградская область	Волгоград	+1	Верхнесоинский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13167-17	05.03.2018	\N	14	8657
Волгоградская область	Волгоград	+1	Вихлянцевский	\N	Урюпинского	\N	117522	\N	09-14	Пн, Ср, Пт, Вс	ЛИ-13186-17	01.03.2018	\N	14	8671
Волгоградская область	Волгоград	+1	Вишняковский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13168-17	05.03.2018	\N	14	8674
Волгоградская область	Волгоград	+1	Горский	\N	Урюпинского	\N	117522	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-13187-17	01.03.2018	\N	14	8691
Волгоградская область	Волгоград	+1	Добринка	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	ЛИ-13169-17	05.03.2018	\N	14	8710
Волгоградская область	Волгоград	+1	Долговский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13188-17	01.03.2018	\N	14	8711
Волгоградская область	Волгоград	+1	Дубовский	\N	Урюпинского	\N	117522	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13170-17	05.03.2018	\N	14	8717
Волгоградская область	Волгоград	+1	Забурдяевский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13172-17	05.03.2018	\N	14	8735
Волгоградская область	Волгоград	+1	Искра	\N	Урюпинского	\N	117522	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13173-17	05.03.2018	\N	14	8766
Волгоградская область	Волгоград	+1	Котовский	\N	Урюпинского	\N	117522	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13174-17	05.03.2018	\N	14	8806
Волгоградская область	Волгоград	+1	Красный	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13189-17	01.03.2018	\N	14	8822
Волгоградская область	Волгоград	+1	Краснянский	\N	Урюпинского	\N	117522	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-13175-17	05.03.2018	\N	14	8830
Волгоградская область	Волгоград	+1	Креповский	\N	Урюпинского	\N	117522	\N	08.30-17.30	Вс, Пн	ЛИ-13176-17	05.03.2018	\N	14	8833
Волгоградская область	Волгоград	+1	Криушинский	\N	Урюпинского	\N	117522	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13190-17	01.03.2018	\N	14	33246
Волгоградская область	Волгоград	+1	Лощиновский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13177-17	05.03.2018	\N	14	8869
Волгоградская область	Волгоград	+1	Михайловская	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	ЛИ-13178-17	05.03.2018	\N	14	8898
Волгоградская область	Волгоград	+1	Моховский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13191-17	01.03.2018	\N	14	33253
Волгоградская область	Волгоград	+1	Нижнеантошинский	\N	Урюпинского	\N	117522	\N	09-14	Пн, Ср, Пт, Вс	ЛИ-13192-17	01.03.2018	\N	14	33254
Волгоградская область	Волгоград	+1	Окладненский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13179-17	01.03.2018	\N	14	8943
Волгоградская область	Волгоград	+1	Ольховский	\N	Урюпинского	\N	117522	\N	09-14	Пн, Ср, Пт, Вс	ЛИ-13193-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Ольшанка	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	ЛИ-13180-17	05.03.2018	\N	14	8947
Волгоградская область	Волгоград	+1	Первомайский	\N	Урюпинского	\N	117522	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-13194-17	01.03.2018	\N	14	8963
Волгоградская область	Волгоград	+1	Петровский	\N	Урюпинского	\N	117522	\N	08-17	Вс, Пн	ЛИ-13181-17	05.03.2018	\N	14	8973
Волгоградская область	Волгоград	+1	Провоторовский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13195-17	01.03.2018	\N	14	33260
Волгоградская область	Волгоград	+1	Россошинский	\N	Урюпинского	\N	117522	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-13182-17	05.03.2018	\N	14	9033
Волгоградская область	Волгоград	+1	Салтынский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13183-17	05.03.2018	\N	14	9045
Волгоградская область	Волгоград	+1	Сычевский	\N	Урюпинского	\N	117522	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13197-17	01.03.2018	\N	14	9100
Волгоградская область	Волгоград	+1	Тепикинская	\N	Урюпинского	\N	117522	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-13198-17	01.03.2018	\N	14	9105
Волгоградская область	Волгоград	+1	Урюпинск	\N	Урюпинского	ц	117522	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2678-18	24.12.2018	\N	14	432
Волгоградская область	Волгоград	+1	Амелино	\N	Фроловского	\N	117514	\N	08-16	Пн, Ср, Пт, Вс	ЛИ-13199-17	05.03.2018	\N	14	8599
Волгоградская область	Волгоград	+1	Арчедино-Чернушинский	\N	Фроловского	\N	117514	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-13200-17	01.03.2018	\N	14	8605
Волгоградская область	Волгоград	+1	Арчединский Лесхоз	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13201-17	05.03.2018	\N	14	8606
Волгоградская область	Волгоград	+1	Верхние Липки	\N	Фроловского	\N	117514	\N	08-18	Пн, Ср, Пт, Вс	ЛИ-13203-17	05.03.2018	\N	14	8660
Волгоградская область	Волгоград	+1	Ветютнев	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13204-17	05.03.2018	\N	14	8668
Волгоградская область	Волгоград	+1	Гуляевка	\N	Фроловского	\N	117514	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13205-17	05.03.2018	\N	14	4550
Волгоградская область	Волгоград	+1	Дудаченский	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13206-17	05.03.2018	\N	14	8720
Волгоградская область	Волгоград	+1	Красные Липки	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13207-17	05.03.2018	\N	14	8820
Вологодская область	Вологда	0	Потуловская	\N	Верховажского	\N	146580	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Рогна	Кулойский Лесопункт	Верховажского	\N	146580	\N	12-17 Сб 11-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9556
Вологодская область	Вологда	0	Слобода	\N	Верховажского	\N	146580	\N	09-18	Вт, Вс	\N	\N	\N	15	9582
Вологодская область	Вологда	0	Сметанино	\N	Верховажского	\N	146580	\N	09-18	Вт, Вс	\N	\N	\N	15	9587
Вологодская область	Вологда	0	Средняя	\N	Верховажского	\N	146580	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9599
Вологодская область	Вологда	0	Урусовская	\N	Верховажского	\N	146580	\N	08-17	Вт, Вс	\N	\N	\N	15	9628
Вологодская область	Вологда	0	Феклуха	\N	Верховажского	\N	146580	\N	11-16 Пт 11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9639
Вологодская область	Вологда	0	Барановская	\N	Вожегодского	\N	146501	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9198
Вологодская область	Вологда	0	Бекетовская	\N	Вожегодского	\N	146501	\N	09-17	Вс, Чт	\N	\N	\N	15	9202
Вологодская область	Вологда	0	Вожега	\N	Вожегодского	ц	146501	ТГ	08-18	Сб, Вс	ЛИ-6714-17	11.07.2017	\N	15	443
Вологодская область	Вологда	0	Воскресенское	\N	Вожегодского	\N	146501	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Гридино	\N	Вожегодского	\N	146501	\N	08.30-17.30	Чт, Вс	\N	\N	\N	15	9280
Вологодская область	Вологда	0	Деревенька	\N	Вожегодского	\N	146501	\N	09-17	Вс, Пн	\N	\N	\N	15	9287
Вологодская область	Вологда	0	Кадниковский	\N	Вожегодского	\N	146501	\N	08-17	Вс, Пн	\N	\N	\N	15	9331
Вологодская область	Вологда	0	Козлово	\N	Вожегодского	\N	146501	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9353
Вологодская область	Вологда	0	Лукьяновская	\N	Вожегодского	\N	146501	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9400
Вологодская область	Вологда	0	Марьинская	\N	Вожегодского	\N	146501	\N	08-17	Вс, Пн	\N	\N	\N	15	9413
Вологодская область	Вологда	0	Михайловская	\N	Вожегодского	\N	146501	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9432
Вологодская область	Вологда	0	Мишутинская	\N	Вожегодского	\N	146501	\N	09-18	Вс, Пн	\N	\N	\N	15	9434
Вологодская область	Вологда	0	Нефедовская	\N	Вожегодского	\N	146501	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9454
Вологодская область	Вологда	0	Огибалово	\N	Вожегодского	\N	146501	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9485
Вологодская область	Вологда	0	Озерный	Бывш. Исаково	Вожегодского	\N	146501	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9486
Вологодская область	Вологда	0	Олеховская	\N	Вожегодского	\N	146501	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9492
Вологодская область	Вологда	0	Поздеевская	Бывш. Коротковская	Вожегодского	\N	146501	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9530
Вологодская область	Вологда	0	Пролетарский	Бывш. Явенга	Вожегодского	\N	146501	\N	09-17	Вс, Пн	\N	\N	\N	15	9548
Вологодская область	Вологда	0	Сосновица	\N	Вожегодского	\N	146501	\N	08-17	Вс, Пн	\N	\N	\N	15	9594
Вологодская область	Вологда	0	Ючка	\N	Вожегодского	\N	146501	\N	09-17 Ср, Пт 08-17	Вс, Пн	\N	\N	\N	15	9686
Вологодская область	Вологда	0	Вологда	\N	\N	\N	146ххх	ТГ	08-20	\N	\N	\N	\N	15	435
Вологодская область	Вологда	0	Лоста	\N	ВОЛОГДА	\N	146911	\N	09-17	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Oстахово	\N	Вологодского	\N	146911	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-8225-17	15.08.2017	\N	15	\N
Вологодская область	Вологда	0	Березник	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9206
Вологодская область	Вологда	0	Большое	\N	Вологодского	\N	146911	\N	10-15 Сб 09-16	Вс, Пн	\N	\N	\N	15	9218
Вологодская область	Вологда	0	Борисово	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9223
Вологодская область	Вологда	0	Васильевское	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9235
Вологодская область	Вологда	0	Грибково	\N	Вологодского	\N	146911	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9277
Вологодская область	Вологда	0	Дикая	\N	Вологодского	\N	146911	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9289
Вологодская область	Вологда	0	Дубровское	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9295
Вологодская область	Вологда	0	Ермаково	\N	Вологодского	\N	146911	\N	09-18	Вс, Пн	\N	\N	\N	15	9302
Вологодская область	Вологда	0	Заря	\N	Вологодского	\N	146911	\N	08-17 Сб 09-13	Вс, Пн	\N	\N	\N	15	5803
Вологодская область	Вологда	0	Кипелово	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9341
Вологодская область	Вологда	0	Кубенское	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9377
Вологодская область	Вологда	0	Куркино	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9389
Вологодская область	Вологда	0	Лесково	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9393
Вологодская область	Вологда	0	Майский	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9403
Вологодская область	Вологда	0	Макарово	\N	Вологодского	\N	146911	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9404
Вологодская область	Вологда	0	Можайское	\N	Вологодского	\N	146911	\N	09-14.30	Пн, Ср, Пт, Вс	\N	\N	\N	15	9436
Вологодская область	Вологда	0	Молочное	\N	Вологодского	\N	146911	\N	08-20 Сб 09-18	Вс	\N	\N	\N	15	5779
Вологодская область	Вологда	0	Морино	\N	Вологодского	\N	146911	\N	08-13	Пн, Ср, Пт, Вс	\N	\N	\N	15	9438
Вологодская область	Вологда	0	Мынчаково	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9444
Вологодская область	Вологда	0	Надеево	\N	Вологодского	\N	146911	\N	09-17	Вс, Пн	\N	\N	\N	15	9446
Вологодская область	Вологда	0	Непотягово	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9450
Вологодская область	Вологда	0	Нефедово	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9453
Вологодская область	Вологда	0	Новленское	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9474
Вологодская область	Вологда	0	Новый Источник	\N	Вологодского	\N	146911	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	5753
Вологодская область	Вологда	0	Норобово	\N	Вологодского	\N	146911	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9482
Вологодская область	Вологда	0	Огарково	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9484
Вологодская область	Вологда	0	Омогаево	\N	Вологодского	\N	146911	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9494
Вологодская область	Вологда	0	Перьево	\N	Вологодского	\N	146911	\N	09-17	Вс, Пн	\N	\N	\N	15	9512
Вологодская область	Вологда	0	Погорелово	\N	Вологодского	\N	146911	\N	09-18	Пн, Ср, Пт, Вс	\N	\N	\N	15	9524
Вологодская область	Вологда	0	Прилуки	\N	Вологодского	\N	146911	\N	09-18	Вс, Пн	\N	\N	\N	15	9545
Вологодская область	Вологда	0	Светилки	\N	Вологодского	\N	146911	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9564
Вологодская область	Вологда	0	Севастьяново	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	5735
Вологодская область	Вологда	0	Северная Ферма	\N	Вологодского	\N	146911	\N	09-14.30	Пн, Ср, Пт, Вс	\N	\N	\N	15	9569
Вологодская область	Вологда	0	Семенково	\N	Вологодского	\N	146911	\N	08-17	Сб, Вс	\N	\N	\N	15	5724
Вологодская область	Вологда	0	Сосновка	\N	Вологодского	\N	146911	\N	09-18	Вс, Пн	\N	\N	\N	15	9595
Вологодская область	Вологда	0	Стризнево	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9600
Вологодская область	Вологда	0	Уткино	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	9635
Вологодская область	Вологда	0	Федотово	\N	Вологодского	\N	146911	\N	08-17	Вс, Пн	\N	\N	\N	15	8843
Вологодская область	Вологда	0	Фофанцево	\N	Вологодского	\N	146911	\N	09-17	Вс, Пн	\N	\N	\N	15	9643
Вологодская область	Вологда	0	Шолохово	\N	Вологодского	\N	146911	\N	09-14.30	Пн, Ср, Пт, Вс	\N	\N	\N	15	9674
Вологодская область	Вологда	0	Янгосарь	\N	Вологодского	\N	146911	\N	09-14.30	Пн, Ср, Пт, Вс	\N	\N	\N	15	9690
Вологодская область	Вологда	0	Андомский Погост	\N	Вытегорского	\N	146513	\N	07-20	\N	\N	\N	\N	15	9179
Вологодская область	Вологда	0	Анненский Мост	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9185
Вологодская область	Вологда	0	Белоусово	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9203
Вологодская область	Вологда	0	Волков Мост	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Вытегра	\N	Вытегорского	ц	146513	ТГ	09-17	Вс	ЛИ-6715-17	11.07.2017	\N	15	445
Вологодская область	Вологда	0	Девятины	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9283
Вологодская область	Вологда	0	Депо	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9286
Вологодская область	Вологда	0	Захарьино	\N	Вытегорского	\N	146513	\N	передвижной	Пн, Ср, Пт, Вс	\N	\N	\N	15	9315
Вологодская область	Вологда	0	Кондуши	\N	Вытегорского	\N	146513	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	5788
Волгоградская область	Волгоград	+1	Лычак	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13208-17	01.03.2018	\N	14	33250
Волгоградская область	Волгоград	+1	Малодельская	\N	Фроловского	\N	117514	\N	Вт, Чт 09.15-17 Сб 09.15-16.50 Ср 09.15-16	Пн, Пт, Вс	ЛИ-13209-17	05.03.2018	\N	14	8879
Волгоградская область	Волгоград	+1	Образцы	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13210-17	05.03.2018	\N	14	8940
Волгоградская область	Волгоград	+1	Писаревка	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13212-17	05.03.2018	\N	14	8977
Волгоградская область	Волгоград	+1	Пригородный	\N	Фроловского	\N	117514	\N	08-20 Сб 09-18	Вс	ЛИ-13213-17	05.03.2018	\N	14	9000
Волгоградская область	Волгоград	+1	Рубежный	\N	Фроловского	\N	117514	\N	09-14	Пн, Ср, Пт, Вс	ЛИ-13214-17	05.03.2018	\N	14	9034
Волгоградская область	Волгоград	+1	Терновка	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13215-17	05.03.2018	\N	14	9108
Волгоградская область	Волгоград	+1	Фролово	\N	Фроловского	ц	117514	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2680-18	24.12.2018	\N	14	433
Волгоградская область	Волгоград	+1	Шуруповский	\N	Фроловского	\N	117514	\N	09-17.30	Пн, Ср, Пт, Вс	ЛИ-13216-17	05.03.2018	\N	14	9163
Волгоградская область	Волгоград	+1	Алешкин	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13217-17	05.03.2018	\N	14	8595
Волгоградская область	Волгоград	+1	Басакин	\N	Чернышковского	\N	117563	\N	08-17	Вс, Пн	\N	\N	\N	14	8611
Волгоградская область	Волгоград	+1	Большетерновой	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13218-17	05.03.2018	\N	14	8629
Волгоградская область	Волгоград	+1	Верхнегнутов	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13219-17	05.03.2018	\N	14	8647
Волгоградская область	Волгоград	+1	Волоцкий	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2681-18	24.12.2018	\N	14	8678
Волгоградская область	Волгоград	+1	Елкино	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13221-17	05.03.2018	\N	14	8726
Волгоградская область	Волгоград	+1	Захаров	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13222-17	05.03.2018	\N	14	8745
Волгоградская область	Волгоград	+1	Красноярский	\N	Чернышковского	\N	117563	\N	08-17	Вс, Пн	\N	\N	\N	14	8819
Волгоградская область	Волгоград	+1	Морской	\N	Чернышковского	\N	117563	\N	10-17	Пн, Ср, Пт, Вс	ЛИ-2682-18	24.12.2018	\N	14	33252
Волгоградская область	Волгоград	+1	Нижнегнутов	\N	Чернышковского	\N	117563	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Попов	\N	Чернышковского	\N	117563	\N	10-17	Пн, Ср, Пт, Вс	ЛИ-13224-17	01.03.2018	\N	14	8995
Волгоградская область	Волгоград	+1	Пристеновский	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13225-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Сизов	\N	Чернышковского	\N	117563	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13226-17	05.03.2018	\N	14	9065
Волгоградская область	Волгоград	+1	Тормосин	\N	Чернышковского	\N	117563	\N	08-17	Вс, Пн	\N	\N	\N	14	9117
Волгоградская область	Волгоград	+1	Чернышковский	\N	Чернышковского	ц	117563	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2683-18	24.12.2018	\N	14	434
Вологодская область	Вологда	0	Акишево	\N	Бабаевского	\N	146516	\N	09-17	\N	\N	\N	\N	15	9172
Вологодская область	Вологда	0	Аксентьевская	Бывш.Чубрино	Бабаевского	\N	146516	\N	09-17	\N	\N	\N	\N	15	9175
Вологодская область	Вологда	0	Александровское	Бывш.Волкова	Бабаевского	\N	146516	\N	09-17	\N	\N	\N	\N	15	9176
Вологодская область	Вологда	0	Бабаево	\N	Бабаевского	ц	146516	ТГ	08-17 Сб 09-16	Вс	ЛИ-6710-17	11.07.2017	\N	15	437
Вологодская область	Вологда	0	Борисово-Судское	\N	Бабаевского	\N	146516	\N	08-17	Вс, Пн	\N	\N	\N	15	9225
Вологодская область	Вологда	0	Верхневольский	\N	Бабаевского	\N	146516	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9244
Вологодская область	Вологда	0	Володино	\N	Бабаевского	\N	146516	\N	08-17	Вс, Пн	\N	\N	\N	15	9252
Вологодская область	Вологда	0	Горка	Бывш. Команево	Бабаевского	\N	146516	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9273
Вологодская область	Вологда	0	Григорьевское	\N	Бабаевского	\N	146516	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9279
Вологодская область	Вологда	0	Дубровка	\N	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9293
Вологодская область	Вологда	0	Заполье	Бывш. Сиуч	Бабаевского	\N	146516	\N	09-16 Пт 09-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9285
Вологодская область	Вологда	0	Кийно	Бывш. Панкратово	Бабаевского	\N	146516	\N	09-16 Сб 09-13	Пн, Ср, Пт, Вс	\N	\N	\N	15	9339
Вологодская область	Вологда	0	Клавдино	Бывш. Слудно	Бабаевского	\N	146516	\N	09-16.30 Сб 09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9343
Вологодская область	Вологда	0	Клюшово	Бывш. Чистиково	Бабаевского	\N	146516	\N	09-16 Сб 09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9346
Вологодская область	Вологда	0	Колошма	\N	Бабаевского	\N	146516	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	8856
Вологодская область	Вологда	0	Костеньково	\N	Бабаевского	\N	146516	\N	09-13	Вс, Пн	\N	\N	\N	15	9369
Вологодская область	Вологда	0	Малое Борисово	\N	Бабаевского	\N	146516	\N	09-16 Сб 09-13	Пн, Ср, Пт, Вс	\N	\N	\N	15	9407
Вологодская область	Вологда	0	Нижняя Ножема	\N	Бабаевского	\N	146516	\N	09-16 Сб 09-13	Пн, Ср, Пт, Вс	\N	\N	\N	15	9462
Вологодская область	Вологда	0	Новое Лукино	\N	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9476
Вологодская область	Вологда	0	Плесо	\N	Бабаевского	\N	146516	\N	10-17 Сб 10-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9521
Вологодская область	Вологда	0	Пожара	\N	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9528
Вологодская область	Вологда	0	Пяжелка	\N	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9550
Вологодская область	Вологда	0	Смородинка	\N	Бабаевского	\N	146516	\N	08-17	Вс, Пн	\N	\N	\N	15	9588
Вологодская область	Вологда	0	Тимохино	Бывш. Санинское	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9616
Вологодская область	Вологда	0	Тимошино	\N	Бабаевского	\N	146516	\N	09-18	Вс, Пн	\N	\N	\N	15	9617
Вологодская область	Вологда	0	Тимошкино	\N	Бабаевского	\N	146516	\N	09-16 Пт 09-13	Вт, Чт, Сб, Вс	\N	\N	\N	15	9614
Вологодская область	Вологда	0	Шогда	\N	Бабаевского	\N	146516	\N	10-17 Сб 10-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9673
Вологодская область	Вологда	0	Великий Двор	\N	Бабушкинского	\N	146598	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9238
Вологодская область	Вологда	0	Воскресенское	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Чт	\N	\N	\N	15	9257
Вологодская область	Вологда	0	Демьяновский Погост	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Жубрино	\N	Бабушкинского	\N	146598	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9306
Вологодская область	Вологда	0	Зайчики	\N	Бабушкинского	\N	146598	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9310
Вологодская область	Вологда	0	Им. Бабушкина	\N	Бабушкинского	ц	146598	ТГ	08-20 Сб 08-18	Вс	ЛИ-6717-17	11.07.2017	\N	15	438
Вологодская область	Вологда	0	Козлец	Бывш. Крутец	Бабушкинского	\N	146598	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9352
Вологодская область	Вологда	0	Кокшарка	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Пн	\N	\N	\N	15	9355
Вологодская область	Вологда	0	Комсомольский	\N	Бабушкинского	\N	146598	\N	10-16 Ср 10-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9357
Вологодская область	Вологда	0	Косиково	\N	Бабушкинского	\N	146598	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9367
Вологодская область	Вологда	0	Кулибарово	\N	Бабушкинского	\N	146598	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9383
Вологодская область	Вологда	0	Кунож	\N	Бабушкинского	\N	146598	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9386
Вологодская область	Вологда	0	Логдуз	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Пн	\N	\N	\N	15	9397
Вологодская область	Вологда	0	Миньково	\N	Бабушкинского	\N	146598	\N	08-17	Вс, Пн	\N	\N	\N	15	9425
Вологодская область	Вологда	0	Рослятино	\N	Бабушкинского	\N	146598	\N	08-17	Вс, Пн	\N	\N	\N	15	9559
Вологодская область	Вологда	0	Тиманова Гора	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Юркино	\N	Бабушкинского	\N	146598	\N	09-18	Вс, Чт	\N	\N	\N	15	9683
Вологодская область	Вологда	0	Антушево	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9188
Вологодская область	Вологда	0	Артюшино	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9192
Вологодская область	Вологда	0	Белозерск	\N	Белозерского	ц	146515	ТГ	09-20 Сб 09-17	Вс	ЛИ-6711-17	11.07.2017	\N	15	439
Вологодская область	Вологда	0	Белый Ручей	\N	Белозерского	\N	146515	\N	09-13	Вс, Пн	\N	\N	\N	15	9204
Вологодская область	Вологда	0	Бечевинка	\N	Белозерского	\N	146515	\N	08-15	Вс, Пн, Пт	\N	\N	\N	15	9211
Вологодская область	Вологда	0	Большие Новишки	\N	Белозерского	\N	146515	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9219
Вологодская область	Вологда	0	Визьма	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Георгиевское	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9267
Вологодская область	Вологда	0	Глушково	\N	Белозерского	\N	146515	\N	08.30-17.30	Вс, Пн	\N	\N	\N	15	9268
Вологодская область	Вологда	0	Енино	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9300
Вологодская область	Вологда	0	Замошье	\N	Белозерского	\N	146515	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9311
Вологодская область	Вологда	0	Зубово	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	3090
Вологодская область	Вологда	0	Ивановское	\N	Белозерского	\N	146515	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9320
Вологодская область	Вологда	0	Карл Либкхнет	\N	Белозерского	\N	146515	\N	09-14.50	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Карпово	\N	Белозерского	\N	146515	\N	09-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9338
Вологодская область	Вологда	0	Климшин Бор	\N	Белозерского	\N	146515	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9345
Вологодская область	Вологда	0	Кукшево	\N	Белозерского	\N	146515	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9382
Вологодская область	Вологда	0	Куность	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9387
Вологодская область	Вологда	0	Маэкса	\N	Белозерского	\N	146515	\N	09-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9416
Вологодская область	Вологда	0	Мегринский	\N	Белозерского	\N	146515	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9419
Вологодская область	Вологда	0	Нижняя Мондома	\N	Белозерского	\N	146515	\N	09-17	Вс, Пн	\N	\N	\N	15	9461
Вологодская область	Вологда	0	Орлово	\N	Белозерского	\N	146515	\N	11-16.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9495
Вологодская область	Вологда	0	Панинская	\N	Белозерского	\N	146515	\N	08-17	Вс, Пн	\N	\N	\N	15	9503
Вологодская область	Вологда	0	Федоровская	\N	Белозерского	\N	146515	\N	09-18	Вс, Пн	\N	\N	\N	15	9638
Вологодская область	Вологда	0	Юрино	\N	Белозерского	\N	146515	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9682
Вологодская область	Вологда	0	Бонга	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9221
Вологодская область	Вологда	0	Ивановская	\N	Вашкинского	\N	146599	\N	09-18	Вс, Пн	\N	\N	\N	15	9319
Вологодская область	Вологда	0	Липин Бор	\N	Вашкинского	ц	146599	ТГ	09-17 Сб 09-15	Вс	ЛИ-6721-17	11.07.2017	\N	15	451
Вологодская область	Вологда	0	Новокемский	\N	Вашкинского	\N	146599	\N	09-18	Вс, Пн	\N	\N	\N	15	9477
Вологодская область	Вологда	0	Октябрьский	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9487
Вологодская область	Вологда	0	Остров	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9498
Вологодская область	Вологда	0	Парфеново	\N	Вашкинского	\N	146599	\N	09-15	Пт, Вт, Чт, Сб, Вс	\N	\N	\N	15	9505
Вологодская область	Вологда	0	Первомайский	\N	Вашкинского	\N	146599	\N	09-18	Вс, Пн	\N	\N	\N	15	9509
Вологодская область	Вологда	0	Пиксимово	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9517
Вологодская область	Вологда	0	Пиньшино	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9518
Вологодская область	Вологда	0	Покровское	\N	Вашкинского	\N	146599	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9532
Вологодская область	Вологда	0	Троицкое	\N	Вашкинского	\N	146599	\N	09-18	Вс, Пн	\N	\N	\N	15	9621
Вологодская область	Вологда	0	Ухтома	\N	Вашкинского	\N	146599	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9636
Вологодская область	Вологда	0	Чертеж	\N	Вашкинского	\N	146599	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9656
Вологодская область	Вологда	0	Аристово	\N	Великоустюгского	\N	146530	\N	09-18	Вс, Чт	\N	\N	\N	15	9191
Вологодская область	Вологда	0	Благовещенье	\N	Великоустюгского	\N	146530	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Бобровниково	\N	Великоустюгского	\N	146530	\N	08-15	Чт, Сб, Вс	\N	\N	\N	15	9213
Вологодская область	Вологда	0	Васильевское	\N	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9234
Вологодская область	Вологда	0	Великий Устюг	\N	Великоустюгского	ц	146530	ТГ	10-18 Сб 09-14	Вс	ЛИ-6712-17	11.07.2017	\N	15	441
Вологодская область	Вологда	0	Верхнее Анисимово	\N	Великоустюгского	\N	146530	\N	10-14	Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Горбачево	\N	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9271
Вологодская область	Вологда	0	Ильинское	\N	Великоустюгского	\N	146530	\N	09-18	Чт, Вс	\N	\N	\N	15	9325
Вологодская область	Вологда	0	Карасово	\N	Великоустюгского	\N	146530	\N	09-16	Чт, Сб, Вс	\N	\N	\N	15	9335
Вологодская область	Вологда	0	Красавино	\N	Великоустюгского	\N	146530	\N	08-20 Сб 09-18	Вс	\N	\N	\N	15	323
Вологодская область	Вологда	0	Красавино Деревня	Бывш. Луженьга	Великоустюгского	\N	146530	\N	08-13 Сб 08-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	1608
Вологодская область	Вологда	0	Кузино	\N	Великоустюгского	\N	146530	\N	09-18	Чт, Вс	\N	\N	\N	15	9380
Вологодская область	Вологда	0	Лодейка	\N	Великоустюгского	\N	146530	\N	09-16 Пн, Пт 09-12	Ср, Вс	\N	\N	\N	15	9398
Вологодская область	Вологда	0	Ломоватка	\N	Великоустюгского	\N	146530	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Морозовица	\N	Великоустюгского	\N	146530	\N	09-18	Чт, Вс	\N	\N	\N	15	9439
Вологодская область	Вологда	0	Мякиницыно	\N	Великоустюгского	\N	146530	\N	09-13	Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Новатор	\N	Великоустюгского	\N	146530	\N	09-18	Вс, Пн	\N	\N	\N	15	5755
Вологодская область	Вологда	0	Новоселово	\N	Великоустюгского	\N	146530	\N	09-13	Чт, Сб, Вс	\N	\N	\N	15	9478
Вологодская область	Вологда	0	Палема	\N	Великоустюгского	\N	146530	\N	09-13	Чт, Сб, Вс	\N	\N	\N	15	9501
Вологодская область	Вологда	0	Пеганово	\N	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9506
Вологодская область	Вологда	0	Первомайское	\N	Великоустюгского	\N	146530	\N	09-13	Чт, Сб, Вс	\N	\N	\N	15	9510
Вологодская область	Вологда	0	Пожарово	Бывш. Кочурино	Великоустюгского	\N	146530	\N	09-14	Чт, Сб, Вс	\N	\N	\N	15	9529
Вологодская область	Вологда	0	Полдарса	\N	Великоустюгского	\N	146530	\N	09-18	Чт, Вс	\N	\N	\N	15	9490
Вологодская область	Вологда	0	Полутово	\N	Великоустюгского	\N	146530	\N	09-13	Чт, Сб, Вс	\N	\N	\N	15	9538
Вологодская область	Вологда	0	Северный	\N	Великоустюгского	\N	146530	\N	10-14.30	Чт, Сб, Вс	\N	\N	\N	15	9570
Вологодская область	Вологда	0	Стрига	\N	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9605
Вологодская область	Вологда	0	Сусоловка	\N	Великоустюгского	\N	146530	\N	09-18	Чт, Вс	\N	\N	\N	15	9609
Вологодская область	Вологда	0	Теплогорье	\N	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9613
Вологодская область	Вологда	0	Томашево	\N	Великоустюгского	\N	146530	\N	10-14	Чт, Сб, Вс	\N	\N	\N	15	9618
Вологодская область	Вологда	0	Усть-Алексеево	\N	Великоустюгского	\N	146530	\N	08-17	Вт, Вс	\N	\N	\N	15	9631
Вологодская область	Вологда	0	Чернево	Бывш. Орлово	Великоустюгского	\N	146530	\N	08-17	Чт, Вс	\N	\N	\N	15	9654
Вологодская область	Вологда	0	Щекино	\N	Великоустюгского	\N	146530	\N	08-12	Чт, Сб, Вс	\N	\N	\N	15	9678
Вологодская область	Вологда	0	Артемьевская	\N	Верховажского	\N	146580	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9136
Вологодская область	Вологда	0	Великодворская	\N	Верховажского	\N	146580	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9240
Вологодская область	Вологда	0	Верховажье	\N	Верховажского	ц	146580	ТГ	09-17	Вс	ЛИ-6713-17	11.07.2017	\N	15	442
Вологодская область	Вологда	0	Ворониха	Бывш. Осташево	Верховажского	\N	146580	\N	12-17 Пт 11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9256
Вологодская область	Вологда	0	Елисеевская	\N	Верховажского	\N	146580	\N	09-18	Вс, Вт	\N	\N	\N	15	9298
Вологодская область	Вологда	0	Каменка	\N	Верховажского	\N	146580	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9333
Вологодская область	Вологда	0	Климушино	\N	Верховажского	\N	146580	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9344
Вологодская область	Вологда	0	Куколовская	Бывш. Терменьга	Верховажского	\N	146580	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9381
Вологодская область	Вологда	0	Леушинская	\N	Верховажского	\N	146580	\N	09-18	Вт, Вс	\N	\N	\N	15	9395
Вологодская область	Вологда	0	Макарцево	\N	Верховажского	\N	146580	\N	10-15 Пт 10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9405
Вологодская область	Вологда	0	Морозово	\N	Верховажского	\N	146580	\N	09-18	Вс, Пн	\N	\N	\N	15	9440
Вологодская область	Вологда	0	Ногинская	\N	Верховажского	\N	146580	\N	08-17	Вс, Пн	\N	\N	\N	15	9481
Вологодская область	Вологда	0	Пежма	\N	Верховажского	\N	146580	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9507
Волгоградская область	Волгоград	+1	Успенка	\N	Нехаевского	\N	117536	\N	08-17	Вс, Пн	\N	\N	\N	14	9130
Волгоградская область	Волгоград	+1	Хорошенский	\N	Нехаевского	\N	117536	\N	09-13	Вс, Пн, Ср, Пт	ЛИ-8394-17	16.08.2017	\N	14	9146
Волгоградская область	Волгоград	+1	Бережновка	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8618
Волгоградская область	Волгоград	+1	Комсомолец	\N	Николаевского	\N	117571	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2632-18	24.12.2018	\N	14	8797
Волгоградская область	Волгоград	+1	Красный Мелиоратор	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8823
Волгоградская область	Волгоград	+1	Левчуновка	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8852
Волгоградская область	Волгоград	+1	Ленинское	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8855
Волгоградская область	Волгоград	+1	Николаевск	\N	Николаевского	ц	117571	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2631-18	24.12.2018	\N	14	417
Волгоградская область	Волгоград	+1	Новый Быт	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8938
Волгоградская область	Волгоград	+1	Очкуровка	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8959
Волгоградская область	Волгоград	+1	Пионер	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8976
Волгоградская область	Волгоград	+1	Политотдельское	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	8990
Волгоградская область	Волгоград	+1	Путь Ильича	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	9011
Волгоградская область	Волгоград	+1	Раздольное	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	9016
Волгоградская область	Волгоград	+1	Солодушино	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Степновка	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	9088
Волгоградская область	Волгоград	+1	Торгун	\N	Николаевского	\N	117571	\N	08-17	Вс, Пн	\N	\N	\N	14	9115
Волгоградская область	Волгоград	+1	Cовхоз Амо	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	ЛИ-2684-18	24.12.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Березовка 1	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Бочаровский	\N	Новоаннинского	\N	117513	\N	09-16	Вс, Пн	\N	\N	\N	14	8637
Волгоградская область	Волгоград	+1	Галушкинский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	8682
Волгоградская область	Волгоград	+1	Деминский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	8707
Волгоградская область	Волгоград	+1	Дурновский	\N	Новоаннинского	\N	117513	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8395-17	16.08.2017	\N	14	8722
Волгоградская область	Волгоград	+1	Краснокоротковский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	8811
Волгоградская область	Волгоград	+1	Жутово 2	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Мартыновский	\N	Новоаннинского	\N	117513	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8396-17	16.08.2017	\N	14	8883
Волгоградская область	Волгоград	+1	Новоаннинский	\N	Новоаннинского	ц	117513	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2633-18	10.01.2019	\N	14	418
Волгоградская область	Волгоград	+1	Новокиевский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	8932
Волгоградская область	Волгоград	+1	Новосельский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-12236-17	01.03.2018	\N	14	8934
Волгоградская область	Волгоград	+1	Панфилово	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	2706
Волгоградская область	Волгоград	+1	Полевое	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	8989
Волгоградская область	Волгоград	+1	Саломатин	\N	Новоаннинского	\N	117513	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8398-17	16.08.2017	\N	14	9042
Волгоградская область	Волгоград	+1	Староаннинская	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	9084
Волгоградская область	Волгоград	+1	Тростянский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	9124
Волгоградская область	Волгоград	+1	Филоновская	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	9138
Волгоградская область	Волгоград	+1	Черкесовский	\N	Новоаннинского	\N	117513	\N	08-17	Вс, Пн	\N	\N	\N	14	9152
Волгоградская область	Волгоград	+1	Алексиковский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8594
Волгоградская область	Волгоград	+1	Верхнекардаильский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	5943
Волгоградская область	Волгоград	+1	Грачи	\N	Новониколаевского	\N	117534	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-8399-17	16.08.2017	\N	14	8694
Волгоградская область	Волгоград	+1	Двойновский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8704
Волгоградская область	Волгоград	+1	Дуплятский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8721
Волгоградская область	Волгоград	+1	Каменка	\N	Новониколаевского	\N	117534	\N	09-14.30	Вс, Ср, Пт	\N	\N	\N	14	8776
Волгоградская область	Волгоград	+1	Киквидзе	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8400-17	16.08.2017	\N	14	8786
Волгоградская область	Волгоград	+1	Комсомольский	\N	Новониколаевского	\N	117534	\N	08-17	Вс, Пн	\N	\N	\N	14	8799
Волгоградская область	Волгоград	+1	Красноармейский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8808
Волгоградская область	Волгоград	+1	Куликовский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8841
Волгоградская область	Волгоград	+1	Купава	\N	Новониколаевского	\N	117534	\N	09-15.30	Вс, Пн, Ср, Пт	ЛИ-12240-17	05.03.2018	\N	14	8844
Волгоградская область	Волгоград	+1	Мирный	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8892
Волгоградская область	Волгоград	+1	Николаевский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	8906
Волгоградская область	Волгоград	+1	Новокардаильский	\N	Новониколаевского	\N	117534	\N	09-16.15	Пн, Ср, Пт, Вс	ЛИ-476-18	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Новониколаевский	\N	Новониколаевского	ц	117534	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2634-18	24.12.2018	\N	14	419
Волгоградская область	Волгоград	+1	Орловский	\N	Новониколаевского	\N	117534	\N	09-16.15	Вс, Пн, Ср, Пт	ЛИ-8403-17	16.08.2017	\N	14	8951
Волгоградская область	Волгоград	+1	Серп И Молот	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	9063
Волгоградская область	Волгоград	+1	Фоминский	\N	Новониколаевского	\N	117534	\N	09-14.30	Вс, Пн, Ср, Пт	ЛИ-8404-17	16.08.2017	\N	14	9139
Волгоградская область	Волгоград	+1	Хоперский	\N	Новониколаевского	\N	117534	\N	09-17	Вс, Пн	\N	\N	\N	14	9145
Волгоградская область	Волгоград	+1	Абганерово	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8584
Волгоградская область	Волгоград	+1	Аксай	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8588
Волгоградская область	Волгоград	+1	Антонов	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8602
Волгоградская область	Волгоград	+1	Васильевка	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8649
Волгоградская область	Волгоград	+1	Верхнерубежный	\N	Октябрьского	\N	117553	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-12243-17	01.03.2018	\N	14	8653
Волгоградская область	Волгоград	+1	Водянский	\N	Октябрьского	\N	117553	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-8406-17	16.08.2017	\N	14	\N
Волгоградская область	Волгоград	+1	Громославка	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8698
Волгоградская область	Волгоград	+1	Жутово 1	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-8407-17	16.08.2017	\N	14	\N
Волгоградская область	Волгоград	+1	Заливский	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8737
Волгоградская область	Волгоград	+1	Ивановка	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8754
Волгоградская область	Волгоград	+1	Ильмень-Суворовский	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8762
Волгоградская область	Волгоград	+1	Ковалевка	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Нижнекумский	\N	Октябрьского	\N	117553	\N	09-16	Вс, Пн, Ср, Пт	ЛИ-12246-17	01.03.2018	\N	14	33271
Волгоградская область	Волгоград	+1	Ново-Аксай	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	8927
Волгоградская область	Волгоград	+1	Октябрьский	\N	Октябрьского	ц	117553	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2635-18	24.12.2018	\N	14	420
Волгоградская область	Волгоград	+1	Перегрузное	\N	Октябрьского	\N	117553	\N	08-12 13-17	Вс, Пн	\N	\N	\N	14	8964
Волгоградская область	Волгоград	+1	Самохино	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн, Ср, Пт	ЛИ-12247-17	05.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Советский	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	9071
Волгоградская область	Волгоград	+1	Черноморовский	\N	Октябрьского	\N	117553	\N	10-16.30	Вс, Пн, Ср, Пт	ЛИ-12248-17	01.03.2018	\N	14	33270
Волгоградская область	Волгоград	+1	Шебалино	\N	Октябрьского	\N	117553	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-475-18	01.03.2018	\N	14	9159
Волгоградская область	Волгоград	+1	Шелестово	\N	Октябрьского	\N	117553	\N	08-17	Вс, Пн	\N	\N	\N	14	9160
Волгоградская область	Волгоград	+1	Гурово	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	8700
Волгоградская область	Волгоград	+1	Гусевка	\N	Ольховского	\N	117562	\N	08-17	Сб, Вс	ЛИ-2636-18	24.12.2018	\N	14	8701
Волгоградская область	Волгоград	+1	Захаровка	\N	Ольховского	\N	117562	\N	08-13.20	Вс, Вт, Чт, Сб	ЛИ-8411-17	16.08.2017	\N	14	8746
Волгоградская область	Волгоград	+1	Зензеватка	\N	Ольховского	\N	117562	\N	08-17	Сб, Вс	ЛИ-2637-18	24.12.2018	\N	14	8750
Волгоградская область	Волгоград	+1	Каменный Брод	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	8775
Волгоградская область	Волгоград	+1	Киреево	\N	Ольховского	\N	117562	\N	08-17	Сб, Вс	ЛИ-2638-18	24.12.2018	\N	14	8787
Волгоградская область	Волгоград	+1	Липовка	\N	Ольховского	\N	117562	\N	08-17	Сб, Вс	ЛИ-2639-18	24.12.2018	\N	14	8861
Волгоградская область	Волгоград	+1	Михайловка	\N	Ольховского	\N	117562	\N	08-13.20	Вс, Вт, Чт, Сб	ЛИ-8412-17	16.08.2017	\N	14	8897
Волгоградская область	Волгоград	+1	Нежинский	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	8913
Волгоградская область	Волгоград	+1	Октябрьский	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	8944
Волгоградская область	Волгоград	+1	Ольховка	\N	Ольховского	ц	117562	ТГ	08.00-17.00	Сб, Вс	ЛИ-3517-17	01.12.2017	\N	14	421
Волгоградская область	Волгоград	+1	Романовка	\N	Ольховского	\N	117562	\N	08-17	Вс, Вт	\N	\N	\N	14	9030
Волгоградская область	Волгоград	+1	Рыбинка	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	9035
Волгоградская область	Волгоград	+1	Солодча	\N	Ольховского	\N	117562	\N	08-17	Сб, Вс	ЛИ-2640-18	24.12.2018	\N	14	9074
Волгоградская область	Волгоград	+1	Ягодное	\N	Ольховского	\N	117562	\N	08-17	Вс, Чт	\N	\N	\N	14	9166
Волгоградская область	Волгоград	+1	Вишневка	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	8672
Волгоградская область	Волгоград	+1	Золотари	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	8752
Волгоградская область	Волгоград	+1	Кайсацкое	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	8768
Волгоградская область	Волгоград	+1	Комсомольский	\N	Палласовского	\N	117551	\N	08-17	Вс, Чт	\N	\N	\N	14	8800
Волгоградская область	Волгоград	+1	Красный Октябрь	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	8824
Волгоградская область	Волгоград	+1	Лиманный	\N	Палласовского	\N	117551	\N	08-16.20	Пн, Ср, Пт, Вс	ЛИ-477-18	01.03.2018	\N	14	8858
Волгоградская область	Волгоград	+1	Новостройка	\N	Палласовского	\N	117551	\N	08-20	Вс	\N	\N	\N	14	8935
Волгоградская область	Волгоград	+1	Палласовка	\N	Палласовского	ц	117551	ТГ	08.00-20.00	Вс	ЛИ-3513-17	01.12.2017	\N	14	422
Волгоградская область	Волгоград	+1	Прудентов	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	ЛИ-478-18	01.03.2018	\N	14	33261
Волгоградская область	Волгоград	+1	Путь Ильича	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	9012
Волгоградская область	Волгоград	+1	Ромашки	\N	Палласовского	\N	117551	\N	08-17	Вс, Пн	\N	\N	\N	14	9032
Волгоградская область	Волгоград	+1	Савинка	\N	Палласовского	\N	117551	\N	09-20	Вс	\N	\N	\N	14	9038
Волгоградская область	Волгоград	+1	Эльтон	\N	Палласовского	\N	117551	\N	08-20	Вс	\N	\N	\N	14	9165
Волгоградская область	Волгоград	+1	Большое Судачье	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8632
Волгоградская область	Волгоград	+1	Громки	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8697
Волгоградская область	Волгоград	+1	Ильмень	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8761
Волгоградская область	Волгоград	+1	Козловка	\N	Руднянского	\N	117516	\N	09-17	Вс, Пн	\N	\N	\N	14	8792
Волгоградская область	Волгоград	+1	Лемешкино	\N	Руднянского	\N	117516	\N	09-17	Вс, Пн	\N	\N	\N	14	8853
Волгоградская область	Волгоград	+1	Лопуховка	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8868
Волгоградская область	Волгоград	+1	Матышево	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8884
Волгоградская область	Волгоград	+1	Осички	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	8953
Волгоградская область	Волгоград	+1	Подкуйково	\N	Руднянского	\N	117516	\N	08-16	Вс, Пн, Ср, Пт	ЛИ-8413-17	16.08.2017	\N	14	8983
Волгоградская область	Волгоград	+1	Рудня	\N	Руднянского	ц	117516	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2641-18	24.12.2018	\N	14	424
Волгоградская область	Волгоград	+1	Сосновка	\N	Руднянского	\N	117516	\N	08-17	Вс, Пн	\N	\N	\N	14	9079
Волгоградская область	Волгоград	+1	Ушинка	\N	Руднянского	\N	117516	\N	09-15	Вс, Пн, Ср, Пт	ЛИ-8414-17	16.08.2017	\N	14	9134
Волгоградская область	Волгоград	+1	Абганерово-Вокзал	\N	Светлоярского	\N	117517	\N	Вт, Чт 09-17 Сб 09-16	Пн, Ср, Пт, Вс	ЛИ-2642-18	24.12.2018	\N	14	8585
Волгоградская область	Волгоград	+1	Большие Чапурники	\N	Светлоярского	\N	117517	\N	08-20 Сб 09-18	Вс	\N	\N	\N	14	8631
Волгоградская область	Волгоград	+1	Дубовый Овраг	\N	Светлоярского	\N	117517	\N	09-18	Вс, Пн	\N	\N	\N	14	8718
Волгоградская область	Волгоград	+1	Ивановка	\N	Светлоярского	\N	117517	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	14	8755
Волгоградская область	Волгоград	+1	Имени Кирова	\N	Светлоярского	\N	117517	\N	08-20 Сб 09-18	Вс	\N	\N	\N	14	8764
Волгоградская область	Волгоград	+1	Краснопартизанский	\N	Светлоярского	\N	117517	\N	10-16	Пн, Ср, Пт, Вс	ЛИ-12254-17	05.03.2018	\N	14	8812
Волгоградская область	Волгоград	+1	Краснофлотский	\N	Светлоярского	\N	117517	\N	08-16	Вс, Пн, Ср, Пт	ЛИ-8416-17	16.08.2017	\N	14	8817
Волгоградская область	Волгоград	+1	Луговой	\N	Светлоярского	\N	117517	\N	09-17	Вс, Пн, Ср, Пт	ЛИ-8417-17	16.08.2017	\N	14	8870
Волгоградская область	Волгоград	+1	Малые Чапурники	\N	Светлоярского	\N	117517	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-12257-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Нариман	\N	Светлоярского	\N	117517	\N	09-18	Вс, Пн	\N	\N	\N	14	8910
Волгоградская область	Волгоград	+1	Приволжский	\N	Светлоярского	\N	117517	\N	09-18	Пн, Ср, Пт, Вс	ЛИ-2643-18	24.12.2018	\N	14	8998
Волгоградская область	Волгоград	+1	Привольный	\N	Светлоярского	\N	117517	\N	09-18	Вс, Пн	\N	\N	\N	14	8999
Волгоградская область	Волгоград	+1	Прудовый	\N	Светлоярского	\N	117517	\N	08-15	Пн, Ср, Пт, Вс	ЛИ-12258-17	01.03.2018	\N	14	9007
Волгоградская область	Волгоград	+1	Райгород	\N	Светлоярского	\N	117517	\N	08-17	Вс, Пн	\N	\N	\N	14	9018
Волгоградская область	Волгоград	+1	Светлый Яр	\N	Светлоярского	ц	117517	ТГ	Пн, Вт, Ср, Чт 08-16 Пт 08-16	Сб, Вс	ЛИ-2645-18	24.12.2018	\N	14	425
Волгоградская область	Волгоград	+1	Северный	\N	Светлоярского	\N	117517	\N	08-15	Пн, Ср, Пт, Вс	ЛИ-12259-17	05.03.2018	\N	14	9052
Волгоградская область	Волгоград	+1	Солянка	\N	Светлоярского	\N	117517	\N	08-15	Вс, Пн, Ср, Пт	ЛИ-8421-17	16.08.2017	\N	14	9077
Волгоградская область	Волгоград	+1	Трудолюбие	\N	Светлоярского	\N	117517	\N	12-16	Вс, Пн, Ср, Пт	ЛИ-8422-17	16.08.2017	\N	14	9125
Волгоградская область	Волгоград	+1	Цаца	\N	Светлоярского	\N	117517	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-2644-18	24.12.2018	\N	14	9149
Волгоградская область	Волгоград	+1	Чапурники	\N	Светлоярского	\N	117517	\N	09-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Червленое	\N	Светлоярского	\N	117517	\N	08-17	Вс, Пн	ЛИ-13083-17	05.03.2018	\N	14	9150
Волгоградская область	Волгоград	+1	Базки	\N	Серафимовичского	\N	117543	\N	10-15	Вт, Чт, Сб, Вс	ЛИ-13085-17	01.03.2018	\N	14	8609
Волгоградская область	Волгоград	+1	Бобровский 1	\N	Серафимовичского	\N	117543	\N	10-13.30	Вт, Чт, Сб, Вс	ЛИ-13103-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Бобровский 2	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2646-18	24.12.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Большой	\N	Серафимовичского	\N	117543	\N	09-18	Вс, Чт	\N	\N	\N	14	8634
Волгоградская область	Волгоград	+1	Рахинка	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Буерак-Поповский	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2647-18	24.12.2018	\N	14	8640
Волгоградская область	Волгоград	+1	Горбатовский	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2648-18	24.12.2018	\N	14	8687
Волгоградская область	Волгоград	+1	Затонский	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13105-17	01.03.2018	\N	14	8743
Волгоградская область	Волгоград	+1	Зимняцкий	\N	Серафимовичского	\N	117543	\N	09-18	Вс, Чт	\N	\N	\N	14	8751
Волгоградская область	Волгоград	+1	Кепинский	\N	Серафимовичского	\N	117543	\N	08-11.30	Вт, Чт, Сб, Вс	ЛИ-13106-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Клетско-Почтовский	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-13089-17	05.03.2018	\N	14	8790
Волгоградская область	Волгоград	+1	Котовский	\N	Серафимовичского	\N	117543	\N	12-16	Вт, Чт, Сб, Вс	ЛИ-13107-17	01.03.2018	\N	14	8805
Волгоградская область	Волгоград	+1	Крутовский	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2649-18	24.12.2018	\N	14	33247
Волгоградская область	Волгоград	+1	Мостовский	\N	Серафимовичского	\N	117543	\N	08-11.30	Вт, Чт, Сб, Вс	ЛИ-13108-17	05.03.2018	\N	14	8903
Волгоградская область	Волгоград	+1	Новоалександровский	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13109-17	01.03.2018	\N	14	8930
Волгоградская область	Волгоград	+1	Отрожки	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2650-18	24.12.2018	\N	14	8957
Волгоградская область	Волгоград	+1	Песчаный	\N	Серафимовичского	\N	117543	\N	09-18	Чт, Вс	ЛИ-13092-17	01.03.2018	\N	14	8972
Волгоградская область	Волгоград	+1	Подольховский	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13110-17	01.03.2018	\N	14	8984
Волгоградская область	Волгоград	+1	Пронин	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2651-18	24.12.2018	\N	14	9004
Волгоградская область	Волгоград	+1	Рыбный	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13111-17	01.03.2018	\N	14	33262
Волгоградская область	Волгоград	+1	Серафимович	\N	Серафимовичского	ц	117543	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2655-18	24.12.2018	\N	14	426
Волгоградская область	Волгоград	+1	Средне-Царицынский	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2652-18	24.12.2018	\N	14	9080
Волгоградская область	Волгоград	+1	Старосенюткин	\N	Серафимовичского	\N	117543	\N	11-14.30	Вт, Чт, Сб, Вс	ЛИ-13112-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Теркин	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2653-18	24.12.2018	\N	14	9106
Волгоградская область	Волгоград	+1	Трясиновский	\N	Серафимовичского	\N	117543	\N	08-17	Вс, Чт	ЛИ-13096-17	05.03.2018	\N	14	9126
Волгоградская область	Волгоград	+1	Усть-Хоперская	\N	Серафимовичского	\N	117543	\N	08-17	Вт, Чт, Сб, Вс	ЛИ-2654-18	24.12.2018	\N	14	9133
Волгоградская область	Волгоград	+1	Фомихинский	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13113-17	01.03.2018	\N	14	9140
Волгоградская область	Волгоград	+1	Хованский	\N	Серафимовичского	\N	117543	\N	09-12.30	Вт, Чт, Сб, Вс	ЛИ-13114-17	01.03.2018	\N	14	9144
Волгоградская область	Волгоград	+1	Хохлачев	\N	Серафимовичского	\N	117543	\N	12-15.30	Вт, Чт, Сб, Вс	ЛИ-13115-17	01.03.2018	\N	14	9147
Волгоградская область	Волгоград	+1	Бурковский	\N	Среднеахтубинского	\N	117524	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Верхнепогромное	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	5942
Волгоградская область	Волгоград	+1	Госпитомник	\N	Среднеахтубинского	\N	117524	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	14	8692
Волгоградская область	Волгоград	+1	Закутский	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	8736
Волгоградская область	Волгоград	+1	Клетский	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	\N
Волгоградская область	Волгоград	+1	Краснослободск	\N	Среднеахтубинского	\N	117524	\N	09-18	Вс, Пн	\N	\N	\N	14	409
Волгоградская область	Волгоград	+1	Красный Октябрь	\N	Среднеахтубинского	\N	117524	\N	08-17	Пн, Ср, Пт, Вс	ЛИ-13120-17	05.03.2018	\N	14	8825
Волгоградская область	Волгоград	+1	Красный Сад	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	ЛИ-13119-17	01.03.2018	\N	14	8827
Волгоградская область	Волгоград	+1	Куйбышев	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	8840
Волгоградская область	Волгоград	+1	Лебяжья Поляна	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	8851
Волгоградская область	Волгоград	+1	Песчанка	\N	Среднеахтубинского	\N	117524	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13122-17	01.03.2018	\N	14	33259
Вологодская область	Вологда	0	Шапша	\N	Харовского	\N	146520	\N	08-17	Вт, Вс	\N	\N	\N	15	9663
Волгоградская область	Волгоград	+1	Средняя Ахтуба	\N	Среднеахтубинского	ц	117524	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2656-18	24.12.2018	\N	14	427
Волгоградская область	Волгоград	+1	Суходол	\N	Среднеахтубинского	\N	117524	\N	08-17	Вс, Пн	\N	\N	\N	14	9099
Волгоградская область	Волгоград	+1	Третий Решающий	\N	Среднеахтубинского	\N	117524	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13123-17	01.03.2018	\N	14	33268
Волгоградская область	Волгоград	+1	Щучий	\N	Среднеахтубинского	\N	117524	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13124-17	01.03.2018	\N	14	9164
Волгоградская область	Волгоград	+1	Белокаменка	\N	Старополтавского	\N	117515	\N	08-14	Вт, Чт, Сб, Вс	ЛИ-2657-18	24.12.2018	\N	14	8615
Волгоградская область	Волгоград	+1	Беляевка	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2658-18	24.12.2018	\N	14	8617
Волгоградская область	Волгоград	+1	Валуевка	\N	Старополтавского	\N	117515	\N	08-17	Вс, Чт	\N	\N	\N	14	8648
Волгоградская область	Волгоград	+1	Вербный	\N	Старополтавского	\N	117515	\N	08-12.30	Вт, Чт, Сб, Вс	ЛИ-13128-17	01.03.2018	\N	14	33239
Волгоградская область	Волгоград	+1	Верхний Еруслан	\N	Старополтавского	\N	117515	\N	08-14	Вт, Чт, Сб, Вс	ЛИ-13129-17	05.03.2018	\N	14	8661
Волгоградская область	Волгоград	+1	Верхняя Водянка	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2659-18	24.12.2018	\N	14	8663
Волгоградская область	Волгоград	+1	Гмелинка	\N	Старополтавского	\N	117515	\N	08-17	Чт, Вс	ЛИ-13131-17	05.03.2018	\N	14	8685
Волгоградская область	Волгоград	+1	Иловатка	\N	Старополтавского	\N	117515	\N	08-17	Вс, Чт	\N	\N	\N	14	8757
Волгоградская область	Волгоград	+1	Калинино	\N	Старополтавского	\N	117515	\N	08-14	Вт, Чт, Сб, Вс	ЛИ-13132-17	05.03.2018	\N	14	8770
Волгоградская область	Волгоград	+1	Кано	\N	Старополтавского	\N	117515	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-2660-18	24.12.2018	\N	14	8777
Волгоградская область	Волгоград	+1	Колышкино	\N	Старополтавского	\N	117515	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-2661-18	24.12.2018	\N	14	8795
Волгоградская область	Волгоград	+1	Красный Яр	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2662-18	24.12.2018	\N	14	8828
Волгоградская область	Волгоград	+1	Курнаевка	\N	Старополтавского	\N	117515	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-2663-18	24.12.2018	\N	14	8846
Волгоградская область	Волгоград	+1	Лятошинка	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2664-18	24.12.2018	\N	14	8873
Волгоградская область	Волгоград	+1	Новая Квасниковка	\N	Старополтавского	\N	117515	\N	08-16	Вт, Чт, Сб, Вс	ЛИ-2665-18	24.12.2018	\N	14	8923
Волгоградская область	Волгоград	+1	Новая Полтавка	\N	Старополтавского	\N	117515	\N	08-17	Вс, Чт	\N	\N	\N	14	8925
Волгоградская область	Волгоград	+1	Новый Тихонов	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2666-18	24.12.2018	\N	14	8937
Волгоградская область	Волгоград	+1	Салтово	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2667-18	24.12.2018	\N	14	9044
Волгоградская область	Волгоград	+1	Старая Полтавка	\N	Старополтавского	ц	117515	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2669-18	24.12.2018	\N	14	428
Волгоградская область	Волгоград	+1	Харьковка	\N	Старополтавского	\N	117515	\N	08-17	Вс, Чт	\N	\N	\N	14	9142
Волгоградская область	Волгоград	+1	Черебаево	\N	Старополтавского	\N	117515	\N	09-17	Вт, Чт, Сб, Вс	ЛИ-2668-18	24.12.2018	\N	14	9151
Волгоградская область	Волгоград	+1	Ближнеосиновский	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-13144-17	01.03.2018	\N	14	33236
Волгоградская область	Волгоград	+1	Ближнеподгорский	\N	Суровикинского	\N	117533	\N	09-16	Пн, Ср, Пт, Вс	ЛИ-13145-17	01.03.2018	\N	14	\N
Волгоградская область	Волгоград	+1	Бурацкий	\N	Суровикинского	\N	117533	\N	09-17	Пн, Ср, Пт, Вс	ЛИ-2670-18	24.12.2018	\N	14	33238
Воронежская область	Воронеж	0	Богучар	\N	Богучарского	ц	153552	ТГ	07-21	\N	\N	\N	\N	16	467
Воронежская область	Воронеж	0	Варваровка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10027
Воронежская область	Воронеж	0	Вишневый	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10052
Воронежская область	Воронеж	0	Галиевка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10073
Воронежская область	Воронеж	0	Грушовое	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10093
Воронежская область	Воронеж	0	Данцевка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10101
Воронежская область	Воронеж	0	Дубрава	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10121
Воронежская область	Воронеж	0	Дьяченково	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10124
Воронежская область	Воронеж	0	Журавка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10146
Воронежская область	Воронеж	0	Залиман	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10152
Воронежская область	Воронеж	0	Каразеево	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10179
Воронежская область	Воронеж	0	Красногоровка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10226
Воронежская область	Воронеж	0	Криница	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10244
Воронежская область	Воронеж	0	Купянка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10254
Воронежская область	Воронеж	0	Лебединка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10261
Воронежская область	Воронеж	0	Липчанка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10273
Воронежская область	Воронеж	0	Лофицкое	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10282
Воронежская область	Воронеж	0	Луговое	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10284
Воронежская область	Воронеж	0	Медово	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10311
Воронежская область	Воронеж	0	Монастырщина	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10323
Воронежская область	Воронеж	0	Новоникольск	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10384
Воронежская область	Воронеж	0	Плесновка	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10465
Воронежская область	Воронеж	0	Подколодновка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10473
Воронежская область	Воронеж	0	Полтавка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10478
Воронежская область	Воронеж	0	Поповка	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10483
Воронежская область	Воронеж	0	Радченское	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10502
Воронежская область	Воронеж	0	Старотолучеево	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10580
Воронежская область	Воронеж	0	Сухой Донец	\N	Богучарского	\N	153552	\N	Вт, Ср, Чт, Пт, Сб 09.00-17.00	Вс, Пн	ЛИ-519-16	14.12.2016	\N	16	10593
Воронежская область	Воронеж	0	Твердохлебовка	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10598
Воронежская область	Воронеж	0	Терешково	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10600
Воронежская область	Воронеж	0	Травкино	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10611
Воронежская область	Воронеж	0	Филоново	\N	Богучарского	\N	153552	\N	07-20	Вс, Пн	\N	\N	\N	16	10637
Воронежская область	Воронеж	0	Шуриновка	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10674
Воронежская область	Воронеж	0	Южный	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	10682
Воронежская область	Воронеж	0	Богана	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	9989
Воронежская область	Воронеж	0	Борисоглебск	\N	Борисоглебского	ц	153511	ТГ	07-21	\N	\N	\N	\N	16	468
Воронежская область	Воронеж	0	Водострой	\N	Борисоглебского	\N	153511	\N	08-20	\N	\N	\N	\N	16	10055
Воронежская область	Воронеж	0	Горелка	\N	Борисоглебского	\N	153511	\N	08-14	Вс, Пн	\N	\N	\N	16	10084
Воронежская область	Воронеж	0	Губари	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10095
Воронежская область	Воронеж	0	Макашевка	\N	Борисоглебского	\N	153511	\N	09-13	Сб, Вс	\N	\N	\N	16	10290
Воронежская область	Воронеж	0	Махровка	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10307
Воронежская область	Воронеж	0	Миролюбие	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10314
Воронежская область	Воронеж	0	Нововоскресеновка	\N	Борисоглебского	\N	153511	\N	08-14	Вс, Пн	\N	\N	\N	16	10374
Воронежская область	Воронеж	0	Петровское	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10457
Воронежская область	Воронеж	0	Танцыреи	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10596
Воронежская область	Воронеж	0	Третьяки	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10613
Воронежская область	Воронеж	0	Тюковка	\N	Борисоглебского	\N	153511	\N	08-14	Вс, Пн	\N	\N	\N	16	10624
Воронежская область	Воронеж	0	Ульяновка	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10628
Воронежская область	Воронеж	0	Чигорак	\N	Борисоглебского	\N	153511	\N	07-20	Вс, Пн	\N	\N	\N	16	10656
Воронежская область	Воронеж	0	Бутурлиновка	\N	Бутурлиновского	ц	153521	ТГ	07-21	\N	\N	\N	\N	16	469
Воронежская область	Воронеж	0	Васильевка	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10029
Воронежская область	Воронеж	0	Великоархангельское	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10033
Воронежская область	Воронеж	0	Гвазда	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10075
Воронежская область	Воронеж	0	Гвазда-1	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10076
Воронежская область	Воронеж	0	Дмитриевка	\N	Бутурлиновского	\N	153521	\N	08-14	Вс, Пн	\N	\N	\N	16	10109
Воронежская область	Воронеж	0	Елизаветино	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10134
Воронежская область	Воронеж	0	Зеленый	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10159
Воронежская область	Воронеж	0	Карайчевка	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10180
Воронежская область	Воронеж	0	Клеповка	\N	Бутурлиновского	\N	153521	ТГ	08-16	Сб, Вс	\N	\N	\N	16	4735
Воронежская область	Воронеж	0	Козловка	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10193
Воронежская область	Воронеж	0	Колодеевка	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10199
Воронежская область	Воронеж	0	Комсомольский	\N	Бутурлиновского	\N	153521	\N	08-14	Вс, Пн	\N	\N	\N	16	10208
Воронежская область	Воронеж	0	Кучеряевка	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10257
Воронежская область	Воронеж	0	Нижний Кисляй	\N	Бутурлиновского	\N	153521	ТГ	08-18 Сб 09-12	Вс	\N	\N	\N	16	4739
Воронежская область	Воронеж	0	Озерки	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10403
Воронежская область	Воронеж	0	Патокино	\N	Бутурлиновского	\N	153521	\N	08-14	Вс, Пн	\N	\N	\N	16	10433
Воронежская область	Воронеж	0	Пузево	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10497
Воронежская область	Воронеж	0	Сериково	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10546
Воронежская область	Воронеж	0	Ударник Совхоз	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10626
Воронежская область	Воронеж	0	Филиппенково	\N	Бутурлиновского	\N	153521	\N	07-20	Вс, Пн	\N	\N	\N	16	10636
Воронежская область	Воронеж	0	Чернавка	\N	Бутурлиновского	\N	153521	\N	08-14	Вс, Пн	\N	\N	\N	16	10650
Воронежская область	Воронеж	0	Чулок	\N	Бутурлиновского	\N	153521	\N	Вт, Ср, Чт, Пт, Сб 08.00-16.00	Вс, Пн	ЛИ-523-16	14.12.2016	\N	16	10658
Воронежская область	Воронеж	0	Верхний Мамон	в зоне обслуживания Павловского РУЭС	Верхнемамонского	ц	153543	ТГ	10-16	\N	\N	\N	\N	16	470
Воронежская область	Воронеж	0	Верхний Мамон-1	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	16352
Воронежская область	Воронеж	0	Верхний Мамон-2	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	16353
Воронежская область	Воронеж	0	Гороховка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Дерезовка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	16361
Воронежская область	Воронеж	0	Лозовое	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10276
Воронежская область	Воронеж	0	Мамоновка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10296
Воронежская область	Воронеж	0	Нижний Мамон	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10346
Воронежская область	Воронеж	0	Нижний Мамон-2	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10347
Воронежская область	Воронеж	0	Ольховатка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10410
Воронежская область	Воронеж	0	Осетровка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10419
Воронежская область	Воронеж	0	Приречное	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10492
Воронежская область	Воронеж	0	Русская Журавка	\N	Верхнемамонского	\N	153543	\N	07-20	Вс, Пн	\N	\N	\N	16	10524
Воронежская область	Воронеж	0	Александровка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	9951
Воронежская область	Воронеж	0	Богословка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	9991
Воронежская область	Воронеж	0	Большая Приваловка	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10001
Воронежская область	Воронеж	0	Васильевка Вторая	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10031
Воронежская область	Воронеж	0	Васильевка Первая	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10032
Воронежская область	Воронеж	0	Верхняя Байгора	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10043
Воронежская область	Воронеж	0	Верхняя Луговатка	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10045
Воронежская область	Воронеж	0	Верхняя Маза	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10046
Воронежская область	Воронеж	0	Верхняя Плавица	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10047
Воронежская область	Воронеж	0	Верхняя Хава	в зоне обслуживания Новоусманского РУЭС	Верхнехавского	ц	153581	ТГ	08-18	\N	\N	\N	\N	16	471
Воронежская область	Воронеж	0	Вишневка	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10051
Воронежская область	Воронеж	0	Малая Приваловка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10293
Воронежская область	Воронеж	0	Малый Самовец	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10295
Воронежская область	Воронеж	0	Марьевка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10300
Воронежская область	Воронеж	0	Нижняя Байгора	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10349
Воронежская область	Воронеж	0	Никоново	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10365
Воронежская область	Воронеж	0	Парижская Коммуна	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10431
Воронежская область	Воронеж	0	Плясоватка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10466
Воронежская область	Воронеж	0	Правая Хава	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10488
Воронежская область	Воронеж	0	Семеновка	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10538
Воронежская область	Воронеж	0	Сухие Гаи	\N	Верхнехавского	\N	153581	\N	08-14	Вс, Пн	\N	\N	\N	16	10592
Воронежская область	Воронеж	0	Углянец	\N	Верхнехавского	\N	153581	\N	08-20	Вс	\N	\N	\N	16	10625
Воронежская область	Воронеж	0	Шукавка	\N	Верхнехавского	\N	153581	\N	07-20	Вс, Пн	\N	\N	\N	16	10673
Воронежская область	Воронеж	0	Банное	\N	Воробьевского	\N	153556	\N	08-14	Вс, Пн	\N	\N	\N	16	9974
Воронежская область	Воронеж	0	Березовка	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	9980
Воронежская область	Воронеж	0	Верхнетолучеево	\N	Воробьевского	\N	153556	\N	08-14	Вс, Пн	\N	\N	\N	16	10038
Воронежская область	Воронеж	0	Верхний Бык	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10040
Воронежская область	Воронеж	0	Воробьевка	в зоне обслуживания Бутурлинского РУЭС	Воробьевского	ц	153556	ТГ	08-16	\N	\N	\N	\N	16	472
Воронежская область	Воронеж	0	Воробьевский Совхоз	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10064
Воронежская область	Воронеж	0	Елизаветовка	\N	Воробьевского	\N	153556	\N	08-14	Вс, Пн	\N	\N	\N	16	10136
Воронежская область	Воронеж	0	Затон	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10158
Воронежская область	Воронеж	0	Квашино	\N	Воробьевского	\N	153556	\N	08-14	Вс, Пн	\N	\N	\N	16	10186
Воронежская область	Воронеж	0	Краснополье	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10230
Воронежская область	Воронеж	0	Краснопольский Совхоз	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10231
Воронежская область	Воронеж	0	Лещаное	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10268
Воронежская область	Воронеж	0	Мужичье	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10330
Воронежская область	Воронеж	0	Нижний Бык	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10343
Воронежская область	Воронеж	0	Никольское	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10360
Воронежская область	Воронеж	0	Никольское 1	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10362
Воронежская область	Воронеж	0	Новотолучеево	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10391
Воронежская область	Воронеж	0	Первомайский	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10435
Воронежская область	Воронеж	0	Рудня	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10519
Воронежская область	Воронеж	0	Солонцы	\N	Воробьевского	\N	153556	\N	07-20	Вс, Пн	\N	\N	\N	16	10559
Воронежская область	Воронеж	0	1 Мая	\N	Воронеж	\N	153086	ТГ	08-20	\N	\N	\N	\N	16	5693
Воронежская область	Воронеж	0	Боровое	\N	Воронеж	\N	153022	\N	08-20	Вс	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Буденный	\N	Воронеж	\N	153074	\N	08-20	\N	\N	\N	\N	16	5383
Воронежская область	Воронеж	0	Воронеж	\N	\N	\N	153ххх	ТГ	08-20	\N	\N	\N	\N	16	502
Воронежская область	Воронеж	0	Краснолесный	\N	Воронеж	\N	153022	\N	08-20	Вс	\N	\N	\N	16	479
Воронежская область	Воронеж	0	Малышево	\N	Воронеж	\N	153052	ТГ	08-20	\N	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Масловка	\N	Воронеж	\N	153074	ТГ	08-20	\N	\N	\N	\N	16	4737
Воронежская область	Воронеж	0	Никольское	\N	Воронеж	\N	153074	ТГ	08-20	\N	\N	\N	\N	16	1343
Воронежская область	Воронеж	0	Подгорное	\N	Воронеж	\N	153077	ТГ	08-20	\N	\N	\N	\N	16	1295
Воронежская область	Воронеж	0	Подклетное	\N	Воронеж	\N	153027	ТГ	08-20	\N	\N	\N	\N	16	10472
Воронежская область	Воронеж	0	Придонской	\N	Воронеж	\N	153040	ТГ	08-20	\N	\N	\N	\N	16	492
Воронежская область	Воронеж	0	Репное	\N	Воронеж	\N	153063	ТГ	08-20	\N	\N	\N	\N	16	1600
Воронежская область	Воронеж	0	Семилукские Выселки	\N	Воронеж	\N	153074	ТГ	08-20	\N	\N	\N	\N	16	1221
Воронежская область	Воронеж	0	Сомово	\N	Воронеж	\N	153022	\N	08-20	Вс	\N	\N	\N	16	497
Воронежская область	Воронеж	0	Таврово	\N	Воронеж	\N	153074	ТГ	08-20	\N	\N	\N	\N	16	1201
Воронежская область	Воронеж	0	Тенистый	\N	Воронеж	\N	153086	ТГ	08-20	\N	\N	\N	\N	16	1182
Воронежская область	Воронеж	0	Шилово	\N	Воронеж	\N	153052	ТГ	08-20	\N	\N	\N	\N	16	4742
Воронежская область	Воронеж	0	Алексеевка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	9957
Воронежская область	Воронеж	0	Большие Алабухи	\N	Грибановского	\N	153514	\N	Вт, Ср, Чт, Пт, Сб 08.00-17.00	Вс, Пн	ЛИ-526-16	14.12.2016	\N	16	5385
Воронежская область	Воронеж	0	Васильевка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10030
Воронежская область	Воронеж	0	Верхний Карачан	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10024
Воронежская область	Воронеж	0	Власовка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10054
Воронежская область	Воронеж	0	Грибановский	в зоне обслуживания Борисоглебского РУЭС	Грибановского	ц	153514	ТГ	08-17	\N	ЛИ-8226-17	15.08.2017	\N	16	473
Воронежская область	Воронеж	0	Дмитриевка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10110
Воронежская область	Воронеж	0	Дубовка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	16366
Воронежская область	Воронеж	0	Калиново	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10173
Воронежская область	Воронеж	0	Кирсановка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	16368
Воронежская область	Воронеж	0	Краснореченка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10232
Воронежская область	Воронеж	0	Красовка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10240
Воронежская область	Воронеж	0	Кутки	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10256
Воронежская область	Воронеж	0	Лавровка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10260
Воронежская область	Воронеж	0	Листопадовка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	6205
Воронежская область	Воронеж	0	Малая Грибановка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	6185
Воронежская область	Воронеж	0	Малые Алабухи Вторые	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10294
Воронежская область	Воронеж	0	Малые Алабухи Первые	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	6184
Воронежская область	Воронеж	0	Нижний Карачан	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	6234
Воронежская область	Воронеж	0	Новогольелань	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10375
Воронежская область	Воронеж	0	Новогольское	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10376
Воронежская область	Воронеж	0	Новомакарово	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	6334
Воронежская область	Воронеж	0	Новоспасовка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10390
Воронежская область	Воронеж	0	Павловка	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10429
Воронежская область	Воронеж	0	Поляна	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	10479
Воронежская область	Воронеж	0	Посевкино	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10485
Воронежская область	Воронеж	0	Средний Карачан	\N	Грибановского	\N	153514	\N	07-20	Вс, Пн	\N	\N	\N	16	16372
Воронежская область	Воронеж	0	Старогольское	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10576
Воронежская область	Воронеж	0	Теллермановский	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	16374
Воронежская область	Воронеж	0	Тихвинка	\N	Грибановского	\N	153514	\N	08-14	Вс, Пн	\N	\N	\N	16	10608
Воронежская область	Воронеж	0	Заброды	\N	Калачеевского	\N	153531	\N	08-20	Вс	\N	\N	\N	16	10148
Воронежская область	Воронеж	0	Заброды-1	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10149
Воронежская область	Воронеж	0	Залесный	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10151
Воронежская область	Воронеж	0	Ильинка	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10164
Воронежская область	Воронеж	0	Калач	\N	Калачеевского	ц	153531	ТГ	07-21	\N	ЛИ-9793-17	13.09.2017	\N	16	475
Воронежская область	Воронеж	0	Калачеевский Совхоз	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10172
Воронежская область	Воронеж	0	Колос	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10205
Воронежская область	Воронеж	0	Коренное	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10216
Воронежская область	Воронеж	0	Лесково	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10267
Воронежская область	Воронеж	0	Манино	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10297
Воронежская область	Воронеж	0	Медвежье	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10309
Воронежская область	Воронеж	0	Морозовка	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10325
Воронежская область	Воронеж	0	Новая Криуша	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10368
Воронежская область	Воронеж	0	Новомеловатка	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10382
Воронежская область	Воронеж	0	Переволочное	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10438
Воронежская область	Воронеж	0	Пирогово	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10462
Воронежская область	Воронеж	0	Подгорное	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10468
Воронежская область	Воронеж	0	Попасное	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10481
Воронежская область	Воронеж	0	Пригородный	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10489
Воронежская область	Воронеж	0	Пришиб	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10493
Воронежская область	Воронеж	0	Россыпное	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10514
Воронежская область	Воронеж	0	Семеновка	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10539
Воронежская область	Воронеж	0	Серяково	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10547
Воронежская область	Воронеж	0	Скрипниково	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10553
Воронежская область	Воронеж	0	Советское	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10556
Воронежская область	Воронеж	0	Хвощеватое	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10641
Воронежская область	Воронеж	0	Хрещатое	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10645
Воронежская область	Воронеж	0	Черноземный	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10652
Воронежская область	Воронеж	0	Четвериково	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10655
Воронежская область	Воронеж	0	Ширяево	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10666
Воронежская область	Воронеж	0	Юнаково	\N	Калачеевского	\N	153531	\N	08-14	Вс, Пн	\N	\N	\N	16	10683
Воронежская область	Воронеж	0	Ясеновка	\N	Калачеевского	\N	153531	\N	07-20	Вс, Пн	\N	\N	\N	16	10689
Воронежская область	Воронеж	0	Верхние Марки	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10039
Воронежская область	Воронеж	0	Волчанское	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10062
Воронежская область	Воронеж	0	Дегтярное	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10104
Воронежская область	Воронеж	0	Евдаково	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10126
Воронежская область	Воронеж	0	Каменка	в зоне обслуживания Лискинского РУЭС	Каменского	ц	153527	ТГ	08-18	\N	\N	\N	\N	16	476
Воронежская область	Воронеж	0	Карпенково	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10184
Воронежская область	Воронеж	0	Коденцово	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Марки	\N	Каменского	\N	153527	\N	07-20	Вс,Пн	\N	\N	\N	16	10298
Воронежская область	Воронеж	0	Ольхов Лог	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10409
Воронежская область	Воронеж	0	Пилипы	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10461
Воронежская область	Воронеж	0	Рыбальчино	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10526
Воронежская область	Воронеж	0	Сончино	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10562
Воронежская область	Воронеж	0	Татарино	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10597
Воронежская область	Воронеж	0	Тимирязево	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10605
Воронежская область	Воронеж	0	Трехстенки	\N	Каменского	\N	153527	\N	07-20	Вс, Пн	\N	\N	\N	16	10614
Воронежская область	Воронеж	0	Тхоревка	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	10623
Воронежская область	Воронеж	0	Щербаково	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Ярки	\N	Каменского	\N	153527	\N	08-14	Вс, Пн	\N	\N	\N	16	16384
Воронежская область	Воронеж	0	Андрюшевка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	9964
Воронежская область	Воронеж	0	Бондарево	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	5384
Воронежская область	Воронеж	0	Бугаевка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10017
Воронежская область	Воронеж	0	Бугаевка-Вторая	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Валентиновка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10025
Воронежская область	Воронеж	0	Волоконовка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10060
Воронежская область	Воронеж	0	Гармашевка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10074
Воронежская область	Воронеж	0	Евдокиевка	\N	Кантемировского	\N	153516	\N	Вт, Чт, Пт, Сб 10.00-16.00	Пн, Ср, Вс	ЛИ-530-16	30.12.1899	\N	16	10127
Воронежская область	Воронеж	0	Журавка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10145
Воронежская область	Воронеж	0	Зайцевка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10150
Воронежская область	Воронеж	0	Кантемировка	\N	Кантемировского	ц	153516	ТГ	07-21	\N	\N	\N	\N	16	477
Воронежская область	Воронеж	0	Касьяновка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10185
Воронежская область	Воронеж	0	Коваленковский	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10190
Воронежская область	Воронеж	0	Колещатовка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10198
Воронежская область	Воронеж	0	Кузнецовский	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10251
Воронежская область	Воронеж	0	Куликовка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10253
Воронежская область	Воронеж	0	Митрофановка	\N	Кантемировского	\N	153516	ТГ	07-18 Вс 07-15	\N	\N	\N	\N	16	4738
Воронежская область	Воронеж	0	Михайловка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	16370
Воронежская область	Воронеж	0	Новобелая	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10372
Воронежская область	Воронеж	0	Новомарковка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10381
Воронежская область	Воронеж	0	Новопавловка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10385
Воронежская область	Воронеж	0	Осиковка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10420
Воронежская область	Воронеж	0	Писаревка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10463
Воронежская область	Воронеж	0	Рудаевка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10517
Воронежская область	Воронеж	0	Скнаровка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10551
Воронежская область	Воронеж	0	Смаглеевка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10555
Воронежская область	Воронеж	0	Соленый	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10558
Воронежская область	Воронеж	0	Софиевка	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10563
Воронежская область	Воронеж	0	Талы	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10594
Воронежская область	Воронеж	0	Титаревка	\N	Кантемировского	\N	153516	\N	07-20	Вс, Пн	\N	\N	\N	16	10606
Воронежская область	Воронеж	0	Фисенково	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10638
Воронежская область	Воронеж	0	Шевченково	\N	Кантемировского	\N	153516	\N	08-14	Вс, Пн	\N	\N	\N	16	10662
Воронежская область	Воронеж	0	Боево	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	9993
Вологодская область	Вологда	0	Коштуги	\N	Вытегорского	\N	146513	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9370
Вологодская область	Вологда	0	Макачево	\N	Вытегорского	\N	146513	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9406
Вологодская область	Вологда	0	Мегра	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9417
Вологодская область	Вологда	0	Межозерье	\N	Вытегорского	\N	146513	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9421
Вологодская область	Вологда	0	Мирный	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9426
Вологодская область	Вологда	0	Митино	\N	Вытегорского	\N	146513	\N	передвижной	Пн, Ср, Пт, Вс	\N	\N	\N	15	9429
Вологодская область	Вологда	0	Новостройка	\N	Вытегорского	\N	146513	\N	передвижной	Пн, Ср, Пт, Вс	\N	\N	\N	15	9479
Вологодская область	Вологда	0	Октябрьский	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9488
Вологодская область	Вологда	0	Ошта	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9499
Вологодская область	Вологда	0	Палтога	\N	Вытегорского	\N	146513	\N	08-17	Вс, Пн	\N	\N	\N	15	9502
Вологодская область	Вологда	0	Панкратово	\N	Вытегорского	\N	146513	\N	Чт, передвижной	Кроме Чт	\N	\N	\N	15	9504
Вологодская область	Вологда	0	Прокшино	\N	Вытегорского	\N	146513	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9547
Вологодская область	Вологда	0	Самино	\N	Вытегорского	\N	146513	\N	09-18	Вс, Пн	\N	\N	\N	15	9565
Вологодская область	Вологда	0	Сорокополье	\N	Вытегорского	\N	146513	\N	09-18	Пн, Ср, Пт, Вс	\N	\N	\N	15	9593
Вологодская область	Вологда	0	Ужла	\N	Вытегорского	\N	146513	\N	Пт, передвижной	Кроме Пт	\N	\N	\N	15	9626
Вологодская область	Вологда	0	Янишево	\N	Вытегорского	\N	146513	\N	09-18	Вс, Ср	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Анохино	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9186
Вологодская область	Вологда	0	Бушуиха	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Пт, Вс	\N	\N	\N	15	9231
Вологодская область	Вологда	0	Вараксино	\N	Грязовецкого	\N	146503	\N	09-16	Вс, Пн	\N	\N	\N	15	9233
Вологодская область	Вологда	0	Вохтога	\N	Грязовецкого	\N	146503	\N	09-18	Вс, Пн	\N	\N	\N	15	9261
Вологодская область	Вологда	0	Грязовец	\N	Грязовецкого	ц	146503	ТГ	09-17 Сб 09-15	Вс	ЛИ-6716-17	11.07.2017	\N	15	446
Вологодская область	Вологда	0	Жерноково	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9304
Вологодская область	Вологда	0	Заемье	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9309
Вологодская область	Вологда	0	Лежа	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Пт, Вс	\N	\N	\N	15	9392
Вологодская область	Вологда	0	Минькино	\N	Грязовецкого	\N	146503	\N	09-16	Вс, Пн	\N	\N	\N	15	9424
Вологодская область	Вологда	0	Плоское	\N	Грязовецкого	\N	146503	\N	09-16	Вс, Пн	\N	\N	\N	15	9523
Вологодская область	Вологда	0	Ростилово	\N	Грязовецкого	\N	146503	\N	09-18	Вс, Пн	\N	\N	\N	15	9560
Вологодская область	Вологда	0	Сидорово	\N	Грязовецкого	\N	146503	\N	09-16	Вс, Пн	\N	\N	\N	15	9576
Вологодская область	Вологда	0	Скородумка	\N	Грязовецкого	\N	146503	\N	09-18	Пн, Пт, Вс	\N	\N	\N	15	9579
Вологодская область	Вологда	0	Слобода	\N	Грязовецкого	\N	146503	\N	09-18	Вс, Пн	\N	\N	\N	15	9583
Вологодская область	Вологда	0	Фрол	\N	Грязовецкого	\N	146503	\N	09-18	Вс, Пн	\N	\N	\N	15	9644
Вологодская область	Вологда	0	Хорошево	\N	Грязовецкого	\N	146503	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9647
Вологодская область	Вологда	0	Юрово	\N	Грязовецкого	\N	146503	\N	09-18	Вс, Пн	\N	\N	\N	15	9684
Вологодская область	Вологда	0	Андроново	\N	Кадуйского	\N	146570	\N	09-17	Сб, Вс	\N	\N	\N	15	9180
Вологодская область	Вологда	0	Барановская	\N	Кадуйского	\N	146570	\N	08-17	Вс, Пн	\N	\N	\N	15	9199
Вологодская область	Вологда	0	Бойлово	\N	Кадуйского	\N	146570	\N	08-17	Вс, Вт	\N	\N	\N	15	9216
Вологодская область	Вологда	0	Кадуй	\N	Кадуйского	ц	146570	ТГ	10-19	Сб, Вс	ЛИ-6718-17	11.07.2017	\N	15	447
Вологодская область	Вологда	0	Маза	\N	Кадуйского	\N	146570	\N	09-18	Вс, Пн	\N	\N	\N	15	9402
Вологодская область	Вологда	0	Нижние	\N	Кадуйского	\N	146570	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9457
Вологодская область	Вологда	0	Никольское	Бывш. Стан	Кадуйского	\N	146570	\N	09-18	Вт, Вс	\N	\N	\N	15	9472
Вологодская область	Вологда	0	Селище	\N	Кадуйского	\N	146570	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9571
Вологодская область	Вологда	0	Сосновка	\N	Кадуйского	\N	146570	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9596
Вологодская область	Вологда	0	Уйта	\N	Кадуйского	\N	146570	\N	08-17	Вс, Пн	\N	\N	\N	15	9627
Вологодская область	Вологда	0	Фанерный Завод	\N	Кадуйского	\N	146570	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9637
Вологодская область	Вологда	0	Хохлово	\N	Кадуйского	\N	146570	\N	09-18	Вс, Пн	\N	\N	\N	15	9648
Вологодская область	Вологда	0	Ципелево	\N	Кадуйского	\N	146570	\N	11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9650
Вологодская область	Вологда	0	Бураково	\N	Кирилловского	\N	146510	\N	11-16.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	5809
Вологодская область	Вологда	0	Вогнема	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9251
Вологодская область	Вологда	0	Волокославинское	\N	Кирилловского	\N	146510	\N	08-16	Вс, Пн	\N	\N	\N	15	9254
Вологодская область	Вологда	0	Глухарево	\N	Кирилловского	\N	146510	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	5806
Вологодская область	Вологда	0	Горицы	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9272
Вологодская область	Вологда	0	Запань Нова	Бывш. Нефедьево	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Иванов Бор	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9318
Вологодская область	Вологда	0	Кириллов	\N	Кирилловского	ц	146510	ТГ	08-20 Сб 09-18	Вс	ЛИ-6719-17	11.07.2017	\N	15	448
Вологодская область	Вологда	0	Коварзино	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9349
Вологодская область	Вологда	0	Колкач	\N	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9356
Вологодская область	Вологда	0	Коротецкая	\N	Кирилловского	\N	146510	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9366
Вологодская область	Вологда	0	Никольский Торжок	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9468
Вологодская область	Вологда	0	Новостройка	\N	Кирилловского	\N	146510	\N	08-13.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9480
Вологодская область	Вологда	0	Пеньково	\N	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9508
Вологодская область	Вологда	0	Петровское	\N	Кирилловского	\N	146510	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9515
Вологодская область	Вологда	0	Рукино	\N	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9561
Вологодская область	Вологда	0	Русино	\N	Кирилловского	\N	146510	\N	10-15.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9562
Вологодская область	Вологда	0	Суховерхово	\N	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	9610
Вологодская область	Вологда	0	Талицы	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9612
Вологодская область	Вологда	0	Топорня	\N	Кирилловского	\N	146510	\N	10-15.20	Пн, Ср, Пт, Вс	ЛИ-8596-17	21.08.2017	\N	15	9620
Вологодская область	Вологда	0	Ферапонтово	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Чарозеро	\N	Кирилловского	\N	146510	\N	08-17	Вс, Пн	\N	\N	\N	15	9652
Вологодская область	Вологда	0	Чистый Дор	\N	Кирилловского	\N	146510	\N	09-14.20	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Алферово	\N	Кичменгско-Городецкого	\N	146504	\N	09-17	\N	\N	\N	\N	15	9177
Вологодская область	Вологда	0	Березовая Гора	\N	Кичменгско-Городецкого	\N	146504	\N	08-11	Вт, Чт, Сб, Вс	\N	\N	\N	15	9207
Вологодская область	Вологда	0	Берсенево	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Вт	\N	\N	\N	15	9209
Вологодская область	Вологда	0	Верхний Енангск	\N	Кичменгско-Городецкого	\N	146504	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9246
Вологодская область	Вологда	0	Верхняя Ентала	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Пн	\N	\N	\N	15	9247
Вологодская область	Вологда	0	Дорожково	\N	Кичменгско-Городецкого	\N	146504	\N	09-11	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Еловино	\N	Кичменгско-Городецкого	\N	146504	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9299
Вологодская область	Вологда	0	Исады	\N	Кичменгско-Городецкого	\N	146504	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9329
Вологодская область	Вологда	0	Кильченга	Бывш. Шестаково	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9340
Вологодская область	Вологда	0	Кичменгский Городок	\N	Кичменгско-Городецкого	ц	146504	ТГ	09-17 Сб 09-14	Вс	ЛИ-6720-17	11.07.2017	\N	15	449
Вологодская область	Вологда	0	Кичменьга	Бывш. Захарово	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9342
Вологодская область	Вологда	0	Кобыльск	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Пн	\N	\N	\N	15	9348
Вологодская область	Вологда	0	Косково	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Пн	\N	\N	\N	15	9368
Вологодская область	Вологда	0	Курилово	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9388
Вологодская область	Вологда	0	Лаптюг	\N	Кичменгско-Городецкого	\N	146504	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9390
Вологодская область	Вологда	0	Нижний Енангск	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Пн	\N	\N	\N	15	9459
Вологодская область	Вологда	0	Нижняя Ентала	\N	Кичменгско-Городецкого	\N	146504	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9460
Вологодская область	Вологда	0	Олятово	\N	Кичменгско-Городецкого	\N	146504	\N	10-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Подволочье	\N	Кичменгско-Городецкого	\N	146504	\N	10-12	Вт, Чт, Сб, Вс	\N	\N	\N	15	9527
Вологодская область	Вологда	0	Сараево	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9566
Вологодская область	Вологда	0	Светица	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9567
Вологодская область	Вологда	0	Слобода	\N	Кичменгско-Городецкого	\N	146504	\N	08-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9584
Вологодская область	Вологда	0	Слободка	\N	Кичменгско-Городецкого	\N	146504	\N	08-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9585
Вологодская область	Вологда	0	Судническая Гора	\N	Кичменгско-Городецкого	\N	146504	\N	08-11	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Шатенево	\N	Кичменгско-Городецкого	\N	146504	\N	08-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9665
Вологодская область	Вологда	0	Шонга	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вт, Вс	\N	\N	\N	15	9675
Вологодская область	Вологда	0	Югский	\N	Кичменгско-Городецкого	\N	146504	\N	08-17	Вс, Пн	\N	\N	\N	15	9681
Вологодская область	Вологда	0	Врагово	\N	Междуреченского	\N	146509	\N	08-17	Вс, Пн	\N	\N	\N	15	9264
Вологодская область	Вологда	0	Гаврипково	\N	Междуреченского	\N	146509	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Игумницево	\N	Междуреченского	\N	146509	\N	08-17	Вс, Пн	\N	\N	\N	15	9324
Вологодская область	Вологда	0	Кожухово	\N	Междуреченского	\N	146509	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9351
Вологодская область	Вологда	0	Новая	\N	Междуреченского	\N	146509	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	5754
Вологодская область	Вологда	0	Пионерский	\N	Междуреченского	\N	146509	\N	09-14	Вс, Пн, Ср, Пт	\N	\N	\N	15	9519
Вологодская область	Вологда	0	Святогорье	\N	Междуреченского	\N	146509	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9568
Вологодская область	Вологда	0	Спас-Ямщики	\N	Междуреченского	\N	146509	\N	08-17	Вс, Пн	\N	\N	\N	15	9597
Вологодская область	Вологда	0	Старое	\N	Междуреченского	\N	146509	\N	09-17	Вс, Пн	\N	\N	\N	15	9601
Вологодская область	Вологда	0	Туровец	\N	Междуреченского	\N	146509	\N	09-18	Вс, Пн	\N	\N	\N	15	9623
Вологодская область	Вологда	0	Шейбухта	\N	Междуреченского	\N	146509	\N	08-17	Вс, Пн	\N	\N	\N	15	9667
Вологодская область	Вологда	0	Шиченга	\N	Междуреченского	\N	146509	\N	09-14	Вс, Пн	\N	\N	\N	15	9671
Вологодская область	Вологда	0	Шуйское	\N	Междуреченского	ц	146509	ТГ	09-18	Вс	ЛИ-6734-17	11.07.2017	\N	15	464
Вологодская область	Вологда	0	Аксентьево	\N	Никольского	\N	146519	\N	09-17	\N	\N	\N	\N	15	9174
Вологодская область	Вологда	0	Аргуново	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9189
Вологодская область	Вологда	0	Байдарово	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9197
Вологодская область	Вологда	0	Большое Сверчково	\N	Никольского	\N	146519	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	15	9220
Вологодская область	Вологда	0	Борок	\N	Никольского	\N	146519	\N	08-17	Вс, Вт	\N	\N	\N	15	9226
Вологодская область	Вологда	0	Вахнево	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9236
Вологодская область	Вологда	0	Верховино	\N	Никольского	\N	146519	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9248
Вологодская область	Вологда	0	Высокинский	\N	Никольского	\N	146519	\N	09-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9262
Вологодская область	Вологда	0	Дунилово	\N	Никольского	\N	146519	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9296
Вологодская область	Вологда	0	Завражье	\N	Никольского	\N	146519	\N	08-17	Вт, Вс	\N	\N	\N	15	9307
Вологодская область	Вологда	0	Займище	\N	Никольского	\N	146519	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	15	9301
Вологодская область	Вологда	0	Зеленцово	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9316
Вологодская область	Вологда	0	Калинино	\N	Никольского	\N	146519	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9332
Вологодская область	Вологда	0	Кипшеньга	Бывш. Теребаево	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9336
Вологодская область	Вологда	0	Кожаево	\N	Никольского	\N	146519	\N	08-17	Вт, Вс	\N	\N	\N	15	9350
Вологодская область	Вологда	0	Куданга	\N	Никольского	\N	146519	\N	09-13	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Молодежный	\N	Никольского	\N	146519	\N	08-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9437
Вологодская область	Вологда	0	Нигино	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9455
Вологодская область	Вологда	0	Никольск	\N	Никольского	ц	146519	ТГ	08-17.15 Сб 09-18	Вс	ЛИ-6722-17	11.07.2017	\N	15	452
Вологодская область	Вологда	0	Никольское	\N	Никольского	\N	146519	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9469
Вологодская область	Вологда	0	Осиново	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9496
Вологодская область	Вологда	0	Пермас	\N	Никольского	\N	146519	\N	08-17	Вт, Вс	\N	\N	\N	15	9511
Вологодская область	Вологда	0	Полежаево	\N	Никольского	\N	146519	\N	08-17	Вт, Вс	\N	\N	\N	15	9536
Вологодская область	Вологда	0	Половина	\N	Никольского	\N	146519	\N	09-11	Пн, Ср, Пт, Вс	\N	\N	\N	15	9537
Вологодская область	Вологда	0	Филинский	Бывш. Марково	Никольского	\N	146519	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	5716
Вологодская область	Вологда	0	Шарженга	\N	Никольского	\N	146519	\N	08-17	Вс, Пн	\N	\N	\N	15	9664
Вологодская область	Вологда	0	Березовая Слободка	\N	Нюксенского	\N	146505	\N	09-12 Чт 08-16	Вт, Сб, Вс	\N	\N	\N	15	9208
Вологодская область	Вологда	0	Бобровское	\N	Нюксенского	\N	146505	\N	09-18	Вс, Вт	\N	\N	\N	15	9214
Вологодская область	Вологда	0	Брусенец	\N	Нюксенского	\N	146505	\N	09-13 Чт, Сб 09-14	Вт, Вс	\N	\N	\N	15	9228
Вологодская область	Вологда	0	Брусная	\N	Нюксенского	\N	146505	\N	09-13 Чт 09-16	Вт, Сб, Вс	\N	\N	\N	15	9229
Вологодская область	Вологда	0	Вострое	\N	Нюксенского	\N	146505	\N	09-18	Вт, Вс	\N	\N	\N	15	9259
Вологодская область	Вологда	0	Городищна	\N	Нюксенского	\N	146505	\N	09-18	Вт, Вс	\N	\N	\N	15	9274
Вологодская область	Вологда	0	Игмас	\N	Нюксенского	\N	146505	\N	09-18	Вт, Вс	\N	\N	\N	15	9323
Вологодская область	Вологда	0	Копылово	\N	Нюксенского	\N	146505	\N	10-14	Вт, Сб, Вс	\N	\N	\N	15	9361
Вологодская область	Вологда	0	Красавино	\N	Нюксенского	\N	146505	\N	09-13	Вт, Сб, Вс	\N	\N	\N	15	5786
Вологодская область	Вологда	0	Леваш	\N	Нюксенского	\N	146505	\N	09-16 Чт 09-17	Вт, Сб, Вс	\N	\N	\N	15	9391
Вологодская область	Вологда	0	Лесютино	\N	Нюксенского	\N	146505	\N	08-17	Вт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Матвеево	\N	Нюксенского	\N	146505	\N	09-17	Вт, Вс	\N	\N	\N	15	9414
Вологодская область	Вологда	0	Нюксеница	\N	Нюксенского	ц	146505	ТГ	09-17	Сб, Вс	ЛИ-6723-17	11.07.2017	\N	15	453
Вологодская область	Вологда	0	Юшково	\N	Нюксенского	\N	146505	\N	09-13	Вт, Сб, Вс	\N	\N	\N	15	9687
Вологодская область	Вологда	0	Архангельское	\N	Сокольского	\N	146540	\N	08-17	Вс, Пн	\N	\N	\N	15	9193
Вологодская область	Вологда	0	Биряково	\N	Сокольского	\N	146540	\N	09-18	Вс, Пн	\N	\N	\N	15	1319
Вологодская область	Вологда	0	Воробьево	\N	Сокольского	\N	146540	\N	08-17	Вс, Пн	\N	\N	\N	15	9255
Вологодская область	Вологда	0	Грибцово	\N	Сокольского	\N	146540	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9278
Вологодская область	Вологда	0	Замошье	\N	Сокольского	\N	146540	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9312
Вологодская область	Вологда	0	Кадников	\N	Сокольского	\N	146540	\N	08-20 Сб 09-18	Вс	\N	\N	\N	15	346
Вологодская область	Вологда	0	Литега	\N	Сокольского	\N	146540	\N	09-18	Вс, Пн	\N	\N	\N	15	9396
Вологодская область	Вологда	0	Марковское	\N	Сокольского	\N	146540	\N	08-17	Вс, Пн	\N	\N	\N	15	9412
Вологодская область	Вологда	0	Нестерово	\N	Сокольского	\N	146540	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9451
Вологодская область	Вологда	0	Обросово	\N	Сокольского	\N	146540	\N	09-18	Вс, Пн	\N	\N	\N	15	9483
Вологодская область	Вологда	0	Огарово	Бывш. Кувшиново	Сокольского	\N	146540	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	5747
Вологодская область	Вологда	0	Оларево	\N	Сокольского	\N	146540	\N	09-15 Сб 09-13	Пн, Ср, Пт, Вс	\N	\N	\N	15	9491
Вологодская область	Вологда	0	Сокол	\N	Сокольского	ц	146540	ТГ	08-18 Сб 09-17	Вс	ЛИ-6724-17	11.07.2017	\N	15	454
Вологодская область	Вологда	0	Чекшино	\N	Сокольского	\N	146540	\N	09-18	Вс, Пн	\N	\N	\N	15	9653
Вологодская область	Вологда	0	Чучково	\N	Сокольского	\N	146540	\N	09-18	Вс, Пн	\N	\N	\N	15	9659
Вологодская область	Вологда	0	Шера	\N	Сокольского	\N	146540	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9669
Вологодская область	Вологда	0	Георгиевская	Бывш. Коробицыно	Сямженского	\N	146500	\N	08-16	Вт, Вс	\N	\N	\N	15	9260
Вологодская область	Вологда	0	Гремячий	\N	Сямженского	\N	146500	\N	09-17	Вс, Пн	\N	\N	\N	15	9276
Вологодская область	Вологда	0	Житьево	\N	Сямженского	\N	146500	\N	09-18	Вт, Вс	\N	\N	\N	15	9305
Вологодская область	Вологда	0	Кононовская	\N	Сямженского	\N	146500	\N	08-17	Вт, Вс	\N	\N	\N	15	9358
Вологодская область	Вологда	0	Копылово	\N	Сямженского	\N	146500	\N	08-17	Вс, Пн	\N	\N	\N	15	9362
Вологодская область	Вологда	0	Коростелево	\N	Сямженского	\N	146500	\N	10-16.30	Вт, Чт, Сб, Вс	\N	\N	\N	15	9365
Вологодская область	Вологда	0	Марковская	\N	Сямженского	\N	146500	\N	10-15 Пт 10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Мирный	\N	Сямженского	\N	146500	\N	08-13 Пт 08-14	Вт, Чт, Сб, Вс	\N	\N	\N	15	9427
Вологодская область	Вологда	0	Пигилинская	\N	Сямженского	\N	146500	\N	08-17	Вт, Вс	\N	\N	\N	15	9516
Вологодская область	Вологда	0	Раменье	\N	Сямженского	\N	146500	\N	08-17	Вс, Пн	\N	\N	\N	15	9551
Вологодская область	Вологда	0	Согорки	\N	Сямженского	\N	146500	\N	12-17 Пт 11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Сямжа	\N	Сямженского	ц	146500	ТГ	09-18 Сб 09-17	Вс, Пн	ЛИ-6725-17	11.07.2017	\N	15	455
Вологодская область	Вологда	0	Усть-Река	\N	Сямженского	\N	146500	\N	08-17	Вс, Пн	\N	\N	\N	15	9632
Вологодская область	Вологда	0	Филинская	\N	Сямженского	\N	146500	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9641
Вологодская область	Вологда	0	Ширега	\N	Сямженского	\N	146500	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9670
Вологодская область	Вологда	0	Айга	\N	Тарногского	\N	146508	\N	09-17	\N	\N	\N	\N	15	9171
Вологодская область	Вологда	0	Афанасьевская	Бывш. Долговицы	Тарногского	\N	146508	\N	09-13	Вс, Пн, Пт	\N	\N	\N	15	9196
Вологодская область	Вологда	0	Верхнекокшеньгский Погост	Володинское	Тарногского	\N	146508	\N	09-17 Ср 09-12	Вс, Пн, Пт	\N	\N	\N	15	5807
Вологодская область	Вологда	0	Власьевская	\N	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	9250
Вологодская область	Вологда	0	Вощар	\N	Тарногского	\N	146508	\N	11-15	Вс, Пн, Пт	\N	\N	\N	15	9263
Вологодская область	Вологда	0	Евсеевская	Бывш. Аббакумовская	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	9297
Вологодская область	Вологда	0	Заречье	\N	Тарногского	\N	146508	\N	08-17	Вс, Пн	\N	\N	\N	15	9314
Вологодская область	Вологда	0	Илезский Погост	Бывш. Окуловская	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Конторка	\N	Тарногского	\N	146508	\N	10-14	Вс, Пн, Пт	\N	\N	\N	15	9359
Вологодская область	Вологда	0	Красное	\N	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	9371
Вологодская область	Вологда	0	Наумовская	\N	Тарногского	\N	146508	\N	10-14 Ср, Пт 09-15	Вс, Пн	\N	\N	\N	15	9448
Вологодская область	Вологда	0	Нижнепаунинская	\N	Тарногского	\N	146508	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9458
Вологодская область	Вологда	0	Никифоровская	\N	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	9464
Вологодская область	Вологда	0	Раменье	\N	Тарногского	\N	146508	\N	09-13	Вт, Сб, Вс	\N	\N	\N	15	9552
Вологодская область	Вологда	0	Ромашевский Погост	Бывш. Ромашево	Тарногского	\N	146508	\N	09-14	Вс, Пн	\N	\N	\N	15	9558
Вологодская область	Вологда	0	Сергиевская	\N	Тарногского	\N	146508	\N	09-13	Вт, Сб, Вс	\N	\N	\N	15	9574
Вологодская область	Вологда	0	Тарногский Городок	\N	Тарногского	ц	146508	ТГ	08-20 Сб 09-17	Вс	ЛИ-6726-17	11.07.2017	\N	15	456
Вологодская область	Вологда	0	Тюприха	\N	Тарногского	\N	146508	\N	09.30-14 Ср, Пт 10-14	Вс, Пн	\N	\N	\N	15	9624
Вологодская область	Вологда	0	Шебенгский Погост	Бывш. Шебеньга	Тарногского	\N	146508	\N	09-18	Вс, Пн	\N	\N	\N	15	9666
Вологодская область	Вологда	0	Бор	Бывш. Усть-Толшма	Тотемского	\N	146517	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9222
Вологодская область	Вологда	0	Великий Двор	\N	Тотемского	\N	146517	\N	09-18	Вс, Пн	\N	\N	\N	15	9239
Вологодская область	Вологда	0	Гремячий	\N	Тотемского	\N	146517	\N	11-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Данилов Починок	\N	Тотемского	\N	146517	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9281
Вологодская область	Вологда	0	Камчуга	\N	Тотемского	\N	146517	\N	08-17 Ср, Пт 08-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9334
Вологодская область	Вологда	0	Карица	\N	Тотемского	\N	146517	\N	11-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Красный Бор	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9372
Вологодская область	Вологда	0	Крутая Осыпь	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	5782
Вологодская область	Вологда	0	Кудринская	\N	Тотемского	\N	146517	\N	08-17	Чт, Вс	\N	\N	\N	15	9379
Вологодская область	Вологда	0	Матвеево	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9415
Вологодская область	Вологда	0	Медведево	\N	Тотемского	\N	146517	\N	08-17	Вс, Чт	\N	\N	\N	15	9420
Вологодская область	Вологда	0	Михайловка	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9431
Вологодская область	Вологда	0	Мосеево	\N	Тотемского	\N	146517	\N	09-18	Вс, Пн	\N	\N	\N	15	9442
Вологодская область	Вологда	0	Никольское	\N	Тотемского	\N	146517	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	15	9470
Вологодская область	Вологда	0	Октябрьский	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9489
Вологодская область	Вологда	0	Погорелово	\N	Тотемского	\N	146517	\N	08-17	Вс, Пн	\N	\N	\N	15	9525
Вологодская область	Вологда	0	Середская	\N	Тотемского	\N	146517	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9575
Вологодская область	Вологда	0	Советский	\N	Тотемского	\N	146517	\N	08-17	Вс, Пн	\N	\N	\N	15	9591
Вологодская область	Вологда	0	Текстильщик	Бывш. Усть-Еденьга	Тотемского	\N	146517	\N	09-17 Пт 08-16 Сб 09.30-15.30	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Тотьма	\N	Тотемского	ц	146517	ТГ	08-17	Вс	ЛИ-6727-17	11.07.2017	\N	15	458
Вологодская область	Вологда	0	Успенье	\N	Тотемского	\N	146517	\N	09-18	Вс, Пн	\N	\N	\N	15	9630
Вологодская область	Вологда	0	Устье	\N	Тотемского	\N	146517	\N	09-15 Ср 09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9634
Вологодская область	Вологда	0	Царева	Бывш. Калинино	Тотемского	\N	146517	\N	08-17	Вс, Пн	\N	\N	\N	15	9649
Вологодская область	Вологда	0	Юбилейный	\N	Тотемского	\N	146517	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	15	9680
Вологодская область	Вологда	0	Чуриловка	Бывш. Ухтанга	ТОТЬМА	\N	146517	\N	09-15 Чт 09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Бережное	\N	Усть-Кубинского	\N	146590	\N	09-18	Вс, Пн	\N	\N	\N	15	9205
Вологодская область	Вологда	0	Богородское	\N	Усть-Кубинского	\N	146590	\N	09-18	Вс, Пн	\N	\N	\N	15	9215
Вологодская область	Вологда	0	Высокое	\N	Усть-Кубинского	\N	146590	\N	10-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9265
Вологодская область	Вологда	0	Заднее	\N	Усть-Кубинского	\N	146590	\N	09-18	Вс, Пн	\N	\N	\N	15	9308
Вологодская область	Вологда	0	Королиха	\N	Усть-Кубинского	\N	146590	\N	10-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9364
Вологодская область	Вологда	0	Марковская	\N	Усть-Кубинского	\N	146590	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9411
Вологодская область	Вологда	0	Митенское	\N	Усть-Кубинского	\N	146590	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9428
Вологодская область	Вологда	0	Никола-Корень	\N	Усть-Кубинского	\N	146590	\N	09-14 Сб 09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9466
Вологодская область	Вологда	0	Никольское	\N	Усть-Кубинского	\N	146590	\N	09-18	Вс, Пн	\N	\N	\N	15	9471
Вологодская область	Вологда	0	Порохово	\N	Усть-Кубинского	\N	146590	\N	09-18	Вс, Пн	\N	\N	\N	15	9541
Вологодская область	Вологда	0	Устье	\N	Усть-Кубинского	ц	146590	ТГ	09-17	Вс, Пн	ЛИ-6728-17	11.07.2017	\N	15	459
Вологодская область	Вологда	0	Брилино	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9227
Вологодская область	Вологда	0	Ванское	\N	Устюженского	\N	146518	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9232
Вологодская область	Вологда	0	Веницы	\N	Устюженского	\N	146518	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9242
Вологодская область	Вологда	0	Даниловское	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9282
Вологодская область	Вологда	0	Долоцкое	\N	Устюженского	\N	146518	\N	08-17	Вс, Чт	\N	\N	\N	15	9291
Вологодская область	Вологда	0	Им. Желябова	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9327
Вологодская область	Вологда	0	Круглицы	\N	Устюженского	\N	146518	\N	10-17 Чт, Сб 11-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9375
Вологодская область	Вологда	0	Лентьево	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9378
Вологодская область	Вологда	0	Малое Восное	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9408
Вологодская область	Вологда	0	Мережа	\N	Устюженского	\N	146518	\N	09-17	\N	\N	\N	\N	15	9422
Вологодская область	Вологда	0	Модно	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9435
Вологодская область	Вологда	0	Мочала	\N	Устюженского	\N	146518	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9443
Вологодская область	Вологда	0	Никола	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9465
Вологодская область	Вологда	0	Расторопово	\N	Устюженского	\N	146518	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9554
Вологодская область	Вологда	0	Славынево	\N	Устюженского	\N	146518	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9580
Вологодская область	Вологда	0	Соболево	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9589
Вологодская область	Вологда	0	Спасское	\N	Устюженского	\N	146518	\N	09-18	Вс, Пн	\N	\N	\N	15	9598
Вологодская область	Вологда	0	Степачево	\N	Устюженского	\N	146518	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9603
Вологодская область	Вологда	0	Устюжна	\N	Устюженского	ц	146518	ТГ	09-17	Сб, Вс	ЛИ-6729-17	11.07.2017	\N	15	460
Вологодская область	Вологда	0	Яковлевское	\N	Устюженского	\N	146518	\N	09.30-15.30	Вт, Чт, Сб, Вс	\N	\N	\N	15	9689
Вологодская область	Вологда	0	Ярцево	\N	Устюженского	\N	146518	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9691
Вологодская область	Вологда	0	Арзубиха	\N	Харовского	\N	146520	\N	08-17	Вс, Пн	\N	\N	\N	15	9190
Вологодская область	Вологда	0	Ивачино	\N	Харовского	\N	146520	\N	09.30-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9322
Вологодская область	Вологда	0	Кумзеро	\N	Харовского	\N	146520	\N	10-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9385
Вологодская область	Вологда	0	Межурки	Бывш. Куляшиха	Харовского	\N	146520	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Михайловское	\N	Харовского	\N	146520	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9433
Вологодская область	Вологда	0	Нижне-Кубенское	\N	Харовского	\N	146520	\N	08-17	Вс, Пн	\N	\N	\N	15	9456
Вологодская область	Вологда	0	Никольский Погост	Бывш. Никольское	Харовского	\N	146520	\N	08-17	Вс, Пн	\N	\N	\N	15	9463
Вологодская область	Вологда	0	Поповка	\N	Харовского	\N	146520	\N	08-17	Чт, Вс	\N	\N	\N	15	9539
Вологодская область	Вологда	0	Пундуга	\N	Харовского	\N	146520	\N	08-17	Вт, Вс	\N	\N	\N	15	9549
Вологодская область	Вологда	0	Семениха	\N	Харовского	\N	146520	\N	08-17	Вс, Пн	\N	\N	\N	15	9572
Вологодская область	Вологда	0	Семигородняя	\N	Харовского	\N	146520	\N	08-17	Вс, Пн	\N	\N	\N	15	9573
Вологодская область	Вологда	0	Сорожино	\N	Харовского	\N	146520	\N	09-13	Вт, Сб, Вс	\N	\N	\N	15	9592
Вологодская область	Вологда	0	Томашка	\N	Харовского	\N	146520	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Харовск	\N	Харовского	ц	146520	ТГ	09-18	Вс	ЛИ-6730-17	11.07.2017	\N	15	461
Вологодская область	Вологда	0	Анисимово	\N	Чагодощенского	\N	146507	\N	09-17	\N	\N	\N	\N	15	9183
Вологодская область	Вологда	0	Анишино	Бывш. Лукинское	Чагодощенского	\N	146507	\N	09-16 Ср, Пт 10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9184
Вологодская область	Вологда	0	Борисово	\N	Чагодощенского	\N	146507	\N	09-18	Вс, Пн	\N	\N	\N	15	9224
Вологодская область	Вологда	0	Мегрино	\N	Чагодощенского	\N	146507	\N	09-18	Вс, Пн	\N	\N	\N	15	9418
Вологодская область	Вологда	0	Покровское	\N	Чагодощенского	\N	146507	\N	09-18	Вс, Пн	\N	\N	\N	15	9534
Вологодская область	Вологда	0	Сазоново	\N	Чагодощенского	\N	146507	\N	09-18	Вс, Пн	\N	\N	\N	15	9563
Вологодская область	Вологда	0	Смердомльский	\N	Чагодощенского	\N	146507	\N	09-18	Чт, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Трухино	Бывш. Избоищи	Чагодощенского	\N	146507	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9622
Вологодская область	Вологда	0	Чагода	\N	Чагодощенского	ц	146507	ТГ	09-18	Вс, Пн	ЛИ-6731-17	11.07.2017	\N	15	462
Вологодская область	Вологда	0	Абаканово	\N	Череповецкого	\N	146511	\N	07-20	Вт, Вс	\N	\N	\N	15	9169
Вологодская область	Вологда	0	Аксеново	\N	Череповецкого	\N	146511	\N	09-17	Вс, Пн	\N	\N	\N	15	9173
Вологодская область	Вологда	0	Андогский	\N	Череповецкого	\N	146511	\N	09.30-15.20	Вт, Чт, Сб, Вс	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Архангельское	\N	Череповецкого	\N	146511	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9194
Вологодская область	Вологда	0	Батран	\N	Череповецкого	\N	146511	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9200
Вологодская область	Вологда	0	Большая Ягница	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9217
Вологодская область	Вологда	0	Большой Двор	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9210
Вологодская область	Вологда	0	Ботово	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	5810
Вологодская область	Вологда	0	Воскресенское	\N	Череповецкого	\N	146511	\N	09-17	Сб, Вс	\N	\N	\N	15	9253
Вологодская область	Вологда	0	Воскресенское На Мусоре	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9258
Вологодская область	Вологда	0	Дермянинское	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9288
Вологодская область	Вологда	0	Дора	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9292
Вологодская область	Вологда	0	Дуброво	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9294
Вологодская область	Вологда	0	Ивановское	\N	Череповецкого	\N	146511	\N	09-18	Вт, Вс	\N	\N	\N	15	9321
Вологодская область	Вологда	0	Ильинское	\N	Череповецкого	\N	146511	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9326
Вологодская область	Вологда	0	Ирдоматка	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9328
Вологодская область	Вологда	0	Климовское	\N	Череповецкого	\N	146511	\N	09-18	Вт, Вс	\N	\N	\N	15	8859
Вологодская область	Вологда	0	Коротово	\N	Череповецкого	\N	146511	\N	08-17	Вт, Вс	\N	\N	\N	15	9363
Вологодская область	Вологда	0	Кривец	\N	Череповецкого	\N	146511	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	15	9374
Вологодская область	Вологда	0	Малечкино	\N	Череповецкого	\N	146511	\N	09-18	Сб, Вс	\N	\N	\N	15	5781
Вологодская область	Вологда	0	Мякса	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9441
Вологодская область	Вологда	0	Надпорожье	\N	Череповецкого	\N	146511	\N	09.40-15.30	Вт, Чт, Сб, Вс	\N	\N	\N	15	9447
Вологодская область	Вологда	0	Нелазское	\N	Череповецкого	\N	146511	\N	09-18	Вт, Вс	\N	\N	\N	15	9449
Вологодская область	Вологда	0	Нестеровское	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9452
Вологодская область	Вологда	0	Николо-Раменье	\N	Череповецкого	\N	146511	\N	09-18	Вт, Вс	\N	\N	\N	15	9467
Вологодская область	Вологда	0	Новое Домозерово	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9475
Вологодская область	Вологда	0	Песье	\N	Череповецкого	\N	146511	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9514
Вологодская область	Вологда	0	Пленишник	\N	Череповецкого	\N	146511	\N	11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9520
Вологодская область	Вологда	0	Плосково	\N	Череповецкого	\N	146511	\N	11-17	Вт, Чт, Сб, Вс	\N	\N	\N	15	9522
Вологодская область	Вологда	0	Покров	\N	Череповецкого	\N	146511	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9531
Вологодская область	Вологда	0	Поповка	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9540
Вологодская область	Вологда	0	Починок	\N	Череповецкого	\N	146511	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9544
Вологодская область	Вологда	0	Романово	\N	Череповецкого	\N	146511	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9557
Вологодская область	Вологда	0	Соболево	\N	Череповецкого	\N	146511	\N	09-15	Вт, Чт, Сб, Вс	\N	\N	\N	15	9590
Вологодская область	Вологда	0	Суда	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9606
Вологодская область	Вологда	0	Сурково	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9608
Вологодская область	Вологда	0	Тоншалово	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9619
Вологодская область	Вологда	0	Угрюмово	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	9625
Вологодская область	Вологда	0	Улазорский	\N	Череповецкого	\N	146511	\N	10-16	Вт, Чт, Сб, Вс	\N	\N	\N	15	5584
Вологодская область	Вологда	0	Харламовское	\N	Череповецкого	\N	146511	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9645
Вологодская область	Вологда	0	Чаево	\N	Череповецкого	\N	146511	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9651
Вологодская область	Вологда	0	Череповец	\N	Череповецкого	ц	146511	ТГ	08-20	\N	ЛИ-6732-17	11.07.2017	\N	15	\N
Вологодская область	Вологда	0	Шайма	\N	Череповецкого	\N	146511	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9661
Вологодская область	Вологда	0	Шалимово	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	9662
Вологодская область	Вологда	0	Шишовка	\N	Череповецкого	\N	146511	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9672
Вологодская область	Вологда	0	Шулма	\N	Череповецкого	\N	146511	\N	09-17	Вт, Вс	\N	\N	\N	15	9676
Вологодская область	Вологда	0	Шухободь	\N	Череповецкого	\N	146511	\N	09-17	Вт, Вс	\N	\N	\N	15	9677
Вологодская область	Вологда	0	Щетининское	\N	Череповецкого	\N	146511	\N	09-18	Вс, Пн	\N	\N	\N	15	\N
Вологодская область	Вологда	0	Яганово	\N	Череповецкого	\N	146511	\N	09-18	Вт, Вс	\N	\N	\N	15	9688
Вологодская область	Вологда	0	Ясная Поляна	\N	Череповецкого	\N	146511	\N	08-16	Вс, Пн	\N	\N	\N	15	9692
Вологодская область	Вологда	0	Ершово	\N	Шекснинского	\N	146506	\N	09-18	Вт, Вс	\N	\N	\N	15	9303
Вологодская область	Вологда	0	Княже	Бывш. Еремеево	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9347
Вологодская область	Вологда	0	Любомирово	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9401
Вологодская область	Вологда	0	Митицыно	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9430
Вологодская область	Вологда	0	Нифантово	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9473
Вологодская область	Вологда	0	Пача	\N	Шекснинского	\N	146506	\N	08-17	Вт, Вс	\N	\N	\N	15	9500
Вологодская область	Вологда	0	Покровское	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9535
Вологодская область	Вологда	0	Сизьма	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	9577
Вологодская область	Вологда	0	Слизово	\N	Шекснинского	\N	146506	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9581
Вологодская область	Вологда	0	Фоминское	\N	Шекснинского	\N	146506	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9642
Вологодская область	Вологда	0	Чаромское	\N	Шекснинского	\N	146506	\N	09-17	Вс, Пн	\N	\N	\N	15	5712
Вологодская область	Вологда	0	Чебсара	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	5704
Вологодская область	Вологда	0	Чернеево	\N	Шекснинского	\N	146506	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	9655
Вологодская область	Вологда	0	Чуровское	\N	Шекснинского	\N	146506	\N	09-18	Вс, Пн	\N	\N	\N	15	5701
Вологодская область	Вологда	0	Шексна	\N	Шекснинского	ц	146506	ТГ	08-20 Сб 09-18	Вс	ЛИ-6733-17	11.07.2017	\N	15	463
Вологодская область	Вологда	0	Шигоево	\N	Шекснинского	\N	146506	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	15	5697
Вологодская область	Вологда	0	Юрочкино	\N	Шекснинского	\N	146506	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	15	9685
Воронежская область	Воронеж	0	Анна	\N	Аннинского	ц	153551	ТГ	08-19	\N	\N	\N	\N	16	465
Воронежская область	Воронеж	0	Артюшкино	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	9968
Воронежская область	Воронеж	0	Архангельское	\N	Аннинского	\N	153551	\N	08-20	Вс	\N	\N	\N	16	4732
Воронежская область	Воронеж	0	Березовка	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	9979
Воронежская область	Воронеж	0	Большая Алексеевка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	9995
Воронежская область	Воронеж	0	Большие Ясырки	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10004
Воронежская область	Воронеж	0	Бродовое	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10016
Воронежская область	Воронеж	0	Васильевка	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10028
Воронежская область	Воронеж	0	Верхняя Тойда	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10048
Воронежская область	Воронеж	0	Гусевка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10096
Воронежская область	Воронеж	0	Дерябкино	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10105
Иркутская область	Иркутск	+5	Бильчир	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Воронежская область	Воронеж	0	Дубровка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10122
Воронежская область	Воронеж	0	Желанное	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10143
Воронежская область	Воронеж	0	Красный Лог	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10238
Воронежская область	Воронеж	0	Круглоподпольное	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10249
Воронежская область	Воронеж	0	Левашовка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10264
Воронежская область	Воронеж	0	Мосоловка	\N	Аннинского	\N	153551	\N	08-14 Вт, Ср, Чт, Пт, Сб 08.00-17.00	Вс, Пн	ЛИ-506-16	14.12.2016	\N	16	10328
Воронежская область	Воронеж	0	Моховое	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10329
Воронежская область	Воронеж	0	Нащекино	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10334
Воронежская область	Воронеж	0	Николаевка	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10355
Воронежская область	Воронеж	0	Никольское	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10359
Воронежская область	Воронеж	0	Новая Жизнь	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10366
Воронежская область	Воронеж	0	Новонадежденский	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Новый Курлак	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10400
Воронежская область	Воронеж	0	Октябрьское	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10406
Воронежская область	Воронеж	0	Островки	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10421
Воронежская область	Воронеж	0	Петровка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10456
Воронежская область	Воронеж	0	Пугачевский	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10496
Воронежская область	Воронеж	0	Рамонье	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10504
Воронежская область	Воронеж	0	Романовка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10510
Воронежская область	Воронеж	0	Рубашевка	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10516
Воронежская область	Воронеж	0	Сабуровка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10529
Воронежская область	Воронеж	0	Садовое	\N	Аннинского	\N	153551	\N	08-20	Вс	\N	\N	\N	16	6243
Воронежская область	Воронеж	0	Садовое 1	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	6223
Воронежская область	Воронеж	0	Софьинка	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Старая Тойда	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10572
Воронежская область	Воронеж	0	Старая Чигла	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10574
Воронежская область	Воронеж	0	Старый Курлак	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10581
Воронежская область	Воронеж	0	Студеное	\N	Аннинского	\N	153551	\N	08-14	Вс, Пн	\N	\N	\N	16	10587
Воронежская область	Воронеж	0	Хлебородное	\N	Аннинского	\N	153551	\N	07-20	Вс, Пн	\N	\N	\N	16	10643
Воронежская область	Воронеж	0	Анновка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	9965
Воронежская область	Воронеж	0	Бобров	\N	Бобровского	ц	153522	ТГ	07-21	\N	\N	\N	\N	16	466
Воронежская область	Воронеж	0	Верхний Икорец	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10041
Воронежская область	Воронеж	0	Верхний Икорец 1	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10037
Воронежская область	Воронеж	0	Коршево	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10219
Воронежская область	Воронеж	0	Красный	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10235
Воронежская область	Воронеж	0	Липовка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10272
Воронежская область	Воронеж	0	Мечетка	\N	Бобровского	\N	153522	\N	07-12	Вс, Пн	\N	\N	\N	16	10313
Воронежская область	Воронеж	0	Нескучный	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10338
Воронежская область	Воронеж	0	Николо-Варваринка	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10357
Воронежская область	Воронеж	0	Никольское-Второе	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Новый Буравль	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10399
Воронежская область	Воронеж	0	Песковатка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10451
Воронежская область	Воронеж	0	Пчелиновка	\N	Бобровского	\N	153522	\N	07-11	Вс, Пн	\N	\N	\N	16	10499
Воронежская область	Воронеж	0	Семено-Александровка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10537
Воронежская область	Воронеж	0	Сухая Березовка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10590
Воронежская область	Воронеж	0	Тройня	\N	Бобровского	\N	153522	\N	08-14	Вс, Пн	\N	\N	\N	16	10620
Воронежская область	Воронеж	0	Хреновое	\N	Бобровского	\N	153522	ТГ	08-17	Вс	\N	\N	\N	16	4741
Воронежская область	Воронеж	0	Хреновое 1	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	16379
Воронежская область	Воронеж	0	Хреновое 2	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	16380
Воронежская область	Воронеж	0	Хреновое 3	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	16381
Воронежская область	Воронеж	0	Чесменка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10654
Воронежская область	Воронеж	0	Шестаково	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10664
Воронежская область	Воронеж	0	Шестаково 1	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Шишовка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10667
Воронежская область	Воронеж	0	Юдановка	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10680
Воронежская область	Воронеж	0	Ясенки	\N	Бобровского	\N	153522	\N	07-20	Вс, Пн	\N	\N	\N	16	10687
Воронежская область	Воронеж	0	Абросимово	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	9947
Воронежская область	Воронеж	0	Белая Горка-Первая	\N	Богучарского	\N	153552	\N	08-14	Вс, Пн	\N	\N	\N	16	9976
Воронежская область	Воронеж	0	Кардаиловка	\N	Поворинского	\N	153515	\N	08-14	Вс, Пн	\N	\N	\N	16	10183
Воронежская область	Воронеж	0	Мазурка	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10288
Воронежская область	Воронеж	0	Октябрьский	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10405
Воронежская область	Воронеж	0	Октябрьское	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10407
Воронежская область	Воронеж	0	Пески	\N	Поворинского	\N	153515	\N	08-20	Вс	\N	\N	\N	16	10447
Воронежская область	Воронеж	0	Пески-1	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10449
Воронежская область	Воронеж	0	Пески-2	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10450
Воронежская область	Воронеж	0	Поворино	в зоне обслуживания Борисоглебского РУЭС	Поворинского	ц	153515	ТГ	08-17	\N	\N	\N	\N	16	490
Воронежская область	Воронеж	0	Поворино-1	\N	Поворинского	\N	153515	\N	08-20	Вс	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Рождественское	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10508
Воронежская область	Воронеж	0	Рождественское-1	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10509
Воронежская область	Воронеж	0	Самодуровка	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10531
Воронежская область	Воронеж	0	Андреевка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	9961
Воронежская область	Воронеж	0	Басовка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	9975
Воронежская область	Воронеж	0	Белогорье	\N	Подгоренского	\N	153562	ТГ	09-18	Сб, Вс	\N	\N	\N	16	4733
Воронежская область	Воронеж	0	Березово	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	9983
Воронежская область	Воронеж	0	Большая Дмитровка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	9997
Воронежская область	Воронеж	0	Большая Хвощеватка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10002
Воронежская область	Воронеж	0	Большой Скорорыб	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10008
Воронежская область	Воронеж	0	Верхний Карабут	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10042
Воронежская область	Воронеж	0	Витебск	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10049
Воронежская область	Воронеж	0	Гончаровка	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10083
Воронежская область	Воронеж	0	Григорьевка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10092
Воронежская область	Воронеж	0	Колодежное	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10201
Воронежская область	Воронеж	0	Костомарово	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10223
Воронежская область	Воронеж	0	Лыково	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10287
Воронежская область	Воронеж	0	Морозовка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10324
Воронежская область	Воронеж	0	Опыт-Совхоз	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10411
Воронежская область	Воронеж	0	Перевальное	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10439
Воронежская область	Воронеж	0	Побединщина	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10467
Воронежская область	Воронеж	0	Подгоренский	в зоне обслуживания Павловского РУЭС	Подгоренского	ц	153562	ТГ	07-21 Сб, Вс 10-16	\N	ЛИ-8227-17	15.08.2017	\N	16	491
Воронежская область	Воронеж	0	Подгорное	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	6281
Воронежская область	Воронеж	0	Пробуждение-Совхоз	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10495
Воронежская область	Воронеж	0	Сагуны	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10530
Воронежская область	Воронеж	0	Саприно	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10533
Воронежская область	Воронеж	0	Семейка	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10536
Воронежская область	Воронеж	0	Сергеевка	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10543
Воронежская область	Воронеж	0	Суд-Николаевка	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10589
Воронежская область	Воронеж	0	Сухая Россошь	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10591
Воронежская область	Воронеж	0	Терновое	\N	Подгоренского	\N	153562	\N	08-14	Вс, Пн	\N	\N	\N	16	10602
Воронежская область	Воронеж	0	Юдино	\N	Подгоренского	\N	153562	\N	07-20	Вс, Пн	\N	\N	\N	16	10681
Воронежская область	Воронеж	0	Айдарово	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	9948
Воронежская область	Воронеж	0	Березово	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	9985
Воронежская область	Воронеж	0	Березово-1	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	9986
Воронежская область	Воронеж	0	Богданово	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	9990
Воронежская область	Воронеж	0	Большая Верейка	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	9996
Воронежская область	Воронеж	0	Бор	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10009
Воронежская область	Воронеж	0	Вниисс	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10056
Воронежская область	Воронеж	0	Горожанка	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10087
Воронежская область	Воронеж	0	Карачун	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10181
Воронежская область	Воронеж	0	Князево	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10188
Воронежская область	Воронеж	0	Комсомольский	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10209
Воронежская область	Воронеж	0	Кривоборье	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10242
Воронежская область	Воронеж	0	Лебяжье	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10263
Воронежская область	Воронеж	0	Ломово	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10277
Воронежская область	Воронеж	0	Лопатки	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10278
Воронежская область	Воронеж	0	Нелжа	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10336
Воронежская область	Воронеж	0	Новоживотинное	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10378
Воронежская область	Воронеж	0	Павловка	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10428
Воронежская область	Воронеж	0	Пчельники	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10500
Воронежская область	Воронеж	0	Рамонь	в зоне обслуживания Семилукского РУЭС	Рамонского	ц	153571	ТГ	07-18 Сб, Вс 09-16	\N	\N	\N	\N	16	493
Воронежская область	Воронеж	0	Русская Гвоздевка	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10523
Воронежская область	Воронеж	0	Сенное	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10542
Воронежская область	Воронеж	0	Скляево	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10550
Воронежская область	Воронеж	0	Сомово	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10561
Воронежская область	Воронеж	0	Ступино	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10588
Воронежская область	Воронеж	0	Трещевка	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10615
Воронежская область	Воронеж	0	Хвощеватка	\N	Рамонского	\N	153571	\N	08-14	Вс, Пн	\N	\N	\N	16	10640
Воронежская область	Воронеж	0	Чертовицы	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10653
Воронежская область	Воронеж	0	Чистая Поляна	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10657
Воронежская область	Воронеж	0	Ямное	\N	Рамонского	\N	153571	\N	07-20	Вс, Пн	\N	\N	\N	16	10686
Воронежская область	Воронеж	0	Бутырки	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10022
Воронежская область	Воронеж	0	Истобное	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10167
Воронежская область	Воронеж	0	Истобное 1	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10168
Воронежская область	Воронеж	0	Колбино	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10196
Воронежская область	Воронеж	0	Корнеевка	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10217
Воронежская область	Воронеж	0	Краснолипье	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10229
Воронежская область	Воронеж	0	Новосолдатка	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10389
Воронежская область	Воронеж	0	Одинцовка	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10402
Воронежская область	Воронеж	0	Осадчее	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10418
Воронежская область	Воронеж	0	Платава	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10464
Воронежская область	Воронеж	0	Прилепы	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10490
Воронежская область	Воронеж	0	Прилужный	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10491
Воронежская область	Воронеж	0	Репьевка	в зоне обслуживания Острогожского РУЭС	Репьевского	ц	153572	ТГ	08-21	\N	\N	\N	\N	16	494
Воронежская область	Воронеж	0	Россошки	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10512
Воронежская область	Воронеж	0	Россошь	\N	Репьевского	\N	153572	\N	07-20	Вс, Пн	\N	\N	\N	16	10513
Воронежская область	Воронеж	0	Скорицкое	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10552
Воронежская область	Воронеж	0	Усть-Муравлянка	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10632
Воронежская область	Воронеж	0	Ячейка	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	16385
Город Байконур	г.Байконур	0	Байконур	\N	\N	\N	351911	ТГ	7.30-18	\N	\N	\N	\N	8	30061
Город Байконур	г.Байконур	0	Байконур	\N	\N	г	351ххх	ТГ	\N	\N	ЛИ-7359-17	13.07.2017	\N	8	30061
Город Москва	г.Москва	0	Москва	\N	\N	\N	111ХХХ	ТГ	08-20	\N	\N	\N	\N	43	1489
Город Санкт-Петербург	г.Санкт-Петербург	0	Санкт-Петербург	\N	\N	\N	121ххх	ТГ	08-20	\N	\N	\N	\N	38	4706
Город Севастополь	г.Севастополь	0	Севастополь	Почтой заказное	\N	г	197ХХХ	ТГ	\N	\N	ЛИ-1203-18	08.06.2018	\N	261	30769
Еврейская автономная область	Биробиджан	+7	Биробиджан	\N	\N	\N	339ххх	ТГ	08-20	Вс	\N	\N	\N	18	555
Еврейская автономная область	Биробиджан	+7	Валдгейм	\N	Биробиджанского	\N	339523	ТГ	09-18	Вс, Пн	\N	\N	\N	18	547
Еврейская автономная область	Биробиджан	+7	Птичник	\N	Биробиджанского	\N	339528	ТГ	09-18	Вс, Пн	\N	\N	\N	18	553
Еврейская автономная область	Биробиджан	+7	Ленинское	\N	Ленинского	ц	339512	ТГ	09-18	Вс	\N	\N	\N	18	551
Еврейская автономная область	Биробиджан	+7	Облучье	\N	Облученского	ц	339513	ТГ	09-18	Сб, Вс	\N	\N	\N	18	552
Еврейская автономная область	Биробиджан	+7	Амурзет	\N	Октябрьского	ц	339511	ТГ	09-18	Вс	\N	\N	\N	18	545
Еврейская автономная область	Биробиджан	+7	Смидович	\N	Смидовичского	ц	339514	ТГ	09-18	Сб, Вс	\N	\N	\N	18	554
Забайкальский край	Чита	+6	Агинское	\N	Агинского	ц	225501	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2580-17	30.12.1899	\N	82	\N
Забайкальский край	Чита	+6	Акша	\N	Акшинского	ц	225530	ТГ	08-16	Сб, Вс	\N	\N	\N	82	2853
Забайкальский край	Чита	+6	Александровский Завод	\N	Александрово-Заводского	ц	225522	\N	\N	\N	\N	\N	\N	82	2854
Забайкальский край	Чита	+6	Балей	\N	Балейского	ц	225517	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2859
Забайкальский край	Чита	+6	Борзя	Кроме Борзя-2, Борзя-3	Борзинского	ц	225522	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2861
Забайкальский край	Чита	+6	Газимурский Завод	\N	Газимуро-Заводского	ц	225574	ТГ	Пн, Вт, Ср, Чт 08.00-16.00 Пт 08.00-15.00	Сб, Вс	ЛИ-2581-17	30.12.1899	\N	82	2866
Забайкальский край	Чита	+6	Дульдурга	\N	Дульдургинского	ц	225501	\N	\N	\N	\N	\N	\N	82	\N
Забайкальский край	Чита	+6	Забайкальск	\N	Забайкальского	ц	225521	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2583-17	30.12.1899	\N	82	2871
Забайкальский край	Чита	+6	Новая Чара	\N	Каларского	ц	225504	ТГ	Пн, Вт, Ср, Чт 08-16 Пт 08-15	Сб, Вс	ЛИ-2584-17	30.12.1899	\N	82	28870
Забайкальский край	Чита	+6	Чара	\N	Каларского	\N	225504	ТГ	10-18	\N	\N	\N	\N	82	2903
Забайкальский край	Чита	+6	Калга	\N	Калганского	ц	225516	\N	\N	\N	\N	\N	\N	82	2874
Забайкальский край	Чита	+6	Карымское	\N	Карымского	ц	225524	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2875
Забайкальский край	Чита	+6	Краснокаменск	\N	Краснокаменского	ц	225520	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2585-17	30.12.1899	\N	82	2872
Забайкальский край	Чита	+6	Красный Чикой	\N	Красночикойского	ц	225512	\N	\N	\N	\N	\N	\N	82	2877
Забайкальский край	Чита	+6	Кыра	\N	Кыринского	ц	225526	ТГ	Пн, Вт, Ср, Чт 08-16 Пт 08-15	Сб, Вс	ЛИ-2586-17	30.12.1899	\N	82	2880
Забайкальский край	Чита	+6	Могойтуй	\N	Могойтуйского	ц	225501	\N	\N	\N	\N	\N	\N	82	\N
Забайкальский край	Чита	+6	Могоча	\N	Могочинского	ц	225523	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2587-17	30.12.1899	\N	82	2883
Забайкальский край	Чита	+6	Нерчинск	\N	Нерчинского	ц	225518	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2884
Забайкальский край	Чита	+6	Нерчинский Завод	\N	Нерчинско-Заводского	ц	225516	\N	\N	\N	\N	\N	\N	82	2885
Забайкальский край	Чита	+6	Оловянная	\N	Оловяннинского	ц	225511	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2889
Забайкальский край	Чита	+6	Нижний Цасучей	\N	Ононского	ц	225501	\N	08-16	Сб, Вс	ЛИ-2579-17	30.12.1899	\N	82	2886
Забайкальский край	Чита	+6	Петровск-Забайкальский	\N	Петровск-Забайкальского	ц	225512	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2588-17	30.12.1899	\N	82	2891
Забайкальский край	Чита	+6	Приаргунск	\N	Приаргунского	ц	225516	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2589-17	30.12.1899	\N	82	2892
Забайкальский край	Чита	+6	Сретенск	\N	Сретенского	ц	225513	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2590-17	30.12.1899	\N	82	\N
Забайкальский край	Чита	+6	Тупик	\N	Тунгиро-Олекминского	ц	225523	\N	\N	\N	\N	\N	\N	82	2895
Забайкальский край	Чита	+6	Верх-Усугли	\N	Тунгокоченского	ц	225581	\N	\N	\N	\N	\N	\N	82	2863
Забайкальский край	Чита	+6	Вершина Дарасуна	\N	Тунгокоченского	ц	225581	ТГ	08-16	Сб, Вс	\N	\N	\N	82	\N
Забайкальский край	Чита	+6	Улеты	\N	Улетовского	ц	225529	ТГ	Пн, Вт, Ср, Чт 08-16 Пт 08-15	Сб, Вс	ЛИ-2591-17	30.12.1899	\N	82	2896
Забайкальский край	Чита	+6	Хилок	\N	Хилокского	ц	225512	\N	\N	\N	\N	\N	\N	82	2902
Забайкальский край	Чита	+6	Чернышевск	\N	Чернышевского	ц	225515	ТГ	Пн, Вт, Ср, Чт 08-17 Пт 08-16	Сб, Вс	ЛИ-2592-17	30.12.1899	\N	82	2905
Забайкальский край	Чита	+6	Чита	Кроме Чита 47	\N	\N	225ххх	ТГ	08-21	\N	\N	\N	\N	82	4720
Забайкальский край	Чита	+6	Атамановка	\N	Читинского	\N	225587	ТГ	09-20	Вс	\N	\N	\N	82	2857
Забайкальский край	Чита	+6	Домна	\N	Читинского	\N	225588	ТГ	07-20	Вс, Пн	\N	\N	\N	82	2868
Забайкальский край	Чита	+6	Новая	\N	Читинского	\N	225589	ТГ	09-20	Вс	\N	\N	\N	82	3296
Забайкальский край	Чита	+6	Новокручининский	\N	Читинского	\N	225589	ТГ	09-20	Вс	\N	\N	\N	82	2887
Забайкальский край	Чита	+6	Шелопугино	\N	Шелопугинского	ц	225519	ТГ	Пн, Вт, Ср, Чт 08-16 Пт 08-15	Сб, Вс	ЛИ-2593-17	30.12.1899	\N	82	2906
Забайкальский край	Чита	+6	Шилка	\N	Шилкинского	ц	225514	ТГ	08-17	Сб, Вс	\N	\N	\N	82	2907
Ивановская область	Иваново	0	Бараново	\N	Верхнеландеховского	\N	227544	\N	10-16	Сб, Вс	\N	\N	\N	19	11728
Ивановская область	Иваново	0	Верхний Ландех	\N	Верхнеландеховского	ц	227544	ТГ	08-20	\N	\N	\N	\N	19	558
Ивановская область	Иваново	0	Кромы	\N	Верхнеландеховского	\N	227544	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2478-17	09.05.2017	\N	19	11808
Ивановская область	Иваново	0	Мыт	\N	Верхнеландеховского	\N	227544	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2479-17	09.05.2017	\N	19	11838
Ивановская область	Иваново	0	Симаково	\N	Верхнеландеховского	\N	227544	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2480-17	09.05.2017	\N	19	11897
Ивановская область	Иваново	0	Вичуга	\N	Вичугского	ц	227512	ТГ	08-20	\N	\N	\N	\N	19	557
Ивановская область	Иваново	0	Гаврилково	\N	Вичугского	\N	227512	\N	08-17	Вс, Пн	\N	\N	\N	19	11750
Ивановская область	Иваново	0	Золотилово	\N	Вичугского	\N	227512	\N	08-17	Вс, Пн	\N	\N	\N	19	11778
Ивановская область	Иваново	0	Каменка	\N	Вичугского	\N	227512	\N	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-2241-17	05.05.2017	\N	19	11791
Ивановская область	Иваново	0	Кирикино	\N	Вичугского	\N	227512	\N	08-17	Вс, Пн	ЛИ-2424-17	09.05.2017	\N	19	11795
Ивановская область	Иваново	0	Косачево	\N	Вичугского	\N	227512	\N	08-17	Вс, Пн	ЛИ-2242-17	05.05.2017	\N	19	11802
Ивановская область	Иваново	0	Новописцово	\N	Вичугского	\N	227512	\N	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-2243-17	05.05.2017	\N	19	11852
Ивановская область	Иваново	0	Раздолье	\N	Вичугского	\N	227512	\N	08-17	Чт, Вс	ЛИ-2244-17	05.05.2017	\N	19	\N
Ивановская область	Иваново	0	Семеновское	\N	Вичугского	\N	227512	\N	Пн, Вт, Ср, Пт, Сб 08-17	Чт, Вс	ЛИ-2425-17	09.05.2017	\N	19	11895
Ивановская область	Иваново	0	Сошники	\N	Вичугского	\N	227512	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-463-17	30.12.1899	\N	19	11904
Ивановская область	Иваново	0	Старая Вичуга	\N	Вичугского	\N	227512	\N	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-2245-17	05.05.2017	\N	19	11891
Ивановская область	Иваново	0	Чертовищи	\N	Вичугского	\N	227512	\N	08-16	Вс, Пн	ЛИ-2246-17	05.05.2017	\N	19	11926
Ивановская область	Иваново	0	Бережок	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2499-17	09.05.2017	\N	19	11731
Ивановская область	Иваново	0	Бородино	\N	Гаврилово-Посадского	\N	227524	\N	08-16	Вс, Пн	\N	\N	\N	19	11736
Ивановская область	Иваново	0	Гаврилов Посад	\N	Гаврилово-Посадского	ц	227524	ТГ	08-20	\N	\N	\N	\N	19	561
Ивановская область	Иваново	0	Загорье	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-14.30	Пн, Ср, Пт, Вс	ЛИ-2500-17	09.05.2017	\N	19	11771
Воронежская область	Воронеж	0	Вознесенка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10057
Ивановская область	Иваново	0	Иваньковский	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2501-17	09.05.2017	\N	19	11781
Ивановская область	Иваново	0	Липовая Роща	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2502-17	09.05.2017	\N	19	11815
Воронежская область	Воронеж	0	Фабрицкое	\N	Репьевского	\N	153572	\N	08-14	Вс, Пн	\N	\N	\N	16	10635
Воронежская область	Воронеж	0	Алейниково	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	9949
Воронежская область	Воронеж	0	Александровка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	9953
Воронежская область	Воронеж	0	Анцелович	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	9967
Воронежская область	Воронеж	0	Архиповка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	9970
Воронежская область	Воронеж	0	Вакуловка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	5382
Воронежская область	Воронеж	0	Голубая Криница	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10082
Воронежская область	Воронеж	0	Евстратовка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10128
Воронежская область	Воронеж	0	Екатериновка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10129
Воронежская область	Воронеж	0	Еленовка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10133
Воронежская область	Воронеж	0	Жилино	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10144
Воронежская область	Воронеж	0	Ивановка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10160
Воронежская область	Воронеж	0	Кокаревка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10195
Воронежская область	Воронеж	0	Колбинское	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10197
Воронежская область	Воронеж	0	Копанки	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10213
Воронежская область	Воронеж	0	Копенкина	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10215
Воронежская область	Воронеж	0	Кривоносово	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10243
Воронежская область	Воронеж	0	Криничное	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10246
Воронежская область	Воронеж	0	Кулаковка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10252
Воронежская область	Воронеж	0	Лебедь-Сергеевка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10262
Воронежская область	Воронеж	0	Лизиновка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10270
Воронежская область	Воронеж	0	Лощина	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10283
Воронежская область	Воронеж	0	Морозовка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10326
Воронежская область	Воронеж	0	Начало	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10333
Воронежская область	Воронеж	0	Нижний Карабут	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10345
Воронежская область	Воронеж	0	Новая Калитва	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10367
Воронежская область	Воронеж	0	Новопостояловка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10387
Воронежская область	Воронеж	0	Первомайское	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10437
Воронежская область	Воронеж	0	Подгорное	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10470
Воронежская область	Воронеж	0	Поддубное	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10471
Воронежская область	Воронеж	0	Поповка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10484
Воронежская область	Воронеж	0	Россошанский Совхоз	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10511
Воронежская область	Воронеж	0	Россошь	\N	Россошанского	ц	153513	ТГ	07-21	\N	\N	\N	\N	16	495
Воронежская область	Воронеж	0	Старая Калитва	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10569
Воронежская область	Воронеж	0	Стеценково	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10584
Воронежская область	Воронеж	0	Терновка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10601
Воронежская область	Воронеж	0	Украинский	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10627
Воронежская область	Воронеж	0	Цапково	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10646
Воронежская область	Воронеж	0	Чагары	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10648
Воронежская область	Воронеж	0	Шекаловка	\N	Россошанского	\N	153513	\N	07-20	Вс, Пн	\N	\N	\N	16	10663
Воронежская область	Воронеж	0	Шрамовка	\N	Россошанского	\N	153513	\N	08-14	Вс, Пн	\N	\N	\N	16	10669
Воронежская область	Воронеж	0	Березовка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	9981
Воронежская область	Воронеж	0	Гнилуша	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10080
Воронежская область	Воронеж	0	Голосновка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10081
Воронежская область	Воронеж	0	Гремячий Колодезь	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10090
Воронежская область	Воронеж	0	Губарево	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10094
Воронежская область	Воронеж	0	Девица	\N	Семилукского	\N	153523	\N	08-20	Вс	\N	\N	\N	16	10103
Воронежская область	Воронеж	0	Долгое	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10115
Воронежская область	Воронеж	0	Ендовище	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10139
Воронежская область	Воронеж	0	Землянск	\N	Семилукского	\N	153563	ТГ	08-16	Вс	\N	\N	\N	16	474
Воронежская область	Воронеж	0	Избище	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10163
Воронежская область	Воронеж	0	Казинка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10171
Воронежская область	Воронеж	0	Латная	\N	Семилукского	\N	153523	ТГ	08-16	Вс	\N	\N	\N	16	4736
Воронежская область	Воронеж	0	Латное	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	6019
Воронежская область	Воронеж	0	Лосево	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10280
Воронежская область	Воронеж	0	Малая Верейка	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10291
Воронежская область	Воронеж	0	Малая Покровка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10292
Воронежская область	Воронеж	0	Медвежье	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10310
Воронежская область	Воронеж	0	Меловатка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10312
Воронежская область	Воронеж	0	Нижняя Ведуга	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10350
Воронежская область	Воронеж	0	Новосильское	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10388
Воронежская область	Воронеж	0	Орлов Лог	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10413
Воронежская область	Воронеж	0	Перекоповка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10441
Воронежская область	Воронеж	0	Перлевка	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10444
Воронежская область	Воронеж	0	Раздолье	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10503
Воронежская область	Воронеж	0	Семилуки	\N	Семилукского	\N	153523	\N	07-18	\N	\N	\N	\N	16	496
Воронежская область	Воронеж	0	Серебрянка	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10545
Воронежская область	Воронеж	0	Стадница	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10566
Воронежская область	Воронеж	0	Старая Ведуга	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	10567
Воронежская область	Воронеж	0	Старая Ведуга 1	\N	Семилукского	\N	153523	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Старая Ольшанка	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10571
Воронежская область	Воронеж	0	Стрелица	\N	Семилукского	\N	153523	\N	08-20	Вс	\N	\N	\N	16	16373
Воронежская область	Воронеж	0	Троицкое	\N	Семилукского	\N	153523	\N	08-14	Вс, Пн	\N	\N	\N	16	10618
Воронежская область	Воронеж	0	40 Лет Октября Колхоз	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	9946
Воронежская область	Воронеж	0	Абрамовка Поселок	\N	Таловского	\N	153532	\N	08-20	Вс	\N	\N	\N	16	9944
Воронежская область	Воронеж	0	Абрамовка-Село	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Александровка	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	9954
Воронежская область	Воронеж	0	Анохинка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	9966
Воронежская область	Воронеж	0	Бирюч	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	9987
Воронежская область	Воронеж	0	Верхняя Тишанка	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	16354
Воронежская область	Воронеж	0	Верхняя Тишанка-1	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	16355
Воронежская область	Воронеж	0	Вознесеновка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10058
Воронежская область	Воронеж	0	Вознесенский	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10059
Воронежская область	Воронеж	0	Высокий	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10068
Воронежская область	Воронеж	0	Вязовка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10071
Воронежская область	Воронеж	0	Еланка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10130
Воронежская область	Воронеж	0	Институт Им. Докучаева	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Казанка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10169
Воронежская область	Воронеж	0	Козловский	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10194
Воронежская область	Воронеж	0	Коминтерн	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10207
Воронежская область	Воронеж	0	Комсомольский	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10210
Воронежская область	Воронеж	0	Михинский	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10320
Воронежская область	Воронеж	0	Нижняя Каменка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10351
Воронежская область	Воронеж	0	Никольское	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10361
Воронежская область	Воронеж	0	Новая Чигла	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	6343
Воронежская область	Воронеж	0	Новенький	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10371
Воронежская область	Воронеж	0	Новотроицкий	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10392
Воронежская область	Воронеж	0	Орловка-1	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Синявка	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10549
Воронежская область	Воронеж	0	Таловая	\N	Таловского	ц	153532	ТГ	07-21	\N	\N	\N	\N	16	498
Воронежская область	Воронеж	0	Терехово	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10599
Воронежская область	Воронеж	0	Утиновка	\N	Таловского	\N	153532	\N	08-14	Вс, Пн	\N	\N	\N	16	10634
Воронежская область	Воронеж	0	Шанино Второе	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10659
Воронежская область	Воронеж	0	Шанино Первое	\N	Таловского	\N	153532	\N	07-20	Вс, Пн	\N	\N	\N	16	10660
Воронежская область	Воронеж	0	Александровка	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	9955
Воронежская область	Воронеж	0	Алешки	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	9958
Воронежская область	Воронеж	0	Бабино	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	9971
Воронежская область	Воронеж	0	Братки	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10015
Воронежская область	Воронеж	0	Долина	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10117
Воронежская область	Воронеж	0	Дубровка	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10123
Воронежская область	Воронеж	0	Есипово	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10142
Воронежская область	Воронеж	0	Заречье	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10157
Воронежская область	Воронеж	0	Кисельное	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10187
Воронежская область	Воронеж	0	Козловка	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10192
Воронежская область	Воронеж	0	Костино-Отделец	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10221
Воронежская область	Воронеж	0	Липяги	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10274
Воронежская область	Воронеж	0	Луначаровка	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10286
Воронежская область	Воронеж	0	Народное	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10332
Воронежская область	Воронеж	0	Никитская	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10353
Воронежская область	Воронеж	0	Николаевка	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10356
Воронежская область	Воронеж	0	Новокирсановка	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	6341
Воронежская область	Воронеж	0	Новотроицкое	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10394
Воронежская область	Воронеж	0	Поляна	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10480
Воронежская область	Воронеж	0	Поповка	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10482
Воронежская область	Воронеж	0	Русаново	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	10521
Воронежская область	Воронеж	0	Тамбовка	\N	Терновского	\N	153533	\N	08-14	Вс, Пн	\N	\N	\N	16	10595
Воронежская область	Воронеж	0	Терновка	в зоне обслуживания Борисоглебского РУЭС	Терновского	ц	153533	ТГ	08-17	\N	\N	\N	\N	16	499
Воронежская область	Воронеж	0	Терновка 2	\N	Терновского	\N	153533	\N	07-20	Вс, Пн	\N	\N	\N	16	16375
Воронежская область	Воронеж	0	Архангельское	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	9969
Воронежская область	Воронеж	0	Борщево	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10013
Воронежская область	Воронеж	0	Верхненикольское	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10036
Воронежская область	Воронеж	0	Гремячье	\N	Хохольского	\N	153518	\N	08-20	Вс	\N	\N	\N	16	10091
Иркутская область	Иркутск	+5	Куреть	\N	Ольхонского	\N	231531	\N	09-13	Сб, Вс	\N	\N	\N	21	12055
Воронежская область	Воронеж	0	Дмитриевка	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10112
Воронежская область	Воронеж	0	Еманча Вторая	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10137
Воронежская область	Воронеж	0	Еманча Первая	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10138
Воронежская область	Воронеж	0	Ивановка	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10161
Воронежская область	Воронеж	0	Костенки	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10220
Воронежская область	Воронеж	0	Кочетовка	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10224
Воронежская область	Воронеж	0	Никольское На Еманче	\N	Хохольского	\N	153518	\N	08-14	Вс, Пн	\N	\N	\N	16	10364
Воронежская область	Воронеж	0	Новогремяченское	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10377
Воронежская область	Воронеж	0	Опытная Станция	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10412
Воронежская область	Воронеж	0	Орловка	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10414
Воронежская область	Воронеж	0	Оськино	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10424
Воронежская область	Воронеж	0	Петино	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10453
Воронежская область	Воронеж	0	Рудкино	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10518
Воронежская область	Воронеж	0	Семидесятное	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10540
Воронежская область	Воронеж	0	Староникольское	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10579
Воронежская область	Воронеж	0	Устье	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10633
Воронежская область	Воронеж	0	Хохол	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	500
Воронежская область	Воронеж	0	Хохол-1	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Хохол-2	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Хохольский	\N	Хохольского	ц	153518	ТГ	08-16 Сб 08-14	Вс	\N	\N	\N	16	16378
Воронежская область	Воронеж	0	Яблочное	\N	Хохольского	\N	153518	\N	07-20	Вс, Пн	\N	\N	\N	16	10685
Воронежская область	Воронеж	0	Александровка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	5690
Воронежская область	Воронеж	0	Битюг-Матреновка	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	ЛИ-9789-17	13.09.2017	\N	16	9988
Воронежская область	Воронеж	0	Большая Добринка	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	9999
Воронежская область	Воронеж	0	Большой Самовец	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10007
Воронежская область	Воронеж	0	Борщевские Пески	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10014
Воронежская область	Воронеж	0	Буравцовка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10020
Воронежская область	Воронеж	0	Восход	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10067
Воронежская область	Воронеж	0	Дмитриевка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	16365
Воронежская область	Воронеж	0	Колодеевка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10200
Воронежская область	Воронеж	0	Копыл	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10202
Воронежская область	Воронеж	0	Красноармейский	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10225
Воронежская область	Воронеж	0	Марьевка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10303
Воронежская область	Воронеж	0	Никольский	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10358
Воронежская область	Воронеж	0	Первомайский	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10436
Воронежская область	Воронеж	0	Перво-Эртиль	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10434
Воронежская область	Воронеж	0	Ростоши	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10515
Воронежская область	Воронеж	0	Сергеевка	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10544
Воронежская область	Воронеж	0	Старый Эртиль	\N	Эртильского	\N	153524	\N	08-14	Вс, Пн	\N	\N	\N	16	10582
Воронежская область	Воронеж	0	Щучинские Пески	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10677
Воронежская область	Воронеж	0	Щучье	\N	Эртильского	\N	153524	\N	07-20	Вс, Пн	\N	\N	\N	16	10678
Воронежская область	Воронеж	0	Эртиль	в зоне обслуживания Аннинского РУЭС	Эртильского	ц	153524	ТГ	08-18	\N	\N	\N	\N	16	501
Воронежская область	Воронеж	0	Эртиль-2	\N	Эртильского	\N	153524	\N	08-20	Вс	\N	\N	\N	16	16382
Воронежская область	Воронеж	0	Эртиль-3	\N	Эртильского	\N	153524	\N	08-20	Вс	\N	\N	\N	16	16383
Воронежская область	Воронеж	0	Данково	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10100
Воронежская область	Воронеж	0	Дзержинского	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10107
Воронежская область	Воронеж	0	Запрудское	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10156
Воронежская область	Воронеж	0	Каменно-Верховка	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10177
Воронежская область	Воронеж	0	Каширское	в зоне обслуживания Нововоронежского РУЭС	Каширского	ц	153555	ТГ	09-17	Вс	\N	\N	\N	16	478
Воронежская область	Воронеж	0	Колодезный	\N	Каширского	\N	153555	\N	08-20	Вс	\N	\N	\N	16	10203
Воронежская область	Воронеж	0	Кондрашкино	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10211
Воронежская область	Воронеж	0	Красный Лог	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10239
Воронежская область	Воронеж	0	Круглое	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10248
Воронежская область	Воронеж	0	Левая Россошь	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10265
Воронежская область	Воронеж	0	Можайское	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10322
Воронежская область	Воронеж	0	Мосальское	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10327
Воронежская область	Воронеж	0	Олень-Колодезь	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10408
Воронежская область	Воронеж	0	Солонцы	\N	Каширского	\N	153555	\N	08-14	Вс, Пн	\N	\N	\N	16	10560
Воронежская область	Воронеж	0	Старина	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10575
Воронежская область	Воронеж	0	Степной Совхоз	\N	Каширского	\N	153555	\N	07-20	Вс, Пн	\N	\N	\N	16	10583
Воронежская область	Воронеж	0	Бодеевка	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	9992
Воронежская область	Воронеж	0	Владимировка	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10053
Воронежская область	Воронеж	0	Вторая Пятилетка Совхоз	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	ЛИ-9790-17	13.09.2017	\N	16	16360
Воронежская область	Воронеж	0	Высокое	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10069
Воронежская область	Воронеж	0	Давыдовка	\N	Лискинского	\N	153512	\N	08-20	Вс	\N	\N	\N	16	10097
Воронежская область	Воронеж	0	Дивногорье	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Добрино	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10114
Воронежская область	Воронеж	0	Дракино	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10118
Воронежская область	Воронеж	0	Ермоловка	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10140
Воронежская область	Воронеж	0	Залужное	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10153
Воронежская область	Воронеж	0	Ковалево	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10189
Воронежская область	Воронеж	0	Коломыцево	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10204
Воронежская область	Воронеж	0	Колыбелка	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10206
Воронежская область	Воронеж	0	Копанище	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10212
Воронежская область	Воронеж	0	Лиски	\N	Лискинского	\N	153512	\N	08-20	\N	\N	\N	\N	16	480
Воронежская область	Воронеж	0	Лискинское	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	6201
Воронежская область	Воронеж	0	Масловка	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	10304
Воронежская область	Воронеж	0	Нижнемарьино	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10342
Воронежская область	Воронеж	0	Нижний Икорец	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10344
Воронежская область	Воронеж	0	Песковатка	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	10452
Воронежская область	Воронеж	0	Петровское	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10458
Воронежская область	Воронеж	0	Петропавловка	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10459
Воронежская область	Воронеж	0	Почепское	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10487
Воронежская область	Воронеж	0	Прияр	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	10494
Воронежская область	Воронеж	0	Пухово	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	10498
Воронежская область	Воронеж	0	Санаторий Им. Цюрупы	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Селявное	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10534
Воронежская область	Воронеж	0	Селявное-Второе	\N	Лискинского	\N	153512	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Средний Икорец	\N	Лискинского	\N	153512	\N	08-20	Вс	\N	\N	\N	16	10565
Воронежская область	Воронеж	0	Средний Икорец-1	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Старая Хворостань	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10573
Воронежская область	Воронеж	0	Сторожевое-Второе	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Тресоруково	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10612
Воронежская область	Воронеж	0	Троицкое	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10616
Воронежская область	Воронеж	0	Щучье	\N	Лискинского	\N	153512	\N	07-20	Вс, Пн	\N	\N	\N	16	10679
Воронежская область	Воронеж	0	Андреевка	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	9962
Воронежская область	Воронеж	0	Верхнее Турово	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10035
Воронежская область	Воронеж	0	Вязноватовка	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10070
Воронежская область	Воронеж	0	Глазово	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10077
Воронежская область	Воронеж	0	Дмитриевский	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10113
Воронежская область	Воронеж	0	Дружба	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10120
Воронежская область	Воронеж	0	Курбатово	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10255
Воронежская область	Воронеж	0	Кучугуровский Совхоз	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10258
Воронежская область	Воронеж	0	Кучугуры	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10259
Воронежская область	Воронеж	0	Михнево	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10321
Воронежская область	Воронеж	0	Нижнедевицк	в зоне обслуживания Хохольского РУЭС	Нижнедевицкого	ц	153535	ТГ	09-16	Вс	\N	\N	\N	16	481
Воронежская область	Воронеж	0	Нижнедевицк Вокзал	\N	Нижнедевицкого	\N	153535	\N	07-20	\N	\N	\N	\N	16	16371
Воронежская область	Воронеж	0	Нижнедевицкий Совхоз	\N	Нижнедевицкого	\N	153535	\N	07-20	\N	\N	\N	\N	16	10339
Воронежская область	Воронеж	0	Нижнее Турово	\N	Нижнедевицкого	\N	153535	\N	07-20	\N	\N	\N	\N	16	10340
Воронежская область	Воронеж	0	Нижнее Турово 1	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10341
Воронежская область	Воронеж	0	Новая Ольшанка	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10369
Воронежская область	Воронеж	0	Острянка	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10423
Воронежская область	Воронеж	0	Першино	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10445
Воронежская область	Воронеж	0	Синие Липяги	\N	Нижнедевицкого	\N	153535	\N	07-20	Вс, Пн	\N	\N	\N	16	10548
Воронежская область	Воронеж	0	Скупая Потудань	\N	Нижнедевицкого	\N	153535	\N	08-14	Вс, Пн	\N	\N	\N	16	10554
Воронежская область	Воронеж	0	Нововоронеж	\N	\N	г	153517	ТГ	07-21	\N	\N	\N	\N	16	483
Воронежская область	Воронеж	0	Бабяково	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	5386
Воронежская область	Воронеж	0	Воля	\N	Новоусманского	\N	153525	\N	08-20	Вс	\N	\N	\N	16	10063
Воронежская область	Воронеж	0	Воля-1	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	16356
Воронежская область	Воронеж	0	Воронежский Совхоз	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10065
Воронежская область	Воронеж	0	Горенские Выселки	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10085
Воронежская область	Воронеж	0	Горки	\N	Новоусманского	\N	153525	\N	08-14	Вс, Пн	\N	\N	\N	16	10086
Воронежская область	Воронеж	0	Казанская Хава	\N	Новоусманского	\N	153525	\N	08-14	Вс, Пн	\N	\N	\N	16	10170
Воронежская область	Воронеж	0	Крыловка	\N	Новоусманского	\N	153525	\N	08-14	Вс, Пн	\N	\N	\N	16	10250
Воронежская область	Воронеж	0	Макарье	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10289
Воронежская область	Воронеж	0	Масловский Совхоз	\N	Новоусманского	\N	153525	\N	08-20	Вс	\N	\N	\N	16	10305
Воронежская область	Воронеж	0	Нижняя Катуховка	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10352
Воронежская область	Воронеж	0	Новая Усмань	\N	Новоусманского	ц	153525	ТГ	09-18 Сб, Вс 08-14	\N	\N	\N	\N	16	482
Воронежская область	Воронеж	0	Новая Усмань-1	\N	Новоусманского	\N	153525	\N	08-20	Вс	\N	\N	\N	16	6347
Воронежская область	Воронеж	0	Новоусманский Совхоз	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10395
Воронежская область	Воронеж	0	Орлово	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10416
Воронежская область	Воронеж	0	Орлово-1	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Отрадное	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10425
Воронежская область	Воронеж	0	Отрадное-1	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Парусное	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10432
Воронежская область	Воронеж	0	Рогачевка	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Рогачевка-1	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10505
Воронежская область	Воронеж	0	Рождественская Хава	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	ЛИ-9792-17	13.09.2017	\N	16	\N
Воронежская область	Воронеж	0	Рыкань	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10528
Воронежская область	Воронеж	0	Трудовое	\N	Новоусманского	\N	153525	\N	08-14	Вс, Пн	\N	\N	\N	16	10621
Воронежская область	Воронеж	0	Хлебное	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10642
Воронежская область	Воронеж	0	Хреновое	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10644
Воронежская область	Воронеж	0	Шуберское	\N	Новоусманского	\N	153525	\N	07-20	Вс, Пн	\N	\N	\N	16	10670
Воронежская область	Воронеж	0	22 Партсъезда Им. Совхоз	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Алферовка	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	9960
Воронежская область	Воронеж	0	Бороздиновский	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10011
Воронежская область	Воронеж	0	Бурляевка	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Варварино	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10026
Воронежская область	Воронеж	0	Еланский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10131
Воронежская область	Воронеж	0	Елань-Колено	\N	Новохоперского	\N	153542	ТГ	09-16 Сб 09-12	Вс	\N	\N	\N	16	5158
Воронежская область	Воронеж	0	Елань-Коленовский	\N	Новохоперского	\N	153542	\N	08-20	Вс	\N	\N	\N	16	10132
Воронежская область	Воронеж	0	Елань-Коленовский Совхоз	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10125
Воронежская область	Воронеж	0	Замельничный	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	ЛИ-9791-17	13.09.2017	\N	16	10154
Воронежская область	Воронеж	0	Каменка-Садовка	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10176
Воронежская область	Воронеж	0	Красное	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10227
Воронежская область	Воронеж	0	Ленинский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10266
Воронежская область	Воронеж	0	Михайловский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10318
Воронежская область	Воронеж	0	Некрылово	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10335
Воронежская область	Воронеж	0	Новоильменский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10379
Воронежская область	Воронеж	0	Новопокровский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10386
Воронежская область	Воронеж	0	Новохоперск	в зоне обслуживания Таловского РУЭС	Новохоперского	ц	153542	ТГ	07-21	\N	\N	\N	\N	16	484
Воронежская область	Воронеж	0	Новохоперский	\N	Новохоперского	\N	153542	\N	08-20	Вс	\N	\N	\N	16	6321
Воронежская область	Воронеж	0	Подгорное	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10469
Воронежская область	Воронеж	0	Подосиновка	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10474
Воронежская область	Воронеж	0	Полежаевский	\N	Новохоперского	\N	153542	\N	08-14	Вс, Пн	\N	\N	\N	16	10476
Воронежская область	Воронеж	0	Половцево	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10477
Воронежская область	Воронеж	0	Пыховка	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10501
Воронежская область	Воронеж	0	Русаново	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10520
Воронежская область	Воронеж	0	Терновский	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10604
Воронежская область	Воронеж	0	Троицкое	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10617
Воронежская область	Воронеж	0	Троицкое-1	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Централь	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10647
Воронежская область	Воронеж	0	Ярки	\N	Новохоперского	\N	153542	\N	07-20	Вс, Пн	\N	\N	\N	16	10688
Воронежская область	Воронеж	0	Андриановка	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	9963
Воронежская область	Воронеж	0	Большие Базы	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10003
Воронежская область	Воронеж	0	Бугаевка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10018
Воронежская область	Воронеж	0	Дроздово	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10119
Воронежская область	Воронеж	0	Заболотовка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10147
Воронежская область	Воронеж	0	Караяшник	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10182
Воронежская область	Воронеж	0	Копанная-Вторая	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Костово	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10222
Воронежская область	Воронеж	0	Лимарев	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	10271
Воронежская область	Воронеж	0	Марченковка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10299
Воронежская область	Воронеж	0	Марьевка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10301
Воронежская область	Воронеж	0	Назаровка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10331
Воронежская область	Воронеж	0	Неровновка	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	10337
Воронежская область	Воронеж	0	Новокараяшник	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	10380
Воронежская область	Воронеж	0	Новохарьковка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10397
Воронежская область	Воронеж	0	Ольховатка	в зоне обслуживания Россошанского РУЭС	Ольховатского	ц	153554	ТГ	07-21	\N	\N	\N	\N	16	485
Воронежская область	Воронеж	0	Постоялый	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10486
Воронежская область	Воронеж	0	Родина Героя	\N	Ольховатского	\N	153554	\N	08-14	Вс, Пн	\N	\N	\N	16	10506
Воронежская область	Воронеж	0	Шапошниковка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10661
Воронежская область	Воронеж	0	Юрасовка	\N	Ольховатского	\N	153554	\N	07-20	Вс, Пн	\N	\N	\N	16	10684
Воронежская область	Воронеж	0	Березово	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	9984
Воронежская область	Воронеж	0	Болдыревка	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	9994
Воронежская область	Воронеж	0	Веретье	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10034
Воронежская область	Воронеж	0	Волошино	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10061
Воронежская область	Воронеж	0	Гнилое	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10079
Воронежская область	Воронеж	0	Дальняя Полубянка	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10098
Воронежская область	Воронеж	0	Девица	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10102
Воронежская область	Воронеж	0	Должик	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10116
Воронежская область	Воронеж	0	Коротояк	\N	Острогожского	\N	153541	\N	08-20	Вс	\N	\N	\N	16	10218
Воронежская область	Воронеж	0	Кривая Поляна	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10241
Воронежская область	Воронеж	0	Криница	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10245
Воронежская область	Воронеж	0	Луки	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10285
Воронежская область	Воронеж	0	Мастюгино	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10306
Воронежская область	Воронеж	0	Нижний Ольшан	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10348
Воронежская область	Воронеж	0	Новая Осиновка	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10370
Воронежская область	Воронеж	0	Новоуспенка	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10396
Воронежская область	Воронеж	0	Острогожск	\N	Острогожского	ц	153541	ТГ	08-21	\N	\N	\N	\N	16	486
Воронежская область	Воронеж	0	Острогожский Совхоз	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10422
Воронежская область	Воронеж	0	Петренково	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10454
Воронежская область	Воронеж	0	Петропавловка	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10460
Воронежская область	Воронеж	0	Русская Тростянка	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10525
Воронежская область	Воронеж	0	Рыбное	\N	Острогожского	\N	153541	\N	08-14	Вс, Пн	\N	\N	\N	16	10527
Воронежская область	Воронеж	0	Солдатское	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10557
Воронежская область	Воронеж	0	Сторожевое-Первое	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Терновое	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10603
Воронежская область	Воронеж	0	Тихая Сосна	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10607
Воронежская область	Воронеж	0	Урыв-Покровка	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Хохол-Тростянка	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Шубное	\N	Острогожского	\N	153541	\N	07-20	Вс, Пн	\N	\N	\N	16	10671
Воронежская область	Воронеж	0	Александровка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	9950
Воронежская область	Воронеж	0	Александровка-Донская	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	9956
Воронежская область	Воронеж	0	Бабка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	9972
Воронежская область	Воронеж	0	Березки	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	9977
Воронежская область	Воронеж	0	Березово	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	9982
Воронежская область	Воронеж	0	Большая Казинка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10000
Воронежская область	Воронеж	0	Воронцовка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10066
Воронежская область	Воронеж	0	Воронцовка 1	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	16358
Воронежская область	Воронеж	0	Воронцовка 2	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	16359
Воронежская область	Воронеж	0	Гаврильск	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10072
Воронежская область	Воронеж	0	Грань	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	10089
Воронежская область	Воронеж	0	Данило	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10099
Воронежская область	Воронеж	0	Елизаветовка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10135
Воронежская область	Воронеж	0	Ерышевка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10141
Воронежская область	Воронеж	0	Каменск	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	10178
Воронежская область	Воронеж	0	Ливенка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10269
Воронежская область	Воронеж	0	Лосево	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10279
Воронежская область	Воронеж	0	Лосево-1	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10281
Воронежская область	Воронеж	0	Михайловка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10315
Воронежская область	Воронеж	0	Николаевка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10354
Воронежская область	Воронеж	0	Павловск	\N	Павловского	ц	153561	ТГ	07-21	\N	\N	\N	\N	16	487
Воронежская область	Воронеж	0	Павловск 2	\N	Павловского	\N	153561	\N	08-20	Вс	\N	\N	\N	16	10427
Воронежская область	Воронеж	0	Павловск 4	\N	Павловского	\N	153561	\N	08-20	Вс	\N	\N	\N	16	6299
Воронежская область	Воронеж	0	Переездной	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	10440
Воронежская область	Воронеж	0	Пески	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	10446
Воронежская область	Воронеж	0	Петровка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10455
Воронежская область	Воронеж	0	Покровка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10475
Воронежская область	Воронеж	0	Русская Буйловка	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10522
Воронежская область	Воронеж	0	Черкасское	\N	Павловского	\N	153561	\N	08-14	Вс, Пн	\N	\N	\N	16	10649
Воронежская область	Воронеж	0	Шкурлат-Третий	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10668
Воронежская область	Воронеж	0	Шувалов	\N	Павловского	\N	153561	\N	07-20	Вс, Пн	\N	\N	\N	16	10672
Воронежская область	Воронеж	0	Александровка	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	ЛИ-9788-17	13.09.2017	\N	16	9952
Воронежская область	Воронеж	0	Алое Поле	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	9959
Воронежская область	Воронеж	0	Большие Ясырки	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10005
Воронежская область	Воронеж	0	Большой Мартын	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10006
Воронежская область	Воронеж	0	Борщево	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10012
Воронежская область	Воронеж	0	Верхняя Катуховка	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10044
Воронежская область	Воронеж	0	Дмитриевка	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10111
Воронежская область	Воронеж	0	Ивановка-Первая	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Калмычек	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10174
Воронежская область	Воронеж	0	Красное	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10228
Воронежская область	Воронеж	0	Красный Лиман	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10236
Воронежская область	Воронеж	0	Красный Лиман-Второй	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Криуша	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10247
Иркутская область	Иркутск	+5	Онгурен	\N	Ольхонского	\N	231531	\N	11-12	Вс	\N	\N	\N	21	12108
Воронежская область	Воронеж	0	Марьевка	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10302
Воронежская область	Воронеж	0	Михайловка-Вторая	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Михайловка-Первая	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Михайловский Совхоз	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10319
Воронежская область	Воронеж	0	Новохреновое	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10398
Воронежская область	Воронеж	0	Октябрьский	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10404
Воронежская область	Воронеж	0	Пады	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10430
Воронежская область	Воронеж	0	Панино	в зоне обслуживания Аннинского РУЭС	Панинского	ц	153534	ТГ	08-17	\N	\N	\N	\N	16	488
Воронежская область	Воронеж	0	Перелешино	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10442
Воронежская область	Воронеж	0	Перелешинский	\N	Панинского	\N	153534	\N	08-20	Вс	\N	\N	\N	16	10443
Воронежская область	Воронеж	0	Тойда	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10609
Воронежская область	Воронеж	0	Тойда1	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Усманские Выселки	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10630
Воронежская область	Воронеж	0	Чернавка	\N	Панинского	\N	153534	\N	07-20	Вс, Пн	\N	\N	\N	16	10651
Воронежская область	Воронеж	0	Щербачевка	\N	Панинского	\N	153534	\N	08-14	Вс, Пн	\N	\N	\N	16	10676
Воронежская область	Воронеж	0	Березняги	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	9978
Воронежская область	Воронеж	0	Бычок	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10023
Воронежская область	Воронеж	0	Глубокое	\N	Петропавловского	\N	153536	\N	08-14	Вс, Пн	\N	\N	\N	16	10078
Воронежская область	Воронеж	0	Замостье	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10155
Воронежская область	Воронеж	0	Индычий	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10166
Воронежская область	Воронеж	0	Красноселовка	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10233
Воронежская область	Воронеж	0	Краснофлотское	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10234
Воронежская область	Воронеж	0	Маяк Совхоз	\N	Петропавловского	\N	153536	\N	08-14	Вс, Пн	\N	\N	\N	16	10308
Воронежская область	Воронеж	0	Новобогородицкое	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10373
Воронежская область	Воронеж	0	Новотроицкое	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10393
Воронежская область	Воронеж	0	Новый Лиман	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10401
Воронежская область	Воронеж	0	Пески	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	\N
Воронежская область	Воронеж	0	Петропавловка	в зоне обслуживания Калачаевского РУЭС	Петропавловского	ц	153536	ТГ	07-21	\N	\N	\N	\N	16	489
Воронежская область	Воронеж	0	Старая Криуша	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10570
Воронежская область	Воронеж	0	Старокриушанский Совхоз	\N	Петропавловского	\N	153536	\N	08-14	Вс, Пн	\N	\N	\N	16	10577
Воронежская область	Воронеж	0	Старомеловая	\N	Петропавловского	\N	153536	\N	07-20	Вс, Пн	\N	\N	\N	16	10578
Воронежская область	Воронеж	0	Труд Совхоз	\N	Петропавловского	\N	153536	\N	08-14	Вс, Пн	\N	\N	\N	16	10622
Воронежская область	Воронеж	0	Фоменково	\N	Петропавловского	\N	153536	\N	08-14	Вс, Пн	\N	\N	\N	16	10639
Воронежская область	Воронеж	0	Байчурово	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	9973
Воронежская область	Воронеж	0	Вихляевка	\N	Поворинского	\N	153515	\N	07-20	Вс, Пн	\N	\N	\N	16	10050
Воронежская область	Воронеж	0	Ильмень	\N	Поворинского	\N	153515	\N	08-14	Вс, Пн	\N	\N	\N	16	10165
Воронежская область	Воронеж	0	Каменка	\N	Поворинского	\N	153515	\N	08-14	Вс, Пн	\N	\N	\N	16	10175
Иркутская область	Иркутск	+5	Первомайское	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Хадахан	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Хареты	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Целинный	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Шараты	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Бугульдейка	\N	Ольхонского	\N	231531	\N	08-13	Сб, Вс	\N	\N	\N	21	11974
Иркутская область	Иркутск	+5	Еланцы	\N	Ольхонского	ц	231531	ТГ	09-17	Вс, Пн	ЛИ-25-16	30.12.1899	\N	21	596
Иркутская область	Иркутск	+5	Ирхидей	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Майская	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Ново-Ленино	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Обуса	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Оса	\N	Осинского	ц	231551	ТГ	08-20 Сб 09-18	Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Приморский	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Унгин	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Усть-Алтан	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Хокта	\N	Осинского	\N	231551	\N	10-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Байкальск	\N	Слюдянского	\N	231536	ТГ	08-20	\N	\N	\N	\N	21	591
Иркутская область	Иркутск	+5	Слюдянка	\N	Слюдянского	ц	231542	ТГ	09-18	Сб, Вс	\N	\N	\N	21	621
Иркутская область	Иркутск	+5	Утулик	\N	Слюдянского	\N	231536	\N	09-18	Вс, Пн	\N	\N	\N	21	12178
Иркутская область	Иркутск	+5	Бирюсинск	\N	Тайшетского	\N	231521	ТГ	10-18 Сб 10-15	Вс	\N	\N	\N	21	4799
Иркутская область	Иркутск	+5	Квиток	\N	Тайшетского	\N	231521	ТГ	10-17	Сб, Вс	\N	\N	\N	21	4803
Иркутская область	Иркутск	+5	Николаевка	\N	Тайшетского	\N	231521	\N	09-18	Вс, Пн	\N	\N	\N	21	16871
Иркутская область	Иркутск	+5	Тайшет	\N	Тайшетского	ц	231521	ТГ	пн-пт 10-19	Сб, Вс	ЛИ-589-17	25.12.2017	\N	21	623
Иркутская область	Иркутск	+5	Шелехово	\N	Тайшетского	\N	231521	ТГ	10-16	Сб, Вс	\N	\N	\N	21	4814
Иркутская область	Иркутск	+5	Шиткино	\N	Тайшетского	\N	231521	ТГ	10-17	Сб, Вс	\N	\N	\N	21	4815
Иркутская область	Иркутск	+5	Юрты	\N	Тайшетского	\N	231521	ТГ	09-14	Сб, Вс	\N	\N	\N	21	30343
Иркутская область	Иркутск	+5	Алгатуй	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11933
Иркутская область	Иркутск	+5	Афанасьево	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11947
Иркутская область	Иркутск	+5	Бадар	\N	Тулунского	\N	231525	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	21	11950
Иркутская область	Иркутск	+5	Будагово	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11975
Иркутская область	Иркутск	+5	Бурхун	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11979
Иркутская область	Иркутск	+5	Владимировка	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11990
Иркутская область	Иркутск	+5	Гадалей	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11992
Иркутская область	Иркутск	+5	Гуран	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	11996
Иркутская область	Иркутск	+5	Евдокимова	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12002
Иркутская область	Иркутск	+5	Едогон	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12003
Иркутская область	Иркутск	+5	Икей	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12022
Иркутская область	Иркутск	+5	Мугун	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12083
Иркутская область	Иркутск	+5	Перфилово	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12117
Иркутская область	Иркутск	+5	Тулун	\N	Тулунского	ц	231525	ТГ	09-18 Сб 09-17	Вс	ЛИ-31-16	30.12.1899	\N	21	625
Иркутская область	Иркутск	+5	Утай	\N	Тулунского	\N	231525	\N	10-16	Вс, Пн, Вт, Чт	\N	\N	\N	21	12179
Иркутская область	Иркутск	+5	Шерагул	\N	Тулунского	\N	231525	\N	09-18	Вс, Пн	\N	\N	\N	21	12211
Иркутская область	Иркутск	+5	Белореченский	\N	Усольского	\N	231700	\N	08-20	Вс	ЛИ-67-16	30.12.1899	\N	21	593
Иркутская область	Иркутск	+5	Биликтуй	\N	Усольского	\N	231727	\N	09-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Большая Елань	\N	Усольского	\N	231727	\N	09-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Буреть	\N	Усольского	\N	231727	\N	09-18	Вс, Пн	\N	\N	\N	21	11977
Иркутская область	Иркутск	+5	Железнодорожный	\N	Усольского	\N	231700	\N	10-17	Вс, Пн	ЛИ-116-16	30.12.1899	\N	21	30342
Иркутская область	Иркутск	+5	Мальта	\N	Усольского	\N	231727	\N	09-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Мишелевка	\N	Усольского	\N	231700	\N	10-18	Вс	ЛИ-164-16	30.12.1899	\N	21	612
Иркутская область	Иркутск	+5	Новожилкино	\N	Усольского	\N	231727	\N	09-18	Вс, Пн	\N	\N	\N	21	12096
Иркутская область	Иркутск	+5	Средний	\N	Усольского	\N	231700	\N	08-20	Вс	ЛИ-227-16	30.12.1899	\N	21	12135
Иркутская область	Иркутск	+5	Тайтурка	\N	Усольского	\N	231727	\N	08-20	Вс	\N	\N	\N	21	622
Иркутская область	Иркутск	+5	Тельма	\N	Усольского	\N	231700	\N	08-20	Вс	ЛИ-568-17	25.12.2017	\N	21	12163
Иркутская область	Иркутск	+5	Усолье-Сибирское	\N	Усольского	ц	231700	ТГ	Пн-Пт 09-20 Сб 09-17	Вс	ЛИ-590-17	25.12.2017	\N	21	627
Иркутская область	Иркутск	+5	Целоты	\N	Усольского	\N	231727	\N	10-16	Пн, Ср, Пт, Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Бадарминск	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	11948
Иркутская область	Иркутск	+5	Ершово	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	11997
Иркутская область	Иркутск	+5	Железнодорожный	\N	Усть-Илимского	\N	231600	\N	09-18	Сб, Вс	ЛИ-117-16	30.12.1899	\N	21	598
Иркутская область	Иркутск	+5	Железнодорожный-1	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	12006
Иркутская область	Иркутск	+5	Невон	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	613
Иркутская область	Иркутск	+5	Подъеланка	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Тубинский	\N	Усть-Илимского	\N	231600	\N	10-17	Вс, Пн	ЛИ-571-17	25.12.2017	\N	21	624
Иркутская область	Иркутск	+5	Усть-Илимск	\N	Усть-Илимского	ц	231600	ТГ	09-19 Сб 10-16	Вс	ЛИ-32-16	30.12.1899	\N	21	628
Иркутская область	Иркутск	+5	Эдучанка	\N	Усть-Илимского	\N	231601	\N	10-17	Вс, Пн	\N	\N	\N	21	634
Иркутская область	Иркутск	+5	Усть-Кут	\N	Усть-Кутского	ц	231543	ТГ	08-16 Пт 08-10.45	Сб, Вс	\N	\N	\N	21	629
Иркутская область	Иркутск	+5	Янталь	\N	Усть-Кутского	\N	231543	ТГ	09-17	Сб, Вс	\N	\N	\N	21	5180
Иркутская область	Иркутск	+5	Игжей	\N	Усть-Удинского	\N	231528	\N	07-20	Вс, Пн	\N	\N	\N	21	12018
Иркутская область	Иркутск	+5	Малышевка	\N	Усть-Удинского	\N	231528	\N	07-20	Вс, Пн	\N	\N	\N	21	12069
Иркутская область	Иркутск	+5	Михайловщина	\N	Усть-Удинского	\N	231528	\N	09-18	Вс, Пн	\N	\N	\N	21	12079
Иркутская область	Иркутск	+5	Молька	\N	Усть-Удинского	\N	231528	\N	07-20	Вс, Пн	\N	\N	\N	21	12082
Иркутская область	Иркутск	+5	Новая Уда	\N	Усть-Удинского	\N	231528	\N	07-20	Вс, Пн	\N	\N	\N	21	12092
Иркутская область	Иркутск	+5	Усть-Уда	\N	Усть-Удинского	ц	231528	ТГ	08-17 Пт 08-15.45	Сб, Вс	ЛИ-36-16	30.12.1899	\N	21	630
Иркутская область	Иркутск	+5	Юголок	\N	Усть-Удинского	\N	231528	\N	07-20	Вс, Пн	\N	\N	\N	21	12217
Иркутская область	Иркутск	+5	Алехино	\N	Черемховского	\N	231800	\N	10-15	Сб, Вс, Вт, Чт	\N	\N	\N	21	11937
Иркутская область	Иркутск	+5	Голуметь	\N	Черемховского	\N	231800	\N	09-17	Вс, Пн	\N	\N	\N	21	16869
Иркутская область	Иркутск	+5	Лохово	\N	Черемховского	\N	231800	\N	09-18	Сб, Вс, Вт, Чт	\N	\N	\N	21	12062
Иркутская область	Иркутск	+5	Михайловка	\N	Черемховского	\N	231800	\N	09-18	Сб, Вс	\N	\N	\N	21	611
Иркутская область	Иркутск	+5	Новогромово	\N	Черемховского	\N	231800	\N	10-17	Вс, Пн	\N	\N	\N	21	12091
Иркутская область	Иркутск	+5	Парфеново	\N	Черемховского	\N	231800	\N	11-15	Сб, Вс, Вт, Чт	\N	\N	\N	21	12112
Иркутская область	Иркутск	+5	Свирск	\N	Черемховского	\N	231800	\N	09-18	Сб, Вс	\N	\N	\N	21	620
Иркутская область	Иркутск	+5	Черемхово	\N	Черемховского	ц	231800	ТГ	09-18	Сб, Вс	\N	\N	\N	21	631
Иркутская область	Иркутск	+5	Веселый	\N	Чунского	\N	231526	\N	09-16	Вс, Пн	\N	\N	\N	21	11972
Иркутская область	Иркутск	+5	Лесогорск	\N	Чунского	\N	231526	\N	09-16	Вс	\N	\N	\N	21	12057
Иркутская область	Иркутск	+5	Лесогорск 1	\N	Чунского	\N	231526	\N	09-16	Вс	\N	\N	\N	21	12054
Иркутская область	Иркутск	+5	Новочунка	\N	Чунского	\N	231526	\N	09-16	Вс, Пн	\N	\N	\N	21	12100
Иркутская область	Иркутск	+5	Октябрьский	\N	Чунского	\N	231526	\N	09-16 Сб 09-14	Вс	\N	\N	\N	21	12106
Иркутская область	Иркутск	+5	Октябрьский 1	\N	Чунского	\N	231526	\N	09-16 Сб 09-14	Вс, Ср	\N	\N	\N	21	12105
Иркутская область	Иркутск	+5	Чунский	\N	Чунского	ц	231526	ТГ	08-17 Пт 08-15.45	Сб, Вс	\N	\N	\N	21	632
Иркутская область	Иркутск	+5	Шелехов	\N	\N	г	231523	ТГ	09-18	Сб, Вс	\N	\N	\N	21	633
Иркутская область	Иркутск	+5	Баклаши	\N	Шелеховского	\N	231523	\N	09-18	Вс, Пн	\N	\N	\N	21	11951
Иркутская область	Иркутск	+5	Большой Луг	\N	Шелеховского	\N	231523	\N	08-20	Вс	\N	\N	\N	21	11970
Иркутская область	Иркутск	+5	Большой Луг-1	\N	Шелеховского	\N	231523	\N	09-18	Вс, Пн	\N	\N	\N	21	11971
Иркутская область	Иркутск	+5	Олха	\N	Шелеховского	\N	231523	\N	09-18	Вс, Пн	\N	\N	\N	21	12101
Иркутская область	Иркутск	+5	Шаманка	\N	Шелеховского	\N	231523	\N	09-18	Вс, Пн	\N	\N	\N	21	12208
Иркутская область	Иркутск	+5	Бозой	\N	Эхирит-Булагатского	\N	231544	\N	10-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Гаханы	\N	Эхирит-Булагатского	\N	231544	\N	10-17	Вс, Пн	\N	\N	\N	21	11993
Иркутская область	Иркутск	+5	Корсук	\N	Эхирит-Булагатского	\N	231544	\N	10-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Олой	\N	Эхирит-Булагатского	\N	231544	\N	10-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Усть-Ордынский	\N	Эхирит-Булагатского	ц	231544	ТГ	пн-пт 08-20 суб 10-15	вс	ЛИ-588-17	25.12.2017	\N	21	\N
Иркутская область	Иркутск	+5	Харат	\N	Эхирит-Булагатского	\N	231544	\N	07-20	Вс, Пн	\N	\N	\N	21	\N
Кабардино-Балкарская Республика	Нальчик	0	Баксан	\N	Баксанского	ц	257511	ТГ	08-17	Сб, Вс	ЛИ-4186-17	30.12.1899	\N	22	636
Кабардино-Балкарская Республика	Нальчик	0	Залукокоаже	\N	Зольского	\N	257561	ТГ	08-17	Сб, Вс	ЛИ-4021-17	30.12.1899	\N	22	12253
Кабардино-Балкарская Республика	Нальчик	0	Майский	\N	Майского	ц	257526	ТГ	08-17	Сб, Вс	ЛИ-5365-17	30.12.1899	\N	22	639
Кабардино-Балкарская Республика	Нальчик	0	Адиюх	\N	Нальчик	\N	257051	ТГ	08-20	\N	ЛИ-5858-17	14.06.2017	\N	22	\N
Кабардино-Балкарская Республика	Нальчик	0	Белая Речка	\N	Нальчик	\N	257051	ТГ	08-20	\N	ЛИ-5859-17	14.06.2017	\N	22	3181
Кабардино-Балкарская Республика	Нальчик	0	Вольный Аул	\N	Нальчик	\N	257051	ТГ	08-20	\N	ЛИ-5860-17	14.06.2017	\N	22	3175
Кабардино-Балкарская Республика	Нальчик	0	Кенже	\N	Нальчик	\N	257051	ТГ	08-20	\N	ЛИ-5861-17	14.06.2017	\N	22	4818
Кабардино-Балкарская Республика	Нальчик	0	Нальчик	\N	\N	г	257ххх	ТГ	08-20	\N	\N	\N	\N	22	635
Кабардино-Балкарская Республика	Нальчик	0	Хасанья	\N	Нальчик	\N	257051	ТГ	08-20	\N	ЛИ-5862-17	14.06.2017	\N	22	644
Кабардино-Балкарская Республика	Нальчик	0	Прохладный	\N	Прохладненского	ц	257521	ТГ	08-17	Сб, Вс	ЛИ-5559-17	30.12.1899	\N	22	641
Кабардино-Балкарская Республика	Нальчик	0	Терек	\N	Терского	ц	257551	ТГ	08-17	Сб, Вс	ЛИ-5367-17	30.12.1899	\N	22	643
Кабардино-Балкарская Республика	Нальчик	0	Нарткала	\N	Урванского	\N	257541	ТГ	Пн, Вт, Ср, Чт, Пт 08-17	Сб, Вс	ЛИ-3671-17	30.12.1899	\N	22	640
Кабардино-Балкарская Республика	Нальчик	0	Чегем	\N	Чегемского	ц	257571	ТГ	08-17	Сб, Вс	ЛИ-5366-17	30.12.1899	\N	22	647
Кабардино-Балкарская Республика	Нальчик	0	Кашхатау	\N	Черекского	ц	257514	ТГ	08-17	Сб, Вс	ЛИ-4176-17	30.12.1899	\N	22	638
Кабардино-Балкарская Республика	Нальчик	0	Тырныауз	\N	Эльбрусского	\N	257531	ТГ	08-17	Сб, Вс	ЛИ-4468-17	30.12.1899	\N	22	645
Калининградская область	Калининград	-1	Багратионовск	\N	Багратионовского	ц	262545	ТГ	10-19	Вс, Пн	ЛИ-6735-17	11.07.2017	\N	23	649
Калининградская область	Калининград	-1	Березовка	\N	Багратионовского	\N	262545	\N	11-16 Сб 10-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12338
Калининградская область	Калининград	-1	Владимирово	\N	Багратионовского	\N	262545	\N	10-18 Сб 10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12347
Калининградская область	Калининград	-1	Гвардейское	\N	Багратионовского	\N	262545	\N	10-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12351
Калининградская область	Калининград	-1	Долгоруково	\N	Багратионовского	\N	262545	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12358
Калининградская область	Калининград	-1	Корнево	в зоне обслуживания Ладушкина	Багратионовского	\N	262501	\N	10-18 Сб 10-17	Вс, Пн	ЛИ-10674-17	05.10.2017	\N	23	12386
Калининградская область	Калининград	-1	Ладушкин	\N	Багратионовского	г	262501	ТГ	10-19	Вс, Пн	ЛИ-6742-17	11.07.2017	\N	23	658
Калининградская область	Калининград	-1	Мамоново	\N	Багратионовского	г	262571	ТГ	10-19	Вс, Пн	ЛИ-6743-17	11.07.2017	\N	23	659
Калининградская область	Калининград	-1	Нивенское	\N	Багратионовского	\N	262545	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12420
Калининградская область	Калининград	-1	Партизанское	\N	Багратионовского	\N	262545	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12432
Калининградская область	Калининград	-1	Пятидорожное	в зоне обслуживания Ладушкина	Багратионовского	\N	262501	\N	08-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12448
Калининградская область	Калининград	-1	Северный	\N	Багратионовского	\N	262545	\N	10-14	Вс, Пн	\N	\N	\N	23	12442
Калининградская область	Калининград	-1	Тишино	\N	Багратионовского	\N	262545	\N	11-16 Сб 10-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12469
Калининградская область	Калининград	-1	Чехово	\N	Багратионовского	\N	262545	\N	11-16 Сб 10-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12481
Калининградская область	Калининград	-1	Южный	\N	Багратионовского	\N	262545	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12483
Калининградская область	Калининград	-1	Балтийск	\N	\N	г	262541	ТГ	Вт, Ср, Чт, Пт, Сб 10-19	Вс, Пн	ЛИ-6736-17	11.07.2017	\N	23	650
Калининградская область	Калининград	-1	Приморск	в зоне обслуживания Светлого	Балтийского	\N	262535	\N	10-18.30 Сб 10-17.30	Вс, Пн	\N	\N	\N	23	12445
Калининградская область	Калининград	-1	Борское	\N	Гвардейского	\N	262591	\N	11-16 Пт 11-17	Вт, Чт, Сб, Вс	\N	\N	\N	23	12342
Калининградская область	Калининград	-1	Гвардейск	\N	Гвардейского	ц	262591	ТГ	09-21 Сб 10-19	Вс	ЛИ-6737-17	11.07.2017	\N	23	651
Калининградская область	Калининград	-1	Заречье	\N	Гвардейского	\N	262591	\N	08-13	Пн, Ср, Пт, Вс	\N	\N	\N	23	12369
Калининградская область	Калининград	-1	Знаменск	\N	Гвардейского	\N	262591	\N	09-18	Вс, Пн	\N	\N	\N	23	657
Калининградская область	Калининград	-1	Зорино	\N	Гвардейского	\N	262591	\N	09-18	Вс, Пн	\N	\N	\N	23	12373
Калининградская область	Калининград	-1	Истровка	\N	Гвардейского	\N	262591	\N	10-16 Пт 11-15	Вт, Чт, Сб, Вс	\N	\N	\N	23	12376
Калининградская область	Калининград	-1	Комсомольск	\N	Гвардейского	\N	262591	\N	09-17	Вс, Пн	\N	\N	\N	23	12384
Калининградская область	Калининград	-1	Красный Яр	\N	Гвардейского	\N	262591	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	23	12388
Калининградская область	Калининград	-1	Малиновка	\N	Гвардейского	\N	262591	\N	10-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12406
Калининградская область	Калининград	-1	Озерки	\N	Гвардейского	\N	262591	\N	09-18	Вс, Пн	\N	\N	\N	23	12429
Калининградская область	Калининград	-1	Славинск	\N	Гвардейского	\N	262591	\N	09-18	Вс, Пн	\N	\N	\N	23	12460
Калининградская область	Калининград	-1	Талпаки	\N	Гвардейского	\N	262591	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	23	12466
Калининградская область	Калининград	-1	Большое Исаково	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12340
Калининградская область	Калининград	-1	Васильково	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12343
Калининградская область	Калининград	-1	Гурьевск	\N	Гурьевского	ц	262551	ТГ	09-21 Сб 10-19	Вс	ЛИ-6738-17	11.07.2017	\N	23	652
Калининградская область	Калининград	-1	Заречье	\N	Гурьевского	\N	262551	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	23	12370
Калининградская область	Калининград	-1	Луговое	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12398
Калининградская область	Калининград	-1	Маршальское	\N	Гурьевского	\N	262551	\N	10-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12409
Калининградская область	Калининград	-1	Моргуново	\N	Гурьевского	\N	262551	\N	09-14 Сб 10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12415
Калининградская область	Калининград	-1	Низовье	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12421
Калининградская область	Калининград	-1	Родники	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12452
Калининградская область	Калининград	-1	Сосновка	\N	Гурьевского	\N	262551	\N	11-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12463
Калининградская область	Калининград	-1	Ушаково	в зоне обслуживания Ладушкина	Гурьевского	\N	262551	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12473
Калининградская область	Калининград	-1	Храброво	\N	Гурьевского	\N	262551	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12478
Калининградская область	Калининград	-1	Гусев	\N	Гусевского	ц	262515	ТГ	09-21 Сб 10-19	Вс	ЛИ-6739-17	11.07.2017	\N	23	653
Калининградская область	Калининград	-1	Кубановка	\N	Гусевского	\N	262515	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	16550
Калининградская область	Калининград	-1	Липово	\N	Гусевского	\N	262515	\N	09.30-17.30	Вс, Вт	\N	\N	\N	23	12397
Калининградская область	Калининград	-1	Майское	\N	Гусевского	\N	262515	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12405
Калининградская область	Калининград	-1	Маяковское	\N	Гусевского	\N	262515	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12410
Калининградская область	Калининград	-1	Михайлово	\N	Гусевского	\N	262515	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12413
Калининградская область	Калининград	-1	Первомайское	\N	Гусевского	\N	262515	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12433
Калининградская область	Калининград	-1	Поддубы	\N	Гусевского	\N	262515	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12439
Калининградская область	Калининград	-1	Фурманово	\N	Гусевского	\N	262515	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12476
Калининградская область	Калининград	-1	Грачевка	\N	Зеленоградского	\N	262525	\N	09-18	Вс, Пн	\N	\N	\N	23	12353
Калининградская область	Калининград	-1	Зеленоградск	\N	Зеленоградского	ц	262525	ТГ	09-21 Сб 10-19	Вс	ЛИ-6740-17	11.07.2017	\N	23	655
Калининградская область	Калининград	-1	Коврово	\N	Зеленоградского	\N	262525	\N	09-18	Вс, Пн	\N	\N	\N	23	12383
Калининградская область	Калининград	-1	Колосовка	\N	Зеленоградского	\N	262525	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	23	12381
Калининградская область	Калининград	-1	Кострово	в зоне обслуживания Светлого	Зеленоградского	\N	262535	\N	10-16 Сб 10-15 Ср, Пт 10-18	Вс, Пн	\N	\N	\N	23	12387
Калининградская область	Калининград	-1	Красноторовка	\N	Зеленоградского	\N	262525	\N	09-17.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	12391
Калининградская область	Калининград	-1	Лесное	\N	Зеленоградского	\N	262525	\N	10-16 Сб 10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12394
Калининградская область	Калининград	-1	Мельниково	\N	Зеленоградского	\N	262525	\N	09-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12412
Калининградская область	Калининград	-1	Переславское	\N	Зеленоградского	\N	262525	\N	09-18	Вс, Пн	\N	\N	\N	23	12434
Калининградская область	Калининград	-1	Поваровка	\N	Зеленоградского	\N	262525	\N	09-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12438
Калининградская область	Калининград	-1	Романово	\N	Зеленоградского	\N	262525	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12453
Калининградская область	Калининград	-1	Рыбачий	\N	Зеленоградского	\N	262525	\N	10-19	Вс, Пн	\N	\N	\N	23	12454
Калининградская область	Калининград	-1	Холмогоровка	\N	Зеленоградского	\N	262525	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12477
Калининградская область	Калининград	-1	Калининград	\N	\N	\N	262ххх	ТГ	09-21	\N	\N	\N	\N	23	648
Калининградская область	Калининград	-1	Алексеевка	\N	Краснознаменского	\N	262594	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	23	12335
Калининградская область	Калининград	-1	Весново	\N	Краснознаменского	\N	262594	\N	10-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12344
Калининградская область	Калининград	-1	Добровольск	\N	Краснознаменского	\N	262594	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12356
Калининградская область	Калининград	-1	Краснознаменск	\N	Краснознаменского	ц	262594	ТГ	10-19	Вс, Пн	ЛИ-6741-17	11.07.2017	\N	23	656
Калининградская область	Калининград	-1	Неманское	\N	Краснознаменского	\N	262594	\N	10-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12419
Калининградская область	Калининград	-1	Победино	\N	Краснознаменского	\N	262594	\N	11-17 Сб 11-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12436
Калининградская область	Калининград	-1	Полтавское	\N	Краснознаменского	\N	262594	\N	11-17 Сб 11-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12441
Калининградская область	Калининград	-1	Тимофеево	\N	Краснознаменского	\N	262594	\N	10-15 Сб 10-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12468
Калининградская область	Калининград	-1	Большое Село	\N	Неманского	\N	262554	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12341
Калининградская область	Калининград	-1	Жилино	\N	Неманского	\N	262554	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12363
Калининградская область	Калининград	-1	Лесное	\N	Неманского	\N	262554	\N	10-15 Сб 10-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12395
Калининградская область	Калининград	-1	Лунино	\N	Неманского	\N	262554	\N	11-16 Пт 11-17	Вт, Чт, Сб, Вс	\N	\N	\N	23	12401
Калининградская область	Калининград	-1	Маломожайское	\N	Неманского	\N	262554	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12407
Калининградская область	Калининград	-1	Неман	\N	Неманского	ц	262554	ТГ	09-21 Сб 10-19	Вс	ЛИ-6744-17	11.07.2017	\N	23	660
Калининградская область	Калининград	-1	Ракитино	\N	Неманского	\N	262554	\N	10-16 Пт 10-17	Вт, Чт, Сб, Вс	\N	\N	\N	23	12449
Калининградская область	Калининград	-1	Ульяново	\N	Неманского	\N	262554	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12472
Калининградская область	Калининград	-1	Бабушкино	\N	Нестеровского	\N	262529	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12336
Калининградская область	Калининград	-1	Ильинское	\N	Нестеровского	\N	262529	\N	09-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12374
Калининградская область	Калининград	-1	Илюшино	\N	Нестеровского	\N	262529	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12375
Калининградская область	Калининград	-1	Калинино	\N	Нестеровского	\N	262529	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12377
Калининградская область	Калининград	-1	Краснолесье	\N	Нестеровского	\N	262529	\N	09-16	Пн, Ср, Пт, Вс	\N	\N	\N	23	12389
Калининградская область	Калининград	-1	Луговое	\N	Нестеровского	\N	262529	\N	10-16.30	Вт, Чт, Сб, Вс	\N	\N	\N	23	12399
Калининградская область	Калининград	-1	Нестеров	\N	Нестеровского	ц	262529	ТГ	09-21 Сб 10-19	Вс	ЛИ-6745-17	11.07.2017	\N	23	661
Калининградская область	Калининград	-1	Садовое	\N	Нестеровского	\N	262529	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12455
Калининградская область	Калининград	-1	Чернышевское	\N	Нестеровского	\N	262529	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12480
Калининградская область	Калининград	-1	Чистые Пруды	\N	Нестеровского	\N	262529	\N	10-18	Вт, Чт, Сб, Вс	\N	\N	\N	23	12482
Калининградская область	Калининград	-1	Ясная Поляна	\N	Нестеровского	\N	262529	\N	10-18 Сб 10-17	Вс, Вт	\N	\N	\N	23	12486
Калининградская область	Калининград	-1	Багратионово	\N	Озерского	\N	262584	\N	10-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12337
Калининградская область	Калининград	-1	Гаврилово	\N	Озерского	\N	262584	\N	10-16.30 Чт, Сб 10-15.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	12349
Калининградская область	Калининград	-1	Карамышево	\N	Озерского	\N	262584	\N	10-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12382
Калининградская область	Калининград	-1	Красноярское	\N	Озерского	\N	262584	\N	09.30-16.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	12392
Калининградская область	Калининград	-1	Лужки	\N	Озерского	\N	262584	\N	09.30-16 Чт, Сб 09.30-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12400
Калининградская область	Калининград	-1	Львовское	\N	Озерского	\N	262584	\N	09-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12402
Калининградская область	Калининград	-1	Мальцево	\N	Озерского	\N	262584	\N	10-16.30 Чт, Сб 10-15.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	\N
Калининградская область	Калининград	-1	Нилово	\N	Озерского	\N	262584	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	23	12422
Калининградская область	Калининград	-1	Новогурьевское	\N	Озерского	\N	262584	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	23	12425
Калининградская область	Калининград	-1	Новостроево	\N	Озерского	\N	262584	\N	10-18	Пн, Ср, Пт, Вс	\N	\N	\N	23	12428
Калининградская область	Калининград	-1	Озерск	\N	Озерского	ц	262584	ТГ	10-19	Вс, Пн	ЛИ-6746-17	11.07.2017	\N	23	662
Калининградская область	Калининград	-1	Олехово	\N	Озерского	\N	262584	\N	10-15	Пн, Ср, Пт, Вс	\N	\N	\N	23	12430
Калининградская область	Калининград	-1	Садовое	\N	Озерского	\N	262584	\N	10-16.30 Чт, Сб 10-15.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	12456
Калининградская область	Калининград	-1	Суворовка	\N	Озерского	\N	262584	\N	09-14	Пн, Ср, Пт, Вс	\N	\N	\N	23	12465
Калининградская область	Калининград	-1	Яблоновка	\N	Озерского	\N	262584	\N	10-16.30 Чт, Сб 10-15.30	Пн, Ср, Пт, Вс	\N	\N	\N	23	12485
Калининградская область	Калининград	-1	Пионерский	\N	\N	г	262581	ТГ	09-21 Сб 10-19	Вс	ЛИ-6747-17	11.07.2017	\N	23	663
Калининградская область	Калининград	-1	Головкино	\N	Полесского	\N	262561	\N	11-16 Сб 11-17	Пн, Ср, Пт, Вс	\N	\N	\N	23	12352
Калининградская область	Калининград	-1	Дальнее	\N	Полесского	\N	262561	\N	09-14 Пт 09-15	Вт, Чт, Сб, Вс	\N	\N	\N	23	12355
Калининградская область	Калининград	-1	Залесье	\N	Полесского	\N	262561	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	23	12365
Ивановская область	Иваново	0	Лобцово	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2503-17	09.05.2017	\N	19	11817
Ивановская область	Иваново	0	Лычево	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2504-17	09.05.2017	\N	19	11821
Ивановская область	Иваново	0	Мирславль	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.30-15.00	Пн, Ср, Пт, Вс	ЛИ-2505-17	09.05.2017	\N	19	11826
Ивановская область	Иваново	0	Непотягово	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2506-17	09.05.2017	\N	19	11842
Ивановская область	Иваново	0	Новоселка	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2507-17	09.05.2017	\N	19	11853
Ивановская область	Иваново	0	Осановец	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2508-17	09.05.2017	\N	19	11859
Ивановская область	Иваново	0	Петровский	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2509-17	09.05.2017	\N	19	11871
Ивановская область	Иваново	0	Ратницкое	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2510-17	09.05.2017	\N	19	11885
Ивановская область	Иваново	0	Шекшово	\N	Гаврилово-Посадского	\N	227524	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2511-17	09.05.2017	\N	19	11928
Ивановская область	Иваново	0	Воздвиженье	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2458-17	09.05.2017	\N	19	11744
Ивановская область	Иваново	0	Вьюшково	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2467-17	09.05.2017	\N	19	11749
Ивановская область	Иваново	0	Гольцовка	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2459-17	09.05.2017	\N	19	11752
Ивановская область	Иваново	0	Долматовское	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2460-17	09.05.2017	\N	19	11760
Ивановская область	Иваново	0	Есиплево	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2461-17	09.05.2017	\N	19	11767
Ивановская область	Иваново	0	Жажлево	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2462-17	09.05.2017	\N	19	11768
Ивановская область	Иваново	0	Заволжск	\N	Заволжского	ц	227533	ТГ	08-20	\N	\N	\N	\N	19	556
Ивановская область	Иваново	0	Заречный	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2463-17	09.05.2017	\N	19	11773
Ивановская область	Иваново	0	Колшево	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2464-17	09.05.2017	\N	19	11800
Ивановская область	Иваново	0	Новлянское	\N	Заволжского	\N	227533	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2465-17	09.05.2017	\N	19	11846
Ивановская область	Иваново	0	Федосцино	\N	Заволжского	\N	227533	\N	Вт, Чт, Сб 09.00-14.20	Пн, Ср, Пт, Вс	ЛИ-2466-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Иваново	\N	\N	\N	227ххх	ТГ	08-20	\N	\N	\N	\N	19	559
Ивановская область	Иваново	0	Балахонки	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2408-17	09.05.2017	\N	19	11727
Иркутская область	Иркутск	+5	Шарагай	\N	Балаганского	\N	231548	\N	09-18	Вс, Вт	\N	\N	\N	21	12209
Ивановская область	Иваново	0	Богданиха	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2410-17	09.05.2017	\N	19	11733
Ивановская область	Иваново	0	Богородское	\N	Ивановского	\N	227000	\N	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-2411-17	09.05.2017	\N	19	11734
Ивановская область	Иваново	0	Буньково	\N	Ивановского	\N	227000	\N	Вт, Чт, Сб 09-17	Пн, Ср, Пт, Вс	ЛИ-2409-17	09.05.2017	\N	19	11737
Ивановская область	Иваново	0	Ермолино	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2412-17	09.05.2017	\N	19	11766
Ивановская область	Иваново	0	Железнодорожный	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-2413-17	09.05.2017	\N	19	11769
Ивановская область	Иваново	0	Захарьино	\N	Ивановского	\N	227000	\N	Пн, Ср, Пт 08-09	Вт, Чт, Сб, Вс	ЛИ-4484-17	13.05.2017	\N	19	11776
Ивановская область	Иваново	0	Иванцево	\N	Ивановского	\N	227000	\N	Пн, Вт, Ср, Чт, Пт 09-12 Сб 09-11.30	Вс	ЛИ-2414-17	09.05.2017	\N	19	11779
Ивановская область	Иваново	0	Калачево	\N	Ивановского	\N	227000	\N	Вт, Чт, Сб 09-17	Пн, Ср, Пт, Вс	ЛИ-2415-17	09.05.2017	\N	19	11789
Ивановская область	Иваново	0	Кохма	\N	Ивановского	г	227000	\N	Пн, Вт, Ср, Чт, Пт 08.00-20.00 Сб 09.00-18.00	Вс	ЛИ-756-16	30.12.1899	\N	19	565
Ивановская область	Иваново	0	Куликово	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2416-17	09.05.2017	\N	19	11811
Ивановская область	Иваново	0	Ломы	\N	Ивановского	\N	227000	\N	Вт, Чт, Сб 08-15.30	Пн, Ср, Пт, Вс	ЛИ-2417-17	09.05.2017	\N	19	11818
Ивановская область	Иваново	0	Михалево	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2418-17	09.05.2017	\N	19	11828
Ивановская область	Иваново	0	Новоталицы	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2419-17	09.05.2017	\N	19	11847
Ивановская область	Иваново	0	Ново-Талицы 1	\N	Ивановского	\N	227000	\N	08-20	Вс	\N	\N	\N	19	11832
Ивановская область	Иваново	0	Озерное	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2420-17	09.05.2017	\N	19	11857
Ивановская область	Иваново	0	Панеево	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2421-17	09.05.2017	\N	19	11861
Ивановская область	Иваново	0	Подвязновский	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2422-17	09.05.2017	\N	19	11875
Ивановская область	Иваново	0	Стромихино	\N	Ивановского	\N	227000	\N	Пн, Ср, Пт 08-09	Вт, Чт, Сб, Вс	ЛИ-4485-17	13.05.2017	\N	19	11907
Ивановская область	Иваново	0	Чернореченский	\N	Ивановского	\N	227000	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2423-17	09.05.2017	\N	19	11924
Ивановская область	Иваново	0	Аньково	\N	Ильинского	\N	227517	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2492-17	09.05.2017	\N	19	11725
Ивановская область	Иваново	0	Гари	\N	Ильинского	\N	227517	\N	Вт, Ср, Сб 09.00-14.20	Пн, Чт, Пт, Вс	ЛИ-2493-17	09.05.2017	\N	19	11751
Ивановская область	Иваново	0	Ивашево	\N	Ильинского	\N	227517	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс,Пн	ЛИ-2494-17	09.05.2017	\N	19	11782
Ивановская область	Иваново	0	Ильинское-Хованское	\N	Ильинского	ц	227517	ТГ	08-20	\N	\N	\N	\N	19	560
Ивановская область	Иваново	0	Исаевское	\N	Ильинского	\N	227517	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2495-17	09.05.2017	\N	19	11788
Ивановская область	Иваново	0	Коварчино	\N	Ильинского	\N	227517	\N	Вт, Ср, Сб 09.30-15.00	Пн, Чт, Пт, Вс	ЛИ-2496-17	09.05.2017	\N	19	11798
Ивановская область	Иваново	0	Нажерово	\N	Ильинского	\N	227517	\N	Вт, Ср, Сб 09.00-15.30	Пн, Чт, Пт, Вс	ЛИ-2497-17	09.05.2017	\N	19	11840
Ивановская область	Иваново	0	Хлебницы	\N	Ильинского	\N	227517	\N	07-20	Вс, Пн	\N	\N	\N	19	11918
Ивановская область	Иваново	0	Щенниково	\N	Ильинского	\N	227517	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2498-17	09.05.2017	\N	19	16867
Ивановская область	Иваново	0	Батманы	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2436-17	09.05.2017	\N	19	11729
Ивановская область	Иваново	0	Вахутки	\N	Кинешемского	\N	227511	\N	08-16	Вс, Пн	\N	\N	\N	19	11742
Ивановская область	Иваново	0	Доброхотово	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт, Сб 08.30-17	Вс, Пн	ЛИ-2437-17	09.05.2017	\N	19	11759
Ивановская область	Иваново	0	Журихино	\N	Кинешемского	\N	227511	\N	Вт, Ср, Сб 09-14.20	Пн, Чт, Пт, Вс	ЛИ-2438-17	09.05.2017	\N	19	11770
Ивановская область	Иваново	0	Зобнино	\N	Кинешемского	ц	227511	\N	09-17	Вс, Пн	\N	\N	\N	19	11777
Ивановская область	Иваново	0	Ильинское	\N	Кинешемского	\N	227511	\N	Вт, Чт, Сб 09-14.20	Пн, Ср, Пт, Вс	ЛИ-2439-17	09.05.2017	\N	19	11785
Ивановская область	Иваново	0	Кинешма	\N	Кинешемского	ц	227511	ТГ	08-20	\N	\N	\N	\N	19	563
Ивановская область	Иваново	0	Красногорск	\N	Кинешемского	\N	227511	\N	Вт, Чт, Сб 09-14.20	Пн, Ср, Пт, Вс	ЛИ-2440-17	09.05.2017	\N	19	11807
Ивановская область	Иваново	0	Ласкариха	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2441-17	09.05.2017	\N	19	11813
Ивановская область	Иваново	0	Наволоки	\N	Кинешемского	\N	227511	\N	Пн, Вт, Ср, Чт, Пт 08.00-20.00 Сб 09.00-18.00	Вс	ЛИ-489-16	30.12.1899	\N	19	568
Ивановская область	Иваново	0	Первомайский	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-2442-17	09.05.2017	\N	19	11868
Ивановская область	Иваново	0	Решма	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2443-17	09.05.2017	\N	19	11886
Ивановская область	Иваново	0	Решма-1	\N	Кинешемского	\N	227511	\N	07-20	Вс, Пн	\N	\N	\N	19	11887
Ивановская область	Иваново	0	Станко	\N	Кинешемского	\N	227511	\N	Вт, Ср, Пт, Сб 08.30-15	Пн, Чт, Вс	ЛИ-2444-17	09.05.2017	\N	19	11905
Ивановская область	Иваново	0	Шилекша	\N	Кинешемского	\N	227511	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2445-17	09.05.2017	\N	19	11929
Ивановская область	Иваново	0	Бутово	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 09.00-14.30	Пн, Ср, Пт, Вс	ЛИ-2512-17	09.05.2017	\N	19	11738
Ивановская область	Иваново	0	Иваньково	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 09.00-14.20	Пн, Ср, Пт, Вс	ЛИ-2513-17	09.05.2017	\N	19	11780
Ивановская область	Иваново	0	Комсомольск	\N	Комсомольского	ц	227542	ТГ	08-20	\N	\N	\N	\N	19	564
Ивановская область	Иваново	0	Кулеберьево	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 10.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2514-17	09.05.2017	\N	19	11810
Ивановская область	Иваново	0	Марково	\N	Комсомольского	\N	227542	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2515-17	09.05.2017	\N	19	11824
Ивановская область	Иваново	0	Мытищи	\N	Комсомольского	\N	227542	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2516-17	09.05.2017	\N	19	11839
Ивановская область	Иваново	0	Никольское	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 09.00-14.30	Пн, Ср, Пт, Вс	ЛИ-2517-17	09.05.2017	\N	19	11845
Ивановская область	Иваново	0	Октябрьский	\N	Комсомольского	\N	227542	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2518-17	09.05.2017	\N	19	11858
Ивановская область	Иваново	0	Писцово	\N	Комсомольского	\N	227542	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2519-17	09.05.2017	\N	19	11872
Ивановская область	Иваново	0	Подозерский	\N	Комсомольского	\N	227542	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2520-17	09.05.2017	\N	19	11876
Ивановская область	Иваново	0	Светиково	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 09.00-15.30	Пн, Ср, Пт, Вс	ЛИ-2521-17	09.05.2017	\N	19	11892
Ивановская область	Иваново	0	Седельницы	\N	Комсомольского	\N	227542	\N	Вт, Чт, Сб 08.30-13.50	Пн, Ср, Пт, Вс	ЛИ-2522-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Воскресенское	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2427-17	09.05.2017	\N	19	11746
Ивановская область	Иваново	0	Кукарино	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2428-17	09.05.2017	\N	19	11809
Ивановская область	Иваново	0	Лежнево	\N	Лежневского	ц	227543	ТГ	08-20	\N	\N	\N	\N	19	566
Ивановская область	Иваново	0	Новые Горки	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2429-17	09.05.2017	\N	19	11854
Ивановская область	Иваново	0	Растилково-Малое	\N	Лежневского	\N	227543	\N	Вт, Чт, Сб 09-16	Пн, Ср, Пт, Вс	ЛИ-2430-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Телегино	\N	Лежневского	\N	227543	\N	Пн, Вт, Ср, Чт, Пт 09-13 Сб 09-12	Вс	ЛИ-2431-17	09.05.2017	\N	19	11910
Ивановская область	Иваново	0	Хозниково	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2432-17	09.05.2017	\N	19	11919
Ивановская область	Иваново	0	Чернцы	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2433-17	09.05.2017	\N	19	11925
Ивановская область	Иваново	0	Шилыково	\N	Лежневского	\N	227543	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2434-17	09.05.2017	\N	19	11930
Ивановская область	Иваново	0	Щапово	\N	Лежневского	\N	227543	\N	Вт, Чт, Сб 08-13.30	Пн, Ср, Пт, Вс	ЛИ-2435-17	09.05.2017	\N	19	11932
Ивановская область	Иваново	0	KOTOBO	\N	Лухского	\N	227534	\N	08.30-15.30	Вт, Чт, Сб, Вс	ЛИ-2234-17	05.05.2017	\N	19	\N
Ивановская область	Иваново	0	Благовещенье	\N	Лухского	\N	227534	\N	08-16.30	Вс, Пн	ЛИ-2235-17	05.05.2017	\N	19	11732
Ивановская область	Иваново	0	Быково	\N	Лухского	\N	227534	\N	08.30-17.30	Вс, Пн	ЛИ-2240-17	05.05.2017	\N	19	11739
Ивановская область	Иваново	0	Воскресенское Новое	\N	Лухского	\N	227534	\N	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-2426-17	09.05.2017	\N	19	11748
Ивановская область	Иваново	0	Лух	\N	Лухского	ц	227534	ТГ	08-20	\N	\N	\N	\N	19	567
Ивановская область	Иваново	0	Порзни	\N	Лухского	\N	227534	\N	08-17	Вс, Пн	ЛИ-2236-17	05.05.2017	\N	19	11880
Ивановская область	Иваново	0	Рябово	\N	Лухского	\N	227534	\N	08-17	Чт, Вс	ЛИ-2237-17	05.05.2017	\N	19	11889
Ивановская область	Иваново	0	Слободки	\N	Лухского	\N	227534	\N	08.30-17.30	Вс, Пн	ЛИ-2238-17	05.05.2017	\N	19	11899
Ивановская область	Иваново	0	Тимирязево	\N	Лухского	\N	227534	\N	08-17	Вс, Пн	ЛИ-2239-17	05.05.2017	\N	19	11912
Ивановская область	Иваново	0	Клетино	\N	Палехского	\N	227541	\N	Вт, Чт, Сб 08-13.20	Пн, Ср, Пт, Вс	ЛИ-2446-17	09.05.2017	\N	19	11796
Ивановская область	Иваново	0	Лужки	\N	Палехского	\N	227541	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2447-17	09.05.2017	\N	19	11820
Ивановская область	Иваново	0	Майдаково	\N	Палехского	\N	227541	\N	Вт, Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2448-17	09.05.2017	\N	19	11822
Ивановская область	Иваново	0	Палех	\N	Палехского	ц	227541	ТГ	08-20	\N	\N	\N	\N	19	571
Ивановская область	Иваново	0	Паново	\N	Палехского	\N	227541	\N	08-17	Вс, Пн	\N	\N	\N	19	11863
Ивановская область	Иваново	0	Пеньки	\N	Палехского	\N	227541	\N	Вт, Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2449-17	09.05.2017	\N	19	11867
Ивановская область	Иваново	0	Подолино	\N	Палехского	\N	227541	\N	08-17	Вс, Пн	\N	\N	\N	19	11877
Ивановская область	Иваново	0	Сакулино	\N	Палехского	\N	227541	\N	08-17	Вс, Пн	\N	\N	\N	19	11890
Ивановская область	Иваново	0	Тименка	\N	Палехского	\N	227541	\N	Вт, Чт, Сб 10.00-15.20	Пн, Ср, Пт, Вс	ЛИ-2450-17	09.05.2017	\N	19	11911
Ивановская область	Иваново	0	Алехино	\N	Пестяковского	\N	227535	\N	12-16	Сб, Вс	\N	\N	\N	19	11723
Ивановская область	Иваново	0	Демидово	\N	Пестяковского	\N	227535	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2481-17	09.05.2017	\N	19	11757
Ивановская область	Иваново	0	Неверово-Слобода	\N	Пестяковского	\N	227535	\N	Вт, Ср, Чт, Пт 08-17 Сб 08-16	Вс, Пн	ЛИ-2482-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Нижний Ландех	\N	Пестяковского	\N	227535	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2483-17	09.05.2017	\N	19	11844
Ивановская область	Иваново	0	Пестяки	\N	Пестяковского	ц	227535	ТГ	08-20	\N	\N	\N	\N	19	572
Ивановская область	Иваново	0	Шалаево	\N	Пестяковского	\N	227535	\N	09-16	Вт, Чт, Сб, Вс	\N	\N	\N	19	11927
Ивановская область	Иваново	0	Горки Чириковы	\N	Приволжского	\N	227525	\N	Вт, Ср, Чт, Пт, Сб 09-15	Вс, Пн	ЛИ-2530-17	09.05.2017	\N	19	11753
Ивановская область	Иваново	0	Ингарь	\N	Приволжского	\N	227525	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2531-17	09.05.2017	\N	19	11787
Ивановская область	Иваново	0	Красинское	\N	Приволжского	\N	227525	\N	Вт, Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-2532-17	09.05.2017	\N	19	11806
Ивановская область	Иваново	0	Кунестино	\N	Приволжского	\N	227525	\N	Пн, Ср, Пт 09-15	Вт, Чт, Сб, Вс	ЛИ-2533-17	09.05.2017	\N	19	11812
Ивановская область	Иваново	0	Новое	\N	Приволжского	\N	227525	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2534-17	09.05.2017	\N	19	11848
Ивановская область	Иваново	0	Плес	\N	Приволжского	\N	227525	\N	Пн, Вт, Ср, Чт, Пт 08.00-20.00 Сб 09.00-18.00	Вс	ЛИ-490-16	14.12.2016	\N	19	574
Ивановская область	Иваново	0	Приволжск	\N	Приволжского	ц	227525	ТГ	08-20	\N	\N	\N	\N	19	575
Ивановская область	Иваново	0	Рождествено	\N	Приволжского	\N	227525	\N	Пн, Ср, Чт, Пт, Сб 09-18	Вт, Вс	ЛИ-2535-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Толпыгино	\N	Приволжского	\N	227525	\N	Вт, Чт, Сб 10-16	Пн, Ср, Пт, Вс	ЛИ-2536-17	09.05.2017	\N	19	11913
Ивановская область	Иваново	0	Утес	\N	Приволжского	\N	227525	\N	Вт, Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-2537-17	09.05.2017	\N	19	11915
Ивановская область	Иваново	0	Зарайское	\N	Пучежского	\N	227513	\N	10-16	Сб, Вс	\N	\N	\N	19	11772
Ивановская область	Иваново	0	Затеиха	\N	Пучежского	\N	227513	\N	Вт, Ср, Чт, Пт 08-17 Сб 08-16	Вс, Пн	ЛИ-2474-17	09.05.2017	\N	19	11775
Ивановская область	Иваново	0	Илья Высоково	\N	Пучежского	\N	227513	\N	Вт, Ср, Чт, Пт 08-17 Сб 08-16	Вс, Пн	ЛИ-2475-17	09.05.2017	\N	19	11786
Ивановская область	Иваново	0	Кандаурово	\N	Пучежского	\N	227513	\N	10-17	Сб, Вс	\N	\N	\N	19	11793
Ивановская область	Иваново	0	Летнево	\N	Пучежского	\N	227513	\N	11-17	Сб, Вс	\N	\N	\N	19	11814
Ивановская область	Иваново	0	Лужинки	\N	Пучежского	\N	227513	\N	10-14	Сб, Вс	\N	\N	\N	19	11819
Ивановская область	Иваново	0	Мортки	\N	Пучежского	\N	227513	\N	Вт, Ср, Чт, Пт 08-17 Сб 08-16	Вс, Пн	ЛИ-2477-17	09.05.2017	\N	19	11834
Ивановская область	Иваново	0	Петрово	\N	Пучежского	\N	227513	\N	11-18	Сб, Вс	\N	\N	\N	19	11870
Ивановская область	Иваново	0	Пучеж	\N	Пучежского	ц	227513	ТГ	08-20	\N	\N	\N	\N	19	576
Ивановская область	Иваново	0	Сеготь	\N	Пучежского	\N	227513	\N	Пн, Ср, Чт, Пт 08-17 Сб 08-16	Вт, Вс	ЛИ-2476-17	09.05.2017	\N	19	11893
Ивановская область	Иваново	0	Болотново	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт 08.00-15.30	Пн, Сб, Вс	ЛИ-2398-17	09.05.2017	\N	19	11735
Ивановская область	Иваново	0	Горкино	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Сб 08-17	Пн, Пт, Вс	ЛИ-2399-17	09.05.2017	\N	19	11754
Ивановская область	Иваново	0	Каминский	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2400-17	09.05.2017	\N	19	11792
Ивановская область	Иваново	0	Малышево	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2401-17	09.05.2017	\N	19	11823
Ивановская область	Иваново	0	Острецово	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2402-17	09.05.2017	\N	19	11860
Ивановская область	Иваново	0	Парское	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2403-17	09.05.2017	\N	19	11865
Ивановская область	Иваново	0	Постинский	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2404-17	09.05.2017	\N	19	11881
Ивановская область	Иваново	0	Родники	\N	Родниковского	ц	227514	ТГ	08-20	\N	\N	\N	\N	19	577
Ивановская область	Иваново	0	Сосновец	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт 08.30-14.30	Пн, Сб, Вс	ЛИ-2405-17	09.05.2017	\N	19	11903
Ивановская область	Иваново	0	Тайманиха	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Сб 08-15.30	Пн, Пт, Вс	ЛИ-2406-17	09.05.2017	\N	19	11908
Ивановская область	Иваново	0	Филисово	\N	Родниковского	\N	227514	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2407-17	09.05.2017	\N	19	11916
Ивановская область	Иваново	0	Антилохово	\N	Савинского	\N	227515	\N	Вт 10-17 Ср, Пт 10-16	Пн, Чт, Сб, Вс	ЛИ-6165-17	06.07.2017	\N	19	11724
Ивановская область	Иваново	0	Архиповка	\N	Савинского	\N	227515	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2551-17	09.05.2017	\N	19	11726
Ивановская область	Иваново	0	Вознесенье	\N	Савинского	\N	227515	\N	07-20	Вс, Пн	\N	\N	\N	19	11745
Ивановская область	Иваново	0	Воскресенское	\N	Савинского	\N	227515	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2552-17	09.05.2017	\N	19	11747
Ивановская область	Иваново	0	Горячево	\N	Савинского	\N	227515	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2553-17	09.05.2017	\N	19	11755
Ивановская область	Иваново	0	Корзино	\N	Савинского	\N	227515	\N	09-18	Вс, Пн	\N	\N	\N	19	11801
Ивановская область	Иваново	0	Панфилово	\N	Савинского	\N	227515	\N	Вт 10-17 Ср, Пт 10-16	Пн, Чт, Сб, Вс	ЛИ-2554-17	09.05.2017	\N	19	11864
Ивановская область	Иваново	0	Покровское	\N	Савинского	\N	227515	\N	Вт 10-17 Ср, Пт 10-16	Пн, Чт, Сб, Вс	ЛИ-2555-17	09.05.2017	\N	19	11878
Ивановская область	Иваново	0	Польки	\N	Савинского	\N	227515	\N	Вт 10-17 Ср, Пт 10-16	Пн, Чт, Сб, Вс	ЛИ-2556-17	09.05.2017	\N	19	11879
Ивановская область	Иваново	0	Савино	\N	Савинского	ц	227515	ТГ	08-20	\N	\N	\N	\N	19	578
Ивановская область	Иваново	0	Крапивново	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2484-17	09.05.2017	\N	19	11805
Ивановская область	Иваново	0	Морозово	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2485-17	09.05.2017	\N	19	11833
Ивановская область	Иваново	0	Нерль	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2486-17	09.05.2017	\N	19	11843
Ивановская область	Иваново	0	Новое Горяново	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2487-17	09.05.2017	\N	19	11849
Ивановская область	Иваново	0	Новое Леушино	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2488-17	09.05.2017	\N	19	11850
Ивановская область	Иваново	0	Оболсуново	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2489-17	09.05.2017	\N	19	11856
Ивановская область	Иваново	0	Синяя Осока	\N	Тейковского	\N	227522	\N	08-15	Пн, Чт, Пт, Вс	\N	\N	\N	19	11898
Ивановская область	Иваново	0	Сокатово	\N	Тейковского	\N	227522	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2490-17	09.05.2017	\N	19	11902
Ивановская область	Иваново	0	Тейково	\N	Тейковского	ц	227522	ТГ	08-20	\N	\N	\N	\N	19	579
Ивановская область	Иваново	0	Тейково-Передвижное	\N	Тейковского	\N	227522	\N	Вт, Ср, Сб 09-17	Пн, Чт, Пт, Вс	ЛИ-2491-17	09.05.2017	\N	19	11906
Ивановская область	Иваново	0	Дуляпино	\N	Фурмановского	\N	227531	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2523-17	09.05.2017	\N	19	11763
Ивановская область	Иваново	0	Каликино	\N	Фурмановского	\N	227531	\N	Вт, Чт 09-15 Сб 09-13	Пн, Ср, Пт, Вс	ЛИ-2524-17	09.05.2017	\N	19	11790
Ивановская область	Иваново	0	Марьинское	\N	Фурмановского	\N	227531	\N	Вт, Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-2525-17	09.05.2017	\N	19	11825
Ивановская область	Иваново	0	Панино	\N	Фурмановского	\N	227531	\N	Пн, Ср, Чт, Пт, Сб 09-18	Вт, Вс	ЛИ-2526-17	09.05.2017	\N	19	11862
Ивановская область	Иваново	0	Погост	\N	Фурмановского	\N	227531	\N	Пн, Ср, Чт, Пт, Сб 09-18	Вт, Вс	ЛИ-2527-17	09.05.2017	\N	19	11874
Ивановская область	Иваново	0	Снетиново	\N	Фурмановского	\N	227531	\N	Пн, Ср, Пт 10-16	Вт, Чт, Сб, Вс	ЛИ-2528-17	09.05.2017	\N	19	11900
Ивановская область	Иваново	0	Фурманов	\N	Фурмановского	ц	227531	ТГ	08-20	\N	\N	\N	\N	19	580
Ивановская область	Иваново	0	Хромцово	\N	Фурмановского	\N	227531	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2529-17	09.05.2017	\N	19	11922
Ивановская область	Иваново	0	Васильевское	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2538-17	09.05.2017	\N	19	11741
Ивановская область	Иваново	0	Введенье	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2539-17	09.05.2017	\N	19	11743
Ивановская область	Иваново	0	Дорожаево	\N	Шуйского	\N	227521	\N	Вт 09-16 Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-2540-17	09.05.2017	\N	19	11761
Ивановская область	Иваново	0	Дунилово	\N	Шуйского	\N	227521	\N	Вт 09-18 Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2541-17	09.05.2017	\N	19	11764
Ивановская область	Иваново	0	Качалово	\N	Шуйского	\N	227521	\N	Вт 10-17 Чт, Сб 10-16	Пн, Ср, Пт, Вс	ЛИ-2542-17	09.05.2017	\N	19	11794
Ивановская область	Иваново	0	Клочково	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2543-17	09.05.2017	\N	19	11797
Ивановская область	Иваново	0	Колобово	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2544-17	09.05.2017	\N	19	11799
Ивановская область	Иваново	0	Михалево	\N	Шуйского	\N	227521	\N	Вт 10-17 Чт, Сб 10-16	Пн, Ср, Пт, Вс	ЛИ-2545-17	09.05.2017	\N	19	11830
Ивановская область	Иваново	0	Михалково	\N	Шуйского	\N	227521	\N	Вт 09-16 Чт, Сб 09-15	Пн, Ср, Пт, Вс	ЛИ-6164-17	06.07.2017	\N	19	11831
Ивановская область	Иваново	0	Перемилово	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2550-17	09.05.2017	\N	19	11869
Ивановская область	Иваново	0	Пустошь	\N	Шуйского	\N	227521	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2546-17	09.05.2017	\N	19	11883
Ивановская область	Иваново	0	Сергеево	\N	Шуйского	\N	227521	\N	Вт 09.30-16.30 Чт, Сб 09.30-15.30	Пн, Ср, Пт, Вс	ЛИ-2547-17	09.05.2017	\N	19	11896
Ивановская область	Иваново	0	Харитоново	\N	Шуйского	\N	227521	\N	Вт, Чт, Сб 08-14	Пн, Ср, Пт, Вс	ЛИ-2548-17	09.05.2017	\N	19	11917
Ивановская область	Иваново	0	Центральный	\N	Шуйского	\N	227521	\N	Вт 10-17 Чт, Сб 10-16	Пн, Ср, Пт, Вс	ЛИ-2549-17	09.05.2017	\N	19	11923
Ивановская область	Иваново	0	Шуя	\N	Шуйского	ц	227521	ТГ	08-20	\N	\N	\N	\N	19	581
Ивановская область	Иваново	0	Груздево	\N	Южского	\N	227523	\N	11-15	Вс, Пн	\N	\N	\N	19	11756
Ивановская область	Иваново	0	Изотино	\N	Южского	\N	227523	\N	12-16	Вс, Пн	\N	\N	\N	19	11784
Ивановская область	Иваново	0	Моста	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 09-18	Вс, Пн	ЛИ-2468-17	09.05.2017	\N	19	11835
Ивановская область	Иваново	0	Мугреево-Никольское	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2469-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Мугреевский	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2470-17	09.05.2017	\N	19	11837
Ивановская область	Иваново	0	Новоклязьминское	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2471-17	09.05.2017	\N	19	\N
Ивановская область	Иваново	0	Преображенское	\N	Южского	\N	227523	\N	09-18	Вс, Пн	\N	\N	\N	19	11882
Ивановская область	Иваново	0	Талицы	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2472-17	09.05.2017	\N	19	11909
Ивановская область	Иваново	0	Холуй	\N	Южского	\N	227523	\N	Вт, Ср, Чт, Пт, Сб 09-17	Вс, Пн	ЛИ-2473-17	09.05.2017	\N	19	11920
Ивановская область	Иваново	0	Хотимль	\N	Южского	\N	227523	\N	09-18	Вс, Пн	\N	\N	\N	19	11921
Ивановская область	Иваново	0	Южа	\N	Южского	ц	227523	ТГ	08-20	\N	\N	\N	\N	19	582
Ивановская область	Иваново	0	Елнать	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2451-17	09.05.2017	\N	19	11765
Ивановская область	Иваново	0	Костяево-Большое	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08.00-16.30	Вс, Пн	ЛИ-2457-17	09.05.2017	\N	19	11803
Ивановская область	Иваново	0	Лобаны	\N	Юрьевецкого	\N	227532	\N	Вт, Чт, Сб 08.00-13.20	Пн, Ср, Пт, Вс	ЛИ-2453-17	09.05.2017	\N	19	11816
Ивановская область	Иваново	0	Михайлово	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2452-17	09.05.2017	\N	19	11827
Ивановская область	Иваново	0	Обжериха	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2456-17	09.05.2017	\N	19	11855
Ивановская область	Иваново	0	Пелевино	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2455-17	09.05.2017	\N	19	11866
Ивановская область	Иваново	0	Соболево	\N	Юрьевецкого	\N	227532	\N	Вт, Ср, Чт, Пт, Сб 08-17	Вс, Пн	ЛИ-2454-17	09.05.2017	\N	19	11901
Ивановская область	Иваново	0	Юрьевец	\N	Юрьевецкого	ц	227532	ТГ	08-20	\N	\N	\N	\N	19	583
Иркутская область	Иркутск	+5	Ангарск	\N	\N	г	231445	ТГ	08-19.30	\N	\N	\N	\N	21	588
Иркутская область	Иркутск	+5	Мегет	\N	Ангарского	\N	231445	\N	09-18 Сб 09-15	Вс	\N	\N	\N	21	610
Иркутская область	Иркутск	+5	Одинск	\N	Ангарского	\N	231445	\N	09-18	Вс, Пн	\N	\N	\N	21	4807
Иркутская область	Иркутск	+5	Балаганск	\N	Балаганского	ц	231548	ТГ	08-17 Пт 08-15.45	Сб, Вс	ЛИ-45-16	30.12.1899	\N	21	592
Иркутская область	Иркутск	+5	Бирит	\N	Балаганского	\N	231548	\N	09-18	Вс, Вт	\N	\N	\N	21	11957
Иркутская область	Иркутск	+5	Заславск	\N	Балаганского	\N	231548	\N	09-18	Вс, Вт	\N	\N	\N	21	12012
Иркутская область	Иркутск	+5	Коновалово	\N	Балаганского	\N	231548	\N	09-18	Вс, Пн	\N	\N	\N	21	12043
Иркутская область	Иркутск	+5	Тарнополь	\N	Балаганского	\N	231548	\N	09-18	Вс, Пн	\N	\N	\N	21	12162
Иркутская область	Иркутск	+5	Баяндай	\N	Баяндаевского	ц	231514	ТГ	09-17 Сб 10-11	Вс, Пн	ЛИ-23-16	30.12.1899	\N	21	\N
Иркутская область	Иркутск	+5	Хогот	\N	Баяндаевского	\N	231514	\N	10-17	Вс, Пн, Ср, Пт	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Балахнинский	\N	Бодайбинского	\N	231512	\N	09-18	Вс, Пн	\N	\N	\N	21	11953
Иркутская область	Иркутск	+5	Бодайбо	\N	Бодайбинского	ц	231512	ТГ	08-16 Пт 08-15.45	Сб, Вс	\N	\N	\N	21	594
Иркутская область	Иркутск	+5	Большой Патом	\N	Бодайбинского	\N	231512	\N	09-13	Сб, Вс	\N	\N	\N	21	11966
Иркутская область	Иркутск	+5	Маракан	\N	Бодайбинского	\N	231512	\N	09-17	Вс, Пн, Ср, Пт	\N	\N	\N	21	12074
Иркутская область	Иркутск	+5	Александровское	\N	Боханского	\N	231535	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Бохан	\N	Боханского	ц	231535	ТГ	08-20	Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Буреть	\N	Боханского	\N	231535	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	21	11976
Иркутская область	Иркутск	+5	Казачье	\N	Боханского	\N	231535	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Новая Ида	\N	Боханского	\N	231535	\N	09-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Олонки	\N	Боханского	\N	231535	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Укыр	\N	Боханского	\N	231535	\N	09-17 Сб 09-16	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Александровка	\N	Братского	\N	231300	\N	10-16	Вс, Пн, Ср, Пт	\N	\N	\N	21	11934
Иркутская область	Иркутск	+5	Бада	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	11949
Иркутская область	Иркутск	+5	Бикей	\N	Братского	\N	231300	\N	10-17	Вс, Чт	\N	\N	\N	21	11959
Иркутская область	Иркутск	+5	Большеокинское	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	11967
Иркутская область	Иркутск	+5	Братск	Кроме Братск 16, 18	Братского	г	2313хх	ТГ	09-19 Сб 09-18	Вс	ЛИ-24-16	30.12.1899	\N	21	\N
Иркутская область	Иркутск	+5	Вихоревка	\N	Братского	\N	231308	\N	08-20 Сб 09-18	Вс	ЛИ-99-16	30.12.1899	\N	21	595
Иркутская область	Иркутск	+5	Дубынино	\N	Братского	\N	231300	\N	10-16	Вс, Пн, Ср, Пт	\N	\N	\N	21	12001
Иркутская область	Иркутск	+5	Зарбь	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	12010
Иркутская область	Иркутск	+5	Илир	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12024
Иркутская область	Иркутск	+5	Калтук	\N	Братского	\N	231308	\N	09-18	Вс, Пн	ЛИ-125-16	30.12.1899	\N	21	604
Иркутская область	Иркутск	+5	Кардой	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	12032
Иркутская область	Иркутск	+5	Кежемский	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12036
Иркутская область	Иркутск	+5	Ключи-Булак	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12040
Иркутская область	Иркутск	+5	Кобляково	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12041
Иркутская область	Иркутск	+5	Куватка	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12050
Иркутская область	Иркутск	+5	Кузнецовка	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12051
Иркутская область	Иркутск	+5	Кумейка	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	12052
Иркутская область	Иркутск	+5	Леонова	\N	Братского	\N	231300	\N	10-16	Вс, Пн, Ср, Пт	\N	\N	\N	21	12058
Иркутская область	Иркутск	+5	Новодолоново	\N	Братского	\N	231300	\N	10-16	Вс, Пн	\N	\N	\N	21	12095
Иркутская область	Иркутск	+5	Новое Приречье	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	12093
Иркутская область	Иркутск	+5	Озёрный	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Покосное	\N	Братского	\N	231308	\N	09-18	Вс, Пн	ЛИ-199-16	30.12.1899	\N	21	616
Иркутская область	Иркутск	+5	Порожский	\N	Братского	\N	231300	\N	10-17	Вс	\N	\N	\N	21	12123
Иркутская область	Иркутск	+5	Тангуй	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12158
Иркутская область	Иркутск	+5	Тарма	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12161
Иркутская область	Иркутск	+5	Турма	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12166
Иркутская область	Иркутск	+5	Тэмь	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12170
Иркутская область	Иркутск	+5	Харанжино	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12185
Иркутская область	Иркутск	+5	Худобок	\N	Братского	\N	231300	\N	14-17	Вс, Пн	\N	\N	\N	21	12196
Иркутская область	Иркутск	+5	Шумилово	\N	Братского	\N	231300	\N	10-17	Вс, Пн	\N	\N	\N	21	12215
Иркутская область	Иркутск	+5	Дальняя Закора	\N	Жигаловского	\N	231520	\N	10-17	Вс, Пн, Ср, Пт	\N	\N	\N	21	11998
Иркутская область	Иркутск	+5	Жигалово	\N	Жигаловского	ц	231520	ТГ	08-19	Вс	\N	\N	\N	21	600
Иркутская область	Иркутск	+5	Знаменка	\N	Жигаловского	\N	231520	\N	10-12	Сб, Вс	\N	\N	\N	21	12014
Иркутская область	Иркутск	+5	Коношаново	\N	Жигаловского	\N	231520	\N	09-17	\N	\N	\N	\N	21	12044
Иркутская область	Иркутск	+5	Лукиново	\N	Жигаловского	\N	231520	\N	10-17	Вс, Пн, Ср, Пт	\N	\N	\N	21	12063
Иркутская область	Иркутск	+5	Петрово	\N	Жигаловского	\N	231520	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	21	12118
Иркутская область	Иркутск	+5	Тимошино	\N	Жигаловского	\N	231520	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	21	12164
Иркутская область	Иркутск	+5	Тутура	\N	Жигаловского	\N	231520	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	21	12157
Иркутская область	Иркутск	+5	Усть-Илга	\N	Жигаловского	\N	231520	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	21	12177
Иркутская область	Иркутск	+5	Чикан	\N	Жигаловского	\N	231520	\N	10-17	Пн, Ср, Пт, Вс	\N	\N	\N	21	12205
Иркутская область	Иркутск	+5	Залари	\N	Заларинского	ц	231517	ТГ	08-15	Сб, Вс	\N	\N	\N	21	601
Иркутская область	Иркутск	+5	Новочеремхово	\N	Заларинского	\N	      	\N	09-16	Вс, Пн	\N	\N	\N	21	12084
Иркутская область	Иркутск	+5	Троицк	\N	Заларинского	\N	231517	\N	11-18	Вс, Пн	\N	\N	\N	21	4812
Иркутская область	Иркутск	+5	Хор-Тагна	\N	Заларинского	\N	231517	\N	13-18	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Батама	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	11955
Иркутская область	Иркутск	+5	Зима	\N	Зиминского	ц	231522	ТГ	08-17 Пт 08-15.45	Сб, Вс	ЛИ-27-16	30.12.1899	\N	21	602
Иркутская область	Иркутск	+5	Кимильтей	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12038
Иркутская область	Иркутск	+5	Масляногорск	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12076
Иркутская область	Иркутск	+5	Новолетники	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12099
Иркутская область	Иркутск	+5	Покровка	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12121
Иркутская область	Иркутск	+5	Саянск	\N	Зиминского	г	231545	ТГ	09-18	Сб, Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Ухтуй	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12181
Иркутская область	Иркутск	+5	Филипповск	\N	Зиминского	\N	231522	\N	09-18	Вс, Пн	\N	\N	\N	21	12176
Иркутская область	Иркутск	+5	Иркутск	\N	\N	г	231ххх	ТГ	пон-пт 10-18 сб 10-15	Вс	ЛИ-8299-17	25.12.2017	\N	21	587
Иркутская область	Иркутск	+5	Большая Речка	\N	Иркутского	\N	231911	\N	08-20 Сб 09-18	Вс	\N	\N	\N	21	11965
Иркутская область	Иркутск	+5	Большое Голоустное	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	11963
Иркутская область	Иркутск	+5	Горохово	\N	Иркутского	\N	231911	\N	09-18	Вс, Вт	\N	\N	\N	21	11994
Иркутская область	Иркутск	+5	Горячий Ключ	\N	Иркутского	\N	231911	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	21	11995
Иркутская область	Иркутск	+5	Дзержинск	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	ЛИ-112-16	30.12.1899	\N	21	11999
Иркутская область	Иркутск	+5	Зорино-Быково	\N	Иркутского	\N	231911	\N	09-18	Вт, Вс	\N	\N	\N	21	12016
Иркутская область	Иркутск	+5	Карлук	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	12033
Иркутская область	Иркутск	+5	Листвянка	\N	Иркутского	\N	231911	\N	08-20 Сб 09-18	Вс	\N	\N	\N	21	12060
Иркутская область	Иркутск	+5	Листвянка-1	\N	Иркутского	\N	231911	\N	08-16	Вс, Пн	\N	\N	\N	21	12061
Иркутская область	Иркутск	+5	Малое Голоустное	\N	Иркутского	\N	231911	\N	10-18 Сб 10-17	Вс, Пн	\N	\N	\N	21	12068
Иркутская область	Иркутск	+5	Мамоны	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	12072
Иркутская область	Иркутск	+5	Маркова	\N	Иркутского	\N	231911	\N	10-20 Сб 10-18	Вс	ЛИ-159-16	30.12.1899	\N	21	12075
Иркутская область	Иркутск	+5	Никольск	\N	Иркутского	\N	231911	\N	09-18	Вс, Вт	\N	\N	\N	21	12090
Иркутская область	Иркутск	+5	Оек	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	12102
Иркутская область	Иркутск	+5	Пивовариха	\N	Иркутского	\N	231911	\N	08-20 Сб 09-18	Вс	ЛИ-197-16	30.12.1899	\N	21	12119
Иркутская область	Иркутск	+5	Ревякина	\N	Иркутского	\N	231911	\N	09-18	Вт, Вс	ЛИ-208-16	30.12.1899	\N	21	12131
Иркутская область	Иркутск	+5	Смоленщина	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	12146
Иркутская область	Иркутск	+5	Сосновый Бор	\N	Иркутского	\N	231911	\N	09-18	Вс, Пн	\N	\N	\N	21	12151
Иркутская область	Иркутск	+5	Урик	\N	Иркутского	\N	231910	\N	09-18	Вс, Пн	ЛИ-578-17	25.12.2017	\N	21	12174
Иркутская область	Иркутск	+5	Хомутово	\N	Иркутского	\N	231910	\N	Пн-Сб 08-20 Сб 09-18	Вс	ЛИ-616-17	25.12.2017	\N	21	12193
Иркутская область	Иркутск	+5	Ширяева	\N	Иркутского	\N	231910	\N	Вт-Сб 09-18	Вс, Пн	ЛИ-617-17	25.12.2017	\N	21	12214
Иркутская область	Иркутск	+5	Магистральный	\N	Казачинско-Ленского	ц	231546	ТГ	09-15.33 Пт 09-15.21	Сб, Вс	\N	\N	\N	21	609
Иркутская область	Иркутск	+5	Улькан	\N	Казачинско-Ленского	\N	231546	\N	10-16	Сб, Вс	ЛИ-577-17	25.12.2017	\N	21	626
Калужская область	Калуга	0	Посконь	\N	Мосальского	\N	183516	\N	\N	Вс, Пн	\N	\N	\N	25	12846
Иркутская область	Иркутск	+5	Ербогачен	\N	Катангского	ц	231516	ТГ	09-16 Пт 08-10.45	Сб, Вс	\N	\N	\N	21	597
Иркутская область	Иркутск	+5	Анга	\N	Качугского	\N	231532	\N	09-13	Сб, Вс	\N	\N	\N	21	11942
Иркутская область	Иркутск	+5	Ацикяк	\N	Качугского	\N	231532	\N	10-16	Вс, Пн, Ср, Пт	\N	\N	\N	21	11935
Иркутская область	Иркутск	+5	Белоусово	\N	Качугского	\N	231532	\N	10-18	Вс, Пн	\N	\N	\N	21	11956
Иркутская область	Иркутск	+5	Бирюлька	\N	Качугского	\N	231532	\N	09-16	Сб, Вс	\N	\N	\N	21	11962
Иркутская область	Иркутск	+5	Бутаково	\N	Качугского	\N	231532	\N	09-12	Сб, Вс	\N	\N	\N	21	11981
Иркутская область	Иркутск	+5	Верхоленск	\N	Качугского	\N	231532	\N	09-13	Сб, Вс	\N	\N	\N	21	11986
Иркутская область	Иркутск	+5	Залог	\N	Качугского	\N	231532	\N	10-13	Вс, Пн	\N	\N	\N	21	12009
Иркутская область	Иркутск	+5	Качуг	\N	Качугского	ц	231532	ТГ	08-17	Вс	\N	\N	\N	21	605
Иркутская область	Иркутск	+5	Манзурка	\N	Качугского	\N	231532	\N	08-16	Сб, Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Никилей	\N	Качугского	\N	231532	\N	10-16	Вс, Пн	\N	\N	\N	21	12007
Иркутская область	Иркутск	+5	Харбатово	\N	Качугского	\N	231532	\N	09-13	Сб, Вс	\N	\N	\N	21	12186
Иркутская область	Иркутск	+5	Алымовка	\N	Киренского	\N	231541	\N	09-12	Сб, Вс	\N	\N	\N	21	11940
Иркутская область	Иркутск	+5	Бубновка	\N	Киренского	\N	231541	\N	09-12	Сб, Вс	\N	\N	\N	21	11973
Иркутская область	Иркутск	+5	Киренск	\N	Киренского	ц	231541	ТГ	08-11.30	Сб, Вс	\N	\N	\N	21	606
Иркутская область	Иркутск	+5	Кривая Лука	\N	Киренского	\N	231541	\N	09-12	Вс, Пн	\N	\N	\N	21	12048
Иркутская область	Иркутск	+5	Макарово	\N	Киренского	\N	231541	\N	09-15	Сб, Вс	\N	\N	\N	21	12066
Иркутская область	Иркутск	+5	Андрюшино	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	11943
Иркутская область	Иркутск	+5	Барлук	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	11954
Иркутская область	Иркутск	+5	Бурук	\N	Куйтунского	\N	231515	\N	09-17	Пн, Сб, Вс	\N	\N	\N	21	11978
Иркутская область	Иркутск	+5	Каразей	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12028
Иркутская область	Иркутск	+5	Куйтун	\N	Куйтунского	ц	231515	ТГ	08-17 Пт 08-16	Сб, Вс	\N	\N	\N	21	607
Иркутская область	Иркутск	+5	Кундуй	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12053
Иркутская область	Иркутск	+5	Лермонтовский	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12059
Иркутская область	Иркутск	+5	Уховский	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12180
Иркутская область	Иркутск	+5	Уян	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12182
Иркутская область	Иркутск	+5	Хаихта	\N	Куйтунского	\N	231515	\N	09-15	Сб, Вс, Пн	\N	\N	\N	21	12183
Иркутская область	Иркутск	+5	Чеботариха	\N	Куйтунского	\N	231515	\N	07-20	Вс, Пн	\N	\N	\N	21	12201
Иркутская область	Иркутск	+5	Мама	\N	Мамско-Чуйского	ц	231524	ТГ	08-16 Пт 08-15.45	Сб, Вс	\N	\N	\N	21	608
Иркутская область	Иркутск	+5	Березняки	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	11958
Иркутская область	Иркутск	+5	Видим	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	11988
Иркутская область	Иркутск	+5	Железногорск-Илимский	\N	Нижнеилимского	ц	231100	ТГ	08-20 Сб 08-18	Вс	\N	\N	\N	21	599
Иркутская область	Иркутск	+5	Игирма	\N	Нижнеилимского	\N	231100	\N	10-16	Вс, Пн, Ср, Пт	\N	\N	\N	21	12019
Иркутская область	Иркутск	+5	Коршуновский	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	12045
Иркутская область	Иркутск	+5	Новая Игирма 2	\N	Нижнеилимского	\N	231122	ТГ	08-19	Сб, Вс	\N	\N	\N	21	615
Иркутская область	Иркутск	+5	Новоилимск	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	12097
Иркутская область	Иркутск	+5	Рудногорск	\N	Нижнеилимского	\N	231100	\N	09-18	Вс	ЛИ-13102-17	24.01.2018	\N	21	618
Иркутская область	Иркутск	+5	Хребтовая	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	12195
Иркутская область	Иркутск	+5	Шестаково	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	12212
Иркутская область	Иркутск	+5	Янгель	\N	Нижнеилимского	\N	231100	\N	09-18	Вс, Пн	\N	\N	\N	21	30341
Иркутская область	Иркутск	+5	Алзамай	\N	Нижнеудинского	\N	231533	ТГ	09-14	Сб, Вс	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Атагай	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	542
Иркутская область	Иркутск	+5	Вершина	\N	Нижнеудинского	\N	231533	\N	10-18	Вс, Пн	\N	\N	\N	21	11987
Иркутская область	Иркутск	+5	Вознесенский	\N	Нижнеудинского	\N	231533	\N	09-17 Ср, Сб 09-13	Вс, Пн	\N	\N	\N	21	16868
Иркутская область	Иркутск	+5	Каменка	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12027
Иркутская область	Иркутск	+5	Катарбей	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12035
Иркутская область	Иркутск	+5	Нижнеудинск	\N	Нижнеудинского	ц	231533	ТГ	10.00-18.30 Сб 10.00-17.30	Вс	ЛИ-29-16	30.12.1899	\N	21	614
Иркутская область	Иркутск	+5	Порог	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12122
Иркутская область	Иркутск	+5	Ук	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12171
Иркутская область	Иркутск	+5	Худоеланское	\N	Нижнеудинского	\N	231533	\N	08-12	Сб, Вс	\N	\N	\N	21	12197
Иркутская область	Иркутск	+5	Чехово	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12204
Иркутская область	Иркутск	+5	Шеберта	\N	Нижнеудинского	\N	231533	\N	09-18	Вс, Пн	\N	\N	\N	21	12210
Иркутская область	Иркутск	+5	Алтарик	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Большебаяновская	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Закулей	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Новоленино	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Иркутская область	Иркутск	+5	Новонукутский	\N	Нукутского	ц	231518	ТГ	08-17 Пт 08-12	Сб, Вс	ЛИ-30-16	30.12.1899	\N	21	\N
Иркутская область	Иркутск	+5	Нукуты	\N	Нукутского	\N	231518	\N	08-17	Вс, Пн	\N	\N	\N	21	\N
Калужская область	Калуга	0	Ветьмица	\N	Куйбышевского	\N	183527	\N	09-16	Вс, Пн	\N	\N	\N	25	12643
Калужская область	Калуга	0	Жерелево	\N	Куйбышевского	\N	183527	\N	09-17	Вс, Пн	\N	\N	\N	25	12696
Калужская область	Калуга	0	Закрутое	\N	Куйбышевского	\N	183527	\N	09-17	Вс, Пн	\N	\N	\N	25	12700
Калужская область	Калуга	0	Зимницы	\N	Куйбышевского	\N	183527	\N	09-16	Вс, Пн	\N	\N	\N	25	12707
Калужская область	Калуга	0	Кузьминичи	\N	Куйбышевского	\N	183527	\N	09-17	Вс, Пн	\N	\N	\N	25	12752
Калужская область	Калуга	0	Мамоновка	\N	Куйбышевского	\N	183527	\N	09-16	Вс, Пн	\N	\N	\N	25	12773
Калужская область	Калуга	0	Милеево	\N	Куйбышевского	\N	183527	\N	09-16	Вс, Пн	\N	\N	\N	25	12779
Калужская область	Калуга	0	Мокрое	\N	Куйбышевского	\N	183527	\N	09-17	Вс, Пн	\N	\N	\N	25	12786
Калужская область	Калуга	0	Суборово	\N	Куйбышевского	\N	183527	\N	09-16	Вс, Пн	\N	\N	\N	25	\N
Калужская область	Калуга	0	Троицкое	\N	Куйбышевского	\N	183527	\N	09-17	Вс, Пн	\N	\N	\N	25	12906
Калужская область	Калуга	0	Букань	\N	Людиновского	\N	183524	\N	09-16	Вс, Пн	\N	\N	\N	25	12632
Калужская область	Калуга	0	Войлово	\N	Людиновского	\N	183524	\N	09-17	Вс, Пн	\N	\N	\N	25	12645
Калужская область	Калуга	0	Заболотье	\N	Людиновского	\N	183524	\N	09-17	Вс, Пн	ЛИ-9796-17	13.09.2017	\N	25	12699
Калужская область	Калуга	0	Заречный	\N	Людиновского	\N	183524	\N	09-17	Вс, Пн	\N	\N	\N	25	12701
Калужская область	Калуга	0	Игнатовка	\N	Людиновского	\N	183524	\N	09-16	Вс, Пн	\N	\N	\N	25	12709
Калужская область	Калуга	0	Колчино	\N	Людиновского	\N	183524	\N	09-16.30	Вс, Пн	\N	\N	\N	25	12732
Калужская область	Калуга	0	Космачево	\N	Людиновского	\N	183524	\N	09-16	Вс, Пн	\N	\N	\N	25	12738
Калужская область	Калуга	0	Людиново	\N	Людиновского	ц	183524	ТГ	08-19 Вс 10-17 Сб 08-17	\N	ЛИ-7318-17	13.07.2017	\N	25	699
Калужская область	Калуга	0	Манино	\N	Людиновского	\N	183524	\N	07-20	Вс, Пн	\N	\N	\N	25	12774
Калужская область	Калуга	0	Алешково	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12595
Калужская область	Калуга	0	Березовка	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12612
Калужская область	Калуга	0	Головтеево	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12667
Калужская область	Калуга	0	Детчено	\N	Малоярославецкого	\N	183512	\N	08-20 Сб, Вс 09-15	\N	\N	\N	\N	25	12678
Калужская область	Калуга	0	Дубровка	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пт	\N	\N	\N	25	12684
Калужская область	Калуга	0	Ерденево	\N	Малоярославецкого	\N	183512	\N	09-17	Вс, Пн	\N	\N	\N	25	12690
Калужская область	Калуга	0	Захарово	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12703
Калужская область	Калуга	0	Игнатьевское	\N	Малоярославецкого	\N	183512	\N	09-16	Вс, Пн	\N	\N	\N	25	12711
Калужская область	Калуга	0	Ильинское	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12713
Калужская область	Калуга	0	Коллонтай	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12729
Калужская область	Калуга	0	Кудиново	\N	Малоярославецкого	\N	183512	\N	08-20 Сб, Вс 09-15	\N	\N	\N	\N	25	12749
Калужская область	Калуга	0	Маклино	\N	Малоярославецкого	\N	183512	\N	08-20	\N	\N	\N	\N	25	12768
Калужская область	Калуга	0	Максимовка	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12770
Калужская область	Калуга	0	Малоярославец	\N	Малоярославецкого	ц	183512	ТГ	08-19 Вс 09-14 Сб 08-17	\N	ЛИ-7319-17	13.07.2017	\N	25	700
Калужская область	Калуга	0	Митинка	\N	Малоярославецкого	\N	183512	\N	10-14	Вс, Пн	\N	\N	\N	25	12782
Калужская область	Калуга	0	Недельное	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12795
Калужская область	Калуга	0	Оболенское	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12808
Калужская область	Калуга	0	Прудки	\N	Малоярославецкого	\N	183512	\N	09-17	Вс, Пн	\N	\N	\N	25	12847
Калужская область	Калуга	0	Рябцево	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12863
Калужская область	Калуга	0	Торбеево	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12904
Калужская область	Калуга	0	Шумятино	\N	Малоярославецкого	\N	183512	\N	10-15	Вс, Пн	\N	\N	\N	25	12937
Калужская область	Калуга	0	Юбилейный	\N	Малоярославецкого	\N	183512	\N	07-20	Вс, Пн	\N	\N	\N	25	12940
Калужская область	Калуга	0	Адуево	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12591
Калужская область	Калуга	0	Брюхово	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12629
Калужская область	Калуга	0	Варваровка	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12636
Калужская область	Калуга	0	Глухово	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12665
Калужская область	Калуга	0	Гусево	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12674
Калужская область	Калуга	0	Каляево	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12717
Калужская область	Калуга	0	Кременское	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12745
Калужская область	Калуга	0	Медынь	\N	Медынского	ц	183531	ТГ	09-16 Сб 09-13	Вс, Пн	ЛИ-7320-17	13.07.2017	\N	25	701
Калужская область	Калуга	0	Михеево	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12785
Калужская область	Калуга	0	Никитское	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12802
Калужская область	Калуга	0	Передел	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12823
Калужская область	Калуга	0	Радюкино	\N	Медынского	\N	183531	\N	07-20	Вс, Пн	\N	\N	\N	25	12854
Калужская область	Калуга	0	Романово	\N	Медынского	\N	183531	\N	09-17	Вс, Пн	\N	\N	\N	25	12858
Калужская область	Калуга	0	Большое Алешино	\N	Мещовского	\N	183533	\N	09-17	Пн, Пт, Вс	\N	\N	\N	25	12619
Калужская область	Калуга	0	Гаврики	\N	Мещовского	\N	183533	\N	10-14	Пн, Чт, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Картышово	\N	Мещовского	\N	183533	\N	07-20	Вс, Пн,	\N	\N	\N	25	\N
Калужская область	Калуга	0	Карцево	\N	Мещовского	\N	183533	\N	12-16	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Клетино	\N	Мещовского	\N	183533	\N	11-14	Пн, Чт, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Кудринская	\N	Мещовского	\N	183533	\N	07-20	Вс, Пн	\N	\N	\N	25	\N
Калужская область	Калуга	0	Лесной	\N	Мещовского	\N	183533	\N	11-17	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Мармыжи	\N	Мещовского	\N	183533	\N	12-16	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Мещовск	\N	Мещовского	ц	183533	ТГ	09-18 Сб 09-13	Вс, Пн	ЛИ-7321-17	13.07.2017	\N	25	702
Калужская область	Калуга	0	Молодежный	\N	Мещовского	\N	183533	\N	11-17	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Мошонки	\N	Мещовского	\N	183533	\N	12-16	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Нестеровка	\N	Мещовского	\N	183533	\N	11-16	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Подкопаево	\N	Мещовского	\N	183533	\N	10-14	Пн, Чт, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Покров	\N	Мещовского	\N	183533	\N	09-17	Вс, Пн	\N	\N	\N	25	\N
Калужская область	Калуга	0	Серпейск	\N	Мещовского	\N	183533	\N	07-20	Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Терпилово	\N	Мещовского	\N	183533	\N	11-17	Пн, Чт, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Торкотино	\N	Мещовского	\N	183533	\N	11-17	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Калужская область	Калуга	0	Боровенск	\N	Мосальского	\N	183516	\N	09-16	Пн, Ср, Вс	\N	\N	\N	25	12622
Калужская область	Калуга	0	Воронино	\N	Мосальского	\N	183516	\N	09-16	Вс, Пн	\N	\N	\N	25	12651
Калужская область	Калуга	0	Горбачи	\N	Мосальского	\N	183516	\N	\N	Вс, Пн	\N	\N	\N	25	12668
Калужская область	Калуга	0	Дашино	\N	Мосальского	\N	183516	\N	\N	Вс, Пн	\N	\N	\N	25	12676
Калужская область	Калуга	0	Долгое	\N	Мосальского	\N	183516	\N	09-16	Вс, Пн	\N	\N	\N	25	12681
Калужская область	Калуга	0	Калуговский	\N	Мосальского	\N	183516	\N	10-15	Пн, Ср, Вс	\N	\N	\N	25	12716
Калужская область	Калуга	0	Людково	\N	Мосальского	\N	183516	\N	09-16	Вс, Пн	\N	\N	\N	25	12766
Калужская область	Калуга	0	Мосальск	\N	Мосальского	ц	183516	ТГ	09-16 Сб 09-13	Вс, Пн	ЛИ-7322-17	13.07.2017	\N	25	703
Калужская область	Калуга	0	Никиткино	\N	Мосальского	\N	183516	\N	\N	Вс, Пн	\N	\N	\N	25	12801
Калужская область	Калуга	0	Путогино	\N	Мосальского	\N	183516	\N	\N	Вс, Пн	\N	\N	\N	25	12848
Калужская область	Калуга	0	Раменский	\N	Мосальского	\N	183516	\N	09-16	Вс, Пн	\N	\N	\N	25	12855
Калужская область	Калуга	0	Шаховский	\N	Мосальского	\N	183516	\N	09-16	Вс, Пн	\N	\N	\N	25	12933
Калужская область	Калуга	0	Обнинск	\N	\N	г	183542	ТГ	06-20 Вс 10-17	\N	ЛИ-7323-17	13.07.2017	\N	25	704
Калужская область	Калуга	0	Ахлебинино	\N	Перемышльского	\N	183517	\N	07-20	Вс, Пн	ЛИ-9795-17	13.09.2017	\N	25	12602
Калужская область	Калуга	0	Большие Козлы	\N	Перемышльского	\N	183517	\N	07-20	Вс, Пн	\N	\N	\N	25	12617
Калужская область	Калуга	0	Борищево	\N	Перемышльского	\N	183517	\N	11-15	Вс, Пн	\N	\N	\N	25	12621
Калужская область	Калуга	0	Василенки	\N	Перемышльского	\N	183517	\N	10-15	Вс, Сб	\N	\N	\N	25	12637
Калужская область	Калуга	0	Головнино	\N	Перемышльского	\N	183517	\N	11-15	Пн, Ср, Пт, Вс	\N	\N	\N	25	\N
Камчатский край	Петропавловск-Камчатский	+9	Вывенка	\N	Олюторского	\N	244518	\N	10-13.30	Сб, Вс	ЛИ-377-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Пахачи	\N	Олюторского	\N	244518	\N	Пн, Вт, Ср, Чт, Пт 10-13.30	Сб, Вс	ЛИ-1712-18	11.12.2018	\N	26	33387
Камчатский край	Петропавловск-Камчатский	+9	Средние Пахачи	\N	Олюторского	\N	244518	\N	10-13.30	Сб, Вс	ЛИ-379-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Тиличики	\N	Олюторского	ц	244518	ТГ	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1721-18	11.12.2018	\N	26	33390
Камчатский край	Петропавловск-Камчатский	+9	Аянка	\N	Пенжинского	\N	244514	\N	Вт, Ср, Чт, Пт 12.30-15.30 Пн 12-15.30	Сб, Вс	ЛИ-1684-18	11.12.2018	\N	26	33379
Камчатский край	Петропавловск-Камчатский	+9	Каменское	\N	Пенжинского	ц	244514	ТГ	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-1695-18	11.12.2018	\N	26	33382
Камчатский край	Петропавловск-Камчатский	+9	Манилы	\N	Пенжинского	\N	244514	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-382-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Петропавловск-Камчатский	\N	\N	\N	244ХХХ	ТГ	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-1713-18	11.12.2018	\N	26	724
Камчатский край	Петропавловск-Камчатский	+9	Крутогоровский	\N	Соболевского	\N	244513	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1701-18	11.12.2018	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Соболево	\N	Соболевского	ц	244513	ТГ	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1717-18	11.12.2018	\N	26	720
Камчатский край	Петропавловск-Камчатский	+9	Устьевое	\N	Соболевского	\N	244513	\N	Пн, Вт, Ср, Чт 09-16.15 Пт 09-16	Сб, Вс	ЛИ-1725-18	11.12.2018	\N	26	5220
Камчатский край	Петропавловск-Камчатский	+9	Воямполка	\N	Тигильского	\N	244521	\N	11-15.30	Сб, Вс	ЛИ-386-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Ковран	\N	Тигильского	\N	244510	\N	10-16	Сб, Вс	\N	\N	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Лесная	\N	Тигильского	\N	244521	\N	11-15.30	Сб, Вс	ЛИ-387-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Палана	\N	Тигильского	\N	244521	ТГ	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-1711-18	11.12.2018	\N	26	33386
Камчатский край	Петропавловск-Камчатский	+9	Седанка	\N	Тигильского	\N	244510	\N	Вт, Ср, Чт, Пт, Сб 10-16.40	Вс, Пн	ЛИ-1716-18	11.12.2018	\N	26	33388
Камчатский край	Петропавловск-Камчатский	+9	Тигиль	\N	Тигильского	ц	244510	ТГ	Пн, Вт, Ср, Чт, Пт 08-20 Сб 09-18	Вс	ЛИ-1720-18	11.12.2018	\N	26	33389
Камчатский край	Петропавловск-Камчатский	+9	Усть-Хайрюзово	\N	Тигильского	\N	244510	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-401-17	30.12.1899	\N	26	\N
Камчатский край	Петропавловск-Камчатский	+9	Хайрюзово	\N	Тигильского	\N	244510	\N	Пн, Вт, Ср, Чт, Пт 11-15.30	Сб, Вс	ЛИ-1726-18	11.12.2018	\N	26	33392
Камчатский край	Петропавловск-Камчатский	+9	Апача	\N	Усть-Большерецкого	\N	244516	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1681-18	11.12.2018	\N	26	6608
Камчатский край	Петропавловск-Камчатский	+9	Запорожье	\N	Усть-Большерецкого	\N	244526	\N	Вт, Ср, Чт, Пт 09-13 Сб 12-13	Вс, Пн	ЛИ-1691-18	11.12.2018	\N	26	4823
Камчатский край	Петропавловск-Камчатский	+9	Кавалерское	\N	Усть-Большерецкого	\N	244516	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1694-18	11.12.2018	\N	26	12903
Камчатский край	Петропавловск-Камчатский	+9	Озерновский	\N	Усть-Большерецкого	\N	244526	\N	09-16	Сб, Вс	ЛИ-7825-17	19.07.2017	\N	26	4834
Камчатский край	Петропавловск-Камчатский	+9	Октябрьский	\N	Усть-Большерецкого	\N	244516	\N	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1709-18	11.12.2018	\N	26	4805
Камчатский край	Петропавловск-Камчатский	+9	Усть-Большерецк	\N	Усть-Большерецкого	ц	244516	ТГ	Вт, Ср, Чт, Пт 09-17 Сб 09-16	Вс, Пн	ЛИ-1723-18	11.12.2018	\N	26	721
Калужская область	Калуга	0	Петрищев