--
-- PostgreSQL database dump
--

-- Dumped from database version 15.3 (Ubuntu 15.3-1.pgdg22.04+1)
-- Dumped by pg_dump version 15.2

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--DROP DATABASE IF EXISTS coretlx;
--
-- Name: coretlx; Type: DATABASE; Schema: -; Owner: coretlx
--

--CREATE DATABASE coretlx WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE_PROVIDER = libc LOCALE = 'C.UTF-8';


--ALTER DATABASE coretlx OWNER TO coretlx;

\connect coretlx

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: coretlx; Type: SCHEMA; Schema: -; Owner: coretlx
--

CREATE SCHEMA coretlx;


ALTER SCHEMA coretlx OWNER TO coretlx;

--
-- Name: clientcat_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.clientcat_list AS (
	clientcat_list bigint[]
);


ALTER TYPE coretlx.clientcat_list OWNER TO coretlx;

--
-- Name: index_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.index_list AS (
	index_list bigint[]
);


ALTER TYPE coretlx.index_list OWNER TO coretlx;

--
-- Name: release_list; Type: TYPE; Schema: coretlx; Owner: coretlx
--

CREATE TYPE coretlx.release_list AS (
	release_list timestamp(0) without time zone[]
);


ALTER TYPE coretlx.release_list OWNER TO coretlx;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: acc_advice_timeout; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_advice_timeout (
    advice_timeout_id bigint NOT NULL,
    advice_id bigint,
    notified timestamp(0) without time zone,
    changed timestamp(0) without time zone
);


ALTER TABLE coretlx.acc_advice_timeout OWNER TO coretlx;

--
-- Name: COLUMN acc_advice_timeout.advice_timeout_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.advice_timeout_id IS 'Id события';


--
-- Name: COLUMN acc_advice_timeout.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.advice_id IS 'ID уведомления';


--
-- Name: COLUMN acc_advice_timeout.notified; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.notified IS 'Когда было отправлено извещение';


--
-- Name: COLUMN acc_advice_timeout.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.acc_advice_timeout.changed IS 'Когда было изменение';


--
-- Name: acc_advice_timeout_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_advice_timeout_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.acc_advice_timeout_seq OWNER TO coretlx;

--
-- Name: acc_change; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_change (
    change_id integer NOT NULL,
    level_id integer NOT NULL,
    key_table character varying(100),
    key_value integer,
    ref_table character varying(100),
    ref_value integer,
    terminal integer,
    created timestamp(0) without time zone
);


ALTER TABLE coretlx.acc_change OWNER TO coretlx;

--
-- Name: acc_change_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_change_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.acc_change_seq OWNER TO coretlx;

--
-- Name: acc_changes; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_changes (
    change_id bigint NOT NULL,
    op_code character(1) NOT NULL,
    key_table character varying(400),
    ref_table character varying(400),
    key_name character varying(400),
    ref_name character varying(400),
    key_id bigint,
    ref_id bigint,
    changed timestamp(0) without time zone,
    terminal character varying(400),
    session_id character varying(96)
);


ALTER TABLE coretlx.acc_changes OWNER TO coretlx;

--
-- Name: acc_error; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_error (
    error_id integer NOT NULL,
    code_id integer NOT NULL,
    error_msg character varying(200),
    terminal character varying(800),
    created timestamp(0) without time zone,
    call_from character varying(1000)
);


ALTER TABLE coretlx.acc_error OWNER TO coretlx;

--
-- Name: acc_error_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_error_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.acc_error_seq OWNER TO coretlx;

--
-- Name: acc_errors; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_errors (
    error_id integer NOT NULL,
    code integer,
    msg character varying(200),
    terminal character varying(200),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL
);


ALTER TABLE coretlx.acc_errors OWNER TO coretlx;

--
-- Name: acc_errors_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_errors_seq
    START WITH 7374
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.acc_errors_seq OWNER TO coretlx;

--
-- Name: acc_level; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_level (
    level_id integer NOT NULL,
    level_name character varying(100),
    object_name character varying(100)
);


ALTER TABLE coretlx.acc_level OWNER TO coretlx;

--
-- Name: acc_module_login; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_module_login (
    module_login_id bigint NOT NULL,
    module_id bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    v_major bigint,
    v_minor bigint,
    v_release bigint,
    v_build bigint,
    terminal character varying(80),
    u_session_id character varying(24)
);


ALTER TABLE coretlx.acc_module_login OWNER TO coretlx;

--
-- Name: acc_module_login_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_module_login_seq
    START WITH 44709
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.acc_module_login_seq OWNER TO coretlx;

--
-- Name: acc_operator; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_operator (
    operator_id bigint NOT NULL,
    name character varying(200),
    created timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    external_id bigint,
    login character varying(50),
    password character varying(50),
    place_id bigint,
    place_num character varying(20),
    parent_id bigint,
    user_role smallint NOT NULL
);


ALTER TABLE coretlx.acc_operator OWNER TO coretlx;

--
-- Name: acc_operator_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_operator_seq
    START WITH 559
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.acc_operator_seq OWNER TO coretlx;

--
-- Name: acc_user_login; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.acc_user_login (
    user_login_id bigint NOT NULL,
    session_id bigint,
    operator_id bigint,
    module_id bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    terminal character varying(80),
    extension bigint,
    u_session_id character varying(24),
    module_login_id bigint,
    place_id bigint,
    place_num character varying(20),
    user_role smallint
);


ALTER TABLE coretlx.acc_user_login OWNER TO coretlx;

--
-- Name: acc_user_login_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.acc_user_login_seq
    START WITH 43552
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.acc_user_login_seq OWNER TO coretlx;

--
-- Name: bill_abocharge_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_abocharge_seq
    START WITH 483332
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_abocharge_seq OWNER TO coretlx;

--
-- Name: bill_abocharges; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_abocharges (
    abocharge_id bigint NOT NULL,
    cost numeric(15,2) DEFAULT 0 NOT NULL,
    extracost numeric(15,2) DEFAULT 0 NOT NULL,
    ndscost numeric(15,2) DEFAULT 0 NOT NULL,
    note character varying(200),
    message_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    operator_id bigint,
    terminal character varying(80) NOT NULL,
    charge_state_id smallint NOT NULL,
    our_cost numeric(15,2) DEFAULT 0 NOT NULL,
    tarif_id bigint,
    account_no numeric(20,0),
    bill_contract numeric(20,0),
    our_nds numeric(15,2) DEFAULT 0 NOT NULL,
    call_id bigint,
    chgtype_id smallint
);


ALTER TABLE coretlx.bill_abocharges OWNER TO coretlx;

--
-- Name: COLUMN bill_abocharges.abocharge_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.abocharge_id IS 'Идентификатор начисления';


--
-- Name: COLUMN bill_abocharges.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.cost IS 'Сумма по тарифу';


--
-- Name: COLUMN bill_abocharges.extracost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.extracost IS 'Сумма сбора';


--
-- Name: COLUMN bill_abocharges.ndscost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.ndscost IS 'НДС';


--
-- Name: COLUMN bill_abocharges.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.note IS 'Примечание';


--
-- Name: COLUMN bill_abocharges.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN bill_abocharges.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_abocharges.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.operator_id IS 'Идентификатор оператора создавшего начисление';


--
-- Name: COLUMN bill_abocharges.terminal; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.terminal IS 'Терминал пользователя';


--
-- Name: COLUMN bill_abocharges.charge_state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.charge_state_id IS 'Идентификатор состояния начисления';


--
-- Name: COLUMN bill_abocharges.our_cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.our_cost IS 'Сумма в пользу оператора связи';


--
-- Name: COLUMN bill_abocharges.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_abocharges.account_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.account_no IS 'Идентификатор абонента';


--
-- Name: COLUMN bill_abocharges.bill_contract; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.bill_contract IS 'Идентификатор договора';


--
-- Name: COLUMN bill_abocharges.our_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.our_nds IS 'НДС на сумму в пользу оператора связи';


--
-- Name: COLUMN bill_abocharges.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN bill_abocharges.chgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_abocharges.chgtype_id IS 'Тип начисления';


--
-- Name: bill_charge_detail; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_charge_detail (
    message_id bigint,
    abocharge_id bigint,
    f_substract smallint DEFAULT 0 NOT NULL,
    cost numeric(15,2),
    billing_code bigint,
    price_id bigint,
    operator_id bigint,
    f_canceled smallint DEFAULT 0
);


ALTER TABLE coretlx.bill_charge_detail OWNER TO coretlx;

--
-- Name: COLUMN bill_charge_detail.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN bill_charge_detail.abocharge_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.abocharge_id IS 'Идентификатор начисления';


--
-- Name: COLUMN bill_charge_detail.f_substract; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.f_substract IS 'Признак вычитания';


--
-- Name: COLUMN bill_charge_detail.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.cost IS 'Сумма по тарифу';


--
-- Name: COLUMN bill_charge_detail.billing_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.billing_code IS 'Идентификатор начисления по классификатору';


--
-- Name: COLUMN bill_charge_detail.price_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.price_id IS 'Идентификатор цены в системе';


--
-- Name: COLUMN bill_charge_detail.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_charge_detail.operator_id IS 'Идентификатор оператора, внесшего начисление';


--
-- Name: bill_discount; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_discount (
    discount_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    discount numeric(5,2) DEFAULT 0 NOT NULL,
    period_id bigint,
    tarif_id bigint,
    clientcategory_id smallint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    note character varying(200),
    operator_id bigint,
    oper_id bigint
);


ALTER TABLE coretlx.bill_discount OWNER TO coretlx;

--
-- Name: bill_discount_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_discount_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_discount_seq OWNER TO coretlx;

--
-- Name: bill_pay_phone; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_pay_phone (
    pay_phone_id bigint NOT NULL,
    aon_phone character varying(20) NOT NULL,
    abonent_phone character varying(20) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    note character varying(200),
    operator_id bigint
);


ALTER TABLE coretlx.bill_pay_phone OWNER TO coretlx;

--
-- Name: COLUMN bill_pay_phone.pay_phone_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.pay_phone_id IS 'Идентификатор соответствия телефонов';


--
-- Name: COLUMN bill_pay_phone.aon_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.aon_phone IS 'Телефон АОН';


--
-- Name: COLUMN bill_pay_phone.abonent_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.abonent_phone IS 'Телефон оплаты';


--
-- Name: COLUMN bill_pay_phone.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_pay_phone.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_pay_phone.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_pay_phone.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.note IS 'Примечание';


--
-- Name: COLUMN bill_pay_phone.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_pay_phone.operator_id IS 'Идентификатор оператора сделавшего последнюю модификацию';


--
-- Name: bill_pay_phone_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_pay_phone_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_pay_phone_seq OWNER TO coretlx;

--
-- Name: bill_price; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_price (
    price_id bigint NOT NULL,
    const numeric(10,2) DEFAULT 0 NOT NULL,
    mult numeric(10,2) DEFAULT 0 NOT NULL,
    extra smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    min_units integer DEFAULT 0 NOT NULL,
    max_units integer DEFAULT 999999 NOT NULL,
    svckind_id bigint,
    period_id bigint,
    clientcategory_id smallint,
    min_msg integer DEFAULT 1 NOT NULL,
    max_msg integer DEFAULT 1 NOT NULL,
    service_id bigint,
    tarif_id bigint,
    changed timestamp(0) without time zone,
    note character varying(100),
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    charge smallint DEFAULT 0 NOT NULL,
    by_release smallint DEFAULT 0 NOT NULL,
    operator_id bigint,
    region_id bigint,
    receive_id bigint,
    billing_code bigint,
    dest_location_id bigint,
    is_exclude_dest smallint DEFAULT 0,
    CONSTRAINT bill_price_chk1 CHECK ((min_units <= max_units))
);


ALTER TABLE coretlx.bill_price OWNER TO coretlx;

--
-- Name: COLUMN bill_price.price_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.price_id IS 'Идентификатор цены';


--
-- Name: COLUMN bill_price.const; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.const IS 'Константа';


--
-- Name: COLUMN bill_price.mult; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.mult IS 'Множитель';


--
-- Name: COLUMN bill_price.extra; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.extra IS 'Флаг сбора (=1)';


--
-- Name: COLUMN bill_price.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_price.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_price.min_units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.min_units IS 'Минимальное число тарификационных единиц';


--
-- Name: COLUMN bill_price.max_units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.max_units IS 'Максимальное число тарификационных единиц';


--
-- Name: COLUMN bill_price.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.svckind_id IS 'Идентификатор вида';


--
-- Name: COLUMN bill_price.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.period_id IS 'Идентификатор периода';


--
-- Name: COLUMN bill_price.clientcategory_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.clientcategory_id IS 'Идентификатор категории абонента';


--
-- Name: COLUMN bill_price.min_msg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.min_msg IS 'Минимальное число сообщений';


--
-- Name: COLUMN bill_price.max_msg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.max_msg IS 'Максимальное число сообщений';


--
-- Name: COLUMN bill_price.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN bill_price.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_price.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_price.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.note IS 'Примечание';


--
-- Name: COLUMN bill_price.opened; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.opened IS 'Дата/время начала действия';


--
-- Name: COLUMN bill_price.charge; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.charge IS 'Признак начисения без учета кол-ва сообщений';


--
-- Name: COLUMN bill_price.by_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.by_release IS 'Проводить расчет по дате выхода объявления (если = 0 расчет производится по дате подачи)';


--
-- Name: COLUMN bill_price.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.operator_id IS 'Идентификатор оператора в последний раз изменившего цену';


--
-- Name: COLUMN bill_price.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.region_id IS 'Идентификатор региона откуда поступил вызов';


--
-- Name: COLUMN bill_price.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.receive_id IS 'Идентификатор места приема (телефон/почта)';


--
-- Name: COLUMN bill_price.billing_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.billing_code IS 'Идентификатор начисления в тарификаторе';


--
-- Name: COLUMN bill_price.dest_location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.dest_location_id IS 'Идентификатор региона куда направлено сообщение';


--
-- Name: COLUMN bill_price.is_exclude_dest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_price.is_exclude_dest IS 'Если = 1, то применять тариф для сообщений, отправленных за пределы указанного региона';


--
-- Name: bill_price_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_price_seq
    START WITH 7468
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_price_seq OWNER TO coretlx;

--
-- Name: bill_service; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_service (
    service_id bigint NOT NULL,
    name character varying(100),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    tarif_id bigint NOT NULL,
    changed timestamp(0) without time zone,
    start_label character varying(100),
    end_label character varying(100),
    operator_id bigint
);


ALTER TABLE coretlx.bill_service OWNER TO coretlx;

--
-- Name: COLUMN bill_service.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN bill_service.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.name IS 'Наименование услуги';


--
-- Name: COLUMN bill_service.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_service.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_service.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_service.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_service.start_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.start_label IS 'Начальная отметка в сообщении';


--
-- Name: COLUMN bill_service.end_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.end_label IS 'Конечная отметка в сообщении';


--
-- Name: COLUMN bill_service.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service.operator_id IS 'Идентификатор оператора в последний раз изменившего услугу';


--
-- Name: bill_service_kind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_service_kind (
    svckind_id bigint NOT NULL,
    service_id bigint NOT NULL
);


ALTER TABLE coretlx.bill_service_kind OWNER TO coretlx;

--
-- Name: COLUMN bill_service_kind.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service_kind.svckind_id IS 'Идентификатор вида услуги';


--
-- Name: COLUMN bill_service_kind.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_service_kind.service_id IS 'Идентификатор услуги';


--
-- Name: bill_service_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_service_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_service_seq OWNER TO coretlx;

--
-- Name: bill_service_seq; Type: SEQUENCE OWNED BY; Schema: coretlx; Owner: coretlx
--

ALTER SEQUENCE coretlx.bill_service_seq OWNED BY coretlx.bill_service.service_id;


--
-- Name: bill_svckind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_svckind (
    svckind_id bigint NOT NULL,
    tarif_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    p1 character varying(1) DEFAULT ' '::character varying NOT NULL,
    p2 character varying(1) DEFAULT ' '::character varying NOT NULL,
    p3 character varying(1) DEFAULT ' '::character varying NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    start_label character varying(50),
    end_label character varying(50),
    f_serve smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    operator_id bigint,
    f_notification smallint DEFAULT 0 NOT NULL,
    f_printcopy smallint DEFAULT 0 NOT NULL,
    f_needrequest smallint DEFAULT 0 NOT NULL,
    f_needtg smallint DEFAULT 0 NOT NULL,
    tlgkind_id bigint
);


ALTER TABLE coretlx.bill_svckind OWNER TO coretlx;

--
-- Name: COLUMN bill_svckind.svckind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.svckind_id IS 'Идентификатор вида услуги';


--
-- Name: COLUMN bill_svckind.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_svckind.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.name IS 'Наименование вида услуги';


--
-- Name: COLUMN bill_svckind.required; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.required IS 'Требуется наличие (категория)';


--
-- Name: COLUMN bill_svckind.p1; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p1 IS 'Первая буква категории приоритета';


--
-- Name: COLUMN bill_svckind.p2; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p2 IS 'Вторая буква категории приоритета';


--
-- Name: COLUMN bill_svckind.p3; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.p3 IS 'Третья буква категории приоритета';


--
-- Name: COLUMN bill_svckind.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_svckind.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_svckind.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_svckind.start_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.start_label IS 'Начальная отметка в сообщении';


--
-- Name: COLUMN bill_svckind.end_label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.end_label IS 'Конечная отметка в сообщении';


--
-- Name: COLUMN bill_svckind.f_serve; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_serve IS 'Признак необходимости указания времени доставки';


--
-- Name: COLUMN bill_svckind.f_second; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_second IS 'Признак использования во втором и следующем сообщении (для многословных телеграмм)';


--
-- Name: COLUMN bill_svckind.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.operator_id IS 'Идентификатор оператора в последний раз изменившего вид услуги';


--
-- Name: COLUMN bill_svckind.f_notification; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_notification IS 'Признак необходимости уведомления';


--
-- Name: COLUMN bill_svckind.f_printcopy; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_printcopy IS 'Признак необходимости печати копии';


--
-- Name: COLUMN bill_svckind.f_needrequest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_needrequest IS 'Признак необходимости дополнительного запроса (уведомления)';


--
-- Name: COLUMN bill_svckind.f_needtg; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_svckind.f_needtg IS 'Требовать наличие телеграфного аппарата';


--
-- Name: bill_svckind_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_svckind_seq
    START WITH 6375
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_svckind_seq OWNER TO coretlx;

--
-- Name: bill_tarif; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_tarif (
    tarif_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    profit numeric(5,2) DEFAULT 0 NOT NULL,
    nds numeric(5,2) DEFAULT 0 NOT NULL,
    closed timestamp(0) without time zone,
    unit_id bigint NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    opened timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    def_service_id bigint,
    msgtype_id smallint NOT NULL,
    operator_id bigint,
    external_id bigint,
    subtract_nds smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.bill_tarif OWNER TO coretlx;

--
-- Name: COLUMN bill_tarif.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN bill_tarif.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.name IS 'Наименование тарифа';


--
-- Name: COLUMN bill_tarif.profit; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.profit IS '% в пользу оператора связи';


--
-- Name: COLUMN bill_tarif.nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.nds IS 'НДС';


--
-- Name: COLUMN bill_tarif.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.closed IS 'Дата/время удаления';


--
-- Name: COLUMN bill_tarif.unit_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.unit_id IS 'Идентификатор единицы тарификации';


--
-- Name: COLUMN bill_tarif.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.created IS 'Дата/время создания';


--
-- Name: COLUMN bill_tarif.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.changed IS 'Дата/время изменения';


--
-- Name: COLUMN bill_tarif.opened; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.opened IS 'Дата/время начала действия';


--
-- Name: COLUMN bill_tarif.def_service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.def_service_id IS 'Идентификатор услуги по умолчанию';


--
-- Name: COLUMN bill_tarif.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN bill_tarif.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.operator_id IS 'Идентификатор оператора в последний раз изменившего тариф';


--
-- Name: COLUMN bill_tarif.external_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.external_id IS 'Внешний идентификатор';


--
-- Name: COLUMN bill_tarif.subtract_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.bill_tarif.subtract_nds IS 'Признак вычитания НДС из суммы начисленной по тарифу (1 - вычитается, 0 - добавляется)';


--
-- Name: bill_tarif_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_tarif_seq
    START WITH 1021
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_tarif_seq OWNER TO coretlx;

--
-- Name: bill_tlgkind; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.bill_tlgkind (
    tlgkind_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    required smallint DEFAULT 0 NOT NULL,
    p1 character varying(1) NOT NULL,
    p2 character varying(1) NOT NULL,
    p3 character varying(1) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone NOT NULL,
    closed timestamp(0) without time zone,
    operator_id bigint,
    start_label character varying(50),
    end_label character varying(50),
    f_serve smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    f_notification smallint DEFAULT 0 NOT NULL,
    f_printcopy smallint DEFAULT 0 NOT NULL,
    f_needrequest smallint DEFAULT 0 NOT NULL,
    f_needtg smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.bill_tlgkind OWNER TO coretlx;

--
-- Name: bill_tlgkind_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.bill_tlgkind_seq
    START WITH 41
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.bill_tlgkind_seq OWNER TO coretlx;

--
-- Name: err_sys_message_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.err_sys_message_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.err_sys_message_seq OWNER TO coretlx;

--
-- Name: err_sys_messages; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.err_sys_messages (
    sys_message_id bigint NOT NULL,
    sys_message character varying(200),
    terminal character varying(200)
);


ALTER TABLE coretlx.err_sys_messages OWNER TO coretlx;

--
-- Name: flyway_schema_history; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.flyway_schema_history (
    installed_rank integer NOT NULL,
    version character varying(50),
    description character varying(200) NOT NULL,
    type character varying(20) NOT NULL,
    script character varying(1000) NOT NULL,
    checksum integer,
    installed_by character varying(100) NOT NULL,
    installed_on timestamp without time zone DEFAULT now() NOT NULL,
    execution_time integer NOT NULL,
    success boolean NOT NULL
);


ALTER TABLE coretlx.flyway_schema_history OWNER TO coretlx;

--
-- Name: imp_tlindex_russia; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.imp_tlindex_russia (
    province_name character varying(100),
    main_town character varying(60),
    time_diff character varying(10),
    town_name character varying(100),
    note character varying(100),
    region_name character varying(100),
    attr character varying(2),
    tlindex character varying(6),
    has_telex character varying(10),
    work_days character varying(100),
    holydays character varying(60),
    li_number character varying(100),
    chaned character varying(100),
    country_id bigint,
    province_id bigint,
    town_id bigint
);


ALTER TABLE coretlx.imp_tlindex_russia OWNER TO coretlx;

--
-- Name: message_temp; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.message_temp (
    created timestamp(0) without time zone,
    pay_phone character(11)
);


ALTER TABLE coretlx.message_temp OWNER TO coretlx;

--
-- Name: msg_address; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_address (
    address_id bigint NOT NULL,
    template_id bigint NOT NULL,
    email character varying(300) NOT NULL,
    name character varying(50) NOT NULL,
    max_count integer NOT NULL,
    body_text text,
    note character varying(300),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    encoding_id smallint DEFAULT 1 NOT NULL,
    max_char smallint DEFAULT 100 NOT NULL,
    attachment smallint DEFAULT 0 NOT NULL,
    cr_mode smallint DEFAULT 0 NOT NULL,
    f_second smallint DEFAULT 0 NOT NULL,
    ccemail character varying(300),
    subject character varying(100) DEFAULT '[Служба заказов]'::character varying,
    extension character varying(20) DEFAULT 'etl'::character varying,
    CONSTRAINT msg_address_chk1 CHECK ((max_count < 2000))
);


ALTER TABLE coretlx.msg_address OWNER TO coretlx;

--
-- Name: COLUMN msg_address.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.address_id IS 'Идентификатор адреса передачи сообщений';


--
-- Name: COLUMN msg_address.template_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.template_id IS 'Идентификатор шаблона форматирования';


--
-- Name: COLUMN msg_address.email; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.email IS 'Адрес электронной почты';


--
-- Name: COLUMN msg_address.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.name IS 'Наименование адреса доставки';


--
-- Name: COLUMN msg_address.max_count; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.max_count IS 'Максимальное число сообщений в пакете';


--
-- Name: COLUMN msg_address.body_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.body_text IS 'Информационный текст в сообщении';


--
-- Name: COLUMN msg_address.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.note IS 'Примечание';


--
-- Name: COLUMN msg_address.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_address.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_address.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_address.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.operator_id IS 'Идентификатор оператора в последний раз изменившего адрес';


--
-- Name: COLUMN msg_address.encoding_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.encoding_id IS 'Идентификатор кодировки письма';


--
-- Name: COLUMN msg_address.max_char; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.max_char IS 'Максимальное число символов в строке';


--
-- Name: COLUMN msg_address.attachment; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.attachment IS 'Передавать пакет как вложение (если 1) или в теле письма (если 0)';


--
-- Name: COLUMN msg_address.cr_mode; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.cr_mode IS 'Режим CR/LF';


--
-- Name: COLUMN msg_address.f_second; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.f_second IS 'Вторичный адрес';


--
-- Name: COLUMN msg_address.ccemail; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_address.ccemail IS 'Адрес электронной почты для отправки копии';


--
-- Name: msg_address_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_address_seq
    START WITH 965
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_address_seq OWNER TO coretlx;

--
-- Name: msg_advert; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_advert (
    message_id bigint NOT NULL,
    dest_rubric_id bigint NOT NULL,
    release coretlx.release_list
);


ALTER TABLE coretlx.msg_advert OWNER TO coretlx;

--
-- Name: COLUMN msg_advert.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_advert.dest_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.dest_rubric_id IS 'Идентификатор рубрики';


--
-- Name: COLUMN msg_advert.release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advert.release IS 'Даты выхода объявления';


--
-- Name: msg_advice; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_advice (
    advice_id bigint NOT NULL,
    message_id bigint,
    advice_state_id bigint NOT NULL,
    note character varying(200),
    f_printcopy smallint,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    is_notifice smallint DEFAULT 0 NOT NULL,
    is_inquire smallint DEFAULT 0 NOT NULL,
    copied timestamp(0) without time zone,
    notified timestamp(0) without time zone
);


ALTER TABLE coretlx.msg_advice OWNER TO coretlx;

--
-- Name: COLUMN msg_advice.is_notifice; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.is_notifice IS 'Уведомление';


--
-- Name: COLUMN msg_advice.is_inquire; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.is_inquire IS 'Запрос';


--
-- Name: COLUMN msg_advice.copied; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.copied IS 'Копия отправлена';


--
-- Name: COLUMN msg_advice.notified; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_advice.notified IS 'Отправлено уведомление';


--
-- Name: msg_advice_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_advice_seq
    START WITH 384194
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_advice_seq OWNER TO coretlx;

--
-- Name: msg_call; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_call (
    call_id bigint NOT NULL,
    aon_phone character varying(20),
    call_phone character varying(20),
    reverse_call smallint,
    abonent_id character varying(20),
    contract_id bigint,
    contract_no character varying(20),
    fgplace_id bigint,
    fgabonent_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    clientcat coretlx.clientcat_list,
    inn character varying(20),
    kpp character varying(20),
    name character varying(300),
    address character varying(350),
    j_address character varying(350),
    pay_phone character varying(20),
    phone_town character varying(100),
    charge_nds smallint DEFAULT 0 NOT NULL,
    fgplace_num character varying(20),
    cdr_call_id bigint,
    key_word character varying(100),
    user_login_id bigint,
    operator_id bigint,
    limit_sum numeric(15,2),
    region_id bigint,
    receive_id bigint,
    f_auto_header smallint DEFAULT 1 NOT NULL,
    completed timestamp(0) without time zone,
    f_avance smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_call OWNER TO coretlx;

--
-- Name: COLUMN msg_call.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN msg_call.aon_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.aon_phone IS 'Телефон АОН';


--
-- Name: COLUMN msg_call.call_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.call_phone IS 'Телефон приема';


--
-- Name: COLUMN msg_call.reverse_call; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.reverse_call IS 'Признак обратного вызова';


--
-- Name: COLUMN msg_call.abonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.abonent_id IS 'Идентификатор абонента в биллинговой системе';


--
-- Name: COLUMN msg_call.contract_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.contract_id IS 'Идентификатор договора в биллинговой системе';


--
-- Name: COLUMN msg_call.contract_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.contract_no IS 'Номер договора';


--
-- Name: COLUMN msg_call.fgplace_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgplace_id IS 'Идентификатор места оплаты';


--
-- Name: COLUMN msg_call.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgabonent_id IS 'Идентификатор типа абонента ЦУС';


--
-- Name: COLUMN msg_call.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_call.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_call.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_call.clientcat; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.clientcat IS 'Список идентификаторов категорий абонента';


--
-- Name: COLUMN msg_call.inn; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.inn IS 'ИНН';


--
-- Name: COLUMN msg_call.kpp; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.kpp IS 'КПП';


--
-- Name: COLUMN msg_call.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.name IS 'Наименование абонента';


--
-- Name: COLUMN msg_call.address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.address IS 'Адрес';


--
-- Name: COLUMN msg_call.j_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.j_address IS 'Юридический адрес';


--
-- Name: COLUMN msg_call.pay_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.pay_phone IS 'Телефон оплаты';


--
-- Name: COLUMN msg_call.phone_town; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.phone_town IS 'Город установки телефона';


--
-- Name: COLUMN msg_call.charge_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.charge_nds IS 'Признак начисления НДС';


--
-- Name: COLUMN msg_call.fgplace_num; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.fgplace_num IS 'Номер места оплаты';


--
-- Name: COLUMN msg_call.cdr_call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.cdr_call_id IS 'Идентификатор вызова в CDR';


--
-- Name: COLUMN msg_call.key_word; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.key_word IS 'Ключевой слово';


--
-- Name: COLUMN msg_call.user_login_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.user_login_id IS 'Идентификатор сессии оператора, принявшего вызов';


--
-- Name: COLUMN msg_call.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.operator_id IS 'Идентификатор оператора в последний раз изменившего вызов';


--
-- Name: COLUMN msg_call.limit_sum; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.limit_sum IS 'Лимит суммы приема';


--
-- Name: COLUMN msg_call.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.region_id IS 'Регион из которого поступил вызов';


--
-- Name: COLUMN msg_call.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_call.receive_id IS 'Место приема телеграммы';


--
-- Name: msg_call_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_call_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_call_seq OWNER TO coretlx;

--
-- Name: msg_call_seq; Type: SEQUENCE OWNED BY; Schema: coretlx; Owner: coretlx
--

ALTER SEQUENCE coretlx.msg_call_seq OWNED BY coretlx.msg_call.call_id;


--
-- Name: msg_chanell_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_chanell_state (
    chanell_id integer NOT NULL,
    state_id smallint NOT NULL,
    changed timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    sector character varying(10)
);


ALTER TABLE coretlx.msg_chanell_state OWNER TO coretlx;

--
-- Name: COLUMN msg_chanell_state.chanell_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chanell_state.chanell_id IS 'Телеграфный канал';


--
-- Name: COLUMN msg_chanell_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chanell_state.state_id IS 'Идентификатор текущего состояния';


--
-- Name: msg_chunk; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_chunk (
    chunk_id bigint NOT NULL,
    message_id bigint,
    text character varying(4000),
    full_text character varying(4000),
    header character varying(400),
    serial_no bigint NOT NULL,
    units bigint,
    words bigint,
    chars bigint,
    sended timestamp(0) without time zone,
    tlg_chanell character varying(6),
    sector character varying(10),
    chanell_no bigint,
    full_serial character varying(50)
);


ALTER TABLE coretlx.msg_chunk OWNER TO coretlx;

--
-- Name: COLUMN msg_chunk.chunk_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chunk_id IS 'Идентификатор фрагмента сообщения';


--
-- Name: COLUMN msg_chunk.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_chunk.text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.text IS 'Текст фрагмента';


--
-- Name: COLUMN msg_chunk.full_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.full_text IS 'Полный форматированные текст фрагмента';


--
-- Name: COLUMN msg_chunk.header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.header IS 'Заголовок';


--
-- Name: COLUMN msg_chunk.serial_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.serial_no IS 'Кассовый номер';


--
-- Name: COLUMN msg_chunk.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.units IS 'Количество единиц тарификации';


--
-- Name: COLUMN msg_chunk.words; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.words IS 'Количество слов';


--
-- Name: COLUMN msg_chunk.chars; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chars IS 'Количество символов';


--
-- Name: COLUMN msg_chunk.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.sended IS 'Дата/время отправки фрагмента';


--
-- Name: COLUMN msg_chunk.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.tlg_chanell IS 'Телеграфный канал по которому передан фрагмент';


--
-- Name: COLUMN msg_chunk.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.sector IS 'Сектор телеграфного канала';


--
-- Name: COLUMN msg_chunk.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_chunk.full_serial; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_chunk.full_serial IS 'Полный кассовый номер сообщения (с каналом и сектором)';


--
-- Name: msg_chunk_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_chunk_seq
    START WITH 527174
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_chunk_seq OWNER TO coretlx;

--
-- Name: msg_dest; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_dest (
    dest_id bigint NOT NULL,
    name character varying(100) NOT NULL,
    info character varying(4000),
    nds numeric(10,2) DEFAULT 0 NOT NULL,
    bill_name character varying(100),
    j_address character varying(100),
    inn character varying(50),
    contr character varying(50),
    closed timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    short_name character varying(100),
    tarif_id bigint,
    release_count smallint DEFAULT 10 NOT NULL,
    operator_id bigint,
    region_id bigint
);


ALTER TABLE coretlx.msg_dest OWNER TO coretlx;

--
-- Name: COLUMN msg_dest.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_dest.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.name IS 'Наименование издания';


--
-- Name: COLUMN msg_dest.info; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.info IS 'Информация об издании (показывается оператору)';


--
-- Name: COLUMN msg_dest.nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.nds IS 'Размер НДС';


--
-- Name: COLUMN msg_dest.bill_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.bill_name IS 'Наименование в биллинговой системе';


--
-- Name: COLUMN msg_dest.j_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.j_address IS 'Юридический адрес';


--
-- Name: COLUMN msg_dest.inn; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.inn IS 'ИНН';


--
-- Name: COLUMN msg_dest.contr; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.contr IS 'Договор';


--
-- Name: COLUMN msg_dest.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_dest.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_dest.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_dest.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.short_name IS 'Краткое наименование издания';


--
-- Name: COLUMN msg_dest.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.tarif_id IS 'Идентификатор применяемого тарифа';


--
-- Name: COLUMN msg_dest.release_count; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.release_count IS 'Максимальное число выпусков';


--
-- Name: COLUMN msg_dest.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.operator_id IS 'Идентификатор оператора в последний раз изменившего скидку';


--
-- Name: COLUMN msg_dest.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest.region_id IS 'Идентификатор региона';


--
-- Name: msg_dest_address; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_dest_address (
    dest_id bigint NOT NULL,
    address_id bigint NOT NULL
);


ALTER TABLE coretlx.msg_dest_address OWNER TO coretlx;

--
-- Name: COLUMN msg_dest_address.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest_address.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_dest_address.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_dest_address.address_id IS 'Идентификатор адреса';


--
-- Name: msg_dest_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_dest_seq
    START WITH 869
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_dest_seq OWNER TO coretlx;

--
-- Name: msg_intelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_intelex (
    intelex_id bigint NOT NULL,
    tlg_index character varying(40),
    tlg_sector character varying(40),
    ch_number bigint,
    full_text character varying(4000),
    created timestamp(0) without time zone DEFAULT statement_timestamp(),
    siregex_id bigint,
    msgservice_id bigint,
    dtlg_content character varying(4000),
    dtlg_sign character varying(4000),
    dtlg_num character varying(400),
    dtlg_date character varying(400),
    dtlg_word character varying(400)
);


ALTER TABLE coretlx.msg_intelex OWNER TO coretlx;

--
-- Name: msg_intelex_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_intelex_seq
    START WITH 40270
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.msg_intelex_seq OWNER TO coretlx;

--
-- Name: msg_last_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_last_log (
    tlg_index character varying(40),
    tlg_sector character varying(40),
    chanell_no bigint,
    message_id bigint,
    chunk_id bigint,
    outtelex_id bigint,
    intelex_id bigint,
    created timestamp(0) without time zone,
    full_text character varying(4000)
);


ALTER TABLE coretlx.msg_last_log OWNER TO coretlx;

--
-- Name: TABLE msg_last_log; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.msg_last_log IS 'Последние отправленные телеграммы';


--
-- Name: msg_message; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_message (
    message_id bigint NOT NULL,
    note character varying(150),
    created timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    units bigint DEFAULT 0 NOT NULL,
    terminal character varying(80),
    service_id bigint NOT NULL,
    cost numeric(15,2) DEFAULT 0 NOT NULL,
    extracost numeric(15,2) DEFAULT 0 NOT NULL,
    ndscost numeric(15,2) DEFAULT 0 NOT NULL,
    msgtype_id smallint DEFAULT 1 NOT NULL,
    our_cost numeric(15,2),
    our_nds numeric(15,2),
    discount numeric(15,2) DEFAULT 0 NOT NULL,
    discount_extra numeric(15,2) DEFAULT 0 NOT NULL,
    changed timestamp(0) without time zone,
    call_id bigint,
    notification character varying(200),
    f_request smallint DEFAULT 0 NOT NULL,
    copy_dest_id integer,
    f_send_request smallint DEFAULT 0 NOT NULL,
    parent_id bigint,
    f_message_copy smallint DEFAULT 0 NOT NULL,
    f_auto_header smallint DEFAULT 1 NOT NULL,
    f_forward smallint DEFAULT 0 NOT NULL,
    tlgplace_no bigint,
    fgnote character varying(150),
    tarif_cost numeric(15,2) DEFAULT 0 NOT NULL,
    extra_cost numeric(15,2) DEFAULT 0 NOT NULL,
    nds_cost numeric(15,2) DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_message OWNER TO coretlx;

--
-- Name: COLUMN msg_message.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_message.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.note IS 'Примечание';


--
-- Name: COLUMN msg_message.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_message.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_message.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.operator_id IS 'Идентификатор оператора в последний раз изменившего сообщение';


--
-- Name: COLUMN msg_message.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.units IS 'Количество тарификационных единиц';


--
-- Name: COLUMN msg_message.terminal; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.terminal IS 'Терминал, с которого принято сообщение';


--
-- Name: COLUMN msg_message.service_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.service_id IS 'Идентификатор услуги';


--
-- Name: COLUMN msg_message.cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.cost IS 'Сумма начисления по тарифу';


--
-- Name: COLUMN msg_message.extracost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.extracost IS 'Сумма сбора по тарифу';


--
-- Name: COLUMN msg_message.ndscost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.ndscost IS 'Сумма НДС';


--
-- Name: COLUMN msg_message.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN msg_message.our_cost; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.our_cost IS 'Доход оператора связи';


--
-- Name: COLUMN msg_message.our_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.our_nds IS 'НДС на доход оператора связи';


--
-- Name: COLUMN msg_message.discount; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.discount IS 'Скидка на сумму начисления';


--
-- Name: COLUMN msg_message.discount_extra; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.discount_extra IS 'Скидка на сумму сбора';


--
-- Name: COLUMN msg_message.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_message.call_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.call_id IS 'Идентификатор вызова';


--
-- Name: COLUMN msg_message.notification; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.notification IS 'Адрес уведомления о доставке';


--
-- Name: COLUMN msg_message.f_request; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_request IS 'Признак запроса уведомления';


--
-- Name: COLUMN msg_message.copy_dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.copy_dest_id IS 'Идентификатор места доставки копии сообщения';


--
-- Name: COLUMN msg_message.f_send_request; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_send_request IS 'Признак необходимости запроса';


--
-- Name: COLUMN msg_message.parent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.parent_id IS 'Идентификатор родительского сообщения (для копии)';


--
-- Name: COLUMN msg_message.f_message_copy; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_message_copy IS 'Признак копии ссобщения';


--
-- Name: COLUMN msg_message.f_auto_header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_auto_header IS 'Признак автоматического формирования заголовка в сервере доставки';


--
-- Name: COLUMN msg_message.f_forward; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.f_forward IS 'Признак сообщения типа "досыл"';


--
-- Name: COLUMN msg_message.tlgplace_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.tlgplace_no IS 'Номер телеграфного места для почтового ОС';


--
-- Name: COLUMN msg_message.fgnote; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_message.fgnote IS 'Дополнительное примечание при отправке сообщения';


--
-- Name: msg_message_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_message_seq
    START WITH 525984
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_message_seq OWNER TO coretlx;

--
-- Name: msg_outtelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_outtelex (
    outtelex_id bigint NOT NULL,
    text character varying(4000),
    header character varying(1600),
    serial_no bigint,
    units bigint,
    words bigint,
    chars bigint,
    tlg_chanell character varying(24),
    sector character varying(40),
    chanell_no bigint,
    full_serial character varying(200),
    sended timestamp(0) without time zone,
    created timestamp(0) without time zone,
    prepared timestamp(0) without time zone,
    message_id bigint,
    msgtype_id bigint,
    tlgend character varying(24),
    town_id bigint,
    note character varying(1600),
    tlgkind_id integer,
    operator_id bigint,
    advice_id bigint,
    intelex_id bigint,
    address character varying(1600),
    is_service smallint DEFAULT 1 NOT NULL,
    is_pay smallint DEFAULT 0 NOT NULL,
    postend character varying(24),
    is_query smallint DEFAULT 1 NOT NULL,
    is_notify smallint DEFAULT 0 NOT NULL,
    is_auto_header smallint DEFAULT 1 NOT NULL,
    is_retry smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.msg_outtelex OWNER TO coretlx;

--
-- Name: COLUMN msg_outtelex.outtelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.outtelex_id IS 'Идентификатор исходящего сообщения';


--
-- Name: COLUMN msg_outtelex.text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.text IS 'Текст сообщения';


--
-- Name: COLUMN msg_outtelex.header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.header IS 'Заголовок сообщения';


--
-- Name: COLUMN msg_outtelex.serial_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.serial_no IS 'Кассовый номер';


--
-- Name: COLUMN msg_outtelex.units; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.units IS 'Единиц тарификации';


--
-- Name: COLUMN msg_outtelex.words; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.words IS 'Слов';


--
-- Name: COLUMN msg_outtelex.chars; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.chars IS 'Символов';


--
-- Name: COLUMN msg_outtelex.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlg_chanell IS 'Индекс канала передачи';


--
-- Name: COLUMN msg_outtelex.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.sector IS 'Сектор';


--
-- Name: COLUMN msg_outtelex.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_outtelex.full_serial; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.full_serial IS 'Полный номер телеграммы';


--
-- Name: COLUMN msg_outtelex.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.sended IS 'Отправлена';


--
-- Name: COLUMN msg_outtelex.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.created IS 'Создана';


--
-- Name: COLUMN msg_outtelex.prepared; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.prepared IS 'Подготовлена к отправке';


--
-- Name: COLUMN msg_outtelex.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_outtelex.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.msgtype_id IS 'Тип сообщения';


--
-- Name: COLUMN msg_outtelex.tlgend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlgend IS 'Телеграфный индекс назначения';


--
-- Name: COLUMN msg_outtelex.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.town_id IS 'Населенный пункт';


--
-- Name: COLUMN msg_outtelex.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.note IS 'Примечание оператора';


--
-- Name: COLUMN msg_outtelex.tlgkind_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.tlgkind_id IS 'Категория телеграммы';


--
-- Name: COLUMN msg_outtelex.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.operator_id IS 'Оператор';


--
-- Name: COLUMN msg_outtelex.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.advice_id IS 'В ответ на запрос уведомления';


--
-- Name: COLUMN msg_outtelex.intelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.intelex_id IS 'В ответ на входящую телеграмму';


--
-- Name: COLUMN msg_outtelex.address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.address IS 'Адрес пункта назначения';


--
-- Name: COLUMN msg_outtelex.is_service; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_service IS 'Признак служебной телеграммы';


--
-- Name: COLUMN msg_outtelex.is_pay; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_pay IS 'Признак платной телеграммы';


--
-- Name: COLUMN msg_outtelex.postend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.postend IS 'Почтовй индекс';


--
-- Name: COLUMN msg_outtelex.is_query; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_query IS 'Запрос';


--
-- Name: COLUMN msg_outtelex.is_notify; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_notify IS 'Извещение отправителя';


--
-- Name: COLUMN msg_outtelex.is_auto_header; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_auto_header IS 'Автоматическре формирование заголовка';


--
-- Name: COLUMN msg_outtelex.is_retry; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_outtelex.is_retry IS 'Повторно неполучением';


--
-- Name: msg_parse; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_parse (
    intelex_id bigint NOT NULL,
    tlg_from character varying(4000),
    tlg_dest character varying(4000),
    tlg_content character varying(4000),
    tlg_sign character varying(4000),
    tlg_num character varying(400),
    tlg_date character varying(400),
    tlg_word character varying(400)
);


ALTER TABLE coretlx.msg_parse OWNER TO coretlx;

--
-- Name: COLUMN msg_parse.intelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.intelex_id IS 'ID входящей телеграммы';


--
-- Name: COLUMN msg_parse.tlg_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_from IS 'Откуда отправлена телеграмма';


--
-- Name: COLUMN msg_parse.tlg_dest; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_dest IS 'Куда направлена телеграмма';


--
-- Name: COLUMN msg_parse.tlg_content; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_content IS 'Содержимое телеграммы';


--
-- Name: COLUMN msg_parse.tlg_sign; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_sign IS 'Подпись';


--
-- Name: COLUMN msg_parse.tlg_num; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_num IS 'Номер исходной телеграммы (из содержимого)';


--
-- Name: COLUMN msg_parse.tlg_date; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_date IS 'Дата исходной телеграммы';


--
-- Name: COLUMN msg_parse.tlg_word; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_parse.tlg_word IS 'Количество слов исходной телеграммы';


--
-- Name: msg_rawtelex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_rawtelex (
    rawtelex_id integer NOT NULL,
    tlg_header character varying(4000),
    tlg_body character varying(4000),
    tlg_footer character varying(4000),
    chunk_id bigint,
    outtelex_id bigint,
    intelex_id bigint,
    created timestamp(0) without time zone NOT NULL,
    tlg_index character varying(40),
    tlg_sector character varying(40),
    tlg_number integer,
    sended timestamp(0) without time zone
);


ALTER TABLE coretlx.msg_rawtelex OWNER TO coretlx;

--
-- Name: TABLE msg_rawtelex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.msg_rawtelex IS 'Отправленная/принятая по каналу связи телеграмма';


--
-- Name: msg_rawtelex_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_rawtelex_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.msg_rawtelex_seq OWNER TO coretlx;

--
-- Name: msg_request; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_request (
    request_id bigint NOT NULL,
    advice_id bigint,
    message_id bigint,
    codeword_id bigint,
    tlg_number character varying(20),
    note character varying(200),
    full_text text,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_request OWNER TO coretlx;

--
-- Name: msg_request_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_request_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_request_seq OWNER TO coretlx;

--
-- Name: msg_response; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_response (
    response_id bigint NOT NULL,
    codeword_id bigint,
    advice_id bigint NOT NULL,
    message_id bigint,
    tlg_number character varying(20) NOT NULL,
    note character varying(200),
    full_text text,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_response OWNER TO coretlx;

--
-- Name: msg_response_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_response_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_response_seq OWNER TO coretlx;

--
-- Name: msg_responsible; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_responsible (
    responsible_id bigint NOT NULL,
    name character varying(300),
    phone1 character varying(20),
    phone2 character varying(20),
    e_mail character varying(300),
    dest_id bigint NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.msg_responsible OWNER TO coretlx;

--
-- Name: COLUMN msg_responsible.responsible_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.responsible_id IS 'Идентификатор ответственного лица';


--
-- Name: COLUMN msg_responsible.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.name IS 'Имя';


--
-- Name: COLUMN msg_responsible.phone1; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.phone1 IS 'Контактный телефон 1';


--
-- Name: COLUMN msg_responsible.phone2; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.phone2 IS 'Контактный телефон 2';


--
-- Name: COLUMN msg_responsible.e_mail; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.e_mail IS 'Адрес электронной почты';


--
-- Name: COLUMN msg_responsible.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_responsible.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_responsible.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_responsible.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_responsible.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_responsible.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: msg_responsible_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_responsible_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_responsible_seq OWNER TO coretlx;

--
-- Name: msg_send_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_send_log (
    send_log_id bigint NOT NULL,
    error_id smallint,
    sended timestamp(0) without time zone DEFAULT statement_timestamp(),
    tlg_chanell character varying(6),
    chunk_id bigint,
    telex_number bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    error_string character varying(200),
    sector character varying(10),
    message_id bigint
);


ALTER TABLE coretlx.msg_send_log OWNER TO coretlx;

--
-- Name: COLUMN msg_send_log.send_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.send_log_id IS 'Идентификатор журнала отправки';


--
-- Name: COLUMN msg_send_log.error_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.error_id IS 'Идентификатор ошибки отправки';


--
-- Name: COLUMN msg_send_log.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.sended IS 'Отправлено';


--
-- Name: COLUMN msg_send_log.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.tlg_chanell IS 'Телеграфный канал';


--
-- Name: COLUMN msg_send_log.chunk_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.chunk_id IS 'Идентификатор фрагмента';


--
-- Name: COLUMN msg_send_log.telex_number; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.telex_number IS 'Номер телеграммы';


--
-- Name: COLUMN msg_send_log.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_send_log.error_string; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.error_string IS 'Строка ошибки';


--
-- Name: COLUMN msg_send_log.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_send_log.sector IS 'Телеграфный сектор';


--
-- Name: msg_send_log_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_send_log_seq
    START WITH 496887
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_send_log_seq OWNER TO coretlx;

--
-- Name: msg_serial; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_serial (
    operator_id bigint,
    serial_no bigint NOT NULL,
    created timestamp(0) without time zone NOT NULL
);


ALTER TABLE coretlx.msg_serial OWNER TO coretlx;

--
-- Name: msg_service; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_service (
    msgservice_id bigint NOT NULL,
    full_text character varying(4000),
    operator_id bigint,
    sended timestamp(0) without time zone,
    received timestamp(0) without time zone,
    is_incoming smallint DEFAULT 0 NOT NULL,
    tlg_chanell character varying(24),
    sector character varying(40),
    chanell_no bigint,
    codeword_id bigint,
    advice_id bigint,
    is_inquire smallint DEFAULT 0,
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    name character varying(400),
    intelex_id bigint,
    outtelex_id bigint
);


ALTER TABLE coretlx.msg_service OWNER TO coretlx;

--
-- Name: COLUMN msg_service.msgservice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.msgservice_id IS 'Идентификатор служебной кодограммы';


--
-- Name: COLUMN msg_service.full_text; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.full_text IS 'Полный текст служебной кодограммы';


--
-- Name: COLUMN msg_service.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.operator_id IS 'Идентификатор оператора принявшего/отправившего телеграмму';


--
-- Name: COLUMN msg_service.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.sended IS 'Когда отправлена';


--
-- Name: COLUMN msg_service.received; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.received IS 'Когда принята';


--
-- Name: COLUMN msg_service.is_incoming; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.is_incoming IS 'Признак входящей кодограммы';


--
-- Name: COLUMN msg_service.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.tlg_chanell IS 'Телеграфный канал';


--
-- Name: COLUMN msg_service.sector; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.sector IS 'Сектор';


--
-- Name: COLUMN msg_service.chanell_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.chanell_no IS 'Номер телеграммы в канале';


--
-- Name: COLUMN msg_service.codeword_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.codeword_id IS 'Идентификатор кодового слова в телеграмме';


--
-- Name: COLUMN msg_service.advice_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.advice_id IS 'Идентификатор запроса уведомления';


--
-- Name: COLUMN msg_service.is_inquire; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.is_inquire IS 'Запрос';


--
-- Name: COLUMN msg_service.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_service.name IS 'Наименование кодограммы';


--
-- Name: msg_service_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_service_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.msg_service_seq OWNER TO coretlx;

--
-- Name: msg_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_state (
    message_id bigint NOT NULL,
    state_id smallint NOT NULL,
    prepared timestamp(0) without time zone,
    sended timestamp(0) without time zone,
    dest_id bigint,
    operator_id bigint,
    locked timestamp(0) without time zone,
    tlg_chanell bigint,
    sector character varying(10),
    created timestamp(0) without time zone,
    msgtype_id smallint,
    parent_id bigint,
    tlgprio smallint,
    outtelex_id bigint
);


ALTER TABLE coretlx.msg_state OWNER TO coretlx;

--
-- Name: COLUMN msg_state.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.state_id IS 'Идентификатор текущего состояния';


--
-- Name: COLUMN msg_state.prepared; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.prepared IS 'Подготовлено к передаче';


--
-- Name: COLUMN msg_state.sended; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.sended IS 'Отправлено';


--
-- Name: COLUMN msg_state.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN msg_state.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.operator_id IS 'Идентификатор оператор, изменившего состояния';


--
-- Name: COLUMN msg_state.locked; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.locked IS 'Заблокировано на отправку';


--
-- Name: COLUMN msg_state.tlg_chanell; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.tlg_chanell IS 'Телеграфный канал передачи сообщения';


--
-- Name: COLUMN msg_state.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.created IS 'Время создания сообщения';


--
-- Name: COLUMN msg_state.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.msgtype_id IS 'Тип телеграммы';


--
-- Name: COLUMN msg_state.parent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.parent_id IS 'Идентификатор родительской телеграммы';


--
-- Name: COLUMN msg_state.tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.tlgprio IS 'Идентификатор приоритета';


--
-- Name: COLUMN msg_state.outtelex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_state.outtelex_id IS 'Идентификатор исходящей телеграммы';


--
-- Name: msg_telex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_telex (
    message_id bigint NOT NULL,
    sign character varying(200),
    tlindex character varying(6) NOT NULL,
    tlgend character varying(200),
    street character varying(200),
    addressee character varying(150),
    country character varying(50),
    postend character varying(6),
    town_id bigint,
    first_address character varying(1000),
    second_address character varying(1000),
    serve_date character varying(100),
    first_tlgprio bigint,
    second_tlgprio bigint,
    cond_address character varying(200),
    tlgplace_no bigint
);


ALTER TABLE coretlx.msg_telex OWNER TO coretlx;

--
-- Name: COLUMN msg_telex.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.message_id IS 'Идентификатор сообщения';


--
-- Name: COLUMN msg_telex.sign; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.sign IS 'Подпись абонента';


--
-- Name: COLUMN msg_telex.tlindex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlindex IS 'Телеграфный индекс назначения';


--
-- Name: COLUMN msg_telex.tlgend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlgend IS 'Адрес';


--
-- Name: COLUMN msg_telex.street; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.street IS 'Адрес';


--
-- Name: COLUMN msg_telex.addressee; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.addressee IS 'Получатель';


--
-- Name: COLUMN msg_telex.country; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.country IS 'Страна назначения';


--
-- Name: COLUMN msg_telex.postend; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.postend IS 'Почтовый индекс';


--
-- Name: COLUMN msg_telex.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.town_id IS 'Идентификатор города назначения';


--
-- Name: COLUMN msg_telex.first_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.first_address IS 'Адрес первого фрагмента';


--
-- Name: COLUMN msg_telex.second_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.second_address IS 'Адрес следующего фрагмента';


--
-- Name: COLUMN msg_telex.serve_date; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.serve_date IS 'Дата вручения';


--
-- Name: COLUMN msg_telex.first_tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.first_tlgprio IS 'Приоритет первой телеграммы';


--
-- Name: COLUMN msg_telex.second_tlgprio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.second_tlgprio IS 'Приоритет второй телеграммы';


--
-- Name: COLUMN msg_telex.cond_address; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.cond_address IS 'Условный адрес';


--
-- Name: COLUMN msg_telex.tlgplace_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_telex.tlgplace_no IS 'Номер телеграфного места для почтового ОС';


--
-- Name: msg_template; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_template (
    template_id bigint NOT NULL,
    name character varying(100) NOT NULL,
    note character varying(300),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    xslt text,
    operator_id bigint
);


ALTER TABLE coretlx.msg_template OWNER TO coretlx;

--
-- Name: COLUMN msg_template.template_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.template_id IS 'Идентификатор шаблона форматирования';


--
-- Name: COLUMN msg_template.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.name IS 'Наименование шаблона форматирования';


--
-- Name: COLUMN msg_template.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.note IS 'Примечание';


--
-- Name: COLUMN msg_template.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.created IS 'Дата/время создания';


--
-- Name: COLUMN msg_template.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.changed IS 'Дата/время изменения';


--
-- Name: COLUMN msg_template.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.closed IS 'Дата/время удаления';


--
-- Name: COLUMN msg_template.xslt; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.xslt IS 'Шаблон форматирования в формате XSLT';


--
-- Name: COLUMN msg_template.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_template.operator_id IS 'Идентификатор оператора в последний раз изменившего шаблон';


--
-- Name: msg_template_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_template_seq
    START WITH 209
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.msg_template_seq OWNER TO coretlx;

--
-- Name: msg_xfer_content; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_xfer_content (
    xfer_log_id bigint NOT NULL,
    message_id bigint NOT NULL
);


ALTER TABLE coretlx.msg_xfer_content OWNER TO coretlx;

--
-- Name: COLUMN msg_xfer_content.xfer_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_content.xfer_log_id IS 'Идентификатор запланированной передачи';


--
-- Name: COLUMN msg_xfer_content.message_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_content.message_id IS 'Идентификатор сообщения';


--
-- Name: msg_xfer_log; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.msg_xfer_log (
    xfer_log_id bigint NOT NULL,
    address_id bigint NOT NULL,
    xfered timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    planned timestamp(0) without time zone,
    started timestamp(0) without time zone,
    xfer_id bigint
);


ALTER TABLE coretlx.msg_xfer_log OWNER TO coretlx;

--
-- Name: COLUMN msg_xfer_log.xfer_log_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfer_log_id IS 'Идентификатор запланированной передачи';


--
-- Name: COLUMN msg_xfer_log.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.address_id IS 'Идентификатор адреса передачи';


--
-- Name: COLUMN msg_xfer_log.xfered; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfered IS 'Дата завершения передачи';


--
-- Name: COLUMN msg_xfer_log.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.created IS 'Дата создания запланированной передачи';


--
-- Name: COLUMN msg_xfer_log.planned; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.planned IS 'Запланировано';


--
-- Name: COLUMN msg_xfer_log.started; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.started IS 'Начато';


--
-- Name: COLUMN msg_xfer_log.xfer_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.msg_xfer_log.xfer_id IS 'Идентификатор времени передачи';


--
-- Name: msg_xfer_log_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.msg_xfer_log_seq
    START WITH 46447
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.msg_xfer_log_seq OWNER TO coretlx;

--
-- Name: ref_clientcategory; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_clientcategory (
    clientcategory_id smallint NOT NULL,
    name character varying(50),
    charge_nds smallint DEFAULT 0 NOT NULL,
    short_name character varying(50),
    catgroup_id bigint
);


ALTER TABLE coretlx.ref_clientcategory OWNER TO coretlx;

--
-- Name: COLUMN ref_clientcategory.clientcategory_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.clientcategory_id IS 'Идентификатор категории абонента';


--
-- Name: COLUMN ref_clientcategory.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.name IS 'Наименование категории абонента';


--
-- Name: COLUMN ref_clientcategory.charge_nds; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.charge_nds IS 'Признак начисления НДС';


--
-- Name: COLUMN ref_clientcategory.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.short_name IS 'Краткое наименование категории абонента';


--
-- Name: COLUMN ref_clientcategory.catgroup_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_clientcategory.catgroup_id IS 'Идентификатор группы категорий';


--
-- Name: ref_codeword; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_codeword (
    codeword_id bigint NOT NULL,
    codeword character varying(80) NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    description character varying(4000)
);


ALTER TABLE coretlx.ref_codeword OWNER TO coretlx;

--
-- Name: ref_codeword_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_codeword_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_codeword_seq OWNER TO coretlx;

--
-- Name: ref_copy_dest; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_copy_dest (
    copy_dest_id integer NOT NULL,
    dest_name character varying(100),
    start_label character varying(100),
    end_label character varying(100),
    telex_hi character(3),
    telex_lo character(3),
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id integer,
    region_id bigint
);


ALTER TABLE coretlx.ref_copy_dest OWNER TO coretlx;

--
-- Name: ref_copy_dest_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_copy_dest_seq
    START WITH 174
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_copy_dest_seq OWNER TO coretlx;

--
-- Name: ref_country; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_country (
    country_id bigint NOT NULL,
    name character varying(60) NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_country OWNER TO coretlx;

--
-- Name: COLUMN ref_country.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.country_id IS 'Идентификатор страны СНГ для передачи телеграммы';


--
-- Name: COLUMN ref_country.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.name IS 'Наименование страны';


--
-- Name: COLUMN ref_country.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_country.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_country.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_country.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_country.operator_id IS 'Идентификатор оператора в последний раз изменившего страну';


--
-- Name: ref_country_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_country_seq
    START WITH 19
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_country_seq OWNER TO coretlx;

--
-- Name: ref_day_period_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_day_period_seq
    START WITH 84
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_day_period_seq OWNER TO coretlx;

--
-- Name: ref_day_periods; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_day_periods (
    day_period_id bigint NOT NULL,
    day_period_name character varying(50) NOT NULL,
    exclude smallint DEFAULT 0 NOT NULL,
    date_from timestamp(0) without time zone,
    date_to timestamp(0) without time zone,
    time_from character(8),
    time_to character(8),
    weekday_from smallint,
    weekday_to smallint,
    period_id bigint NOT NULL
);


ALTER TABLE coretlx.ref_day_periods OWNER TO coretlx;

--
-- Name: COLUMN ref_day_periods.day_period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.day_period_id IS 'Идентификатор временного интервала';


--
-- Name: COLUMN ref_day_periods.day_period_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.day_period_name IS 'Наименование';


--
-- Name: COLUMN ref_day_periods.exclude; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.exclude IS 'Признак исключения из периода';


--
-- Name: COLUMN ref_day_periods.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.date_from IS 'Дата начала действия';


--
-- Name: COLUMN ref_day_periods.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.date_to IS 'Дата окончания действия';


--
-- Name: COLUMN ref_day_periods.time_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.time_from IS 'Время начала действия';


--
-- Name: COLUMN ref_day_periods.time_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.time_to IS 'Время окончания действия';


--
-- Name: COLUMN ref_day_periods.weekday_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.weekday_from IS 'День недели начала';


--
-- Name: COLUMN ref_day_periods.weekday_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.weekday_to IS 'День недели окончания';


--
-- Name: COLUMN ref_day_periods.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_day_periods.period_id IS 'Идентификатор периода';


--
-- Name: ref_delivery; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_delivery (
    delivery_id bigint NOT NULL,
    cat_name character varying(800),
    delivery_time character varying(400),
    reason character varying(800),
    entered timestamp(0) without time zone,
    created timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    order_no bigint
);


ALTER TABLE coretlx.ref_delivery OWNER TO coretlx;

--
-- Name: COLUMN ref_delivery.delivery_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.delivery_id IS 'Уникальный идентификатор';


--
-- Name: COLUMN ref_delivery.cat_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.cat_name IS 'Наименование категории телеграммы';


--
-- Name: COLUMN ref_delivery.delivery_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.delivery_time IS 'Срок доставки телеграммы';


--
-- Name: COLUMN ref_delivery.reason; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.reason IS 'Основание ';


--
-- Name: COLUMN ref_delivery.entered; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.entered IS 'Введен';


--
-- Name: COLUMN ref_delivery.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.created IS 'Создано';


--
-- Name: COLUMN ref_delivery.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.changed IS 'Изменено';


--
-- Name: COLUMN ref_delivery.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.closed IS 'Удалено';


--
-- Name: COLUMN ref_delivery.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_delivery.order_no IS 'Порядок отображения';


--
-- Name: ref_delivery_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_delivery_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.ref_delivery_seq OWNER TO coretlx;

--
-- Name: ref_dest_rubric; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_dest_rubric (
    dest_rubric_id bigint NOT NULL,
    name character varying(100),
    label character varying(50),
    order_no bigint,
    dest_id bigint,
    my_rubric_id bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_dest_rubric OWNER TO coretlx;

--
-- Name: COLUMN ref_dest_rubric.dest_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.dest_rubric_id IS 'Идентификатор рубрики издания';


--
-- Name: COLUMN ref_dest_rubric.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.name IS 'Наименование рубрики';


--
-- Name: COLUMN ref_dest_rubric.label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.label IS 'Отметка в сообщении';


--
-- Name: COLUMN ref_dest_rubric.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.order_no IS 'Порядковый номер (используется для сортировки списка при выводе оператору)';


--
-- Name: COLUMN ref_dest_rubric.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.dest_id IS 'Идентификатор издания';


--
-- Name: COLUMN ref_dest_rubric.my_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.my_rubric_id IS 'Идентификатор внутренней рубрики';


--
-- Name: COLUMN ref_dest_rubric.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_dest_rubric.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_dest_rubric.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_dest_rubric.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_dest_rubric.operator_id IS 'Идентификатор оператора в последний раз изменившего рубрику';


--
-- Name: ref_dest_rubric_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_dest_rubric_order_seq
    START WITH 1663
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_dest_rubric_order_seq OWNER TO coretlx;

--
-- Name: ref_dest_rubric_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_dest_rubric_seq
    START WITH 1663
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_dest_rubric_seq OWNER TO coretlx;

--
-- Name: ref_exclude_release; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_exclude_release (
    exclude_release_id bigint NOT NULL,
    date_from timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    date_to timestamp(0) without time zone,
    note character varying(100),
    dest_id bigint NOT NULL
);


ALTER TABLE coretlx.ref_exclude_release OWNER TO coretlx;

--
-- Name: COLUMN ref_exclude_release.exclude_release_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.exclude_release_id IS 'Идентификатор запрета приема';


--
-- Name: COLUMN ref_exclude_release.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.date_from IS 'Дата начала';


--
-- Name: COLUMN ref_exclude_release.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.date_to IS 'Дата окончания';


--
-- Name: COLUMN ref_exclude_release.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.note IS 'Примечание';


--
-- Name: COLUMN ref_exclude_release.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_exclude_release.dest_id IS 'Идентификатор издания';


--
-- Name: ref_exclude_release_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_exclude_release_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.ref_exclude_release_seq OWNER TO coretlx;

--
-- Name: ref_fgplace; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_fgplace (
    fgplace_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    created timestamp(0) without time zone NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint,
    telex_town character varying(200),
    telex_index character varying(10),
    receive_id bigint,
    region_id bigint
);


ALTER TABLE coretlx.ref_fgplace OWNER TO coretlx;

--
-- Name: ref_fgplace_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_fgplace_seq
    START WITH 661
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.ref_fgplace_seq OWNER TO coretlx;

--
-- Name: ref_location; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_location (
    location_id bigint NOT NULL,
    name character varying(60),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    tarif_id bigint,
    operator_id bigint,
    f_builtin smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.ref_location OWNER TO coretlx;

--
-- Name: COLUMN ref_location.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.location_id IS 'Идентификатор территории';


--
-- Name: COLUMN ref_location.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.name IS 'Наименование территории';


--
-- Name: COLUMN ref_location.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_location.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_location.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_location.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN ref_location.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: COLUMN ref_location.f_builtin; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location.f_builtin IS 'Признак использование в системе, не может удаляться пользователем';


--
-- Name: ref_location_place; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_location_place (
    location_id bigint NOT NULL,
    country_id bigint,
    province_id bigint,
    town_id bigint,
    exclude smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_location_place OWNER TO coretlx;

--
-- Name: COLUMN ref_location_place.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.location_id IS 'Идентификатор территории';


--
-- Name: COLUMN ref_location_place.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.country_id IS 'Идентификатор страны';


--
-- Name: COLUMN ref_location_place.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.province_id IS 'Идентификатор области';


--
-- Name: COLUMN ref_location_place.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.town_id IS 'Идентификатор города';


--
-- Name: COLUMN ref_location_place.exclude; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.exclude IS 'Признак исключения из территории';


--
-- Name: COLUMN ref_location_place.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_location_place.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_location_place.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_location_place.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_location_place.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_location_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_location_seq
    START WITH 39
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_location_seq OWNER TO coretlx;

--
-- Name: ref_my_rubric; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_my_rubric (
    my_rubric_id bigint NOT NULL,
    name character varying(50),
    order_no bigint,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_my_rubric OWNER TO coretlx;

--
-- Name: COLUMN ref_my_rubric.my_rubric_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.my_rubric_id IS 'Идентификатор внутренней рубрики';


--
-- Name: COLUMN ref_my_rubric.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.name IS 'Наименование внутренней рубрики';


--
-- Name: COLUMN ref_my_rubric.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.order_no IS 'Номер по порядку (для сортировки)';


--
-- Name: COLUMN ref_my_rubric.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_my_rubric.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_my_rubric.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_my_rubric.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_my_rubric.operator_id IS 'Идентификатор оператора в последний раз изменившего рубрику';


--
-- Name: ref_my_rubric_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_my_rubric_order_seq
    START WITH 11
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_my_rubric_order_seq OWNER TO coretlx;

--
-- Name: ref_my_rubric_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_my_rubric_seq
    START WITH 11
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_my_rubric_seq OWNER TO coretlx;

--
-- Name: ref_news; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_news (
    news_id bigint NOT NULL,
    country_id bigint,
    created timestamp(0) without time zone,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    content character varying(4000)
);


ALTER TABLE coretlx.ref_news OWNER TO coretlx;

--
-- Name: COLUMN ref_news.news_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.news_id IS 'Идентификатор новости';


--
-- Name: COLUMN ref_news.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.country_id IS 'Идентификатор страны назначения';


--
-- Name: COLUMN ref_news.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.created IS 'Создано';


--
-- Name: COLUMN ref_news.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.closed IS 'Удалено';


--
-- Name: COLUMN ref_news.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.changed IS 'Изменено';


--
-- Name: COLUMN ref_news.content; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_news.content IS 'Содержимое новости';


--
-- Name: ref_news_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_news_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.ref_news_seq OWNER TO coretlx;

--
-- Name: ref_options; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_options (
    option_id bigint NOT NULL,
    module_id bigint NOT NULL,
    options bytea,
    operator_id bigint,
    prop_name character varying(100)
);


ALTER TABLE coretlx.ref_options OWNER TO coretlx;

--
-- Name: COLUMN ref_options.option_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.option_id IS 'Идентификатор настроек';


--
-- Name: COLUMN ref_options.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN ref_options.options; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.options IS 'Настройки';


--
-- Name: COLUMN ref_options.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.operator_id IS 'Идентификатор оператора, для которого сохранены настройки (null - глобальные настройки для всех операторов)';


--
-- Name: COLUMN ref_options.prop_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_options.prop_name IS 'Наименование настроек';


--
-- Name: ref_options_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_options_seq
    START WITH 42
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_options_seq OWNER TO coretlx;

--
-- Name: ref_order; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_order (
    order_id bigint NOT NULL,
    tarif_id bigint NOT NULL,
    name character varying(50),
    short_name character varying(50),
    label character varying(50),
    info character varying(4000),
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    closed timestamp(0) without time zone
);


ALTER TABLE coretlx.ref_order OWNER TO coretlx;

--
-- Name: COLUMN ref_order.order_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.order_id IS 'Идентификатор услуги заказа';


--
-- Name: COLUMN ref_order.tarif_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.tarif_id IS 'Идентификатор тарифа';


--
-- Name: COLUMN ref_order.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.name IS 'Наименование услуги заказа';


--
-- Name: COLUMN ref_order.short_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.short_name IS 'Краткое наименование';


--
-- Name: COLUMN ref_order.label; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.label IS 'Отметка';


--
-- Name: COLUMN ref_order.info; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.info IS 'Информация (для оператора)';


--
-- Name: COLUMN ref_order.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_order.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_order.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_order.closed IS 'Дата/время удаления';


--
-- Name: ref_order_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_order_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.ref_order_seq OWNER TO coretlx;

--
-- Name: ref_period; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_period (
    period_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    closed timestamp(0) without time zone,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    changed timestamp(0) without time zone,
    operator_id bigint
);


ALTER TABLE coretlx.ref_period OWNER TO coretlx;

--
-- Name: COLUMN ref_period.period_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.period_id IS 'Идентификатор периода времени';


--
-- Name: COLUMN ref_period.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.name IS 'Наименование';


--
-- Name: COLUMN ref_period.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_period.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_period.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_period.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_period.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_period_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_period_seq
    START WITH 103
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_period_seq OWNER TO coretlx;

--
-- Name: ref_province; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_province (
    province_id bigint NOT NULL,
    country_id bigint NOT NULL,
    name character varying(60) NOT NULL,
    name_print character varying(60),
    time_diff smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    def_town_id bigint,
    operator_id bigint,
    imp_name character varying(100),
    CONSTRAINT ref_province_chk1 CHECK (((time_diff >= '-24'::integer) AND (time_diff <= 24)))
);


ALTER TABLE coretlx.ref_province OWNER TO coretlx;

--
-- Name: COLUMN ref_province.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.province_id IS 'Идентификатор области (края)';


--
-- Name: COLUMN ref_province.country_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.country_id IS 'Идентификатор страны, в которой расположена область';


--
-- Name: COLUMN ref_province.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.name IS 'Наименование';


--
-- Name: COLUMN ref_province.name_print; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.name_print IS 'Наименование в родительном падеже';


--
-- Name: COLUMN ref_province.time_diff; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.time_diff IS 'Разница во времени с МСК';


--
-- Name: COLUMN ref_province.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_province.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_province.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_province.def_town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.def_town_id IS 'Идентификатор города, автоматически выбираемого в АРМ оператора при выборе области';


--
-- Name: COLUMN ref_province.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.operator_id IS 'Идентификатор оператора в последний раз изменившего область';


--
-- Name: COLUMN ref_province.imp_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_province.imp_name IS 'Наименование в импортируемом справочнике телеграфных индексов';


--
-- Name: ref_province_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_province_seq
    START WITH 244
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_province_seq OWNER TO coretlx;

--
-- Name: ref_release; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_release (
    date_from timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    date_to timestamp(0) without time zone,
    lock_days smallint DEFAULT 0 NOT NULL,
    lock_time character varying(5) DEFAULT '00:00'::character varying NOT NULL,
    weekday_from smallint,
    weekday_to smallint,
    release_id bigint NOT NULL,
    note character varying(100),
    disable_time character varying(5) DEFAULT '00:00'::character varying NOT NULL,
    dest_id bigint NOT NULL,
    operator_id bigint
);


ALTER TABLE coretlx.ref_release OWNER TO coretlx;

--
-- Name: COLUMN ref_release.date_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.date_from IS 'Дата начала действия';


--
-- Name: COLUMN ref_release.date_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.date_to IS 'Дата окончания действия';


--
-- Name: COLUMN ref_release.lock_days; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.lock_days IS 'Запретить прием за дней (мягкая блокировка)';


--
-- Name: COLUMN ref_release.lock_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.lock_time IS 'Запретить прием в (время) (мягкая блокировка)';


--
-- Name: COLUMN ref_release.weekday_from; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.weekday_from IS 'День недели начала действия';


--
-- Name: COLUMN ref_release.weekday_to; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.weekday_to IS 'День недели окончания действия';


--
-- Name: COLUMN ref_release.release_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.release_id IS 'Идентификатор времени выпуска';


--
-- Name: COLUMN ref_release.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.note IS 'Примечание';


--
-- Name: COLUMN ref_release.disable_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.disable_time IS 'Запретить формировние за дней (жесткая блокировка)';


--
-- Name: COLUMN ref_release.dest_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.dest_id IS 'Запретить формирование в (время) (жесткая блокировка)';


--
-- Name: COLUMN ref_release.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_release.operator_id IS 'Идентификатор оператора в последний раз изменившего запись';


--
-- Name: ref_release_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_release_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_release_seq OWNER TO coretlx;

--
-- Name: ref_reports; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_reports (
    report_id bigint NOT NULL,
    module_id bigint NOT NULL,
    r_data bytea,
    u_name character varying(100),
    grid_name character varying(100),
    slow_report smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.ref_reports OWNER TO coretlx;

--
-- Name: COLUMN ref_reports.report_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.report_id IS 'Идентификатор отчета';


--
-- Name: COLUMN ref_reports.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN ref_reports.r_data; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.r_data IS 'Шаблон для построения отчета';


--
-- Name: COLUMN ref_reports.u_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.u_name IS 'Наименование отчета';


--
-- Name: COLUMN ref_reports.grid_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.grid_name IS 'Наименование сетки (для интегрированных отчетов)';


--
-- Name: COLUMN ref_reports.slow_report; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_reports.slow_report IS 'Признак медленного отчета';


--
-- Name: ref_reports_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_reports_seq
    START WITH 105381
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.ref_reports_seq OWNER TO coretlx;

--
-- Name: ref_town; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_town (
    town_id bigint NOT NULL,
    province_id bigint NOT NULL,
    name character varying(60),
    region character varying(60),
    attr character varying(1),
    note character varying(100),
    has_telex smallint DEFAULT 0 NOT NULL,
    created timestamp(0) without time zone DEFAULT statement_timestamp() NOT NULL,
    closed timestamp(0) without time zone,
    changed timestamp(0) without time zone,
    telex_hi character varying(3) NOT NULL,
    telex_lo character varying(3),
    operator_id bigint,
    imp_name character varying(100),
    CONSTRAINT ref_town_chk1 CHECK (((attr)::text = ANY ((ARRAY[''::character varying, 'о'::character varying, 'ц'::character varying, 'г'::character varying, 'О'::character varying, 'Ц'::character varying, 'Г'::character varying, ' '::character varying])::text[])))
);


ALTER TABLE coretlx.ref_town OWNER TO coretlx;

--
-- Name: COLUMN ref_town.town_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.town_id IS 'Идентификатор города (населенного пункта)';


--
-- Name: COLUMN ref_town.province_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.province_id IS 'Идентификатор области (края) где расположен город';


--
-- Name: COLUMN ref_town.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.name IS 'Наименование';


--
-- Name: COLUMN ref_town.region; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.region IS 'Район (если есть) в родительном падеже';


--
-- Name: COLUMN ref_town.attr; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.attr IS 'Признак (О - областной центр, Ц - районный центр, Г - город без необходимости указания района в адресе)';


--
-- Name: COLUMN ref_town.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.note IS 'Примечание для операторов по приему телеграмм';


--
-- Name: COLUMN ref_town.has_telex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.has_telex IS 'Признак наличия телеграфной связи';


--
-- Name: COLUMN ref_town.created; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.created IS 'Дата/время создания';


--
-- Name: COLUMN ref_town.closed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.closed IS 'Дата/время удаления';


--
-- Name: COLUMN ref_town.changed; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.changed IS 'Дата/время изменения';


--
-- Name: COLUMN ref_town.telex_hi; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.telex_hi IS 'Верхний телеграфный индекс';


--
-- Name: COLUMN ref_town.telex_lo; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.telex_lo IS 'Низовой телеграфный индекс';


--
-- Name: COLUMN ref_town.operator_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.operator_id IS 'Идентификатор оператора в последний раз изменившего город';


--
-- Name: COLUMN ref_town.imp_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_town.imp_name IS 'Наименование в импортируемом справочнике телеграфных индексов';


--
-- Name: ref_town_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_town_seq
    START WITH 33510
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_town_seq OWNER TO coretlx;

--
-- Name: ref_xfer; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.ref_xfer (
    xfer_time character varying(5),
    weekday_id smallint NOT NULL,
    xfer_id bigint NOT NULL,
    note character varying(100),
    address_id bigint
);


ALTER TABLE coretlx.ref_xfer OWNER TO coretlx;

--
-- Name: COLUMN ref_xfer.xfer_time; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.xfer_time IS 'Время передачи';


--
-- Name: COLUMN ref_xfer.weekday_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.weekday_id IS 'День недели';


--
-- Name: COLUMN ref_xfer.xfer_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.xfer_id IS 'Идентификатор передачи';


--
-- Name: COLUMN ref_xfer.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.note IS 'Примечание';


--
-- Name: COLUMN ref_xfer.address_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.ref_xfer.address_id IS 'Идентификатор адреса доставки сообщений';


--
-- Name: ref_xfer_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.ref_xfer_seq
    START WITH 2545
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 1;


ALTER TABLE coretlx.ref_xfer_seq OWNER TO coretlx;

--
-- Name: role_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coretlx.role_seq OWNER TO coretlx;

--
-- Name: roles; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.roles (
    id integer NOT NULL,
    name character varying(255)
);


ALTER TABLE coretlx.roles OWNER TO coretlx;

--
-- Name: tmp_old_charge_seq; Type: SEQUENCE; Schema: coretlx; Owner: coretlx
--

CREATE SEQUENCE coretlx.tmp_old_charge_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999
    CACHE 20;


ALTER TABLE coretlx.tmp_old_charge_seq OWNER TO coretlx;

--
-- Name: voc_advice_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_advice_state (
    advice_state_id bigint NOT NULL,
    state_name character varying(50),
    f_advice smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_advice_state OWNER TO coretlx;

--
-- Name: voc_app_errors; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_app_errors (
    module_id bigint,
    error_code bigint,
    package_name character varying(50),
    message character varying(200)
);


ALTER TABLE coretlx.voc_app_errors OWNER TO coretlx;

--
-- Name: voc_chanell_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_chanell_state (
    state_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_chanell_state OWNER TO coretlx;

--
-- Name: voc_charge_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_charge_state (
    charge_state_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_charge_state OWNER TO coretlx;

--
-- Name: COLUMN voc_charge_state.charge_state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_charge_state.charge_state_id IS 'Идентификатор состояния начисления';


--
-- Name: COLUMN voc_charge_state.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_charge_state.name IS 'Расшифровка';


--
-- Name: voc_charge_type; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_charge_type (
    chgtype_id smallint NOT NULL,
    name character varying(50)
);


ALTER TABLE coretlx.voc_charge_type OWNER TO coretlx;

--
-- Name: voc_encoding; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_encoding (
    encoding_id smallint NOT NULL,
    name character varying(20)
);


ALTER TABLE coretlx.voc_encoding OWNER TO coretlx;

--
-- Name: COLUMN voc_encoding.encoding_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_encoding.encoding_id IS 'Идентификатор кодировки сообщения';


--
-- Name: COLUMN voc_encoding.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_encoding.name IS 'Наимеование кодировки';


--
-- Name: voc_fgabonent; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_fgabonent (
    fgabonent_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    clientcat coretlx.clientcat_list,
    receive_id bigint,
    f_auto_header smallint DEFAULT 1 NOT NULL
);


ALTER TABLE coretlx.voc_fgabonent OWNER TO coretlx;

--
-- Name: COLUMN voc_fgabonent.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgabonent.fgabonent_id IS 'Идентификатор абонента';


--
-- Name: COLUMN voc_fgabonent.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgabonent.receive_id IS 'место приема';


--
-- Name: voc_fgregion; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_fgregion (
    region_id bigint,
    fgabonent_id bigint,
    pay_phone character varying(20),
    abonent_id character varying(20)
);


ALTER TABLE coretlx.voc_fgregion OWNER TO coretlx;

--
-- Name: COLUMN voc_fgregion.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_fgregion.fgabonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.fgabonent_id IS 'Идентификатор типа обслуживания';


--
-- Name: COLUMN voc_fgregion.pay_phone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.pay_phone IS 'Телефон оплаты, экспортируемый в биллинговую систему';


--
-- Name: COLUMN voc_fgregion.abonent_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_fgregion.abonent_id IS 'Идентификатор абонента, экспортируемый в биллинговую систему';


--
-- Name: voc_modules; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_modules (
    module_id bigint NOT NULL,
    module_name character varying(200),
    v_major bigint DEFAULT 0 NOT NULL,
    v_minor bigint DEFAULT 0 NOT NULL,
    v_release bigint DEFAULT 0 NOT NULL,
    v_build bigint DEFAULT 0 NOT NULL,
    option_list bytea,
    m_major bigint DEFAULT 0 NOT NULL,
    m_minor bigint DEFAULT 0 NOT NULL,
    m_release bigint DEFAULT 0 NOT NULL,
    m_build bigint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_modules OWNER TO coretlx;

--
-- Name: COLUMN voc_modules.module_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.module_id IS 'Идентификатор модуля';


--
-- Name: COLUMN voc_modules.module_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.module_name IS 'Наименование модуля';


--
-- Name: COLUMN voc_modules.v_major; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_major IS 'Старший номер версии модуля';


--
-- Name: COLUMN voc_modules.v_minor; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_minor IS 'Младший номер версии модуля';


--
-- Name: COLUMN voc_modules.v_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_release IS 'Номер выпуска версии модуля';


--
-- Name: COLUMN voc_modules.v_build; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.v_build IS 'Номер постройки версии модуля';


--
-- Name: COLUMN voc_modules.option_list; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.option_list IS 'Глобальные настройки модуля';


--
-- Name: COLUMN voc_modules.m_major; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_major IS 'Минимальный старший номер поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_minor; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_minor IS 'Минимальный младший номер поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_release; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_release IS 'Минимальный номер выпуска поддерживаемой версии модуля';


--
-- Name: COLUMN voc_modules.m_build; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_modules.m_build IS 'Минимальный номер постройки поддерживаемой версии модуля';


--
-- Name: voc_msg_state; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_msg_state (
    state_id smallint NOT NULL,
    name character varying(50),
    archive smallint NOT NULL
);


ALTER TABLE coretlx.voc_msg_state OWNER TO coretlx;

--
-- Name: COLUMN voc_msg_state.state_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.state_id IS 'Идентификатор текущего состояния сообщения';


--
-- Name: COLUMN voc_msg_state.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.name IS 'Наименование текущего состояния сообщения';


--
-- Name: COLUMN voc_msg_state.archive; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msg_state.archive IS 'Признак архива (сообщение отправлено по линии связи)';


--
-- Name: voc_msgtype; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_msgtype (
    msgtype_id smallint NOT NULL,
    name character varying(50),
    group_id smallint DEFAULT 0 NOT NULL
);


ALTER TABLE coretlx.voc_msgtype OWNER TO coretlx;

--
-- Name: COLUMN voc_msgtype.msgtype_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.msgtype_id IS 'Идентификатор типа сообщения';


--
-- Name: COLUMN voc_msgtype.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.name IS 'Наименование типа сообщения';


--
-- Name: COLUMN voc_msgtype.group_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_msgtype.group_id IS 'Идентификатор группы типов';


--
-- Name: voc_receive; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_receive (
    receive_id bigint NOT NULL,
    name character varying(100)
);


ALTER TABLE coretlx.voc_receive OWNER TO coretlx;

--
-- Name: COLUMN voc_receive.receive_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_receive.receive_id IS 'Идентификатор пункта приема';


--
-- Name: COLUMN voc_receive.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_receive.name IS 'Наименование пункта приема (телефон/почта)';


--
-- Name: voc_region_code; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_region_code (
    region_id bigint NOT NULL,
    abc_code character varying(10),
    order_no bigint NOT NULL,
    billing_proc character varying(100),
    contract_proc character varying(100)
);


ALTER TABLE coretlx.voc_region_code OWNER TO coretlx;

--
-- Name: COLUMN voc_region_code.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_region_code.abc_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.abc_code IS 'ABC код региона';


--
-- Name: COLUMN voc_region_code.order_no; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.order_no IS 'Номер выборки при определении региона';


--
-- Name: COLUMN voc_region_code.billing_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.billing_proc IS 'Процедура запроса даных в биллинговой системе';


--
-- Name: COLUMN voc_region_code.contract_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_region_code.contract_proc IS 'Процедура запроса данных по договору';


--
-- Name: voc_regions; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_regions (
    region_id bigint NOT NULL,
    abc_code character varying(10),
    name character varying(100),
    billing_proc character varying(100),
    note character varying(200),
    location_id bigint,
    time_zone character varying(400)
);


ALTER TABLE coretlx.voc_regions OWNER TO coretlx;

--
-- Name: COLUMN voc_regions.region_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.region_id IS 'Идентификатор региона';


--
-- Name: COLUMN voc_regions.abc_code; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.abc_code IS 'ABC код региона';


--
-- Name: COLUMN voc_regions.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.name IS 'Наименование региона';


--
-- Name: COLUMN voc_regions.billing_proc; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.billing_proc IS 'Процедура запроса даных в биллинговой системе';


--
-- Name: COLUMN voc_regions.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.note IS 'Примечания';


--
-- Name: COLUMN voc_regions.location_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.location_id IS 'Местоположение для региона';


--
-- Name: COLUMN voc_regions.time_zone; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_regions.time_zone IS 'Временная зона для региона';


--
-- Name: voc_send_error; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_send_error (
    error_id smallint NOT NULL,
    description character varying(100)
);


ALTER TABLE coretlx.voc_send_error OWNER TO coretlx;

--
-- Name: COLUMN voc_send_error.error_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_send_error.error_id IS 'Идентификатор ошибки отправки';


--
-- Name: COLUMN voc_send_error.description; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_send_error.description IS 'Описание ошибки';


--
-- Name: voc_siregex; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_siregex (
    siregex_id bigint NOT NULL,
    name character varying(200),
    regex character varying(400)
);


ALTER TABLE coretlx.voc_siregex OWNER TO coretlx;

--
-- Name: TABLE voc_siregex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON TABLE coretlx.voc_siregex IS 'Шаблоны для служебных кодограмм';


--
-- Name: COLUMN voc_siregex.siregex_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.siregex_id IS 'идентификатор';


--
-- Name: COLUMN voc_siregex.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.name IS 'наименование кодограммы';


--
-- Name: COLUMN voc_siregex.regex; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_siregex.regex IS 'регулярное выражение';


--
-- Name: voc_tlgprio; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_tlgprio (
    tlgprio_id integer NOT NULL,
    mark character varying(3) NOT NULL,
    note character varying(100),
    prio smallint DEFAULT 500 NOT NULL
);


ALTER TABLE coretlx.voc_tlgprio OWNER TO coretlx;

--
-- Name: COLUMN voc_tlgprio.tlgprio_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.tlgprio_id IS 'Идентификатор приоритета отправки телеграммы';


--
-- Name: COLUMN voc_tlgprio.mark; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.mark IS 'Отметка в служебном заголовке';


--
-- Name: COLUMN voc_tlgprio.note; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.note IS 'Примечание';


--
-- Name: COLUMN voc_tlgprio.prio; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_tlgprio.prio IS 'Числовой приоритет отправки';


--
-- Name: voc_units; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_units (
    unit_id smallint NOT NULL,
    name character varying(50) NOT NULL
);


ALTER TABLE coretlx.voc_units OWNER TO coretlx;

--
-- Name: COLUMN voc_units.unit_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_units.unit_id IS 'Идентификатор тарификационной единицы';


--
-- Name: COLUMN voc_units.name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_units.name IS 'Наименование тарификационной единицы';


--
-- Name: voc_weekdays; Type: TABLE; Schema: coretlx; Owner: coretlx
--

CREATE TABLE coretlx.voc_weekdays (
    weekday_id smallint NOT NULL,
    weekday_name character varying(20) NOT NULL,
    swdname character varying(10) NOT NULL
);


ALTER TABLE coretlx.voc_weekdays OWNER TO coretlx;

--
-- Name: COLUMN voc_weekdays.weekday_id; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.weekday_id IS 'Идентификатор дня недели';


--
-- Name: COLUMN voc_weekdays.weekday_name; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.weekday_name IS 'Полное наименование дня недели';


--
-- Name: COLUMN voc_weekdays.swdname; Type: COMMENT; Schema: coretlx; Owner: coretlx
--

COMMENT ON COLUMN coretlx.voc_weekdays.swdname IS 'Краткое наименование дня недели';


--
-- Name: acc_advice_timeout acc_advice_timeout_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_advice_timeout
    ADD CONSTRAINT acc_advice_timeout_pkey PRIMARY KEY (advice_timeout_id);


--
-- Name: acc_change acc_change_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_change
    ADD CONSTRAINT acc_change_pkey PRIMARY KEY (change_id);


--
-- Name: acc_changes acc_changes_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_changes
    ADD CONSTRAINT acc_changes_pkey PRIMARY KEY (change_id);


--
-- Name: acc_error acc_error_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_error
    ADD CONSTRAINT acc_error_pkey PRIMARY KEY (error_id);


--
-- Name: acc_errors acc_errors_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_errors
    ADD CONSTRAINT acc_errors_pkey PRIMARY KEY (error_id);


--
-- Name: acc_level acc_level_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_level
    ADD CONSTRAINT acc_level_pkey PRIMARY KEY (level_id);


--
-- Name: acc_module_login acc_module_login_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_module_login
    ADD CONSTRAINT acc_module_login_pkey PRIMARY KEY (module_login_id);


--
-- Name: acc_module_login acc_module_login_u_session_id_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_module_login
    ADD CONSTRAINT acc_module_login_u_session_id_key UNIQUE (u_session_id);


--
-- Name: acc_operator acc_operator_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_operator
    ADD CONSTRAINT acc_operator_pkey PRIMARY KEY (operator_id);


--
-- Name: acc_user_login acc_user_login_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_user_login
    ADD CONSTRAINT acc_user_login_pkey PRIMARY KEY (user_login_id);


--
-- Name: acc_user_login acc_user_login_u_session_id_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_user_login
    ADD CONSTRAINT acc_user_login_u_session_id_key UNIQUE (u_session_id);


--
-- Name: bill_abocharges bill_abocharges_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_abocharges
    ADD CONSTRAINT bill_abocharges_pkey PRIMARY KEY (abocharge_id);


--
-- Name: bill_discount bill_discount_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_discount
    ADD CONSTRAINT bill_discount_pkey PRIMARY KEY (discount_id);


--
-- Name: bill_pay_phone bill_pay_phone_aon_phone_closed_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_pay_phone
    ADD CONSTRAINT bill_pay_phone_aon_phone_closed_key UNIQUE (aon_phone, closed);


--
-- Name: bill_pay_phone bill_pay_phone_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_pay_phone
    ADD CONSTRAINT bill_pay_phone_pkey PRIMARY KEY (pay_phone_id);


--
-- Name: bill_price bill_price_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT bill_price_pkey PRIMARY KEY (price_id);


--
-- Name: bill_service_kind bill_service_kind_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_service_kind
    ADD CONSTRAINT bill_service_kind_pkey PRIMARY KEY (svckind_id, service_id);


--
-- Name: bill_service bill_service_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_service
    ADD CONSTRAINT bill_service_pkey PRIMARY KEY (service_id);


--
-- Name: bill_svckind bill_svckind_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_svckind
    ADD CONSTRAINT bill_svckind_pkey PRIMARY KEY (svckind_id);


--
-- Name: bill_tarif bill_tarif_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_tarif
    ADD CONSTRAINT bill_tarif_pkey PRIMARY KEY (tarif_id);


--
-- Name: bill_tlgkind bill_tlgkind_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_tlgkind
    ADD CONSTRAINT bill_tlgkind_pkey PRIMARY KEY (tlgkind_id);


--
-- Name: err_sys_messages err_sys_messages_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.err_sys_messages
    ADD CONSTRAINT err_sys_messages_pkey PRIMARY KEY (sys_message_id);


--
-- Name: flyway_schema_history flyway_schema_history_pk; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.flyway_schema_history
    ADD CONSTRAINT flyway_schema_history_pk PRIMARY KEY (installed_rank);


--
-- Name: msg_address msg_address_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_address
    ADD CONSTRAINT msg_address_pkey PRIMARY KEY (address_id);


--
-- Name: msg_advert msg_advert_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_advert
    ADD CONSTRAINT msg_advert_pkey PRIMARY KEY (message_id);


--
-- Name: msg_advice msg_advice_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_advice
    ADD CONSTRAINT msg_advice_pkey PRIMARY KEY (advice_id);


--
-- Name: msg_call msg_call_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_call
    ADD CONSTRAINT msg_call_pkey PRIMARY KEY (call_id);


--
-- Name: msg_chunk msg_chunk_message_id_serial_no_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_chunk
    ADD CONSTRAINT msg_chunk_message_id_serial_no_key UNIQUE (message_id, serial_no);


--
-- Name: msg_chunk msg_chunk_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_chunk
    ADD CONSTRAINT msg_chunk_pkey PRIMARY KEY (chunk_id);


--
-- Name: msg_dest_address msg_dest_address_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_dest_address
    ADD CONSTRAINT msg_dest_address_pkey PRIMARY KEY (dest_id, address_id);


--
-- Name: msg_dest msg_dest_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_dest
    ADD CONSTRAINT msg_dest_pkey PRIMARY KEY (dest_id);


--
-- Name: msg_intelex msg_intelex_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_intelex
    ADD CONSTRAINT msg_intelex_pkey PRIMARY KEY (intelex_id);


--
-- Name: msg_message msg_message_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_message
    ADD CONSTRAINT msg_message_pkey PRIMARY KEY (message_id);


--
-- Name: msg_outtelex msg_outtelex_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_outtelex
    ADD CONSTRAINT msg_outtelex_pkey PRIMARY KEY (outtelex_id);


--
-- Name: msg_parse msg_parse_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_parse
    ADD CONSTRAINT msg_parse_pkey PRIMARY KEY (intelex_id);


--
-- Name: msg_rawtelex msg_rawtelex_chunk_id_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_chunk_id_key UNIQUE (chunk_id);


--
-- Name: msg_rawtelex msg_rawtelex_intelex_id_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_intelex_id_key UNIQUE (intelex_id);


--
-- Name: msg_rawtelex msg_rawtelex_outtelex_id_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_outtelex_id_key UNIQUE (outtelex_id);


--
-- Name: msg_rawtelex msg_rawtelex_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_pkey PRIMARY KEY (rawtelex_id);


--
-- Name: msg_request msg_request_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_request
    ADD CONSTRAINT msg_request_pkey PRIMARY KEY (request_id);


--
-- Name: msg_response msg_response_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_response
    ADD CONSTRAINT msg_response_pkey PRIMARY KEY (response_id);


--
-- Name: msg_responsible msg_responsible_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_responsible
    ADD CONSTRAINT msg_responsible_pkey PRIMARY KEY (responsible_id);


--
-- Name: msg_send_log msg_send_log_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_send_log
    ADD CONSTRAINT msg_send_log_pkey PRIMARY KEY (send_log_id);


--
-- Name: msg_service msg_service_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_service
    ADD CONSTRAINT msg_service_pkey PRIMARY KEY (msgservice_id);


--
-- Name: msg_state msg_state_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_state
    ADD CONSTRAINT msg_state_pkey PRIMARY KEY (message_id);


--
-- Name: msg_telex msg_telex_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_telex
    ADD CONSTRAINT msg_telex_pkey PRIMARY KEY (message_id);


--
-- Name: msg_template msg_template_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_template
    ADD CONSTRAINT msg_template_pkey PRIMARY KEY (template_id);


--
-- Name: msg_xfer_content msg_xfer_content_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_xfer_content
    ADD CONSTRAINT msg_xfer_content_pkey PRIMARY KEY (xfer_log_id, message_id);


--
-- Name: msg_xfer_log msg_xfer_log_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_xfer_log
    ADD CONSTRAINT msg_xfer_log_pkey PRIMARY KEY (xfer_log_id);


--
-- Name: ref_clientcategory ref_clientcategory_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_clientcategory
    ADD CONSTRAINT ref_clientcategory_pkey PRIMARY KEY (clientcategory_id);


--
-- Name: ref_codeword ref_codeword_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_codeword
    ADD CONSTRAINT ref_codeword_pkey PRIMARY KEY (codeword_id);


--
-- Name: ref_copy_dest ref_copy_dest_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_copy_dest
    ADD CONSTRAINT ref_copy_dest_pkey PRIMARY KEY (copy_dest_id);


--
-- Name: ref_country ref_country_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_country
    ADD CONSTRAINT ref_country_pkey PRIMARY KEY (country_id);


--
-- Name: ref_day_periods ref_day_periods_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_day_periods
    ADD CONSTRAINT ref_day_periods_pkey PRIMARY KEY (day_period_id);


--
-- Name: ref_delivery ref_delivery_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_delivery
    ADD CONSTRAINT ref_delivery_pkey PRIMARY KEY (delivery_id);


--
-- Name: ref_dest_rubric ref_dest_rubric_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_dest_rubric
    ADD CONSTRAINT ref_dest_rubric_pkey PRIMARY KEY (dest_rubric_id);


--
-- Name: ref_exclude_release ref_exclude_release_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_exclude_release
    ADD CONSTRAINT ref_exclude_release_pkey PRIMARY KEY (exclude_release_id);


--
-- Name: ref_fgplace ref_fgplace_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_fgplace
    ADD CONSTRAINT ref_fgplace_pkey PRIMARY KEY (fgplace_id);


--
-- Name: ref_location ref_location_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location
    ADD CONSTRAINT ref_location_pkey PRIMARY KEY (location_id);


--
-- Name: ref_my_rubric ref_my_rubric_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_my_rubric
    ADD CONSTRAINT ref_my_rubric_pkey PRIMARY KEY (my_rubric_id);


--
-- Name: ref_news ref_news_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_news
    ADD CONSTRAINT ref_news_pkey PRIMARY KEY (news_id);


--
-- Name: ref_options ref_options_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_options
    ADD CONSTRAINT ref_options_pkey PRIMARY KEY (option_id);


--
-- Name: ref_order ref_order_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_order
    ADD CONSTRAINT ref_order_pkey PRIMARY KEY (order_id);


--
-- Name: ref_period ref_period_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_period
    ADD CONSTRAINT ref_period_pkey PRIMARY KEY (period_id);


--
-- Name: ref_province ref_province_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_province
    ADD CONSTRAINT ref_province_pkey PRIMARY KEY (province_id);


--
-- Name: ref_release ref_release_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_release
    ADD CONSTRAINT ref_release_pkey PRIMARY KEY (release_id);


--
-- Name: ref_town ref_town_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_town
    ADD CONSTRAINT ref_town_pkey PRIMARY KEY (town_id);


--
-- Name: ref_xfer ref_xfer_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_xfer
    ADD CONSTRAINT ref_xfer_pkey PRIMARY KEY (xfer_id);


--
-- Name: roles roles_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: voc_advice_state voc_advice_state_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_advice_state
    ADD CONSTRAINT voc_advice_state_pkey PRIMARY KEY (advice_state_id);


--
-- Name: voc_chanell_state voc_chanell_state_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_chanell_state
    ADD CONSTRAINT voc_chanell_state_pkey PRIMARY KEY (state_id);


--
-- Name: voc_charge_state voc_charge_state_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_charge_state
    ADD CONSTRAINT voc_charge_state_pkey PRIMARY KEY (charge_state_id);


--
-- Name: voc_charge_type voc_charge_type_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_charge_type
    ADD CONSTRAINT voc_charge_type_pkey PRIMARY KEY (chgtype_id);


--
-- Name: voc_encoding voc_encoding_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_encoding
    ADD CONSTRAINT voc_encoding_pkey PRIMARY KEY (encoding_id);


--
-- Name: voc_fgabonent voc_fgabonent_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_fgabonent
    ADD CONSTRAINT voc_fgabonent_pkey PRIMARY KEY (fgabonent_id);


--
-- Name: voc_modules voc_modules_module_name_key; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_modules
    ADD CONSTRAINT voc_modules_module_name_key UNIQUE (module_name);


--
-- Name: voc_modules voc_modules_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_modules
    ADD CONSTRAINT voc_modules_pkey PRIMARY KEY (module_id);


--
-- Name: voc_msg_state voc_msg_state_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_msg_state
    ADD CONSTRAINT voc_msg_state_pkey PRIMARY KEY (state_id);


--
-- Name: voc_msgtype voc_msgtype_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_msgtype
    ADD CONSTRAINT voc_msgtype_pkey PRIMARY KEY (msgtype_id);


--
-- Name: voc_receive voc_receive_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_receive
    ADD CONSTRAINT voc_receive_pkey PRIMARY KEY (receive_id);


--
-- Name: voc_regions voc_regions_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_regions
    ADD CONSTRAINT voc_regions_pkey PRIMARY KEY (region_id);


--
-- Name: voc_send_error voc_send_error_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_send_error
    ADD CONSTRAINT voc_send_error_pkey PRIMARY KEY (error_id);


--
-- Name: voc_siregex voc_siregex_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_siregex
    ADD CONSTRAINT voc_siregex_pkey PRIMARY KEY (siregex_id);


--
-- Name: voc_tlgprio voc_tlgprio_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_tlgprio
    ADD CONSTRAINT voc_tlgprio_pkey PRIMARY KEY (tlgprio_id);


--
-- Name: voc_units voc_units_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_units
    ADD CONSTRAINT voc_units_pkey PRIMARY KEY (unit_id);


--
-- Name: voc_weekdays voc_weekdays_pkey; Type: CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_weekdays
    ADD CONSTRAINT voc_weekdays_pkey PRIMARY KEY (weekday_id);


--
-- Name: acc_operator_closed_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX acc_operator_closed_ix ON coretlx.acc_operator USING btree (closed);


--
-- Name: acc_operator_external_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX acc_operator_external_ix ON coretlx.acc_operator USING btree (external_id);


--
-- Name: bill_abocharges_call_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_abocharges_call_ix ON coretlx.bill_abocharges USING btree (call_id);


--
-- Name: bill_abocharges_message_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_abocharges_message_ix ON coretlx.bill_abocharges USING btree (message_id);


--
-- Name: bill_charge_detail_charge_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_charge_detail_charge_ix ON coretlx.bill_charge_detail USING btree (abocharge_id);


--
-- Name: bill_charge_detail_message_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_charge_detail_message_ix ON coretlx.bill_charge_detail USING btree (message_id);


--
-- Name: bill_discount_bill_tarif_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_discount_bill_tarif_ix ON coretlx.bill_discount USING btree (tarif_id);


--
-- Name: bill_discount_ref_clientc_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_discount_ref_clientc_ix ON coretlx.bill_discount USING btree (clientcategory_id);


--
-- Name: bill_discount_ref_period_fk1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_discount_ref_period_fk1 ON coretlx.bill_discount USING btree (period_id);


--
-- Name: bill_pay_phone_index1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_pay_phone_index1 ON coretlx.bill_pay_phone USING btree (aon_phone);


--
-- Name: bill_price_bill_service_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_price_bill_service_ix ON coretlx.bill_price USING btree (service_id);


--
-- Name: bill_price_bill_svckind_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_price_bill_svckind_ix ON coretlx.bill_price USING btree (svckind_id);


--
-- Name: bill_price_bill_tarif_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_price_bill_tarif_ix ON coretlx.bill_price USING btree (tarif_id);


--
-- Name: bill_price_ref_period_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_price_ref_period_ix ON coretlx.bill_price USING btree (period_id);


--
-- Name: bill_service_kind_bill_knd_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_service_kind_bill_knd_ix ON coretlx.bill_service_kind USING btree (svckind_id);


--
-- Name: bill_service_kind_bill_se_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_service_kind_bill_se_ix ON coretlx.bill_service_kind USING btree (service_id);


--
-- Name: bill_svckind_tarif_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_svckind_tarif_ix ON coretlx.bill_svckind USING btree (tarif_id);


--
-- Name: bill_svckind_tlgkind_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_svckind_tlgkind_ix ON coretlx.bill_svckind USING btree (tlgkind_id);


--
-- Name: bill_tarif_bill_service_fk1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_tarif_bill_service_fk1 ON coretlx.bill_tarif USING btree (def_service_id);


--
-- Name: bill_tarif_msg_dest_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_tarif_msg_dest_ix ON coretlx.msg_dest USING btree (tarif_id);


--
-- Name: bill_tarif_ref_location_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_tarif_ref_location_ix ON coretlx.ref_location USING btree (tarif_id);


--
-- Name: bill_tarif_ref_order_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_tarif_ref_order_ix ON coretlx.ref_order USING btree (tarif_id);


--
-- Name: bill_tarif_voc_units_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX bill_tarif_voc_units_ix ON coretlx.bill_tarif USING btree (unit_id);


--
-- Name: flyway_schema_history_s_idx; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX flyway_schema_history_s_idx ON coretlx.flyway_schema_history USING btree (success);


--
-- Name: idx3gi90ewl0mj8gien47ttvm1s9; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idx3gi90ewl0mj8gien47ttvm1s9 ON coretlx.ref_province USING btree (closed);


--
-- Name: idx3lilo3y68sae1cptqufu72wxm; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idx3lilo3y68sae1cptqufu72wxm ON coretlx.ref_town USING btree (closed);


--
-- Name: idx4jgl5qnao1qsnk4m2c9c5rv5y; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idx4jgl5qnao1qsnk4m2c9c5rv5y ON coretlx.ref_town USING btree (name);


--
-- Name: idx5qppdpdmq0myovg059x25kotb; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idx5qppdpdmq0myovg059x25kotb ON coretlx.ref_town USING btree (changed);


--
-- Name: idxa933sd0fcb3d62snvsqke8dh3; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxa933sd0fcb3d62snvsqke8dh3 ON coretlx.ref_province USING btree (name);


--
-- Name: idxcw8ewikqrkalwhopn3tpfc9es; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxcw8ewikqrkalwhopn3tpfc9es ON coretlx.ref_province USING btree (changed);


--
-- Name: idxfkqa9dqdq7tlrbhtwksiobyjy; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxfkqa9dqdq7tlrbhtwksiobyjy ON coretlx.ref_country USING btree (closed);


--
-- Name: idxi2b6okois5qyyyj2gelet5fe3; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxi2b6okois5qyyyj2gelet5fe3 ON coretlx.ref_town USING btree (region);


--
-- Name: idxqefovkt4tgyq5f9aiwdyd0p6s; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxqefovkt4tgyq5f9aiwdyd0p6s ON coretlx.ref_country USING btree (name);


--
-- Name: idxs7tis16wt2ifmlgujb4pyh8kf; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxs7tis16wt2ifmlgujb4pyh8kf ON coretlx.ref_town USING btree (operator_id);


--
-- Name: idxsoisj6jw259ja728k61ctx0jn; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX idxsoisj6jw259ja728k61ctx0jn ON coretlx.ref_country USING btree (changed);


--
-- Name: msg_address_msg_template_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_address_msg_template_ix ON coretlx.msg_address USING btree (template_id);


--
-- Name: msg_address_ref_xfer_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_address_ref_xfer_ix ON coretlx.ref_xfer USING btree (address_id);


--
-- Name: msg_call_user_login_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_call_user_login_ix ON coretlx.msg_call USING btree (user_login_id);


--
-- Name: msg_chunk_message_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_chunk_message_ix ON coretlx.msg_chunk USING btree (message_id);


--
-- Name: msg_dest_address_msg_addr_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_dest_address_msg_addr_ix ON coretlx.msg_dest_address USING btree (address_id);


--
-- Name: msg_dest_address_msg_dest_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_dest_address_msg_dest_ix ON coretlx.msg_dest_address USING btree (dest_id);


--
-- Name: msg_dest_exclude_release_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_dest_exclude_release_ix ON coretlx.ref_exclude_release USING btree (dest_id);


--
-- Name: msg_dest_ref_dest_rubric_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_dest_ref_dest_rubric_ix ON coretlx.ref_dest_rubric USING btree (dest_id);


--
-- Name: msg_intelex_service_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_intelex_service_ix ON coretlx.msg_intelex USING btree (msgservice_id);


--
-- Name: msg_message_call_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_message_call_ix ON coretlx.msg_message USING btree (call_id);


--
-- Name: msg_message_create_date_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_message_create_date_ix ON coretlx.msg_message USING btree (date_trunc('day'::text, created));


--
-- Name: msg_message_created_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_message_created_ix ON coretlx.msg_message USING btree (created, operator_id);


--
-- Name: msg_message_operator_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_message_operator_ix ON coretlx.msg_message USING btree (operator_id);


--
-- Name: msg_outtelex_advice_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_outtelex_advice_ix ON coretlx.msg_outtelex USING btree (advice_id);


--
-- Name: msg_responsible_msg_dest_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_responsible_msg_dest_ix ON coretlx.msg_responsible USING btree (dest_id);


--
-- Name: msg_send_log_chunk_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_send_log_chunk_ix ON coretlx.msg_send_log USING btree (chunk_id);


--
-- Name: msg_service_intelex_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_service_intelex_ix ON coretlx.msg_service USING btree (intelex_id);


--
-- Name: msg_service_outtelex_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_service_outtelex_ix ON coretlx.msg_service USING btree (outtelex_id);


--
-- Name: msg_state_operator_state_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_state_operator_state_ix ON coretlx.msg_state USING btree (state_id, operator_id);


--
-- Name: msg_xfer_log_addr_started_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_xfer_log_addr_started_ix ON coretlx.msg_xfer_log USING btree (address_id, started);


--
-- Name: msg_xfer_log_xfer_content_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX msg_xfer_log_xfer_content_ix ON coretlx.msg_xfer_content USING btree (xfer_log_id);


--
-- Name: ref_clientcat_bill_price_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_clientcat_bill_price_ix ON coretlx.bill_price USING btree (clientcategory_id);


--
-- Name: ref_copy_dest_region_fk; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_copy_dest_region_fk ON coretlx.ref_copy_dest USING btree (region_id);


--
-- Name: ref_fgplace_receive_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_fgplace_receive_ix ON coretlx.ref_fgplace USING btree (receive_id);


--
-- Name: ref_location_place_index1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE UNIQUE INDEX ref_location_place_index1 ON coretlx.ref_location_place USING btree (location_id, country_id, province_id, town_id);


--
-- Name: ref_location_place_ref_co_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_location_place_ref_co_ix ON coretlx.ref_location_place USING btree (country_id);


--
-- Name: ref_location_place_ref_lo_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_location_place_ref_lo_ix ON coretlx.ref_location_place USING btree (location_id);


--
-- Name: ref_location_place_ref_pr_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_location_place_ref_pr_ix ON coretlx.ref_location_place USING btree (province_id);


--
-- Name: ref_location_place_ref_to_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_location_place_ref_to_ix ON coretlx.ref_location_place USING btree (town_id);


--
-- Name: ref_my_rubric_dest_rubric_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_my_rubric_dest_rubric_ix ON coretlx.ref_dest_rubric USING btree (my_rubric_id);


--
-- Name: ref_province_ref_country_fk1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_province_ref_country_fk1 ON coretlx.ref_province USING btree (country_id);


--
-- Name: ref_town_ref_province_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX ref_town_ref_province_ix ON coretlx.ref_town USING btree (province_id);


--
-- Name: voc_encoding_msg_address_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_encoding_msg_address_ix ON coretlx.msg_address USING btree (encoding_id);


--
-- Name: voc_modules_ref_options_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_modules_ref_options_ix ON coretlx.ref_options USING btree (module_id);


--
-- Name: voc_msgtype_bill_tarif_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_msgtype_bill_tarif_ix ON coretlx.bill_tarif USING btree (msgtype_id);


--
-- Name: voc_weekdays_ref_release_ix1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_weekdays_ref_release_ix1 ON coretlx.ref_release USING btree (weekday_from);


--
-- Name: voc_weekdays_ref_release_ix2; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_weekdays_ref_release_ix2 ON coretlx.ref_release USING btree (weekday_to);


--
-- Name: voc_weekdays_ref_xfer_ix; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_weekdays_ref_xfer_ix ON coretlx.ref_xfer USING btree (weekday_id);


--
-- Name: voc_wkdays_ref_day_periods_ix1; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_wkdays_ref_day_periods_ix1 ON coretlx.ref_day_periods USING btree (weekday_from);


--
-- Name: voc_wkdays_ref_day_periods_ix2; Type: INDEX; Schema: coretlx; Owner: coretlx
--

CREATE INDEX voc_wkdays_ref_day_periods_ix2 ON coretlx.ref_day_periods USING btree (weekday_to);


--
-- Name: acc_change acc_change_level_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_change
    ADD CONSTRAINT acc_change_level_fk FOREIGN KEY (level_id) REFERENCES coretlx.acc_level(level_id);


--
-- Name: bill_discount bill_discount_bill_tarif_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_discount
    ADD CONSTRAINT bill_discount_bill_tarif_fk1 FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id);


--
-- Name: bill_discount bill_discount_ref_clientc_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_discount
    ADD CONSTRAINT bill_discount_ref_clientc_fk1 FOREIGN KEY (clientcategory_id) REFERENCES coretlx.ref_clientcategory(clientcategory_id);


--
-- Name: bill_discount bill_discount_ref_period_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_discount
    ADD CONSTRAINT bill_discount_ref_period_fk1 FOREIGN KEY (period_id) REFERENCES coretlx.ref_period(period_id);


--
-- Name: bill_price bill_price_bill_service_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT bill_price_bill_service_fk1 FOREIGN KEY (service_id) REFERENCES coretlx.bill_service(service_id);


--
-- Name: bill_price bill_price_bill_svckind_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT bill_price_bill_svckind_fk1 FOREIGN KEY (svckind_id) REFERENCES coretlx.bill_svckind(svckind_id);


--
-- Name: bill_price bill_price_bill_tarif_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT bill_price_bill_tarif_fk1 FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id);


--
-- Name: bill_price bill_price_ref_period_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT bill_price_ref_period_fk1 FOREIGN KEY (period_id) REFERENCES coretlx.ref_period(period_id);


--
-- Name: bill_service_kind bill_service_kind_bill_knd_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_service_kind
    ADD CONSTRAINT bill_service_kind_bill_knd_fk1 FOREIGN KEY (svckind_id) REFERENCES coretlx.bill_svckind(svckind_id) ON DELETE CASCADE;


--
-- Name: bill_service_kind bill_service_kind_bill_se_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_service_kind
    ADD CONSTRAINT bill_service_kind_bill_se_fk1 FOREIGN KEY (service_id) REFERENCES coretlx.bill_service(service_id) ON DELETE CASCADE;


--
-- Name: bill_svckind bill_svckind_tarif_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_svckind
    ADD CONSTRAINT bill_svckind_tarif_fk FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id) ON DELETE CASCADE;


--
-- Name: bill_svckind bill_svckind_tlgkind_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_svckind
    ADD CONSTRAINT bill_svckind_tlgkind_fk FOREIGN KEY (tlgkind_id) REFERENCES coretlx.bill_tlgkind(tlgkind_id) ON DELETE SET NULL;


--
-- Name: bill_tarif bill_tarif_bill_service_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_tarif
    ADD CONSTRAINT bill_tarif_bill_service_fk1 FOREIGN KEY (def_service_id) REFERENCES coretlx.bill_service(service_id) ON DELETE SET NULL;


--
-- Name: msg_dest bill_tarif_msg_dest_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_dest
    ADD CONSTRAINT bill_tarif_msg_dest_fk1 FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id);


--
-- Name: bill_tarif bill_tarif_voc_units_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_tarif
    ADD CONSTRAINT bill_tarif_voc_units_fk FOREIGN KEY (unit_id) REFERENCES coretlx.voc_units(unit_id);


--
-- Name: msg_advert fk18vpkrgtrrh5d4ilps1clgg9y; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_advert
    ADD CONSTRAINT fk18vpkrgtrrh5d4ilps1clgg9y FOREIGN KEY (dest_rubric_id) REFERENCES coretlx.ref_dest_rubric(dest_rubric_id);


--
-- Name: ref_location_place fk1lnbcbx8a2bncs3etmmyr5pcu; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location_place
    ADD CONSTRAINT fk1lnbcbx8a2bncs3etmmyr5pcu FOREIGN KEY (location_id) REFERENCES coretlx.ref_location(location_id);


--
-- Name: ref_location_place fk29htemcyo7rk9xl3cebfgy0kg; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location_place
    ADD CONSTRAINT fk29htemcyo7rk9xl3cebfgy0kg FOREIGN KEY (province_id) REFERENCES coretlx.ref_province(province_id);


--
-- Name: ref_location fk33a2m1wjginupumh0v0t0dphl; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location
    ADD CONSTRAINT fk33a2m1wjginupumh0v0t0dphl FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id);


--
-- Name: ref_province fk3m3mvi5cex1xwfst4d1ut6bu8; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_province
    ADD CONSTRAINT fk3m3mvi5cex1xwfst4d1ut6bu8 FOREIGN KEY (province_id) REFERENCES coretlx.ref_town(town_id);


--
-- Name: acc_operator fk57ped6syuan7fic1jhmigjfco; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.acc_operator
    ADD CONSTRAINT fk57ped6syuan7fic1jhmigjfco FOREIGN KEY (user_role) REFERENCES coretlx.roles(id);


--
-- Name: ref_province fkai6hq9b3wk063xeb9xyoel63t; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_province
    ADD CONSTRAINT fkai6hq9b3wk063xeb9xyoel63t FOREIGN KEY (country_id) REFERENCES coretlx.ref_country(country_id);


--
-- Name: ref_dest_rubric fkbvk2kap5nmelvpxn7ld2ogdga; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_dest_rubric
    ADD CONSTRAINT fkbvk2kap5nmelvpxn7ld2ogdga FOREIGN KEY (dest_id) REFERENCES coretlx.msg_dest(dest_id);


--
-- Name: msg_state fkcfb9rqwrgsi1hsi62wjek848b; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_state
    ADD CONSTRAINT fkcfb9rqwrgsi1hsi62wjek848b FOREIGN KEY (state_id) REFERENCES coretlx.voc_msg_state(state_id);


--
-- Name: voc_region_code fkf2u4b5brr4rwkp7nxtyywq1t9; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.voc_region_code
    ADD CONSTRAINT fkf2u4b5brr4rwkp7nxtyywq1t9 FOREIGN KEY (region_id) REFERENCES coretlx.voc_regions(region_id);


--
-- Name: ref_location_place fkhfuklhkim1e0k8v8kyh79clmp; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location_place
    ADD CONSTRAINT fkhfuklhkim1e0k8v8kyh79clmp FOREIGN KEY (country_id) REFERENCES coretlx.ref_country(country_id);


--
-- Name: bill_service fkj77i5a5ad39egqgrdan006yiu; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_service
    ADD CONSTRAINT fkj77i5a5ad39egqgrdan006yiu FOREIGN KEY (tarif_id) REFERENCES coretlx.bill_tarif(tarif_id);


--
-- Name: ref_news fkjdmw2pbd0csallrwsf6ninfu4; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_news
    ADD CONSTRAINT fkjdmw2pbd0csallrwsf6ninfu4 FOREIGN KEY (country_id) REFERENCES coretlx.ref_country(country_id);


--
-- Name: msg_message fknadvp8g0u2i9yhe5y1cny3r75; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_message
    ADD CONSTRAINT fknadvp8g0u2i9yhe5y1cny3r75 FOREIGN KEY (service_id) REFERENCES coretlx.bill_service(service_id);


--
-- Name: ref_location_place fkomcawa5lwgwlklpj3s67wywxe; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_location_place
    ADD CONSTRAINT fkomcawa5lwgwlklpj3s67wywxe FOREIGN KEY (town_id) REFERENCES coretlx.ref_town(town_id);


--
-- Name: ref_town fkpo9bts2vm481pdnb67js5qr1s; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.ref_town
    ADD CONSTRAINT fkpo9bts2vm481pdnb67js5qr1s FOREIGN KEY (province_id) REFERENCES coretlx.ref_province(province_id);


--
-- Name: msg_address msg_address_msg_template_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_address
    ADD CONSTRAINT msg_address_msg_template_fk1 FOREIGN KEY (template_id) REFERENCES coretlx.msg_template(template_id);


--
-- Name: bill_abocharges msg_call_bill_abocharges_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_abocharges
    ADD CONSTRAINT msg_call_bill_abocharges_fk1 FOREIGN KEY (call_id) REFERENCES coretlx.msg_call(call_id) ON DELETE SET NULL;


--
-- Name: msg_call msg_call_user_login_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_call
    ADD CONSTRAINT msg_call_user_login_fk FOREIGN KEY (user_login_id) REFERENCES coretlx.acc_user_login(user_login_id) ON DELETE SET NULL;


--
-- Name: msg_chunk msg_chunk_message_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_chunk
    ADD CONSTRAINT msg_chunk_message_fk FOREIGN KEY (message_id) REFERENCES coretlx.msg_message(message_id);


--
-- Name: msg_dest_address msg_dest_address_msg_addr_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_dest_address
    ADD CONSTRAINT msg_dest_address_msg_addr_fk1 FOREIGN KEY (address_id) REFERENCES coretlx.msg_address(address_id) NOT VALID;


--
-- Name: msg_dest_address msg_dest_address_msg_dest_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_dest_address
    ADD CONSTRAINT msg_dest_address_msg_dest_fk1 FOREIGN KEY (dest_id) REFERENCES coretlx.msg_dest(dest_id);


--
-- Name: msg_intelex msg_intelex_service_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_intelex
    ADD CONSTRAINT msg_intelex_service_fk FOREIGN KEY (msgservice_id) REFERENCES coretlx.msg_service(msgservice_id);


--
-- Name: bill_abocharges msg_message_abocharges_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_abocharges
    ADD CONSTRAINT msg_message_abocharges_fk1 FOREIGN KEY (message_id) REFERENCES coretlx.msg_message(message_id) ON DELETE SET NULL;


--
-- Name: msg_message msg_message_call_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_message
    ADD CONSTRAINT msg_message_call_fk FOREIGN KEY (call_id) REFERENCES coretlx.msg_call(call_id);


--
-- Name: msg_advert msg_message_msg_advert_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_advert
    ADD CONSTRAINT msg_message_msg_advert_fk1 FOREIGN KEY (message_id) REFERENCES coretlx.msg_message(message_id) ON DELETE CASCADE;


--
-- Name: msg_outtelex msg_outtelex_advice_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_outtelex
    ADD CONSTRAINT msg_outtelex_advice_fk FOREIGN KEY (advice_id) REFERENCES coretlx.msg_advice(advice_id);


--
-- Name: msg_parse msg_parse_intelex_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_parse
    ADD CONSTRAINT msg_parse_intelex_fk FOREIGN KEY (intelex_id) REFERENCES coretlx.msg_intelex(intelex_id) ON DELETE CASCADE;


--
-- Name: msg_rawtelex msg_rawtelex_chunk_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_chunk_fk FOREIGN KEY (chunk_id) REFERENCES coretlx.msg_chunk(chunk_id);


--
-- Name: msg_rawtelex msg_rawtelex_intelex_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_intelex_fk FOREIGN KEY (intelex_id) REFERENCES coretlx.msg_intelex(intelex_id);


--
-- Name: msg_rawtelex msg_rawtelex_outtelex_fk; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_rawtelex
    ADD CONSTRAINT msg_rawtelex_outtelex_fk FOREIGN KEY (outtelex_id) REFERENCES coretlx.msg_outtelex(outtelex_id);


--
-- Name: msg_responsible msg_responsible_msg_dest_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_responsible
    ADD CONSTRAINT msg_responsible_msg_dest_fk1 FOREIGN KEY (dest_id) REFERENCES coretlx.msg_dest(dest_id) NOT VALID;


--
-- Name: bill_price ref_clientcat_bill_price_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_price
    ADD CONSTRAINT ref_clientcat_bill_price_fk1 FOREIGN KEY (clientcategory_id) REFERENCES coretlx.ref_clientcategory(clientcategory_id) ON DELETE SET NULL;


--
-- Name: msg_address voc_encoding_msg_address_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.msg_address
    ADD CONSTRAINT voc_encoding_msg_address_fk1 FOREIGN KEY (encoding_id) REFERENCES coretlx.voc_encoding(encoding_id);


--
-- Name: bill_tarif voc_msgtype_bill_tarif_fk1; Type: FK CONSTRAINT; Schema: coretlx; Owner: coretlx
--

ALTER TABLE ONLY coretlx.bill_tarif
    ADD CONSTRAINT voc_msgtype_bill_tarif_fk1 FOREIGN KEY (msgtype_id) REFERENCES coretlx.voc_msgtype(msgtype_id);


--
-- PostgreSQL database dump complete
--

