procedure register_fgcall(i_call_id      in msg_call.call_id%type,
i_aon_phone    in MSG_CALL.CALL_PHONE%type, -- Телефон АОН
i_oper_phone   in MSG_CALL.CALL_PHONE%type, -- Телефон оператора
i_fgabonent_id in msg_call.fgabonent_id%type,
i_fgplace_id   in msg_call.fgplace_id%type,
o_call_id      out MSG_CALL.CALL_ID%type, -- Идентификатор вызова
o_auto_header  out msg_call.f_auto_header%type,
o_pay_phone    out MSG_CALL.PAY_PHONE%type, -- Телефон оплаты
o_name         out MSG_CALL.NAME%type, -- Наименование абонента
o_paddress     out MSG_CALL.ADDRESS%type, -- Адрес доставки счета
o_jaddress     out MSG_CALL.J_ADDRESS%type, -- Юридический адрес
o_inn          out MSG_CALL.INN%type, -- ИНН
o_kpp          out MSG_CALL.KPP%type -- КПП
) is
    PRAGMA AUTONOMOUS_TRANSACTION;
    l_call msg_call%rowtype;
begin
    l_call := null;
    -- Если регистрируется новый вызов
    if i_call_id is null and g_call.call_id is not null then
      unregister_call;
end if;
    -- Если нет зарегистрированного вызова
    if g_call.call_id is null then
      if i_call_id is null then
        -- Если вызов ранее не регистрировался
        if g_user_login.operator_id is null then
          cmn_errors_pkg.operator_not_registered;
end if;
        l_call.fgplace_id  := i_fgplace_id;
        l_call.fgplace_num := i_fgabonent_id;
        -- TODO - Добавить место приема
        l_call.created   := sysdate;
        l_call.closed    := null;
        l_call.aon_phone := i_aon_phone;
else
begin
          -- Сюда попадаем, если состояние пакета
          -- сброшено из-за перекомпиляции
select *
into g_call
from MSG_CALL
where MSG_CALL.CALL_ID = i_call_id;
o_call_id   := g_call.call_id;
          o_pay_phone := g_call.pay_phone;
          o_name      := g_call.name;
          o_paddress  := g_call.address;
          o_jaddress  := g_call.j_address;
          o_inn       := g_call.inn;
          o_kpp       := g_call.kpp;
          return;
exception
          when others then
            cmn_errors_pkg.invalid_call;
end;
end if;
else
      -- Если есть зарегистрированный вызов
      l_call := g_call;
      if call_message_count(l_call.call_id) > 0 then
        cmn_errors_pkg.busy_call;
end if;
end if;
    -- Начиная отсюда можно производить изменение вызова
    l_call.call_id      := i_call_id;
    l_call.call_phone   := i_oper_phone;
    l_call.fgplace_id   := i_fgplace_id;
    l_call.fgabonent_id := i_fgabonent_id;
    l_call.reverse_call := null;
    l_call.contract_no  := null;
    l_call.j_address    := null;
    l_call.inn          := null;
    l_call.kpp          := null;

select voc_fgabonent.clientcat,
       voc_fgabonent.receive_id,
       voc_fgabonent.f_auto_header
into l_call.clientcat, l_call.receive_id, l_call.f_auto_header
from voc_fgabonent
where voc_fgabonent.fgabonent_id = i_fgabonent_id;
select ref_fgplace.name,
       ref_fgplace.telex_town,
       ref_fgplace.region_id,
       ref_fgplace.receive_id
into l_call.name, l_call.address, l_call.region_id, l_call.receive_id
from ref_fgplace
where ref_fgplace.fgplace_id = i_fgplace_id;

begin
      if l_call.region_id is not null and l_call.fgabonent_id is not null then
select voc_fgregion.pay_phone, voc_fgregion.abonent_id
into l_call.pay_phone, l_call.abonent_id
from voc_fgregion
where voc_fgregion.region_id = l_call.region_id
  and voc_fgregion.fgabonent_id = l_call.fgabonent_id;
else
        l_call.pay_phone  := null;
        l_call.abonent_id := null;
end if;
exception
      when others then
        l_call.pay_phone  := null;
        l_call.abonent_id := null;
end;

    l_call.charge_nds    := is_charge_nds(l_call.clientcat);
    l_call.changed       := sysdate;
    l_call.operator_id   := g_user_login.operator_id;
    l_call.user_login_id := g_user_login.user_login_id;

    if l_call.call_id is null then
select MSG_CALL_SEQ.nextval into l_call.call_id from dual;
insert into msg_call values l_call;
else
update msg_call
set row = l_call
where msg_call.call_id = l_call.call_id;
end if;

    g_call := l_call;

    o_call_id     := g_call.call_id;
    o_auto_header := g_call.f_auto_header;
    o_pay_phone   := g_call.pay_phone;
    o_name        := g_call.name;
    o_paddress    := g_call.address;
    o_jaddress    := g_call.j_address;
    o_inn         := g_call.inn;
    o_kpp         := g_call.kpp;
commit;
end register_fgcall;