procedure calc_advert_charge(
    v_message  in out nocopy msg_message%rowtype
  ) is
    cursor c_prices is
select
    bill_price.price_id,
    bill_price.const,
    bill_price.mult,
    bill_price.extra,
    bill_price.charge,
    bill_price.billing_code
from bill_service
         left join bill_price on bill_price.tarif_id = bill_service.tarif_id,
     msg_call
where bill_service.service_id = v_message.service_id
  and msg_call.call_id = v_message.call_id
  and (BILL_PRICE.SERVICE_ID = v_message.service_id
    or BILL_PRICE.SVCKIND_ID in (select BILL_SERVICE_KIND.SVCKIND_ID from BILL_SERVICE_KIND where BILL_SERVICE_KIND.SERVICE_ID = bill_service.service_id)
    or (BILL_PRICE.SERVICE_ID is null and BILL_PRICE.SVCKIND_ID is null)
    )
  and (bill_price.clientcategory_id is null or bill_price.clientcategory_id in (
    select *
    from TABLE(MSG_CALL.CLIENTCAT) CATEGORIES
))
  and (bill_price.region_id is null or bill_price.region_id = msg_call.region_id)
  and (bill_price.receive_id is null or bill_price.receive_id = msg_call.receive_id)
  and (BILL_PRICE.CLOSED is null or BILL_PRICE.CLOSED > v_message.created)
  and BILL_PRICE.OPENED < v_message.created
  and v_message.units between BILL_PRICE.MIN_UNITS and BILL_PRICE.MAX_UNITS;
l_charge_detail    bill_charge_detail%rowtype;
l_release_count    number;
l_advert_count     number;
l_price_cost       number;
  begin
    -- Общее количество выпусков
select count(*)
into l_release_count
from table(select msg_advert.release from msg_advert where msg_advert.message_id = v_message.message_id) release;

l_charge_detail.message_id := v_message.message_id;
l_charge_detail.abocharge_id := null;
l_charge_detail.f_substract := 0;
l_charge_detail.operator_id := cmn_auth_pkg.get_valid_operator_id;
l_charge_detail.f_canceled := 0;

for price in c_prices loop
      -- Количество выпусков, тарифицируемых по price_id
select count(*)
into l_advert_count
from bill_price,
     table(select msg_advert.release from msg_advert where msg_advert.message_id = v_message.message_id) release
where bill_price.price_id = price.price_id
  and (
    BILL_PRICE.CLOSED is null or
    (bill_price.by_release = 0 and BILL_PRICE.CLOSED > v_message.created) or
    (bill_price.by_release = 1 and bill_price.closed > release.column_value)
    )
  and (
    (bill_price.by_release = 0 and BILL_PRICE.opened < v_message.created) or
    (bill_price.by_release = 1 and bill_price.opened < release.column_value)
    );

l_price_cost := price.const + v_message.units * price.mult;
if price.extra = 0 then
        if price.charge = 0 then
          v_message.cost := v_message.cost + l_price_cost * l_release_count;
v_message.tarif_cost := v_message.tarif_cost + l_price_cost * l_release_count;
else
          v_message.cost := v_message.cost + l_price_cost * l_release_count / l_advert_count;
v_message.tarif_cost := v_message.tarif_cost + l_price_cost * l_release_count / l_advert_count;
end if;
else
        if price.charge = 0 then
          v_message.extracost := v_message.extracost + l_price_cost * l_release_count;
v_message.extra_cost := v_message.extra_cost + l_price_cost * l_release_count;
else
          v_message.extracost := v_message.extracost + l_price_cost * l_release_count / l_advert_count;
v_message.extra_cost := v_message.extra_cost + l_price_cost * l_release_count / l_advert_count;
end if;
end if;

if price.charge = 0 then
        l_charge_detail.cost := l_price_cost * l_release_count;
else
        l_charge_detail.cost := l_price_cost * l_release_count / l_advert_count;
end if;
l_charge_detail.price_id := price.price_id;
l_charge_detail.billing_code := nvl(price.billing_code, cmn_constant_pkg.DEFAULT_BILLING_CODE);
insert into bill_charge_detail values l_charge_detail;
end loop;
end calc_advert_charge;