procedure calc_telex_charge(
    v_message  in out nocopy msg_message%rowtype
  ) is
    cursor c_prices(i_message_id msg_message.message_id%type) is
select
    bill_price.price_id,
    bill_price.const,
    bill_price.mult,
    bill_price.extra,
    bill_price.billing_code
from msg_message
         left join bill_service on bill_service.service_id = msg_message.service_id
         left join bill_price on bill_price.tarif_id = bill_service.tarif_id
         left join msg_telex on msg_telex.message_id = msg_message.message_id
         left join ref_town on ref_town.town_id = msg_telex.town_id
         left join ref_province on ref_province.province_id = ref_town.province_id
         left join msg_call on msg_call.call_id = msg_message.call_id
where msg_message.message_id = i_message_id
  and (BILL_PRICE.SERVICE_ID = bill_service.service_id
    or BILL_PRICE.SVCKIND_ID in (select BILL_SERVICE_KIND.SVCKIND_ID from BILL_SERVICE_KIND where BILL_SERVICE_KIND.SERVICE_ID = bill_service.service_id)
    or (BILL_PRICE.SERVICE_ID is null and BILL_PRICE.SVCKIND_ID is null)
    )
  and (bill_price.clientcategory_id is null or bill_price.clientcategory_id in (
    select *
    from TABLE(MSG_CALL.CLIENTCAT) CATEGORIES
))
  and (bill_price.region_id is null or bill_price.region_id = msg_call.region_id)
  and (bill_price.receive_id is null or bill_price.receive_id = msg_call.receive_id)
  and (BILL_PRICE.CLOSED is null or BILL_PRICE.CLOSED > msg_message.created)
  and BILL_PRICE.OPENED < msg_message.created
  and msg_message.units between BILL_PRICE.MIN_UNITS and BILL_PRICE.MAX_UNITS
  and (bill_price.dest_location_id is null or
       (bill_price.is_exclude_dest = 0 and bill_price.dest_location_id in
                                           (
                                               select REF_LOCATION_PLACE.LOCATION_ID
                                               from REF_LOCATION_PLACE
                                               where REF_LOCATION_PLACE.TOWN_ID = REF_TOWN.TOWN_ID
                                                  or (REF_LOCATION_PLACE.TOWN_ID is null and REF_LOCATION_PLACE.PROVINCE_ID = REF_PROVINCE.PROVINCE_ID)
                                                  or (REF_LOCATION_PLACE.PROVINCE_ID is null and REF_LOCATION_PLACE.COUNTRY_ID = REF_PROVINCE.COUNTRY_ID)
                                           )
           ) or
       (bill_price.is_exclude_dest = 1 and bill_price.dest_location_id not in
                                           (
                                               select REF_LOCATION_PLACE.LOCATION_ID
                                               from REF_LOCATION_PLACE
                                               where REF_LOCATION_PLACE.TOWN_ID = REF_TOWN.TOWN_ID
                                                  or (REF_LOCATION_PLACE.TOWN_ID is null and REF_LOCATION_PLACE.PROVINCE_ID = REF_PROVINCE.PROVINCE_ID)
                                                  or (REF_LOCATION_PLACE.PROVINCE_ID is null and REF_LOCATION_PLACE.COUNTRY_ID = REF_PROVINCE.COUNTRY_ID)
                                           )
           )
    );
l_charge_detail    bill_charge_detail%rowtype;
l_price_cost       number;
  begin
l_charge_detail.message_id := v_message.message_id;
l_charge_detail.abocharge_id := null;
l_charge_detail.f_substract := 0;
l_charge_detail.operator_id := cmn_auth_pkg.get_valid_operator_id;
l_charge_detail.f_canceled := 0;

for price in c_prices(v_message.message_id) loop
      l_price_cost := price.const + v_message.units * price.mult;
if price.extra = 0 then
        v_message.cost := v_message.cost + l_price_cost;
v_message.tarif_cost := v_message.tarif_cost + l_price_cost;
else
        v_message.extracost := v_message.extracost + l_price_cost;
v_message.extra_cost := v_message.extra_cost + l_price_cost;
end if;
l_charge_detail.cost := l_price_cost;
l_charge_detail.price_id := price.price_id;
l_charge_detail.billing_code := nvl(price.billing_code, cmn_constant_pkg.DEFAULT_BILLING_CODE);
insert into bill_charge_detail values l_charge_detail;
end loop;
end calc_telex_charge;