/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.specification;

import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import ru.asw.telegrammodule.entity.coretlx.RefTown;
import ru.asw.telegrammodule.utils.SearchCriteria;

public class TownSpecification
implements Specification<RefTown> {
    private static Logger logger = LoggerFactory.getLogger((String)TownSpecification.class.getName());
    private SearchCriteria criteria;

    public TownSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<RefTown> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getOperation().equalsIgnoreCase("fetch")) {
            root.fetch("province").fetch("country");
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">=")) {
            if (root.get(this.criteria.getKey()).getJavaType() == Date.class) {
                return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<=")) {
            if (root.get(this.criteria.getKey()).getJavaType() == Date.class) {
                return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            if (root.get(this.criteria.getKey()).getJavaType() == Date.class) {
                return builder.greaterThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.greaterThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            if (root.get(this.criteria.getKey()).getJavaType() == Date.class) {
                return builder.lessThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.lessThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (this.criteria.getKey().equals("provinceId")) {
                return builder.equal((Expression)root.get("province").get("id"), this.criteria.getValue());
            }
            if (root.get(this.criteria.getKey()).getJavaType() == Date.class && this.criteria.getValue() == null) {
                return builder.isNull((Expression)root.get(this.criteria.getKey()));
            }
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.upper((Expression)root.get(this.criteria.getKey())), "%" + ((String)this.criteria.getValue()).toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

