/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.specification;

import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import ru.asw.telegrammodule.entity.coretlx.MsgMessage;
import ru.asw.telegrammodule.utils.SearchCriteria;

public class MessageSpecification
implements Specification<MsgMessage> {
    private static Logger logger = LoggerFactory.getLogger((String)MessageSpecification.class.getName());
    private SearchCriteria criteria;

    public MessageSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<MsgMessage> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            if (this.criteria.getKey().equals("created")) {
                return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            if (this.criteria.getKey().equals("created")) {
                return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Date)this.criteria.getValue()));
            }
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (this.criteria.getKey().equals("tariffId")) {
                return builder.equal((Expression)root.get("service").get("tariff").get("id"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("stateId")) {
                return builder.equal((Expression)root.get("state").get("state").get("id"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("regionId")) {
                return builder.equal((Expression)root.get("call").get("regionId"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("operatorId")) {
                return builder.equal((Expression)root.get("operator").get("id"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("fgPlaceId")) {
                return builder.equal((Expression)root.get("call").get("fgplaceId"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("payPhone")) {
                return builder.equal((Expression)root.get("call").get("payPhone"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("receiveId")) {
                return builder.equal((Expression)root.get("call").get("receiveId"), this.criteria.getValue());
            }
            if (this.criteria.getKey().equals("isAdvance")) {
                return builder.equal((Expression)root.get("call").get("fAvance"), this.criteria.getValue());
            }
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like((Expression)root.get(this.criteria.getKey()), "%" + String.valueOf(this.criteria.getValue()) + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

