/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import ru.asw.telegrammodule.dto.TownDto;
import ru.asw.telegrammodule.repository.RefTownRepository;
import ru.asw.telegrammodule.service.TownService;
import ru.asw.telegrammodule.specification.TownSpecification;
import ru.asw.telegrammodule.utils.FormatDataTime;
import ru.asw.telegrammodule.utils.SearchCriteria;

@Service
public class TownServiceImpl
implements TownService {
    private RefTownRepository refTownRepository;

    public List<TownDto> findTownsByParams(Long id, String name, Long provinceId, String district, Date changed) {
        Specification spec = Specification.where(null);
        TownSpecification spec01 = new TownSpecification(new SearchCriteria("fetch"));
        spec = spec.and((Specification)spec01);
        TownSpecification spec0 = new TownSpecification(new SearchCriteria("closed", ">", (Object)FormatDataTime.atStartOfDay((Date)new Date())));
        TownSpecification spec00 = new TownSpecification(new SearchCriteria("closed", ":", null));
        spec = spec.and(spec0.or((Specification)spec00));
        if (id != null) {
            TownSpecification specId = new TownSpecification(new SearchCriteria("id", ":", (Object)id));
            spec = spec.and((Specification)specId);
        }
        if (name != null) {
            TownSpecification spec1 = new TownSpecification(new SearchCriteria("name", ":", (Object)name));
            spec = spec.and((Specification)spec1);
        }
        if (provinceId != null) {
            TownSpecification spec2 = new TownSpecification(new SearchCriteria("provinceId", ":", (Object)provinceId));
            spec = spec.and((Specification)spec2);
        }
        if (changed != null) {
            TownSpecification spec3 = new TownSpecification(new SearchCriteria("changed", ">", (Object)FormatDataTime.atStartOfDay((Date)changed)));
            TownSpecification spec30 = new TownSpecification(new SearchCriteria("changed", ":", null));
            spec = spec.and(spec3.or((Specification)spec30));
        }
        if (district != null) {
            TownSpecification spec5 = new TownSpecification(new SearchCriteria("district", ":", (Object)district));
            spec = spec.and((Specification)spec5);
        }
        ArrayList<TownDto> towns = new ArrayList<TownDto>();
        List refTowns = this.refTownRepository.findAll(spec);
        refTowns.forEach(t -> towns.add(TownDto.builder().id(t.getId()).name(t.getName()).note(t.getNote()).provinceName(t.getProvince().getName()).countryName(t.getProvince().getCountry().getName()).attr(t.getAttr()).district(t.getDistrict()).tg(t.getHasTelex()).build()));
        return towns;
    }

    public TownServiceImpl(RefTownRepository refTownRepository) {
        this.refTownRepository = refTownRepository;
    }
}

