/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.service.impl;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import ru.asw.telegrammodule.beans.CurrentCall;
import ru.asw.telegrammodule.dto.ChargeDto;
import ru.asw.telegrammodule.dto.MessagesDto;
import ru.asw.telegrammodule.dto.ResponseCallDto;
import ru.asw.telegrammodule.dto.UpdateMsgMessageDto;
import ru.asw.telegrammodule.entity.coretlx.BillChargeDetail;
import ru.asw.telegrammodule.entity.coretlx.BillPrice;
import ru.asw.telegrammodule.entity.coretlx.BillService;
import ru.asw.telegrammodule.entity.coretlx.BillSvckind;
import ru.asw.telegrammodule.entity.coretlx.MsgAdvert;
import ru.asw.telegrammodule.entity.coretlx.MsgAdvice;
import ru.asw.telegrammodule.entity.coretlx.MsgCall;
import ru.asw.telegrammodule.entity.coretlx.MsgChunk;
import ru.asw.telegrammodule.entity.coretlx.MsgMessage;
import ru.asw.telegrammodule.entity.coretlx.MsgSerial;
import ru.asw.telegrammodule.entity.coretlx.MsgState;
import ru.asw.telegrammodule.entity.coretlx.MsgTelex;
import ru.asw.telegrammodule.entity.coretlx.MsgXferContent;
import ru.asw.telegrammodule.entity.coretlx.MsgXferContentId;
import ru.asw.telegrammodule.entity.coretlx.MsgXferLog;
import ru.asw.telegrammodule.entity.coretlx.RefCopyDest;
import ru.asw.telegrammodule.entity.coretlx.RefTown;
import ru.asw.telegrammodule.entity.coretlx.VocMsgState;
import ru.asw.telegrammodule.entity.coretlx.VocTlgprio;
import ru.asw.telegrammodule.enums.AdviceState;
import ru.asw.telegrammodule.enums.MessageState;
import ru.asw.telegrammodule.enums.MessageType;
import ru.asw.telegrammodule.enums.PermissionsDescription;
import ru.asw.telegrammodule.enums.TextUnitType;
import ru.asw.telegrammodule.repository.BillPriceRepository;
import ru.asw.telegrammodule.repository.BillServiceRepository;
import ru.asw.telegrammodule.repository.BillSvckindRepository;
import ru.asw.telegrammodule.repository.MsgAdvertRepository;
import ru.asw.telegrammodule.repository.MsgAdviceRepository;
import ru.asw.telegrammodule.repository.MsgCallRepository;
import ru.asw.telegrammodule.repository.MsgChunkRepository;
import ru.asw.telegrammodule.repository.MsgMessageRepository;
import ru.asw.telegrammodule.repository.MsgSerialRepository;
import ru.asw.telegrammodule.repository.MsgStateRepository;
import ru.asw.telegrammodule.repository.MsgTelexRepository;
import ru.asw.telegrammodule.repository.MsgXferContentRepository;
import ru.asw.telegrammodule.repository.MsgXferLogRepository;
import ru.asw.telegrammodule.repository.RefCopyDestRepository;
import ru.asw.telegrammodule.repository.RefTownRepository;
import ru.asw.telegrammodule.repository.VocMsgStateRepository;
import ru.asw.telegrammodule.repository.VocTlgprioRepository;
import ru.asw.telegrammodule.service.MessageService;
import ru.asw.telegrammodule.service.OperatorService;
import ru.asw.telegrammodule.service.impl.MessageServiceImpl;
import ru.asw.telegrammodule.specification.MessageSpecification;
import ru.asw.telegrammodule.utils.FormatDataTime;
import ru.asw.telegrammodule.utils.SearchCriteria;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Value(value="#{'${telegram.pay_phone.suffix.array}'.split(',')}")
    private List<String> payPhoneSuffixes;
    @Autowired
    @Qualifier(value="currentCall")
    private CurrentCall currentCall;
    @PersistenceContext
    private EntityManager entityManager;
    static final Integer PAGE_SIZE = 20;
    static final Integer PAGE_NUMBER = 0;
    private static Logger logger = LoggerFactory.getLogger((String)MessageServiceImpl.class.getName());
    private final MsgMessageRepository msgMessageRepository;
    private final VocMsgStateRepository vocMsgStateRepository;
    private final MsgXferContentRepository msgXferContentRepository;
    private final MsgAdviceRepository msgAdviceRepository;
    private final OperatorService operatorService;
    private final MsgAdvertRepository msgAdvertRepository;
    private final MsgXferLogRepository msgXferLogRepository;
    private final MsgCallRepository callRepository;
    private final ModelMapper modelMapper;
    private final BillServiceRepository serviceRepository;
    private final RefCopyDestRepository copyDestRepository;
    private final VocTlgprioRepository tlgprioRepository;
    private final BillSvckindRepository billSvckindRepository;
    private final RefTownRepository refTownRepository;
    private final MsgChunkRepository msgChunkRepository;
    private final MsgTelexRepository telexRepository;
    private final MsgStateRepository stateRepository;
    private final MsgSerialRepository serialRepository;
    private final BillPriceRepository billPriceRepository;

    public MessageServiceImpl(List<String> payPhoneSuffixes, MsgMessageRepository msgMessageRepository, VocMsgStateRepository vocMsgStateRepository, MsgXferContentRepository msgXferContentRepository, MsgAdviceRepository msgAdviceRepository, OperatorService operatorService, MsgAdvertRepository msgAdvertRepository, MsgXferLogRepository msgXferLogRepository, MsgCallRepository callRepository, ModelMapper modelMapper, BillServiceRepository serviceRepository, RefCopyDestRepository copyDestRepository, VocTlgprioRepository tlgprioRepository, BillSvckindRepository billSvckindRepository, RefTownRepository refTownRepository, MsgChunkRepository msgChunkRepository, MsgTelexRepository telexRepository, MsgStateRepository stateRepository, MsgSerialRepository serialRepository, BillPriceRepository billPriceRepository) {
        this.payPhoneSuffixes = payPhoneSuffixes;
        this.msgMessageRepository = msgMessageRepository;
        this.vocMsgStateRepository = vocMsgStateRepository;
        this.msgXferContentRepository = msgXferContentRepository;
        this.msgAdviceRepository = msgAdviceRepository;
        this.operatorService = operatorService;
        this.msgAdvertRepository = msgAdvertRepository;
        this.msgXferLogRepository = msgXferLogRepository;
        this.callRepository = callRepository;
        this.modelMapper = modelMapper;
        this.serviceRepository = serviceRepository;
        this.copyDestRepository = copyDestRepository;
        this.tlgprioRepository = tlgprioRepository;
        this.billSvckindRepository = billSvckindRepository;
        this.refTownRepository = refTownRepository;
        this.msgChunkRepository = msgChunkRepository;
        this.telexRepository = telexRepository;
        this.stateRepository = stateRepository;
        this.serialRepository = serialRepository;
        this.billPriceRepository = billPriceRepository;
    }

    @Transactional
    public ResponseEntity<MsgMessage> dropMessageFromQueueByMessageId(Long messageId) {
        MsgMessage message = (MsgMessage)this.msgMessageRepository.findById((Object)messageId).get();
        MsgState msgState = message.getState();
        msgState.setState((VocMsgState)this.vocMsgStateRepository.findById((Object)MessageState.MSG_STATE_DROPPED.getValue()).get());
        this.msgXferContentRepository.findById_MessageId(messageId);
        this.msgXferContentRepository.delete((Object)this.msgXferContentRepository.findById_MessageId(messageId));
        message.setState(msgState);
        return ResponseEntity.ok((Object)this.dropMessage(message));
    }

    @Transactional
    public ResponseEntity<MsgMessage> dropPaymentMessage(Long messageId) {
        MsgMessage message = (MsgMessage)this.msgMessageRepository.findById((Object)messageId).get();
        MsgState msgState = message.getState();
        msgState.setState((VocMsgState)this.vocMsgStateRepository.findById((Object)MessageState.MSG_STATE_DROPPED.getValue()).get());
        msgState.setPrepared(null);
        msgState.setSent(null);
        msgState.setOperatorId(this.operatorService.getOperatorId());
        message.setState(msgState);
        return ResponseEntity.ok((Object)this.dropMessage(message));
    }

    private MsgMessage dropMessage(MsgMessage message) {
        message.setChanged(new Date());
        message.setClosed(new Date());
        message.setCost(BigDecimal.ZERO);
        message.setTarifCost(BigDecimal.ZERO);
        message.setExtracost(BigDecimal.ZERO);
        message.setExtraCost(BigDecimal.ZERO);
        message = (MsgMessage)this.msgMessageRepository.save((Object)message);
        Optional advice = this.msgAdviceRepository.findByMessageId(message.getId());
        if (advice.isPresent()) {
            ((MsgAdvice)advice.get()).setAdviceStateId(Integer.valueOf(AdviceState.ADVICE_STATE_COMPLETE.getValue()));
            this.msgAdviceRepository.save((Object)((MsgAdvice)advice.get()));
        }
        return message;
    }

    @Transactional
    public void sendQueue() {
        List msgMessageList = this.msgMessageRepository.findByState_State((VocMsgState)this.vocMsgStateRepository.findById((Object)MessageState.MSG_STATE_EDIT.getValue()).get());
        msgMessageList.forEach(message -> {
            if (message.getCall() != null) {
                if (message.getCall().getfAvance() == null) {
                    message.getCall().setfAvance(Boolean.valueOf(false));
                }
                if (!message.getCall().getfAvance().booleanValue() && message.getMsgtypeId().intValue() == MessageType.ADVERT.getValue()) {
                    MsgAdvert msgAdvert = this.msgAdvertRepository.findByMessage(message);
                    Set msgAddresses = msgAdvert.getDestRubric().getDest().getMsgAddresses();
                    msgAddresses.forEach(msgAddress -> {
                        MsgXferLog msgXferLog = this.msgXferLogRepository.findByAddressIdAndStartedIsNull(msgAddress.getId());
                        MsgXferContentId msgXferContentId = new MsgXferContentId();
                        msgXferContentId.setMessageId(message.getId());
                        msgXferContentId.setXferLogId(msgXferLog.getId());
                        MsgXferContent msgXferContent = new MsgXferContent();
                        msgXferContent.setId(msgXferContentId);
                        this.msgXferContentRepository.save((Object)msgXferContent);
                        logger.info("New msgXferContent contains - ({}, {})", (Object)msgXferContent.getId().getMessageId(), (Object)msgXferContent.getId().getXferLogId());
                    });
                }
                if (!message.getCall().getfAvance().booleanValue()) {
                    message.getState().setState((VocMsgState)this.vocMsgStateRepository.findById((Object)MessageState.MSG_STATE_QUEUE.getValue()).get());
                } else {
                    message.getState().setState((VocMsgState)this.vocMsgStateRepository.findById((Object)MessageState.MSG_STATE_PAYMENT.getValue()).get());
                }
            }
            message.getState().setPrepared(new Date());
            message.getState().setSent(null);
            this.msgMessageRepository.save(message);
            logger.info("The message added to the queue (messageId = {}, stateId = {})", (Object)message.getId(), (Object)message.getState().getState().getId());
        });
    }

    public MessagesDto getMessagesByParams(Integer pageNumber, Integer size, Long operatorId, Date dateFrom, Date dateTo, Integer tariffId, Integer stateId, Integer regionId) {
        return this.getMessagesByParams(pageNumber, size, operatorId, dateFrom, dateTo, tariffId, stateId, regionId, null, null, null, null);
    }

    public MessagesDto getMessagesByParams(Integer pageNumber, Integer size, Long operatorId, Date dateFrom, Date dateTo, Integer tariffId, Integer stateId, Integer regionId, String payPhone, Long fgPlaceId, Long receiveId, Boolean isAdvance) {
        MessageSpecification spec8;
        MessageSpecification spec4;
        pageNumber = pageNumber == null ? PAGE_NUMBER : pageNumber;
        size = size == null ? PAGE_SIZE : size;
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)size);
        Specification spec = Specification.where(null);
        if (operatorId != null) {
            MessageSpecification spec1 = new MessageSpecification(new SearchCriteria("operatorId", ":", (Object)operatorId));
            spec = spec.and((Specification)spec1);
        }
        if (dateFrom != null) {
            MessageSpecification spec2 = new MessageSpecification(new SearchCriteria("created", ">", (Object)FormatDataTime.atStartOfDay((Date)dateFrom)));
            spec = spec.and((Specification)spec2);
        }
        if (dateTo != null) {
            MessageSpecification spec3 = new MessageSpecification(new SearchCriteria("created", "<", (Object)FormatDataTime.atEndOfDay((Date)dateTo)));
            spec = spec.and((Specification)spec3);
        }
        if (tariffId != null) {
            spec4 = new MessageSpecification(new SearchCriteria("tariffId", ":", (Object)tariffId));
            spec = spec.and((Specification)spec4);
        }
        if (stateId != null) {
            spec4 = new MessageSpecification(new SearchCriteria("stateId", ":", (Object)stateId));
            spec = spec.and((Specification)spec4);
        }
        if (regionId != null) {
            MessageSpecification spec5 = new MessageSpecification(new SearchCriteria("regionId", ":", (Object)regionId));
            spec = spec.and((Specification)spec5);
        }
        if (fgPlaceId != null) {
            MessageSpecification spec6 = new MessageSpecification(new SearchCriteria("fgPlaceId", ":", (Object)fgPlaceId));
            spec = spec.and((Specification)spec6);
        }
        if (payPhone != null) {
            MessageSpecification spec7 = new MessageSpecification(new SearchCriteria("payPhone", ":", (Object)payPhone));
            spec = spec.and((Specification)spec7);
        }
        if (receiveId != null) {
            spec8 = new MessageSpecification(new SearchCriteria("receiveId", ":", (Object)receiveId));
            spec = spec.and((Specification)spec8);
        }
        if (isAdvance != null) {
            spec8 = new MessageSpecification(new SearchCriteria("isAdvance", ":", (Object)isAdvance));
            spec = spec.and((Specification)spec8);
        }
        return new MessagesDto(this.msgMessageRepository.findAll(spec, (Pageable)pageable));
    }

    public String getNoPermissionsReasonByMessageTypeId(Integer messageTypeId, ResponseCallDto call) {
        if (call.getAbonentId() == null && call.getContractId() == null && call.getFgabonentId() == null) {
            return PermissionsDescription.NO_ABONENTS_ACCOUNT.getValue();
        }
        if (call.getFgabonentId() != null) {
            switch (messageTypeId) {
                case 1: 
                case 2: {
                    return PermissionsDescription.POST_DEPTS_MESSAGES_IS_BANNED.getValue();
                }
            }
            return PermissionsDescription.UNKNOWN_MESSAGE_TYPE.getValue();
        }
        if (messageTypeId.intValue() == MessageType.FTELEX.getValue()) {
            return PermissionsDescription.FAR_ABROAD_IS_BANNED.getValue();
        }
        if (messageTypeId != 1 && messageTypeId != 2) {
            return PermissionsDescription.UNKNOWN_MESSAGE_TYPE.getValue();
        }
        if (call.getContractId() != null) {
            if (messageTypeId.intValue() == MessageType.TELEX.getValue()) {
                return PermissionsDescription.CONTRACT_TELEGRAMS_IS_UNAVAILABLE.getValue();
            }
            return PermissionsDescription.CONTRACT_AD_IS_UNAVAILABLE.getValue();
        }
        return this.getESSAPermissionInfo(messageTypeId, call.getPayPhone());
    }

    private String getESSAPermissionInfo(Integer messageType, String payPhone) {
        Set suffixes = this.payPhoneSuffixes.stream().collect(Collectors.toSet());
        if (suffixes.contains(payPhone.substring(0, 3))) {
            HashMap<Integer, String> lResult = new HashMap<Integer, String>();
            lResult.put(0, PermissionsDescription.BILLING_CONNECTION_ERROR.getValue());
            lResult.put(1, PermissionsDescription.BILLING_NO_ABONENT_ERROR.getValue());
            lResult.put(2, PermissionsDescription.SERVICE_IS_UNAVAILABLE_DUE_TO_TARIFF.getValue());
            lResult.put(3, PermissionsDescription.SERVICE_IS_UNAVAILABLE_DUE_TO_STANDART.getValue());
            lResult.put(4, PermissionsDescription.SERVICE_IS_UNAVAILABLE_BY_UNKNOWN_REASON.getValue());
            SecureRandom rand = new SecureRandom();
            int upperbound = 5;
            int randomReason = rand.nextInt(upperbound);
            return (String)lResult.get(randomReason);
        }
        return PermissionsDescription.CAN_NOT_RECOGNIZE_ABONENT.getValue();
    }

    public ResponseEntity<MsgMessage> updateMessage(UpdateMsgMessageDto dto) throws Exception {
        this.modelMapper.getConfiguration().setSkipNullEnabled(true).setMatchingStrategy(MatchingStrategies.STRICT);
        MsgMessage message = null;
        if (dto.getId() != null) {
            Optional oMessage = this.msgMessageRepository.findById((Object)dto.getId());
            if (oMessage.isEmpty()) {
                dto.setId(null);
            } else {
                message = (MsgMessage)oMessage.get();
            }
        }
        MsgTelex telex = (MsgTelex)this.modelMapper.map((Object)dto.getTelex(), MsgTelex.class);
        if (dto.getId() == null) {
            message = (MsgMessage)this.modelMapper.map((Object)dto, MsgMessage.class);
            message.setTelex(null);
            String ipAddr = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRemoteAddr();
            message.setTerminal(ipAddr);
            message.setMsgtypeId(Integer.valueOf(MessageType.TELEX.getValue()));
            message.setCreated(new Date());
            message.setUnits(Long.valueOf(0L));
            message.setTarifCost(BigDecimal.ZERO);
            message.setExtraCost(BigDecimal.ZERO);
            message.setNdsCost(BigDecimal.ZERO);
            message.setCost(BigDecimal.ZERO);
            message.setExtracost(BigDecimal.ZERO);
            message.setNdscost(BigDecimal.ZERO);
            message.setDiscount(BigDecimal.ZERO);
            message.setDiscountExtra(BigDecimal.ZERO);
            message.setfRequest(false);
            message.setfSendRequest(false);
            message.setfMessageCopy(false);
            message.setOurCost(BigDecimal.ZERO);
            message.setOurNds(BigDecimal.ZERO);
            message.setfForward(false);
            message.setService((BillService)this.serviceRepository.findById((Object)dto.getServiceId()).orElseThrow());
            message.setOperator(this.operatorService.getOperator());
        } else {
            if (message.getMsgtypeId().intValue() != MessageType.TELEX.getValue()) {
                throw new Exception("Error! The messageTypeId is incorrect, it must be " + MessageType.TELEX.getValue() + ", but is " + message.getMsgtypeId() + "...");
            }
            if (message.isfForward()) {
                throw new Exception("Message could not be updated, the fForward flag is TRUE, must bu FALSE.");
            }
            MsgState state = message.getState() == null ? MsgState.builder().messageId(dto.getId()).build() : message.getState();
            message.setState(state);
            message.getState().setState((VocMsgState)this.vocMsgStateRepository.findById((Object)2).orElseThrow());
            message.getState().setOperatorId(this.operatorService.getOperatorId());
            message.setChanged(new Date());
            message.getState().setTlgprio(((VocTlgprio)this.tlgprioRepository.findById((Object)message.getTelex().getFirstTlgprio()).orElseThrow()).getId());
            message.setNote(dto.getNote());
            message.setNotification(dto.getNotification());
            message.setfSendRequest(dto.isFSendRequest());
            message.setService((BillService)this.serviceRepository.findById((Object)dto.getServiceId()).orElseThrow());
            if (dto.getCopyDestId() != null) {
                message.setCopyDestId(((RefCopyDest)this.copyDestRepository.findById((Object)dto.getCopyDestId()).orElseThrow()).getId());
            }
            message.setOperator(this.operatorService.getOperator());
        }
        message.setChanged(new Date());
        message = (MsgMessage)this.msgMessageRepository.save((Object)message);
        Optional msgTelex = this.telexRepository.findById((Object)message.getId());
        if (msgTelex.isPresent()) {
            telex.setId(((MsgTelex)msgTelex.get()).getId());
        }
        telex.setMessage(message);
        this.telexRepository.save((Object)telex);
        message.setTelex(telex);
        if (message.getCall() == null && this.currentCall.getCall() != null) {
            message.setCall((MsgCall)this.callRepository.findById((Object)this.currentCall.getCall().getId()).orElseThrow());
            message.setfAutoHeader(this.currentCall.getCall().getFAutoHeader().booleanValue());
        }
        this.makeTelexAddress(message);
        if (dto.getId() == null) {
            this.initMessageState(message);
            message.getTelex().setId(message.getId());
        }
        message = (MsgMessage)this.msgMessageRepository.save((Object)message);
        message = this.textFormat(message, dto);
        message.setUnits(Long.valueOf(message.getChunks().size()));
        message = (MsgMessage)this.msgMessageRepository.findById((Object)message.getId()).orElseThrow();
        this.currentCall.setMessage(message);
        message = this.calcMessageCharge(message);
        message = (MsgMessage)this.msgMessageRepository.save((Object)message);
        this.currentCall.setMessage(message);
        return ResponseEntity.ok((Object)message);
    }

    private MsgMessage textFormat(MsgMessage message, UpdateMsgMessageDto dto) {
        String text = this.telexPreFormat(dto.getMsgText());
        String firstAddress = this.telexPreFormat(message.getTelex().getFirstAddress());
        String secondAddress = this.telexPreFormat(message.getTelex().getSecondAddress());
        Long tlgPlaceNo = message.getTelex().getTlgplaceNo();
        String sign = this.telexPreFormat(message.getTelex().getSign());
        String note = this.telexPreFormat(message.getNote());
        int cAddrWords = this.countUnits(firstAddress, TextUnitType.WORDS);
        int cAddrChars = this.countUnits(firstAddress, TextUnitType.CHARS);
        int cSignWords = this.countUnits(sign, TextUnitType.WORDS);
        int cSignChars = this.countUnits(sign, TextUnitType.CHARS);
        String delim = " //.";
        StringTokenizer st = new StringTokenizer(text, " //.", true);
        int allTokensNumber = st.countTokens();
        int i = 0;
        int tc = 0;
        Object chankText = "";
        Object chunkTokens = "";
        List chunks = new ArrayList();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.matches(" |.")) {
                ++tc;
                chunkTokens = (String)chunkTokens + " " + token;
            }
            if (tc <= 300) {
                chankText = (String)chankText + token;
            }
            if (tc != 300) continue;
            chunks = this.fillChunks(message, dto, ++i, (String)chankText, (String)chunkTokens, chunks, st.countTokens() == 0);
            chankText = "";
            tc = 0;
            log.info("chunkTokens = {}", chunkTokens);
            chunkTokens = "";
        }
        chunks = this.fillChunks(message, dto, i, (String)chankText, (String)chunkTokens, chunks, true);
        long msgUnits = chunks.stream().mapToInt(chunk -> Math.toIntExact(chunk.getUnits())).sum() + cAddrWords;
        List msgChunks = (List)this.msgChunkRepository.saveAll(chunks);
        message.setChunks(msgChunks);
        message.setUnits(Long.valueOf(msgUnits));
        return (MsgMessage)this.msgMessageRepository.save((Object)message);
    }

    private List<MsgChunk> fillChunks(MsgMessage message, UpdateMsgMessageDto dto, int i, String chunkText, String chunkTokens, List<MsgChunk> chunks, boolean isLastChunk) {
        Long chunkSerialNo;
        List msgChunks = this.msgChunkRepository.getMsgChunksByMessage(message);
        if (dto.getId() != null && msgChunks.size() > 0) {
            chunkSerialNo = ((MsgChunk)msgChunks.get(0)).getSerialNo();
            msgChunks.forEach(ch -> {
                this.msgChunkRepository.deleteById((Object)ch.getId());
                log.info("Delete old chunk - {}", (Object)ch.getId());
            });
        } else {
            chunkSerialNo = this.getSerialNo();
        }
        StringTokenizer ct = new StringTokenizer(chunkTokens, ", //.\n\r");
        System.out.print("\n-------------------" + i + "/" + ct.countTokens() + "SN: " + chunkSerialNo + "----------------------\n");
        System.out.println(chunkText);
        Long prevSN = 0L;
        if (chunks.size() > 1) {
            prevSN = chunks.get(i - 1).getSerialNo();
        }
        MsgChunk chunk = MsgChunk.builder().fullText((String)(i > 1 && !isLastChunk ? "\u041f\u0420\u041e\u0414\u041e\u041b\u0416\u0415\u041d\u0418\u0415 \u0422\u0415\u041b\u0415\u0413\u0420\u0410\u041c\u041c\u042b " + prevSN + "\n" : "") + this.telexPreFormat(chunkText) + (isLastChunk ? "" : "\n\u041f\u0420\u041e\u0414\u041e\u041b\u0416\u0415\u041d\u0418\u0415 \u0421\u041b\u0415\u0414\u0423\u0415\u0422-")).text(chunkText).id(null).words(Long.valueOf(this.countUnits(chunkTokens, TextUnitType.WORDS))).chars(Long.valueOf(this.countUnits(chunkTokens, TextUnitType.CHARS))).units(Long.valueOf(this.countUnits(chunkTokens, TextUnitType.WORDS))).message(message).serialNo(chunkSerialNo).build();
        chunks.add(chunk);
        return chunks;
    }

    private String telexPreFormat(String text) {
        if (text == null) {
            return null;
        }
        text = text.toUpperCase();
        text = text.replace('\r', '\n');
        text = text.replace("!", " \u0412\u0421\u041a\u041b ");
        text = text.replace(":", " \u0414\u0412\u0422\u0427 ");
        text = text.replace('\\', '/');
        text = text.replace('\u2116', 'N');
        text = text.replace('\u042a', '\u042c');
        text = text.replace('\u0401', '\u0415');
        text = text.replace('\t', ' ');
        text = text.replace('{', '(');
        text = text.replace('}', ')');
        text = text.replace('[', '(');
        text = text.replace(']', ')');
        text = text.replaceAll("''", "\"");
        return text;
    }

    private Long getSerialNo() {
        Optional sn = this.serialRepository.findByOperatorId(this.operatorService.getOperatorId());
        if (sn.isPresent()) {
            this.serialRepository.delete((Object)((MsgSerial)sn.get()));
            this.serialRepository.flush();
            ((MsgSerial)sn.get()).setSerialNo(Long.valueOf(((MsgSerial)sn.get()).getSerialNo() + 1L));
            ((MsgSerial)sn.get()).setCreated(new Date());
            return ((MsgSerial)this.serialRepository.save((Object)((MsgSerial)sn.get()))).getSerialNo();
        }
        MsgSerial serialNo = new MsgSerial(this.operatorService.getOperatorId(), Long.valueOf(this.serialRepository.findMaxSerialNo() + 1L), new Date());
        return ((MsgSerial)this.serialRepository.save((Object)serialNo)).getSerialNo();
    }

    private int countUnits(String text, TextUnitType unitType) {
        switch (unitType.getValue()) {
            case 1: {
                return text.replaceAll("\\s|-|\\t|\\n|\\r", "").length();
            }
            case 2: {
                return new StringTokenizer(text).countTokens();
            }
        }
        return 0;
    }

    @Transactional
    public ResponseEntity<MsgMessage> saveCurrentMessage() {
        MsgTelex telex = this.currentCall.getMessage().getTelex();
        MsgState state = this.currentCall.getMessage().getState();
        List msgChunks = this.currentCall.getMessage().getChunks();
        this.currentCall.getMessage().setTelex(null);
        this.currentCall.getMessage().setState(null);
        this.currentCall.getMessage().setChunks(null);
        MsgMessage msgMessage = (MsgMessage)this.msgMessageRepository.save((Object)this.currentCall.getMessage());
        telex.setMessage(msgMessage);
        state.setMessage(msgMessage);
        msgChunks.forEach(chunk -> {
            chunk.setMessage(msgMessage);
            this.msgChunkRepository.save(chunk);
        });
        this.telexRepository.save((Object)telex);
        this.stateRepository.save((Object)state);
        this.currentCall.setMessage(msgMessage);
        this.currentCall.getMessage().setTelex(telex);
        this.currentCall.getMessage().setState(state);
        this.currentCall.getMessage().setChunks(msgChunks);
        return ResponseEntity.ok((Object)this.currentCall.getMessage());
    }

    private void initMessageState(MsgMessage message) {
        MsgState state = MsgState.builder().state((VocMsgState)this.vocMsgStateRepository.findById((Object)2).orElseThrow()).created(message.getCreated()).msgtypeId(message.getMsgtypeId()).parentId(message.getParentId()).tlgprio(message.getTelex().getFirstTlgprio()).message(message).build();
        message.setState(state);
    }

    private MsgMessage telexFormat(MsgMessage message) {
        return null;
    }

    private void makeTelexAddress(MsgMessage message) throws Exception {
        String[] p = new String[3];
        List billSvckinds = this.billSvckindRepository.findByBillServices_Id(message.getService().getId());
        Comparator<BillSvckind> comparator = Comparator.comparing(BillSvckind::getFSecond);
        billSvckinds.sort((bs1, bs2) -> Boolean.compare(bs2.getRequired(), bs1.getRequired()));
        billSvckinds.sort(comparator.reversed());
        billSvckinds.sort(Comparator.comparing(BillSvckind::getFSecond));
        billSvckinds.forEach(i -> {
            p[0] = i.getP1() != null && !i.getP1().equals(" ") ? i.getP1() : null;
            p[1] = i.getP2() != null && !i.getP2().equals(" ") ? i.getP2() : null;
            p[2] = i.getP3() != null && !i.getP3().equals(" ") ? i.getP3() : null;
        });
        1 ref = new /* Unavailable Anonymous Inner Class!! */;
        Arrays.stream(p).forEach(i -> {
            if (i != null && !i.equals(" ")) {
                ref.tlgMark = ref.tlgMark + i;
            }
        });
        if (ref.tlgMark == null) {
            throw new Exception("Error! tlgMark1 is null!");
        }
        message.getTelex().setFirstTlgprio(this.tlgprioRepository.findVocTlgprioByMark(ref.tlgMark).getId());
        billSvckinds.stream().filter(BillSvckind::getFSecond).forEach(i -> {
            p[0] = i.getP1() != null && !i.getP1().equals(" ") ? i.getP1() : null;
            p[1] = i.getP2() != null && !i.getP2().equals(" ") ? i.getP2() : null;
            p[2] = i.getP3() != null && !i.getP3().equals(" ") ? i.getP3() : null;
        });
        2 ref2 = new /* Unavailable Anonymous Inner Class!! */;
        Arrays.stream(p).forEach(i -> {
            if (i != null && !i.equals(" ")) {
                ref2.tlgMark = ref2.tlgMark + i;
            }
        });
        if (ref2.tlgMark == null) {
            throw new Exception("Error! tlgMark2 is null!");
        }
        message.getTelex().setSecondTlgprio(this.tlgprioRepository.findVocTlgprioByMark(ref2.tlgMark).getId());
        this.getNumberOfSrvKnd(message, billSvckinds);
        this.makeTelexAddressMakers(message, billSvckinds);
        message.setTelex(this.setLocationsAndForWhom(message.getTelex(), billSvckinds));
    }

    private MsgTelex setLocationsAndForWhom(MsgTelex telex, List<BillSvckind> billSvckinds) {
        Optional town = this.refTownRepository.findById((Object)telex.getTownId());
        if (town.isPresent()) {
            if (!((RefTown)town.get()).getProvince().getCountry().getName().equals("\u0420\u041e\u0421\u0421\u0418\u042f")) {
                telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), ((RefTown)town.get()).getProvince().getCountry().getName()));
                telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), ((RefTown)town.get()).getProvince().getCountry().getName()));
            }
            telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), ((RefTown)town.get()).getName()));
            telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), ((RefTown)town.get()).getName()));
            try {
                Integer.parseInt(telex.getPostend().trim());
                telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), telex.getPostend()));
                telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), telex.getPostend()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((RefTown)town.get()).getAttr() == null || !((RefTown)town.get()).getAttr().equals("\u041e")) {
                telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), ((RefTown)town.get()).getProvince().getName()));
                telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), ((RefTown)town.get()).getProvince().getName()));
            }
            if (((RefTown)town.get()).getAttr() == null || !((RefTown)town.get()).getAttr().matches("O|\u0426|U")) {
                telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), ((RefTown)town.get()).getDistrict()));
                telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), ((RefTown)town.get()).getDistrict()));
            }
            telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), telex.getStreet()));
            telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), telex.getStreet()));
        }
        billSvckinds.forEach(i -> {
            telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), i.getEndLabel() != null ? i.getEndLabel().trim().toUpperCase() : null));
            if (i.getFSecond().booleanValue()) {
                telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), i.getEndLabel() != null ? i.getEndLabel().trim().toUpperCase() : null));
            }
        });
        telex.setFirstAddress(this.concatLabel(telex.getFirstAddress(), telex.getAddressee()));
        telex.setSecondAddress(this.concatLabel(telex.getSecondAddress(), telex.getAddressee()));
        return telex;
    }

    private void makeTelexAddressMakers(MsgMessage message, List<BillSvckind> billSvckinds) {
        MsgTelex telex = message.getTelex();
        for (int i = 0; i < billSvckinds.size(); ++i) {
            telex.setFirstAddress(this.concatLabel(telex.getFirstAddress() != null ? telex.getFirstAddress() : null, billSvckinds.get(i).getStartLabel() != null ? billSvckinds.get(i).getStartLabel().trim().toUpperCase() : null));
            if (!billSvckinds.get(i).getFSecond().booleanValue()) continue;
            telex.setSecondAddress(this.concatLabel(telex.getSecondAddress() != null ? telex.getSecondAddress() : null, billSvckinds.get(i).getStartLabel() != null ? billSvckinds.get(i).getStartLabel().trim().toUpperCase() : null));
        }
        message.setTelex(telex);
    }

    private void getNumberOfSrvKnd(MsgMessage message, List<BillSvckind> billSvckinds) {
        int sServeCnt;
        int fServeCnt = billSvckinds.stream().filter(i -> i.getFSecond() == false && i.getFServe() != false).collect(Collectors.toSet()).size();
        if (fServeCnt != 0) {
            message.getTelex().setFirstAddress("\u0412\u0420\u0423\u0427\u0418\u0422\u042c " + message.getTelex().getServeDate().trim().toUpperCase());
        }
        if ((sServeCnt = billSvckinds.stream().filter(i -> i.getFSecond() != false && i.getFServe() != false).collect(Collectors.toSet()).size()) != 0) {
            message.getTelex().setSecondAddress("\u0412\u0420\u0423\u0427\u0418\u0422\u042c " + message.getTelex().getServeDate().trim().toUpperCase());
        }
    }

    private String concatLabel(String vText, String iLabel) {
        if (iLabel != null && vText != null) {
            vText = (String)vText + " ";
        }
        return (String)(vText == null ? "" : vText) + (iLabel != null ? iLabel.trim().toUpperCase() : "");
    }

    public List<ChargeDto> chargeMessage() {
        ArrayList<ChargeDto> chargeDtos = new ArrayList<ChargeDto>();
        BillPrice price = (BillPrice)this.currentCall.getMessage().getService().getTariff().getBillPrices().iterator().next();
        if (this.currentCall.getMessage().getMsgtypeId().equals(MessageType.TELEX.getValue()) || this.currentCall.getMessage().getMsgtypeId().equals(MessageType.FTELEX.getValue())) {
            ChargeDto charge = ChargeDto.builder().billPrice(price).cntUnits(this.currentCall.getMessage().getUnits().longValue()).cost(price.getExtra() == false ? price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(this.currentCall.getMessage().getUnits()))) : BigDecimal.ZERO).extra(price.getExtra() != false ? price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(this.currentCall.getMessage().getUnits()))) : BigDecimal.ZERO).msg(1L).build();
            chargeDtos.add(charge);
            return chargeDtos;
        }
        if (this.currentCall.getMessage().getMsgtypeId().equals(MessageType.ADVERT.getValue())) {
            ChargeDto charge = ChargeDto.builder().billPrice(price).cntUnits(this.currentCall.getMessage().getUnits().longValue()).cost(!price.getExtra().booleanValue() ? (!price.getCharge().booleanValue() ? price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(this.currentCall.getMessage().getUnits()))) : price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(this.currentCall.getMessage().getUnits()))).divide(BigDecimal.ONE)) : BigDecimal.ZERO).extra(price.getExtra() != false ? price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(this.currentCall.getMessage().getUnits()))) : BigDecimal.ZERO).msg(1L).build();
            chargeDtos.add(charge);
            return chargeDtos;
        }
        return null;
    }

    public void sendPaymentMessage(Long messageId) {
        Optional msgMessage = this.msgMessageRepository.findById((Object)messageId);
        if (msgMessage.isPresent()) {
            MsgState state = ((MsgMessage)msgMessage.get()).getState();
            state.setState((VocMsgState)this.vocMsgStateRepository.getReferenceById((Object)MessageState.MSG_STATE_QUEUE.getValue()));
            this.stateRepository.save((Object)state);
        }
    }

    public void setFgNoteForMessage(Long messageId, String fgNote) {
        Optional msgMessage = this.msgMessageRepository.findById((Object)messageId);
        if (msgMessage.isPresent()) {
            ((MsgMessage)msgMessage.get()).setFgnote(fgNote);
            this.msgMessageRepository.save((Object)((MsgMessage)msgMessage.get()));
        }
    }

    public void setCurrentFgNoteForMessage(String fgNote) throws Exception {
        if (this.currentCall == null || this.currentCall.getMessage() == null) {
            throw new Exception("Error! Current Call or Current message is null ...");
        }
        this.currentCall.getMessage().setFgnote(fgNote);
    }

    public MsgMessage calcMessageCharge(MsgMessage message) {
        message.setCost(BigDecimal.ZERO);
        message.setExtracost(BigDecimal.ZERO);
        message.setExtraCost(BigDecimal.ZERO);
        message.setTarifCost(BigDecimal.ZERO);
        message.setDiscount(BigDecimal.ZERO);
        message.setBillChargeDetails(null);
        message = (MsgMessage)this.msgMessageRepository.save((Object)message);
        if (message.getCall() != null) {
            if (message.getMsgtypeId().intValue() == MessageType.TELEX.getValue() || message.getMsgtypeId().intValue() == MessageType.FTELEX.getValue()) {
                message.setBillChargeDetails(this.calcTelexCharge(message));
            }
            if (message.getMsgtypeId().intValue() == MessageType.ADVERT.getValue()) {
                message.setBillChargeDetails(this.calcAdvertCharge(message));
            }
        }
        return (MsgMessage)this.msgMessageRepository.save((Object)message);
    }

    private Set<BillChargeDetail> calcAdvertCharge(MsgMessage message) {
        List billPrices = this.billPriceRepository.findTopBillPriceByTarif_Id(message.getService().getTariff().getId());
        HashSet<BillChargeDetail> chargeDetails = new HashSet<BillChargeDetail>();
        Optional releaseCount = this.msgAdvertRepository.findById((Object)message.getId());
        if (releaseCount.isPresent()) {
            List list = ((MsgAdvert)releaseCount.get()).getRelease().getList();
        }
        billPrices.forEach(price -> {
            BillChargeDetail detail = new BillChargeDetail();
            detail.setAbochargeId(null);
            detail.setfSubstract(Boolean.valueOf(false));
            detail.setOperatorId(message.getCall().getOperatorId());
            detail.setfCanceled(Boolean.valueOf(false));
            detail.setBillCost(price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(message.getUnits()))));
            detail.setPriceId(price.getId());
            detail.setBillingCode(Long.valueOf(price.getBillingCode() == null ? 0L : price.getBillingCode()));
            chargeDetails.add(detail);
        });
        return chargeDetails;
    }

    private Set<BillChargeDetail> calcTelexCharge(MsgMessage message) {
        List billPrices = this.billPriceRepository.findTopBillPriceByTarif_Id(message.getService().getTariff().getId());
        HashSet<BillChargeDetail> chargeDetails = new HashSet<BillChargeDetail>();
        billPrices.forEach(price -> {
            BillChargeDetail detail = new BillChargeDetail();
            detail.setAbochargeId(null);
            detail.setfSubstract(Boolean.valueOf(false));
            detail.setOperatorId(message.getCall().getOperatorId());
            detail.setfCanceled(Boolean.valueOf(false));
            detail.setBillCost(price.get_const().add(price.getMult().multiply(BigDecimal.valueOf(message.getUnits()))));
            detail.setPriceId(price.getId());
            detail.setBillingCode(Long.valueOf(price.getBillingCode() == null ? 0L : price.getBillingCode()));
            chargeDetails.add(detail);
        });
        return chargeDetails;
    }
}

