/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.asw.telegrammodule.beans.CurrentCall;
import ru.asw.telegrammodule.dto.CallRequestDto;
import ru.asw.telegrammodule.dto.ResponseCallDto;
import ru.asw.telegrammodule.entity.Operator;
import ru.asw.telegrammodule.entity.coretlx.BillPayPhone;
import ru.asw.telegrammodule.entity.coretlx.MsgCall;
import ru.asw.telegrammodule.entity.coretlx.RefFgplace;
import ru.asw.telegrammodule.entity.coretlx.VocFgabonent;
import ru.asw.telegrammodule.entity.coretlx.VocFgregion;
import ru.asw.telegrammodule.entity.type.Restriction;
import ru.asw.telegrammodule.enums.MessageType;
import ru.asw.telegrammodule.repository.BillPayPhoneRepository;
import ru.asw.telegrammodule.repository.MsgCallRepository;
import ru.asw.telegrammodule.repository.RefClientcategoryRepository;
import ru.asw.telegrammodule.repository.RefFgplaceRepository;
import ru.asw.telegrammodule.repository.VocFgabonentRepository;
import ru.asw.telegrammodule.repository.VocFgregionRepository;
import ru.asw.telegrammodule.service.CallService;
import ru.asw.telegrammodule.service.MessageService;
import ru.asw.telegrammodule.service.OperatorService;

@Service
public class CallServiceImpl
implements CallService {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private OperatorService operatorService;
    private MsgCallRepository msgCallRepository;
    private BillPayPhoneRepository billPayPhoneRepository;
    private RefClientcategoryRepository clientcategoryRepository;
    private VocFgabonentRepository fgabonentRepository;
    private MessageService messageService;
    private ModelMapper modelMapper;
    private RefFgplaceRepository fgplaceRepository;
    private VocFgregionRepository fgregionRepository;
    @Autowired
    @Qualifier(value="currentCall")
    private CurrentCall currentCall;

    public CallServiceImpl(MsgCallRepository callRepository, OperatorService operatorService, BillPayPhoneRepository billPayPhoneRepository, RefClientcategoryRepository clientcategoryRepository, VocFgabonentRepository fgabonentRepository, MessageService messageService, ModelMapper modelMapper, RefFgplaceRepository fgplaceRepository, VocFgregionRepository fgregionRepository) {
        this.msgCallRepository = callRepository;
        this.operatorService = operatorService;
        this.billPayPhoneRepository = billPayPhoneRepository;
        this.clientcategoryRepository = clientcategoryRepository;
        this.fgabonentRepository = fgabonentRepository;
        this.messageService = messageService;
        this.modelMapper = modelMapper;
        this.fgplaceRepository = fgplaceRepository;
        this.fgregionRepository = fgregionRepository;
    }

    @Transactional
    public MsgCall createOrUpdateCall(Long callId, CallRequestDto dto, boolean isFgCall) {
        MsgCall msgCall = new MsgCall();
        Operator operator = this.operatorService.getOperator();
        if (callId == null) {
            if (!isFgCall) {
                msgCall.setFgplaceId(operator.getPlaceId());
                msgCall.setFgplaceNum(operator.getPlaceNum());
            } else {
                msgCall.setFgplaceId(dto.getFgPlaceId());
                msgCall.setFgplaceNum(dto.getFgAbonentId().toString());
            }
            msgCall.setCreated(new Date());
        } else {
            Optional msgCallOptional = this.msgCallRepository.findById((Object)callId);
            if (msgCallOptional.isPresent()) {
                msgCall = (MsgCall)msgCallOptional.get();
            } else {
                return null;
            }
        }
        if (!isFgCall) {
            msgCall.setReceiveId(Long.valueOf(1L));
            msgCall.setfAutoHeader(Boolean.valueOf(true));
            msgCall.setReverseCall(Boolean.valueOf(dto.isReverseCall()));
            if (dto.getContractNumber() == null) {
                BillPayPhone billPayPhone = this.billPayPhoneRepository.findByAonPhone(dto.getCallPhone());
                msgCall.setPayPhone(billPayPhone == null ? dto.getCallPhone() : billPayPhone.getAbonentPhone());
            } else {
                msgCall.setContractNo(dto.getContractNumber());
                msgCall.setRegionId(dto.getRegionId());
            }
            msgCall.setChargeNds(Boolean.valueOf(false));
            msgCall.setAbonentId("363000501073");
            msgCall.setName("\u041c\u0418\u041d\u0418\u0421\u0422\u0415\u0420\u0421\u0422\u0412\u041e \u0423\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u0424\u0418\u041d\u0410\u041d\u0421\u0410\u041c\u0418 \u0421\u0410\u041c\u0410\u0420\u0421\u041a\u041e\u0419 \u041e\u0411\u041b\u0410\u0421\u0422\u0418");
            msgCall.setAddress("443006 \u0433. \u0421\u0410\u041c\u0410\u0420\u0410 \u0443\u043b. \u041c\u041e\u041b\u041e\u0414\u041e\u0413\u0412\u0410\u0420\u0414\u0415\u0419\u0421\u041a\u0410\u042f 210");
            msgCall.setjAddress("443006 \u0433. \u0421\u0410\u041c\u0410\u0420\u0410 \u0443\u043b. \u041c\u041e\u041b\u041e\u0414\u041e\u0413\u0412\u0410\u0420\u0414\u0415\u0419\u0421\u041a\u0410\u042f 210");
            msgCall.setInn("6315802231");
            msgCall.setKpp("631501001");
            msgCall.setContractId(dto.getContractNumber() != null ? Long.valueOf(11111L) : null);
            msgCall.setRegionId(Long.valueOf(1L));
            if (dto.getCallPhone().startsWith("343")) {
                msgCall.setfAvance(Boolean.valueOf(false));
            } else {
                msgCall.setfAvance(Boolean.valueOf(true));
            }
        } else {
            Optional fgregion;
            VocFgabonent vocFgabonent = (VocFgabonent)this.fgabonentRepository.findById((Object)dto.getFgAbonentId()).get();
            RefFgplace fgPlace = (RefFgplace)this.fgplaceRepository.findById((Object)dto.getFgPlaceId()).get();
            msgCall.setFgabonentId(dto.getFgAbonentId());
            msgCall.setName(fgPlace.getName());
            msgCall.setAddress(fgPlace.getTelexTown());
            msgCall.setRegionId(fgPlace.getRegionId());
            msgCall.setReceiveId(vocFgabonent.getReceiveId());
            msgCall.setfAutoHeader(vocFgabonent.getFAutoHeader());
            msgCall.setChargeNds(Boolean.valueOf(this.isChargeNds(vocFgabonent.getClientcat())));
            msgCall.setPayPhone(null);
            msgCall.setAbonentId(null);
            if (dto.getCallPhone().startsWith("343")) {
                msgCall.setfAvance(Boolean.valueOf(false));
            } else {
                msgCall.setfAvance(Boolean.valueOf(true));
            }
            if (msgCall.getRegionId() != null && msgCall.getFgabonentId() != null && (fgregion = this.fgregionRepository.findByRegionIdAndFgabonentId(msgCall.getRegionId(), msgCall.getFgabonentId())).isPresent()) {
                msgCall.setPayPhone(((VocFgregion)fgregion.get()).getPayPhone());
                msgCall.setAbonentId(((VocFgregion)fgregion.get()).getAbonentId());
            }
        }
        msgCall.setCallPhone(dto.getCallPhone());
        msgCall.setAonPhone(dto.getAonPhone());
        msgCall.setChanged(new Date());
        msgCall.setOperatorId(operator.getId());
        return (MsgCall)this.msgCallRepository.save((Object)msgCall);
    }

    public ResponseCallDto createCall(CallRequestDto callRequestDto, boolean isFgCall) {
        ResponseCallDto dto = this.convertToDto(this.createOrUpdateCall(null, callRequestDto, isFgCall));
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        restrictions.add(new Restriction(Integer.valueOf(MessageType.TELEX.getValue()), this.messageService.getNoPermissionsReasonByMessageTypeId(Integer.valueOf(MessageType.TELEX.getValue()), dto)));
        restrictions.add(new Restriction(Integer.valueOf(MessageType.ADVERT.getValue()), this.messageService.getNoPermissionsReasonByMessageTypeId(Integer.valueOf(MessageType.ADVERT.getValue()), dto)));
        dto.setRestrictions(restrictions);
        this.currentCall.setCall(dto);
        this.logger.info("Create new Call ...");
        return this.currentCall.getCall();
    }

    public ResponseEntity dropCall(ResponseCallDto msgCall) {
        if (msgCall != null) {
            Optional call = this.msgCallRepository.findById((Object)msgCall.getId());
            if (call.isPresent()) {
                ((MsgCall)call.get()).setCompleted(new Date());
                this.msgCallRepository.save((Object)((MsgCall)call.get()));
                this.logger.info("Complete call with Id - {} ...", (Object)msgCall.getId());
            }
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    public void checkAndDropCurrentCall(Long operatorId) {
        List msgCallList = this.msgCallRepository.findAllByOperatorIdAndCompletedIsNull(operatorId);
        msgCallList.forEach(i -> i.setCompleted(new Date()));
        this.msgCallRepository.saveAll((Iterable)msgCallList);
        this.currentCall = new CurrentCall();
    }

    private ResponseCallDto convertToDto(MsgCall call) {
        ResponseCallDto postDto = (ResponseCallDto)this.modelMapper.map((Object)call, ResponseCallDto.class);
        return postDto;
    }

    private boolean isChargeNds(String clientCat) {
        ArrayList<Integer> catIds = new ArrayList<Integer>();
        String[] arrayCat = clientCat.split(",");
        for (int i2 = 0; i2 < arrayCat.length; ++i2) {
            catIds.add(Integer.valueOf(arrayCat[i2].replaceAll("[^\\d]", "")));
        }
        return this.clientcategoryRepository.findAllById(catIds).stream().anyMatch(i -> i.getChargeNds());
    }
}

