/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import ru.asw.telegrammodule.entity.Operator;
import ru.asw.telegrammodule.repository.OperatorRepository;

@Service
public class OperatorService {
    @Autowired
    private OperatorRepository operatorRepository;

    public String getCurrentOperatorLogin() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String operatorName = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return operatorName;
    }

    public Long getOperatorId() {
        return this.operatorRepository.findUserByLogin(this.getCurrentOperatorLogin()).getId();
    }

    public Operator findOperatorByLogin(String login) {
        return this.operatorRepository.findUserByLogin(login);
    }

    public Operator getOperator() {
        return this.operatorRepository.findUserByLogin(this.getCurrentOperatorLogin());
    }
}

