/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.entity.coretlx;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.asw.telegrammodule.entity.Operator;
import ru.asw.telegrammodule.entity.coretlx.BillChargeDetail;
import ru.asw.telegrammodule.entity.coretlx.BillService;
import ru.asw.telegrammodule.entity.coretlx.MsgAdvert;
import ru.asw.telegrammodule.entity.coretlx.MsgCall;
import ru.asw.telegrammodule.entity.coretlx.MsgChunk;
import ru.asw.telegrammodule.entity.coretlx.MsgMessage;
import ru.asw.telegrammodule.entity.coretlx.MsgState;
import ru.asw.telegrammodule.entity.coretlx.MsgTelex;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Entity
@Table(name="msg_message")
public class MsgMessage {
    @Id
    @SequenceGenerator(name="msg_message_seq", sequenceName="msg_message_seq", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="msg_message_seq")
    @Column(name="message_id", nullable=false)
    private Long id;
    @Column(name="note", length=150)
    private String note;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created")
    private Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="closed")
    private Date closed;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="operator_id")
    private Operator operator;
    @Column(name="units", nullable=false)
    private Long units;
    @Column(name="terminal", length=80)
    private String terminal;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="service_id")
    private BillService service;
    @Column(name="cost", nullable=false, precision=15, scale=2)
    private BigDecimal cost;
    @Column(name="extracost", nullable=false, precision=15, scale=2)
    private BigDecimal extracost;
    @Column(name="ndscost", nullable=false, precision=15, scale=2)
    private BigDecimal ndscost;
    @Column(name="msgtype_id", nullable=false)
    private Integer msgtypeId;
    @Column(name="our_cost", precision=15, scale=2)
    private BigDecimal ourCost;
    @Column(name="our_nds", precision=15, scale=2)
    private BigDecimal ourNds;
    @Column(name="discount", nullable=false, precision=15, scale=2)
    private BigDecimal discount;
    @Column(name="discount_extra", nullable=false, precision=15, scale=2)
    private BigDecimal discountExtra;
    @Column(name="changed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date changed;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="call_id")
    private MsgCall call;
    @Column(name="notification", length=200)
    private String notification;
    @Column(name="f_request", nullable=false)
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean fRequest;
    @Column(name="copy_dest_id")
    private Integer copyDestId;
    @Column(name="f_send_request", nullable=false)
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean fSendRequest;
    @Column(name="parent_id")
    private Long parentId;
    @Column(name="f_message_copy", nullable=false)
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean fMessageCopy;
    @Column(name="f_auto_header", nullable=false)
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean fAutoHeader;
    @Column(name="f_forward", nullable=false)
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean fForward;
    @Column(name="tlgplace_no")
    private Long tlgplaceNo;
    @Column(name="fgnote", length=150)
    private String fgnote;
    @Column(name="tarif_cost", nullable=false, precision=15, scale=2)
    private BigDecimal tarifCost;
    @Column(name="extra_cost", nullable=false, precision=15, scale=2)
    private BigDecimal extraCost;
    @Column(name="nds_cost", nullable=false, precision=15, scale=2)
    private BigDecimal ndsCost;
    @OneToMany(mappedBy="message")
    private List<MsgChunk> chunks;
    @JsonProperty(value="state")
    @OneToOne(mappedBy="message", cascade={CascadeType.ALL})
    private MsgState state;
    @JsonProperty(value="advert")
    @OneToOne(mappedBy="message", cascade={CascadeType.ALL})
    private MsgAdvert advert;
    @JsonProperty(value="telex")
    @OneToOne(mappedBy="message", cascade={CascadeType.ALL})
    private MsgTelex telex;
    @ElementCollection
    @CollectionTable(name="bill_charge_detail", joinColumns={@JoinColumn(name="message_id")})
    @AttributeOverrides(value={@AttributeOverride(name="billCost", column=@Column(name="cost"))})
    private Set<BillChargeDetail> billChargeDetails;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getClosed() {
        return this.closed;
    }

    public void setClosed(Date closed) {
        this.closed = closed;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Long getUnits() {
        return this.units;
    }

    public void setUnits(Long units) {
        this.units = units;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public BillService getService() {
        return this.service;
    }

    public void setService(BillService service) {
        this.service = service;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getExtracost() {
        return this.extracost;
    }

    public void setExtracost(BigDecimal extracost) {
        this.extracost = extracost;
    }

    public BigDecimal getNdscost() {
        return this.ndscost;
    }

    public void setNdscost(BigDecimal ndscost) {
        this.ndscost = ndscost;
    }

    public Integer getMsgtypeId() {
        return this.msgtypeId;
    }

    public void setMsgtypeId(Integer msgtypeId) {
        this.msgtypeId = msgtypeId;
    }

    public BigDecimal getOurCost() {
        return this.ourCost;
    }

    public void setOurCost(BigDecimal ourCost) {
        this.ourCost = ourCost;
    }

    public BigDecimal getOurNds() {
        return this.ourNds;
    }

    public void setOurNds(BigDecimal ourNds) {
        this.ourNds = ourNds;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getDiscountExtra() {
        return this.discountExtra;
    }

    public void setDiscountExtra(BigDecimal discountExtra) {
        this.discountExtra = discountExtra;
    }

    public Date getChanged() {
        return this.changed;
    }

    public void setChanged(Date changed) {
        this.changed = changed;
    }

    public MsgCall getCall() {
        return this.call;
    }

    public void setCall(MsgCall call) {
        this.call = call;
    }

    public String getNotification() {
        return this.notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public boolean isfRequest() {
        return this.fRequest;
    }

    public void setfRequest(boolean fRequest) {
        this.fRequest = fRequest;
    }

    public Integer getCopyDestId() {
        return this.copyDestId;
    }

    public void setCopyDestId(Integer copyDestId) {
        this.copyDestId = copyDestId;
    }

    public boolean isfSendRequest() {
        return this.fSendRequest;
    }

    public void setfSendRequest(boolean fSendRequest) {
        this.fSendRequest = fSendRequest;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean isfMessageCopy() {
        return this.fMessageCopy;
    }

    public void setfMessageCopy(boolean fMessageCopy) {
        this.fMessageCopy = fMessageCopy;
    }

    public boolean isfAutoHeader() {
        return this.fAutoHeader;
    }

    public void setfAutoHeader(boolean fAutoHeader) {
        this.fAutoHeader = fAutoHeader;
    }

    public boolean isfForward() {
        return this.fForward;
    }

    public void setfForward(boolean fForward) {
        this.fForward = fForward;
    }

    public Long getTlgplaceNo() {
        return this.tlgplaceNo;
    }

    public void setTlgplaceNo(Long tlgplaceNo) {
        this.tlgplaceNo = tlgplaceNo;
    }

    public String getFgnote() {
        return this.fgnote;
    }

    public void setFgnote(String fgnote) {
        this.fgnote = fgnote;
    }

    public BigDecimal getTarifCost() {
        return this.tarifCost;
    }

    public void setTarifCost(BigDecimal tarifCost) {
        this.tarifCost = tarifCost;
    }

    public BigDecimal getExtraCost() {
        return this.extraCost;
    }

    public void setExtraCost(BigDecimal extraCost) {
        this.extraCost = extraCost;
    }

    public BigDecimal getNdsCost() {
        return this.ndsCost;
    }

    public void setNdsCost(BigDecimal ndsCost) {
        this.ndsCost = ndsCost;
    }

    public List<MsgChunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<MsgChunk> chunks) {
        this.chunks = chunks;
    }

    public MsgState getState() {
        return this.state;
    }

    public void setState(MsgState state) {
        this.state = state;
    }

    public MsgAdvert getAdvert() {
        return this.advert;
    }

    public void setAdvert(MsgAdvert advert) {
        this.advert = advert;
    }

    public MsgTelex getTelex() {
        return this.telex;
    }

    public void setTelex(MsgTelex telex) {
        this.telex = telex;
    }

    public Set<BillChargeDetail> getBillChargeDetails() {
        return this.billChargeDetails;
    }

    public void setBillChargeDetails(Set<BillChargeDetail> billChargeDetails) {
        this.billChargeDetails = billChargeDetails;
    }

    public static MsgMessageBuilder builder() {
        return new MsgMessageBuilder();
    }

    public MsgMessage(Long id, String note, Date created, Date closed, Operator operator, Long units, String terminal, BillService service, BigDecimal cost, BigDecimal extracost, BigDecimal ndscost, Integer msgtypeId, BigDecimal ourCost, BigDecimal ourNds, BigDecimal discount, BigDecimal discountExtra, Date changed, MsgCall call, String notification, boolean fRequest, Integer copyDestId, boolean fSendRequest, Long parentId, boolean fMessageCopy, boolean fAutoHeader, boolean fForward, Long tlgplaceNo, String fgnote, BigDecimal tarifCost, BigDecimal extraCost, BigDecimal ndsCost, List<MsgChunk> chunks, MsgState state, MsgAdvert advert, MsgTelex telex, Set<BillChargeDetail> billChargeDetails) {
        this.id = id;
        this.note = note;
        this.created = created;
        this.closed = closed;
        this.operator = operator;
        this.units = units;
        this.terminal = terminal;
        this.service = service;
        this.cost = cost;
        this.extracost = extracost;
        this.ndscost = ndscost;
        this.msgtypeId = msgtypeId;
        this.ourCost = ourCost;
        this.ourNds = ourNds;
        this.discount = discount;
        this.discountExtra = discountExtra;
        this.changed = changed;
        this.call = call;
        this.notification = notification;
        this.fRequest = fRequest;
        this.copyDestId = copyDestId;
        this.fSendRequest = fSendRequest;
        this.parentId = parentId;
        this.fMessageCopy = fMessageCopy;
        this.fAutoHeader = fAutoHeader;
        this.fForward = fForward;
        this.tlgplaceNo = tlgplaceNo;
        this.fgnote = fgnote;
        this.tarifCost = tarifCost;
        this.extraCost = extraCost;
        this.ndsCost = ndsCost;
        this.chunks = chunks;
        this.state = state;
        this.advert = advert;
        this.telex = telex;
        this.billChargeDetails = billChargeDetails;
    }

    public MsgMessage() {
    }
}

