/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.entity.coretlx;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ru.asw.telegrammodule.entity.coretlx.MsgChunk;
import ru.asw.telegrammodule.entity.coretlx.MsgMessage;
import ru.asw.telegrammodule.entity.coretlx.MsgRawtelex;
import ru.asw.telegrammodule.enums.MessageType;
import ru.asw.telegrammodule.utils.MessageUtils;

@Entity
@Table(name="msg_chunk")
@JsonIgnoreProperties(value={"message"})
public class MsgChunk {
    @Id
    @SequenceGenerator(name="msg_chunk_seq", sequenceName="msg_chunk_seq", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="msg_chunk_seq")
    @Column(name="chunk_id", nullable=false)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="message_id")
    private MsgMessage message;
    @Column(name="text", length=4000)
    private String text;
    @Column(name="full_text", length=4000)
    private String fullText;
    @Transient
    private String resolvedFullText;
    @Column(name="header", length=400)
    private String header;
    @Column(name="serial_no", nullable=false)
    private Long serialNo;
    @Column(name="units")
    private Long units;
    @Column(name="words")
    private Long words;
    @Column(name="chars")
    private Long chars;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="sended")
    private Date sent;
    @Column(name="tlg_chanell", length=6)
    private String tlgChanell;
    @Column(name="sector", length=10)
    private String sector;
    @Column(name="chanell_no")
    private Long chanellNo;
    @Column(name="full_serial", length=50)
    private String fullSerial;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="chunk")
    private MsgRawtelex msgRawtelex;

    public String getResolvedFullText() {
        if (this.message.getState().getMsgtypeId() != null && this.message.getState().getMsgtypeId().intValue() == MessageType.TELEX.getValue()) {
            return MessageUtils.resolveChunk((String)((this.header == null ? "" : this.header) + Character.toString(13) + Character.toString(10) + Character.toString(10) + this.fullText + Character.toString(13) + Character.toString(10)));
        }
        return MessageUtils.resolveChunk((String)((this.header == null ? "" : this.header) + Character.toString(13) + Character.toString(10) + Character.toString(10) + Character.toString(10) + Character.toString(10) + this.fullText + Character.toString(13) + Character.toString(10)));
    }

    public MsgChunk() {
    }

    public MsgChunk(Long id, MsgMessage message, String text, String fullText, String resolvedFullText, String header, Long serialNo, Long units, Long words, Long chars, Date sent, String tlgChanell, String sector, Long chanellNo, String fullSerial, MsgRawtelex msgRawtelex) {
        this.id = id;
        this.message = message;
        this.text = text;
        this.fullText = fullText;
        this.resolvedFullText = resolvedFullText;
        this.header = header;
        this.serialNo = serialNo;
        this.units = units;
        this.words = words;
        this.chars = chars;
        this.sent = sent;
        this.tlgChanell = tlgChanell;
        this.sector = sector;
        this.chanellNo = chanellNo;
        this.fullSerial = fullSerial;
        this.msgRawtelex = msgRawtelex;
    }

    public static MsgChunkBuilder builder() {
        return new MsgChunkBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public MsgMessage getMessage() {
        return this.message;
    }

    public String getText() {
        return this.text;
    }

    public String getFullText() {
        return this.fullText;
    }

    public String getHeader() {
        return this.header;
    }

    public Long getSerialNo() {
        return this.serialNo;
    }

    public Long getUnits() {
        return this.units;
    }

    public Long getWords() {
        return this.words;
    }

    public Long getChars() {
        return this.chars;
    }

    public Date getSent() {
        return this.sent;
    }

    public String getTlgChanell() {
        return this.tlgChanell;
    }

    public String getSector() {
        return this.sector;
    }

    public Long getChanellNo() {
        return this.chanellNo;
    }

    public String getFullSerial() {
        return this.fullSerial;
    }

    public MsgRawtelex getMsgRawtelex() {
        return this.msgRawtelex;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMessage(MsgMessage message) {
        this.message = message;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public void setResolvedFullText(String resolvedFullText) {
        this.resolvedFullText = resolvedFullText;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setSerialNo(Long serialNo) {
        this.serialNo = serialNo;
    }

    public void setUnits(Long units) {
        this.units = units;
    }

    public void setWords(Long words) {
        this.words = words;
    }

    public void setChars(Long chars) {
        this.chars = chars;
    }

    public void setSent(Date sent) {
        this.sent = sent;
    }

    public void setTlgChanell(String tlgChanell) {
        this.tlgChanell = tlgChanell;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public void setChanellNo(Long chanellNo) {
        this.chanellNo = chanellNo;
    }

    public void setFullSerial(String fullSerial) {
        this.fullSerial = fullSerial;
    }

    public void setMsgRawtelex(MsgRawtelex msgRawtelex) {
        this.msgRawtelex = msgRawtelex;
    }
}

