/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.convertor;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.persistence.AttributeConverter;
import ru.asw.telegrammodule.entity.AdvertReleases;

public class AdvertReleaseConvertor
implements AttributeConverter<AdvertReleases, String> {
    private static final String SEPARATOR = "\"\",\"\"";
    private static final String START_WITH = "(\"{\"\"";
    private static final String END_WITH = "\"\"}\")";
    private static final String COMMA = ",";
    private static final String REPLACE_PATTERN = "[\"({})]";

    public String convertToDatabaseColumn(AdvertReleases releases) {
        if (releases == null || releases.getList().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(START_WITH);
        for (int i = 0; i < releases.getList().size() - 1; ++i) {
            sb.append(releases.getList().get(i));
            if (i >= releases.getList().size() - 1) continue;
            sb.append(SEPARATOR);
        }
        sb.append(END_WITH);
        return sb.toString();
    }

    public AdvertReleases convertToEntityAttribute(String dbReleases) {
        if ((dbReleases = dbReleases.replaceAll(REPLACE_PATTERN, "")) == null || dbReleases.isEmpty()) {
            return null;
        }
        String[] releasesArray = dbReleases.split(COMMA);
        AdvertReleases advertReleases = new AdvertReleases();
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (int i = 0; i < releasesArray.length; ++i) {
            LocalDateTime dateTime = null;
            try {
                dateTime = LocalDateTime.parse(releasesArray[i], formatter);
            }
            catch (Exception e) {
                releasesArray[i] = releasesArray[i].replace("T", " ");
                dateTime = LocalDateTime.parse(releasesArray[i], formatter1);
            }
            list.add(dateTime);
        }
        advertReleases.setList(list);
        return advertReleases;
    }
}

