/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.entity.coretlx.VocTlgprio;
import ru.asw.telegrammodule.repository.VocTlgprioRepository;

@RestController
@RequestMapping(value={"/voc"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="tlgprio")
public class VocTlgprioController {
    private VocTlgprioRepository repository;

    public VocTlgprioController(VocTlgprioRepository repository) {
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 Tlgprio")
    @GetMapping(value={"/tlgprios"})
    public List<VocTlgprio> getAll() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 Tlgprio \u043f\u043e ID")
    @GetMapping(value={"/tlgprios/{id}"})
    public VocTlgprio getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional vocTlgprio = this.repository.findById((Object)id);
        if (vocTlgprio.isPresent()) {
            return (VocTlgprio)vocTlgprio.get();
        }
        return null;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 VocTlgprio \u043f\u043e ID")
    @DeleteMapping(value={"/tlgprios/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oVocTlgprio = this.repository.findById((Object)id);
        if (oVocTlgprio.isPresent()) {
            this.repository.deleteById((Object)id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 VocTlgprio \u043f\u043e ID")
    @PutMapping(value={"/tlgprios/{id}"})
    public ResponseEntity<VocTlgprio> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody VocTlgprio vocTlgprio) {
        Optional oVocTlgprio = this.repository.findById((Object)id);
        if (oVocTlgprio.isPresent()) {
            VocTlgprio vocTlgprioUpd = vocTlgprio;
            vocTlgprioUpd.setId(id);
            return ResponseEntity.ok((Object)((VocTlgprio)this.repository.save((Object)vocTlgprioUpd)));
        }
        return ResponseEntity.notFound().build();
    }
}

