/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.entity.coretlx.RefFgplace;
import ru.asw.telegrammodule.repository.RefFgplaceRepository;

@RestController
@RequestMapping(value={"/ref/"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="fgPlace")
public class RefFgPlaceController {
    private RefFgplaceRepository refFgplaceRepository;

    public RefFgPlaceController(RefFgplaceRepository repository) {
        this.refFgplaceRepository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefFgPlace \u043f\u043e \u0418\u0414 \u0440\u0435\u0433\u0438\u043e\u043d\u0430 (OPER_ABONENT_PKG.FGPLACE_SEL)")
    @GetMapping(value={"/fgPlaces/search"})
    public List<RefFgplace> getAllByRegionId(@RequestParam(value="regionId", required=false) Long regionId) {
        if (regionId == null) {
            return this.refFgplaceRepository.findAllByClosedIsNullOrderByName();
        }
        return this.refFgplaceRepository.findAllByRegionIdAndClosedIsNullOrderByName(regionId);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefFgPlace \u043f\u043e \u0418\u0414")
    @GetMapping(value={"/fgPlaces/{id}"})
    public RefFgplace getAllByfgPlacesId(@PathVariable(value="id", required=false) Long id) {
        return this.refFgplaceRepository.findRefFgplaceById(id);
    }
}

