/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.CreateRefCopyDestDto;
import ru.asw.telegrammodule.entity.coretlx.RefCopyDest;
import ru.asw.telegrammodule.repository.RefCopyDestRepository;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/ref"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="copyDest")
public class RefCopyDestController {
    private OperatorService operatorService;
    private ModelMapper modelMapper;
    private RefCopyDestRepository repository;

    public RefCopyDestController(OperatorService operatorService, ModelMapper modelMapper, RefCopyDestRepository repository) {
        this.operatorService = operatorService;
        this.modelMapper = modelMapper;
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefCopyDest")
    @GetMapping(value={"/copyDests"})
    public List<RefCopyDest> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefCopyDest")
    @GetMapping(value={"/copyDests/adm"})
    public List<RefCopyDest> getAllForAdmin() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefCopyDest \u043f\u043e ID")
    @GetMapping(value={"/copyDests/{id}"})
    public RefCopyDest getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id) {
        Optional refCopyDest = this.repository.findById((Object)id);
        return refCopyDest.orElse(null);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefCopyDest \u043f\u043e ID")
    @DeleteMapping(value={"/copyDests/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id) {
        Optional oRefCopyDest = this.repository.findById((Object)id);
        if (oRefCopyDest.isPresent()) {
            RefCopyDest refCopyDest = (RefCopyDest)oRefCopyDest.get();
            refCopyDest.setClosed(new Date());
            this.repository.save((Object)refCopyDest);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefCopyDest \u043f\u043e ID")
    @PutMapping(value={"/copyDests/{id}"})
    public ResponseEntity<RefCopyDest> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id, @RequestBody RefCopyDest refCopyDest) {
        Optional oRefCopyDest = this.repository.findById((Object)id);
        if (oRefCopyDest.isPresent()) {
            RefCopyDest refCopyDestUpd = refCopyDest;
            refCopyDestUpd.setId(id);
            refCopyDest.setChanged(new Date());
            return ResponseEntity.ok((Object)((RefCopyDest)this.repository.save((Object)refCopyDestUpd)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 RefCopyDest")
    @PostMapping(value={"/copyDests"})
    public ResponseEntity<RefCopyDest> save(@RequestBody CreateRefCopyDestDto dto) {
        RefCopyDest refCopyDest = this.convertFromDto(dto);
        refCopyDest.setCreated(new Date());
        refCopyDest.setOperatorId(this.operatorService.getOperatorId());
        return ResponseEntity.ok((Object)((RefCopyDest)this.repository.save((Object)refCopyDest)));
    }

    private RefCopyDest convertFromDto(CreateRefCopyDestDto dto) {
        RefCopyDest refCopyDest = (RefCopyDest)this.modelMapper.map((Object)dto, RefCopyDest.class);
        return refCopyDest;
    }
}

