/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.entity.coretlx.RefClientcategory;
import ru.asw.telegrammodule.repository.RefClientcategoryRepository;

@RestController
@RequestMapping(value={"/ref"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="clientcategory")
public class RefClientcategoryController {
    private RefClientcategoryRepository repository;

    public RefClientcategoryController(RefClientcategoryRepository repository) {
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefClientcategory")
    @GetMapping(value={"/clientcategories"})
    public List<RefClientcategory> getAll() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefClientcategory \u043f\u043e ID")
    @GetMapping(value={"/clientcategories/{id}"})
    public RefClientcategory getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id) {
        Optional refClientcategory = this.repository.findById((Object)id);
        return refClientcategory.orElse(null);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefClientcategory \u043f\u043e ID")
    @DeleteMapping(value={"/clientcategories/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id) {
        Optional oRefClientCategory = this.repository.findById((Object)id);
        if (oRefClientCategory.isPresent()) {
            this.repository.deleteById((Object)id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 RefClientcategory \u043f\u043e ID")
    @PutMapping(value={"/templates/{id}"})
    public ResponseEntity<RefClientcategory> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Integer id, @RequestBody RefClientcategory refClientcategory) {
        Optional oRefClientcategory = this.repository.findById((Object)id);
        if (oRefClientcategory.isPresent()) {
            RefClientcategory refClientcategoryUpd = refClientcategory;
            refClientcategoryUpd.setId(id);
            return ResponseEntity.ok((Object)((RefClientcategory)this.repository.save((Object)refClientcategoryUpd)));
        }
        return ResponseEntity.notFound().build();
    }
}

