/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.OperatorDto;
import ru.asw.telegrammodule.entity.Operator;
import ru.asw.telegrammodule.repository.OperatorRepository;
import ru.asw.telegrammodule.repository.RoleRepository;

@RestController
@RequestMapping(value={"/operators"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="operators")
public class OperatorController {
    private ModelMapper modelMapper;
    private final RoleRepository roleRepository;
    private final OperatorRepository operatorRepository;

    public OperatorController(ModelMapper modelMapper, RoleRepository roleRepository, OperatorRepository operatorRepository) {
        this.modelMapper = modelMapper;
        this.roleRepository = roleRepository;
        this.operatorRepository = operatorRepository;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043f\u043e \u041b\u043e\u0433\u0438\u043d\u0443")
    @GetMapping(value={"/byLogin"})
    public ResponseEntity<Operator> findByLogin(@RequestParam(value="login") String login) {
        return ResponseEntity.ok((Object)this.operatorRepository.findUserByLogin(login));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u0435\u0441\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432")
    @GetMapping
    public ResponseEntity<List<Operator>> findAll() {
        return ResponseEntity.ok((Object)this.operatorRepository.findAll());
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 Operator")
    @PostMapping(value={"/"})
    public ResponseEntity<Operator> save(@RequestBody OperatorDto dto) {
        Operator operator = this.convertFromDto(dto);
        operator.setUserRole(this.roleRepository.findByNameContaining(dto.getUserRole()));
        operator.setCreated(new Date());
        return ResponseEntity.ok((Object)((Operator)this.operatorRepository.save((Object)operator)));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 Operator \u043f\u043e ID")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Operator> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody OperatorDto dto) {
        if (!Objects.equals(id, dto.getId())) {
            throw new IllegalArgumentException("IDs don't match");
        }
        Optional oOperator = this.operatorRepository.findById((Object)id);
        if (oOperator.isPresent()) {
            Operator operator = this.convertFromDto(dto);
            operator.setChanged(new Date());
            return ResponseEntity.ok((Object)((Operator)this.operatorRepository.save((Object)operator)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 Operator \u043f\u043e ID")
    @PutMapping(value={"/{id}/password"})
    public ResponseEntity<Operator> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestParam(value="password") String password) {
        Optional oOperator = this.operatorRepository.findById((Object)id);
        if (oOperator.isPresent()) {
            Operator operator = (Operator)oOperator.get();
            operator.setPassword(password);
            operator.setChanged(new Date());
            return ResponseEntity.ok((Object)((Operator)this.operatorRepository.save((Object)operator)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 Operator \u043f\u043e \u041b\u043e\u0433\u0438\u043d\u0443")
    @PutMapping(value={"/password"})
    public ResponseEntity<Operator> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @RequestParam(value="login") String login, @RequestParam(value="password") String password) {
        Optional<Operator> oOperator = Optional.ofNullable(this.operatorRepository.findUserByLogin(login));
        if (oOperator.isPresent()) {
            Operator operator = oOperator.get();
            operator.setPassword(password);
            operator.setChanged(new Date());
            return ResponseEntity.ok((Object)((Operator)this.operatorRepository.save((Object)operator)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 Operator \u043f\u043e ID")
    @PutMapping(value={"/{id}/recovery"})
    public ResponseEntity<Operator> recoveryById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oOperator = this.operatorRepository.findById((Object)id);
        if (oOperator.isPresent()) {
            Operator operator = (Operator)oOperator.get();
            operator.setChanged(new Date());
            operator.setClosed(null);
            return ResponseEntity.ok((Object)((Operator)this.operatorRepository.save((Object)operator)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 Operator \u043f\u043e ID")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oOperator = this.operatorRepository.findById((Object)id);
        if (oOperator.isPresent()) {
            Operator operator = (Operator)oOperator.get();
            operator.setClosed(new Date());
            this.operatorRepository.save((Object)operator);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    private Operator convertFromDto(OperatorDto dto) {
        this.modelMapper.getConfiguration().setSkipNullEnabled(true).setMatchingStrategy(MatchingStrategies.STRICT);
        Operator operator = (Operator)this.modelMapper.map((Object)dto, Operator.class);
        if (dto.getId() != null) {
            Operator old = (Operator)this.operatorRepository.findById((Object)dto.getId()).get();
            operator.setChanged(old.getChanged());
            operator.setClosed(old.getClosed());
            operator.setCreated(old.getCreated());
            if (dto.getPassword() == null) {
                operator.setPassword(old.getPassword());
            }
            if (dto.getUserRole() == null) {
                operator.setUserRole(old.getUserRole());
            } else {
                operator.setUserRole(this.roleRepository.findByNameContaining(dto.getUserRole()));
            }
        }
        return operator;
    }
}

