/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.entity.coretlx.MsgTemplate;
import ru.asw.telegrammodule.repository.MsgTemplateRepository;

@RestController
@RequestMapping(value={"/msg"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="template")
public class MsgTemplateController {
    private MsgTemplateRepository repository;

    public MsgTemplateController(MsgTemplateRepository repository) {
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 MsgTemplate")
    @GetMapping(value={"/templates"})
    public List<MsgTemplate> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 MsgTemplate")
    @GetMapping(value={"/templates/adm"})
    public List<MsgTemplate> getAllForAdmin() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 MsgTemplate \u043f\u043e ID")
    @GetMapping(value={"/templates/{id}"})
    public MsgTemplate getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional msgTemplate = this.repository.findById((Object)id);
        return msgTemplate.orElse(null);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 MsgTemplate \u043f\u043e ID")
    @DeleteMapping(value={"/templates/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oMsgTemplate = this.repository.findById((Object)id);
        if (oMsgTemplate.isPresent()) {
            MsgTemplate msgTemplate = (MsgTemplate)oMsgTemplate.get();
            msgTemplate.setClosed(new Date());
            this.repository.save((Object)msgTemplate);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 MsgTemplate \u043f\u043e ID")
    @PutMapping(value={"/templates/{id}"})
    public ResponseEntity<MsgTemplate> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody MsgTemplate msgTemplate) {
        Optional oMsgTemplate = this.repository.findById((Object)id);
        if (oMsgTemplate.isPresent()) {
            MsgTemplate msgTemplateUpd = msgTemplate;
            msgTemplateUpd.setId(id);
            msgTemplateUpd.setChanged(new Date());
            return ResponseEntity.ok((Object)((MsgTemplate)this.repository.save((Object)msgTemplateUpd)));
        }
        return ResponseEntity.notFound().build();
    }
}

