/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.beans.CurrentCall;
import ru.asw.telegrammodule.dto.MessagesDto;
import ru.asw.telegrammodule.dto.UpdateMsgMessageDto;
import ru.asw.telegrammodule.entity.coretlx.MsgChunk;
import ru.asw.telegrammodule.entity.coretlx.MsgMessage;
import ru.asw.telegrammodule.entity.coretlx.VocMsgState;
import ru.asw.telegrammodule.enums.MessageState;
import ru.asw.telegrammodule.repository.MsgChunkRepository;
import ru.asw.telegrammodule.repository.MsgMessageRepository;
import ru.asw.telegrammodule.repository.VocMsgStateRepository;
import ru.asw.telegrammodule.service.MessageService;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="Messages")
public class MessageController {
    static final Integer PAGE_SIZE = 20;
    static final Integer PAGE_NUMBER = 0;
    @Autowired
    private MsgMessageRepository msgMessageRepository;
    @Autowired
    private MsgChunkRepository msgChunkRepository;
    @Autowired
    private VocMsgStateRepository vocMsgStateRepository;
    @Autowired
    private MessageService messageService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private CurrentCall currentCall;
    private ModelMapper modelMapper;

    public MessageController(ModelMapper modelMapper) {
        this.modelMapper = modelMapper;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c (OPER_ARCHIVE_PKG.MSGSTATE_SEL)")
    @GetMapping(value={"/states"})
    public ResponseEntity<List<VocMsgState>> getStates() {
        return ResponseEntity.ok((Object)this.vocMsgStateRepository.findAllByArchive(true));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c (OPER_ARCHIVE_PKG.ARCHIVE_SEL)")
    @GetMapping(value={"/messages"})
    public ResponseEntity<MessagesDto> getMessages(@Parameter(description="\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (0 - \u043f\u0435\u0440\u0432\u0430\u044f)") @RequestParam(value="page", defaultValue="0", required=false) Integer pageNumber, @Parameter(description="\u0420\u0430\u0437\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b") @RequestParam(value="size", defaultValue="20", required=false) Integer size, @Parameter(description="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 (yyyy.MM.dd)") @RequestParam(value="dateFrom", required=false) @DateTimeFormat(pattern="yyyy.MM.dd") Date dateFrom, @Parameter(description="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 (yyyy.MM.dd)") @RequestParam(value="dateTo", required=false) @DateTimeFormat(pattern="yyyy.MM.dd") Date dateTo, @Parameter(description="ID \u0422\u0430\u0440\u0438\u0444\u0430") @RequestParam(value="tariffId", required=false) Integer tariffId, @Parameter(description="ID \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f") @RequestParam(value="stateId", required=false) Integer stateId, @Parameter(description="ID \u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430") @RequestParam(value="operatorId", required=false) Long operatorId, @Parameter(description="\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043e\u043f\u043b\u0430\u0442\u044b") @RequestParam(value="payPhone", required=false) String payPhone, @Parameter(description="ID \u043c\u0435\u0441\u0442\u0430 \u043f\u0440\u0438\u0435\u043c\u0430") @RequestParam(value="receiveId", required=false) Long receiveId, @Parameter(description="ID \u043e\u0442\u0434\u0435\u043b\u0435\u043d\u0438\u044f (\u043f\u043e\u0447\u0442\u0430)") @RequestParam(value="fgPlaceId", required=false) Long fgPlaceId, @Parameter(description="ID \u0440\u0435\u0433\u0438\u043e\u043d\u0430") @RequestParam(value="regionId", required=false) Integer regionId, @Parameter(description="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0430\u0432\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430") @RequestParam(value="isAdvance", required=false) Boolean isAdvance) {
        return ResponseEntity.ok((Object)this.messageService.getMessagesByParams(pageNumber, size, operatorId, dateFrom, dateTo, tariffId, stateId, regionId, payPhone, fgPlaceId, receiveId, isAdvance));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c (OPER_QUEUE_PKG.QUEUE_SEL)")
    @GetMapping(value={"/messages/queue"})
    public ResponseEntity<MessagesDto> getMessagesQueue() {
        return ResponseEntity.ok((Object)this.messageService.getMessagesByParams(PAGE_NUMBER, PAGE_SIZE, this.operatorService.getOperatorId(), null, null, null, Integer.valueOf(MessageState.MSG_STATE_EDIT.getValue()), null));
    }

    @Operation(summary="\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c (OPER_QUEUE_PKG.QUEUE_SEND)")
    @GetMapping(value={"/messages/queue/send"})
    public void sendMessagesQueue() {
        this.messageService.sendQueue();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c (OPER_PAYMENT_PKG.QUEUE_SEL)")
    @GetMapping(value={"/messages/payment/queue"})
    public ResponseEntity<MessagesDto> getMessagesQueue(@Parameter(description="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 (yyyy.MM.dd)") @RequestParam(value="dateFrom", required=false) @DateTimeFormat(pattern="yyyy.MM.dd") Date dateFrom, @Parameter(description="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 (yyyy.MM.dd)") @RequestParam(value="dateTo", required=false) @DateTimeFormat(pattern="yyyy.MM.dd") Date dateTo, @Parameter(description="ID \u0420\u0435\u0433\u0438\u043e\u043d\u0430") @RequestParam(value="regionId", required=false) Integer regionId) {
        return ResponseEntity.ok((Object)this.messageService.getMessagesByParams(PAGE_NUMBER, PAGE_SIZE, null, dateFrom, dateTo, null, Integer.valueOf(MessageState.MSG_STATE_PAYMENT.getValue()), regionId));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u044b \u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u0445 (OPER_PAYMENT_PKG.MESSAGE_DROP)")
    @DeleteMapping(value={"/messages/payment/{messageId}/drop"})
    public void dropPaymentMessage(@PathVariable(value="messageId") Long messageId) {
        this.messageService.dropPaymentMessage(messageId);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u041a\u0430\u0440\u043c\u0430\u043d \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f  (OPER_POCKET_PKG.POCKET_SEL)")
    @GetMapping(value={"/messages/pocket"})
    public ResponseEntity<MessagesDto> gePocket() {
        return ResponseEntity.ok((Object)this.messageService.getMessagesByParams(PAGE_NUMBER, PAGE_SIZE, this.operatorService.getOperatorId(), null, null, null, Integer.valueOf(MessageState.MSG_STATE_POCKET.getValue()), null));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u044b \u0432 \u043a\u0430\u0440\u043c\u0430\u043d\u0435 (OPER_POCKET_PKG.MESSAGE_DEL)")
    @DeleteMapping(value={"/messages/pocket/{messageId}/drop"})
    public void dropPocketMessage(@PathVariable(value="messageId") Long messageId) {
        this.messageService.dropMessageFromQueueByMessageId(messageId);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u0443 \u043f\u043e ID")
    @GetMapping(value={"/messages/{messageId}"})
    public ResponseEntity<MsgMessage> selectMessageById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 messageId") @PathVariable(value="messageId") Long messageId) {
        Optional msgMessageOptional = this.msgMessageRepository.findById((Object)messageId);
        return msgMessageOptional.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u0443 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u043e ID (OPER_QUEUE_PKG.DROP_MSG)")
    @DeleteMapping(value={"/messages/queue/{messageId}/drop"})
    public void dropMessageById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 messageId") @PathVariable(value="messageId") Long messageId) {
        this.messageService.dropMessageFromQueueByMessageId(messageId);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0447\u0430\u0441\u0442\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u044b \u043f\u043e Id (OPER_ARCHIVE_PKG.CHUNK_SEL)")
    @GetMapping(value={"/messages/chunks/{chunkId}"})
    public ResponseEntity<MsgChunk> selectChunksByParamsId(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 chunkId") @PathVariable(value="chunkId") Long chunkId) {
        return ResponseEntity.ok((Object)this.msgChunkRepository.getMsgChunkById(chunkId));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0438\u043f\u0443 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f (CMN_AUTH_PKG.permission_get)")
    @GetMapping(value={"/messages/permissions/{messageTypeId}"})
    public ResponseEntity<String> getPermissionsByMessageTypeId(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 messageTypeId") @PathVariable(value="messageTypeId") Integer messageTypeId) {
        return ResponseEntity.ok((Object)this.messageService.getNoPermissionsReasonByMessageTypeId(messageTypeId, this.currentCall.getCall()));
    }

    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c/\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u0443")
    @PostMapping(value={"/messages"})
    public ResponseEntity<MsgMessage> createOrUpdateMessage(@RequestBody UpdateMsgMessageDto dto) throws Exception {
        return this.messageService.updateMessage(dto);
    }

    @Operation(summary="\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c\u0443")
    @PostMapping(value={"/messages/current/save"})
    public ResponseEntity<MsgMessage> saveMessage() {
        return this.messageService.saveCurrentMessage();
    }

    @Operation(summary=" OPER_PAYMENT_PKG.message_send(:MESSAGE_ID)")
    @PostMapping(value={"/messages/payment/{messageId}/send"})
    public void sendPaymentMessage(@PathVariable(value="messageId") Long messageId) {
        this.messageService.sendPaymentMessage(messageId);
    }

    @Operation(summary="\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 FGNOTE \u043f\u043e \u0418\u0414 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f  (OPER_TELEX_PKG.SET_FGNOTE(:MESSAGE_ID, :FGNOTE))")
    @PostMapping(value={"/messages/{messageId}/fgNote"})
    public void setFgNoteMessage(@PathVariable(value="messageId") Long messageId, @RequestParam(value="fgNote") String fgNote) {
        this.messageService.setFgNoteForMessage(messageId, fgNote);
    }

    @Operation(summary="\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 FGNOTE \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f (OPER_TELEX_PKG.SET_FGNOTE(:MESSAGE_ID, :FGNOTE))")
    @PostMapping(value={"/messages/current/fgNote"})
    public void setCurrentFgNoteMessage(@RequestParam(value="fgNote") String fgNote) throws Exception {
        this.messageService.setCurrentFgNoteForMessage(fgNote);
    }
}

