/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.TownDto;
import ru.asw.telegrammodule.entity.coretlx.RefCountry;
import ru.asw.telegrammodule.entity.coretlx.RefTown;
import ru.asw.telegrammodule.entity.coretlx.VocRegion;
import ru.asw.telegrammodule.repository.RefCountryRepository;
import ru.asw.telegrammodule.repository.RefTownRepository;
import ru.asw.telegrammodule.repository.VocRegionRepository;
import ru.asw.telegrammodule.service.TownService;

@RestController
@RequestMapping(value={"/locations"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="Locations")
public class LocationsController {
    private TownService townService;
    private RefTownRepository refTownRepository;
    private RefCountryRepository refCountryRepository;
    private VocRegionRepository vocRegionRepository;

    @Operation(summary="\u041f\u043e\u0438\u0441\u043a \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c (OPER_TELEX_PKG.TOWN_NAME_SEL(:CHANGED, :TOWNS) \u0438 \u0434\u0440)")
    @GetMapping(value={"towns"})
    public ResponseEntity<List<TownDto>> findByParams(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430") @RequestParam(value="id", required=false) Long id, @Parameter(description="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430") @RequestParam(value="name", required=false) String name, @Parameter(description="\u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438") @RequestParam(value="provinceId", required=false) Long provinceId, @Parameter(description="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0439\u043e\u043d\u0430") @RequestParam(value="district", required=false) String district, @Parameter(description="\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0441. \u043f\u0443\u043d\u043a\u0442\u0430 (yyyy.MM.dd)") @RequestParam(value="changed", required=false) @DateTimeFormat(pattern="yyyy.MM.dd") Date changed) {
        return ResponseEntity.ok((Object)this.townService.findTownsByParams(id, name, provinceId, district, changed));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0418\u0414 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043f\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044e (TOWN_ID_SEL)")
    @GetMapping(value={"towns/{name}/id"})
    public ResponseEntity<Long> getTownId(@Parameter(description="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430") @PathVariable(value="name") String name) {
        List towns;
        try {
            towns = this.refTownRepository.findByNameIsContainingIgnoreCaseAndClosedIsNullOrClosedAfter(name, new Date());
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
        if (towns == null || towns.size() != 1) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)((RefTown)towns.get(0)).getId());
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043f\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044e \u043f\u043e \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0435 \u043f\u043e\u0438\u0441\u043a\u0430 (OPER_TELEX_PKG.town_ident_sel)")
    @GetMapping(value={"/towns/{name}/{provinceId}"})
    public ResponseEntity<List<RefTown>> getTownByName(@Parameter(description="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0441") @PathVariable(value="name") String name, @Parameter(description="\u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438 (provinceId)") @PathVariable(value="provinceId", required=false) Long provinceId) {
        List towns;
        try {
            towns = this.refTownRepository.findByNameIsStartingWithIgnoreCaseAndClosedIsNullOrClosedAfter(name, Date.from(LocalDateTime.now(ZoneOffset.MIN).atZone(ZoneId.systemDefault()).toInstant()));
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)towns);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u043e \u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438 ")
    @GetMapping(value={"/towns/{provinceId}"})
    public ResponseEntity<List<RefTown>> getTownsByProvinceId(@Parameter(description="\u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438") @PathVariable(value="provinceId") Long provinceId) {
        return ResponseEntity.ok((Object)this.refTownRepository.findByProvinceId(provinceId));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0438 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044e \u0440\u0430\u0439\u043e\u043d\u0430")
    @GetMapping(value={"/towns/{provinceId}/{districtName}"})
    public ResponseEntity<List<RefTown>> getTownsByDistrictName(@Parameter(description="\u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438") @PathVariable(value="provinceId") Long provinceId, @Parameter(description="\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0420\u0430\u0439\u043e\u043d\u0430") @PathVariable(value="districtName") String districtName) {
        return ResponseEntity.ok((Object)this.refTownRepository.findByDistrictAndProvinceId(districtName, provinceId));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 (OPER_PAYMENT_PKG.REGION_SEL)")
    @GetMapping(value={"/regions"})
    public ResponseEntity<List<VocRegion>> getVocRegion() {
        return ResponseEntity.ok((Object)this.vocRegionRepository.findAll());
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0418\u0414 \u0440\u0435\u0433\u0438\u043e\u043d\u0430 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 (OPER_PAYMENT_PKG.REGION_BY_PHONE)")
    @GetMapping(value={"/regions/byPhone"})
    public ResponseEntity<Long> getIdVocRegionByAonPhone(@RequestParam(value="phone") String phone) {
        Optional regionOptional = this.vocRegionRepository.findByAbcCode(phone);
        return regionOptional.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0442\u0440\u0430\u043d")
    @GetMapping(value={"/countries"})
    public ResponseEntity<List<RefCountry>> getCountries() {
        return ResponseEntity.ok((Object)this.refCountryRepository.findByClosedIsNullOrClosedAfterOrderByName(new Date()));
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0439\u043e\u043d\u043e\u0432 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 (OPER_PAYMENT_PKG.REGION_SEL)")
    @GetMapping(value={"/provinces/{provinceId}/districts"})
    public ResponseEntity<List<String>> getDistricts(@Parameter(description="\u0418\u0414 \u041e\u0431\u043b\u0430\u0441\u0442\u0438") @PathVariable(value="provinceId") Long provinceId) {
        return ResponseEntity.ok((Object)this.refTownRepository.findDistinctByDistrictAndDistrictIsNotNull(provinceId));
    }

    public LocationsController(TownService townService, RefTownRepository refTownRepository, RefCountryRepository refCountryRepository, VocRegionRepository vocRegionRepository) {
        this.townService = townService;
        this.refTownRepository = refTownRepository;
        this.refCountryRepository = refCountryRepository;
        this.vocRegionRepository = vocRegionRepository;
    }
}

