/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.beans.CurrentCall;
import ru.asw.telegrammodule.dto.CallRequestDto;
import ru.asw.telegrammodule.dto.CreateCallRequestDto;
import ru.asw.telegrammodule.dto.CreateFgCallRequestDto;
import ru.asw.telegrammodule.dto.ResponseCallDto;
import ru.asw.telegrammodule.service.CallService;

@RestController
@RequestMapping(value={"/calls"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="Calls")
public class CallController {
    private static Logger logger = LoggerFactory.getLogger((String)CallController.class.getName());
    @Autowired
    @Qualifier(value="currentCall")
    private CurrentCall currentCall;
    @Autowired
    private CallService callService;
    @Autowired
    private ModelMapper modelMapper;

    @Operation(summary="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430")
    @ResponseBody
    @PostMapping(value={"/create"}, produces={"application/json"})
    public ResponseEntity<ResponseCallDto> saveCall(@RequestBody CreateCallRequestDto callDto) {
        CallRequestDto callRequestDto = (CallRequestDto)this.modelMapper.map((Object)callDto, CallRequestDto.class);
        if (this.currentCall.getCall() != null) {
            logger.info("The Call is already active, drop current call and try again ...");
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
        }
        this.currentCall.setCall(this.callService.createCall(callRequestDto, false));
        return ResponseEntity.ok((Object)this.currentCall.getCall());
    }

    @Operation(summary="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430")
    @ResponseBody
    @PostMapping(value={"/fg/create"}, produces={"application/json"})
    public ResponseEntity<ResponseCallDto> saveFgCall(@RequestBody CreateFgCallRequestDto callDto) {
        CallRequestDto callRequestDto = (CallRequestDto)this.modelMapper.map((Object)callDto, CallRequestDto.class);
        if (this.currentCall.getCall() != null) {
            logger.info("The FgCall is already active, drop current call and try again ...");
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
        }
        this.currentCall.setCall(this.callService.createCall(callRequestDto, true));
        return ResponseEntity.ok((Object)this.currentCall.getCall());
    }

    @Operation(summary="\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430")
    @ResponseBody
    @PutMapping(value={"/complete"}, produces={"application/json"})
    public ResponseEntity dropCall() {
        ResponseEntity re = this.callService.dropCall(this.currentCall.getCall());
        this.currentCall.setCall(null);
        return re;
    }
}

