/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.CreateBillTlgkindDto;
import ru.asw.telegrammodule.entity.coretlx.BillTlgkind;
import ru.asw.telegrammodule.repository.BillTlgkindRepository;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/bill"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="tlgkind")
public class BillTlgkindController {
    private ModelMapper modelMapper;
    private OperatorService operatorService;
    private BillTlgkindRepository repository;

    public BillTlgkindController(ModelMapper modelMapper, OperatorService operatorService, BillTlgkindRepository repository) {
        this.modelMapper = modelMapper;
        this.operatorService = operatorService;
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillTlgkind")
    @GetMapping(value={"/tlgkinds"})
    public List<BillTlgkind> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillTlgkind")
    @GetMapping(value={"/tlgkinds/adm"})
    public List<BillTlgkind> getAllForAdmin() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillTlgkind \u043f\u043e ID")
    @GetMapping(value={"/tlgkinds/{id}"})
    public BillTlgkind getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional billTlgkind = this.repository.findById((Object)id);
        return billTlgkind.orElse(null);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillTlgckind \u043f\u043e ID")
    @DeleteMapping(value={"/tlgkinds/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oBillTlgkind = this.repository.findById((Object)id);
        if (oBillTlgkind.isPresent()) {
            BillTlgkind billTlgkind = (BillTlgkind)oBillTlgkind.get();
            billTlgkind.setClosed(new Date());
            this.repository.save((Object)billTlgkind);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillTlgkind \u043f\u043e ID")
    @PutMapping(value={"/tlgkinds/{id}"})
    public ResponseEntity<BillTlgkind> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody BillTlgkind tlgkind) {
        Optional oBillTlgkind = this.repository.findById((Object)id);
        if (oBillTlgkind.isPresent()) {
            BillTlgkind billTlgkind = tlgkind;
            billTlgkind.setId(id);
            billTlgkind.setChanged(new Date());
            return ResponseEntity.ok((Object)((BillTlgkind)this.repository.save((Object)billTlgkind)));
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 BillTlgkind")
    @PostMapping(value={"/billTlgkind"})
    public ResponseEntity<BillTlgkind> save(@RequestBody CreateBillTlgkindDto dto) {
        BillTlgkind billTlgkind = this.convertFromDto(dto);
        billTlgkind.setCreated(new Date());
        billTlgkind.setChanged(new Date());
        billTlgkind.setOperatorId(this.operatorService.getOperatorId());
        return ResponseEntity.ok((Object)((BillTlgkind)this.repository.save((Object)billTlgkind)));
    }

    private BillTlgkind convertFromDto(CreateBillTlgkindDto dto) {
        BillTlgkind billTlgkind = (BillTlgkind)this.modelMapper.map((Object)dto, BillTlgkind.class);
        return billTlgkind;
    }
}

