/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.RequestBillTariffDto;
import ru.asw.telegrammodule.entity.coretlx.BillTariff;
import ru.asw.telegrammodule.entity.coretlx.RefCountry;
import ru.asw.telegrammodule.entity.coretlx.RefLocation;
import ru.asw.telegrammodule.entity.coretlx.RefProvince;
import ru.asw.telegrammodule.entity.coretlx.RefTown;
import ru.asw.telegrammodule.entity.coretlx.location.province.RefLocationPlaceProvince;
import ru.asw.telegrammodule.entity.coretlx.location.town.RefLocationPlaceTown;
import ru.asw.telegrammodule.repository.BillTariffRepository;
import ru.asw.telegrammodule.repository.RefCountryRepository;
import ru.asw.telegrammodule.repository.RefLocationRepository;
import ru.asw.telegrammodule.repository.RefProvinceRepository;
import ru.asw.telegrammodule.repository.RefTownRepository;

@RestController
@RequestMapping(value={"/"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="Tariffs")
public class BillTariffController {
    @Autowired
    private RefLocationRepository refLocationRepository;
    @Autowired
    private RefProvinceRepository refProvinceRepository;
    @Autowired
    private RefCountryRepository refCountryRepository;
    @Autowired
    private BillTariffRepository billTariffRepository;
    @Autowired
    private RefTownRepository refTownRepository;
    @Autowired
    private ModelMapper modelMapper;

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u0430\u0440\u0438\u0444\u043e\u0432 (OPER_ARCHIVE_PKG.TARIF_SEL)")
    @GetMapping(value={"/tariffs"})
    public ResponseEntity<List<BillTariff>> getAll() {
        return ResponseEntity.ok((Object)this.billTariffRepository.findAll());
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444 \u043f\u043e Id \u0433\u043e\u0440\u043e\u0434\u0430 (tarif_get)")
    @GetMapping(value={"/tariffs/towns/{townId}"})
    public ResponseEntity<RequestBillTariffDto> getBillTariffByTownId(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0433\u043e\u0440\u043e\u0434\u0430") @PathVariable(value="townId") Long townId) {
        Optional oRefTown = this.refTownRepository.findById((Object)townId);
        BillTariff tariff = null;
        if (oRefTown.isPresent()) {
            Optional oCountry;
            Optional refLocationPlace;
            Optional province;
            Optional location;
            RefTown refTown = (RefTown)oRefTown.get();
            Optional locationPlace = refTown.getRefLocationPlaces().stream().findFirst();
            if (locationPlace.isPresent() && (location = this.refLocationRepository.findById((Object)((RefLocationPlaceTown)locationPlace.get()).getLocationId())).isPresent()) {
                tariff = ((RefLocation)location.get()).getTarif();
            }
            if (tariff == null && (province = this.refProvinceRepository.findById((Object)refTown.getProvince().getId())).isPresent() && (refLocationPlace = ((RefProvince)province.get()).getRefLocationPlaces().stream().findFirst()).isPresent() && (location = this.refLocationRepository.findById((Object)((RefLocationPlaceProvince)refLocationPlace.get()).getLocationId())).isPresent()) {
                tariff = ((RefLocation)location.get()).getTarif();
            }
            if (tariff == null && (oCountry = this.refCountryRepository.findById((Object)refTown.getProvince().getCountry().getId())).isPresent() && (location = this.refLocationRepository.findById((Object)((RefCountry)oCountry.get()).getRefLocationPlaces().stream().filter(i -> i.getProvinceId() == null & i.getTownId() == null).findFirst().get().getLocationId())).isPresent()) {
                tariff = ((RefLocation)location.get()).getTarif();
            }
            if (tariff != null) {
                RequestBillTariffDto dto = this.convertToDto(tariff);
                dto.setTelexHi(((RefTown)oRefTown.get()).getTelexHi());
                dto.setTelexLo(((RefTown)oRefTown.get()).getTelexLo());
                return ResponseEntity.ok((Object)dto);
            }
        }
        return ResponseEntity.notFound().build();
    }

    private RequestBillTariffDto convertToDto(BillTariff tariff) {
        this.modelMapper.getConfiguration().setSkipNullEnabled(true).setMatchingStrategy(MatchingStrategies.STRICT);
        RequestBillTariffDto dto = (RequestBillTariffDto)this.modelMapper.map((Object)tariff, RequestBillTariffDto.class);
        return dto;
    }
}

