/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.CreateBillSvckindDto;
import ru.asw.telegrammodule.entity.coretlx.BillSvckind;
import ru.asw.telegrammodule.entity.coretlx.BillTlgkind;
import ru.asw.telegrammodule.repository.BillSvckindRepository;
import ru.asw.telegrammodule.repository.BillTariffRepository;
import ru.asw.telegrammodule.repository.BillTlgkindRepository;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/bill"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="svckind")
public class BillSvckindController {
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private BillTariffRepository tariffRepository;
    @Autowired
    private BillTlgkindRepository tlgkindRepository;
    private BillSvckindRepository repository;

    public BillSvckindController(BillSvckindRepository repository) {
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind")
    @GetMapping(value={"/svckinds"})
    public List<BillSvckind> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind")
    @GetMapping(value={"/svckinds/adm"})
    public List<BillSvckind> getAllForAdmin() {
        return this.repository.findAll();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind \u043f\u043e ID")
    @GetMapping(value={"/svckinds/{id}"})
    public BillSvckind getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional billSvckind = this.repository.findById((Object)id);
        return billSvckind.orElse(null);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind \u043f\u043e TariffID, \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 (OPER_TELEX_PKG.KINDREQ_VOC)")
    @GetMapping(value={"/svckinds/tariff/{id}/required"})
    public List<BillSvckind> getByTariffIdRequired(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        List billSvckinds = this.repository.findAllByTarif_IdAndRequiredIsTrue(id);
        return billSvckinds;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind \u043f\u043e TariffID, \u043d\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 (OPER_TELEX_PKG.KINDOPT_VOC)")
    @GetMapping(value={"/svckinds/tariff/{id}/optional"})
    public List<BillSvckind> getByTariffIdOptional(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        List billSvckinds = this.repository.findAllByTarif_IdAndRequiredIsFalse(id);
        return billSvckinds;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 BillSvckind")
    @PostMapping(value={"/svckinds"})
    public ResponseEntity<BillSvckind> save(@RequestBody CreateBillSvckindDto dto) {
        BillSvckind billSvckind = this.fillBillSvckind(new BillSvckind(), dto, false);
        return ResponseEntity.ok((Object)((BillSvckind)this.repository.save((Object)billSvckind)));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind \u043f\u043e ID")
    @DeleteMapping(value={"/svckinds/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oBillSvckind = this.repository.findById((Object)id);
        if (oBillSvckind.isPresent()) {
            BillSvckind billSvckind = (BillSvckind)oBillSvckind.get();
            billSvckind.setClosed(new Date());
            this.repository.save((Object)billSvckind);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillSvckind \u043f\u043e ID")
    @PutMapping(value={"/svckinds/{id}"})
    public ResponseEntity<BillSvckind> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody CreateBillSvckindDto dto) {
        Optional oBillSvckind = this.repository.findById((Object)id);
        if (oBillSvckind.isPresent()) {
            BillSvckind billSvckind = this.fillBillSvckind((BillSvckind)oBillSvckind.get(), dto, true);
            return ResponseEntity.ok((Object)((BillSvckind)this.repository.save((Object)billSvckind)));
        }
        return ResponseEntity.notFound().build();
    }

    private BillSvckind fillBillSvckind(BillSvckind billSvckind, CreateBillSvckindDto dto, boolean isChanging) {
        billSvckind.setName(dto.getName());
        billSvckind.setRequired(dto.getRequired());
        billSvckind.setEndLabel(dto.getEndLabel());
        billSvckind.setStartLabel(dto.getStartLabel());
        billSvckind.setCreated(new Date());
        billSvckind.setP1(dto.getP1());
        billSvckind.setP2(dto.getP2());
        billSvckind.setP3(dto.getP3());
        billSvckind.setFNeedtg(dto.getFneedtg());
        billSvckind.setFNotification(dto.getFnotification());
        billSvckind.setFPrintcopy(dto.getFprintcopy());
        billSvckind.setFServe(dto.getFserve());
        billSvckind.setFSecond(dto.getFsecond());
        billSvckind.setFNeedrequest(dto.getFneedrequest());
        billSvckind.setTarif(this.tariffRepository.findBillTariffById(dto.getTarifId()));
        billSvckind.setTlgkind((BillTlgkind)this.tlgkindRepository.findById((Object)dto.getTlgkindId()).get());
        billSvckind.setOperatorId(this.operatorService.getOperatorId());
        if (isChanging) {
            billSvckind.setChanged(new Date());
        }
        return billSvckind;
    }
}

