/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.CreateBillServiceDto;
import ru.asw.telegrammodule.entity.coretlx.BillService;
import ru.asw.telegrammodule.repository.BillServiceRepository;
import ru.asw.telegrammodule.repository.BillTariffRepository;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/bill"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="service")
public class BillServiceController {
    @Autowired
    private OperatorService operatorService;
    private BillServiceRepository repository;
    private BillTariffRepository tariffRepository;

    public BillServiceController(BillServiceRepository repository, BillTariffRepository billTariffRepository) {
        this.repository = repository;
        this.tariffRepository = billTariffRepository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillService")
    @GetMapping(value={"/services"})
    public List<BillService> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillService \u043f\u043e ID")
    @GetMapping(value={"/services/{id}"})
    public BillService getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional billService = this.repository.findById((Object)id);
        return billService.orElse(null);
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillService \u043f\u043e TariffID (OPER_TELEX_PKG.service_voc)")
    @GetMapping(value={"/services/tariff/{id}"})
    public List<BillService> getByTariffId(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        List billService = this.repository.findAllByTariff_Id(id);
        return billService;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 BillService")
    @PostMapping(value={"/services"})
    public ResponseEntity<BillService> save(@RequestBody CreateBillServiceDto dto) {
        BillService billService = new BillService();
        billService.setCreated(new Date());
        billService.setName(dto.getName());
        billService.setTariff(this.tariffRepository.findBillTariffById(dto.getTariffId()));
        billService.setStartLabel(dto.getStartLabel());
        billService.setEndLabel(dto.getEndLabel());
        billService.setOperatorId(this.operatorService.getOperatorId());
        return ResponseEntity.ok((Object)((BillService)this.repository.save((Object)billService)));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillService \u043f\u043e ID")
    @DeleteMapping(value={"/services/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oBillService = this.repository.findById((Object)id);
        if (oBillService.isPresent()) {
            BillService billService = (BillService)oBillService.get();
            billService.setClosed(new Date());
            this.repository.save((Object)billService);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }
}

