/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.dto.CreateBillPayPhoneRequestDto;
import ru.asw.telegrammodule.entity.coretlx.BillPayPhone;
import ru.asw.telegrammodule.repository.BillPayPhoneRepository;
import ru.asw.telegrammodule.service.OperatorService;

@RestController
@RequestMapping(value={"/bill"})
@SecurityRequirement(name="App Bearer token")
@Tag(name="payphone")
public class BillPayPhoneController {
    @Autowired
    private OperatorService operatorService;
    private BillPayPhoneRepository repository;

    public BillPayPhoneController(BillPayPhoneRepository repository) {
        this.repository = repository;
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0438\u0441\u043a\u0430 BillPayPhone")
    @GetMapping(value={"/payphones"})
    public List<BillPayPhone> getAll() {
        return this.repository.findAllByClosedIsNull();
    }

    @Operation(summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 BillPayPhone \u043f\u043e ID")
    @GetMapping(value={"/payphones/{id}"})
    public BillPayPhone getById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional billPayPhone = this.repository.findById((Object)id);
        return billPayPhone.orElse(null);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430 BillPayPhone")
    @PostMapping(value={"/payphones"})
    public ResponseEntity<BillPayPhone> save(@RequestBody CreateBillPayPhoneRequestDto dto) {
        BillPayPhone billPayPhone = new BillPayPhone();
        billPayPhone.setAonPhone(dto.getAonPhone());
        billPayPhone.setAbonentPhone(dto.getAbonentPhone());
        billPayPhone.setNote(dto.getNote());
        billPayPhone.setCreated(new Date());
        billPayPhone.setOperatorId(this.operatorService.getOperatorId());
        return ResponseEntity.ok((Object)((BillPayPhone)this.repository.save((Object)billPayPhone)));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillPayPhone \u043f\u043e ID")
    @DeleteMapping(value={"/payphones/{id}"})
    public ResponseEntity deleteById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id) {
        Optional oBillPayPhone = this.repository.findById((Object)id);
        if (oBillPayPhone.isPresent()) {
            BillPayPhone billPayPhone = (BillPayPhone)oBillPayPhone.get();
            billPayPhone.setClosed(new Date());
            this.repository.save((Object)billPayPhone);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 BillPayPhone \u043f\u043e ID")
    @PutMapping(value={"/payphones/{id}"})
    public ResponseEntity<BillPayPhone> updateById(@Parameter(description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430") @PathVariable(value="id") Long id, @RequestBody BillPayPhone payPhone) {
        Optional oBillPayPhone = this.repository.findById((Object)id);
        if (oBillPayPhone.isPresent()) {
            BillPayPhone billPayPhone = payPhone;
            billPayPhone.setId(id);
            billPayPhone.setChanged(new Date());
            return ResponseEntity.ok((Object)((BillPayPhone)this.repository.save((Object)billPayPhone)));
        }
        return ResponseEntity.notFound().build();
    }
}

