/*
 * Decompiled with CFR 0.152.
 */
package ru.asw.telegrammodule.controller;

import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import ru.asw.telegrammodule.entity.coretlx.MsgAdvert;
import ru.asw.telegrammodule.entity.coretlx.MsgAdvertDto;
import ru.asw.telegrammodule.entity.coretlx.RefDestRubric;
import ru.asw.telegrammodule.entity.coretlx.RefDestRubricRepository;
import ru.asw.telegrammodule.repository.MsgAdvertRepository;

@RestController
public class AdvertController {
    private final MsgAdvertRepository advertRepo;
    private final RefDestRubricRepository refDestRubricRepository;

    public AdvertController(MsgAdvertRepository advertRepo, RefDestRubricRepository refDestRubricRepository) {
        this.advertRepo = advertRepo;
        this.refDestRubricRepository = refDestRubricRepository;
    }

    @GetMapping(value={"/advert/{id}"})
    public ResponseEntity<MsgAdvertDto> advert(@PathVariable Long id) {
        Optional optional = this.advertRepo.findById((Object)id);
        if (optional.isPresent()) {
            MsgAdvertDto dto = MsgAdvertDto.builder().id(((MsgAdvert)optional.get()).getId()).messageUnits(((MsgAdvert)optional.get()).getMessage().getUnits()).messageId(((MsgAdvert)optional.get()).getMessage().getId()).destRubricName(((MsgAdvert)optional.get()).getDestRubric().getName()).destRubricId(((MsgAdvert)optional.get()).getDestRubric().getId()).release(((MsgAdvert)optional.get()).getRelease()).build();
            return ResponseEntity.ok((Object)dto);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    @PostMapping(value={"/advert/"})
    public ResponseEntity<MsgAdvert> release(@RequestBody MsgAdvertDto dto) {
        Optional refDestRubric = this.refDestRubricRepository.findById((Object)dto.getDestRubricId());
        Optional optional = this.advertRepo.findById((Object)dto.getId());
        if (optional.isPresent() && refDestRubric.isPresent()) {
            ((MsgAdvert)optional.get()).setRelease(dto.getRelease());
            ((MsgAdvert)optional.get()).setId(dto.getId());
            ((MsgAdvert)optional.get()).setDestRubric((RefDestRubric)refDestRubric.get());
            optional.ifPresent(arg_0 -> ((MsgAdvertRepository)this.advertRepo).save(arg_0));
            return ResponseEntity.ok((Object)((MsgAdvert)optional.get()));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }
}

